/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.Date;
import java.util.Vector;
import jv.loader.PvDisplayOption;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgMathLoader {
    protected int m_dim = 0;
    protected PdVector[] m_circle;
    protected PdVector[] m_disk;
    protected boolean m_isKeyAnimation = false;
    protected boolean m_isAnimation = false;
    protected PgJvxSrc[] m_geom;
    protected PgJvxSrc[][] m_graphics;
    protected Vector graphicsVector;
    protected int m_numGraphics = 0;
    protected PvDisplayOption m_displayOption;
    protected PdVector m_boundingBoxMin;
    protected PdVector m_boundingBoxMax;
    protected PdVector m_viewVertical;
    protected static final int COLOR_FACE_FRONT = 0;
    protected static final int COLOR_FACE_BACK = 1;
    protected static final int COLOR_FACE_FRONT_REFL = 2;
    protected static final int COLOR_FACE_BACK_REFL = 3;
    protected static final int COLOR_FACE_FRONT_NOLIGHTS = 4;
    protected static final int COLOR_FACE_BACK_NOLIGHTS = 5;
    protected static final int COLOR_ELEMENT_EDGE = 6;
    protected static final int COLOR_POINT = 7;
    protected static final int COLOR_POLYGON = 8;

    public boolean isKeyAnimation() {
        return this.m_isKeyAnimation;
    }

    public PgJvxSrc[][] read(BufferedReader bufferedReader) {
        int n;
        int n2;
        int n3;
        int n4;
        if (bufferedReader == null) {
            PsDebug.warning("missing reader");
            return null;
        }
        this.graphicsVector = new Vector();
        try {
            n4 = this.parseMath(bufferedReader);
            if (n4 == 0) {
                PsDebug.warning("error during parsing of reader");
                return null;
            }
            if (this.m_numGraphics == 0) {
                PsDebug.warning("missing graphics");
                return null;
            }
        }
        catch (IOException iOException) {
            PsDebug.warning("exception during parsing of reader");
            iOException.printStackTrace();
            return null;
        }
        this.m_graphics = new PgJvxSrc[this.m_numGraphics][];
        n4 = 0;
        while (n4 < this.m_numGraphics) {
            this.m_graphics[n4] = (PgJvxSrc[])this.graphicsVector.elementAt(n4);
            ++n4;
        }
        this.m_boundingBoxMin = new PdVector(3);
        this.m_boundingBoxMax = new PdVector(3);
        PdVector pdVector = this.m_graphics[0][0].getVertex(0);
        if (pdVector.getSize() != 3) {
            this.m_boundingBoxMin.setConstant(0.0);
            this.m_boundingBoxMax.setConstant(0.0);
        } else {
            this.m_boundingBoxMin.copy(pdVector);
            this.m_boundingBoxMax.copy(pdVector);
        }
        this.m_dim = 0;
        int n5 = 0;
        while (n5 < this.m_numGraphics) {
            n3 = this.m_graphics[n5].length;
            int n6 = 0;
            while (n6 < n3) {
                PdVector[] pdVectorArray = this.m_graphics[n5][n6].getVertices();
                n2 = this.m_graphics[n5][n6].getNumVertices();
                n = this.m_graphics[n5][n6].getDimOfVertices();
                if (n > this.m_dim) {
                    this.m_dim = n;
                }
                int n7 = 0;
                while (n7 < n2) {
                    if (pdVectorArray[n7].m_data[0] < this.m_boundingBoxMin.m_data[0]) {
                        this.m_boundingBoxMin.m_data[0] = pdVectorArray[n7].m_data[0];
                    }
                    if (pdVectorArray[n7].m_data[0] > this.m_boundingBoxMax.m_data[0]) {
                        this.m_boundingBoxMax.m_data[0] = pdVectorArray[n7].m_data[0];
                    }
                    if (n > 1) {
                        if (pdVectorArray[n7].m_data[1] < this.m_boundingBoxMin.m_data[1]) {
                            this.m_boundingBoxMin.m_data[1] = pdVectorArray[n7].m_data[1];
                        }
                        if (pdVectorArray[n7].m_data[1] > this.m_boundingBoxMax.m_data[1]) {
                            this.m_boundingBoxMax.m_data[1] = pdVectorArray[n7].m_data[1];
                        }
                    }
                    if (n > 2) {
                        if (pdVectorArray[n7].m_data[2] < this.m_boundingBoxMin.m_data[2]) {
                            this.m_boundingBoxMin.m_data[2] = pdVectorArray[n7].m_data[2];
                        }
                        if (pdVectorArray[n7].m_data[2] > this.m_boundingBoxMax.m_data[2]) {
                            this.m_boundingBoxMax.m_data[2] = pdVectorArray[n7].m_data[2];
                        }
                    }
                    ++n7;
                }
                ++n6;
            }
            ++n5;
        }
        if (this.m_dim == 3) {
            this.adjustViewer();
        } else {
            this.m_displayOption.setCameraProjection(0, 1);
            PdVector pdVector2 = new PdVector((this.m_boundingBoxMin.m_data[0] + this.m_boundingBoxMax.m_data[0]) / 2.0, (this.m_boundingBoxMin.m_data[1] + this.m_boundingBoxMax.m_data[1]) / 2.0, 0.0);
            this.m_displayOption.setCameraInterest(0, pdVector2);
            PdVector pdVector3 = PdVector.subNew(this.m_boundingBoxMax, this.m_boundingBoxMin);
            double d = pdVector3.max();
            pdVector2 = new PdVector((this.m_boundingBoxMax.m_data[0] + this.m_boundingBoxMin.m_data[0]) / 2.0, (this.m_boundingBoxMax.m_data[1] + this.m_boundingBoxMin.m_data[1]) / 2.0, d);
            this.m_displayOption.setCameraPosition(0, pdVector2);
            this.m_displayOption.setCameraRoll(0, 0.0);
            this.m_displayOption.setCurrentCamera(1);
            this.m_displayOption.clearTag(8);
        }
        int n8 = 0;
        n3 = 0;
        while (n3 < this.m_numGraphics) {
            int n9 = this.m_graphics[n3].length;
            int n10 = 0;
            while (n10 < n9) {
                ++n8;
                PgJvxSrc pgJvxSrc = this.m_graphics[n3][n10];
                if (pgJvxSrc.getType() == 33 && pgJvxSrc.getDimOfVertices() == 3) {
                    this.computeMathematicaColors(pgJvxSrc);
                }
                ++n10;
            }
            ++n3;
        }
        if (!this.isAnimation() && !this.isKeyAnimation() && this.m_graphics.length > 1) {
            PgJvxSrc[][] pgJvxSrcArrayArray = new PgJvxSrc[][]{new PgJvxSrc[n8]};
            int n11 = 0;
            int n12 = 0;
            while (n12 < this.m_numGraphics) {
                n2 = this.m_graphics[n12].length;
                n = 0;
                while (n < n2) {
                    pgJvxSrcArrayArray[0][n11] = this.m_graphics[n12][n];
                    ++n11;
                    ++n;
                }
                ++n12;
            }
            this.m_graphics = pgJvxSrcArrayArray;
        }
        return this.m_graphics;
    }

    public void setAnimation(boolean bl) {
        this.m_isAnimation = bl;
    }

    public PvDisplayOption getDisplayOption() {
        return this.m_displayOption;
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) throws IOException {
        String string;
        int n;
        int n2;
        int n3;
        PiVector[] piVectorArray;
        int n4;
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null) {
            PsDebug.warning("missing geometry");
            return false;
        }
        PgJvxSrc pgJvxSrc = pgJvxSrcArray[0];
        writer.write("(* Produced with JavaView v." + PsConfig.getVersion() + " by " + PsConfig.getAuthors() + "\n");
        writer.write("     File Format = Mathematica Graphics MGS\n");
        writer.write("     Geometry    = " + pgJvxSrc.getName() + "\n");
        writer.write("     Date        = " + new Date().toString() + "\n//\n");
        int n5 = pgJvxSrc.getNumVertices();
        writer.write("     Number of Vertices = " + n5 + "\n");
        int n6 = pgJvxSrc.getNumElements();
        if (n6 > 0) {
            writer.write("     Number of Elements = " + n6 + "\n");
        }
        if ((n4 = pgJvxSrc.getNumPolygons()) > 0) {
            writer.write("     Number of Polygons = " + n4 + "\n");
        }
        writer.write("\n End of Header *)\n");
        writer.write("Graphics3D[{");
        PdVector[] pdVectorArray = pgJvxSrc.getVertices();
        String string2 = null;
        Color[] colorArray = null;
        boolean bl = false;
        if (n4 > 0) {
            bl = true;
            if (!pgJvxSrc.isShowingPolygonColors()) {
                string2 = PgMathLoader.writeColor(pgJvxSrc.getGlobalPolygonColor());
                writer.write(string2 + ",");
            } else {
                colorArray = pgJvxSrc.getPolygonColors();
            }
            piVectorArray = pgJvxSrc.getPolygons();
            n3 = 0;
            while (n3 < n4) {
                if (pgJvxSrc.isShowingPolygonColors()) {
                    string2 = PgMathLoader.writeColor(colorArray[n3]);
                    writer.write("{" + string2 + ",");
                }
                writer.write("Line[{");
                n2 = piVectorArray[n3].getSize();
                n = 0;
                while (n < n2) {
                    if (n > 0) {
                        writer.write(", ");
                    }
                    string = PgMathLoader.writeVertex(pdVectorArray[piVectorArray[n3].m_data[n]]);
                    writer.write(string);
                    ++n;
                }
                writer.write("}]");
                if (pgJvxSrc.isShowingPolygonColors()) {
                    writer.write("}");
                }
                if (n3 < n4 - 1) {
                    writer.write(",");
                }
                writer.write("\n");
                ++n3;
            }
        } else if (n6 > 0) {
            bl = true;
            if (!pgJvxSrc.isShowingEdges()) {
                writer.write("EdgeForm[],");
            }
            if (!pgJvxSrc.isShowingElementColors()) {
                string2 = PgMathLoader.writeColor(pgJvxSrc.getGlobalElementColor());
                writer.write("SurfaceColor[" + string2 + "],");
            } else {
                colorArray = pgJvxSrc.getElementColors();
            }
            piVectorArray = pgJvxSrc.getElements();
            n3 = 0;
            while (n3 < n6) {
                if (pgJvxSrc.isShowingElementColors()) {
                    string2 = PgMathLoader.writeColor(colorArray[n3]);
                    writer.write("{" + string2 + ",");
                }
                writer.write("Polygon[{");
                n2 = piVectorArray[n3].getSize();
                n = 0;
                while (n < n2) {
                    if (n > 0) {
                        writer.write(", ");
                    }
                    string = PgMathLoader.writeVertex(pdVectorArray[piVectorArray[n3].m_data[n]]);
                    writer.write(string);
                    ++n;
                }
                writer.write("}]");
                if (pgJvxSrc.isShowingElementColors()) {
                    writer.write("}");
                }
                if (n3 < n6 - 1) {
                    writer.write(",");
                }
                writer.write("\n");
                ++n3;
            }
        }
        if (n5 > 0 && pgJvxSrc.isShowingVertices()) {
            if (bl) {
                writer.write(",\n");
            }
            int n7 = 0;
            while (n7 < n5) {
                writer.write("Point[");
                String string3 = PgMathLoader.writeVertex(pdVectorArray[n7]);
                writer.write(string3);
                writer.write("]");
                if (n7 < n5 - 1) {
                    writer.write(",");
                }
                writer.write("\n");
                ++n7;
            }
        }
        writer.write("}]\n");
        return true;
    }

    private Color readRGBColor(StreamTokenizer streamTokenizer) {
        PdVector pdVector = new PdVector();
        if (this.parseVector(streamTokenizer, pdVector, 3)) {
            return new Color((float)pdVector.m_data[0], (float)pdVector.m_data[1], (float)pdVector.m_data[2]);
        }
        return new Color(1.0f, 0.0f, 0.0f);
    }

    private int readSurfaceColor(StreamTokenizer streamTokenizer, Color[] colorArray) {
        try {
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            int n = 1;
            colorArray[0] = this.readColor(streamTokenizer);
            colorArray[1] = colorArray[0];
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == 44) {
                streamTokenizer.nextToken();
                colorArray[1] = this.readColor(streamTokenizer);
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 44) {
                    n = (int)this.readNumber(streamTokenizer);
                    streamTokenizer.nextToken();
                }
            }
            return n;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return 1;
        }
    }

    private static String writeColor(Color color) {
        if (color == null) {
            PsDebug.warning("missing color");
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("RGBColor[");
        stringBuffer.append(String.valueOf((double)color.getRed() / 255.0) + ", " + String.valueOf((double)color.getGreen() / 255.0) + ", " + String.valueOf((double)color.getBlue() / 255.0) + "]");
        return stringBuffer.toString();
    }

    private Color readColor(StreamTokenizer streamTokenizer) {
        if (streamTokenizer.ttype != -3 || !"CMYKColor".equals(streamTokenizer.sval) && !"GrayLevel".equals(streamTokenizer.sval) && !"Hue".equals(streamTokenizer.sval) && !"RGBColor".equals(streamTokenizer.sval)) {
            PsDebug.warning("'CMYKColor', 'GrayLevel', 'Hue' or 'RGBColor' expected in line " + streamTokenizer.lineno());
        }
        if ("RGBColor".equals(streamTokenizer.sval)) {
            return this.readRGBColor(streamTokenizer);
        }
        if ("GrayLevel".equals(streamTokenizer.sval)) {
            return this.readGrayLevel(streamTokenizer);
        }
        if ("Hue".equals(streamTokenizer.sval)) {
            return this.readHueColor(streamTokenizer);
        }
        if ("CMYKColor".equals(streamTokenizer.sval)) {
            return this.readGrayLevel(streamTokenizer);
        }
        return Color.white;
    }

    private void setDisplayDefault() {
        this.m_displayOption.clearTag(3);
        this.m_displayOption.clearTag(4);
        this.m_displayOption.setTag(8);
        this.m_displayOption.clearTag(11);
        this.m_displayOption.setTag(17);
        this.m_displayOption.setNumLights(3);
        this.m_displayOption.setLightColor(0, Color.red);
        this.m_displayOption.setLightPosition(0, new PdVector(1.0, 0.0, 1.0));
        this.m_displayOption.setLightType(0, 1);
        this.m_displayOption.setLightColor(1, Color.green);
        this.m_displayOption.setLightPosition(1, new PdVector(1.0, 1.0, 1.0));
        this.m_displayOption.setLightType(1, 1);
        this.m_displayOption.setLightColor(2, Color.blue);
        this.m_displayOption.setLightPosition(2, new PdVector(0.0, 1.0, 1.0));
        this.m_displayOption.setLightType(2, 1);
        this.m_displayOption.setAmbientLight(Color.black);
        this.m_displayOption.setNumCameras(1);
        this.m_displayOption.setCameraPosition(0, new PdVector(1.3, -2.4, 2.0));
        this.m_displayOption.setCameraProjection(0, 0);
        PdVector pdVector = new PdVector(3);
        pdVector.setConstant(0.5);
        this.m_displayOption.setCameraInterest(0, pdVector);
        this.m_displayOption.setEnabledCameraClip(0, false);
        this.m_displayOption.setCameraFieldOfView(0, 53.13);
        this.m_displayOption.setCameraAngle(0, 1.0);
        this.m_displayOption.setCameraRoll(0, 0.0);
        this.m_displayOption.setCurrentCamera(0);
        this.m_displayOption.setCameraAmbient(0, 0);
        this.m_displayOption.setCameraNearClip(0, 0.0);
        this.m_displayOption.setCameraFarClip(0, 0.0);
        this.m_displayOption.setCameraPerspective(0, 0);
        this.m_displayOption.setEnabledCameraTransform(0, false);
        this.m_viewVertical = new PdVector(0.0, 0.0, 1.0);
        PiVector piVector = new PiVector(6);
        piVector.setConstant(0);
        this.m_displayOption.setAxesEdge(piVector);
    }

    private double readNumber(StreamTokenizer streamTokenizer) {
        try {
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype != -2) {
                PsDebug.warning("Number expected Line: " + streamTokenizer.lineno());
            }
            double d = streamTokenizer.nval;
            streamTokenizer.ordinaryChar(69);
            streamTokenizer.ordinaryChar(101);
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == 42) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 94) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != -2) {
                        PsDebug.warning("Number expected Line: " + streamTokenizer.lineno());
                        streamTokenizer.wordChars(69, 69);
                        streamTokenizer.wordChars(101, 101);
                        return d;
                    }
                    PsDebug.warning("Not formated number found - Please use FormatGraphics.");
                    d *= Math.pow(10.0, streamTokenizer.nval);
                }
            } else if (streamTokenizer.ttype == 69 || streamTokenizer.ttype == 101) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != -2) {
                    PsDebug.warning("Number expected Line: " + streamTokenizer.lineno());
                    streamTokenizer.wordChars(69, 69);
                    streamTokenizer.wordChars(101, 101);
                    return d;
                }
                d *= Math.pow(10.0, streamTokenizer.nval);
            } else {
                streamTokenizer.pushBack();
            }
            streamTokenizer.wordChars(69, 69);
            streamTokenizer.wordChars(101, 101);
            return d;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            streamTokenizer.wordChars(69, 69);
            streamTokenizer.wordChars(101, 101);
            return 0.0;
        }
    }

    private static String writeVertex(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing vertex");
            return null;
        }
        int n = pdVector.getSize();
        if (n < 2) {
            PsDebug.warning("dimension of vertex smaller than 2, return emtpy string.");
            return "";
        }
        if (n > 3) {
            PsDebug.warning("dimension of vertex larger than 3, truncated.");
            n = 3;
        }
        StringBuffer stringBuffer = new StringBuffer("{" + String.valueOf(pdVector.m_data[0]));
        int n2 = 1;
        while (n2 < n) {
            stringBuffer.append(", ");
            if (Math.abs(pdVector.m_data[n2]) > 1.0E-10) {
                stringBuffer.append((float)pdVector.m_data[n2]);
            } else {
                stringBuffer.append(0.0f);
            }
            ++n2;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public boolean isAnimation() {
        return this.m_isAnimation;
    }

    private static void geomInitType(PgJvxSrc pgJvxSrc) {
        switch (pgJvxSrc.getType()) {
            case 30: {
                pgJvxSrc.showVertices(true);
                return;
            }
            case 33: {
                pgJvxSrc.assureNeighbours();
                pgJvxSrc.showEdges(true);
                pgJvxSrc.setGlobalElementBackColor(Color.white);
                pgJvxSrc.setGlobalElementColor(Color.white);
                pgJvxSrc.showElements(true);
                return;
            }
            case 32: {
                pgJvxSrc.showVertices(true);
                pgJvxSrc.showPolygons(true);
                pgJvxSrc.showEdges(true);
                return;
            }
            case 36: {
                pgJvxSrc.showVertices(false);
                return;
            }
        }
    }

    private boolean readParametricSurface(StreamTokenizer streamTokenizer) {
        try {
            int n;
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            Vector<PdVector> vector = new Vector<PdVector>();
            Vector[] vectorArray = new Vector[4];
            int n2 = 0;
            do {
                vectorArray[n2] = new Vector();
            } while (++n2 <= 3);
            PiVector piVector = new PiVector();
            PiVector piVector2 = new PiVector();
            Color color = new Color(0, 0, 0);
            double d = 1.0;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = true;
            boolean bl4 = true;
            boolean bl5 = true;
            int n3 = 0;
            int n4 = 0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            while (streamTokenizer.ttype != 125) {
                streamTokenizer.nextToken();
                ++n4;
                int n5 = n3;
                n3 = 0;
                while (streamTokenizer.ttype != 125) {
                    ++n3;
                    if (this.m_dim == 3) {
                        PdVector pdVector = new PdVector(3);
                        pdVector.m_data[2] = this.readNumber(streamTokenizer);
                        vector.addElement(pdVector);
                    } else if (this.m_dim == 2) {
                        double d6 = this.readNumber(streamTokenizer);
                        bl = true;
                        n = 0;
                        do {
                            vectorArray[n].addElement(new PdVector(d6));
                        } while (++n <= 3);
                    }
                    streamTokenizer.nextToken();
                }
                if (n4 > 1 && n5 != n3) {
                    PsDebug.warning("Number of U-Lines not constant - V-Line: " + n4 + " Line: " + streamTokenizer.lineno());
                    return false;
                }
                streamTokenizer.nextToken();
            }
            streamTokenizer.nextToken();
            int n6 = 1;
            while (n6 != 0) {
                if (streamTokenizer.ttype == -1) {
                    PsDebug.warning("PgMathLoader.readElementSet: ']' missing Line: " + streamTokenizer.lineno());
                    return false;
                }
                if (streamTokenizer.ttype == 93) {
                    --n6;
                }
                if (streamTokenizer.ttype == 91) {
                    ++n6;
                }
                if (streamTokenizer.ttype == -3 && !this.readOptions(streamTokenizer)) {
                    if ("AxesLabel".equals(streamTokenizer.sval)) {
                        this.readAxesLabel(streamTokenizer, this.m_dim);
                    } else if ("Mesh".equals(streamTokenizer.sval)) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        bl3 = "True".equals(streamTokenizer.sval);
                    } else if ("RGBColor".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval)) {
                        bl = true;
                        Color color2 = this.readColor(streamTokenizer);
                        n = 0;
                        do {
                            vectorArray[n].addElement(color2);
                        } while (++n <= 3);
                        piVector.addEntry(1);
                        piVector2.addEntry(1);
                    } else if ("SurfaceColor".equals(streamTokenizer.sval)) {
                        bl = true;
                        Color[] colorArray = new Color[2];
                        n = this.readSurfaceColor(streamTokenizer, colorArray);
                        piVector.addEntry(n);
                        piVector2.addEntry(n);
                        int n7 = 0;
                        do {
                            vectorArray[n7].addElement(colorArray[0]);
                        } while (++n7 <= 1);
                        n7 = 2;
                        do {
                            vectorArray[n7].addElement(colorArray[1]);
                        } while (++n7 <= 3);
                    } else if ("FaceForm".equals(streamTokenizer.sval)) {
                        Color[] colorArray;
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        if (!(streamTokenizer.ttype == -3 && ("CMYKColor".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "RGBColor".equals(streamTokenizer.sval) || "SurfaceColor".equals(streamTokenizer.sval)))) {
                            PsDebug.warning("'CMYKColor', 'GrayLevel', 'Hue', 'RGBColor' or 'SurfaceColor' expected in line " + streamTokenizer.lineno());
                        }
                        bl = true;
                        if ("SurfaceColor".equals(streamTokenizer.sval)) {
                            colorArray = new Color[2];
                            piVector.addEntry(this.readSurfaceColor(streamTokenizer, colorArray));
                            vectorArray[0].addElement(colorArray[0]);
                            vectorArray[2].addElement(colorArray[1]);
                        } else {
                            colorArray = this.readColor(streamTokenizer);
                            vectorArray[0].addElement(colorArray);
                            vectorArray[2].addElement(colorArray);
                            piVector.addEntry(1);
                        }
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == 44) {
                            streamTokenizer.nextToken();
                            if (!(streamTokenizer.ttype == -3 && ("CMYKColor".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "RGBColor".equals(streamTokenizer.sval) || "SurfaceColor".equals(streamTokenizer.sval)))) {
                                PsDebug.warning("'CMYKColor', 'GrayLevel', 'Hue', 'RGBColor' or 'SurfaceColor' expected in line " + streamTokenizer.lineno());
                            }
                            if ("SurfaceColor".equals(streamTokenizer.sval)) {
                                colorArray = new Color[2];
                                piVector2.addEntry(this.readSurfaceColor(streamTokenizer, colorArray));
                                vectorArray[1].addElement(colorArray[0]);
                                vectorArray[3].addElement(colorArray[1]);
                            } else {
                                colorArray = this.readColor(streamTokenizer);
                                vectorArray[1].addElement(colorArray);
                                vectorArray[3].addElement(colorArray);
                                piVector2.addEntry(1);
                            }
                            streamTokenizer.nextToken();
                        } else {
                            int n8 = vectorArray[0].size() - 1;
                            vectorArray[1].addElement(vectorArray[0].elementAt(n8));
                            vectorArray[3].addElement(vectorArray[2].elementAt(n8));
                            piVector2.addEntry(piVector.m_data[n8]);
                        }
                    } else if ("EdgeForm".equals(streamTokenizer.sval)) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == 93) {
                            bl3 = false;
                        }
                        while (streamTokenizer.ttype != 93) {
                            if (streamTokenizer.ttype != -3) continue;
                            if ("RGBColor".equals(streamTokenizer.sval) || "CMYKColor".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval)) {
                                bl2 = true;
                                color = this.readColor(streamTokenizer);
                            }
                            if (!"Thickness".equals(streamTokenizer.sval)) continue;
                            streamTokenizer.nextToken();
                            d = 200.0 * this.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                        }
                    } else if ("MeshRange".equals(streamTokenizer.sval)) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        streamTokenizer.parseNumbers();
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        d2 = this.readNumber(streamTokenizer);
                        streamTokenizer.nextToken();
                        d3 = this.readNumber(streamTokenizer);
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        d4 = this.readNumber(streamTokenizer);
                        streamTokenizer.nextToken();
                        d5 = this.readNumber(streamTokenizer);
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                    } else if ("HiddenSurface".equals(streamTokenizer.sval)) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        bl4 = "True".equals(streamTokenizer.sval);
                    } else if ("Shading".equals(streamTokenizer.sval)) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        bl5 = "True".equals(streamTokenizer.sval);
                    }
                }
                streamTokenizer.ordinaryChar(45);
                streamTokenizer.nextToken();
            }
            if (this.m_dim == 2) {
                ++n3;
                ++n4;
                int n9 = 0;
                while (n9 < n3 * n4) {
                    vector.addElement(new PdVector(2));
                    ++n9;
                }
            }
            double d7 = (d3 - d2) / (double)(n3 - 1);
            double d8 = (d5 - d4) / (double)(n4 - 1);
            int n10 = 0;
            PgJvxSrc pgJvxSrc = new PgJvxSrc();
            pgJvxSrc.setType(33);
            pgJvxSrc.setNumVertices(n3 * n4);
            PdVector[] pdVectorArray = pgJvxSrc.getVertices();
            int n11 = 0;
            while (n11 < n4) {
                int n12 = 0;
                while (n12 < n3) {
                    pdVectorArray[n11 * n3 + n12].copy((PdVector)vector.elementAt(n10));
                    pdVectorArray[n11 * n3 + n12].m_data[0] = d2 + (double)n12 * d7;
                    pdVectorArray[n11 * n3 + n12].m_data[1] = d4 + (double)n11 * d8;
                    ++n10;
                    ++n12;
                }
                ++n11;
            }
            pgJvxSrc.setDimOfElements(4);
            pgJvxSrc.setNumElements((n3 - 1) * (n4 - 1));
            PiVector[] piVectorArray = pgJvxSrc.getElements();
            PiVector[] piVectorArray2 = pgJvxSrc.getNeighbours();
            int n13 = 0;
            int n14 = 0;
            while (n14 < n4 - 1) {
                int n15 = 0;
                while (n15 < n3 - 1) {
                    piVectorArray[n13].m_data[0] = n14 * n3 + n15;
                    piVectorArray[n13].m_data[1] = (n14 + 1) * n3 + n15;
                    piVectorArray[n13].m_data[2] = (n14 + 1) * n3 + n15 + 1;
                    piVectorArray[n13].m_data[3] = n14 * n3 + n15 + 1;
                    if (n14 < n4 - 2) {
                        piVectorArray2[n13].m_data[0] = n13 + n3 - 1;
                    }
                    if (n15 < n3 - 2) {
                        piVectorArray2[n13].m_data[1] = n13 + 1;
                    }
                    if (n14 > 0) {
                        piVectorArray2[n13].m_data[2] = n13 - n3 + 1;
                    }
                    if (n15 > 0) {
                        piVectorArray2[n13].m_data[3] = n13 - 1;
                    }
                    ++n13;
                    ++n15;
                }
                ++n14;
            }
            PgMathLoader.geomInitType(pgJvxSrc);
            pgJvxSrc.showEdges(bl3);
            if (this.m_dim == 3) {
                pgJvxSrc.showElements(bl4);
                pgJvxSrc.showElementColors(bl5);
                pgJvxSrc.showElementBackColors(bl5);
                n14 = (n3 - 1) * (n4 - 1);
                Color[][] colorArrayArray = new Color[4][];
                int n16 = 0;
                do {
                    colorArrayArray[n16] = new Color[n14];
                } while (++n16 <= 3);
                if (bl) {
                    if (vectorArray[0].size() == n14) {
                        n16 = 0;
                        while (n16 < n14) {
                            int n17 = 0;
                            do {
                                colorArrayArray[n17][n16] = (Color)vectorArray[n17].elementAt(n16);
                            } while (++n17 <= 3);
                            ++n16;
                        }
                        pgJvxSrc.setElementColors(colorArrayArray[0]);
                        pgJvxSrc.setElementBackColors(colorArrayArray[1]);
                    } else {
                        n16 = 0;
                        do {
                            Color color3 = (Color)vectorArray[n16].elementAt(0);
                            int n18 = 0;
                            while (n18 < n14) {
                                colorArrayArray[n16][n18] = color3;
                                ++n18;
                            }
                        } while (++n16 <= 3);
                        pgJvxSrc.setElementColors(colorArrayArray[0]);
                        pgJvxSrc.setElementBackColors(colorArrayArray[1]);
                    }
                } else {
                    n16 = 0;
                    while (n16 < n14) {
                        int n19 = 0;
                        do {
                            colorArrayArray[n19][n16] = Color.white;
                        } while (++n19 <= 3);
                        ++n16;
                    }
                    pgJvxSrc.setElementColors(colorArrayArray[0]);
                    pgJvxSrc.setElementBackColors(colorArrayArray[1]);
                }
                if (bl2) {
                    pgJvxSrc.setGlobalEdgeColor(color);
                }
            } else if (this.m_dim == 2) {
                pgJvxSrc.setDimOfVertices(2);
                pgJvxSrc.showElements(bl4);
                pgJvxSrc.showElementColors(bl5);
                pgJvxSrc.showElementBackColors(bl5);
                n14 = (n3 - 1) * (n4 - 1);
                Color[] colorArray = new Color[n14];
                if (bl) {
                    if (vectorArray[0].size() == n14) {
                        double d9;
                        double d10 = ((PdVector)vectorArray[0].elementAt((int)0)).m_data[0];
                        double d11 = ((PdVector)vectorArray[0].elementAt((int)0)).m_data[0];
                        int n20 = 0;
                        while (n20 < n14) {
                            d9 = ((PdVector)vectorArray[0].elementAt((int)n20)).m_data[0];
                            if (d9 > d11) {
                                d11 = d9;
                            }
                            if (d9 < d10) {
                                d10 = d9;
                            }
                            ++n20;
                        }
                        if (d10 == d11) {
                            d11 += 1.0;
                        }
                        n20 = 0;
                        while (n20 < n14) {
                            d9 = ((PdVector)vectorArray[0].elementAt((int)n20)).m_data[0];
                            d9 = (d9 - d10) / (d11 - d10);
                            colorArray[n20] = new Color((float)d9, (float)d9, (float)d9);
                            ++n20;
                        }
                        pgJvxSrc.setElementColors(colorArray);
                        pgJvxSrc.setElementBackColors(colorArray);
                    } else {
                        int n21 = 0;
                        while (n21 < n14) {
                            colorArray[n21] = Color.gray;
                            ++n21;
                        }
                        pgJvxSrc.setElementColors(colorArray);
                        pgJvxSrc.setElementBackColors(colorArray);
                    }
                } else {
                    int n22 = 0;
                    while (n22 < n14) {
                        colorArray[n22] = Color.gray;
                        ++n22;
                    }
                    pgJvxSrc.setElementColors(colorArray);
                    pgJvxSrc.setElementBackColors(colorArray);
                }
                if (bl2) {
                    pgJvxSrc.setGlobalEdgeColor(color);
                }
            }
            if (!this.m_displayOption.hasTag(17) && this.m_dim == 3) {
                n14 = pgJvxSrc.getNumElements();
                Color[] colorArray = new Color[n14];
                Color[] colorArray2 = new Color[n14];
                double d12 = pdVectorArray[0].m_data[2];
                double d13 = pdVectorArray[0].m_data[2];
                int n23 = 0;
                while (n23 < n3 * n4) {
                    if (pdVectorArray[n23].m_data[2] > d13) {
                        d13 = pdVectorArray[n23].m_data[2];
                    }
                    if (pdVectorArray[n23].m_data[2] < d12) {
                        d12 = pdVectorArray[n23].m_data[2];
                    }
                    ++n23;
                }
                double d14 = d13 - d12;
                PiVector[] piVectorArray3 = pgJvxSrc.getElements();
                PdVector[] pdVectorArray2 = pgJvxSrc.getVertices();
                int n24 = 0;
                while (n24 < n14) {
                    PiVector piVector3 = piVectorArray3[n24];
                    int n25 = piVector3.getSize();
                    double d15 = 0.0;
                    int n26 = 0;
                    while (n26 < n25) {
                        d15 += pdVectorArray2[piVector3.m_data[n26]].m_data[2];
                        ++n26;
                    }
                    double d16 = ((d15 /= (double)n25) - d12) / d14;
                    colorArray[n24] = new Color((float)d16, (float)d16, (float)d16);
                    colorArray2[n24] = colorArray[n24];
                    ++n24;
                }
                pgJvxSrc.setElementColors(colorArray);
                pgJvxSrc.setElementBackColors(colorArray2);
            }
            pgJvxSrc.setGlobalEdgeSize(d);
            this.m_geom = new PgJvxSrc[1];
            this.m_geom[0] = pgJvxSrc;
            this.graphicsVector.addElement(this.m_geom);
            streamTokenizer.parseNumbers();
            streamTokenizer.pushBack();
            return true;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return false;
        }
    }

    private void adjustViewer() {
        double d;
        PdVector pdVector = this.m_displayOption.getCameraInterest(0);
        PdVector pdVector2 = this.m_displayOption.getCameraPosition(0);
        PdVector pdVector3 = PdVector.subNew(this.m_boundingBoxMax, this.m_boundingBoxMin);
        int n = 0;
        do {
            int n2 = n;
            this.m_viewVertical.m_data[n2] = this.m_viewVertical.m_data[n2] * pdVector3.m_data[n];
            d = pdVector.m_data[n];
            pdVector.m_data[n] = (1.0 - d) * this.m_boundingBoxMin.m_data[n] + d * this.m_boundingBoxMax.m_data[n];
            int n3 = n++;
            pdVector3.m_data[n3] = pdVector3.m_data[n3] * (1.0 + 2.0 * Math.abs(0.5 - d));
        } while (n < 3);
        pdVector2.normalize();
        pdVector2.multScalar(pdVector3.length());
        pdVector2.add(pdVector);
        PdVector pdVector4 = PdVector.subNew(pdVector2, pdVector);
        d = -PdVector.angle(PdVector.crossNew(pdVector4, this.m_viewVertical), PdVector.crossNew(pdVector4, new PdVector(0.0, 0.0, 1.0)));
        this.m_displayOption.setCameraRoll(0, d);
        int n4 = this.m_displayOption.getNumLights();
        if (n4 == 3 && PdVector.subNew(this.m_displayOption.getLightPosition(0), new PdVector(1.0, 0.0, 1.0)).length() == 0.0 && this.m_displayOption.getLightColor(0).getRGB() == -65536 && this.m_displayOption.getLightType(0) == 1 && PdVector.subNew(this.m_displayOption.getLightPosition(1), new PdVector(1.0, 1.0, 1.0)).length() == 0.0 && this.m_displayOption.getLightColor(1).getRGB() == -16711936 && this.m_displayOption.getLightType(1) == 1 && PdVector.subNew(this.m_displayOption.getLightPosition(2), new PdVector(0.0, 1.0, 1.0)).length() == 0.0 && this.m_displayOption.getLightColor(2).getRGB() == -16776961 && this.m_displayOption.getLightType(2) == 1 && this.m_displayOption.getAmbientLight().getRGB() == -16777216) {
            this.m_displayOption.setNumLights(5);
            n4 = 5;
            this.m_displayOption.setLightColor(3, Color.gray);
            this.m_displayOption.setLightPosition(3, new PdVector(-1.0, -1.0, -1.0));
            this.m_displayOption.setLightType(3, 1);
            this.m_displayOption.setLightColor(4, Color.blue);
            this.m_displayOption.setLightPosition(4, new PdVector(0.0, 0.0, -1.0));
            this.m_displayOption.setLightType(4, 1);
        }
        int n5 = 0;
        while (n5 < n4) {
            if (this.m_displayOption.getLightType(n5) == 1) {
                PdVector pdVector5 = this.m_displayOption.getLightPosition(n5);
                PdVector pdVector6 = PdVector.crossNew(pdVector4, this.m_viewVertical);
                if (!pdVector6.normalize() && !(pdVector6 = PdVector.crossNew(pdVector4, new PdVector(0.0, 1.0, 0.0))).normalize()) {
                    pdVector6 = PdVector.crossNew(pdVector4, new PdVector(0.0, 0.0, 1.0));
                    pdVector6.normalize();
                }
                PdVector pdVector7 = PdVector.crossNew(pdVector4, pdVector6);
                pdVector7.normalize();
                PdVector pdVector8 = PdVector.copyNew(pdVector4);
                pdVector8.normalize();
                PdVector pdVector9 = PdVector.blendNew(-pdVector5.m_data[0], pdVector6, -pdVector5.m_data[1], pdVector7);
                PdVector pdVector10 = PdVector.blendNew(pdVector5.m_data[2], pdVector8, 1.0, pdVector9);
                this.m_displayOption.setLightPosition(n5, pdVector10);
            }
            ++n5;
        }
    }

    private boolean readOptions(StreamTokenizer streamTokenizer) {
        try {
            if ("Boxed".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                if ("True".equals(streamTokenizer.sval)) {
                    this.m_displayOption.setTag(8);
                } else {
                    this.m_displayOption.clearTag(8);
                }
                return true;
            }
            if ("Axes".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                if ("True".equals(streamTokenizer.sval) || "Automatic".equals(streamTokenizer.sval)) {
                    this.m_displayOption.setTag(3);
                } else {
                    this.m_displayOption.clearTag(3);
                }
                return true;
            }
            if ("Lighting".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                if ("True".equals(streamTokenizer.sval)) {
                    this.m_displayOption.setTag(17);
                } else {
                    this.m_displayOption.clearTag(17);
                }
                return true;
            }
            if ("LightSources".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.parseNumbers();
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 125) {
                    this.m_displayOption.setNumLights(0);
                } else {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == -2) {
                        PdVector[] pdVectorArray = new PdVector[1];
                        Color[] colorArray = new Color[1];
                        pdVectorArray[0] = new PdVector(3);
                        int n = 0;
                        do {
                            streamTokenizer.pushBack();
                            pdVectorArray[0].m_data[n] = this.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                        } while (++n < 3);
                        streamTokenizer.nextToken();
                        colorArray[0] = this.readColor(streamTokenizer);
                        streamTokenizer.nextToken();
                    } else {
                        Vector<PdVector> vector = new Vector<PdVector>();
                        Vector<Color> vector2 = new Vector<Color>();
                        while (streamTokenizer.ttype != 125) {
                            PdVector pdVector = new PdVector(3);
                            int n = 0;
                            do {
                                pdVector.m_data[n] = this.readNumber(streamTokenizer);
                                streamTokenizer.nextToken();
                            } while (++n < 3);
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            Color color = this.readColor(streamTokenizer);
                            streamTokenizer.nextToken();
                            vector.addElement(pdVector);
                            vector2.addElement(color);
                            streamTokenizer.nextToken();
                            if (streamTokenizer.ttype != 44) continue;
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                        }
                        PdVector[] pdVectorArray = new PdVector[vector.size()];
                        Color[] colorArray = new Color[vector2.size()];
                        int n = vector.size();
                        this.m_displayOption.setNumLights(n);
                        int n2 = 0;
                        while (n2 < n) {
                            pdVectorArray[n2] = (PdVector)vector.elementAt(n2);
                            colorArray[n2] = (Color)vector2.elementAt(n2);
                            this.m_displayOption.setLightColor(n2, (Color)vector2.elementAt(n2));
                            this.m_displayOption.setLightPosition(n2, (PdVector)vector.elementAt(n2));
                            this.m_displayOption.setLightType(n2, 1);
                            ++n2;
                        }
                    }
                }
                return true;
            }
            if ("ViewPoint".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.parseNumbers();
                PdVector pdVector = new PdVector();
                if (!this.parseVector(streamTokenizer, pdVector, 3)) {
                    return false;
                }
                this.m_displayOption.setCameraPosition(0, pdVector);
                return true;
            }
            if ("ViewCenter".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.parseNumbers();
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != -3 || !"Automatic".equals(streamTokenizer.sval)) {
                    streamTokenizer.pushBack();
                    PdVector pdVector = new PdVector();
                    if (!this.parseVector(streamTokenizer, pdVector, 3)) {
                        return false;
                    }
                    this.m_displayOption.setCameraInterest(0, pdVector);
                }
                return true;
            }
            if ("AxesEdge".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.parseNumbers();
                streamTokenizer.nextToken();
                PiVector piVector = new PiVector(6);
                if (streamTokenizer.ttype == -3 && "Automatic".equals(streamTokenizer.sval)) {
                    int n = 0;
                    do {
                        piVector.m_data[n] = -1;
                    } while (++n < 6);
                } else {
                    int n = 0;
                    do {
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == -3) {
                            if ("Automatic".equals(streamTokenizer.sval)) {
                                piVector.m_data[n * 2] = -1;
                                piVector.m_data[n * 2 + 1] = -1;
                            } else {
                                piVector.m_data[n * 2] = 0;
                                piVector.m_data[n * 2 + 1] = 0;
                            }
                        } else {
                            streamTokenizer.nextToken();
                            piVector.m_data[n * 2] = (int)streamTokenizer.nval;
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            piVector.m_data[n * 2 + 1] = (int)streamTokenizer.nval;
                            streamTokenizer.nextToken();
                        }
                        streamTokenizer.nextToken();
                    } while (++n < 3);
                }
                this.m_displayOption.setAxesEdge(piVector);
                return true;
            }
            if ("AmbientLight".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.parseNumbers();
                streamTokenizer.nextToken();
                this.m_displayOption.setAmbientLight(this.readColor(streamTokenizer));
                return true;
            }
            if ("BoxRatios".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.parseNumbers();
                streamTokenizer.nextToken();
                PdVector pdVector = new PdVector(3);
                if (streamTokenizer.ttype == -3 && "Automatic".equals(streamTokenizer.sval)) {
                    pdVector.setConstant(0.0);
                } else {
                    streamTokenizer.pushBack();
                    if (!this.parseVector(streamTokenizer, pdVector, 3)) {
                        return false;
                    }
                }
                return true;
            }
            if ("Background".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == -3 && ("RGBColor".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval) || "CMYKColor".equals(streamTokenizer.sval))) {
                    this.m_displayOption.setBackgroundColor(this.readColor(streamTokenizer));
                }
                return true;
            }
            if ("PolygonIntersections".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                if (!"True".equals(streamTokenizer.sval)) {
                    // empty if block
                }
                return true;
            }
            if ("ViewVertical".equals(streamTokenizer.sval)) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                return this.parseVector(streamTokenizer, this.m_viewVertical, 3);
            }
            return false;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return false;
        }
    }

    private Color readGrayLevel(StreamTokenizer streamTokenizer) {
        try {
            streamTokenizer.nextToken();
            double d = this.readNumber(streamTokenizer);
            streamTokenizer.nextToken();
            return new Color((float)d, (float)d, (float)d);
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return new Color(0.5f, 0.5f, 0.5f);
        }
    }

    private void readAxesLabel(StreamTokenizer streamTokenizer, int n) {
        try {
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            streamTokenizer.ordinaryChar(34);
            streamTokenizer.nextToken();
            String[] stringArray = new String[n];
            if (streamTokenizer.ttype == -3 && "None".equals(streamTokenizer.sval)) {
                int n2 = 0;
                while (n2 < n) {
                    stringArray[n2] = "";
                    ++n2;
                }
                this.m_displayOption.clearTag(4);
            } else if (streamTokenizer.ttype == 123) {
                this.m_displayOption.setTag(4);
                int n3 = 0;
                while (n3 < n) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype != 34) {
                        PsDebug.warning("AxesLabel should be given in quotes.");
                        this.m_displayOption.clearTag(4);
                        break;
                    }
                    stringArray[n3] = this.readString(streamTokenizer);
                    streamTokenizer.nextToken();
                    ++n3;
                }
            } else {
                int n4 = 0;
                while (n4 < n - 1) {
                    stringArray[n4] = "";
                    ++n4;
                }
                if (streamTokenizer.ttype == 34) {
                    stringArray[n] = this.readString(streamTokenizer);
                    this.m_displayOption.setTag(4);
                } else {
                    PsDebug.warning("AxesLabel should be given in quotes.");
                    this.m_displayOption.clearTag(4);
                }
            }
            streamTokenizer.wordChars(34, 34);
            this.m_displayOption.setAxesLabel(stringArray);
            return;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return;
        }
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean parseMath(BufferedReader bufferedReader) throws IOException {
        int n;
        int n2;
        StreamTokenizer streamTokenizer;
        try {
            this.m_displayOption = new PvDisplayOption();
            this.setDisplayDefault();
            streamTokenizer = new StreamTokenizer(bufferedReader);
            streamTokenizer.ordinaryChar(91);
            streamTokenizer.ordinaryChar(93);
            streamTokenizer.ordinaryChar(123);
            streamTokenizer.ordinaryChar(125);
            streamTokenizer.ordinaryChar(42);
            streamTokenizer.ordinaryChar(94);
            streamTokenizer.ordinaryChar(44);
            streamTokenizer.parseNumbers();
            streamTokenizer.eolIsSignificant(false);
            streamTokenizer.whitespaceChars(92, 92);
            n2 = 0;
            n = 0;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception);
            return false;
        }
        block12: while (true) {
            int n3 = 0;
            block13: do {
                switch (n3 == 0 ? streamTokenizer.nextToken() : n3) {
                    default: {
                        PsDebug.warning("parsing broke abnormally reading st.sval = " + streamTokenizer.sval + ", st.ttype = " + streamTokenizer.ttype + "  in line: " + streamTokenizer.lineno());
                        break;
                    }
                    case -1: {
                        if (n2 != 0) {
                            PsDebug.warning("'}' missing");
                            return false;
                        }
                        if (n == 0) return true;
                        PsDebug.warning("']' missing");
                        return false;
                    }
                    case -3: {
                        n3 = 44;
                        if ("InputForm".equals(streamTokenizer.sval)) continue block13;
                        if ("Graphics".equals(streamTokenizer.sval)) {
                            this.m_dim = 2;
                            if (!this.readGraphics(streamTokenizer)) {
                                PsDebug.warning("failed reading Graphics");
                                return false;
                            }
                            ++this.m_numGraphics;
                            break;
                        }
                        if ("Graphics3D".equals(streamTokenizer.sval)) {
                            this.m_dim = 3;
                            if (!this.readGraphics(streamTokenizer)) {
                                PsDebug.warning("failed reading Graphics3D");
                                return false;
                            }
                            ++this.m_numGraphics;
                            break;
                        }
                        if ("SurfaceGraphics".equals(streamTokenizer.sval)) {
                            this.m_dim = 3;
                            if (!this.readParametricSurface(streamTokenizer)) {
                                PsDebug.warning("failed reading SurfaceGraphics as ElementSet");
                                return false;
                            }
                            ++this.m_numGraphics;
                            break;
                        }
                        if ("DensityGraphics".equals(streamTokenizer.sval)) {
                            this.m_dim = 2;
                            if (!this.readParametricSurface(streamTokenizer)) {
                                PsDebug.warning("failed reading DensityGraphics as ElementSet");
                                return false;
                            }
                            ++this.m_numGraphics;
                            break;
                        }
                        if (!("KeyAnimation".equals(streamTokenizer.sval) || "Animation".equals(streamTokenizer.sval) || "ShowAnimation".equals(streamTokenizer.sval))) {
                            PsDebug.warning("Unknown command:" + streamTokenizer.sval + " Line: " + streamTokenizer.lineno());
                            return false;
                        }
                        if ("KeyAnimation".equals(streamTokenizer.sval)) {
                            this.m_isKeyAnimation = true;
                        }
                        if ("Animation".equals(streamTokenizer.sval)) {
                            this.m_isAnimation = true;
                        }
                        if ("ShowAnimation".equals(streamTokenizer.sval)) {
                            this.m_isKeyAnimation = true;
                        }
                        streamTokenizer.nextToken();
                        while (streamTokenizer.ttype != 93) {
                            streamTokenizer.nextToken();
                            if (streamTokenizer.ttype == 123 || streamTokenizer.ttype == 125) {
                                streamTokenizer.nextToken();
                            }
                            if (streamTokenizer.ttype != -3 || !"Graphics".equals(streamTokenizer.sval) && !"Graphics3D".equals(streamTokenizer.sval) && !"SurfaceGraphics".equals(streamTokenizer.sval)) {
                                PsDebug.warning("Expected 'Graphics', 'Graphics3D' or 'SurfaceGraphics' Line: " + streamTokenizer.lineno());
                                return false;
                            }
                            if ("Graphics".equals(streamTokenizer.sval)) {
                                this.m_dim = 2;
                                if (!this.readGraphics(streamTokenizer)) {
                                    PsDebug.warning("failed reading Graphics");
                                    return false;
                                }
                                ++this.m_numGraphics;
                            }
                            if ("Graphics3D".equals(streamTokenizer.sval)) {
                                this.m_dim = 3;
                                if (!this.readGraphics(streamTokenizer)) {
                                    PsDebug.warning("failed reading Graphics3D");
                                    return false;
                                }
                                ++this.m_numGraphics;
                            }
                            if ("SurfaceGraphics".equals(streamTokenizer.sval)) {
                                this.m_dim = 3;
                                if (!this.readParametricSurface(streamTokenizer)) {
                                    PsDebug.warning("failed reading SurfaceGraphics as ElementSet");
                                    return false;
                                }
                                ++this.m_numGraphics;
                            }
                            streamTokenizer.nextToken();
                            if (streamTokenizer.ttype == 123 || streamTokenizer.ttype == 125) {
                                streamTokenizer.nextToken();
                            }
                            if (streamTokenizer.ttype == 44 || streamTokenizer.ttype == 93) continue;
                            PsDebug.warning("Expected ',' or ']' Line: " + streamTokenizer.lineno());
                            return false;
                        }
                        break;
                    }
                    case 40: {
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype != 42) {
                            streamTokenizer.pushBack();
                            break;
                        }
                        boolean bl = true;
                        while (bl) {
                            streamTokenizer.nextToken();
                            if (streamTokenizer.ttype != 42) continue;
                            streamTokenizer.nextToken();
                            if (streamTokenizer.ttype == 41) {
                                bl = false;
                                continue;
                            }
                            streamTokenizer.pushBack();
                        }
                        break;
                    }
                    case 123: {
                        ++n2;
                        break;
                    }
                    case 125: {
                        n3 = 44;
                        if (--n2 >= 0) continue block13;
                        PsDebug.warning("More '}' than '{' Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    case 91: {
                        ++n;
                        break;
                    }
                    case 93: {
                        if (--n < 0) {
                            PsDebug.warning("More ']' than '[' Line: " + streamTokenizer.lineno());
                            return false;
                        }
                    }
                    case 44: 
                }
                continue block12;
            } while (true);
        }
    }

    private String readString(StreamTokenizer streamTokenizer) {
        try {
            streamTokenizer.nextToken();
            String string = new String("");
            while (streamTokenizer.ttype != 34) {
                if (streamTokenizer.ttype == -3) {
                    string = string + streamTokenizer.sval;
                } else if (streamTokenizer.ttype == -2) {
                    streamTokenizer.pushBack();
                    string = string + Double.toString(this.readNumber(streamTokenizer));
                } else if (streamTokenizer.ttype == 91) {
                    string = string + "[";
                } else if (streamTokenizer.ttype == 93) {
                    string = string + "]";
                } else if (streamTokenizer.ttype == 44) {
                    string = string + ",";
                } else if (streamTokenizer.ttype == 42) {
                    string = string + "*";
                } else if (streamTokenizer.ttype == 94) {
                    string = string + "^";
                } else if (streamTokenizer.ttype == 123) {
                    string = string + "{";
                } else if (streamTokenizer.ttype == 125) {
                    string = string + "}";
                } else if (streamTokenizer.ttype == 40) {
                    string = string + "(";
                } else if (streamTokenizer.ttype == 41) {
                    string = string + ")";
                } else if (streamTokenizer.ttype == 45) {
                    string = string + "-";
                } else if (streamTokenizer.ttype == 62) {
                    string = string + ">";
                }
                streamTokenizer.nextToken();
            }
            return string;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return "";
        }
    }

    private void computeMathematicaColors(PgJvxSrc pgJvxSrc) {
        if (this.m_displayOption.hasTag(17)) {
            pgJvxSrc.makeElementNormals();
            int n = pgJvxSrc.getNumElements();
            Color[] colorArray = new Color[n];
            Color[] colorArray2 = new Color[n];
            int n2 = this.m_displayOption.getNumLights();
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                if (this.m_displayOption.getLightType(n4) == 1) {
                    ++n3;
                }
                ++n4;
            }
            Color[] colorArray3 = new Color[n3];
            PdVector[] pdVectorArray = new PdVector[n3];
            Color color = this.m_displayOption.getAmbientLight();
            int n5 = 0;
            int n6 = 0;
            while (n6 < n3) {
                if (this.m_displayOption.getLightType(n6) == 1) {
                    colorArray3[n5] = this.m_displayOption.getLightColor(n6);
                    pdVectorArray[n5] = this.m_displayOption.getLightPosition(n6);
                    ++n5;
                }
                ++n6;
            }
            PdVector[] pdVectorArray2 = pgJvxSrc.getElementNormals();
            Color[] colorArray4 = pgJvxSrc.getElementColors();
            Color[] colorArray5 = pgJvxSrc.getElementBackColors();
            int n7 = 0;
            while (n7 < n) {
                double d = color.getRed();
                double d2 = color.getGreen();
                double d3 = color.getBlue();
                double d4 = color.getRed();
                double d5 = color.getGreen();
                double d6 = color.getBlue();
                PdVector pdVector = PdVector.copyNew(pdVectorArray2[n7]);
                pdVector.normalize();
                int n8 = 0;
                while (n8 < n3) {
                    double d7 = PdVector.dot(pdVector, pdVectorArray[n8]) / pdVectorArray[n8].length();
                    if (d7 > 0.0) {
                        d += d7 * (double)colorArray3[n8].getRed();
                        d2 += d7 * (double)colorArray3[n8].getGreen();
                        d3 += d7 * (double)colorArray3[n8].getBlue();
                    } else {
                        d4 -= d7 * (double)colorArray3[n8].getRed();
                        d5 -= d7 * (double)colorArray3[n8].getGreen();
                        d6 -= d7 * (double)colorArray3[n8].getBlue();
                    }
                    ++n8;
                }
                Color color2 = colorArray4[n7];
                d = d > (double)color2.getRed() ? (double)color2.getRed() / 255.0 : (d /= 255.0);
                d2 = d2 > (double)color2.getGreen() ? (double)color2.getGreen() / 255.0 : (d2 /= 255.0);
                d3 = d3 > (double)color2.getBlue() ? (double)color2.getBlue() / 255.0 : (d3 /= 255.0);
                Color color3 = colorArray5[n7];
                d4 = d4 > (double)color3.getRed() ? (double)color3.getRed() / 255.0 : (d4 /= 255.0);
                d5 = d5 > (double)color3.getGreen() ? (double)color3.getGreen() / 255.0 : (d5 /= 255.0);
                d6 = d6 > (double)color3.getBlue() ? (double)color3.getBlue() / 255.0 : (d6 /= 255.0);
                colorArray[n7] = new Color((float)d, (float)d2, (float)d3);
                colorArray2[n7] = new Color((float)d4, (float)d5, (float)d6);
                ++n7;
            }
            pgJvxSrc.setElementColors(colorArray);
            pgJvxSrc.setElementBackColors(colorArray2);
        }
    }

    private Color readHueColor(StreamTokenizer streamTokenizer) {
        try {
            streamTokenizer.nextToken();
            double d = this.readNumber(streamTokenizer);
            double d2 = 1.0;
            double d3 = 1.0;
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == 44) {
                d2 = this.readNumber(streamTokenizer);
                streamTokenizer.nextToken();
                d3 = this.readNumber(streamTokenizer);
                streamTokenizer.nextToken();
            }
            Color color = new Color(Color.HSBtoRGB((float)d, (float)d2, (float)d3));
            return color;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return new Color(1.0f, 0.0f, 0.0f);
        }
    }

    private Color readCMYKColor(StreamTokenizer streamTokenizer) {
        PdVector pdVector = new PdVector();
        if (this.parseVector(streamTokenizer, pdVector, 4)) {
            PsDebug.warning("Reading of CMYKColor not implemented yet.");
            return new Color(255, 255, 255);
        }
        PsDebug.warning("Reading of CMYKColor failed.");
        return new Color(255, 255, 255);
    }

    private boolean readGraphics(StreamTokenizer streamTokenizer) {
        try {
            int n;
            int n2;
            Vector[] vectorArray = new Vector[7];
            Vector<Color> vector = new Vector<Color>();
            vector.addElement(Color.white);
            int n3 = 0;
            do {
                vectorArray[n3] = new Vector();
                vectorArray[n3].addElement(Color.white);
            } while (++n3 <= 5);
            PiVector piVector = new PiVector(1);
            piVector.m_data[0] = 1;
            PiVector piVector2 = new PiVector(1);
            piVector2.m_data[0] = 1;
            vectorArray[6] = new Vector();
            vectorArray[6].addElement(Color.black);
            boolean bl = false;
            boolean bl2 = false;
            Vector[] vectorArray2 = new Vector[9];
            int n4 = 0;
            do {
                vectorArray2[n4] = new Vector();
            } while (++n4 <= 8);
            PiVector piVector3 = new PiVector();
            PiVector piVector4 = new PiVector();
            Vector<PdVector> vector2 = new Vector<PdVector>();
            Vector<PiVector> vector3 = new Vector<PiVector>();
            Vector<PdVector> vector4 = new Vector<PdVector>();
            Vector<PdVector[]> vector5 = new Vector<PdVector[]>();
            Vector<PgJvxSrc> vector6 = new Vector<PgJvxSrc>();
            Vector<PdVector> vector7 = new Vector<PdVector>();
            Vector<PdVector> vector8 = new Vector<PdVector>();
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            boolean bl3 = true;
            if (this.m_dim == 2) {
                bl3 = false;
            }
            double d = 1.0;
            int n12 = 0;
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype != 91) {
                PsDebug.warning("'['Expected Line: " + streamTokenizer.lineno());
                return false;
            }
            String string = "";
            int n13 = -1;
            while (n13 != 0) {
                if (n13 == -1) {
                    n13 = 0;
                }
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 123) {
                    int n14 = vector.size();
                    if (++n13 + 1 > n14) {
                        vector.addElement((Color)vector.elementAt(n14 - 1));
                        int n15 = 0;
                        do {
                            vectorArray[n15].addElement(vectorArray[n15].elementAt(n14 - 1));
                        } while (++n15 <= 6);
                        piVector.setSize(n13 + 1);
                        piVector2.setSize(n13 + 1);
                        continue;
                    }
                    vector.setElementAt((Color)vector.elementAt(n13 - 1), n13);
                    int n16 = 0;
                    do {
                        vectorArray[n16].setElementAt(vectorArray[n16].elementAt(n13 - 1), n13);
                    } while (++n16 <= 6);
                    piVector.m_data[n13] = piVector.m_data[n13 - 1];
                    piVector2.m_data[n13] = piVector2.m_data[n13 - 1];
                    continue;
                }
                if (streamTokenizer.ttype == 125) {
                    --n13;
                    continue;
                }
                if (streamTokenizer.ttype == 44) continue;
                if (streamTokenizer.ttype != -3) {
                    PsDebug.warning("Graphics primitive identifyer expected Line: " + streamTokenizer.lineno());
                    return false;
                }
                if ("Polygon".equals(streamTokenizer.sval)) {
                    int n17;
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    int n18 = 0;
                    while (streamTokenizer.ttype != 125) {
                        streamTokenizer.nextToken();
                        PdVector pdVector = new PdVector(this.m_dim);
                        n17 = 0;
                        while (n17 < this.m_dim) {
                            pdVector.m_data[n17] = this.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            ++n17;
                        }
                        vector2.addElement(pdVector);
                        ++n18;
                        ++n5;
                        streamTokenizer.nextToken();
                    }
                    PiVector piVector5 = new PiVector(n18);
                    n17 = 0;
                    while (n17 < n18) {
                        piVector5.m_data[n17] = n12 + n17;
                        ++n17;
                    }
                    n12 += n18;
                    vector3.addElement(piVector5);
                    ++n6;
                    streamTokenizer.nextToken();
                    n17 = 0;
                    do {
                        vectorArray2[n17].addElement(vectorArray[n17].elementAt(n13));
                    } while (++n17 <= 6);
                    piVector3.addEntry(piVector.m_data[n13]);
                    piVector4.addEntry(piVector2.m_data[n13]);
                    continue;
                }
                if ("Point".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    PdVector pdVector = new PdVector();
                    if (!this.parseVector(streamTokenizer, pdVector, this.m_dim)) {
                        return false;
                    }
                    vector4.addElement(pdVector);
                    ++n7;
                    streamTokenizer.nextToken();
                    vectorArray2[7].addElement(vector.elementAt(n13));
                    continue;
                }
                if ("Line".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    Vector<PdVector> vector9 = new Vector<PdVector>();
                    int n19 = 0;
                    while (streamTokenizer.ttype != 125) {
                        PdVector pdVector = new PdVector();
                        if (!this.parseVector(streamTokenizer, pdVector, this.m_dim)) {
                            return false;
                        }
                        vector9.addElement(pdVector);
                        ++n19;
                        streamTokenizer.nextToken();
                    }
                    PgJvxSrc pgJvxSrc = new PgJvxSrc();
                    pgJvxSrc.setDimOfVertices(this.m_dim);
                    pgJvxSrc.setNumVertices(n19);
                    int n20 = 0;
                    while (n20 < n19) {
                        pgJvxSrc.setVertex(n20, (PdVector)vector9.elementAt(n20));
                        ++n20;
                    }
                    ++n9;
                    vector6.addElement(pgJvxSrc);
                    streamTokenizer.nextToken();
                    vectorArray2[8].addElement(vector.elementAt(n13));
                    continue;
                }
                if ("Arrow".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    PdVector[] pdVectorArray = new PdVector[2];
                    pdVectorArray[0] = new PdVector(this.m_dim);
                    if (!this.parseVector(streamTokenizer, pdVectorArray[0], this.m_dim)) {
                        return false;
                    }
                    streamTokenizer.nextToken();
                    pdVectorArray[1] = new PdVector(this.m_dim);
                    if (!this.parseVector(streamTokenizer, pdVectorArray[1], this.m_dim)) {
                        return false;
                    }
                    vector5.addElement(pdVectorArray);
                    while (streamTokenizer.ttype != 93) {
                        streamTokenizer.nextToken();
                    }
                    ++n8;
                    continue;
                }
                if ("Circle".equals(streamTokenizer.sval)) {
                    if (this.m_dim != 2) {
                        PsDebug.warning("Wrong dimension of graphics primitive Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    streamTokenizer.nextToken();
                    PdVector pdVector = new PdVector();
                    if (!this.parseVector(streamTokenizer, pdVector, 2)) {
                        return false;
                    }
                    pdVector.setSize(3);
                    streamTokenizer.nextToken();
                    pdVector.m_data[2] = this.readNumber(streamTokenizer);
                    streamTokenizer.nextToken();
                    ++n10;
                    vector7.addElement(pdVector);
                    continue;
                }
                if ("Disk".equals(streamTokenizer.sval)) {
                    if (this.m_dim != 2) {
                        PsDebug.warning("Wrong dimension of graphics primitive Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    streamTokenizer.nextToken();
                    PdVector pdVector = new PdVector();
                    if (!this.parseVector(streamTokenizer, pdVector, 2)) {
                        return false;
                    }
                    pdVector.setSize(3);
                    streamTokenizer.nextToken();
                    pdVector.m_data[2] = this.readNumber(streamTokenizer);
                    streamTokenizer.nextToken();
                    ++n11;
                    vector8.addElement(pdVector);
                    continue;
                }
                if ("Rectangle".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    PdVector pdVector = new PdVector();
                    if (!this.parseVector(streamTokenizer, pdVector, 2)) {
                        return false;
                    }
                    streamTokenizer.nextToken();
                    PdVector pdVector2 = new PdVector();
                    if (!this.parseVector(streamTokenizer, pdVector2, 2)) {
                        return false;
                    }
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == 93) {
                        if (this.m_dim != 2) {
                            PsDebug.warning("Wrong dimension of graphics primitive Line: " + streamTokenizer.lineno());
                            return false;
                        }
                        PiVector piVector6 = new PiVector(4);
                        int n21 = 0;
                        do {
                            piVector6.m_data[n21] = n12 + n21;
                        } while (++n21 < 4);
                        vector3.addElement(piVector6);
                        ++n6;
                        PdVector[] pdVectorArray = new PdVector[]{pdVector, new PdVector(pdVector2.m_data[0], pdVector.m_data[1]), pdVector2, new PdVector(pdVector.m_data[0], pdVector2.m_data[1])};
                        n2 = 0;
                        do {
                            vector2.addElement(pdVectorArray[n2]);
                        } while (++n2 < 4);
                        n5 += 4;
                        n12 += 4;
                        n2 = 0;
                        do {
                            vectorArray2[n2].addElement(vectorArray[n2].elementAt(n13));
                        } while (++n2 <= 6);
                        piVector3.addEntry(piVector.m_data[n13]);
                        piVector4.addEntry(piVector2.m_data[n13]);
                        continue;
                    }
                    string = string + "Rectangle[{" + pdVector.m_data[0] + "," + pdVector.m_data[1] + "},{" + pdVector2.m_data[0] + "," + pdVector2.m_data[1] + "}" + streamTokenizer.sval;
                    int n22 = 1;
                    while (n22 != 0) {
                        if (streamTokenizer.ttype == -1) {
                            PsDebug.warning("']' missing Line: " + streamTokenizer.lineno());
                            return false;
                        }
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == 93) {
                            --n22;
                            string = string + "]";
                        }
                        if (streamTokenizer.ttype == 91) {
                            ++n22;
                            string = string + "[";
                        }
                        if (streamTokenizer.ttype == -3) {
                            string = string + streamTokenizer.sval;
                            continue;
                        }
                        if (streamTokenizer.ttype == -2) {
                            streamTokenizer.pushBack();
                            string = string + Double.toString(this.readNumber(streamTokenizer));
                            continue;
                        }
                        if (streamTokenizer.ttype == 123) {
                            string = string + "{";
                            continue;
                        }
                        if (streamTokenizer.ttype == 125) {
                            string = string + "}";
                            continue;
                        }
                        if (streamTokenizer.ttype == 44) {
                            string = string + ",";
                            continue;
                        }
                        if (streamTokenizer.ttype == 42) {
                            string = string + "*";
                            continue;
                        }
                        if (streamTokenizer.ttype != 94) continue;
                        string = string + "^";
                    }
                    continue;
                }
                if ("Cuboid".equals(streamTokenizer.sval)) {
                    if (this.m_dim != 3) {
                        PsDebug.warning("Wrong dimension of graphics primitive Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    streamTokenizer.nextToken();
                    PdVector pdVector = new PdVector();
                    if (!this.parseVector(streamTokenizer, pdVector, 3)) {
                        return false;
                    }
                    streamTokenizer.nextToken();
                    PdVector pdVector3 = new PdVector();
                    if (streamTokenizer.ttype == 44) {
                        if (!this.parseVector(streamTokenizer, pdVector3, 3)) {
                            return false;
                        }
                        streamTokenizer.nextToken();
                    } else {
                        pdVector3 = PdVector.copyNew(pdVector);
                        pdVector3.add(1.0);
                    }
                    PiVector[] piVectorArray = new PiVector[]{new PiVector(n12, n12 + 4, n12 + 5, n12 + 1), new PiVector(n12 + 3, n12 + 2, n12 + 6, n12 + 7), new PiVector(n12, n12 + 1, n12 + 2, n12 + 3), new PiVector(n12 + 4, n12 + 7, n12 + 6, n12 + 5), new PiVector(n12 + 1, n12 + 5, n12 + 6, n12 + 2), new PiVector(n12, n12 + 3, n12 + 7, n12 + 4)};
                    int n23 = 0;
                    do {
                        vector3.addElement(piVectorArray[n23]);
                    } while (++n23 < 6);
                    n6 += 6;
                    n12 += 8;
                    PdVector[] pdVectorArray = new PdVector[]{pdVector, new PdVector(pdVector3.m_data[0], pdVector.m_data[1], pdVector.m_data[2]), new PdVector(pdVector3.m_data[0], pdVector.m_data[1], pdVector3.m_data[2]), new PdVector(pdVector.m_data[0], pdVector.m_data[1], pdVector3.m_data[2]), new PdVector(pdVector.m_data[0], pdVector3.m_data[1], pdVector.m_data[2]), new PdVector(pdVector3.m_data[0], pdVector3.m_data[1], pdVector.m_data[2]), pdVector3, new PdVector(pdVector.m_data[0], pdVector3.m_data[1], pdVector3.m_data[2])};
                    n2 = 0;
                    do {
                        vector2.addElement(pdVectorArray[n2]);
                    } while (++n2 < 8);
                    n5 += 8;
                    n2 = 0;
                    do {
                        int n24 = 0;
                        do {
                            vectorArray2[n24].addElement(vectorArray[n24].elementAt(n13));
                        } while (++n24 <= 6);
                        piVector3.addEntry(piVector.m_data[n13]);
                        piVector4.addEntry(piVector2.m_data[n13]);
                    } while (++n2 < 6);
                    continue;
                }
                if ("RGBColor".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "CMYKColor".equals(streamTokenizer.sval)) {
                    bl = true;
                    Color color = this.readColor(streamTokenizer);
                    vector.setElementAt(color, n13);
                    int n25 = 4;
                    do {
                        vectorArray[n25].setElementAt(color, n13);
                    } while (++n25 <= 5);
                    if (this.m_dim == 3) continue;
                    n25 = 0;
                    do {
                        vectorArray[n25].setElementAt(color, n13);
                    } while (++n25 <= 3);
                    piVector.m_data[n13] = 1;
                    piVector2.m_data[n13] = 1;
                    continue;
                }
                if ("SurfaceColor".equals(streamTokenizer.sval)) {
                    bl = true;
                    Color[] colorArray = new Color[2];
                    piVector.m_data[n13] = this.readSurfaceColor(streamTokenizer, colorArray);
                    Color color = colorArray[0];
                    Color color2 = colorArray[1];
                    piVector2.m_data[n13] = piVector.m_data[n13];
                    int n26 = 0;
                    do {
                        vectorArray[n26].setElementAt(color, n13);
                    } while (++n26 <= 1);
                    n26 = 2;
                    do {
                        vectorArray[n26].setElementAt(color2, n13);
                    } while (++n26 <= 3);
                    continue;
                }
                if ("EdgeForm".equals(streamTokenizer.sval)) {
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == 93) {
                        bl3 = false;
                    }
                    while (streamTokenizer.ttype != 93) {
                        if (streamTokenizer.ttype == -3) {
                            if ("RGBColor".equals(streamTokenizer.sval) || "CMYKColor".equals(streamTokenizer.sval) || "Hue".equals(streamTokenizer.sval) || "GrayLevel".equals(streamTokenizer.sval)) {
                                bl2 = true;
                                Color color = this.readColor(streamTokenizer);
                                vectorArray[6].setElementAt(color, n13);
                                streamTokenizer.nextToken();
                            }
                            if (!"Thickness".equals(streamTokenizer.sval)) continue;
                            streamTokenizer.nextToken();
                            d = 200.0 * this.readNumber(streamTokenizer);
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            continue;
                        }
                        streamTokenizer.nextToken();
                    }
                    continue;
                }
                if ("FaceForm".equals(streamTokenizer.sval)) {
                    Color[] colorArray;
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    bl = true;
                    if ("SurfaceColor".equals(streamTokenizer.sval)) {
                        colorArray = new Color[2];
                        piVector.m_data[n13] = this.readSurfaceColor(streamTokenizer, colorArray);
                        Color color = colorArray[0];
                        Color color3 = colorArray[1];
                        vectorArray[0].setElementAt(color, n13);
                        vectorArray[2].setElementAt(color3, n13);
                    } else {
                        colorArray = this.readColor(streamTokenizer);
                        vectorArray[4].setElementAt(colorArray, n13);
                    }
                    streamTokenizer.nextToken();
                    boolean bl4 = true;
                    if (streamTokenizer.ttype == 44) {
                        Color[] colorArray2;
                        streamTokenizer.nextToken();
                        if ("SurfaceColor".equals(streamTokenizer.sval)) {
                            colorArray2 = new Color[2];
                            piVector2.m_data[n13] = this.readSurfaceColor(streamTokenizer, colorArray2);
                            Color color = colorArray2[0];
                            Color color4 = colorArray2[1];
                            vectorArray[1].setElementAt(color, n13);
                            vectorArray[3].setElementAt(color4, n13);
                        } else {
                            bl4 = false;
                            colorArray2 = this.readColor(streamTokenizer);
                            vectorArray[5].setElementAt(colorArray2, n13);
                        }
                        streamTokenizer.nextToken();
                        continue;
                    }
                    if (bl4) {
                        vectorArray[1].setElementAt(vectorArray[0].elementAt(n13), n13);
                        vectorArray[3].setElementAt(vectorArray[2].elementAt(n13), n13);
                        piVector2.m_data[n13] = piVector.m_data[n13];
                        continue;
                    }
                    vectorArray[5].setElementAt(vectorArray[4].elementAt(n13), n13);
                    continue;
                }
                PsDebug.warning("skipping " + streamTokenizer.sval + " Line: " + streamTokenizer.lineno());
                string = string + streamTokenizer.sval;
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != 91) {
                    PsDebug.warning("'[' expected Line: " + streamTokenizer.lineno());
                    return false;
                }
                int n27 = 1;
                string = string + "[";
                while (n27 != 0) {
                    if (streamTokenizer.ttype == -1) {
                        PsDebug.warning("']' missing Line: " + streamTokenizer.lineno());
                        return false;
                    }
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == 93) {
                        --n27;
                        string = string + "]";
                    }
                    if (streamTokenizer.ttype == 91) {
                        ++n27;
                        string = string + "[";
                    }
                    if (streamTokenizer.ttype == -3) {
                        string = string + streamTokenizer.sval;
                        continue;
                    }
                    if (streamTokenizer.ttype == -2) {
                        streamTokenizer.pushBack();
                        string = string + Double.toString(this.readNumber(streamTokenizer));
                        continue;
                    }
                    if (streamTokenizer.ttype == 123) {
                        string = string + "{";
                        continue;
                    }
                    if (streamTokenizer.ttype == 125) {
                        string = string + "}";
                        continue;
                    }
                    if (streamTokenizer.ttype == 44) {
                        string = string + ",";
                        continue;
                    }
                    if (streamTokenizer.ttype == 42) {
                        string = string + "*";
                        continue;
                    }
                    if (streamTokenizer.ttype != 94) continue;
                    string = string + "^";
                }
            }
            boolean bl5 = true;
            boolean bl6 = true;
            streamTokenizer.nextToken();
            int n28 = 1;
            while (n28 != 0) {
                if (streamTokenizer.ttype == -1) {
                    PsDebug.warning("']' missing Line: " + streamTokenizer.lineno());
                    return false;
                }
                if (streamTokenizer.ttype == 93) {
                    --n28;
                }
                if (streamTokenizer.ttype == 91) {
                    ++n28;
                }
                if (streamTokenizer.ttype == -3 && !this.readOptions(streamTokenizer)) {
                    if ("AxesLabel".equals(streamTokenizer.sval)) {
                        this.readAxesLabel(streamTokenizer, this.m_dim);
                    } else if ("HiddenSurface".equals(streamTokenizer.sval)) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        bl6 = "True".equals(streamTokenizer.sval);
                    } else if ("Shading".equals(streamTokenizer.sval)) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        bl5 = "True".equals(streamTokenizer.sval);
                    }
                }
                streamTokenizer.ordinaryChar(45);
                streamTokenizer.nextToken();
            }
            int n29 = 0;
            if (n6 != 0) {
                ++n29;
            }
            if (n7 != 0) {
                ++n29;
            }
            if (n8 != 0) {
                ++n29;
            }
            if (n9 != 0) {
                ++n29;
            }
            this.m_geom = new PgJvxSrc[n29];
            n2 = 0;
            if (n6 != 0) {
                PgJvxSrc pgJvxSrc = new PgJvxSrc();
                pgJvxSrc.setType(33);
                pgJvxSrc.setDimOfVertices(this.m_dim);
                pgJvxSrc.setNumVertices(n5);
                int n30 = 0;
                while (n30 < n5) {
                    pgJvxSrc.setVertex(n30, (PdVector)vector2.elementAt(n30));
                    ++n30;
                }
                pgJvxSrc.setDimOfElements(-1);
                pgJvxSrc.setNumElements(n6);
                n30 = 0;
                while (n30 < n6) {
                    pgJvxSrc.setElement(n30, (PiVector)vector3.elementAt(n30));
                    ++n30;
                }
                PgMathLoader.geomInitType(pgJvxSrc);
                if (bl3) {
                    pgJvxSrc.showEdges(true);
                } else {
                    pgJvxSrc.showEdges(false);
                }
                pgJvxSrc.setGlobalEdgeSize(d);
                pgJvxSrc.showElementColors(bl5);
                pgJvxSrc.showElementBackColors(bl5);
                pgJvxSrc.showElements(bl6);
                Color[][] colorArrayArray = new Color[4][];
                int n31 = 0;
                do {
                    colorArrayArray[n31] = new Color[n6];
                } while (++n31 <= 3);
                if (bl) {
                    if (this.m_displayOption.hasTag(17)) {
                        n31 = 0;
                        while (n31 < n6) {
                            n = 0;
                            do {
                                colorArrayArray[n][n31] = (Color)vectorArray2[n].elementAt(n31);
                            } while (++n <= 3);
                            ++n31;
                        }
                    } else {
                        n31 = 0;
                        while (n31 < n6) {
                            colorArrayArray[0][n31] = (Color)vectorArray2[4].elementAt(n31);
                            colorArrayArray[1][n31] = (Color)vectorArray2[5].elementAt(n31);
                            ++n31;
                        }
                    }
                    pgJvxSrc.setElementColors(colorArrayArray[0]);
                    pgJvxSrc.setElementBackColors(colorArrayArray[1]);
                    if (bl2) {
                        Color[] colorArray = new Color[n6];
                        n = 0;
                        while (n < n6) {
                            colorArray[n] = (Color)vectorArray2[6].elementAt(n);
                            ++n;
                        }
                    }
                } else {
                    n31 = 0;
                    while (n31 < n6) {
                        n = 0;
                        do {
                            colorArrayArray[n][n31] = Color.white;
                        } while (++n <= 3);
                        ++n31;
                    }
                    pgJvxSrc.setElementColors(colorArrayArray[0]);
                    pgJvxSrc.setElementBackColors(colorArrayArray[1]);
                }
                this.m_geom[n2] = pgJvxSrc;
                this.m_geom[n2].setName("ElementSet imported from Mathematica");
                ++n2;
            }
            if (n7 != 0) {
                PgJvxSrc pgJvxSrc = new PgJvxSrc();
                pgJvxSrc.setType(30);
                PgMathLoader.geomInitType(pgJvxSrc);
                pgJvxSrc.setDimOfVertices(this.m_dim);
                pgJvxSrc.setNumVertices(n7);
                int n32 = 0;
                while (n32 < n7) {
                    pgJvxSrc.setVertex(n32, (PdVector)vector4.elementAt(n32));
                    ++n32;
                }
                if (bl) {
                    Color[] colorArray = new Color[n7];
                    int n33 = 0;
                    while (n33 < n7) {
                        colorArray[n33] = (Color)vectorArray2[7].elementAt(n33);
                        ++n33;
                    }
                    pgJvxSrc.setVertexColors(colorArray);
                }
                this.m_geom[n2] = pgJvxSrc;
                this.m_geom[n2].setName("PointSet imported from Mathematica");
                ++n2;
            }
            if (n8 != 0) {
                PgJvxSrc pgJvxSrc = new PgJvxSrc();
                pgJvxSrc.setType(36);
                PgMathLoader.geomInitType(pgJvxSrc);
                pgJvxSrc.setDimOfVertices(this.m_dim);
                pgJvxSrc.setNumVertices(n8);
                pgJvxSrc.setNumVectorFields(1);
                pgJvxSrc.setNumVectors(0, n8, this.m_dim);
                PdVector[] pdVectorArray = new PdVector[n8];
                PdVector[] pdVectorArray2 = new PdVector[n8];
                n = 0;
                while (n < n8) {
                    pdVectorArray[n] = ((PdVector[])vector5.elementAt(n))[0];
                    pdVectorArray2[n] = PdVector.subNew(((PdVector[])vector5.elementAt(n))[1], pdVectorArray[n]);
                    ++n;
                }
                pgJvxSrc.setVertices(pdVectorArray);
                pgJvxSrc.setVectors(0, pdVectorArray2);
                pgJvxSrc.showVectorArrows(0, true);
                pgJvxSrc.setGlobalVectorColor(0, Color.black);
                this.m_geom[n2] = pgJvxSrc;
                this.m_geom[n2].setName("VectorField imported from Mathematica");
                ++n2;
            }
            if (n9 != 0) {
                int n34;
                int n35;
                PgJvxSrc[] pgJvxSrcArray = new PgJvxSrc[n9];
                int n36 = 0;
                int n37 = 0;
                while (n37 < n9) {
                    pgJvxSrcArray[n37] = (PgJvxSrc)vector6.elementAt(n37);
                    n36 += pgJvxSrcArray[n37].getNumVertices();
                    ++n37;
                }
                PgJvxSrc pgJvxSrc = new PgJvxSrc();
                pgJvxSrc.setType(32);
                PgMathLoader.geomInitType(pgJvxSrc);
                pgJvxSrc.showVertices(false);
                pgJvxSrc.setDimOfVertices(this.m_dim);
                pgJvxSrc.setNumVertices(n36);
                n = 0;
                int n38 = 0;
                while (n38 < n9) {
                    n35 = pgJvxSrcArray[n38].getNumVertices();
                    PdVector[] pdVectorArray = pgJvxSrcArray[n38].getVertices();
                    n34 = 0;
                    while (n34 < n35) {
                        pgJvxSrc.setVertex(n, pdVectorArray[n34]);
                        ++n;
                        ++n34;
                    }
                    ++n38;
                }
                pgJvxSrc.setDimOfPolygons(-1);
                pgJvxSrc.setNumPolygons(n9);
                PiVector[] piVectorArray = pgJvxSrc.getPolygons();
                n35 = 0;
                int n39 = 0;
                while (n39 < n9) {
                    n34 = pgJvxSrcArray[n39].getNumVertices();
                    piVectorArray[n39].setSize(n34);
                    int n40 = 0;
                    while (n40 < n34) {
                        piVectorArray[n39].m_data[n40] = n40 + n35;
                        ++n40;
                    }
                    n35 += n34;
                    ++n39;
                }
                if (bl) {
                    Color[] colorArray = new Color[n9];
                    n34 = 0;
                    while (n34 < n9) {
                        colorArray[n34] = (Color)vectorArray2[8].elementAt(n34);
                        ++n34;
                    }
                    pgJvxSrc.setPolygonColors(colorArray);
                }
                this.m_geom[n2] = pgJvxSrc;
                this.m_geom[n2].setName("PgPolygonSet imported from Mathematica");
                ++n2;
            }
            if (n10 != 0) {
                PsDebug.warning(n10 + " circles found in Mathematica graphics object. Circles get ignored in JavaView.");
            }
            if (n11 != 0) {
                PsDebug.warning(n11 + " discs found in Mathematica graphics object. Discs get ignored in JavaView.");
            }
            streamTokenizer.parseNumbers();
            streamTokenizer.pushBack();
            if (n29 <= 0) {
                PsDebug.warning("No graphics found");
                return false;
            }
            this.graphicsVector.addElement(this.m_geom);
            return true;
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return false;
        }
    }

    private boolean parseVector(StreamTokenizer streamTokenizer, PdVector pdVector, int n) {
        pdVector.setSize(n);
        try {
            streamTokenizer.nextToken();
            int n2 = 0;
            while (n2 < n) {
                pdVector.m_data[n2] = this.readNumber(streamTokenizer);
                streamTokenizer.nextToken();
                ++n2;
            }
            return true;
        }
        catch (Exception exception) {
            PsDebug.warning("parseVector throw exception - st.ttype&sval:" + streamTokenizer.ttype + " " + streamTokenizer.sval);
            PsDebug.warning("Exception thrown: " + exception + " Line: " + streamTokenizer.lineno());
            return false;
        }
    }

    public void setKeyAnimation(boolean bl) {
        this.m_isKeyAnimation = bl;
    }
}

