/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import jv.loader.PgLoader;
import jv.number.PdColor;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;
import jv.vecmath.P_Vector;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuData;

public class PsXmlLoader {
    private static final int UNKNOWN = -1;
    private static final int TRUE = 1;
    private static final int FALSE = 0;

    public static void parseVectorAttr(P_Vector p_Vector, PsXmlNode psXmlNode, String[] stringArray) {
        if (p_Vector == null || psXmlNode == null || stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = psXmlNode.getAttribute(stringArray[n]);
            if (string != null) {
                if (string.equalsIgnoreCase("mark")) {
                    p_Vector.setTag(1);
                } else if (stringArray[n].equalsIgnoreCase("name")) {
                    p_Vector.setName(string);
                } else {
                    PsDebug.warning("unknown attribute = " + stringArray[n]);
                    stringArray = null;
                    return;
                }
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean parse(BufferedReader bufferedReader, PsXmlSrc psXmlSrc) throws IOException {
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.ordinaryChars(48, 48);
        streamTokenizer.ordinaryChars(49, 57);
        streamTokenizer.ordinaryChar(124);
        streamTokenizer.ordinaryChar(60);
        streamTokenizer.ordinaryChar(62);
        streamTokenizer.ordinaryChar(47);
        streamTokenizer.ordinaryChar(33);
        streamTokenizer.ordinaryChar(63);
        streamTokenizer.ordinaryChar(91);
        streamTokenizer.ordinaryChar(93);
        streamTokenizer.ordinaryChar(45);
        streamTokenizer.ordinaryChar(43);
        streamTokenizer.ordinaryChar(46);
        streamTokenizer.ordinaryChar(39);
        streamTokenizer.ordinaryChar(92);
        streamTokenizer.ordinaryChar(96);
        streamTokenizer.ordinaryChar(180);
        streamTokenizer.ordinaryChar(176);
        streamTokenizer.wordChars(124, 124);
        streamTokenizer.wordChars(39, 39);
        streamTokenizer.wordChars(92, 92);
        streamTokenizer.wordChars(96, 96);
        streamTokenizer.wordChars(180, 180);
        streamTokenizer.wordChars(176, 176);
        streamTokenizer.wordChars(35, 35);
        streamTokenizer.wordChars(94, 94);
        streamTokenizer.wordChars(38, 38);
        streamTokenizer.wordChars(36, 36);
        streamTokenizer.wordChars(40, 40);
        streamTokenizer.wordChars(41, 41);
        streamTokenizer.wordChars(126, 126);
        streamTokenizer.wordChars(64, 64);
        streamTokenizer.wordChars(45, 45);
        streamTokenizer.wordChars(43, 43);
        streamTokenizer.wordChars(42, 42);
        streamTokenizer.wordChars(48, 48);
        streamTokenizer.wordChars(49, 57);
        streamTokenizer.wordChars(46, 46);
        streamTokenizer.wordChars(44, 44);
        streamTokenizer.wordChars(59, 59);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.wordChars(58, 58);
        streamTokenizer.whitespaceChars(61, 61);
        int n = 0;
        PsXmlNode psXmlNode = null;
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = true;
        try {
            block17: while (true) {
                switch (streamTokenizer.nextToken()) {
                    default: {
                        PsDebug.warning("parsing broke abnormally\n\t in line=" + streamTokenizer.lineno() + " reading st.sval=" + streamTokenizer.sval + ", st.ttype=" + streamTokenizer.ttype);
                        return false;
                    }
                    case 10: {
                        if (!bl2 || psXmlNode == null || !psXmlNode.hasContent()) continue block17;
                        psXmlNode.appendContent("\n");
                        continue block17;
                    }
                    case -1: {
                        if (n > 0) {
                            PsDebug.warning("missing closing element");
                            if (psXmlNode != null) {
                                PsDebug.warning("current element = " + psXmlNode.getType());
                            }
                            return false;
                        }
                        if (n < 0) {
                            PsDebug.warning("too many closing element");
                            if (psXmlNode != null) {
                                PsDebug.warning("current element = " + psXmlNode.getType());
                            }
                            return false;
                        }
                        while (true) {
                            if (psXmlNode == null || psXmlNode.getFather() == null) {
                                psXmlSrc.setRootNode(psXmlNode);
                                return true;
                            }
                            psXmlNode = psXmlNode.getFather();
                        }
                    }
                    case 60: {
                        bl4 = false;
                        streamTokenizer.ordinaryChar(47);
                        streamTokenizer.ordinaryChar(34);
                        streamTokenizer.quoteChar(34);
                        if (bl2 && psXmlNode != null && psXmlNode.hasContent() && (string = psXmlNode.getContent()).endsWith("\n")) {
                            string = string.substring(0, string.length() - 1);
                            psXmlNode.setContent(string);
                        }
                        bl2 = false;
                        int n2 = streamTokenizer.nextToken();
                        if (n2 == 33 || n2 == 63) {
                            streamTokenizer.nextToken();
                            if (streamTokenizer.sval.equals("xml")) {
                                while (streamTokenizer.nextToken() != 62) {
                                }
                                continue block17;
                            }
                            if (streamTokenizer.sval.equals("DOCTYPE")) {
                                streamTokenizer.nextToken();
                                if (streamTokenizer.sval != null) {
                                    psXmlSrc.setDocName(streamTokenizer.sval);
                                } else {
                                    PsDebug.warning("missing DTD doc name.");
                                }
                                int n3 = streamTokenizer.nextToken();
                                if (streamTokenizer.sval != null && streamTokenizer.sval.equals("SYSTEM")) {
                                    streamTokenizer.nextToken();
                                    if (streamTokenizer.sval != null) {
                                        psXmlSrc.setDocType(streamTokenizer.sval);
                                        continue block17;
                                    }
                                    PsDebug.warning("missing DTD doc type.");
                                    continue block17;
                                }
                                if (n3 == 91) {
                                    bl3 = true;
                                    continue block17;
                                }
                                PsDebug.warning("error while parsing doctype.\n\t in line=" + streamTokenizer.lineno() + " reading st.sval=" + streamTokenizer.sval + ", st.ttype=" + streamTokenizer.ttype);
                                continue block17;
                            }
                            if (streamTokenizer.sval.equals("ENTITY")) {
                                while (streamTokenizer.nextToken() != 62) {
                                }
                                continue block17;
                            }
                            if (streamTokenizer.sval.equals("ELEMENT")) {
                                while (streamTokenizer.nextToken() != 62) {
                                }
                                continue block17;
                            }
                            if (streamTokenizer.sval.equals("ATTLIST")) {
                                while (streamTokenizer.nextToken() != 62) {
                                }
                                continue block17;
                            }
                            if (streamTokenizer.sval.equals("--")) {
                                while (streamTokenizer.nextToken() != 62) {
                                }
                                continue block17;
                            }
                            PsDebug.warning("unknown command.\n\t in line=" + streamTokenizer.lineno() + " reading st.sval=" + streamTokenizer.sval + ", st.ttype=" + streamTokenizer.ttype);
                            while (streamTokenizer.nextToken() != 62) {
                            }
                            continue block17;
                        }
                        if (n2 == 47) {
                            --n;
                            streamTokenizer.nextToken();
                            if (!streamTokenizer.sval.equals(psXmlNode.getType())) {
                                psXmlNode = psXmlNode.getFather();
                            }
                            if (psXmlNode.isMixedMode() && psXmlNode.hasContent()) {
                                psXmlNode.addMixedContent(psXmlNode.getContent());
                                psXmlNode.setContent(null);
                            }
                            psXmlNode.expand(false);
                            continue block17;
                        }
                        if (bl5) {
                            bl5 = false;
                            streamTokenizer.wordChars(33, 33);
                            streamTokenizer.wordChars(63, 63);
                            streamTokenizer.wordChars(91, 91);
                            streamTokenizer.wordChars(93, 93);
                        }
                        ++n;
                        PsXmlNode psXmlNode2 = new PsXmlNode(streamTokenizer.sval);
                        if (psXmlNode != null) {
                            if (psXmlNode.isExpanded()) {
                                psXmlNode.addChild(psXmlNode2);
                                if (!psXmlNode.isMixedMode() && psXmlNode.hasContent()) {
                                    psXmlNode.setMixedMode(true);
                                }
                                if (psXmlNode.isMixedMode()) {
                                    if (psXmlNode.hasContent()) {
                                        psXmlNode.addMixedContent(psXmlNode.getContent());
                                        psXmlNode.setContent(null);
                                    }
                                    psXmlNode.addMixedContent(psXmlNode2);
                                }
                            } else {
                                psXmlNode.setSibling(psXmlNode2);
                            }
                        }
                        psXmlNode = psXmlNode2;
                        psXmlNode.expand(true);
                        bl = true;
                        streamTokenizer.whitespaceChars(61, 61);
                        continue block17;
                    }
                    case 62: {
                        bl = false;
                        streamTokenizer.ordinaryChar(61);
                        streamTokenizer.wordChars(61, 61);
                        bl4 = true;
                        streamTokenizer.ordinaryChar(34);
                        streamTokenizer.wordChars(34, 34);
                        streamTokenizer.wordChars(47, 47);
                        continue block17;
                    }
                    case 93: {
                        if (bl3) {
                            bl3 = false;
                            continue block17;
                        }
                        if (!bl4) continue block17;
                        if (!psXmlNode.isMixedMode() && psXmlNode.getChild() != null) {
                            psXmlNode.setMixedMode(true);
                            psXmlNode.addMixedContent(psXmlNode.getChild());
                        }
                        psXmlNode.appendContent("]");
                        continue block17;
                    }
                    case 47: {
                        if (bl) {
                            if (streamTokenizer.nextToken() != 62) {
                                PsDebug.error("found '/' in attribute mode, error in line=" + streamTokenizer.lineno());
                                return false;
                            }
                            bl = false;
                            --n;
                            psXmlNode.expand(false);
                            continue block17;
                        }
                        if (!psXmlNode.isMixedMode() && psXmlNode.getChild() != null) {
                            psXmlNode.setMixedMode(true);
                            psXmlNode.addMixedContent(psXmlNode.getChild());
                        }
                        psXmlNode.appendContent("/");
                        bl2 = true;
                        continue block17;
                    }
                    case 91: {
                        if (bl4) {
                            if (!psXmlNode.isMixedMode() && psXmlNode.getChild() != null) {
                                psXmlNode.setMixedMode(true);
                                psXmlNode.addMixedContent(psXmlNode.getChild());
                            }
                            psXmlNode.appendContent(" [");
                            continue block17;
                        }
                    }
                    case 34: {
                        if (!bl4) continue block17;
                        if (!psXmlNode.isMixedMode() && psXmlNode.getChild() != null) {
                            psXmlNode.setMixedMode(true);
                            psXmlNode.addMixedContent(psXmlNode.getChild());
                        }
                        psXmlNode.appendContent("\"");
                        continue block17;
                    }
                    case 33: {
                        if (!bl4) continue block17;
                        if (!psXmlNode.isMixedMode() && psXmlNode.getChild() != null) {
                            psXmlNode.setMixedMode(true);
                            psXmlNode.addMixedContent(psXmlNode.getChild());
                        }
                        psXmlNode.appendContent("!");
                        continue block17;
                    }
                    case 63: {
                        if (!bl4) continue block17;
                        if (!psXmlNode.isMixedMode() && psXmlNode.getChild() != null) {
                            psXmlNode.setMixedMode(true);
                            psXmlNode.addMixedContent(psXmlNode.getChild());
                        }
                        psXmlNode.appendContent("?");
                        continue block17;
                    }
                    case 61: {
                        if (!bl4) continue block17;
                        if (!psXmlNode.isMixedMode() && psXmlNode.getChild() != null) {
                            psXmlNode.setMixedMode(true);
                            psXmlNode.addMixedContent(psXmlNode.getChild());
                        }
                        psXmlNode.appendContent("=");
                        continue block17;
                    }
                    case -3: {
                        if (bl) {
                            String string2 = streamTokenizer.sval;
                            streamTokenizer.nextToken();
                            String string3 = streamTokenizer.sval;
                            psXmlNode.addAttribute(string2, string3);
                            continue block17;
                        }
                        if (!psXmlNode.isExpanded()) {
                            psXmlNode = psXmlNode.getFather();
                        }
                        if (!psXmlNode.isMixedMode() && psXmlNode.getChild() != null) {
                            psXmlNode.setMixedMode(true);
                            psXmlNode.addMixedContent(psXmlNode.getChild());
                        }
                        string = psXmlNode.getContent();
                        if (!psXmlNode.hasContent()) {
                            psXmlNode.setContent(streamTokenizer.sval);
                        } else if (string.endsWith("\n") || string.endsWith("/")) {
                            string = string + streamTokenizer.sval;
                            psXmlNode.setContent(string);
                        } else {
                            psXmlNode.appendContent(" " + streamTokenizer.sval);
                        }
                        bl2 = true;
                        continue block17;
                    }
                    case -2: 
                }
                if (!psXmlNode.isMixedMode() && psXmlNode.getChild() != null) {
                    psXmlNode.setMixedMode(true);
                }
                if (!psXmlNode.hasContent()) {
                    psXmlNode.setContent(String.valueOf(streamTokenizer.nval));
                } else {
                    psXmlNode.appendContent(" " + String.valueOf(streamTokenizer.nval));
                }
                bl2 = true;
            }
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown in line=" + streamTokenizer.lineno() + ", Exception = " + exception);
            return false;
        }
    }

    public static PsXmlSrc read(String string) {
        BufferedReader bufferedReader = PsUtil.open(string);
        if (bufferedReader == null) {
            PsDebug.warning("could not open file = " + string);
            return null;
        }
        PsXmlSrc psXmlSrc = PsXmlLoader.read(bufferedReader);
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        if (psXmlSrc == null) {
            PsDebug.warning("error when reading file = " + string);
            return null;
        }
        return psXmlSrc;
    }

    public static PsXmlSrc read(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning("missing buffered reader");
            return null;
        }
        PsXmlSrc psXmlSrc = new PsXmlSrc();
        try {
            boolean bl = PsXmlLoader.parse(bufferedReader, psXmlSrc);
            if (!bl) {
                PsDebug.warning("failed reading stream = " + bufferedReader);
                return null;
            }
        }
        catch (IOException iOException) {
            PsDebug.warning("failed reading stream = " + bufferedReader);
            iOException.printStackTrace();
            return null;
        }
        return psXmlSrc;
    }

    public static PdVector[] parseDoubleList(PsXmlNode psXmlNode, String string, String[] stringArray) {
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes(psXmlNode, string);
        if (psXmlNodeArray == null || psXmlNodeArray.length == 0) {
            return null;
        }
        PdVector[] pdVectorArray = new PdVector[psXmlNodeArray.length];
        int n = 0;
        while (n < psXmlNodeArray.length) {
            pdVectorArray[n] = PsXmlLoader.parsePdVector(psXmlNodeArray[n], stringArray);
            if (pdVectorArray[n] == null) {
                PsDebug.warning("failed to parse vector at index = " + n);
                return null;
            }
            ++n;
        }
        return pdVectorArray;
    }

    public static void addVectorList(PsXmlNode psXmlNode, String string, PdVector[] pdVectorArray, int n) {
        if (pdVectorArray == null || pdVectorArray.length < n) {
            return;
        }
        boolean bl = "p".equals(string);
        psXmlNode.addAttribute("num", String.valueOf(n));
        int n2 = 0;
        while (n2 < n) {
            PsXmlLoader.addVector(psXmlNode, string, pdVectorArray[n2], bl);
            ++n2;
        }
    }

    public static Color parseColorContent(PsXmlNode psXmlNode) {
        if (psXmlNode == null) {
            return null;
        }
        String string = psXmlNode.getContent();
        return PdColor.parseColor(string);
    }

    public static void addVectorList(PsXmlNode psXmlNode, String string, PiVector[] piVectorArray, int n) {
        if (piVectorArray == null || piVectorArray.length < n) {
            return;
        }
        boolean bl = "e".equals(string) || "f".equals(string) || "l".equals(string);
        psXmlNode.addAttribute("num", String.valueOf(n));
        int n2 = 0;
        while (n2 < n) {
            PsXmlLoader.addVector(psXmlNode, string, piVectorArray[n2], bl);
            ++n2;
        }
    }

    public static void addVectorList(PsXmlNode psXmlNode, String string, PdVector[][] pdVectorArray, int n) {
        if (pdVectorArray == null || pdVectorArray.length < n) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            if (pdVectorArray[n2] == null) {
                return;
            }
            ++n2;
        }
        n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < pdVectorArray[n3].length) {
                psXmlNode.addChild(string, PuData.toString(pdVectorArray[n3][n4].m_data));
                ++n4;
            }
            n2 += pdVectorArray[n3].length;
            ++n3;
        }
        psXmlNode.addAttribute("num", String.valueOf(n2));
    }

    public static void addVectorList(PsXmlNode psXmlNode, String string, Color[] colorArray, int n) {
        if (colorArray == null || colorArray.length < n) {
            return;
        }
        psXmlNode.addAttribute("num", String.valueOf(n));
        int n2 = 0;
        while (n2 < n) {
            String string2 = String.valueOf(colorArray[n2].getRed()) + " " + String.valueOf(colorArray[n2].getGreen()) + " " + String.valueOf(colorArray[n2].getBlue());
            psXmlNode.addChild(string, string2);
            ++n2;
        }
    }

    public static PiVector parsePiVector(String string) {
        if (string == null) {
            PsDebug.warning("missing integer string.");
            return null;
        }
        try {
            String[] stringArray = PuString.splitString(string, ' ');
            if (stringArray == null || stringArray.length == 0) {
                PsDebug.warning("missing integer entries = " + string);
                return null;
            }
            PiVector piVector = new PiVector(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                piVector.setEntry(n, Integer.parseInt(stringArray[n]));
                ++n;
            }
            return piVector;
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning("wrong format in integer string = " + string);
            return null;
        }
    }

    public static PiVector parsePiVector(PsXmlNode psXmlNode, String string, String[] stringArray) {
        PsXmlNode psXmlNode2 = PsXmlSrc.getRsrcNode(psXmlNode, string);
        if (psXmlNode2 == null) {
            return null;
        }
        return PsXmlLoader.parsePiVector(psXmlNode2, stringArray);
    }

    public static PiVector parsePiVector(PsXmlNode psXmlNode, String[] stringArray) {
        if (psXmlNode == null) {
            PsDebug.warning("missing xml node.");
            return null;
        }
        PiVector piVector = PsXmlLoader.parsePiVector(psXmlNode.getContent());
        if (stringArray != null) {
            PsXmlLoader.parseVectorAttr(piVector, psXmlNode, stringArray);
        }
        return piVector;
    }

    public static void addVector(PsXmlNode psXmlNode, String string, PdVector pdVector, boolean bl) {
        if (pdVector == null) {
            return;
        }
        PsXmlNode psXmlNode2 = psXmlNode.addChild(string, PuData.toString(pdVector.m_data));
        if (bl && pdVector.getName() != null) {
            psXmlNode2.addAttribute("name", pdVector.getName());
        }
        if (pdVector.hasTag(1)) {
            psXmlNode2.addAttribute("tag", "mark");
        }
    }

    public static void addVector(PsXmlNode psXmlNode, String string, PiVector piVector, boolean bl) {
        if (piVector == null) {
            return;
        }
        PsXmlNode psXmlNode2 = psXmlNode.addChild(string, PuData.toString(piVector.m_data));
        if (bl && piVector.getName() != null) {
            psXmlNode2.addAttribute("name", piVector.getName());
        }
        if (piVector.hasTag(1)) {
            psXmlNode2.addAttribute("tag", "mark");
        }
    }

    public static PsXmlNode addColor(PsXmlNode psXmlNode, String string, Color color) {
        if (color == null) {
            return null;
        }
        PsXmlNode psXmlNode2 = psXmlNode.addChild(string);
        psXmlNode2.setContent(String.valueOf(color.getRed()) + " " + String.valueOf(color.getGreen()) + " " + String.valueOf(color.getBlue()));
        psXmlNode2.addAttribute("type", "rgb");
        return psXmlNode2;
    }

    public static PiVector[] parseIntegerList(PsXmlNode psXmlNode, String string, String[] stringArray) {
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes(psXmlNode, string);
        if (psXmlNodeArray == null || psXmlNodeArray.length == 0) {
            return null;
        }
        PiVector[] piVectorArray = new PiVector[psXmlNodeArray.length];
        int n = 0;
        while (n < psXmlNodeArray.length) {
            piVectorArray[n] = PsXmlLoader.parsePiVector(psXmlNodeArray[n], stringArray);
            if (piVectorArray[n] == null) {
                PsDebug.warning("failed to parse vector at index = " + n);
                return null;
            }
            ++n;
        }
        return piVectorArray;
    }

    public static Color[] parseColorList(PsXmlNode psXmlNode, String string) {
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes(psXmlNode, string);
        if (psXmlNodeArray == null || psXmlNodeArray.length == 0) {
            return null;
        }
        Color[] colorArray = new Color[psXmlNodeArray.length];
        int n = 0;
        while (n < psXmlNodeArray.length) {
            colorArray[n] = PsXmlLoader.parseColorContent(psXmlNodeArray[n]);
            if (colorArray[n] == null) {
                PsDebug.warning("failed to parse color at index = " + n);
                return null;
            }
            ++n;
        }
        return colorArray;
    }

    public static Color parseColorRGB(PsXmlNode psXmlNode, String string) {
        PsXmlNode psXmlNode2 = PsXmlSrc.getRsrcNode(psXmlNode, string);
        if (psXmlNode2 == null) {
            return null;
        }
        return PsXmlLoader.parseColorContent(psXmlNode2);
    }

    public static PdVector parsePdVector(PsXmlNode psXmlNode, String string, String[] stringArray) {
        PsXmlNode psXmlNode2 = PsXmlSrc.getRsrcNode(psXmlNode, string);
        if (psXmlNode2 == null) {
            return null;
        }
        return PsXmlLoader.parsePdVector(psXmlNode2, stringArray);
    }

    public static PdVector parsePdVector(PsXmlNode psXmlNode, String[] stringArray) {
        if (psXmlNode == null) {
            PsDebug.warning("missing xml node.");
            return null;
        }
        PdVector pdVector = PsXmlLoader.parsePdVector(psXmlNode.getContent());
        if (stringArray != null) {
            PsXmlLoader.parseVectorAttr(pdVector, psXmlNode, stringArray);
        }
        return pdVector;
    }

    public static PdVector parsePdVector(String string) {
        if (string == null) {
            PsDebug.warning("missing double string.");
            return null;
        }
        String[] stringArray = PuString.splitString(string, ' ');
        if (stringArray == null || stringArray.length == 0) {
            PsDebug.warning("missing double entries = " + string);
            return null;
        }
        PdVector pdVector = new PdVector(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            pdVector.setEntry(n, PgLoader.parseDouble(stringArray[n]));
            ++n;
        }
        return pdVector;
    }
}

