/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Date;
import jv.loader.PsXmlLoader;
import jv.loader.PvDisplayOption;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PvDisplayIf;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;
import jv.vecmath.PdVector;

public class PvDisplayLoader {
    private static final int UNKNOWN = -1;
    private static final int TRUE = 1;
    private static final int FALSE = 0;

    private static void parseOption(PvDisplayOption pvDisplayOption, int n, String string) {
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("show")) {
            pvDisplayOption.setOption(n, true);
            return;
        }
        pvDisplayOption.setOption(n, false);
    }

    protected static PvDisplayOption[] parseRsrcTree(PsXmlSrc psXmlSrc) {
        String string = null;
        String string2 = null;
        String string3 = null;
        PsXmlNode psXmlNode = psXmlSrc.getRootNode();
        if (psXmlNode == null) {
            PsDebug.warning("missing root node.");
            return null;
        }
        PsXmlNode psXmlNode2 = PsXmlSrc.getRsrcNode(psXmlNode, "version");
        if (psXmlNode2 == null) {
            PsDebug.warning("missing version information, using default.");
            string = "0.0";
            string2 = "dump";
        } else {
            string = psXmlNode2.getContent();
            string2 = psXmlNode2.getAttribute("type");
        }
        string3 = PsXmlSrc.getRsrc(psXmlNode, "abstract");
        PsXmlNode psXmlNode3 = PsXmlSrc.getRsrcNode(psXmlNode, "displays");
        if (psXmlNode3 == null) {
            PsDebug.warning("missing displays node");
            return null;
        }
        String[] stringArray = new String[]{"tag", "name"};
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes(psXmlNode3, "display");
        if (psXmlNodeArray == null || psXmlNodeArray.length == 0) {
            PsDebug.warning("missing display node");
            return null;
        }
        PvDisplayOption[] pvDisplayOptionArray = new PvDisplayOption[psXmlNodeArray.length];
        int n = 0;
        while (n < psXmlNodeArray.length) {
            PsXmlNode psXmlNode4;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            int n2;
            Object object5;
            Object object6;
            pvDisplayOptionArray[n] = new PvDisplayOption();
            pvDisplayOptionArray[n].setVersion(string);
            pvDisplayOptionArray[n].setVersionType(string2);
            pvDisplayOptionArray[n].setAbstract(string3);
            pvDisplayOptionArray[n].setTitle(psXmlNodeArray[n].getAttribute("name"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 1, psXmlNodeArray[n].getAttribute("antiAlias"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 2, psXmlNodeArray[n].getAttribute("autoRotate"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 3, psXmlNodeArray[n].getAttribute("axes"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 4, psXmlNodeArray[n].getAttribute("axesLabel"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 7, psXmlNodeArray[n].getAttribute("border"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 8, psXmlNodeArray[n].getAttribute("boundingBox"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 9, psXmlNodeArray[n].getAttribute("center"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 10, psXmlNodeArray[n].getAttribute("cross"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 11, psXmlNodeArray[n].getAttribute("depthcue"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 12, psXmlNodeArray[n].getAttribute("drawing"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 13, psXmlNodeArray[n].getAttribute("edgeAura"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 15, psXmlNodeArray[n].getAttribute("frame"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 16, psXmlNodeArray[n].getAttribute("info"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 18, psXmlNodeArray[n].getAttribute("magnet"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 19, psXmlNodeArray[n].getAttribute("single"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 20, psXmlNodeArray[n].getAttribute("sorting"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 21, psXmlNodeArray[n].getAttribute("visible"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 22, psXmlNodeArray[n].getAttribute("xyGrid"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 23, psXmlNodeArray[n].getAttribute("xzGrid"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 24, psXmlNodeArray[n].getAttribute("yzGrid"));
            PvDisplayLoader.parseOption(pvDisplayOptionArray[n], 25, psXmlNodeArray[n].getAttribute("zBuffer"));
            PsXmlNode psXmlNode5 = PsXmlSrc.getRsrcNode(psXmlNodeArray[n], "cameras");
            if (psXmlNode5 != null) {
                object6 = psXmlNode5.getAttribute("select");
                int n3 = -1;
                int n4 = 0;
                while (n4 < PvDisplayIf.CAMERA_NAME.length) {
                    if (((String)object6).equals(PvDisplayIf.CAMERA_NAME[n4])) {
                        n3 = n4;
                        break;
                    }
                    ++n4;
                }
                if (n3 == -1) {
                    PsDebug.warning("unknown selected camera type = " + (String)object6);
                    n3 = 0;
                }
                pvDisplayOptionArray[n].setCurrentCamera(n3);
                object5 = PsXmlSrc.getRsrcNodes(psXmlNode5, "camera");
                if (object5 != null) {
                    pvDisplayOptionArray[n].setNumCameras(((PsXmlNode[])object5).length);
                    n2 = 0;
                    while (n2 < ((Object)object5).length) {
                        String string4;
                        double d;
                        object6 = ((PsXmlNode)object5[n2]).getAttribute("projection");
                        n3 = -1;
                        n4 = 0;
                        while (n4 < PvDisplayIf.CAMERA_NAME.length) {
                            if (((String)object6).equals(PvDisplayIf.CAMERA_NAME[n4])) {
                                n3 = n4;
                                break;
                            }
                            ++n4;
                        }
                        if (n3 == -1) {
                            PsDebug.warning("unknown type of camera[" + n4 + "], type = " + (String)object6);
                            n3 = 0;
                        }
                        pvDisplayOptionArray[n].setCameraProjection(n2, n3);
                        object4 = PsXmlLoader.parsePdVector((PsXmlNode)object5[n2], "position", stringArray);
                        if (object4 != null) {
                            pvDisplayOptionArray[n].setCameraPosition(n2, (PdVector)object4);
                        }
                        if ((object4 = PsXmlLoader.parsePdVector((PsXmlNode)object5[n2], "interest", stringArray)) != null) {
                            pvDisplayOptionArray[n].setCameraInterest(n2, (PdVector)object4);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object5[n2], "fieldOfView")) != 0.0) {
                            pvDisplayOptionArray[n].setCameraFieldOfView(n2, d);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object5[n2], "roll")) != 0.0) {
                            pvDisplayOptionArray[n].setCameraRoll(n2, d);
                        }
                        if ((object3 = PsXmlSrc.getRsrcNode((PsXmlNode)object5[n2], "transform")) != null) {
                            String string5;
                            object2 = ((PsXmlNode)object3).getAttribute("enable");
                            if (object2 != null && ((String)object2).equals("show")) {
                                pvDisplayOptionArray[n].setEnabledCameraTransform(n2, true);
                            }
                            if ((string4 = ((PsXmlNode)object3).getAttribute("ambient")) != null) {
                                if (string4.equals("R3Euclidean")) {
                                    pvDisplayOptionArray[n].setCameraAmbient(n2, 3);
                                } else if (string4.equals("R4Euclidean")) {
                                    pvDisplayOptionArray[n].setCameraAmbient(n2, 6);
                                } else if (string4.equals("S3Sphere")) {
                                    pvDisplayOptionArray[n].setCameraAmbient(n2, 7);
                                } else if (string4.equals("H3Hyperbolic")) {
                                    pvDisplayOptionArray[n].setCameraAmbient(n2, 8);
                                }
                            }
                            if ((string5 = ((PsXmlNode)object3).getAttribute("perspective")) != null) {
                                if (string5.equals("parallel")) {
                                    pvDisplayOptionArray[n].setCameraPerspective(n2, 0);
                                } else if (string5.equals("stereographic")) {
                                    pvDisplayOptionArray[n].setCameraPerspective(n2, 1);
                                } else if (string5.equals("poincareBall")) {
                                    pvDisplayOptionArray[n].setCameraPerspective(n2, 1);
                                } else if (string5.equals("kleinBall")) {
                                    pvDisplayOptionArray[n].setCameraPerspective(n2, 2);
                                } else if (string5.equals("upperHalfspace")) {
                                    pvDisplayOptionArray[n].setCameraPerspective(n2, 3);
                                }
                            }
                        }
                        if ((object2 = PsXmlSrc.getRsrcNode((PsXmlNode)object5[n2], "clipping")) != null) {
                            string4 = ((PsXmlNode)object2).getAttribute("enable");
                            if (string4 != null && string4.equals("show")) {
                                pvDisplayOptionArray[n].setEnabledCameraClip(n2, true);
                            }
                            if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object5[n2], "near")) != 0.0) {
                                pvDisplayOptionArray[n].setCameraNearClip(n2, d);
                            }
                            if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object5[n2], "far")) != 0.0) {
                                pvDisplayOptionArray[n].setCameraFarClip(n2, d);
                            }
                        }
                        ++n2;
                    }
                }
            } else {
                PsDebug.warning("missing element 'cameras'.");
            }
            if ((object6 = PsXmlSrc.getRsrcNode(psXmlNodeArray[n], "lights")) != null) {
                PsXmlNode psXmlNode6 = PsXmlSrc.getRsrcNode((PsXmlNode)object6, "ambient");
                if (psXmlNode6 != null) {
                    pvDisplayOptionArray[n].setAmbientLight(PsXmlLoader.parseColorRGB(psXmlNode6, "color"));
                }
                if ((object5 = PsXmlSrc.getRsrcNodes((PsXmlNode)object6, "light")) != null) {
                    pvDisplayOptionArray[n].setNumLights(((PsXmlNode[])object5).length);
                    n2 = 0;
                    while (n2 < ((PsXmlNode[])object5).length) {
                        PdVector pdVector;
                        object4 = ((PsXmlNode)object5[n]).getAttribute("type");
                        if (object4 != null) {
                            if (((String)object4).equals("bulb")) {
                                pvDisplayOptionArray[n].setLightType(n2, 1);
                            } else if (((String)object4).equals("rgbCube")) {
                                pvDisplayOptionArray[n].setLightType(n2, 2);
                            } else if (((String)object4).equals("hue")) {
                                pvDisplayOptionArray[n].setLightType(n2, 3);
                            } else if (((String)object4).equals("spot")) {
                                pvDisplayOptionArray[n].setLightType(n2, 4);
                            } else if (((String)object4).equals("sun")) {
                                pvDisplayOptionArray[n].setLightType(n2, 5);
                            }
                        }
                        if ((pdVector = PsXmlLoader.parsePdVector((PsXmlNode)object5[n], "position", stringArray)) != null) {
                            pvDisplayOptionArray[n].setLightPosition(n2, pdVector);
                        }
                        if ((pdVector = PsXmlLoader.parsePdVector((PsXmlNode)object5[n], "interest", stringArray)) != null) {
                            pvDisplayOptionArray[n].setLightInterest(n2, pdVector);
                        }
                        if ((object = PsXmlLoader.parseColorRGB((PsXmlNode)object5[n], "color")) != null) {
                            pvDisplayOptionArray[n].setLightColor(n2, (Color)object);
                        }
                        ++n2;
                    }
                }
            }
            if ((psXmlNode4 = PsXmlSrc.getRsrcNode(psXmlNodeArray[n], "background")) != null) {
                object5 = PsXmlLoader.parseColorRGB(psXmlNode4, "color");
                if (object5 != null) {
                    pvDisplayOptionArray[n].setBackgroundColor((Color)object5);
                }
                if ((object4 = psXmlNode4.getAttribute("image")) != null && ((String)object4).equals("show")) {
                    pvDisplayOptionArray[n].setOption(5, true);
                } else {
                    pvDisplayOptionArray[n].setOption(5, false);
                }
                PsXmlNode psXmlNode7 = PsXmlSrc.getRsrcNode(psXmlNode4, "image");
                if (psXmlNode7 != null) {
                    object = psXmlNode7.getAttribute("repeat");
                    if (object != null) {
                        pvDisplayOptionArray[n].setBackgroundImageRepeat((String)object);
                    }
                    if ((object3 = PsXmlSrc.getRsrcNode(psXmlNode7, "url")) != null) {
                        pvDisplayOptionArray[n].setBackgroundImage(((PsXmlNode)object3).getContent());
                    }
                }
            }
            if ((object5 = PsXmlSrc.getRsrcNode(psXmlNodeArray[n], "foreground")) != null) {
                String string6;
                object4 = PsXmlLoader.parseColorRGB((PsXmlNode)object5, "color");
                if (object4 != null) {
                    pvDisplayOptionArray[n].setForegroundColor((Color)object4);
                }
                if ((string6 = ((PsXmlNode)object5).getAttribute("image")) != null && string6.equals("show")) {
                    pvDisplayOptionArray[n].setOption(14, true);
                } else {
                    pvDisplayOptionArray[n].setOption(14, false);
                }
                object = PsXmlSrc.getRsrcNode((PsXmlNode)object5, "image");
                if (object != null) {
                    object3 = ((PsXmlNode)object).getAttribute("repeat");
                    if (object3 != null) {
                        pvDisplayOptionArray[n].setForegroundImageRepeat((String)object3);
                    }
                    if ((object2 = PsXmlSrc.getRsrcNode((PsXmlNode)object, "url")) != null) {
                        pvDisplayOptionArray[n].setForegroundImage(((PsXmlNode)object2).getContent());
                    }
                }
            }
            if ((object4 = PsXmlSrc.getRsrcNode(psXmlNodeArray[n], "window")) != null) {
                PsXmlNode psXmlNode8 = PsXmlSrc.getRsrcNode((PsXmlNode)object4, "x");
                if (psXmlNode8 != null) {
                    int n5 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object4, "x");
                    int n6 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object4, "y");
                    pvDisplayOptionArray[n].setWindowPosition(n5, n6);
                }
                int n7 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object4, "width");
                int n8 = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object4, "height");
                pvDisplayOptionArray[n].setWindowSize(n7, n8);
            }
            ++n;
        }
        return pvDisplayOptionArray;
    }

    public static PvDisplayOption[] read(String string) {
        BufferedReader bufferedReader = PsUtil.open(string);
        if (bufferedReader == null) {
            PsDebug.warning("could not open = " + string);
            return null;
        }
        PvDisplayOption[] pvDisplayOptionArray = PvDisplayLoader.read(bufferedReader);
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        return pvDisplayOptionArray;
    }

    public static PvDisplayOption[] read(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning("missing reader");
            return null;
        }
        PsXmlSrc psXmlSrc = PsXmlLoader.read(bufferedReader);
        if (psXmlSrc == null) {
            PsDebug.warning("failed to parsing XML in reader");
            return null;
        }
        PvDisplayOption[] pvDisplayOptionArray = PvDisplayLoader.parseRsrcTree(psXmlSrc);
        if (pvDisplayOptionArray == null) {
            PsDebug.warning("failed to interpret content of JVD in reader");
            return null;
        }
        return pvDisplayOptionArray;
    }

    private static boolean hasAttribute(String string, String string2) {
        return string != null && string.equalsIgnoreCase(string2);
    }

    private static int parseVisibility(String string) {
        if (string == null) {
            return -1;
        }
        if (string.equalsIgnoreCase("show")) {
            return 1;
        }
        return 0;
    }

    public static String write(PvDisplayOption[] pvDisplayOptionArray) {
        if (pvDisplayOptionArray == null || pvDisplayOptionArray.length == 0) {
            PsDebug.warning("missing options.");
            return null;
        }
        PsXmlSrc psXmlSrc = PvDisplayLoader.fillRsrcTree(null, pvDisplayOptionArray);
        if (psXmlSrc == null) {
            PsDebug.warning("failed to generate XML tree");
            return null;
        }
        return PsXmlSrc.write(psXmlSrc);
    }

    protected static PsXmlSrc fillRsrcTree(PsXmlSrc psXmlSrc, PvDisplayOption[] pvDisplayOptionArray) {
        PsXmlNode psXmlNode;
        PsXmlNode psXmlNode2;
        if (pvDisplayOptionArray == null || pvDisplayOptionArray.length == 0 || pvDisplayOptionArray[0] == null) {
            return null;
        }
        if (psXmlSrc == null) {
            psXmlSrc = new PsXmlSrc();
        }
        if ((psXmlNode2 = psXmlSrc.getRootNode()) == null) {
            psXmlNode2 = new PsXmlNode("jv-disp");
            psXmlSrc.setRootNode(psXmlNode2);
        }
        psXmlSrc.setDocName("jv-disp");
        PsXmlNode[] psXmlNodeArray = new PsXmlNode[2];
        psXmlNodeArray[0] = psXmlNode2.addChild("meta");
        psXmlNodeArray[0].addAttribute("generator", PsConfig.getProgram() + " v." + PsConfig.getVersion());
        psXmlNodeArray[1] = psXmlNode2.addChild("meta");
        psXmlNodeArray[1].addAttribute("date", new Date().toString());
        if (pvDisplayOptionArray[0] != null) {
            psXmlNode = psXmlNode2.addChild("version", pvDisplayOptionArray[0].getVersion());
            psXmlNode.addAttribute("type", pvDisplayOptionArray[0].getVersionType());
            if (pvDisplayOptionArray[0].getTitle() != null) {
                psXmlNode2.addChild("title", pvDisplayOptionArray[0].getTitle());
            }
            psXmlNode2.addChild("abstract", pvDisplayOptionArray[0].getAbstract());
        }
        psXmlNode = psXmlNode2.addChild("displays");
        if (pvDisplayOptionArray != null) {
            int n = 0;
            while (n < pvDisplayOptionArray.length) {
                Dimension dimension;
                PsXmlNode psXmlNode3;
                Object object;
                int n2;
                PsXmlNode psXmlNode4 = psXmlNode.addChild("display");
                psXmlNode4.addAttribute("name", pvDisplayOptionArray[n].getTitle());
                if (pvDisplayOptionArray[n].getOption(1)) {
                    psXmlNode4.addAttribute("antiAlias", "show");
                }
                if (pvDisplayOptionArray[n].getOption(2)) {
                    psXmlNode4.addAttribute("autoRotate", "show");
                }
                if (pvDisplayOptionArray[n].getOption(3)) {
                    psXmlNode4.addAttribute("axes", "show");
                }
                if (pvDisplayOptionArray[n].getOption(4)) {
                    psXmlNode4.addAttribute("axesLabel", "show");
                }
                if (!pvDisplayOptionArray[n].getOption(7)) {
                    psXmlNode4.addAttribute("border", "hide");
                }
                if (pvDisplayOptionArray[n].getOption(8)) {
                    psXmlNode4.addAttribute("boundingBox", "show");
                }
                if (pvDisplayOptionArray[n].getOption(9)) {
                    psXmlNode4.addAttribute("center", "show");
                }
                if (pvDisplayOptionArray[n].getOption(10)) {
                    psXmlNode4.addAttribute("cross", "show");
                }
                if (!pvDisplayOptionArray[n].getOption(11)) {
                    psXmlNode4.addAttribute("depthcue", "hide");
                }
                if (!pvDisplayOptionArray[n].getOption(12)) {
                    psXmlNode4.addAttribute("drawing", "hide");
                }
                if (pvDisplayOptionArray[n].getOption(13)) {
                    psXmlNode4.addAttribute("edgeAura", "show");
                }
                if (pvDisplayOptionArray[n].getOption(15)) {
                    psXmlNode4.addAttribute("frame", "show");
                }
                if (pvDisplayOptionArray[n].getOption(16)) {
                    psXmlNode4.addAttribute("info", "show");
                }
                if (pvDisplayOptionArray[n].getOption(18)) {
                    psXmlNode4.addAttribute("magnet", "show");
                }
                if (pvDisplayOptionArray[n].getOption(19)) {
                    psXmlNode4.addAttribute("single", "show");
                }
                if (!pvDisplayOptionArray[n].getOption(20)) {
                    psXmlNode4.addAttribute("sorting", "hide");
                }
                if (!pvDisplayOptionArray[n].getOption(21)) {
                    psXmlNode4.addAttribute("visible", "hide");
                }
                if (pvDisplayOptionArray[n].getOption(22)) {
                    psXmlNode4.addAttribute("xyGrid", "show");
                }
                if (pvDisplayOptionArray[n].getOption(23)) {
                    psXmlNode4.addAttribute("xzGrid", "show");
                }
                if (pvDisplayOptionArray[n].getOption(24)) {
                    psXmlNode4.addAttribute("yzGrid", "show");
                }
                if (pvDisplayOptionArray[n].getOption(25)) {
                    psXmlNode4.addAttribute("zBuffer", "show");
                }
                PsXmlNode psXmlNode5 = psXmlNode4.addChild("cameras");
                int n3 = pvDisplayOptionArray[n].getCurrentCamera();
                if (n3 < 0 || n3 >= PvDisplayIf.CAMERA_NAME.length) {
                    PsDebug.warning("unknown camera type = " + n3);
                } else {
                    psXmlNode5.addAttribute("select", PvDisplayIf.CAMERA_NAME[n3]);
                }
                int n4 = pvDisplayOptionArray[n].getNumCameras();
                int n5 = 0;
                while (n5 < n4) {
                    PsXmlNode psXmlNode6 = psXmlNode5.addChild("camera");
                    n2 = pvDisplayOptionArray[n].getCameraProjection(n5);
                    if (n2 < 0 || n2 >= PvDisplayIf.CAMERA_NAME.length) {
                        PsDebug.warning("unknown camera type = " + n2);
                    } else {
                        psXmlNode6.addAttribute("projection", PvDisplayIf.CAMERA_NAME[n2]);
                    }
                    PsXmlLoader.addVector(psXmlNode6, "position", pvDisplayOptionArray[n].getCameraPosition(n5), true);
                    PsXmlLoader.addVector(psXmlNode6, "interest", pvDisplayOptionArray[n].getCameraInterest(n5), true);
                    psXmlNode6.addChild("fieldOfView", pvDisplayOptionArray[n].getCameraAngle(n5));
                    psXmlNode6.addChild("roll", pvDisplayOptionArray[n].getCameraRoll(n5));
                    object = psXmlNode6.addChild("transform");
                    if (pvDisplayOptionArray[n].isEnabledCameraTransform(n5)) {
                        ((PsXmlNode)object).addAttribute("enable", "show");
                    } else {
                        ((PsXmlNode)object).addAttribute("enable", "hide");
                    }
                    int n6 = pvDisplayOptionArray[n].getCameraAmbient(n5);
                    switch (n6) {
                        case 3: {
                            ((PsXmlNode)object).addAttribute("ambient", "R3Euclidean");
                            break;
                        }
                        case 6: {
                            ((PsXmlNode)object).addAttribute("ambient", "R4Euclidean");
                            break;
                        }
                        case 7: {
                            ((PsXmlNode)object).addAttribute("ambient", "S3Sphere");
                            break;
                        }
                        case 8: {
                            ((PsXmlNode)object).addAttribute("ambient", "H3Hyperbolic");
                            break;
                        }
                        default: {
                            PsDebug.warning("unknown ambient space type = " + n6);
                        }
                    }
                    int n7 = pvDisplayOptionArray[n].getCameraPerspective(n5);
                    switch (n7) {
                        case 0: {
                            ((PsXmlNode)object).addAttribute("perspective", "parallel");
                            break;
                        }
                        case 1: {
                            ((PsXmlNode)object).addAttribute("perspective", "stereographic");
                            break;
                        }
                        default: {
                            PsDebug.warning("unknown perspective type = " + n7);
                        }
                    }
                    psXmlNode3 = psXmlNode6.addChild("clipping");
                    if (pvDisplayOptionArray[n].isEnabledCameraClip(n5)) {
                        psXmlNode3.addAttribute("enable", "show");
                    } else {
                        psXmlNode3.addAttribute("enable", "hide");
                    }
                    psXmlNode3.addChild("near", pvDisplayOptionArray[n].getCameraNearClip(n5));
                    psXmlNode3.addChild("far", pvDisplayOptionArray[n].getCameraFarClip(n5));
                    ++n5;
                }
                PsXmlNode psXmlNode7 = psXmlNode4.addChild("lights");
                PsXmlLoader.addColor(psXmlNode7, "ambient", pvDisplayOptionArray[n].getAmbientLight());
                int n8 = pvDisplayOptionArray[n].getNumLights();
                n2 = 0;
                while (n2 < n8) {
                    object = psXmlNode7.addChild("light");
                    int n9 = pvDisplayOptionArray[n].getLightType(n2);
                    switch (n9) {
                        case 1: {
                            ((PsXmlNode)object).addAttribute("type", "bulb");
                            break;
                        }
                        case 2: {
                            ((PsXmlNode)object).addAttribute("type", "rgbCube");
                            break;
                        }
                        case 3: {
                            ((PsXmlNode)object).addAttribute("type", "hue");
                            break;
                        }
                        case 4: {
                            ((PsXmlNode)object).addAttribute("type", "spot");
                            break;
                        }
                        case 5: {
                            ((PsXmlNode)object).addAttribute("type", "sun");
                            break;
                        }
                        default: {
                            PsDebug.warning("unknown light type = " + n9);
                        }
                    }
                    PsXmlLoader.addVector((PsXmlNode)object, "position", pvDisplayOptionArray[n].getLightPosition(n2), true);
                    PsXmlLoader.addVector((PsXmlNode)object, "interest", pvDisplayOptionArray[n].getLightInterest(n2), true);
                    PsXmlLoader.addColor((PsXmlNode)object, "color", pvDisplayOptionArray[n].getLightColor(n2));
                    ++n2;
                }
                PsXmlNode psXmlNode8 = psXmlNode4.addChild("background");
                PsXmlLoader.addColor(psXmlNode8, "color", pvDisplayOptionArray[n].getBackgroundColor());
                object = pvDisplayOptionArray[n].getBackgroundImage();
                if (object != null) {
                    if (pvDisplayOptionArray[n].getOption(5)) {
                        psXmlNode8.addAttribute("image", "show");
                    }
                    PsXmlNode psXmlNode9 = psXmlNode8.addChild("image");
                    psXmlNode9.addAttribute("repeat", pvDisplayOptionArray[n].getBackgroundImageRepeat());
                    psXmlNode9.addChild("url", (String)object);
                }
                psXmlNode3 = psXmlNode4.addChild("foreground");
                PsXmlLoader.addColor(psXmlNode3, "color", pvDisplayOptionArray[n].getForegroundColor());
                object = pvDisplayOptionArray[n].getForegroundImage();
                if (object != null) {
                    if (pvDisplayOptionArray[n].getOption(14)) {
                        psXmlNode3.addAttribute("image", "show");
                    }
                    PsXmlNode psXmlNode10 = psXmlNode3.addChild("image");
                    psXmlNode10.addAttribute("repeat", pvDisplayOptionArray[n].getForegroundImageRepeat());
                    psXmlNode10.addChild("url", (String)object);
                }
                PsXmlNode psXmlNode11 = psXmlNode4.addChild("window");
                Point point = pvDisplayOptionArray[n].getWindowPosition();
                if (point != null) {
                    psXmlNode11.addChild("x", point.x);
                    psXmlNode11.addChild("y", point.y);
                }
                if ((dimension = pvDisplayOptionArray[n].getWindowSize()) != null) {
                    psXmlNode11.addChild("width", dimension.width);
                    psXmlNode11.addChild("height", dimension.height);
                }
                ++n;
            }
        }
        return psXmlSrc;
    }
}

