/*
 * Decompiled with CFR 0.152.
 */
package jv.rsrc;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsStackLayout;
import jv.object.PsUpdateIf;
import jv.objectGui.GuiStackLayout;
import jv.rsrc.PsGeometryInfo;

public final class PsGeometryInfo_IP
extends PsPanel {
    protected PsGeometryInfo m_geometryInfo;
    protected Label m_lClassification;
    protected Label m_lDescription;
    protected Label m_lAbstract;
    protected TextArea m_tAbstract;
    protected Label m_lDetail;
    protected TextArea m_tDetail;
    protected Label m_lPrimary;
    protected TextField m_tPrimary;
    protected Label m_lSecondary;
    protected TextField m_tSecondary;
    protected Label m_lKeywords;
    protected TextField m_tKeywords;
    protected Label m_lZentralblatt;
    protected TextField m_tZentralblatt;
    protected Label m_lSoftware;
    protected TextField m_tSoftware;

    public PsGeometryInfo_IP() {
        this.setInsetSize(0);
        this.setLayout(new BorderLayout());
        this.m_lClassification = new Label("Classification");
        this.m_lClassification.setFont(PsConfig.getFont(3));
        this.m_lPrimary = new Label("Primary");
        this.m_tPrimary = new TextField();
        this.m_lSecondary = new Label("Secondary (separated by  ; )");
        this.m_tSecondary = new TextField();
        this.m_lKeywords = new Label("Keywords (separated by  ; )");
        this.m_tKeywords = new TextField();
        this.m_lDescription = new Label("Description");
        this.m_lDescription.setFont(PsConfig.getFont(3));
        this.m_lAbstract = new Label("Summarizing sentence");
        this.m_tAbstract = new TextArea(2, 30);
        this.m_lDetail = new Label("Detailed description (must use <p> paragraph text </p> to enclose paragraphs)");
        this.m_tDetail = new TextArea(6, 30);
        this.m_lZentralblatt = new Label("Zentralblatt f\u00fcr Mathematik number (if it exists)");
        this.m_tZentralblatt = new TextField();
        this.m_lSoftware = new Label("Software used for production of master (incl. version)");
        this.m_tSoftware = new TextField();
        this.init();
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.m_geometryInfo = (PsGeometryInfo)psUpdateIf;
    }

    public void accept() {
        this.m_geometryInfo.m_abstract = this.m_tAbstract.getText();
        this.m_geometryInfo.m_detail = this.m_tDetail.getText();
        this.m_geometryInfo.m_primary = this.m_tPrimary.getText();
        this.m_geometryInfo.m_secondary = PuString.splitString(this.m_tSecondary.getText(), ';');
        this.m_geometryInfo.m_keyword = PuString.splitString(this.m_tKeywords.getText(), ';');
        this.m_geometryInfo.m_software = this.m_tSoftware.getText();
        this.m_geometryInfo.m_zentralblatt = this.m_tZentralblatt.getText();
    }

    public boolean update(Object object) {
        if (this.m_geometryInfo == null) {
            PsDebug.warning("missing geometryInfo");
            return false;
        }
        if (object == this.m_geometryInfo) {
            ((TextComponent)this.m_tPrimary).setText(this.m_geometryInfo.m_primary);
            ((TextComponent)this.m_tSecondary).setText(PuString.mergeStrings(this.m_geometryInfo.m_secondary, ';'));
            ((TextComponent)this.m_tKeywords).setText(PuString.mergeStrings(this.m_geometryInfo.m_keyword, ';'));
            this.m_tAbstract.setText(this.m_geometryInfo.m_abstract);
            this.m_tDetail.setText(this.m_geometryInfo.m_detail);
            ((TextComponent)this.m_tZentralblatt).setText(this.m_geometryInfo.m_zentralblatt);
            ((TextComponent)this.m_tSoftware).setText(this.m_geometryInfo.m_software);
            return true;
        }
        return super.update(object);
    }

    public void init() {
        super.init();
        this.setLayout(new PsStackLayout(1));
        Panel panel = new Panel();
        panel.setLayout(new GuiStackLayout(0));
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        panel2.add("North", this.m_lClassification);
        panel.add("Left Fill", panel2);
        PsPanel psPanel = new PsPanel();
        psPanel.setLayout(new PsStackLayout(3));
        Panel panel3 = new Panel();
        panel3.setLayout(new GridLayout(2, 2));
        panel3.add(this.m_lPrimary);
        panel3.add(this.m_lSecondary);
        panel3.add(this.m_tPrimary);
        panel3.add(this.m_tSecondary);
        psPanel.add(panel3);
        Panel panel4 = new Panel();
        panel4.setLayout(new GridLayout(2, 1));
        panel4.add(this.m_lKeywords);
        panel4.add(this.m_tKeywords);
        psPanel.add(panel4);
        psPanel.addLine(1);
        panel.add("Right Fill*4", psPanel);
        this.add(panel);
        panel3 = new Panel();
        panel3.setLayout(new GuiStackLayout(0));
        panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        panel2.add("North", this.m_lDescription);
        panel3.add("Left Fill", panel2);
        psPanel = new PsPanel();
        psPanel.setLayout(new PsStackLayout(3));
        Panel panel5 = new Panel();
        panel5.setLayout(new PsStackLayout(3));
        panel5.add(this.m_lAbstract);
        panel5.add(this.m_tAbstract);
        psPanel.add(panel5);
        panel5 = new Panel();
        panel5.setLayout(new PsStackLayout(3));
        panel5.add(this.m_lDetail);
        panel5.add(this.m_tDetail);
        psPanel.add(panel5);
        panel5 = new Panel();
        panel5.setLayout(new GridLayout(2, 1));
        panel5.add(this.m_lZentralblatt);
        panel5.add(this.m_tZentralblatt);
        psPanel.add(panel5);
        panel5 = new Panel();
        panel5.setLayout(new GridLayout(2, 1));
        panel5.add(this.m_lSoftware);
        panel5.add(this.m_tSoftware);
        psPanel.add(panel5);
        psPanel.addLine(1);
        panel3.add("Right Fill*4", psPanel);
        this.add(panel3);
    }
}

