/*
 * Decompiled with CFR 0.152.
 */
package jv.thirdParty.ruler;

import java.awt.Color;
import java.text.NumberFormat;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public final class PgRuler
extends PgJvxSrc {
    private static final int MIN = 0;
    private static final int MAX = 1;
    private static final int NORMALHP1 = 0;
    private static final int NORMALHP2 = 1;
    private static final int UPHP1 = 2;
    private static final int UPHP2 = 3;
    public static final int NORMAL_DIRECTION = 0;
    public static final int UP_VECTOR_DIRECTION = 1;
    public static final int TITLE_ALIGN_LEFT = 0;
    public static final int TITLE_ALIGN_RIGHT = 1;
    public static final int TITLE_ALIGN_CENTER = 2;
    protected boolean m_bFixedMode;
    protected boolean m_bMajorMode;
    protected boolean m_bMinorMode;
    protected boolean m_bHashInNormalDir;
    protected boolean m_bHashInUpDir;
    protected boolean m_bShowLabels;
    protected boolean m_bShowRulerName;
    protected String m_rulerName;
    protected int m_rulerNamePos;
    protected PdVector m_minMax;
    protected PdVector m_origin = new PdVector(3);
    protected PdVector m_normalOffset = new PdVector(3);
    protected PdVector m_upOffset = new PdVector(3);
    protected PdVector m_v = new PdVector(3);
    protected PdVector m_n = new PdVector(3);
    protected PdVector m_u = new PdVector(3);
    protected double[] m_minorHashExtent = new double[4];
    protected double[] m_majorHashExtent = new double[4];
    protected Color m_majorHashExtentColor;
    protected Color m_minorHashExtentColor;
    protected PuInteger m_numMajorHashings;
    protected PuInteger m_numMinorHashings;
    protected PuDouble m_majorHashUnits;
    protected PuDouble m_minorHashUnits;
    private double m_defMin = -10.0;
    private double m_defMax = 10.0;
    private double m_defMajorHashUnit = 5.0;
    private double m_defMinorHashUnit = 2.5;
    private int m_defNumMajorHashings = 5;
    private int m_defNumMinorHashings = 2;
    private double m_defhMajor = 0.5;
    private double m_defhMinor = 0.25;
    private boolean m_defbHashInNormalDir = true;
    private boolean m_defbHashInUpDir = false;
    private Color m_defhMajorColor = new Color(0, 0, 255);
    private Color m_defhMinorColor = new Color(113, 113, 255);
    private int m_numMajor;
    private int m_numMinor;
    private double[] m_majorHashing = new double[1000];
    private double[] m_minorHashing = new double[1000];

    public double getMaxParameter() {
        return this.m_minMax.getEntry(1);
    }

    public void setMajorHashSize(double d, double d2, int n) {
        if (n == 0) {
            this.m_majorHashExtent[0] = d;
            this.m_majorHashExtent[1] = d2;
            return;
        }
        if (n == 1) {
            this.m_majorHashExtent[2] = d;
            this.m_majorHashExtent[3] = d2;
        }
    }

    public double getMajorUnit() {
        return this.m_majorHashUnits.getValue();
    }

    public void setNameAlignment(int n, int n2, int n3, int n4) {
        this.m_rulerNamePos = n;
        this.setLabelAttribute(2, n3, n4, n2, 0, 3);
    }

    public void setOrigin(PdVector pdVector) {
        this.m_origin.copy(pdVector);
    }

    public boolean isShowingMinorHashings() {
        return this.m_bMinorMode;
    }

    public void showMinorHashings(boolean bl) {
        this.m_bMinorMode = bl;
    }

    protected void resetVertices() {
        int n = 0;
        while (n < this.m_maxNumVertices) {
            if (this.m_vertex[n] != null) {
                this.m_vertex[n].setName("");
            }
            ++n;
        }
        n = 0;
        while (n < this.m_maxNumPolygons) {
            if (this.m_polygon[n] != null) {
                this.m_polygon[n].setName("");
            }
            ++n;
        }
    }

    public int getNumMajorPartitions() {
        return this.m_numMajorHashings.getValue();
    }

    public boolean update(Object object) {
        if (object == this) {
            this.computeHashings();
            return super.update(this);
        }
        if (object == this.m_minorHashUnits || object == this.m_majorHashUnits) {
            this.m_majorHashUnits.setBounds(0.1, Math.ceil(this.m_minMax.getEntry(1) + 0.25));
            this.m_minorHashUnits.setBounds(0.1, Math.ceil(this.m_minMax.getEntry(1) + 0.25));
            this.computeHashings();
            return super.update(this);
        }
        if (object == this.m_numMajorHashings || object == this.m_numMinorHashings) {
            int n = new Double(2.0 * this.m_minMax.getEntry(1)).intValue();
            this.m_numMajorHashings.setBounds(0, n);
            this.m_numMinorHashings.setBounds(0, n);
            this.computeHashings();
            return super.update(this);
        }
        return super.update(object);
    }

    public void setMajorColor(Color color) {
        this.m_majorHashExtentColor = color;
    }

    public boolean isShowingLabels() {
        return this.m_bShowLabels;
    }

    public void showLabels(boolean bl) {
        this.m_bShowLabels = bl;
    }

    public void setMinorColor(Color color) {
        this.m_minorHashExtentColor = color;
    }

    public boolean isShowingHashingsInNormalDir() {
        return this.m_bHashInNormalDir;
    }

    public boolean isShowingHashingsInUpDir() {
        return this.m_bHashInUpDir;
    }

    public void showHashingsInNormalDir(boolean bl) {
        this.m_bHashInNormalDir = bl;
    }

    public void showHashingsInUpDir(boolean bl) {
        this.m_bHashInUpDir = bl;
    }

    public double getMinParameter() {
        return this.m_minMax.getEntry(0);
    }

    public boolean isShowingMajorHashings() {
        return this.m_bMajorMode;
    }

    public void showMajorHashings(boolean bl) {
        this.m_bMajorMode = bl;
    }

    public void setPartitionedHashing(int n, int n2) {
        this.m_numMajorHashings.setValue(n);
        this.m_numMinorHashings.setValue(n2);
    }

    public PgRuler() {
        this(3);
    }

    public PgRuler(int n) {
        super(n);
        this.setTag(7);
        this.m_origin = new PdVector(n);
        this.m_normalOffset = new PdVector(n);
        this.m_upOffset = new PdVector(n);
        this.m_minMax = new PdVector(2);
        this.m_majorHashUnits = new PuDouble("Major Units", this);
        this.m_minorHashUnits = new PuDouble("Minor Units", this);
        this.m_numMajorHashings = new PuInteger("Major Hashings", this);
        this.m_numMinorHashings = new PuInteger("Minor Hashings", this);
        this.init();
    }

    public PgRuler(PdVector pdVector, PdVector pdVector2) {
        this(3);
        this.setDirection(pdVector);
        this.setNormal(pdVector2);
        this.m_u.cross(this.m_v, this.m_n);
    }

    public double getMinorUnit() {
        return this.m_minorHashUnits.getValue();
    }

    public void setUpVector(PdVector pdVector) {
        this.m_u.copy(pdVector);
        this.m_u.normalize();
    }

    public void setHashOffsetInNormalDir(double d, double d2, double d3) {
        this.m_normalOffset.m_data[0] = d;
        this.m_normalOffset.m_data[1] = d2;
        this.m_normalOffset.m_data[2] = d3;
    }

    public void setHashOffsetInUpDir(double d, double d2, double d3) {
        this.m_upOffset.m_data[0] = d;
        this.m_upOffset.m_data[1] = d2;
        this.m_upOffset.m_data[2] = d3;
    }

    public boolean isShowingRulerName() {
        return this.m_bShowRulerName;
    }

    public void showRulerName(boolean bl) {
        this.m_bShowRulerName = bl;
    }

    public void setMinorHashSize(double d, double d2, int n) {
        if (n == 0) {
            this.m_minorHashExtent[0] = d;
            this.m_minorHashExtent[1] = d2;
        }
        if (n == 1) {
            this.m_minorHashExtent[2] = d;
            this.m_minorHashExtent[3] = d2;
        }
    }

    public void setRulerName(String string) {
        this.setRulerName(string, 1, false);
    }

    public void setRulerName(String string, int n) {
        this.setRulerName(string, n, false);
    }

    public void setRulerName(String string, boolean bl) {
        this.setRulerName(string, 1, bl);
    }

    public void setRulerName(String string, int n, boolean bl) {
        this.m_rulerName = string;
        this.m_rulerNamePos = n;
        this.m_bShowRulerName = bl;
        this.setName(this.m_rulerName);
    }

    public void setNormal(PdVector pdVector) {
        this.m_n.copy(pdVector);
        this.m_n.normalize();
    }

    public void setFixedHashing(double d, double d2) {
        if (d >= this.m_majorHashUnits.getMax() - 0.5) {
            this.m_majorHashUnits.setBounds(0.1, 2.0 * d);
        }
        if (d2 >= this.m_minorHashUnits.getMax() - 0.5) {
            this.m_minorHashUnits.setBounds(0.1, 2.0 * d2);
        }
        this.m_majorHashUnits.setValue(d);
        this.m_minorHashUnits.setValue(d2);
    }

    public boolean isShowingFixedMode() {
        return this.m_bFixedMode;
    }

    public void showFixedMode(boolean bl) {
        this.m_bFixedMode = bl;
    }

    public void setMinMax(double d, double d2) {
        this.m_minMax.m_data[0] = d;
        this.m_minMax.m_data[1] = d2;
    }

    protected void computeHashings() {
        int n;
        PdVector pdVector;
        int n2;
        double d;
        double d2 = this.m_minMax.getEntry(0);
        if (d2 >= (d = this.m_minMax.getEntry(1))) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        if (this.m_bFixedMode) {
            double d3 = this.m_majorHashUnits.getValue();
            double d4 = this.m_minorHashUnits.getValue();
            if (this.m_bMajorMode) {
                n3 = PgRuler.hashInterval(n3, this.m_majorHashing, d3, d2, true, d, true);
                if (this.m_bMinorMode) {
                    if (n3 == 0) {
                        n4 = PgRuler.hashInterval(n4, this.m_minorHashing, d4, d2, true, d, true);
                    } else {
                        n4 = PgRuler.hashInterval(n4, this.m_minorHashing, d4, d2, false, this.m_majorHashing[0], false);
                        n4 = PgRuler.hashInterval(n4, this.m_minorHashing, d4, this.m_majorHashing[n3 - 1], false, d, false);
                        int n5 = 1;
                        while (n5 < n3) {
                            n4 = PgRuler.hashInterval(n4, this.m_minorHashing, d4, this.m_majorHashing[n5 - 1], false, this.m_majorHashing[n5], false);
                            ++n5;
                        }
                    }
                }
            } else if (this.m_bMinorMode) {
                n4 = PgRuler.hashInterval(n4, this.m_minorHashing, d4, d2, true, d, true);
            }
        } else {
            n3 = this.partitionInterval(n3, this.m_majorHashing, this.m_numMajorHashings.getValue(), d2, true, d, true);
            if (this.m_bMinorMode) {
                int n6 = this.m_numMinorHashings.getValue();
                n2 = 1;
                while (n2 < n3) {
                    n4 = this.partitionInterval(n4, this.m_minorHashing, n6, this.m_majorHashing[n2 - 1], false, this.m_majorHashing[n2], false);
                    ++n2;
                }
            }
        }
        int n7 = 1;
        if (this.m_bHashInNormalDir) {
            n7 += n3 + n4;
        }
        if (this.m_bHashInUpDir) {
            n7 += n3 + n4;
        }
        if (this.m_bShowLabels) {
            n7 += n3;
        }
        if (this.m_bShowRulerName) {
            ++n7;
        }
        n2 = 2 * n7;
        this.resetVertices();
        this.setNumVertices(n2);
        this.setNumPolygons(n7);
        PdVector[] pdVectorArray = this.getVertices();
        PiVector[] piVectorArray = this.getPolygons();
        Color[] colorArray = this.getPolygonColors();
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(1);
        PdVector pdVector2 = this.m_v;
        int n8 = 0;
        int n9 = 0;
        piVectorArray[n9].set(n8, n8 + 1);
        colorArray[n9++] = this.m_majorHashExtentColor;
        pdVectorArray[n8++].blendBase(this.m_origin, d2, pdVector2);
        pdVectorArray[n8++].blendBase(this.m_origin, d, pdVector2);
        if (this.m_bShowLabels) {
            int n10 = 0;
            while (n10 < n3) {
                piVectorArray[n9].set(n8, n8 + 1);
                colorArray[n9++] = this.m_majorHashExtentColor;
                if (this.m_bShowLabels) {
                    pdVectorArray[n8].setName(numberFormat.format(this.m_majorHashing[n10]));
                }
                pdVectorArray[n8++].blendBase(this.m_origin, this.m_majorHashing[n10], pdVector2);
                pdVectorArray[n8++].blendBase(this.m_origin, this.m_majorHashing[n10], pdVector2);
                ++n10;
            }
        }
        PdVector pdVector3 = new PdVector(this.m_dim);
        PdVector pdVector4 = new PdVector(this.m_dim);
        if (this.m_bHashInUpDir) {
            pdVector = PdVector.addNew(this.m_origin, this.m_upOffset);
            pdVector3.blendBase(pdVector, this.m_majorHashExtent[2], this.m_u);
            pdVector4.blendBase(pdVector, this.m_majorHashExtent[3], this.m_u);
            n = 0;
            while (n < n3) {
                piVectorArray[n9].set(n8, n8 + 1);
                colorArray[n9++] = this.m_majorHashExtentColor;
                pdVectorArray[n8++].blendBase(pdVector3, this.m_majorHashing[n], pdVector2);
                pdVectorArray[n8++].blendBase(pdVector4, this.m_majorHashing[n], pdVector2);
                ++n;
            }
            pdVector3.blendBase(pdVector, this.m_minorHashExtent[2], this.m_u);
            pdVector4.blendBase(pdVector, this.m_minorHashExtent[3], this.m_u);
            n = 0;
            while (n < n4) {
                piVectorArray[n9].set(n8, n8 + 1);
                colorArray[n9++] = this.m_minorHashExtentColor;
                pdVectorArray[n8++].blendBase(pdVector3, this.m_minorHashing[n], pdVector2);
                pdVectorArray[n8++].blendBase(pdVector4, this.m_minorHashing[n], pdVector2);
                ++n;
            }
        }
        if (this.m_bHashInNormalDir) {
            pdVector = PdVector.addNew(this.m_origin, this.m_normalOffset);
            pdVector3.blendBase(pdVector, this.m_majorHashExtent[0], this.m_n);
            pdVector4.blendBase(pdVector, this.m_majorHashExtent[1], this.m_n);
            n = 0;
            while (n < n3) {
                piVectorArray[n9].set(n8, n8 + 1);
                colorArray[n9++] = this.m_majorHashExtentColor;
                pdVectorArray[n8++].blendBase(pdVector3, this.m_majorHashing[n], pdVector2);
                pdVectorArray[n8++].blendBase(pdVector4, this.m_majorHashing[n], pdVector2);
                ++n;
            }
            pdVector3.blendBase(pdVector, this.m_minorHashExtent[0], this.m_n);
            pdVector4.blendBase(pdVector, this.m_minorHashExtent[1], this.m_n);
            n = 0;
            while (n < n4) {
                piVectorArray[n9].set(n8, n8 + 1);
                colorArray[n9++] = this.m_minorHashExtentColor;
                pdVectorArray[n8++].blendBase(pdVector3, this.m_minorHashing[n], pdVector2);
                pdVectorArray[n8++].blendBase(pdVector4, this.m_minorHashing[n], pdVector2);
                ++n;
            }
        }
        if (this.m_bShowRulerName) {
            double d5 = d2;
            switch (this.m_rulerNamePos) {
                default: {
                    d5 = d2;
                    break;
                }
                case 1: {
                    d5 = d;
                    break;
                }
                case 2: {
                    d5 = (d2 + d) / 2.0;
                }
            }
            piVectorArray[n9].set(n8, n8 + 1);
            colorArray[n9] = this.m_majorHashExtentColor;
            this.getPolygon(n9).setName(this.m_rulerName);
            pdVectorArray[n8].blendBase(this.m_origin, d5, pdVector2);
            pdVectorArray[n8 + 1].copy(pdVectorArray[n8]);
        }
    }

    public int getNumMinorPartitions() {
        return this.m_numMinorHashings.getValue();
    }

    public void setDefaultHashSizes(int n) {
        if (n == 0) {
            this.m_majorHashExtent[0] = 0.0;
            this.m_majorHashExtent[1] = this.m_defhMajor;
            this.m_minorHashExtent[0] = 0.0;
            this.m_minorHashExtent[1] = this.m_defhMinor;
            this.m_bHashInNormalDir = true;
            this.m_bHashInUpDir = false;
            return;
        }
        if (n == 1) {
            this.m_majorHashExtent[2] = 0.0;
            this.m_majorHashExtent[3] = this.m_defhMajor;
            this.m_minorHashExtent[2] = 0.0;
            this.m_minorHashExtent[3] = this.m_defhMinor;
            this.m_bHashInNormalDir = false;
            this.m_bHashInUpDir = true;
        }
    }

    public void init() {
        super.init();
        this.setDimOfPolygons(2);
        this.m_bHashInNormalDir = this.m_defbHashInNormalDir;
        this.m_bHashInUpDir = this.m_defbHashInUpDir;
        this.m_bMajorMode = true;
        this.m_bMinorMode = true;
        this.m_bFixedMode = true;
        this.m_bShowLabels = true;
        this.m_bShowRulerName = false;
        this.m_majorHashExtent[0] = 0.0;
        this.m_majorHashExtent[1] = this.m_defhMajor;
        this.m_majorHashExtent[2] = 0.0;
        this.m_majorHashExtent[3] = this.m_defhMajor;
        this.m_minorHashExtent[0] = 0.0;
        this.m_minorHashExtent[1] = this.m_defhMinor;
        this.m_minorHashExtent[2] = 0.0;
        this.m_minorHashExtent[3] = this.m_defhMinor;
        this.m_majorHashExtentColor = this.m_defhMajorColor;
        this.m_minorHashExtentColor = this.m_defhMinorColor;
        this.m_numMajorHashings.setDefValue(this.m_defNumMajorHashings);
        this.m_numMajorHashings.init();
        this.m_numMinorHashings.setDefValue(this.m_defNumMinorHashings);
        this.m_numMinorHashings.init();
        this.m_majorHashUnits.setDefValue(this.m_defMajorHashUnit);
        this.m_majorHashUnits.init();
        this.m_minorHashUnits.setDefValue(this.m_defMinorHashUnit);
        this.m_minorHashUnits.init();
        this.m_minMax.m_data[0] = this.m_defMin;
        this.m_minMax.m_data[1] = this.m_defMax;
        this.showIndices(true);
        this.showVertices(true);
        this.setGlobalVertexSize(0.0);
        this.setGlobalPolygonSize(1.0);
        this.setDefaultLabelEnabled(false);
        this.showPolygons(true);
        this.showPolygonColors(true);
        this.assurePolygonColors();
    }

    public void setEndPoint(PdVector pdVector, PdVector pdVector2) {
        this.setDirection(PdVector.subNew(pdVector, this.m_origin));
        this.m_minMax.setEntry(0, 0.0);
        this.m_minMax.setEntry(1, PdVector.dist(pdVector, this.m_origin));
        if (pdVector.getSize() == 3) {
            this.setNormal(PdVector.crossNew(pdVector2, this.m_v));
            return;
        }
        if (Math.abs(this.m_v.m_data[1]) < 0.001) {
            this.setNormal(new PdVector(this.m_v.m_data[2], 0.0, this.m_v.m_data[0]));
            return;
        }
        if (Math.abs(this.m_v.m_data[0]) < 0.001) {
            this.setNormal(new PdVector(0.0, -this.m_v.m_data[2], this.m_v.m_data[1]));
            return;
        }
        if (Math.abs(this.m_v.m_data[2]) < 0.001) {
            this.setNormal(new PdVector(-this.m_v.m_data[1], this.m_v.m_data[0], 0.0));
            return;
        }
        this.setNormal(new PdVector(0.0, 0.0, 1.0));
    }

    protected static int hashInterval(int n, double[] dArray, double d, double d2, boolean bl, double d3, boolean bl2) {
        double d4;
        double d5 = 1.0E-7;
        double d6 = bl ? d * Math.ceil(d2 / d) : d * Math.floor((d2 + d) / d);
        double d7 = d4 = bl2 ? d * Math.floor(d3 / d) : d * Math.ceil((d3 - d) / d);
        if (Math.abs(d6 - d2) < d5) {
            d6 += d;
        }
        if (Math.abs(d4 - d3) < d5) {
            d4 -= d;
        }
        double d8 = d6;
        while (d8 <= d4 + 1.0E-7 && n < dArray.length) {
            dArray[n++] = d8;
            d8 += d;
        }
        return n;
    }

    protected int partitionInterval(int n, double[] dArray, int n2, double d, boolean bl, double d2, boolean bl2) {
        double d3 = (d2 - d) / (double)(n2 + 1);
        if (!bl) {
            d += d3;
        }
        if (!bl2) {
            d2 -= d3;
        }
        double d4 = d;
        while (d4 <= d2 + 1.0E-7 && n < dArray.length) {
            dArray[n++] = d4;
            d4 += d3;
        }
        return n;
    }

    public void setHashLabel(int n, int n2, int n3, int n4) {
        this.setLabelAttribute(0, n, n2, n3, n4, 1);
    }

    public void setDirection(PdVector pdVector) {
        this.m_v.copy(pdVector);
        this.m_v.normalize();
    }
}

