/*
 * Decompiled with CFR 0.152.
 */
package jv.thirdParty.ruler;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.number.PdVector_IP;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.thirdParty.ruler.PgRuler;

public class PgRuler_CP
extends PsPanel
implements ActionListener,
ItemListener {
    protected PgRuler m_ruler;
    protected CheckboxGroup m_cbg;
    protected Checkbox m_cFixedMode;
    protected Checkbox m_cDynamicMode;
    protected Checkbox m_currentCB;
    protected Checkbox m_cMajor;
    protected Checkbox m_cMinor;
    protected Checkbox m_cLabels;
    protected Checkbox m_cName;
    protected Label m_lTitle;
    protected Panel m_pFixed;
    protected Panel m_pDynamic;
    protected Panel m_pHashType;
    protected PdVector_IP m_pminMax;
    private static /* synthetic */ Class class$jv$thirdParty$ruler$PgRuler_CP;

    public PgRuler_CP() {
        if (this.getClass() == (class$jv$thirdParty$ruler$PgRuler_CP != null ? class$jv$thirdParty$ruler$PgRuler_CP : (class$jv$thirdParty$ruler$PgRuler_CP = PgRuler_CP.class$("jv.thirdParty.ruler.PgRuler_CP")))) {
            this.init();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.m_ruler == null) {
            return;
        }
        Object object = itemEvent.getSource();
        if (object == this.m_cMajor) {
            this.m_ruler.showMajorHashings(this.m_cMajor.getState());
        } else if (object == this.m_cMinor) {
            this.m_ruler.showMinorHashings(this.m_cMinor.getState());
        } else if (object == this.m_cLabels) {
            this.m_ruler.showLabels(this.m_cLabels.getState());
        } else if (object == this.m_cName) {
            this.m_ruler.showRulerName(this.m_cName.getState());
        } else if (object == this.m_cFixedMode) {
            this.m_ruler.showFixedMode(true);
        } else if (object == this.m_cDynamicMode) {
            this.m_ruler.showFixedMode(false);
        } else {
            return;
        }
        this.m_ruler.update(this.m_ruler);
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.m_ruler = (PgRuler)psUpdateIf;
        this.setTitle("Custumize Ruler: " + this.m_ruler.m_rulerName);
        this.m_pminMax.setVector(this.m_ruler.m_minMax);
        this.m_pDynamic.removeAll();
        this.m_pDynamic.add(this.m_ruler.m_numMajorHashings.getInfoPanel());
        this.m_pDynamic.add(this.m_ruler.m_numMinorHashings.getInfoPanel());
        this.m_pFixed.removeAll();
        this.m_pFixed.add(this.m_ruler.m_majorHashUnits.getInfoPanel());
        this.m_pFixed.add(this.m_ruler.m_minorHashUnits.getInfoPanel());
        this.validate();
    }

    public boolean update(Object object) {
        if (this.m_ruler == null) {
            PsDebug.warning("missing ruler");
            return true;
        }
        if (object == this.m_ruler) {
            if (this.m_cMajor.getState() != this.m_ruler.isShowingMajorHashings()) {
                this.m_cMajor.setState(this.m_ruler.isShowingMajorHashings());
            }
            if (this.m_cMinor.getState() != this.m_ruler.isShowingMinorHashings()) {
                this.m_cMinor.setState(this.m_ruler.isShowingMinorHashings());
            }
            if (this.m_cLabels.getState() != this.m_ruler.isShowingLabels()) {
                this.m_cLabels.setState(this.m_ruler.isShowingLabels());
            }
            if (this.m_cName.getState() != this.m_ruler.isShowingRulerName()) {
                this.m_cName.setState(this.m_ruler.isShowingRulerName());
            }
            if (this.m_cbg.getSelectedCheckbox() != this.m_currentCB) {
                this.m_currentCB = this.m_cbg.getSelectedCheckbox();
                if (this.m_currentCB == this.m_cFixedMode) {
                    this.m_ruler.showFixedMode(true);
                } else if (this.m_currentCB == this.m_cDynamicMode) {
                    this.m_ruler.showFixedMode(false);
                }
                this.showModePanels(this.m_currentCB);
            }
            this.m_pminMax.setVector(this.m_ruler.m_minMax);
            return true;
        }
        if (object == this.m_pminMax) {
            return this.m_ruler.update(this.m_ruler);
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_ruler == null) {
            return;
        }
    }

    protected void showModePanels(Checkbox checkbox) {
        if (checkbox == this.m_cFixedMode) {
            this.m_pHashType.remove(this.m_pDynamic);
            this.m_pHashType.add(this.m_pFixed);
        } else {
            this.m_pHashType.remove(this.m_pFixed);
            this.m_pHashType.add(this.m_pDynamic);
        }
        this.validate();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        this.addTitle("Customize Ruler");
        this.addLine(1);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 3));
        this.add(panel);
        Component component = new Label("Ruler Style:");
        panel.add(component);
        this.m_cbg = new CheckboxGroup();
        this.m_cFixedMode = new Checkbox("Origin-Fixed", this.m_cbg, true);
        this.m_cFixedMode.addItemListener(this);
        panel.add(this.m_cFixedMode);
        this.m_cDynamicMode = new Checkbox("Partitioned", this.m_cbg, false);
        this.m_cDynamicMode.addItemListener(this);
        panel.add(this.m_cDynamicMode);
        this.m_currentCB = null;
        component = new PsPanel();
        ((Container)component).setLayout(new GridLayout(1, 4));
        this.add(component);
        this.m_cName = new Checkbox("Name");
        this.m_cName.addItemListener(this);
        ((Container)component).add(this.m_cName);
        this.m_cLabels = new Checkbox("Labels");
        this.m_cLabels.addItemListener(this);
        ((Container)component).add(this.m_cLabels);
        this.m_cMajor = new Checkbox("Major |");
        this.m_cMajor.addItemListener(this);
        ((Container)component).add(this.m_cMajor);
        this.m_cMinor = new Checkbox("Minor |");
        this.m_cMinor.addItemListener(this);
        ((Container)component).add(this.m_cMinor);
        PsPanel psPanel = new PsPanel();
        psPanel.setLayout(new GridLayout(1, 1));
        this.m_pminMax = new PdVector_IP();
        this.m_pminMax.setTitle("Min|Max Parameter:");
        this.m_pminMax.setParent(this);
        psPanel.add(this.m_pminMax);
        this.add(psPanel);
        this.m_pHashType = new PsPanel();
        this.m_pHashType.setLayout(new GridLayout(1, 1));
        this.m_pDynamic = new PsPanel();
        this.m_pDynamic.setLayout(new GridLayout(2, 1));
        this.m_pFixed = new PsPanel();
        this.m_pFixed.setLayout(new GridLayout(2, 1));
        this.add(this.m_pHashType);
    }
}

