/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import java.io.Serializable;
import jv.object.PsDebug;

public abstract class P_Vector
implements Serializable {
    protected static final int NUM_BITS = 32;
    protected static final int BITS = 6;
    protected static final int MASK = 63;
    protected long[] m_bits;
    protected String m_name;
    protected int[] m_constraint;

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\t" + super.toString());
        stringBuffer.append("\n");
        stringBuffer.append("\t ******* P_Vector ***********\n");
        stringBuffer.append("\t Name = ");
        if (this.m_name != null) {
            stringBuffer.append(this.getName());
        }
        if (this.m_bits != null && this.m_bits.length > 0) {
            stringBuffer.append("\t Attr = (" + this.m_bits[0]);
            n = 1;
            while (n < this.m_bits.length) {
                stringBuffer.append(", " + this.m_bits[n]);
                ++n;
            }
            stringBuffer.append(")\n");
        } else {
            stringBuffer.append("\t Attr = null\n");
        }
        if (this.m_constraint != null && this.m_constraint.length > 0) {
            stringBuffer.append("\t Constraint = (" + this.m_constraint[0]);
            n = 1;
            while (n < this.m_constraint.length) {
                stringBuffer.append(", " + this.m_constraint[n]);
                ++n;
            }
            stringBuffer.append(")\n");
        } else {
            stringBuffer.append("\t Constraint = null\n");
        }
        return stringBuffer.toString();
    }

    public void clearTag(int n) {
        if (this.m_bits == null) {
            return;
        }
        int n2 = n >> 6;
        if (n2 >= this.m_bits.length) {
            this.grow(n);
        }
        int n3 = n2;
        this.m_bits[n3] = this.m_bits[n3] & (1L << (n & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private void create(int n) {
        this.m_bits = new long[n + 63 >> 6];
    }

    public void setTag(int n) {
        int n2;
        if (this.m_bits == null) {
            this.create(32);
        }
        if ((n2 = n >> 6) >= this.m_bits.length) {
            this.grow(n);
        }
        int n3 = n2;
        this.m_bits[n3] = this.m_bits[n3] | 1L << (n & 0x3F);
    }

    public boolean hasTag(int n) {
        if (this.m_bits == null) {
            return false;
        }
        int n2 = n >> 6;
        if (n2 < this.m_bits.length) {
            return (this.m_bits[n2] & 1L << (n & 0x3F)) != 0L;
        }
        return false;
    }

    public void copy(P_Vector p_Vector) {
        if (p_Vector == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (p_Vector.m_bits == null) {
            this.m_bits = null;
        } else {
            if (this.m_bits == null || this.m_bits.length < p_Vector.m_bits.length) {
                this.create(p_Vector.m_bits.length);
            }
            int n = this.m_bits.length - 1;
            while (n >= 0) {
                this.m_bits[n] = p_Vector.m_bits[n];
                --n;
            }
        }
        this.m_name = p_Vector.m_name;
    }

    public long[] getBits() {
        return this.m_bits;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    private void grow(int n) {
        long[] lArray = new long[Math.max(this.m_bits.length << 1, n + 63 >> 6)];
        int n2 = this.m_bits.length - 1;
        while (n2 >= 0) {
            this.m_bits[n2] = lArray[n2];
            --n2;
        }
        this.m_bits = lArray;
    }

    public static P_Vector[][] clone(P_Vector[][] p_VectorArray) {
        P_Vector[][] p_VectorArray2 = (P_Vector[][])p_VectorArray.clone();
        if (p_VectorArray2 == null) {
            return null;
        }
        int n = 0;
        while (n < p_VectorArray.length) {
            if (p_VectorArray[n] != null) {
                p_VectorArray2[n] = P_Vector.clone(p_VectorArray[n]);
            }
            ++n;
        }
        return p_VectorArray2;
    }

    public static P_Vector[] clone(P_Vector[] p_VectorArray) {
        P_Vector[] p_VectorArray2 = (P_Vector[])p_VectorArray.clone();
        if (p_VectorArray2 == null) {
            return null;
        }
        try {
            int n = 0;
            while (n < p_VectorArray.length) {
                if (p_VectorArray[n] != null) {
                    p_VectorArray2[n] = (P_Vector)p_VectorArray[n].clone();
                }
                ++n;
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
        return p_VectorArray2;
    }
}

