/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import jv.number.PuString;
import jv.object.PsDebug;
import jv.vecmath.P_Vector;
import jv.vecmath.PdMatrix;
import jv.vecmath.PuData;
import jv.vecmath.PuMath;

public class PdVector
extends P_Vector {
    public double[] m_data;

    public static double[][] getEntries(PdVector[] pdVectorArray) {
        if (pdVectorArray == null) {
            return null;
        }
        int n = pdVectorArray.length;
        double[][] dArrayArray = new double[n][];
        int n2 = 0;
        while (n2 < n) {
            dArrayArray[n2] = pdVectorArray[n2].getEntries();
            ++n2;
        }
        return dArrayArray;
    }

    public double[] getEntries() {
        return (double[])this.m_data.clone();
    }

    public void leftMultAffin(PdMatrix pdMatrix, PdVector pdVector, boolean bl) {
        int n;
        int n2 = this.m_data.length;
        if (pdMatrix.m_iSize != pdMatrix.m_jSize || pdMatrix.m_iSize - 1 != n2) {
            PsDebug.warning("argument not square or incompatible sizes");
            return;
        }
        if (this == pdVector) {
            PsDebug.warning("this must be different from argument");
            return;
        }
        if (bl) {
            n = 0;
            while (n < n2) {
                this.m_data[n] = pdMatrix.m_data[n][n2];
                ++n;
            }
        } else {
            this.setConstant(0.0);
        }
        n = 0;
        while (n < n2) {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n;
                this.m_data[n4] = this.m_data[n4] + pdMatrix.m_data[n][n3] * pdVector.m_data[n3];
                ++n3;
            }
            ++n;
        }
    }

    public double getEntry(int n) {
        if (n < 0 || this.m_data.length <= n) {
            PsDebug.warning("index out of range, index=" + n);
            return 0.0;
        }
        return this.m_data[n];
    }

    public void setEntry(int n, double d) {
        if (this.m_data.length <= n) {
            this.setSize(n + 1);
        }
        this.m_data[n] = d;
    }

    public void setEntry(int n, int n2) {
        this.setEntry(n, (double)n2);
    }

    public double getLastEntry() {
        if (this.m_data == null || this.m_data.length == 0) {
            PsDebug.warning("empty vector.");
            return 0.0;
        }
        return this.m_data[this.m_data.length - 1];
    }

    public void setLastEntry(double d) {
        if (this.m_data == null || this.m_data.length == 0) {
            PsDebug.warning("empty vector.");
            return;
        }
        this.m_data[this.m_data.length - 1] = d;
    }

    public int indexOfMax() {
        int n = 0;
        double d = Double.NEGATIVE_INFINITY;
        int n2 = 0;
        while (n2 < this.m_data.length) {
            if (this.m_data[n2] > d) {
                d = this.m_data[n2];
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public PdVector orthogonalPart(PdVector pdVector, PdVector pdVector2) {
        if (pdVector == null) {
            pdVector = new PdVector(this.getSize());
        }
        double d = PdVector.dot(this, pdVector2);
        pdVector.blendBase(this, -d, pdVector2);
        return pdVector;
    }

    public static double angleWithOrientation(double[] dArray, PdVector[] pdVectorArray, int n) {
        if (dArray == null || pdVectorArray == null) {
            PsDebug.warning("missing angle or vertex array.");
            return 0.0;
        }
        if (dArray.length < n || pdVectorArray.length < n) {
            PsDebug.warning("angle or vertex array too small.");
            return 0.0;
        }
        if (pdVectorArray.length < 1 || pdVectorArray[0] == null) {
            PsDebug.warning("empty polygon, no vertex found.");
            return 0.0;
        }
        int n2 = pdVectorArray[0].getSize();
        PdVector[] pdVectorArray2 = new PdVector[n];
        PdVector pdVector = new PdVector(n2);
        PdVector pdVector2 = new PdVector(n2);
        int n3 = 0;
        while (n3 < n) {
            pdVectorArray2[n3] = PdVector.subNew(pdVectorArray[(n3 + 1) % n], pdVectorArray[n3]);
            pdVectorArray2[n3].normalize();
            ++n3;
        }
        boolean bl = true;
        double d = 0.0;
        n3 = 0;
        while (n3 < n) {
            int n4 = (n3 - 1 + n) % n;
            dArray[n3] = PdVector.dot(pdVectorArray2[n4], pdVectorArray2[n3]);
            if (dArray[n3] < -1.0) {
                dArray[n3] = -1.0;
            } else if (dArray[n3] > 1.0) {
                dArray[n3] = 1.0;
            }
            dArray[n3] = Math.acos(dArray[n3]);
            if (!bl) {
                dArray[n3] = -dArray[n3];
            }
            d += dArray[n3];
            int n5 = (n3 + 1 + n) % n;
            pdVector = pdVectorArray2[n4].orthogonalPart(pdVector, pdVectorArray2[n3]);
            pdVector = pdVectorArray2[n5].orthogonalPart(pdVector2, pdVectorArray2[n3]);
            if (PdVector.dot(pdVector2, pdVector) > 0.0) {
                bl = !bl;
            }
            ++n3;
        }
        if (d < 0.0) {
            n3 = 0;
            while (n3 < n) {
                dArray[n3] = -dArray[n3];
                ++n3;
            }
            d = -d;
        }
        return d;
    }

    public static double angleWithOrientation(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        double d = pdVector.length();
        double d2 = pdVector2.length();
        if (d == 0.0 || d2 == 0.0) {
            return 0.0;
        }
        double d3 = PdVector.dot(pdVector, pdVector2) / d / d2;
        if (d3 < -1.0) {
            d3 = -1.0;
        } else if (d3 > 1.0) {
            d3 = 1.0;
        }
        d3 = Math.acos(d3);
        PdVector pdVector4 = PdVector.crossNew(pdVector, pdVector2);
        if (PdVector.dot(pdVector4, pdVector3) < 0.0) {
            d3 = -d3;
        }
        return d3;
    }

    public static double dist(PdVector pdVector, PdVector pdVector2) {
        double d = 0.0;
        int n = 0;
        while (n < pdVector.m_data.length) {
            double d2 = pdVector.m_data[n] - pdVector2.m_data[n];
            d += d2 * d2;
            ++n;
        }
        return Math.sqrt(d);
    }

    public double dist(PdVector pdVector) {
        double d = 0.0;
        int n = 0;
        while (n < this.m_data.length) {
            double d2 = this.m_data[n] - pdVector.m_data[n];
            d += d2 * d2;
            ++n;
        }
        return Math.sqrt(d);
    }

    public static PdVector[] copyNew(double[][] dArray) {
        if (dArray == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        int n = dArray.length;
        PdVector[] pdVectorArray = new PdVector[n];
        int n2 = 0;
        while (n2 < n) {
            pdVectorArray[n2] = new PdVector(dArray[n2]);
            ++n2;
        }
        return pdVectorArray;
    }

    public static PdVector[] copyNew(PdVector[] pdVectorArray) {
        if (pdVectorArray == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        return PdVector.copyNew(pdVectorArray, pdVectorArray.length);
    }

    public static PdVector[] copyNew(PdVector[] pdVectorArray, int n) {
        if (pdVectorArray == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        PdVector[] pdVectorArray2 = new PdVector[n];
        int n2 = 0;
        while (n2 < n) {
            pdVectorArray2[n2] = PdVector.copyNew(pdVectorArray[n2]);
            ++n2;
        }
        return pdVectorArray2;
    }

    public static PdVector copyNew(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing argument vector");
            return null;
        }
        if (pdVector.m_data == null) {
            PsDebug.warning("missing data of argument vector.");
            return null;
        }
        PdVector pdVector2 = new PdVector(pdVector.m_data.length);
        pdVector2.copy(pdVector);
        return pdVector2;
    }

    public static PdVector crossNew(PdVector pdVector, PdVector pdVector2) {
        PdVector pdVector3 = new PdVector(3);
        pdVector3.cross(pdVector, pdVector2);
        return pdVector3;
    }

    public boolean equals(double[] dArray) {
        int n = this.getSize();
        if (dArray == null && n == 0) {
            return true;
        }
        if (dArray == null) {
            return false;
        }
        if (n != dArray.length) {
            return false;
        }
        --n;
        while (n >= 0) {
            if (this.m_data[n] != dArray[n]) {
                return false;
            }
            --n;
        }
        return true;
    }

    public boolean equals(PdVector pdVector) {
        if (pdVector == null && this.getSize() == 0) {
            return true;
        }
        return this.equals(pdVector.m_data);
    }

    public boolean equals(PdVector pdVector, double d) {
        if (pdVector == null && this.getSize() == 0) {
            return true;
        }
        if (this.getSize() != pdVector.getSize()) {
            return false;
        }
        return !(PdVector.sqrDist(this, pdVector) > d * d);
    }

    public static PdVector normalToVectorNew(PdVector pdVector) {
        PdVector pdVector2 = new PdVector(pdVector.getSize());
        pdVector2.normalToVector(pdVector);
        return pdVector2;
    }

    public static int getSameSize(PdVector[] pdVectorArray, int n) {
        if (pdVectorArray == null || pdVectorArray.length == 0) {
            return -1;
        }
        if (pdVectorArray[0] == null) {
            return -1;
        }
        if (pdVectorArray.length < n) {
            PsDebug.warning("used vectors larger than array size.");
            n = pdVectorArray.length;
        }
        int n2 = pdVectorArray[0].getSize();
        int n3 = 1;
        while (n3 < n) {
            if (n2 != pdVectorArray[n3].getSize()) {
                n2 = -1;
                break;
            }
            ++n3;
        }
        return n2;
    }

    public int getSize() {
        if (this.m_data == null) {
            return 0;
        }
        return this.m_data.length;
    }

    public int setSize(int n) {
        if (this.m_data == null) {
            this.m_data = new double[n];
        } else if (this.m_data.length != n) {
            this.m_data = PuData.realloc(this.m_data, n);
        }
        return n;
    }

    public void blendBase(PdVector pdVector, double d, PdVector pdVector2) {
        if (this.m_data == null) {
            this.setSize(pdVector.m_data.length);
        }
        if (this.m_data.length != pdVector.m_data.length || this.m_data.length != pdVector2.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        int n = 0;
        while (n < this.m_data.length) {
            this.m_data[n] = pdVector.m_data[n] + d * pdVector2.m_data[n];
            ++n;
        }
    }

    public Object clone() {
        return PdVector.copyNew(this);
    }

    public double sqrLength() {
        double d = 0.0;
        int n = 0;
        while (n < this.m_data.length) {
            d += this.m_data[n] * this.m_data[n];
            ++n;
        }
        return d;
    }

    public double length() {
        return PdVector.length(this.m_data.length, this.m_data);
    }

    public static double length(int n, double[] dArray) {
        double d = 0.0;
        int n2 = 0;
        while (n2 < n) {
            d += dArray[n2] * dArray[n2];
            ++n2;
        }
        return Math.sqrt(d);
    }

    public boolean setLength(double d) {
        double d2 = this.length();
        if (d2 == 0.0) {
            return false;
        }
        d2 /= d;
        int n = 0;
        while (n < this.m_data.length) {
            int n2 = n++;
            this.m_data[n2] = this.m_data[n2] / d2;
        }
        return true;
    }

    public int changeValue(int n, double d, double d2) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (this.m_data[n3] == d) {
                this.m_data[n3] = d2;
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public int changeValue(double d, double d2) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_data.length) {
            if (this.m_data[n2] == d) {
                this.m_data[n2] = d2;
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PdVector ***********\n");
        int n = this.getSize();
        stringBuffer.append("\t size\t = " + n + "\n");
        if (n > 0) {
            stringBuffer.append("\t m_data = (" + this.m_data[0]);
            int n2 = 1;
            while (n2 < n) {
                stringBuffer.append(", " + this.m_data[n2]);
                ++n2;
            }
            stringBuffer.append(")\n");
        } else {
            stringBuffer.append("\t m_data = null\n");
        }
        return stringBuffer.toString();
    }

    public boolean normalOfPlane(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        PdVector pdVector4;
        PdVector pdVector5 = PdVector.subNew(pdVector, pdVector2);
        if (!this.cross(pdVector5, pdVector4 = PdVector.subNew(pdVector, pdVector3))) {
            return false;
        }
        return this.normalize();
    }

    public static final boolean max(PdVector pdVector, PdVector[] pdVectorArray, int n) {
        if (pdVectorArray == null || pdVectorArray.length == 0 || pdVectorArray.length < n || pdVectorArray[0] == null) {
            PsDebug.warning("null pointer argument or array too small");
            return false;
        }
        if (pdVector == null || pdVector.m_data == null) {
            PsDebug.warning("missing max argument");
            return false;
        }
        if (n == 0) {
            pdVector.setConstant(0.0);
            return false;
        }
        pdVector.setConstant(Double.NEGATIVE_INFINITY);
        int n2 = 0;
        while (n2 < n) {
            int n3 = Math.min(pdVector.m_data.length, pdVectorArray[n2].m_data.length) - 1;
            while (n3 >= 0) {
                if (pdVector.m_data[n3] < pdVectorArray[n2].m_data[n3]) {
                    pdVector.m_data[n3] = pdVectorArray[n2].m_data[n3];
                }
                --n3;
            }
            ++n2;
        }
        return true;
    }

    public double max() {
        double d = -1.7976931348623157E308;
        int n = 0;
        while (n < this.m_data.length) {
            if (this.m_data[n] > d) {
                d = this.m_data[n];
            }
            ++n;
        }
        return d;
    }

    public static double area(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        double d;
        double d2;
        double d3 = PdVector.dist(pdVector2, pdVector3);
        double d4 = (d3 + (d2 = PdVector.dist(pdVector3, pdVector)) + (d = PdVector.dist(pdVector, pdVector2))) / 2.0;
        double d5 = d4 * (d4 - d3) * (d4 - d2) * (d4 - d);
        if (d5 < 0.0) {
            return 0.0;
        }
        return Math.sqrt(d5);
    }

    public static double area(PdVector[] pdVectorArray) {
        if (pdVectorArray == null) {
            PsDebug.warning("missing points");
            return 0.0;
        }
        if (pdVectorArray.length < 3) {
            PsDebug.warning("array must have length >=3", pdVectorArray);
            return 0.0;
        }
        double d = 0.0;
        int n = 2;
        while (n < pdVectorArray.length) {
            double d2;
            double d3;
            double d4 = PdVector.dist(pdVectorArray[n - 1], pdVectorArray[n]);
            double d5 = (d4 + (d3 = PdVector.dist(pdVectorArray[n], pdVectorArray[0])) + (d2 = PdVector.dist(pdVectorArray[0], pdVectorArray[n - 1]))) / 2.0;
            double d6 = d5 * (d5 - d4) * (d5 - d3) * (d5 - d2);
            if (d6 > 0.0) {
                d += Math.sqrt(d6);
            }
            ++n;
        }
        return d;
    }

    public static double sqrDist(PdVector pdVector, PdVector pdVector2) {
        double d = 0.0;
        int n = 0;
        while (n < pdVector.m_data.length) {
            double d2 = pdVector.m_data[n] - pdVector2.m_data[n];
            d += d2 * d2;
            ++n;
        }
        return d;
    }

    public void sub(PdVector pdVector) {
        if (this.m_data == null) {
            this.setSize(pdVector.m_data.length);
        }
        if (this.m_data.length != pdVector.m_data.length) {
            return;
        }
        int n = 0;
        while (n < this.m_data.length) {
            int n2 = n;
            this.m_data[n2] = this.m_data[n2] - pdVector.m_data[n];
            ++n;
        }
    }

    public void sub(PdVector pdVector, PdVector pdVector2) {
        if (this.m_data == null) {
            this.setSize(pdVector.m_data.length);
        }
        if (this.m_data.length != pdVector.m_data.length) {
            return;
        }
        int n = 0;
        while (n < this.m_data.length) {
            this.m_data[n] = pdVector.m_data[n] - pdVector2.m_data[n];
            ++n;
        }
    }

    public double sqrDist(PdVector pdVector) {
        double d = 0.0;
        int n = 0;
        while (n < this.m_data.length) {
            double d2 = this.m_data[n] - pdVector.m_data[n];
            d += d2 * d2;
            ++n;
        }
        return d;
    }

    public double getFirstEntry() {
        if (this.m_data == null || this.m_data.length == 0) {
            PsDebug.warning("empty vector.");
            return 0.0;
        }
        return this.m_data[0];
    }

    public static boolean copy(PdVector[] pdVectorArray, int n, PdVector[] pdVectorArray2, int n2, int n3) {
        if (pdVectorArray == null || pdVectorArray.length < n + n3) {
            PsDebug.warning("missing space in dataDest", pdVectorArray2);
            return false;
        }
        int n4 = 0;
        while (n4 < n3) {
            pdVectorArray[n + n4].copy(pdVectorArray2[n2 + n4]);
            ++n4;
        }
        return true;
    }

    public void setFirstEntry(double d) {
        if (this.m_data == null || this.m_data.length == 0) {
            PsDebug.warning("empty vector.");
            return;
        }
        this.m_data[0] = d;
    }

    public boolean copy(int n, PdVector pdVector, int n2, int n3) {
        if (this.m_data.length < n + n3) {
            PsDebug.warning("missing space in this");
            return false;
        }
        if (this.m_data == null || this.m_data.length < n + n3) {
            this.setSize(n + n3);
        }
        System.arraycopy(pdVector.m_data, n2, this.m_data, n, n3);
        return true;
    }

    public void copy(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing argument vector");
            return;
        }
        if (pdVector.m_data == null) {
            PsDebug.warning("missing data of argument vector");
            return;
        }
        this.copyArray(pdVector);
        super.copy(pdVector);
    }

    public void copy(double[] dArray, int n) {
        if (dArray == null) {
            PsDebug.warning("null vector 'anArray' passed");
            return;
        }
        if (this.m_data == null) {
            this.setSize(n);
        }
        int n2 = Math.min(this.m_data.length, n);
        System.arraycopy(dArray, 0, this.m_data, 0, n2);
        int n3 = n2;
        while (n3 < this.m_data.length) {
            this.m_data[n3] = 0.0;
            ++n3;
        }
    }

    public void copy(double[] dArray, int n, int n2) {
        if (dArray == null) {
            PsDebug.warning("null vector 'anArray' passed");
            return;
        }
        if (dArray.length < n + n2) {
            PsDebug.warning("ind+size is bigger than array");
            return;
        }
        if (this.m_data == null) {
            this.setSize(n2);
        }
        int n3 = Math.min(this.m_data.length, n2);
        System.arraycopy(dArray, n, this.m_data, 0, n3);
        int n4 = n3;
        while (n4 < this.m_data.length) {
            this.m_data[n4] = 0.0;
            ++n4;
        }
    }

    public int indexOfAbsMin() {
        int n = 0;
        double d = Double.MAX_VALUE;
        int n2 = 0;
        while (n2 < this.m_data.length) {
            if (Math.abs(this.m_data[n2]) < d) {
                d = Math.abs(this.m_data[n2]);
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public void normalToVector(PdVector pdVector) {
        this.setLength(pdVector.getSize());
        this.setConstant(1.0);
        this.m_data[pdVector.indexOfAbsMax()] = 0.0;
        this.orthonormalize(pdVector);
    }

    public static void setConstant(PdVector[] pdVectorArray, double d) {
        if (pdVectorArray == null || pdVectorArray.length == 0 || pdVectorArray[0] == null) {
            return;
        }
        int n = 0;
        while (n < pdVectorArray.length) {
            pdVectorArray[n].setConstant(d);
            ++n;
        }
    }

    public static void setConstant(PdVector[] pdVectorArray, double[] dArray) {
        if (pdVectorArray == null || pdVectorArray.length == 0 || pdVectorArray[0] == null) {
            return;
        }
        if (pdVectorArray[0].m_data.length != dArray.length) {
            PsDebug.warning("arrays have different length");
            return;
        }
        int n = Math.min(pdVectorArray[0].m_data.length, dArray.length);
        int n2 = 0;
        while (n2 < pdVectorArray.length) {
            int n3 = 0;
            while (n3 < n) {
                pdVectorArray[n2].m_data[n3] = dArray[n3];
                ++n3;
            }
            ++n2;
        }
    }

    public static void setConstant(PdVector[] pdVectorArray, PdVector pdVector) {
        if (pdVector == null || pdVector.m_data == null) {
            return;
        }
        PdVector.setConstant(pdVectorArray, pdVector.m_data);
    }

    public static void setConstant(PdVector pdVector, double d) {
        if (pdVector == null || pdVector.m_data == null) {
            return;
        }
        int n = pdVector.getSize() - 1;
        while (n >= 0) {
            pdVector.m_data[n] = d;
            --n;
        }
    }

    public void setConstant(double d) {
        if (this.m_data == null) {
            return;
        }
        int n = this.m_data.length - 1;
        while (n >= 0) {
            this.m_data[n] = d;
            --n;
        }
    }

    public int addEntry(double d) {
        int n = this.setSize(this.getSize() + 1);
        this.m_data[n - 1] = d;
        return n;
    }

    public int indexOfMin() {
        int n = 0;
        double d = Double.MAX_VALUE;
        int n2 = 0;
        while (n2 < this.m_data.length) {
            if (this.m_data[n2] < d) {
                d = this.m_data[n2];
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public static PdVector[] realloc(PdVector[] pdVectorArray, int n, int n2) {
        int n3;
        if (pdVectorArray != null && pdVectorArray.length == n) {
            int n4 = 0;
            while (n4 < pdVectorArray.length) {
                if (pdVectorArray[n4].m_data == null || pdVectorArray[n4].m_data.length != n2) {
                    pdVectorArray[n4].setSize(n2);
                }
                ++n4;
            }
            return pdVectorArray;
        }
        PdVector[] pdVectorArray2 = new PdVector[n];
        if (pdVectorArray == null) {
            n3 = 0;
        } else {
            n3 = Math.min(pdVectorArray.length, n);
            System.arraycopy(pdVectorArray, 0, pdVectorArray2, 0, n3);
        }
        int n5 = 0;
        while (n5 < n3) {
            if (pdVectorArray2[n5].m_data == null || pdVectorArray2[n5].m_data.length != n2) {
                pdVectorArray2[n5].setSize(n2);
            }
            ++n5;
        }
        n5 = n3;
        while (n5 < n) {
            pdVectorArray2[n5] = new PdVector(n2);
            ++n5;
        }
        return pdVectorArray2;
    }

    public static PdVector[] realloc(PdVector[] pdVectorArray, int n) {
        int n2;
        if (pdVectorArray != null && pdVectorArray.length == n) {
            return pdVectorArray;
        }
        PdVector[] pdVectorArray2 = new PdVector[n];
        if (pdVectorArray == null) {
            n2 = 0;
        } else {
            n2 = Math.min(pdVectorArray.length, n);
            System.arraycopy(pdVectorArray, 0, pdVectorArray2, 0, n2);
        }
        int n3 = n2;
        while (n3 < n) {
            pdVectorArray2[n3] = new PdVector();
            ++n3;
        }
        return pdVectorArray2;
    }

    public static double getOrientation(PdVector[] pdVectorArray) {
        int n = pdVectorArray.length;
        PdMatrix pdMatrix = new PdMatrix(n);
        int n2 = 0;
        while (n2 < n) {
            if (pdVectorArray[n2] == null || pdVectorArray[n2].getSize() < n) {
                PsDebug.warning("missing or invalid vector v[" + n2 + "]");
                return 0.0;
            }
            int n3 = 0;
            while (n3 < n) {
                pdMatrix.m_data[n2][n3] = pdVectorArray[n2].m_data[n3];
                ++n3;
            }
            ++n2;
        }
        return pdMatrix.det();
    }

    public boolean cross(PdVector pdVector, PdVector pdVector2) {
        if (this.m_data.length != 3) {
            return false;
        }
        int n = pdVector.getSize();
        int n2 = pdVector2.getSize();
        if (n == 3 && n2 == 3) {
            this.m_data[0] = pdVector.m_data[1] * pdVector2.m_data[2] - pdVector.m_data[2] * pdVector2.m_data[1];
            this.m_data[1] = -pdVector.m_data[0] * pdVector2.m_data[2] + pdVector.m_data[2] * pdVector2.m_data[0];
            this.m_data[2] = pdVector.m_data[0] * pdVector2.m_data[1] - pdVector.m_data[1] * pdVector2.m_data[0];
        } else if (n == 2 && n2 == 3) {
            this.m_data[0] = pdVector.m_data[1] * pdVector2.m_data[2];
            this.m_data[1] = -pdVector.m_data[0] * pdVector2.m_data[2];
            this.m_data[2] = pdVector.m_data[0] * pdVector2.m_data[1] - pdVector.m_data[1] * pdVector2.m_data[0];
        } else if (n == 3 && n2 == 2) {
            this.m_data[0] = -pdVector.m_data[2] * pdVector2.m_data[1];
            this.m_data[1] = pdVector.m_data[2] * pdVector2.m_data[0];
            this.m_data[2] = pdVector.m_data[0] * pdVector2.m_data[1] - pdVector.m_data[1] * pdVector2.m_data[0];
        } else if (n == 2 && n2 == 2) {
            this.set(0.0, 0.0, pdVector.m_data[0] * pdVector2.m_data[1] - pdVector.m_data[1] * pdVector2.m_data[0]);
        } else {
            PsDebug.error("wrong dimension of arguments: vSize = " + n + " wSize = " + n2, this);
            return false;
        }
        return true;
    }

    public static double dot(PdVector pdVector, PdVector pdVector2) {
        double d = 0.0;
        int n = 0;
        while (n < pdVector.m_data.length) {
            d += pdVector.m_data[n] * pdVector2.m_data[n];
            ++n;
        }
        return d;
    }

    public double dot(PdVector pdVector) {
        double d = 0.0;
        int n = 0;
        while (n < this.m_data.length) {
            d += this.m_data[n] * pdVector.m_data[n];
            ++n;
        }
        return d;
    }

    public boolean normalize() {
        double d = this.length();
        if (d < 1.0E-10) {
            return false;
        }
        int n = 0;
        while (n < this.m_data.length) {
            int n2 = n++;
            this.m_data[n2] = this.m_data[n2] / d;
        }
        return true;
    }

    public boolean normalize(PdVector pdVector) {
        double d = pdVector.length();
        if (d < 1.0E-10) {
            this.copy(pdVector);
            return false;
        }
        int n = 0;
        while (n < this.m_data.length) {
            this.m_data[n] = pdVector.m_data[n] / d;
            ++n;
        }
        return true;
    }

    public void add(double d) {
        if (this.m_data == null) {
            return;
        }
        int n = 0;
        while (n < this.m_data.length) {
            int n2 = n++;
            this.m_data[n2] = this.m_data[n2] + d;
        }
    }

    public void add(PdVector pdVector) {
        if (this.m_data == null) {
            this.setSize(pdVector.m_data.length);
        }
        if (this.m_data.length != pdVector.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        int n = 0;
        while (n < this.m_data.length) {
            int n2 = n;
            this.m_data[n2] = this.m_data[n2] + pdVector.m_data[n];
            ++n;
        }
    }

    public void add(PdVector pdVector, PdVector pdVector2) {
        if (this.m_data == null) {
            this.setSize(pdVector.m_data.length);
        }
        if (this.m_data.length != pdVector.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        int n = 0;
        while (n < this.m_data.length) {
            this.m_data[n] = pdVector.m_data[n] + pdVector2.m_data[n];
            ++n;
        }
    }

    public String toShortString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = this.getSize();
        if (this.m_data == null || n2 == 0) {
            stringBuffer.append("{ m_data = null} \t");
        } else {
            stringBuffer.append("{ " + String.valueOf(this.m_data[0]));
            n = 1;
            while (n < n2) {
                stringBuffer.append(", " + String.valueOf(this.m_data[n]));
                ++n;
            }
            stringBuffer.append("} \t");
        }
        stringBuffer.append("Attr = ");
        if (this.m_bits == null) {
            stringBuffer.append("{ } \t");
        } else {
            stringBuffer.append("{ " + PuString.intToString((int)this.m_bits[0], 4));
            n = 1;
            while (n < this.m_bits.length) {
                stringBuffer.append("\t " + PuString.intToString((int)this.m_bits[n], 4));
                ++n;
            }
            stringBuffer.append("} \t");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static double angle(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        PdVector pdVector4 = PdVector.subNew(pdVector, pdVector2);
        PdVector pdVector5 = PdVector.subNew(pdVector, pdVector3);
        return PdVector.angle(pdVector4, pdVector5);
    }

    public static void angle(double[] dArray, PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        PdVector.angle(dArray, new PdVector[]{pdVector, pdVector2, pdVector3});
    }

    public static void angle(double[] dArray, PdVector[] pdVectorArray) {
        int n = pdVectorArray.length;
        PdVector[] pdVectorArray2 = new PdVector[n];
        int n2 = 0;
        while (n2 < n) {
            pdVectorArray2[n2] = PdVector.subNew(pdVectorArray[(n2 + 1) % n], pdVectorArray[n2]);
            pdVectorArray2[n2].normalize();
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            dArray[n2] = PdVector.dot(pdVectorArray2[(n2 - 1 + n) % n], pdVectorArray2[n2]);
            if (dArray[n2] < -1.0) {
                dArray[n2] = -1.0;
            } else if (dArray[n2] > 1.0) {
                dArray[n2] = 1.0;
            }
            dArray[n2] = Math.PI - Math.acos(dArray[n2]);
            ++n2;
        }
    }

    public static double angle(PdVector pdVector, PdVector pdVector2) {
        double d = pdVector.length();
        double d2 = pdVector2.length();
        if (d == 0.0 || d2 == 0.0) {
            return 0.0;
        }
        double d3 = PdVector.dot(pdVector, pdVector2) / d / d2;
        if (d3 < -1.0) {
            d3 = -1.0;
        } else if (d3 > 1.0) {
            d3 = 1.0;
        }
        d3 = Math.acos(d3) * 180.0 / Math.PI;
        return d3;
    }

    public void copyArray(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing argument vector");
            return;
        }
        if (pdVector.m_data == null) {
            PsDebug.warning("missing data of argument vector");
            return;
        }
        int n = pdVector.m_data.length;
        if (this.m_data == null) {
            this.setSize(n);
        }
        if (this.m_data.length > n) {
            int n2 = n;
            while (n2 < this.m_data.length) {
                this.m_data[n2] = 0.0;
                ++n2;
            }
        } else {
            n = this.m_data.length;
        }
        switch (n) {
            case 3: {
                this.m_data[2] = pdVector.m_data[2];
            }
            case 2: {
                this.m_data[1] = pdVector.m_data[1];
            }
            case 1: {
                this.m_data[0] = pdVector.m_data[0];
                return;
            }
        }
        System.arraycopy(pdVector.m_data, 0, this.m_data, 0, n);
    }

    public void leftMultMatrix(PdMatrix pdMatrix) {
        if (pdMatrix.m_iSize != pdMatrix.m_jSize || pdMatrix.m_iSize != this.m_data.length) {
            PsDebug.warning("argument not square or incompatible sizes");
            return;
        }
        double[] dArray = new double[this.m_data.length];
        int n = 0;
        while (n < this.m_data.length) {
            dArray[n] = 0.0;
            int n2 = 0;
            while (n2 < this.m_data.length) {
                int n3 = n;
                dArray[n3] = dArray[n3] + pdMatrix.m_data[n][n2] * this.m_data[n2];
                ++n2;
            }
            ++n;
        }
        n = 0;
        while (n < this.m_data.length) {
            this.m_data[n] = dArray[n];
            ++n;
        }
    }

    public void leftMultMatrix(PdMatrix pdMatrix, PdVector pdVector) {
        if (this == pdVector) {
            PsDebug.warning("this vector must be different from argument vector");
            return;
        }
        if (this.m_data.length != pdMatrix.m_iSize) {
            this.setSize(pdMatrix.m_iSize);
        }
        int n = 0;
        while (n < pdMatrix.m_iSize) {
            this.m_data[n] = 0.0;
            int n2 = 0;
            while (n2 < pdVector.m_data.length) {
                int n3 = n;
                this.m_data[n3] = this.m_data[n3] + pdMatrix.m_data[n][n2] * pdVector.m_data[n2];
                ++n2;
            }
            ++n;
        }
    }

    public void invert(int n) {
        int n2 = n / 2;
        int n3 = 0;
        while (n3 < n2) {
            double d = this.m_data[n3];
            this.m_data[n3] = this.m_data[n - 1 - n3];
            this.m_data[n - 1 - n3] = d;
            ++n3;
        }
    }

    public void invert() {
        int n = this.m_data.length / 2;
        int n2 = 0;
        while (n2 < n) {
            double d = this.m_data[n2];
            this.m_data[n2] = this.m_data[this.m_data.length - 1 - n2];
            this.m_data[this.m_data.length - 1 - n2] = d;
            ++n2;
        }
    }

    public static final boolean min(PdVector pdVector, PdVector[] pdVectorArray, int n) {
        if (pdVectorArray == null || pdVectorArray.length == 0 || pdVectorArray.length < n || pdVectorArray[0] == null) {
            PsDebug.warning("null pointer argument or array too small");
            return false;
        }
        if (pdVector == null || pdVector.m_data == null) {
            PsDebug.warning("missing min argument");
            return false;
        }
        pdVector.setConstant(Double.MAX_VALUE);
        int n2 = 0;
        while (n2 < n) {
            int n3 = Math.min(pdVector.m_data.length, pdVectorArray[n2].m_data.length) - 1;
            while (n3 >= 0) {
                if (pdVector.m_data[n3] > pdVectorArray[n2].m_data[n3]) {
                    pdVector.m_data[n3] = pdVectorArray[n2].m_data[n3];
                }
                --n3;
            }
            ++n2;
        }
        return true;
    }

    public double min() {
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < this.m_data.length) {
            if (this.m_data[n] < d) {
                d = this.m_data[n];
            }
            ++n;
        }
        return d;
    }

    public double maxAbs() {
        double d = Double.NEGATIVE_INFINITY;
        int n = 0;
        while (n < this.m_data.length) {
            if (Math.abs(this.m_data[n]) > d) {
                d = Math.abs(this.m_data[n]);
            }
            ++n;
        }
        return d;
    }

    public static PdVector addNew(PdVector pdVector, PdVector pdVector2) {
        int n;
        if (pdVector == null || pdVector2 == null) {
            return null;
        }
        int n2 = pdVector.getSize();
        if (n2 != (n = pdVector2.getSize())) {
            n2 = Math.min(n2, n);
        }
        PdVector pdVector3 = new PdVector(n2);
        pdVector3.add(pdVector, pdVector2);
        return pdVector3;
    }

    public static PdVector blendNew(double d, PdVector pdVector, double d2, PdVector pdVector2) {
        PdVector pdVector3 = new PdVector(pdVector.getSize());
        pdVector3.blend(d, pdVector, d2, pdVector2);
        return pdVector3;
    }

    public void multScalar(double d) {
        int n = 0;
        while (n < this.m_data.length) {
            int n2 = n++;
            this.m_data[n2] = this.m_data[n2] * d;
        }
    }

    public void multScalar(PdVector pdVector, double d) {
        int n = 0;
        while (n < this.m_data.length) {
            this.m_data[n] = pdVector.m_data[n] * d;
            ++n;
        }
    }

    public void set(PdVector pdVector, int n, int n2) {
        if (pdVector == null || pdVector.getSize() < n + n2) {
            PsDebug.warning("argument array too small.");
            return;
        }
        if (this.m_data == null || this.m_data.length != n2) {
            this.setSize(n2);
        }
        int n3 = 0;
        while (n3 < n2) {
            this.m_data[n3] = pdVector.m_data[n + n3];
            ++n3;
        }
    }

    public void set(double[] dArray, int n, int n2) {
        if (dArray == null || dArray.length < n + n2) {
            PsDebug.warning("argument array too small.");
            return;
        }
        if (this.m_data == null || this.m_data.length != n2) {
            this.setSize(n2);
        }
        int n3 = 0;
        while (n3 < n2) {
            this.m_data[n3] = dArray[n + n3];
            ++n3;
        }
    }

    public void set(double[] dArray, int n) {
        this.set(dArray, 0, n);
    }

    public void set(double[] dArray) {
        if (dArray == null) {
            PsDebug.warning("missing argument array.");
            return;
        }
        this.set(dArray, 0, dArray.length);
    }

    public void set(int[] nArray, int n, int n2) {
        if (nArray == null || nArray.length < n + n2) {
            PsDebug.warning("argument array too small.");
            return;
        }
        if (this.m_data == null || this.m_data.length != n2) {
            this.setSize(n2);
        }
        int n3 = 0;
        while (n3 < n2) {
            this.m_data[n3] = nArray[n + n3];
            ++n3;
        }
    }

    public PdVector() {
    }

    public PdVector(int n) {
        this.m_data = new double[n];
    }

    public PdVector(double d) {
        this(1);
        this.m_data[0] = d;
    }

    public PdVector(double d, double d2) {
        this(2);
        this.m_data[0] = d;
        this.m_data[1] = d2;
    }

    public PdVector(double d, double d2, double d3) {
        this(3);
        this.m_data[0] = d;
        this.m_data[1] = d2;
        this.m_data[2] = d3;
    }

    public PdVector(double d, double d2, double d3, double d4) {
        this(4);
        this.m_data[0] = d;
        this.m_data[1] = d2;
        this.m_data[2] = d3;
        this.m_data[3] = d4;
    }

    public PdVector(double[] dArray) {
        this();
        this.set(dArray);
    }

    public void set(int[] nArray, int n) {
        this.set(nArray, 0, n);
    }

    public void set(int[] nArray) {
        if (nArray == null) {
            PsDebug.warning("missing argument array.");
            return;
        }
        this.set(nArray, 0, nArray.length);
    }

    public void set(double d) {
        if (this.m_data == null || this.m_data.length < 1) {
            this.setSize(1);
        }
        this.m_data[0] = d;
    }

    public void set(double d, double d2) {
        if (this.m_data == null || this.m_data.length < 2) {
            this.setSize(2);
        }
        this.m_data[0] = d;
        this.m_data[1] = d2;
    }

    public void set(double d, double d2, double d3) {
        if (this.m_data == null || this.m_data.length < 3) {
            this.setSize(3);
        }
        this.m_data[0] = d;
        this.m_data[1] = d2;
        this.m_data[2] = d3;
    }

    public void set(double d, double d2, double d3, double d4) {
        if (this.m_data == null || this.m_data.length < 4) {
            this.setSize(4);
        }
        this.m_data[0] = d;
        this.m_data[1] = d2;
        this.m_data[2] = d3;
        this.m_data[3] = d4;
    }

    public static PdVector subNew(PdVector pdVector, PdVector pdVector2) {
        int n;
        if (pdVector == null || pdVector2 == null) {
            return null;
        }
        int n2 = pdVector.getSize();
        if (n2 != (n = pdVector2.getSize())) {
            n2 = Math.min(n2, n);
        }
        PdVector pdVector3 = new PdVector(n2);
        pdVector3.sub(pdVector, pdVector2);
        return pdVector3;
    }

    public void blend(double d, PdVector pdVector, double d2, PdVector pdVector2) {
        if (this.m_data == null) {
            this.setSize(pdVector.m_data.length);
        }
        if (this.m_data.length != pdVector.m_data.length || this.m_data.length != pdVector2.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        int n = 0;
        while (n < this.m_data.length) {
            this.m_data[n] = d * pdVector.m_data[n] + d2 * pdVector2.m_data[n];
            ++n;
        }
    }

    public void sort(PdVector pdVector) {
        int n = this.getSize();
        if (pdVector == null || pdVector.m_data == null) {
            pdVector = new PdVector(n);
        }
        if (pdVector.getSize() != n) {
            pdVector.setSize(n);
        }
        if (n < 10) {
            double[] dArray = pdVector.m_data;
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = this.m_data[n2];
                ++n2;
            }
            int n3 = n - 1;
            while (n3 > 0) {
                int n4 = 0;
                while (n4 < n3) {
                    if (dArray[n4] > dArray[n4 + 1]) {
                        double d = dArray[n4 + 1];
                        dArray[n4 + 1] = dArray[n4];
                        dArray[n4] = d;
                    }
                    ++n4;
                }
                --n3;
            }
            return;
        }
        int[] nArray = new int[n];
        PuMath.heapsort(n, this.m_data, nArray);
        int n5 = 0;
        while (n5 < n) {
            pdVector.m_data[n5] = this.m_data[nArray[n5]];
            ++n5;
        }
    }

    public void sort() {
        int n = this.getSize();
        if (n < 10) {
            int n2 = n - 1;
            while (n2 > 0) {
                int n3 = 0;
                while (n3 < n2) {
                    if (this.m_data[n3] > this.m_data[n3 + 1]) {
                        double d = this.m_data[n3 + 1];
                        this.m_data[n3 + 1] = this.m_data[n3];
                        this.m_data[n3] = d;
                    }
                    ++n3;
                }
                --n2;
            }
            return;
        }
        int[] nArray = new int[n];
        double[] dArray = new double[n];
        int n4 = 0;
        while (n4 < n) {
            dArray[n4] = this.m_data[n4];
            ++n4;
        }
        PuMath.heapsort(n, dArray, nArray);
        n4 = 0;
        while (n4 < n) {
            this.m_data[n4] = dArray[nArray[n4]];
            ++n4;
        }
    }

    public void rightMultMatrix(PdMatrix pdMatrix) {
        if (pdMatrix.m_iSize != pdMatrix.m_jSize || pdMatrix.m_iSize != this.m_data.length) {
            PsDebug.warning("argument not square or incompatible sizes");
            return;
        }
        double[] dArray = new double[this.m_data.length];
        int n = 0;
        while (n < this.m_data.length) {
            dArray[n] = 0.0;
            int n2 = 0;
            while (n2 < this.m_data.length) {
                int n3 = n;
                dArray[n3] = dArray[n3] + this.m_data[n2] * pdMatrix.m_data[n2][n];
                ++n2;
            }
            ++n;
        }
        n = 0;
        while (n < this.m_data.length) {
            this.m_data[n] = dArray[n];
            ++n;
        }
    }

    public void rightMultMatrix(PdVector pdVector, PdMatrix pdMatrix) {
        if (this == pdVector) {
            PsDebug.warning("this vector must be different from argument vector");
            return;
        }
        if (this.m_data.length != pdMatrix.m_jSize) {
            this.setSize(pdMatrix.m_jSize);
        }
        int n = 0;
        while (n < pdMatrix.m_jSize) {
            this.m_data[n] = 0.0;
            int n2 = 0;
            while (n2 < pdMatrix.m_iSize) {
                int n3 = n;
                this.m_data[n3] = this.m_data[n3] + pdVector.m_data[n2] * pdMatrix.m_data[n2][n];
                ++n2;
            }
            ++n;
        }
    }

    public void orthogonalize(PdVector pdVector) {
        this.orthogonalPart(this, pdVector);
    }

    public void orthonormalize(PdVector pdVector) {
        this.orthogonalize(pdVector);
        this.normalize();
    }

    public void invStereoProj(double d, double d2) {
        if (this.m_data.length != 3) {
            return;
        }
        double d3 = 1.0 + d * d + d2 * d2;
        this.m_data[0] = 2.0 * d / d3;
        this.m_data[1] = 2.0 * d2 / d3;
        this.m_data[2] = (2.0 - d3) / d3;
    }

    public PdVector orthogonalPartWrtONB(PdVector pdVector, PdVector pdVector2) {
        PdVector pdVector3 = new PdVector(this.m_data.length);
        double d = PdVector.dot(this, pdVector);
        double d2 = PdVector.dot(this, pdVector2);
        int n = 0;
        while (n < this.m_data.length) {
            pdVector3.m_data[n] = this.m_data[n] - d * pdVector.m_data[n] - d2 * pdVector2.m_data[n];
            ++n;
        }
        return pdVector3;
    }

    public PdVector projectOntoONB(PdVector pdVector, PdVector pdVector2) {
        PdVector pdVector3 = new PdVector(this.m_data.length);
        double d = PdVector.dot(this, pdVector);
        double d2 = PdVector.dot(this, pdVector2);
        int n = 0;
        while (n < this.m_data.length) {
            pdVector3.m_data[n] = d * pdVector.m_data[n] + d2 * pdVector2.m_data[n];
            ++n;
        }
        return pdVector3;
    }

    public int indexOfAbsMax() {
        int n = 0;
        double d = 0.0;
        int n2 = 0;
        while (n2 < this.m_data.length) {
            if (Math.abs(this.m_data[n2]) > d) {
                d = this.m_data[n2];
                n = n2;
            }
            ++n2;
        }
        return n;
    }
}

