/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.loader.PgFileDialog;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.GuiStackLayout;
import jv.objectGui.PsImage;
import jv.project.PgGeometryIf;
import jv.viewer.PvDisplay;
import jv.viewer.PvGeometry;

public final class PvDisplay_IP
extends PsPanel
implements ActionListener,
ItemListener {
    protected PvDisplay m_display;
    protected Panel m_pColor;
    protected Panel m_pSize;
    protected Checkbox m_cAnimation;
    protected Checkbox m_cAxes;
    protected Checkbox m_cBackImage;
    protected Checkbox m_cBndbox;
    protected Checkbox m_cClearScreen;
    protected Checkbox m_cDepthcue;
    protected Checkbox m_cEdgeAura;
    protected Checkbox m_cEdgesOnce;
    protected Checkbox m_cFrame;
    protected Checkbox m_cGrid;
    protected Checkbox m_cPainters;
    protected Checkbox m_cZBuffer;
    protected Checkbox m_cFps;
    protected Label m_lFps;
    protected PsPanel m_pFps;
    protected CheckboxGroup m_gSelectionMode;
    protected Checkbox m_cSingle;
    protected Checkbox m_cMultiple;
    protected List m_listVisible;
    protected List m_listSelect;
    protected boolean m_deleteMode = false;
    private Color m_deleteColor;
    protected boolean m_duplicateMode = false;
    private Color m_duplicateColor;
    protected TextField m_tImage;
    protected String m_fileName;
    protected String m_dirName;
    protected Button m_bBrowse;
    protected Choice m_cImageFit;
    protected Button m_bCenter;
    protected Button m_bFit;
    protected Button m_bMerge;
    protected Button m_bDuplicate;
    protected Button m_bDelete;
    protected Button m_bReset;
    private static /* synthetic */ Class class$jv$viewer$PvDisplay_IP;

    private void duplicateGeom(PgGeometryIf pgGeometryIf) {
        if (this.m_display.m_specialGeom.contains(pgGeometryIf)) {
            PsDebug.warning("not allowed to duplicate special geometry");
            return;
        }
        PgGeometryIf pgGeometryIf2 = (PgGeometryIf)pgGeometryIf.clone();
        PsObject cfr_ignored_0 = (PsObject)((Object)pgGeometryIf2);
        pgGeometryIf2.setName("Clone" + PsObject.getNumObjects() + "-" + pgGeometryIf.getName());
        this.m_display.addGeometry(pgGeometryIf2);
        this.m_display.selectGeometry(pgGeometryIf2);
        this.m_display.update(this.m_display);
        this.m_duplicateMode = false;
        this.m_bDuplicate.setBackground(this.m_duplicateColor);
        this.m_bDuplicate.setLabel(PsConfig.getMessage("bDuplicate"));
    }

    private void deleteGeom(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf == null) {
            return;
        }
        if (this.m_display.m_specialGeom.get("xy-grid") == pgGeometryIf) {
            this.m_display.showGrid(false);
        } else if (this.m_display.m_specialGeom.get("bndbox") == pgGeometryIf) {
            this.m_display.showBndBox(false);
        } else if (this.m_display.m_specialGeom.get("frame") == pgGeometryIf) {
            this.m_display.showFrame(false);
        } else {
            this.m_display.removeGeometry(pgGeometryIf);
            this.m_display.update(this.m_display);
        }
        this.m_deleteMode = false;
        this.m_bDelete.setBackground(this.m_deleteColor);
        this.m_bDelete.setLabel(PsConfig.getMessage("bDelete"));
    }

    public PvDisplay_IP() {
        if (this.getClass() == (class$jv$viewer$PvDisplay_IP != null ? class$jv$viewer$PvDisplay_IP : (class$jv$viewer$PvDisplay_IP = PvDisplay_IP.class$("jv.viewer.PvDisplay_IP")))) {
            this.init();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.m_display == null) {
            return;
        }
        Object object = itemEvent.getSource();
        if (object == this.m_cAnimation) {
            this.m_display.setEnabledAnimation(this.m_cAnimation.getState());
            if (this.m_cAnimation.getState()) {
                this.m_display.start();
                return;
            }
            this.m_display.stop();
            return;
        }
        if (object == this.m_cAxes) {
            this.m_display.showAxes(this.m_cAxes.getState());
            this.m_display.update(this.m_display.m_currentCamera);
            return;
        }
        if (object == this.m_cBackImage) {
            boolean bl = this.m_cBackImage.getState();
            this.m_display.showBackImage(bl);
            if (bl) {
                String string = "";
                if (this.loadImage(this.m_display.getBackgroundImageFile()) != null) {
                    string = this.m_display.getBackgroundImageFile();
                }
                ((TextComponent)this.m_tImage).setText(string);
            }
            this.m_cImageFit.setEnabled(bl);
            if (this.m_bBrowse != null) {
                this.m_bBrowse.setEnabled(bl);
            }
            this.m_tImage.setEnabled(bl);
            this.m_display.update(this.m_display.m_currentCamera);
            return;
        }
        if (object == this.m_cBndbox) {
            this.m_display.showBndBox(this.m_cBndbox.getState());
            this.m_display.update(this.m_display.m_currentCamera);
            return;
        }
        if (object == this.m_cClearScreen) {
            this.m_display.setEnabledClearScreen(this.m_cClearScreen.getState());
            this.m_display.update(this.m_display.m_currentCamera);
            return;
        }
        if (object == this.m_cDepthcue) {
            this.m_display.showDepthcue(this.m_cDepthcue.getState());
            this.m_display.update(this.m_display.m_currentCamera);
            return;
        }
        if (object == this.m_cEdgeAura) {
            this.m_display.showEdgeAura(this.m_cEdgeAura.getState());
            this.m_display.update(this.m_display.m_currentCamera);
            return;
        }
        if (object == this.m_cEdgesOnce) {
            this.m_display.showEdgesOnce(this.m_cEdgesOnce.getState());
            this.m_display.update(this.m_display.m_currentCamera);
            return;
        }
        if (object == this.m_cFrame) {
            this.m_display.showFrame(this.m_cFrame.getState());
            this.m_display.update(this.m_display.m_currentCamera);
            return;
        }
        if (object == this.m_cGrid) {
            this.m_display.showGrid(this.m_cGrid.getState());
            this.m_display.update(this.m_display.m_currentCamera);
            return;
        }
        if (object == this.m_cPainters) {
            this.m_display.setEnabledPainters(this.m_cPainters.getState());
            this.m_display.update(this.m_display.m_currentCamera);
            return;
        }
        if (object == this.m_cZBuffer) {
            this.m_display.setEnabledZBuffer(this.m_cZBuffer.getState());
            this.m_display.update(this.m_display.m_currentCamera);
            return;
        }
        if (object == this.m_cFps) {
            this.m_display.m_bFpsEnabled = this.m_cFps.getState();
            this.m_display.m_sleep.setEnabled(this.m_cFps.getState());
            this.m_lFps.setText(PsConfig.getMessage("lFps"));
            if (this.m_display.m_bFpsEnabled) {
                this.m_display.start();
                return;
            }
            this.m_display.stop();
            return;
        }
        if (object == this.m_cSingle) {
            if (this.m_display.hasPaintTag(2048)) {
                return;
            }
            this.m_display.setPaintTag(2048, true);
            if (this.m_display.m_currentGeom != null) {
                this.m_display.selectGeometry(this.m_display.m_currentGeom.getGeometry());
            }
            this.m_display.update(this.m_display);
            return;
        }
        if (object == this.m_cMultiple) {
            if (!this.m_display.hasPaintTag(2048)) {
                return;
            }
            this.m_display.setPaintTag(2048, false);
            if (this.m_display.m_currentGeom != null) {
                this.m_display.selectGeometry(this.m_display.m_currentGeom.getGeometry());
                return;
            }
        } else {
            if (object == this.m_cImageFit) {
                this.m_display.setImageFitMode(this.m_cImageFit.getSelectedIndex());
                this.m_display.update(this.m_display.m_currentCamera);
                return;
            }
            if (object == this.m_listVisible) {
                int n = (Integer)itemEvent.getItem();
                if (n < 0 || this.m_listVisible.getItemCount() <= n) {
                    return;
                }
                PvGeometry[] pvGeometryArray = this.m_display.getAllGeometryContainers();
                if (this.m_deleteMode) {
                    this.deleteGeom(pvGeometryArray[n].getGeometry());
                    return;
                }
                if (this.m_duplicateMode) {
                    this.duplicateGeom(pvGeometryArray[n].getGeometry());
                    return;
                }
                switch (itemEvent.getStateChange()) {
                    case 1: {
                        if (this.m_display.hasPaintTag(2048)) {
                            this.m_display.selectGeometry(pvGeometryArray[n].getGeometry());
                            this.m_display.update(this.m_display);
                            return;
                        }
                        pvGeometryArray[n].getGeometry().setVisible(true);
                        pvGeometryArray[n].setVisible(true);
                        this.m_display.update(this);
                        return;
                    }
                    case 2: {
                        pvGeometryArray[n].getGeometry().setVisible(false);
                        pvGeometryArray[n].setVisible(false);
                        this.m_display.update(this);
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (object == this.m_listSelect) {
                int n = (Integer)itemEvent.getItem();
                if (n < 0 || this.m_listSelect.getItemCount() <= n) {
                    return;
                }
                PvGeometry[] pvGeometryArray = this.m_display.getAllGeometryContainers();
                if (this.m_deleteMode) {
                    this.deleteGeom(pvGeometryArray[n].getGeometry());
                    return;
                }
                if (this.m_duplicateMode) {
                    this.duplicateGeom(pvGeometryArray[n].getGeometry());
                    return;
                }
                switch (itemEvent.getStateChange()) {
                    case 1: {
                        this.m_display.selectGeometry(pvGeometryArray[n].getGeometry());
                        this.m_display.update(this);
                    }
                }
            }
        }
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.m_display = (PvDisplay)psUpdateIf;
        this.setTitle(this.m_display.getName());
        this.m_pColor.add(this.m_display.m_backgroundColor.getInfoPanel());
        this.m_pColor.add(this.m_display.m_foregroundColor.getInfoPanel());
        this.m_pSize.add(this.m_display.m_width.getInfoPanel());
        this.m_pSize.add(this.m_display.m_height.getInfoPanel());
        if (this.m_pFps != null) {
            this.m_pFps.add(this.m_display.m_sleep.getInfoPanel());
        }
    }

    private Image loadImage(String string) {
        Image image = PsImage.getImage(string);
        if (!PsImage.loadImage(this, image)) {
            PsDebug.warning("failed loading image = " + string);
            return null;
        }
        this.m_display.setBackgroundImage(image);
        this.m_display.showBackImage(true);
        return image;
    }

    public boolean update(Object object) {
        if (this.m_display == null) {
            PsDebug.warning("missing display");
            return false;
        }
        if (object == this.m_display) {
            int n;
            String string = this.m_display.getName();
            if (string != null && this.getTitle() != null && !string.equals(this.getTitle())) {
                this.setTitle(string);
            }
            if (this.m_cBackImage.getState() != this.m_display.isShowingBackImage()) {
                boolean bl = this.m_display.isShowingBackImage();
                this.m_cBackImage.setState(bl);
                if (bl) {
                    ((TextComponent)this.m_tImage).setText(this.m_display.getBackgroundImageFile());
                }
                this.m_cImageFit.setEnabled(bl);
                if (this.m_bBrowse != null) {
                    this.m_bBrowse.setEnabled(bl);
                }
                this.m_tImage.setEnabled(bl);
            }
            if (this.m_cImageFit.getSelectedIndex() != this.m_display.getImageFitMode()) {
                this.m_cImageFit.select(this.m_display.getImageFitMode());
            }
            if (this.m_cAnimation.getState() != this.m_display.isEnabledAnimation()) {
                this.m_cAnimation.setState(this.m_display.isEnabledAnimation());
            }
            if (this.m_cAxes.getState() != this.m_display.isShowingAxes()) {
                this.m_cAxes.setState(this.m_display.isShowingAxes());
            }
            if (this.m_cBndbox.getState() != this.m_display.isShowingBndBox()) {
                this.m_cBndbox.setState(this.m_display.isShowingBndBox());
            }
            if (this.m_cClearScreen.getState() != this.m_display.isEnabledClearScreen()) {
                this.m_cClearScreen.setState(this.m_display.isEnabledClearScreen());
            }
            if (this.m_cDepthcue.getState() != this.m_display.isShowingDepthcue()) {
                this.m_cDepthcue.setState(this.m_display.isShowingDepthcue());
            }
            if (this.m_cEdgeAura.getState() != this.m_display.isShowingEdgeAura()) {
                this.m_cEdgeAura.setState(this.m_display.isShowingEdgeAura());
            }
            if (this.m_cEdgesOnce.getState() != this.m_display.isShowingEdgesOnce()) {
                this.m_cEdgesOnce.setState(this.m_display.isShowingEdgesOnce());
            }
            if (this.m_cFrame.getState() != this.m_display.isShowingFrame()) {
                this.m_cFrame.setState(this.m_display.isShowingFrame());
            }
            if (this.m_cGrid.getState() != this.m_display.isShowingGrid()) {
                this.m_cGrid.setState(this.m_display.isShowingGrid());
            }
            if (this.m_cPainters.getState() != this.m_display.isEnabledPainters()) {
                this.m_cPainters.setState(this.m_display.isEnabledPainters());
            }
            if (this.m_cZBuffer.getState() != this.m_display.isEnabledZBuffer()) {
                this.m_cZBuffer.setState(this.m_display.isEnabledZBuffer());
            }
            if (this.m_pFps != null && this.m_cFps.getState() != this.m_display.m_bFpsEnabled) {
                this.m_cFps.setState(this.m_display.m_bFpsEnabled);
            }
            PvGeometry[] pvGeometryArray = this.m_display.getAllGeometryContainers();
            PgGeometryIf pgGeometryIf = this.m_display.getSelectedGeometry();
            boolean bl = this.m_display.hasPaintTag(2048);
            if (bl && this.m_gSelectionMode.getSelectedCheckbox() != this.m_cSingle) {
                this.m_gSelectionMode.setSelectedCheckbox(this.m_cSingle);
            } else if (!bl && this.m_gSelectionMode.getSelectedCheckbox() == this.m_cSingle) {
                this.m_gSelectionMode.setSelectedCheckbox(this.m_cMultiple);
            }
            boolean bl2 = true;
            int n2 = 0;
            int n3 = this.m_listVisible.getItemCount();
            if (pvGeometryArray != null) {
                n2 = pvGeometryArray.length;
            }
            if (n3 != n2) {
                bl2 = false;
            } else {
                n = 0;
                while (n < n2) {
                    String string2 = this.m_listVisible.getItem(n);
                    if (string2 == null || !string2.equals(pvGeometryArray[n].getGeometry().getName())) {
                        bl2 = false;
                        break;
                    }
                    ++n;
                }
            }
            if (!bl2) {
                if (n3 > 0) {
                    this.m_listVisible.removeAll();
                    this.m_listSelect.removeAll();
                }
                n = 0;
                while (n < n2) {
                    this.m_listVisible.add(pvGeometryArray[n].getGeometry().getName());
                    this.m_listSelect.add(pvGeometryArray[n].getGeometry().getName());
                    ++n;
                }
            }
            n = 0;
            while (n < n2) {
                if (pvGeometryArray[n].isVisible() != this.m_listVisible.isIndexSelected(n)) {
                    if (pvGeometryArray[n].isVisible()) {
                        this.m_listVisible.select(n);
                    } else {
                        this.m_listVisible.deselect(n);
                    }
                }
                if (pvGeometryArray[n].getGeometry() == pgGeometryIf) {
                    this.m_listSelect.select(n);
                }
                ++n;
            }
            return true;
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_display == null) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.m_tImage) {
            this.m_fileName = this.m_tImage.getText();
            this.m_fileName.trim();
            if (this.loadImage(this.m_fileName) == null) {
                return;
            }
            this.m_display.setBackgroundImage(this.m_fileName);
            this.m_display.update(this.m_display.m_currentCamera);
            return;
        }
        if (object == this.m_bBrowse) {
            if (!PsConfig.isApplication()) {
                this.m_fileName = this.m_tImage.getText();
                this.m_fileName.trim();
            } else {
                PgFileDialog pgFileDialog = new PgFileDialog(PsConfig.getFrame(), PsConfig.getMessage("OpenImage"), 0);
                if (this.m_dirName == null) {
                    this.m_dirName = PsConfig.getCodeBase() + "images";
                }
                ((FileDialog)pgFileDialog).setDirectory(this.m_dirName);
                ((Component)pgFileDialog).setVisible(true);
                String string = pgFileDialog.getFile();
                if (string == null) {
                    return;
                }
                this.m_dirName = ((FileDialog)pgFileDialog).getDirectory();
                this.m_fileName = this.m_dirName + string;
                this.m_fileName.trim();
                ((TextComponent)this.m_tImage).setText(this.m_fileName);
            }
            if (this.loadImage(this.m_fileName) == null) {
                return;
            }
            this.m_display.setBackgroundImage(this.m_fileName);
            this.m_display.update(this.m_display.m_currentCamera);
            return;
        }
        if (object == this.m_bCenter) {
            this.m_display.center();
            this.m_display.update(this.m_display.m_currentCamera);
            return;
        }
        if (object == this.m_bFit) {
            this.m_display.fit();
            this.m_display.update(this.m_display.m_currentCamera);
            return;
        }
        if (object == this.m_bMerge) {
            PgGeometryIf[] pgGeometryIfArray = this.m_display.getGeometries();
            PgGeometryIf pgGeometryIf = null;
            int n = 0;
            while (n < pgGeometryIfArray.length) {
                if (pgGeometryIfArray[n].isVisible()) {
                    pgGeometryIf = pgGeometryIfArray[n];
                    break;
                }
                ++n;
            }
            if (pgGeometryIf == null) {
                PsDebug.warning("missing visible geometry.");
                return;
            }
            n = 0;
            while (n < pgGeometryIfArray.length) {
                if (pgGeometryIfArray[n].isVisible() && pgGeometryIfArray[n] != pgGeometryIf) {
                    pgGeometryIf.merge(pgGeometryIfArray[n]);
                    this.m_display.removeGeometry(pgGeometryIfArray[n]);
                }
                ++n;
            }
            pgGeometryIf.update(pgGeometryIf);
            this.m_display.selectGeometry(pgGeometryIf);
            this.m_display.update(this.m_display);
            return;
        }
        if (object == this.m_bDuplicate) {
            if (this.m_duplicateMode) {
                this.m_duplicateMode = false;
                this.m_bDuplicate.setBackground(this.m_duplicateColor);
                this.m_bDuplicate.setLabel(PsConfig.getMessage("bDuplicate"));
                return;
            }
            this.m_duplicateMode = true;
            this.m_duplicateColor = this.m_bDuplicate.getBackground();
            this.m_bDuplicate.setBackground(Color.red);
            this.m_bDuplicate.setLabel(PsConfig.getMessage("ClickGeom"));
            return;
        }
        if (object == this.m_bDelete) {
            if (this.m_deleteMode) {
                this.m_deleteMode = false;
                this.m_bDelete.setBackground(this.m_deleteColor);
                this.m_bDelete.setLabel(PsConfig.getMessage("bDelete"));
                return;
            }
            this.m_deleteMode = true;
            this.m_deleteColor = this.m_bDelete.getBackground();
            this.m_bDelete.setBackground(Color.red);
            this.m_bDelete.setLabel(PsConfig.getMessage("ClickGeom"));
            return;
        }
        if (object == this.m_bReset) {
            this.m_display.init();
            this.update(this.m_display);
            this.m_display.update(this.m_display.m_currentCamera);
        }
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        this.setBorderType(3);
        this.addTitle("");
        this.m_pColor = new Panel();
        this.m_pColor.setLayout(new GridLayout(2, 1));
        this.add(this.m_pColor);
        this.m_pSize = new Panel();
        this.m_pSize.setLayout(new GridLayout(2, 1));
        this.add(this.m_pSize);
        this.addLine(1);
        PsPanel psPanel = new PsPanel();
        psPanel.setLayout(new GridLayout(3, 2));
        psPanel.addTitle(PsConfig.getMessage("BackImage"));
        this.m_cBackImage = new Checkbox(PsConfig.getMessage("Show"));
        this.m_cBackImage.addItemListener(this);
        psPanel.add(this.m_cBackImage);
        psPanel.add(new Label(PsConfig.getMessage("Display")));
        this.m_cImageFit = new Choice();
        this.m_cImageFit.addItemListener(this);
        this.m_cImageFit.addItem(PsConfig.getMessage("cCenter"));
        this.m_cImageFit.addItem(PsConfig.getMessage("cTesselate"));
        this.m_cImageFit.addItem(PsConfig.getMessage("cResize"));
        this.m_cImageFit.setEnabled(false);
        psPanel.add(this.m_cImageFit);
        Panel panel = new Panel();
        panel.setLayout(new GuiStackLayout(0, 0));
        panel.add("WIDE*2", new Label(PsConfig.getMessage("ImageFile")));
        this.m_bBrowse = new Button(PsConfig.getMessage("Load"));
        this.m_bBrowse.addActionListener(this);
        panel.add("FILL*1", this.m_bBrowse);
        this.m_bBrowse.setEnabled(false);
        psPanel.add(panel);
        this.m_tImage = new TextField();
        this.m_tImage.addActionListener(this);
        this.m_tImage.setEnabled(false);
        psPanel.add(this.m_tImage);
        this.add(psPanel);
        this.addLine(1);
        this.addSubTitle(PsConfig.getMessage("displayTitle"));
        panel = new PsPanel();
        panel.setLayout(new GridLayout(5, 2));
        this.add(panel);
        this.m_cAnimation = new Checkbox(PsConfig.getMessage("cAnimation"));
        this.m_cAnimation.addItemListener(this);
        panel.add(this.m_cAnimation);
        this.m_cAxes = new Checkbox(PsConfig.getMessage("cAxes"));
        this.m_cAxes.addItemListener(this);
        panel.add(this.m_cAxes);
        this.m_cBndbox = new Checkbox(PsConfig.getMessage("cBndbox0"));
        this.m_cBndbox.addItemListener(this);
        panel.add(this.m_cBndbox);
        this.m_cDepthcue = new Checkbox(PsConfig.getMessage("cDepthcue"));
        this.m_cDepthcue.addItemListener(this);
        panel.add(this.m_cDepthcue);
        this.m_cFrame = new Checkbox(PsConfig.getMessage("cFrame"));
        this.m_cFrame.addItemListener(this);
        panel.add(this.m_cFrame);
        this.m_cGrid = new Checkbox(PsConfig.getMessage("cGrid"));
        this.m_cGrid.addItemListener(this);
        panel.add(this.m_cGrid);
        this.m_cPainters = new Checkbox(PsConfig.getMessage("cPainters"));
        this.m_cPainters.addItemListener(this);
        panel.add(this.m_cPainters);
        this.m_cEdgesOnce = new Checkbox(PsConfig.getMessage("cEdgesOnce"));
        this.m_cEdgesOnce.addItemListener(this);
        this.m_cEdgeAura = new Checkbox(PsConfig.getMessage("cEdgeAura"));
        this.m_cEdgeAura.addItemListener(this);
        panel.add(this.m_cEdgeAura);
        this.m_cClearScreen = new Checkbox(PsConfig.getMessage("cClearScreen"));
        this.m_cClearScreen.addItemListener(this);
        panel.add(this.m_cClearScreen);
        this.m_cZBuffer = new Checkbox(PsConfig.getMessage("cZBuffer") + " (beta)");
        this.m_cZBuffer.addItemListener(this);
        panel.add(this.m_cZBuffer);
        this.addLine(1);
        this.m_pFps = new PsPanel();
        this.m_pFps.setLayout(new GridLayout(2, 1));
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, 2));
        this.m_cFps = new Checkbox(PsConfig.getMessage("cFps"));
        this.m_cFps.addItemListener(this);
        this.m_cFps.setFont(PsConfig.getFont(3));
        this.m_cFps.setState(false);
        panel2.add(this.m_cFps);
        this.m_lFps = new Label(PsConfig.getMessage("lFps"));
        panel2.add(this.m_lFps);
        this.m_pFps.add(panel2);
        this.addLine(1);
        panel2 = new PsPanel();
        ((PsPanel)panel2).setInsetSize(0);
        this.add(panel2);
        Panel panel3 = new PsPanel();
        ((PsPanel)panel3).setInsetSize(0);
        panel3.setLayout(new GridLayout(1, 2));
        ((PsPanel)panel3).addSubTitle(PsConfig.getMessage("lGeometries"));
        Panel panel4 = new Panel();
        panel4.setLayout(new GridLayout(1, 2));
        this.m_gSelectionMode = new CheckboxGroup();
        this.m_cSingle = new Checkbox(PsConfig.getMessage("cSingle"), this.m_gSelectionMode, false);
        this.m_cSingle.addItemListener(this);
        panel4.add(this.m_cSingle);
        this.m_cMultiple = new Checkbox(PsConfig.getMessage("cMultiple"), this.m_gSelectionMode, true);
        this.m_cMultiple.addItemListener(this);
        panel4.add(this.m_cMultiple);
        panel3.add(panel4);
        panel2.add(panel3);
        panel4 = new Panel();
        panel4.setLayout(new GridLayout(1, 2));
        Panel panel5 = new Panel();
        panel5.setLayout(new BorderLayout());
        Label label = new Label(PsConfig.getMessage("lSel"));
        panel5.add("North", label);
        this.m_listSelect = new List(5, false);
        this.m_listSelect.addItemListener(this);
        panel5.add("Center", this.m_listSelect);
        panel4.add(panel5);
        Panel panel6 = new Panel();
        panel6.setLayout(new BorderLayout());
        Label label2 = new Label(PsConfig.getMessage("lVis"));
        panel6.add("North", label2);
        this.m_listVisible = new List(5, true);
        this.m_listVisible.addItemListener(this);
        panel6.add("Center", this.m_listVisible);
        panel4.add(panel6);
        panel2.add(panel4);
        panel3 = new Panel();
        panel3.setLayout(new FlowLayout());
        this.add(panel3);
        this.m_bMerge = new Button(PsConfig.getMessage("bMerge"));
        this.m_bMerge.addActionListener(this);
        panel3.add(this.m_bMerge);
        this.m_bDuplicate = new Button(PsConfig.getMessage("bDuplicate"));
        this.m_bDuplicate.addActionListener(this);
        panel3.add(this.m_bDuplicate);
        this.m_bDelete = new Button(PsConfig.getMessage("bDelete"));
        this.m_bDelete.addActionListener(this);
        panel3.add(this.m_bDelete);
        panel4 = new Panel();
        panel4.setLayout(new FlowLayout());
        this.add(panel4);
        this.m_bCenter = new Button(PsConfig.getMessage("bCenter"));
        this.m_bCenter.addActionListener(this);
        panel4.add(this.m_bCenter);
        this.m_bFit = new Button(PsConfig.getMessage("bFit"));
        this.m_bFit.addActionListener(this);
        panel4.add(this.m_bFit);
        this.m_bReset = new Button(PsConfig.getMessage("bReset"));
        this.m_bReset.addActionListener(this);
        panel4.add(this.m_bReset);
    }
}

