/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.MemoryImageSource;
import jv.number.PdColor;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.project.PvDisplayIf;
import jv.project.PvGeometryIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuProj;
import jv.viewer.PvDisplay;
import jv.viewer.PvScene;
import jv.viewer.PvThickGraphics;

final class PvGeometry
extends PgJvxSrc
implements PvGeometryIf {
    protected PvDisplayIf m_display;
    protected PgGeometryIf m_geometry;
    protected static int PS_ZOOM = 1;
    protected Color m_backColor;
    protected boolean m_bShowEdgeAura;
    protected int m_drawingOrder = 0;
    protected PdVector[] m_bndBox;
    protected PiVector[] m_bndBoxTrans;
    protected Color m_globalBndboxColor;
    private int m_dimTrans;
    protected int m_dimOfColors;
    protected int m_pickedVertex;
    protected int[] m_texturePix;
    protected int m_textureWidth;
    protected int m_textureHeight;
    protected int m_textureDepth = 256;
    protected boolean m_bEnableZBuffer = false;
    protected PdVector[] m_faceTextureBnd;
    protected PiVector[] m_faceDestBnd;
    private int prevElemHeight;
    private int prevElemWidth;
    private transient Image m_destImage;
    private int imgHeight;
    private int imgWidth;
    private transient MemoryImageSource mis;
    protected int m_alpha;
    protected boolean m_bShowTransparency;
    protected boolean m_bShowVectors;
    private boolean m_bHasTaggedVertices;
    protected int m_numPolygonEdges;
    protected boolean m_bHasTaggedPolygons;
    protected boolean m_bHasTaggedEdges;
    protected boolean m_bHasTaggedBoundaries;
    protected boolean m_bHasTaggedElements;
    private boolean m_bHasNeighbours;
    private PdVector m_vt;
    protected PiVector[] m_vertexTrans;
    protected PiVector[] m_vertexNormalTrans;
    protected PiVector[] m_elementNormalTrans;
    protected PiVector[][] m_vectorTrans;
    protected boolean m_useVertices;
    protected boolean m_useUnusedVertices;
    protected boolean m_useElements;
    protected boolean m_usePolygons;
    private int[] xv = new int[this.m_maxDimOfElements];
    private int[] yv = new int[this.m_maxDimOfElements];
    private int[] zv = new int[this.m_maxDimOfElements];
    private double m_grey = 200.0;
    private double m_greyElem = 30.0;
    private boolean m_elemIsClipped;
    private int[] m_origInd = new int[this.m_maxDimOfElements];
    private PiVector m_pix = new PiVector();
    private PiVector m_pixZero = new PiVector();
    protected boolean m_bShowDepthcue;
    protected boolean m_bShowEdgeOnce;
    protected boolean m_bEnableClip;
    protected double m_clipFar;
    protected double m_clipNear;
    protected PvScene m_scene;
    protected Dimension m_dispSize;
    private double m_heightFac;
    private double m_itemHeight;
    private boolean m_bShowCurrElement = false;
    private boolean m_bShowCurrEdge = false;
    private boolean m_bDrawingEdge = false;
    private boolean m_bDepthcueEdge = false;
    private boolean m_bUse_m_heightFac = false;
    private PdVector[] texCoord = null;
    private int[] xvSub = new int[3];
    private int[] yvSub = new int[3];
    private int[] zvSub = new int[3];
    private PdVector[] texSub = new PdVector[3];
    private int[][] elemSub = new int[this.m_maxDimOfElements][3];
    private int[] indVec = new int[this.m_maxDimOfElements];
    private PdVector[] currVertex = PdVector.realloc(null, this.m_maxDimOfElements, 3);
    private double[] angle = new double[this.m_maxDimOfElements];
    protected double[] m_elemCenter;
    protected PdVector m_lightDir = new PdVector(0.0, 0.7071, 0.7071);
    private static int MIS_IMAGE_OUTSIDE = -1;
    protected static int MIS_IMAGE_REQUIRED = 0;
    protected static int MIS_IMAGE_REDRAW = 1;
    private int[] m_elemMin = new int[2];
    private int[] m_elemMax = new int[2];
    private int m_elemWidth = 0;
    private int m_elemHeight = 0;
    protected boolean m_bNewZBuffer = false;
    private int m_currElementCol = -16777216;
    private int m_currEdgeCol = -16777216;
    private int m_currVertexCol = -16777216;
    private static int m_colMark = 254;
    private static int NNW = 1;
    private static int NWW = 2;
    private static int SWW = 3;
    private static int SSW = 4;
    private static int SSE = 5;
    private static int SEE = 6;
    private static int NEE = 7;
    private static int NNE = 8;
    private PiVector m_unusedVertex = new PiVector();
    private int m_numUnusedVertices = 0;
    PdMatrix m_projMat;
    PdMatrix m_viewMat;
    private PdVector vt = new PdVector(this.m_dim + 1);
    private PdVector vtExact = new PdVector(this.m_dim);
    int[] m_position = null;
    protected static int m_zMin = Integer.MAX_VALUE;
    protected static int m_zMax = Integer.MIN_VALUE;
    PdVector elemCenter = new PdVector(3);
    PiVector elemCenterTrans = new PiVector(3);

    private void drawVector_(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, Color color) {
        this.drawVector_(graphics, n, n2, n3, n4, n5, n6, n4, true, bl, color);
    }

    private void drawVector_(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean bl2, Color color) {
        this.drawLine(graphics, n, n2, n3, n4, n5, n6, n7, color);
        if (bl2) {
            this.drawVectorTip(graphics, n, n2, n3, n4, n5, n6, n7, bl, color);
        }
    }

    private Color getEdgeColor_(int n) {
        Color color;
        if (this.m_bShowTaggedEdges && this.m_bHasTaggedEdges && this.m_element[n].hasTag(1)) {
            color = this.m_globalEdgeTagColor;
        } else {
            color = this.m_bShowEdgeColors && this.m_edgeColor != null ? this.m_edgeColor[n] : this.m_globalEdgeColor;
            if (this.m_bShowDepthcue && !this.m_bShowElements && !this.m_bEnableZBuffer) {
                color = PdColor.getDimmedColor(color, this.m_heightFac, this.m_grey * (1.0 - this.m_heightFac));
            }
        }
        return color;
    }

    public boolean setVectorList(int n, PdVector[] pdVectorArray) {
        this.setVectors(n, pdVectorArray);
        return true;
    }

    public boolean hasTagPolygon(int n, int n2) {
        return this.m_polygon[n].hasTag(n2);
    }

    public int addPolygon(PiVector piVector) {
        this.setNumPolygons(this.m_numPolygons + 1);
        this.m_polygon[this.m_numPolygons - 1].setSize(piVector.getSize());
        this.m_polygon[this.m_numPolygons - 1].copy(piVector);
        this.computeNumPolygonEdges();
        return this.m_numPolygons - 1;
    }

    public void setState(int n, boolean bl) {
        switch (n) {
            case 85: {
                this.m_bDefaultLabelEnabled = bl;
                return;
            }
            case 86: {
                this.m_bShowTitle = bl;
                return;
            }
            case 80: {
                this.m_bShowIndices = bl;
                return;
            }
            case 81: {
                this.m_bShowVertexLabels = bl;
                return;
            }
            case 82: {
                this.m_bShowPolygonLabels = bl;
                return;
            }
            case 83: {
                this.m_bShowEdgeLabels = bl;
                return;
            }
            case 84: {
                this.m_bShowElementLabels = bl;
                return;
            }
            case 50: {
                this.m_bShowVertices = bl;
                return;
            }
            case 51: {
                this.m_bShowTaggedVertices = bl;
                return;
            }
            case 52: {
                this.m_bShowEdges = bl;
                return;
            }
            case 53: {
                this.m_bShowTaggedEdges = bl;
                return;
            }
            case 87: {
                this.m_bShowOutline = bl;
                return;
            }
            case 54: {
                this.m_bShowPolygons = bl;
                return;
            }
            case 55: {
                this.m_bShowTaggedPolygons = bl;
                return;
            }
            case 56: {
                this.m_bShowElements = bl;
                return;
            }
            case 57: {
                this.m_bShowTaggedElements = bl;
                return;
            }
            case 68: {
                this.m_bShowBackface = bl;
                return;
            }
            case 58: {
                this.m_bShowBoundaries = bl;
                return;
            }
            case 59: {
                this.m_bShowTaggedBoundaries = bl;
                return;
            }
            case 60: {
                this.m_bShowVertexNormals = bl;
                return;
            }
            case 62: {
                this.m_bShowElementNormals = bl;
                return;
            }
            case 64: {
                this.m_bShowPolygonNormals = bl;
                return;
            }
            case 61: {
                this.m_bShowVertexNormalArrow = bl;
                return;
            }
            case 63: {
                this.m_bShowElementNormalArrow = bl;
                return;
            }
            case 65: {
                this.m_bShowPolygonNormalArrow = bl;
                return;
            }
            case 88: {
                this.m_bShowPolygonStartArrow = bl;
                return;
            }
            case 89: {
                this.m_bShowPolygonEndArrow = bl;
                return;
            }
            case 69: {
                this.m_bShowBndBox = bl;
                return;
            }
            case 70: {
                this.m_bShowCenter = bl;
                return;
            }
            case 71: {
                this.m_bShowVertexTexture = bl;
                return;
            }
            case 72: {
                this.m_bShowElementTexture = bl;
                return;
            }
            case 73: {
                this.m_bShowTransparency = bl;
                return;
            }
            case 90: {
                this.m_bShowVertexColors = bl;
                return;
            }
            case 92: {
                this.m_bShowPolygonColors = bl;
                return;
            }
            case 93: {
                this.m_bShowEdgeColors = bl;
                return;
            }
            case 94: {
                this.m_bShowElementColors = bl;
                return;
            }
            case 99: {
                this.m_bShowElementBackColor = bl;
                return;
            }
            case 100: {
                this.m_bShowElementBackColors = bl;
                return;
            }
        }
        PsDebug.warning("invalid key = " + n);
    }

    protected boolean getState(int n) {
        switch (n) {
            case 50: {
                return this.m_bShowVertices;
            }
            case 69: {
                return this.m_bShowBndBox;
            }
        }
        PsDebug.warning("unsupported key = " + n);
        return false;
    }

    private boolean getElementBndBox(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n) {
        int n2 = 0;
        do {
            nArray[n2] = Integer.MAX_VALUE;
            nArray2[n2] = Integer.MIN_VALUE;
        } while (++n2 < 2);
        n2 = 0;
        while (n2 < n) {
            if (nArray3[n2] < nArray[0]) {
                nArray[0] = nArray3[n2];
            }
            if (nArray3[n2] > nArray2[0]) {
                nArray2[0] = nArray3[n2];
            }
            if (nArray4[n2] < nArray[1]) {
                nArray[1] = nArray4[n2];
            }
            if (nArray4[n2] > nArray2[1]) {
                nArray2[1] = nArray4[n2];
            }
            ++n2;
        }
        return nArray[0] < this.m_dispSize.width && nArray2[0] >= 0 && nArray[1] < this.m_dispSize.height && nArray2[1] >= 0;
    }

    private int[][] triangulate(int[] nArray, int[] nArray2, int[] nArray3, int n) {
        int n2 = n;
        int n3 = 0;
        while (n3 < n2) {
            this.indVec[n3] = (n3 + 1) % n2;
            ++n3;
        }
        int n4 = -1;
        int n5 = n2 - 1;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n2 - 3) {
            int n8 = n2 - n7;
            int n9 = n6;
            n3 = 0;
            while (n3 < n8) {
                this.currVertex[n3].set(nArray[n9], (double)nArray2[n9], 0.0);
                n9 = this.indVec[n9];
                ++n3;
            }
            PdVector.angleWithOrientation(this.angle, this.currVertex, n8);
            double d = Double.NEGATIVE_INFINITY;
            int n10 = -1;
            n9 = n6;
            n3 = 0;
            while (n3 < n8) {
                if (this.angle[n3] > d) {
                    d = this.angle[n3];
                    n10 = n9;
                    n4 = n5;
                }
                n5 = n9;
                n9 = this.indVec[n9];
                ++n3;
            }
            if (n10 == -1) {
                PsDebug.error("missing max angle");
                return null;
            }
            this.elemSub[n7][0] = n4;
            this.elemSub[n7][1] = n10;
            this.elemSub[n7][2] = this.indVec[n10];
            this.indVec[n4] = this.indVec[n10];
            n5 = n4;
            n6 = this.indVec[n10];
            ++n7;
        }
        this.elemSub[n7][0] = n6;
        this.elemSub[n7][1] = this.indVec[n6];
        this.elemSub[n7][2] = this.indVec[this.indVec[n6]];
        return this.elemSub;
    }

    private void drawLine(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, Color color) {
        if (this.m_bEnableZBuffer) {
            if (n < 3) {
                this.drawLineZBuffer(graphics, new int[]{n2, n5}, new int[]{n3, n6}, new int[]{n4, n7}, 2, color);
                return;
            }
            this.drawLineZBuffer(graphics, n, new int[]{n2, n5}, new int[]{n3, n6}, new int[]{n4, n7}, 2, color);
            return;
        }
        if (color != null) {
            graphics.setColor(color);
        }
        if (n < 3) {
            graphics.drawLine(n2, n3, n5, n6);
            return;
        }
        PvThickGraphics.drawLine(graphics, n, n2, n3, n5, n6);
    }

    protected int getZMin() {
        return m_zMin;
    }

    private void drawElementBnd(Graphics graphics, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3) {
        if (!(!this.m_bHasNeighbours || this.m_neighbour[n].m_data.length < n2 || this.m_bEnableClip && this.m_elemIsClipped)) {
            int n3 = 0;
            while (n3 < n2) {
                if (this.m_neighbour[n].m_data[n3] == -1) {
                    int n4 = (n3 + 1) % n2;
                    int n5 = (n3 + 2) % n2;
                    this.drawLine(graphics, (int)this.m_globalBndSize, nArray[n4], nArray2[n4], nArray3[n4], nArray[n5], nArray2[n5], nArray3[n5], this.m_globalBndColor);
                }
                ++n3;
            }
        }
    }

    protected int getNumItems() {
        int n = 0;
        if (this.m_useVertices) {
            n += this.m_numVertices;
        } else if (this.m_useUnusedVertices) {
            n += this.m_numUnusedVertices;
        }
        if (this.m_useElements) {
            n += this.m_numElements;
        }
        if (this.m_usePolygons) {
            n += this.m_numPolygonEdges;
        }
        return n;
    }

    private void project(PiVector piVector, PdVector pdVector, PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        double d;
        if (this.m_ambientMatrix != null) {
            this.vt.copyArray(pdVector);
            if (this.m_position == null) {
                this.vt.m_data[this.m_dim] = 1.0;
                this.vt.leftMultMatrix(this.m_ambientMatrix);
            } else {
                if (this.vt.getSize() != this.m_ambientMatrix.getSize()) {
                    this.vt.setSize(this.m_ambientMatrix.getSize());
                }
                d = PdVector.length(this.m_dim, this.m_ambientMatrix.m_data[0]);
                this.vt.m_data[this.m_dim] = 0.0;
                this.vt.leftMultMatrix(this.m_ambientMatrix);
                this.vt.multScalar(1.0 / d);
            }
            this.vt.m_data[this.m_dim] = 0.0;
            pdVector.copyArray(this.vt);
        }
        if (this.m_position == null && this.m_ambientProj != 0) {
            if (this.m_ambientMatrix != null) {
                this.vtExact.copyArray(this.vt);
            } else {
                this.vtExact.copyArray(pdVector);
            }
            if (this.m_ambientSpace == 9 || this.m_ambientSpace == 6 || this.m_ambientSpace == 3 || this.m_ambientSpace == 1 || this.m_ambientSpace == 2 || this.m_ambientSpace == 4 || this.m_ambientSpace == 7 || this.m_ambientSpace == 10) {
                if (this.m_ambientProj == 1) {
                    PuProj.stereographic(this.vtExact, this.vtExact);
                } else {
                    PsDebug.warning("unknown projection type");
                }
            } else if (this.m_ambientSpace == 5 || this.m_ambientSpace == 8 || this.m_ambientSpace == 11) {
                if (this.m_ambientProj == 2) {
                    PuProj.lorentz2Klein(this.vtExact, this.vtExact);
                } else if (this.m_ambientProj == 1) {
                    PuProj.lorentz2Poincare(this.vtExact, this.vtExact);
                } else if (this.m_ambientProj == 3) {
                    PuProj.lorentz2Uhm(this.vtExact, this.vtExact);
                } else {
                    PsDebug.warning("unknown projection type");
                }
            } else {
                PsDebug.warning("unknown ambient space");
            }
            int n = 0;
            while (n < this.m_dim - 1) {
                pdVector.m_data[n] = this.vtExact.m_data[n];
                ++n;
            }
            n = this.m_dim - 1;
            while (n < 3) {
                pdVector.m_data[n] = 0.0;
                ++n;
            }
        }
        if (pdMatrix2 != null) {
            pdVector.m_data[3] = 1.0;
            if (this.m_position == null) {
                pdVector.leftMultMatrix(pdMatrix2);
            } else {
                d = PdVector.length(3, pdMatrix2.m_data[2]);
                pdVector.m_data[3] = 0.0;
                pdVector.leftMultMatrix(pdMatrix2);
                pdVector.multScalar(1.0 / d);
            }
        }
        pdVector.m_data[3] = 1.0;
        if (this.m_position == null) {
            int n = 0;
            do {
                d = pdMatrix.m_data[n][3];
                int n2 = 0;
                do {
                    d += pdMatrix.m_data[n][n2] * pdVector.m_data[n2];
                } while (++n2 < 3);
                piVector.m_data[n] = (int)(d + 0.5);
            } while (++n < 3);
            return;
        }
        double d2 = PdVector.length(3, this.m_viewMat.m_data[2]);
        int n = PS_ZOOM * this.m_dispSize.width / 10;
        int n3 = PS_ZOOM * this.m_dispSize.height - n;
        double d3 = pdMatrix.m_data[0][3];
        double d4 = pdMatrix.m_data[1][3];
        d = pdMatrix.m_data[0][3];
        int n4 = 0;
        do {
            d += pdMatrix.m_data[0][n4] * pdVector.m_data[n4] / d2;
        } while (++n4 < 3);
        piVector.m_data[0] = (int)(d + (double)n - d3 + 0.5);
        d = pdMatrix.m_data[1][3];
        n4 = 0;
        do {
            d += pdMatrix.m_data[1][n4] * pdVector.m_data[n4] / d2;
        } while (++n4 < 3);
        piVector.m_data[1] = (int)(d + (double)n3 - d4 + 0.5);
        d = pdMatrix.m_data[2][3];
        n4 = 0;
        do {
            d += pdMatrix.m_data[2][n4] * pdVector.m_data[n4] / d2;
        } while (++n4 < 3);
        piVector.m_data[2] = (int)(d + 0.5);
    }

    private int discretizeBndEdge(int n, int n2, int n3, int n4, int n5, int n6, PdVector pdVector, PdVector pdVector2, PiVector[] piVectorArray, PdVector[] pdVectorArray, int n7, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n8, int[] nArray, int n9, int n10, int n11) {
        int n12;
        int n13;
        int n14;
        int n15;
        double d;
        double d2;
        double d3;
        int n16;
        int n17 = n7;
        int n18 = n4 - n;
        int n19 = n5 - n2;
        double d4 = n6 - n3;
        int n20 = n;
        int n21 = n2;
        double d5 = n3;
        double d6 = pdVector.m_data[0] + 0.5;
        double d7 = pdVector.m_data[1] + 0.5;
        double d8 = pdVector.m_data[2];
        int n22 = 1;
        int n23 = 1;
        if (n18 < 0) {
            n18 = -n18;
            n22 = -1;
        }
        if (n19 < 0) {
            n19 = -n19;
            n23 = -1;
        }
        int n24 = nArray.length;
        int n25 = 0xFFFFFF;
        if (Math.abs(n18) <= Math.abs(n19)) {
            n16 = Math.abs(n19);
            d3 = (pdVector2.m_data[0] - pdVector.m_data[0]) / (double)n16;
            d2 = (pdVector2.m_data[1] - pdVector.m_data[1]) / (double)n16;
            d = (pdVector2.m_data[2] - pdVector.m_data[2]) / (double)n16;
            if (n16 == 0) {
                return n7;
            }
            d4 /= (double)Math.abs(n19);
            n15 = 2 * n18 - n19;
            n14 = 2 * n18;
            n13 = 2 * (n18 - n19);
            do {
                pdVectorArray[n7].set(d6, d7, d8);
                piVectorArray[n7].set(n20, n21, (int)d5);
                if (this.m_bShowCurrEdge && (n12 = (n21 - n11) * n9 + (n20 - n10)) >= 0 && n12 < n24) {
                    nArray[n12] = m_colMark << 24 | nArray[n12] & n25;
                }
                ++n7;
                d6 += d3;
                d7 += d2;
                d8 += d;
                n21 += n23;
                d5 += d4;
                if (n15 <= 0) {
                    n15 += n14;
                    continue;
                }
                n15 += n13;
                n20 += n22;
            } while (n21 != n5);
        } else {
            n16 = Math.abs(n18);
            d3 = (pdVector2.m_data[0] - pdVector.m_data[0]) / (double)n16;
            d2 = (pdVector2.m_data[1] - pdVector.m_data[1]) / (double)n16;
            d = (pdVector2.m_data[2] - pdVector.m_data[2]) / (double)n16;
            if (n16 == 0) {
                return n7;
            }
            d4 /= (double)Math.abs(n18);
            n15 = 2 * n19 - n18;
            n14 = 2 * n19;
            n13 = 2 * (n19 - n18);
            pdVectorArray[n7].set(d6, d7, d8);
            piVectorArray[n7].set(n20, n21, (int)d5);
            if (this.m_bShowCurrEdge && (n12 = (n21 - n11) * n9 + (n20 - n10)) >= 0 && n12 < n24) {
                nArray[n12] = m_colMark << 24 | nArray[n12] & n25;
            }
            ++n7;
            boolean bl5 = bl2 && n23 < 0 || bl3 && n23 > 0;
            while (n20 != n4) {
                if (n15 <= 0) {
                    d6 += d3;
                    d7 += d2;
                    d8 += d;
                    n15 += n14;
                    n20 += n22;
                    d5 += d4;
                } else if (bl5) {
                    d6 += d3;
                    d7 += d2;
                    d8 += d;
                    n15 += n13;
                    d5 += d4;
                    n21 += n23;
                    if ((n20 += n22) != n4) {
                        pdVectorArray[n7].set(d6, d7, d8);
                        piVectorArray[n7].set(n20, n21, (int)d5);
                        ++n7;
                    }
                } else {
                    pdVectorArray[n7].set(d6, d7, d8);
                    piVectorArray[n7].set(n20, n21, (int)d5);
                    ++n7;
                    d6 += d3;
                    d7 += d2;
                    d8 += d;
                    n15 += n13;
                    n20 += n22;
                    d5 += d4;
                    n21 += n23;
                }
                if (!this.m_bShowCurrEdge || (n12 = (n21 - n11) * n9 + (n20 - n10)) < 0 || n12 >= n24) continue;
                nArray[n12] = m_colMark << 24 | nArray[n12] & n25;
            }
        }
        if (!bl) {
            if (n8 == NNW || n8 == NWW || n8 == SWW || n8 == NNE) {
                n16 = n17;
                while (n16 < n7) {
                    piVectorArray[n16].m_data[3] = 0;
                    ++n16;
                }
            } else if (n8 == SEE || n8 == NEE) {
                n16 = n17;
                while (n16 < n7) {
                    piVectorArray[n16].m_data[3] = 0;
                    ++n16;
                }
            } else if (n8 == SSE) {
                if (n23 < 0) {
                    piVectorArray[n17].m_data[3] = 0;
                    n16 = n17 + 1;
                    while (n16 < n7) {
                        piVectorArray[n16].m_data[3] = piVectorArray[n16 - 1].m_data[0] - piVectorArray[n16].m_data[0] + 1;
                        ++n16;
                    }
                } else {
                    n16 = n17;
                    while (n16 < n7 - 1) {
                        piVectorArray[n16].m_data[3] = piVectorArray[n16 + 1].m_data[0] - piVectorArray[n16].m_data[0] + 1;
                        ++n16;
                    }
                    piVectorArray[n7 - 1].m_data[3] = n7 - 2 >= n17 ? piVectorArray[n7 - 2].m_data[3] : 0;
                }
            } else if (n8 == SSW) {
                if (n23 < 0) {
                    piVectorArray[n17].m_data[3] = 0;
                    n16 = n17 + 1;
                    while (n16 < n7) {
                        piVectorArray[n16].m_data[3] = piVectorArray[n16 - 1].m_data[0] - piVectorArray[n16].m_data[0] - 1;
                        ++n16;
                    }
                } else {
                    n16 = n17;
                    while (n16 < n7 - 1) {
                        piVectorArray[n16].m_data[3] = piVectorArray[n16 + 1].m_data[0] - piVectorArray[n16].m_data[0] - 1;
                        ++n16;
                    }
                    piVectorArray[n7 - 1].m_data[3] = n7 - 2 >= n17 ? piVectorArray[n7 - 2].m_data[3] : 0;
                }
            }
        }
        return n7;
    }

    public boolean hasTagElement(int n, int n2) {
        return this.m_element[n].hasTag(n2);
    }

    public boolean setPolygonColor(int n, Color color) {
        if (n < 0) {
            PsDebug.error("index=" + n + " out of range", this);
            return false;
        }
        if (color == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        if (n >= this.m_numPolygons) {
            this.setNumPolygons(n + 1);
        }
        this.assurePolygonColors();
        this.m_polygonColor[n] = color;
        return true;
    }

    public void setNumVectors(int n, int n2, int n3) {
        super.setNumVectors(n, n2, n3);
        this.m_vectorTrans[n] = PiVector.realloc(this.m_vectorTrans[n], n2, this.m_dimTrans);
    }

    public boolean setPolygonTag(int n, int n2) {
        if (n < 0 || n > this.m_numPolygons - 1) {
            PsDebug.error("index=" + n + " out of range", this);
            return false;
        }
        if (n2 < 0 || n2 >= 32) {
            PsDebug.warning("tag=" + n2 + " out of range", this);
            return false;
        }
        this.m_polygon[n].setTag(n2);
        return true;
    }

    public boolean hasTagVertex(int n, int n2) {
        return this.m_vertex[n].hasTag(n2);
    }

    public int addVertex(PdVector pdVector) {
        this.setNumVertices(this.m_numVertices + 1);
        this.m_vertex[this.m_numVertices - 1].copy(pdVector);
        return this.m_numVertices - 1;
    }

    public void setGlobalBndSize(double d) {
        this.m_globalBndSize = d;
        if (this.m_globalBndSize > 1.0) {
            this.m_globalBndSize = 2.0 * d - 1.0;
        }
    }

    private boolean drawPolygonZBuffer(Graphics graphics, int n, int[] nArray, int[] nArray2, int[] nArray3, int n2, Color color) {
        if (color != null) {
            this.m_currElementCol = this.m_alpha | color.getRGB();
        }
        if (n < 3) {
            int n3 = this.assureMIS(nArray, nArray2, n2);
            if (n3 == MIS_IMAGE_OUTSIDE) {
                return false;
            }
            int n4 = 0;
            while (n4 < n2) {
                int n5 = (n4 + 1) % n2;
                this.drawLine_(nArray[n4], nArray2[n4], nArray3[n4], nArray[n5], nArray2[n5], nArray3[n5], this.m_pix.m_data, this.imgWidth, this.m_elemMin[0], this.m_elemMin[1], ((PvDisplay)this.m_display).getZBuffer(), color);
                ++n4;
            }
            if (!this.m_bNewZBuffer) {
                this.drawMIS(graphics, n3);
            }
        } else {
            int n6 = 0;
            while (n6 < n2) {
                int n7 = (n6 + 1) % n2;
                this.drawLine_(graphics, n, nArray[n6], nArray2[n6], nArray3[n6], nArray[n7], nArray2[n7], nArray3[n7], this.m_pix.m_data, this.imgWidth, this.m_elemMin[0], this.m_elemMin[1], ((PvDisplay)this.m_display).getZBuffer(), color);
                ++n6;
            }
        }
        return true;
    }

    protected int getNumTaggedVertices() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_numVertices) {
            if (this.m_vertex[n2].hasTag(1)) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public void setNumVectorFields(int n) {
        if (n == this.m_numVectorFields) {
            return;
        }
        PiVector[][] piVectorArrayArray = new PiVector[n][];
        int n2 = 0;
        while (n2 < Math.min(n, this.m_numVectorFields)) {
            piVectorArrayArray[n2] = this.m_vectorTrans[n2];
            ++n2;
        }
        this.m_vectorTrans = piVectorArrayArray;
        this.m_bShowVectors = false;
        super.setNumVectorFields(n);
    }

    protected boolean untagAllVertices() {
        int n = 0;
        while (n < this.m_numVertices) {
            this.m_vertex[n].clearTag(1);
            this.m_geometry.clearTagVertex(n, 1);
            ++n;
        }
        return true;
    }

    protected int getNumUnusedVertices() {
        return this.m_numUnusedVertices;
    }

    public boolean setPolygonNormal(int n, PdVector pdVector) {
        if (n < 0) {
            PsDebug.error("index=" + n + " out of range", this);
            return false;
        }
        if (pdVector == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        if (n >= this.m_numPolygons) {
            this.setNumPolygons(n + 1);
        }
        this.assurePolygonNormals();
        this.m_polygonNormal[n].copy(pdVector);
        return true;
    }

    protected PiVector getTaggedVertices() {
        int n = this.getNumTaggedVertices();
        if (n == 0) {
            return null;
        }
        PiVector piVector = new PiVector(n);
        n = 0;
        int n2 = 0;
        while (n2 < this.m_numVertices) {
            if (this.m_vertex[n2].hasTag(1)) {
                piVector.setEntry(n++, n2);
            }
            ++n2;
        }
        return piVector;
    }

    protected boolean untagVertices(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        int n5 = 0;
        while (n5 < this.m_numVertices) {
            if (this.m_vertex[n5].hasTag(1) && rectangle.contains(this.m_vertexTrans[n5].m_data[0], this.m_vertexTrans[n5].m_data[1])) {
                this.m_vertex[n5].clearTag(1);
                this.m_geometry.clearTagVertex(n5, 1);
            }
            ++n5;
        }
        return true;
    }

    protected void setDisplay(PvDisplayIf pvDisplayIf) {
        this.m_display = pvDisplayIf;
    }

    protected int[] getUnusedVertices() {
        return this.m_unusedVertex.m_data;
    }

    protected int computeNumPolygonEdges() {
        this.m_numPolygonEdges = 0;
        int n = 0;
        while (n < this.m_numPolygons) {
            if (this.m_polygon[n] != null) {
                this.m_numPolygonEdges += Math.max(this.m_polygon[n].getSize() - 1, 0);
            }
            ++n;
        }
        return this.m_numPolygonEdges;
    }

    protected void drawItem(Graphics graphics, int n, double d, double d2) {
        this.m_heightFac = 0.2 + 0.8 * d;
        this.m_itemHeight = d2;
        if (!(this.m_bShowBackface || this.m_elementNormal != null && this.m_elementNormal.length >= this.m_numElements)) {
            this.m_bShowBackface = true;
            PsDebug.warning("missing normals, backelement culling switched off");
        }
        int n2 = 0;
        if (this.m_useVertices) {
            if (n < this.m_numVertices) {
                this.drawVertex(graphics, n);
                return;
            }
            n2 = this.m_numVertices;
        } else if (this.m_useUnusedVertices) {
            if (n < this.m_numUnusedVertices) {
                this.drawVertex(graphics, this.m_unusedVertex.getEntry(n));
                return;
            }
            n2 = this.m_numUnusedVertices;
        }
        if (this.m_useElements) {
            if (n - n2 < this.m_numElements) {
                this.drawElement(graphics, n - n2);
                return;
            }
            n2 += this.m_numElements;
        }
        if (this.m_usePolygons) {
            if (n - n2 < this.m_numPolygonEdges) {
                this.m_bShowCurrEdge = false;
                this.m_bShowCurrElement = true;
                this.m_bDrawingEdge = true;
                this.drawPolygon(graphics, n - n2);
                int n3 = 0;
                do {
                    if (this.m_origInd[n3] == -1) continue;
                    this.drawVertex(graphics, this.m_origInd[n3]);
                } while (++n3 < 2);
                return;
            }
            PsDebug.error("itemInd out of range, index = " + n, this);
        }
    }

    private void leftMult34(PdMatrix pdMatrix, PdVector pdVector, PiVector piVector) {
        int n = 0;
        do {
            double d = 0.0;
            int n2 = 0;
            do {
                d += pdMatrix.m_data[n][n2] * pdVector.m_data[n2];
            } while (++n2 < 4);
            piVector.m_data[n] = (int)(d + 0.5);
        } while (++n < 3);
    }

    private boolean isBackelementCulled(int n, int n2) {
        if (this.m_elementNormalTrans == null || this.m_elementNormalTrans.length < n) {
            return false;
        }
        return this.m_elementNormalTrans[n].hasTag(14);
    }

    private int assureMIS(int[] nArray, int[] nArray2, int n) {
        boolean bl = this.getElementBndBox(this.m_elemMin, this.m_elemMax, nArray, nArray2, n);
        if (!bl) {
            return MIS_IMAGE_OUTSIDE;
        }
        this.m_elemWidth = this.m_elemMax[0] - this.m_elemMin[0] + 1;
        this.m_elemHeight = this.m_elemMax[1] - this.m_elemMin[1] + 1;
        if ((double)(this.m_elemHeight + this.m_elemWidth) > (double)(this.m_dispSize.height + this.m_dispSize.width) * 2.0) {
            return MIS_IMAGE_OUTSIDE;
        }
        if (this.mis == null || this.imgHeight < this.m_elemHeight || this.imgWidth < this.m_elemWidth) {
            this.imgHeight = Math.max(this.m_elemHeight, this.imgHeight);
            this.imgWidth = Math.max(this.m_elemWidth, this.imgWidth);
            this.m_pix.setSize(this.imgWidth * this.imgHeight);
            this.m_pixZero.setSize(this.imgWidth * this.imgHeight);
            this.mis = new MemoryImageSource(this.imgWidth, this.imgHeight, this.m_pix.m_data, 0, this.imgWidth);
            this.mis.setAnimated(true);
            return MIS_IMAGE_REQUIRED;
        }
        return MIS_IMAGE_REDRAW;
    }

    private void drawMIS(Graphics graphics, int n) {
        if (n == MIS_IMAGE_REQUIRED) {
            this.m_destImage = ((Component)((Object)this.m_display)).createImage(this.mis);
        } else {
            this.mis.newPixels(0, 0, Math.max(this.m_elemWidth, this.prevElemWidth), Math.max(this.m_elemHeight, this.prevElemHeight));
        }
        if (this.m_destImage != null) {
            graphics.drawImage(this.m_destImage, this.m_elemMin[0], this.m_elemMin[1], null);
        }
        System.arraycopy(this.m_pixZero.m_data, 0, this.m_pix.m_data, 0, this.imgWidth * this.m_elemHeight);
        this.prevElemWidth = this.m_elemWidth;
        this.prevElemHeight = this.m_elemHeight;
    }

    protected void setMIS(int n, int n2, int[] nArray) {
        this.imgWidth = n;
        this.imgHeight = n2;
        this.m_elemHeight = n2;
        this.m_pix.m_data = nArray;
    }

    private void getElementCenter(double[] dArray, PiVector piVector, PiVector[] piVectorArray, int n) {
        int n2 = piVector.m_data.length;
        int n3 = 0;
        while (n3 < n) {
            dArray[n3] = 0.0;
            int n4 = 0;
            while (n4 < n2) {
                int n5 = n3;
                dArray[n5] = dArray[n5] + (double)piVectorArray[piVector.m_data[n4]].m_data[n3];
                ++n4;
            }
            int n6 = n3++;
            dArray[n6] = dArray[n6] / (double)n2;
        }
    }

    private void getElementCenter(double[] dArray, PiVector piVector, PdVector[] pdVectorArray, int n) {
        int n2 = piVector.m_data.length;
        int n3 = 0;
        while (n3 < n) {
            dArray[n3] = 0.0;
            int n4 = 0;
            while (n4 < n2) {
                int n5 = n3;
                dArray[n5] = dArray[n5] + pdVectorArray[piVector.m_data[n4]].m_data[n3];
                ++n4;
            }
            int n6 = n3++;
            dArray[n6] = dArray[n6] / (double)n2;
        }
    }

    protected void projectItems(PdMatrix pdMatrix, PdMatrix pdMatrix2, PdMatrix pdMatrix3, PdMatrix pdMatrix4) {
        if (this.m_dim + 1 != this.vt.getSize()) {
            this.vt.setSize(this.m_dim + 1);
            this.vtExact.setSize(this.m_dim);
        }
        this.m_projMat = pdMatrix2;
        this.m_viewMat = pdMatrix3;
        this.projectVertices(pdMatrix, pdMatrix4);
        int n = this.m_ambientProj;
        this.m_ambientProj = 0;
        int n2 = 0;
        do {
            this.m_vt.copyArray(this.m_bndBox[n2]);
            this.project(this.m_bndBoxTrans[n2], this.m_vt, pdMatrix, pdMatrix4);
        } while (++n2 < 2);
        this.m_ambientProj = n;
        if (this.m_bShowVertexNormals || this.m_bShowEdgeAura || this.m_bShowOutline || !this.m_bShowBackface || this.m_bShowElementBackColor) {
            this.projectVertexNormals(pdMatrix, pdMatrix4);
        }
        if (this.m_bShowElementNormals || this.m_bShowEdgeAura || this.m_bShowOutline || !this.m_bShowBackface || this.m_bShowElementBackColor || this.m_bShowElementBackColors) {
            this.projectElementNormals(pdMatrix, pdMatrix4);
        }
        if (this.m_bShowVectors) {
            this.projectVectors(pdMatrix, pdMatrix4);
        }
    }

    public PgGeometryIf getGeometry() {
        return this.m_geometry;
    }

    public void setGeometry(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf == null) {
            PsDebug.warning("missing geometry");
            return;
        }
        this.m_geometry = pgGeometryIf;
        this.setName(pgGeometryIf.getName() + "_Container");
        this.update(this.m_geometry);
    }

    protected void setPosition(int n, int n2) {
        this.m_position = new int[]{n, n2};
    }

    public int getDrawingOrder() {
        return this.m_drawingOrder;
    }

    public void setDrawingOrder(int n) {
        this.m_drawingOrder = n;
    }

    private void drawElementVectors(Graphics graphics, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n3 = 0;
        while (n3 < this.m_numVectorFields) {
            if (this.m_bShowVectorField[n3] && this.m_vectorIsElementBased[n3]) {
                Color color = this.m_globalVectorColor[n3];
                if (this.m_bShowVectorColors[n3]) {
                    color = this.m_vectorColor[n3][n];
                }
                this.getElementCenter(this.m_elemCenter, this.m_element[n], this.m_vertexTrans, 3);
                this.drawVector_(graphics, (int)this.m_globalVectorSize[n3], (int)this.m_elemCenter[0], (int)this.m_elemCenter[1], (int)this.m_elemCenter[2], this.m_vectorTrans[n3][n].m_data[0], this.m_vectorTrans[n3][n].m_data[1], this.m_vectorTrans[n3][n].m_data[2], this.m_bShowVectorArrow[n3], color);
            }
            ++n3;
        }
    }

    public void init() {
        super.init();
        this.m_useVertices = true;
        this.m_useElements = true;
        this.m_bHasNeighbours = false;
        this.m_bShowTransparency = false;
        this.m_alpha = -16777216;
        this.m_bHasTaggedVertices = false;
        this.m_bHasTaggedPolygons = false;
        this.m_bHasTaggedEdges = false;
        this.m_bHasTaggedBoundaries = false;
        this.m_bHasTaggedElements = false;
        this.m_vertexTrans = null;
        this.m_vertexNormalTrans = null;
        this.m_elementNormalTrans = null;
        this.m_vectorTrans = null;
        this.m_globalBndboxColor = Color.magenta;
        this.m_bndBox = PdVector.realloc(this.m_bndBox, 2, this.m_dim);
        this.m_bndBox[0].setConstant(-1.0);
        this.m_bndBox[1].setConstant(1.0);
        this.m_bndBoxTrans = PiVector.realloc(this.m_bndBoxTrans, 2, this.m_dimTrans);
        this.m_center = new PdVector(this.m_dim);
        this.m_center.setConstant(0.0);
        this.m_elemCenter = new double[Math.max(3, this.m_dim)];
    }

    protected void projectVectors(PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        if (this.m_numVertices == 0 || this.m_numVectorFields == 0) {
            this.m_bShowVectors = false;
            return;
        }
        int n = 0;
        while (n < this.m_numVectorFields) {
            int n2;
            int n3;
            if (!this.m_vectorIsElementBased[n]) {
                n3 = 0;
                while (n3 < this.m_numVertices) {
                    n2 = 0;
                    while (n2 < this.m_dim) {
                        this.m_vt.m_data[n2] = this.m_vertex[n3].m_data[n2] + this.m_globalVectorLength[n] * this.m_vector[n][n3].m_data[n2];
                        ++n2;
                    }
                    this.project(this.m_vectorTrans[n][n3], this.m_vt, pdMatrix, pdMatrix2);
                    ++n3;
                }
            } else {
                n3 = 0;
                while (n3 < this.m_numElements) {
                    this.getElementCenter(this.m_elemCenter, this.m_element[n3], this.m_vertex, this.m_dim);
                    n2 = 0;
                    while (n2 < this.m_dim) {
                        this.m_vt.m_data[n2] = this.m_elemCenter[n2] + this.m_globalVectorLength[n] * this.m_vector[n][n3].m_data[n2];
                        ++n2;
                    }
                    this.project(this.m_vectorTrans[n][n3], this.m_vt, pdMatrix, pdMatrix2);
                    ++n3;
                }
            }
            ++n;
        }
    }

    protected boolean setGeometryElement(int n, PiVector piVector) {
        this.setElement(n, piVector);
        return this.m_geometry.setElement(n, piVector);
    }

    protected int pickVertex(int n, int n2) {
        Rectangle rectangle = new Rectangle();
        int n3 = 0;
        while (n3 < this.m_numVertices) {
            rectangle.setBounds(this.m_vertexTrans[n3].m_data[0] - 3, this.m_vertexTrans[n3].m_data[1] - 3, 7, 7);
            if (rectangle.contains(n, n2)) {
                this.m_vertex[n3].setTag(1);
                this.m_geometry.setTagVertex(n3, 1);
                this.m_bHasTaggedVertices = true;
                this.m_pickedVertex = n3;
                return this.m_pickedVertex;
            }
            ++n3;
        }
        return -1;
    }

    protected int releaseVertex(int n) {
        if (n >= 0 && n < this.m_numVertices) {
            this.m_vertex[n].clearTag(1);
            this.m_geometry.clearTagVertex(n, 1);
        }
        this.m_pickedVertex = -1;
        return -1;
    }

    public void setTexture(int[] nArray, int n, int n2) {
        this.m_texturePix = nArray;
        this.m_textureWidth = n;
        this.m_textureHeight = n2;
        if (nArray == null) {
            this.setState(71, false);
            this.setState(72, false);
        }
    }

    public boolean setElementTexture(int n, PdVector[] pdVectorArray) {
        if (n < 0 || n > this.m_numElements - 1) {
            PsDebug.error("index=" + n + " out of range", this);
            return false;
        }
        if (pdVectorArray == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        this.assureElementTextures();
        this.m_elementTexture[n] = PdVector.copyNew(pdVectorArray, pdVectorArray.length);
        return true;
    }

    public boolean setVertexTexture(int n, PdVector pdVector) {
        if (n < 0 || n > this.m_numVertices - 1) {
            PsDebug.error("index=" + n + " out of range", this);
            return false;
        }
        if (pdVector == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        this.assureVertexTextures();
        this.m_vertexTexture[n].copy(pdVector);
        return true;
    }

    protected boolean setGeometryVertex(int n, PdVector pdVector) {
        this.setVertex(n, pdVector);
        return this.m_geometry.setVertex(n, pdVector);
    }

    public void clearTagElement(int n, int n2) {
        this.m_element[n].clearTag(n2);
        this.m_geometry.clearTagElement(n, n2);
    }

    private void drawElement(Graphics graphics, int n) {
        int n2;
        int n3 = this.m_element[n].m_data.length;
        if (n3 == 0) {
            return;
        }
        if (!this.m_bShowBackface && this.isBackelementCulled(n, n3)) {
            return;
        }
        if (this.m_bShowVertexTexture && this.m_vertexTexture == null) {
            this.m_bShowVertexTexture = false;
        }
        if (this.m_bShowElementTexture && this.m_elementTexture == null) {
            this.m_bShowElementTexture = false;
        }
        if ((this.m_bShowVertexTexture || this.m_bShowElementTexture || this.m_bEnableZBuffer) && this.texCoord == null) {
            this.texCoord = PdVector.realloc(this.texCoord, this.m_maxDimOfElements, 3);
        }
        if (this.m_bEnableClip) {
            this.m_elemIsClipped = false;
            if (this.m_bShowVertexTexture) {
                PdVector[] pdVectorArray = new PdVector[n3];
                n2 = 0;
                while (n2 < n3) {
                    pdVectorArray[n2] = this.m_vertexTexture[this.m_element[n].m_data[n2]];
                    ++n2;
                }
                n3 = this.clipElement(n, n3, this.xv, this.yv, this.zv, this.m_origInd, this.texCoord, pdVectorArray);
            } else {
                n3 = this.m_bShowElementTexture ? this.clipElement(n, n3, this.xv, this.yv, this.zv, this.m_origInd, this.texCoord, this.m_elementTexture[n]) : this.clipElement(n, n3, this.xv, this.yv, this.zv, this.m_origInd, null, null);
            }
            if (this.m_bShowVertexTexture || this.m_bShowElementTexture) {
                int n4 = 0;
                while (n4 < n3) {
                    if (this.m_bShowVertexTexture || this.m_bShowElementTexture) {
                        this.texCoord[n4].m_data[0] = this.texCoord[n4].m_data[0] * ((double)this.m_textureWidth - 1.0);
                        this.texCoord[n4].m_data[1] = this.texCoord[n4].m_data[1] * ((double)this.m_textureHeight - 1.0);
                    }
                    ++n4;
                }
            }
            if (n3 == 0) {
                return;
            }
        } else {
            int n5 = 0;
            while (n5 < n3) {
                n2 = this.m_element[n].m_data[n5];
                this.xv[n5] = this.m_vertexTrans[n2].m_data[0];
                this.yv[n5] = this.m_vertexTrans[n2].m_data[1];
                this.zv[n5] = this.m_vertexTrans[n2].m_data[2];
                this.m_origInd[n5] = n2;
                ++n5;
            }
            if (this.m_bShowVertexTexture || this.m_bShowElementTexture) {
                if (this.m_dimOfTextures == 3) {
                    n5 = 0;
                    while (n5 < n3) {
                        if (this.m_bShowVertexTexture) {
                            this.texCoord[n5].copyArray(this.m_vertexTexture[this.m_element[n].m_data[n5]]);
                        } else if (this.m_bShowElementTexture) {
                            this.texCoord[n5].copyArray(this.m_elementTexture[n][n5]);
                        }
                        ++n5;
                    }
                } else {
                    n5 = 0;
                    while (n5 < n3) {
                        if (this.m_bShowVertexTexture) {
                            this.texCoord[n5].copyArray(this.m_vertexTexture[this.m_element[n].m_data[n5]]);
                        } else if (this.m_bShowElementTexture) {
                            this.texCoord[n5].copyArray(this.m_elementTexture[n][n5]);
                        }
                        this.texCoord[n5].m_data[0] = this.texCoord[n5].m_data[0] * ((double)this.m_textureWidth - 1.0);
                        this.texCoord[n5].m_data[1] = this.texCoord[n5].m_data[1] * ((double)this.m_textureHeight - 1.0);
                        ++n5;
                    }
                }
            } else if (this.m_bEnableZBuffer) {
                n5 = 0;
                while (n5 < n3) {
                    this.texCoord[n5].m_data[0] = (double)this.m_textureWidth - 1.0;
                    this.texCoord[n5].m_data[1] = (double)this.m_textureHeight - 1.0;
                    ++n5;
                }
            }
        }
        if (this.m_bShowVertexTexture || this.m_bShowElementTexture || this.m_bEnableZBuffer) {
            double d = PvScene.m_zMin;
            double d2 = PvScene.m_zMax;
            double d3 = 1.0;
            if (d2 - d != 0.0) {
                d3 = d2 - d;
            }
            int n6 = 0;
            while (n6 < n3) {
                this.texCoord[n6].setEntry(2, Math.sqrt(((double)this.zv[n6] - d) / d3));
                ++n6;
            }
        }
        this.m_bShowCurrElement = this.m_bShowElements || this.m_bShowTaggedElements && this.m_bHasTaggedElements;
        this.m_bShowCurrEdge = this.m_bShowEdges || this.m_bShowOutline || this.m_bShowTaggedEdges && this.m_bHasTaggedEdges;
        this.m_bDrawingEdge = false;
        this.m_bDepthcueEdge = false;
        if (this.m_bShowElements || this.m_bShowTaggedElements && this.m_bHasTaggedElements) {
            if ((this.m_bShowVertexTexture || this.m_bShowElementTexture || this.m_bEnableZBuffer) && n3 > 4) {
                this.elemSub = this.triangulate(this.xv, this.yv, this.zv, n3);
                int n7 = 0;
                while (n7 < n3 - 2) {
                    n2 = 0;
                    do {
                        this.xvSub[n2] = this.xv[this.elemSub[n7][n2]];
                        this.yvSub[n2] = this.yv[this.elemSub[n7][n2]];
                        this.zvSub[n2] = this.zv[this.elemSub[n7][n2]];
                        this.texSub[n2] = this.texCoord[this.elemSub[n7][n2]];
                    } while (++n2 < 3);
                    this.drawElement(graphics, n, 3, this.xvSub, this.yvSub, this.zvSub, this.texSub);
                    ++n7;
                }
            } else {
                this.drawElement(graphics, n, n3, this.xv, this.yv, this.zv, this.texCoord);
            }
        }
        this.m_bShowCurrElement = true;
        this.m_bShowCurrEdge = false;
        this.m_bDrawingEdge = true;
        if ((this.m_bShowEdges || this.m_bShowOutline || this.m_bShowTaggedEdges && this.m_bHasTaggedEdges) && (!this.m_bShowVertexTexture && !this.m_bShowElementTexture && !this.m_bEnableZBuffer || !(this.m_globalEdgeSize < 2.0) || !this.m_bShowElements || this.m_bShowOutline)) {
            this.m_bDepthcueEdge = !this.m_bShowElements;
            this.drawElementEdges(graphics, n, n3, this.xv, this.yv, this.zv, this.texCoord);
        }
        this.m_bDepthcueEdge = false;
        if (!(!this.m_bShowBoundaries || this.m_bEnableClip && this.m_elemIsClipped)) {
            this.drawElementBnd(graphics, n, n3, this.xv, this.yv, this.zv);
        }
        if (!this.m_useVertices && (this.m_bShowVertices || this.m_bShowTaggedVertices && this.m_bHasTaggedVertices || this.m_bShowVertexNormals || this.m_bShowVectors)) {
            this.drawElementVertices(graphics, n, n3, this.m_origInd);
        }
        if ((this.m_bShowIndices || this.m_bShowElementLabels) && (this.m_bShowElements || this.m_bShowTaggedElements && this.m_bHasTaggedElements)) {
            int n8 = 0;
            n2 = 0;
            int n9 = n3 - 1;
            while (n9 >= 0) {
                n8 += this.xv[n9];
                n2 += this.yv[n9];
                --n9;
            }
            graphics.setColor(Color.orange);
            String string = this.m_element[n].getName();
            if (string == null && this.m_bDefaultLabelEnabled) {
                string = String.valueOf(n);
            }
            int[] nArray = this.m_labelAttribute[3].m_data;
            this.drawString(graphics, string, n8 / n3, n2 / n3, 0, nArray);
        }
        if (this.m_bShowElementNormals) {
            this.drawElementNormal(graphics, n, n3, this.xv, this.yv, this.zv);
        }
        if (this.m_bShowVectors) {
            this.drawElementVectors(graphics, n, n3, this.xv, this.yv, this.zv, this.m_origInd);
        }
    }

    private void drawElement(Graphics graphics, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, PdVector[] pdVectorArray) {
        Color color = this.m_globalElementColor;
        if (this.m_bShowTaggedElements && this.m_bHasTaggedElements && this.m_element[n].hasTag(1)) {
            color = this.m_globalElementTagColor;
        } else if (this.m_bShowElements) {
            color = (this.m_bShowElementBackColor || this.m_bShowElementBackColors) && this.isBackelementCulled(n, n2) ? (this.m_bShowElementBackColors && this.m_elementBackColor != null ? this.m_elementBackColor[n] : this.m_globalElementBackColor) : (this.m_bShowElementColors && this.m_elementColor != null ? this.m_elementColor[n] : this.m_globalElementColor);
            if (this.m_bShowDepthcue && !this.m_bEnableZBuffer) {
                color = PdColor.getDimmedColor(color, this.m_heightFac);
            } else if (this.m_elementNormal != null && this.m_elementNormal.length >= this.m_numElements) {
                double d = PdVector.dot(this.m_elementNormal[n], this.m_lightDir);
                if (d < 0.0) {
                    d = -d;
                }
                d = 1.0 - d * 0.3;
                color = PdColor.getDimmedColor(color, d);
            }
        } else {
            return;
        }
        if (this.m_bShowVertexTexture || this.m_bShowElementTexture || this.m_bEnableZBuffer) {
            this.m_currEdgeCol = this.m_alpha | this.getEdgeColor_(n).getRGB();
            this.drawElementZBuffer(graphics, nArray, nArray2, nArray3, n2, color, pdVectorArray);
            return;
        }
        graphics.setColor(color);
        graphics.fillPolygon(nArray, nArray2, n2);
    }

    protected boolean removeGeometryElement(int n) {
        this.removeElement(n);
        this.m_geometry.removeElement(n);
        return true;
    }

    private void drawString(Graphics graphics, String string, int n, int n2, int n3, int[] nArray) {
        if (string == null) {
            return;
        }
        if (graphics.getFont() != PsConfig.getFont(nArray[4])) {
            graphics.setFont(PsConfig.getFont(nArray[4]));
        }
        int n4 = 0;
        int n5 = 0;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (nArray[2] == 0) {
            n4 = n3;
        } else if (nArray[2] == 1) {
            n4 = -fontMetrics.stringWidth(string) / 2;
        } else if (nArray[2] == 2) {
            n4 = -fontMetrics.stringWidth(string) - n3;
        }
        if (nArray[3] == 0) {
            n5 = n3;
        } else if (nArray[3] == 1) {
            n5 = fontMetrics.getHeight() / 2;
        } else if (nArray[3] == 2) {
            n5 = fontMetrics.getHeight() + n3;
        }
        graphics.drawString(string, n + (nArray[0] + n4) * PS_ZOOM, n2 + (nArray[1] + n5) * PS_ZOOM);
    }

    protected boolean tagVertices(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        int n5 = 0;
        while (n5 < this.m_numVertices) {
            if (rectangle.contains(this.m_vertexTrans[n5].m_data[0], this.m_vertexTrans[n5].m_data[1])) {
                this.m_vertex[n5].setTag(1);
                this.m_geometry.setTagVertex(n5, 1);
            }
            ++n5;
        }
        return true;
    }

    private void drawElementEdges(Graphics graphics, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, PdVector[] pdVectorArray) {
        Color color;
        block5: {
            if (this.m_bShowEdgeAura && !this.m_bShowElements) {
                graphics.setColor(this.m_backColor);
                PvThickGraphics.drawPolygon(graphics, Math.max(6, (int)(2.0 * this.m_globalEdgeSize)), nArray, nArray2, n2, !this.isBackelementCulled(n, n2));
            }
            color = this.getEdgeColor_(n);
            if (!this.m_bShowOutline || !this.m_bHasNeighbours || this.m_elementNormal == null || this.m_elementNormal.length < this.m_numElements || this.m_bEnableClip && this.m_elemIsClipped) break block5;
            int n3 = 0;
            while (n3 < n2) {
                block6: {
                    int n4;
                    int n5;
                    int n6;
                    block8: {
                        block7: {
                            int n7 = this.m_neighbour[n].m_data[n3];
                            if (n7 >= this.m_numElements) break block6;
                            n6 = (n3 + 1) % n2;
                            n5 = (n3 + 2) % n2;
                            n4 = (int)this.m_globalEdgeSize;
                            if (n7 == -1 || this.isBackelementCulled(n, n2) == this.isBackelementCulled(n7, n2)) break block7;
                            n4 = (int)(2.0 * this.m_globalBndSize + 1.0);
                            break block8;
                        }
                        if (!this.m_bShowEdges) break block6;
                    }
                    this.drawLine(graphics, n4, nArray[n6], nArray2[n6], nArray3[n6], nArray[n5], nArray2[n5], nArray3[n5], color);
                }
                ++n3;
            }
            return;
        }
        this.drawPolygon(graphics, (int)this.m_globalEdgeSize, nArray, nArray2, nArray3, n2, color);
    }

    private void drawElementVertices(Graphics graphics, int n, int n2, int[] nArray) {
        int n3 = 0;
        while (n3 < n2) {
            block5: {
                block6: {
                    if (nArray[n3] == -1) break block5;
                    if (!this.m_bShowBackface || !this.m_bShowEdgeOnce || !this.m_bHasNeighbours || this.m_bEnableClip && this.m_elemIsClipped || this.m_numUnusedVertices != 0) break block6;
                    int n4 = this.m_neighbour[n].m_data[(n3 - 2 + n2) % n2];
                    int n5 = this.m_neighbour[n].m_data[(n3 - 1 + n2) % n2];
                    if (n4 >= this.m_numElements || n5 >= this.m_numElements) {
                        PsDebug.warning("void neighbour information, invoke: makeNeighbour()!");
                        return;
                    }
                    if (n4 != -1 && this.m_itemHeight < this.m_scene.getHeightOfElementInCurrentGeometry(n4) || n5 != -1 && this.m_itemHeight < this.m_scene.getHeightOfElementInCurrentGeometry(n5)) break block5;
                }
                this.drawVertex(graphics, nArray[n3]);
            }
            ++n3;
        }
    }

    protected void projectVertices(PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        if (this.m_numVertices == 0) {
            return;
        }
        m_zMin = Integer.MAX_VALUE;
        m_zMax = Integer.MIN_VALUE;
        int n = 0;
        while (n < this.m_numVertices) {
            this.m_vt.copyArray(this.m_vertex[n]);
            this.project(this.m_vertexTrans[n], this.m_vt, pdMatrix, pdMatrix2);
            if (this.m_vertexTrans[n].m_data[2] < m_zMin) {
                m_zMin = this.m_vertexTrans[n].m_data[2];
            }
            if (this.m_vertexTrans[n].m_data[2] > m_zMax) {
                m_zMax = this.m_vertexTrans[n].m_data[2];
            }
            ++n;
        }
    }

    private void drawVectorTip(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, Color color) {
        double d = n5 - n2;
        double d2 = n6 - n3;
        double d3 = n7 - n4;
        double d4 = d * d + d2 * d2;
        double d5 = (double)PS_ZOOM * ((double)n + 4.0);
        if (d4 < 1.0) {
            return;
        }
        double d6 = bl ? 2.0 * d5 / Math.PI / Math.sqrt(d4) * Math.atan(d4 / 50.0 / (double)PS_ZOOM / (double)PS_ZOOM) : 2.0 * d5 / Math.PI / Math.sqrt(d4) * Math.atan(8.0 / (double)PS_ZOOM / (double)PS_ZOOM);
        d = (int)(d * d6);
        d2 = (int)(d2 * d6);
        d3 = (int)(d3 * d6);
        int n8 = n5 + (int)(-d + d2);
        int n9 = n6 + (int)(-d - d2);
        int n10 = n7 - (int)d3;
        this.drawLine(graphics, n, n5, n6, n7, n8, n9, n10, color);
        n8 = n5 + (int)(-d - d2);
        n9 = n6 + (int)(d - d2);
        this.drawLine(graphics, n, n5, n6, n7, n8, n9, n10, color);
    }

    protected void setMaxNumVertices(int n) {
        if (this.m_maxNumVertices == n) {
            return;
        }
        super.setMaxNumVertices(n);
        this.m_vertexTrans = PiVector.realloc(this.m_vertexTrans, n, this.m_dimTrans);
        if (this.m_vertexNormal != null) {
            this.m_vertexNormalTrans = PiVector.realloc(this.m_vertexNormalTrans, n, this.m_dimTrans);
        }
    }

    public boolean update(Object object) {
        int n;
        if (object != this.m_geometry) {
            return false;
        }
        if (this.m_geometry == null) {
            PsDebug.warning("missing associated geometry");
            return false;
        }
        this.m_geometry.paint(this);
        if (!this.getName().startsWith(this.m_geometry.getName())) {
            this.setName(this.m_geometry.getName() + "_Container");
        }
        this.getBounds();
        if (this.m_bShowTaggedVertices) {
            this.m_bHasTaggedVertices = false;
            n = 0;
            while (n < this.m_numVertices) {
                if (this.m_vertex[n].hasTag(1)) {
                    this.m_bHasTaggedVertices = true;
                    break;
                }
                ++n;
            }
        }
        if (this.m_bShowTaggedPolygons) {
            this.m_bHasTaggedPolygons = false;
            n = 0;
            while (n < this.m_numPolygons) {
                if (this.m_polygon[n].hasTag(1)) {
                    this.m_bHasTaggedPolygons = true;
                    break;
                }
                ++n;
            }
        }
        if (this.m_bShowTaggedElements) {
            this.m_bHasTaggedElements = false;
            n = 0;
            while (n < this.m_numElements) {
                if (this.m_element[n].hasTag(1)) {
                    this.m_bHasTaggedElements = true;
                    break;
                }
                ++n;
            }
        }
        this.m_numUnusedVertices = 0;
        if (this.m_numVertices > 0 && this.m_bShowVertices && (this.m_numElements > 0 || this.m_numPolygonEdges > 0)) {
            this.updateUnusedVertices();
        }
        this.m_useVertices = false;
        this.m_useUnusedVertices = false;
        this.m_useElements = false;
        this.m_usePolygons = false;
        if (this.m_numElements == 0 && this.m_numPolygonEdges == 0 && (this.m_bShowVertices || this.m_bShowTaggedVertices || this.m_bShowVertexNormals || this.m_bShowVectors) || !this.m_bShowElements && !this.m_bShowEdges && !this.m_bShowBoundaries && !this.m_bShowElementNormals && !this.m_bShowVectors && !this.m_bShowPolygons) {
            this.m_useVertices = true;
        } else if (this.m_bShowVertices && this.m_numUnusedVertices > 0 && (this.m_numElements > 0 || this.m_numPolygonEdges > 0)) {
            this.m_useUnusedVertices = true;
        }
        if (this.m_numPolygonEdges > 0 && (this.m_bShowPolygons || this.m_bShowTaggedPolygons || this.m_bShowPolygonNormals)) {
            this.m_usePolygons = true;
        }
        this.m_bHasNeighbours = false;
        if (this.m_numElements > 0 && (this.m_bShowElements || this.m_bShowEdges || this.m_bShowOutline || this.m_bShowBoundaries || this.m_bShowElementNormals || this.m_bShowVectors || this.m_bShowTaggedElements && this.m_bHasTaggedElements || this.m_bShowTaggedEdges && this.m_bHasTaggedEdges)) {
            this.m_useElements = true;
            if (this.m_neighbour != null && this.m_neighbour.length >= this.m_numElements && this.m_neighbour[0] != null && this.m_neighbour[0].getSize() == this.m_element[0].getSize()) {
                this.m_bHasNeighbours = true;
            }
        }
        return true;
    }

    protected void drawTitle(Graphics graphics) {
        if (!this.m_bShowTitle) {
            return;
        }
        String string = this.m_geometry.getName();
        if (string == null) {
            return;
        }
        graphics.setColor(Color.black);
        int[] nArray = this.m_labelAttribute[5].m_data;
        this.drawString(graphics, string, this.m_bndBoxTrans[1].m_data[0], this.m_bndBoxTrans[1].m_data[1], 0, nArray);
    }

    protected int getZMax() {
        return m_zMax;
    }

    public boolean setPolygon(int n, PiVector piVector) {
        if (!super.setPolygon(n, piVector)) {
            return false;
        }
        this.computeNumPolygonEdges();
        return true;
    }

    public void clearTagPolygon(int n, int n2) {
        this.m_polygon[n].clearTag(n2);
        this.m_geometry.clearTagPolygon(n, n2);
    }

    private void drawPolygon(Graphics graphics, int n) {
        Color color;
        int n2;
        int n3;
        int n4 = 0;
        while (n4 < this.m_numPolygons) {
            n3 = this.m_polygon[n4].getSize() - 1;
            if (n < n3) break;
            n -= n3;
            ++n4;
        }
        if (n4 == this.m_numPolygons) {
            PsDebug.warning("edgeInd = " + n + " out of bounds.");
            return;
        }
        n3 = n != 0 ? 0 : 1;
        boolean bl = n == this.m_polygon[n4].getSize() - 2;
        int n5 = 2;
        if (this.m_bEnableClip) {
            this.m_elemIsClipped = false;
            n5 = this.clipPolygon(n4, n, this.xv, this.yv, this.zv, this.m_origInd);
            if (n5 == 0) {
                return;
            }
        } else {
            n2 = 0;
            while (n2 < n5) {
                int n6 = this.m_polygon[n4].m_data[n + n2];
                this.xv[n2] = this.m_vertexTrans[n6].m_data[0];
                this.yv[n2] = this.m_vertexTrans[n6].m_data[1];
                this.zv[n2] = this.m_vertexTrans[n6].m_data[2];
                this.m_origInd[n2] = n6;
                ++n2;
            }
        }
        n2 = (int)this.m_globalPolygonSize;
        if (this.m_bShowTaggedPolygons && this.m_bHasTaggedPolygons && this.m_polygon[n4].hasTag(1)) {
            n2 = (int)(2.0 * this.m_globalPolygonSize);
            color = this.m_globalPolygonTagColor;
        } else if (this.m_bShowPolygons) {
            if (this.m_bShowEdgeAura) {
                this.m_bDepthcueEdge = false;
                this.drawLine(graphics, Math.max(6, 2 * (int)this.m_globalPolygonSize), this.xv[0], this.yv[0], this.zv[0] - 30, this.xv[1], this.yv[1], this.zv[1] - 30, this.m_backColor);
            }
            color = this.m_bShowPolygonColors && this.m_polygonColor != null ? this.m_polygonColor[n4] : this.m_globalPolygonColor;
            if (this.m_bShowDepthcue && !this.m_bEnableZBuffer) {
                color = PdColor.getDimmedColor(color, this.m_heightFac, this.m_grey * (1.0 - this.m_heightFac));
            }
        } else {
            return;
        }
        this.m_bDepthcueEdge = true;
        this.drawLine(graphics, n2, this.xv[0], this.yv[0], this.zv[0], this.xv[1], this.yv[1], this.zv[1], color);
        if (this.m_bShowPolygonEndArrow && bl) {
            this.drawVectorTip(graphics, n2, this.xv[0], this.yv[0], this.zv[0], this.xv[1], this.yv[1], this.zv[1], false, color);
        }
        if (this.m_bShowPolygonStartArrow && n3 != 0) {
            this.drawVectorTip(graphics, n2, this.xv[1], this.yv[1], this.zv[1], this.xv[0], this.yv[0], this.zv[0], false, color);
        }
        if ((this.m_bShowIndices || this.m_bShowPolygonLabels) && (this.m_bShowPolygons || this.m_bShowTaggedPolygons && this.m_bHasTaggedPolygons)) {
            String string = this.m_polygon[n4].getName();
            if (string == null && this.m_bDefaultLabelEnabled) {
                string = String.valueOf(n4) + "," + String.valueOf(n);
            }
            int[] nArray = this.m_labelAttribute[2].m_data;
            this.drawString(graphics, string, (this.xv[0] + this.xv[1]) / 2, (this.yv[0] + this.yv[1]) / 2, n2, nArray);
        }
    }

    private void drawPolygon(Graphics graphics, int n, int[] nArray, int[] nArray2, int[] nArray3, int n2, Color color) {
        if (this.m_bEnableZBuffer) {
            if (n < 3) {
                this.drawPolygonZBuffer(graphics, n, nArray, nArray2, nArray3, n2, color);
                return;
            }
            this.drawPolygonZBuffer(graphics, n, nArray, nArray2, nArray3, n2, color);
            return;
        }
        graphics.setColor(color);
        if (n < 3) {
            graphics.drawPolygon(nArray, nArray2, n2);
            return;
        }
        PvThickGraphics.drawPolygon(graphics, n, nArray, nArray2, n2);
    }

    public boolean setLabelAttributes(PiVector[] piVectorArray) {
        PiVector.copy(this.m_labelAttribute, 0, piVectorArray, 0, piVectorArray.length);
        return true;
    }

    public PdVector[] getBounds() {
        if (this.m_numVertices == 0) {
            return null;
        }
        PdVector.min(this.m_bndBox[0], this.m_vertex, this.m_numVertices);
        PdVector.max(this.m_bndBox[1], this.m_vertex, this.m_numVertices);
        int n = this.m_dimTrans - 1;
        while (n >= this.m_dim) {
            this.m_bndBox[0].setEntry(n, 0.0);
            this.m_bndBox[1].setEntry(n, 0.0);
            --n;
        }
        return this.m_bndBox;
    }

    protected void projectVertexNormals(PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        if (this.m_numVertices == 0 || this.m_vertexNormal == null || this.m_vertexNormal.length < this.m_numVertices) {
            this.m_bShowVertexNormals = false;
            return;
        }
        int n = 0;
        while (n < this.m_numVertices) {
            int n2 = 0;
            while (n2 < this.m_dim) {
                this.m_vt.m_data[n2] = this.m_vertex[n].m_data[n2] + this.m_globalVertexNormalLength * this.m_vertexNormal[n].m_data[n2];
                ++n2;
            }
            this.project(this.m_vertexNormalTrans[n], this.m_vt, pdMatrix, pdMatrix2);
            ++n;
        }
    }

    protected void projectElementNormals(PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        if (this.m_numElements == 0 || this.m_elementNormal == null || this.m_elementNormal.length < this.m_numElements) {
            this.m_bShowElementNormals = false;
            return;
        }
        int n = 0;
        while (n < this.m_numElements) {
            this.getElementCenter(this.m_elemCenter, this.m_element[n], this.m_vertex, this.m_dim);
            int n2 = 0;
            while (n2 < this.m_dim) {
                this.m_vt.m_data[n2] = this.m_elemCenter[n2] + this.m_globalElementNormalLength * this.m_elementNormal[n].m_data[n2];
                ++n2;
            }
            this.project(this.m_elementNormalTrans[n], this.m_vt, pdMatrix, pdMatrix2);
            if (this.m_bShowOutline || !this.m_bShowBackface || this.m_bShowElementBackColor || this.m_bShowElementBackColors || this.m_bShowEdgeAura) {
                n2 = this.m_element[n].m_data.length;
                if (this.m_dim >= 3) {
                    double d = this.m_vertexTrans[this.m_element[n].m_data[0]].m_data[2];
                    int n3 = 1;
                    while (n3 < n2) {
                        d += (double)this.m_vertexTrans[this.m_element[n].m_data[n3]].m_data[2];
                        ++n3;
                    }
                    if (this.m_elementNormalTrans[n].m_data[2] - (int)(d / (double)n2) < 0) {
                        this.m_elementNormalTrans[n].setTag(14);
                    } else {
                        this.m_elementNormalTrans[n].clearTag(14);
                    }
                }
            }
            ++n;
        }
    }

    private void drawElementTexture_(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int n3, int[] nArray4, int n4, int n5, PdVector[] pdVectorArray, int[][] nArray5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11 = 0;
        int n12 = nArray2[0];
        int n13 = 1;
        while (n13 < n) {
            if (nArray2[n13] < n12 || nArray2[n13] == n12 && nArray2[(n13 + 1) % n] > nArray2[n13]) {
                n12 = nArray2[n13];
                n11 = n13;
            }
            ++n13;
        }
        int n14 = nArray[(n11 + 1) % n];
        int n15 = nArray2[(n11 - 1 + n) % n];
        int n16 = nArray2[n11];
        int n17 = nArray[(n11 - 1 + n) % n];
        int n18 = nArray2[(n11 + 1) % n];
        int n19 = nArray[n11];
        boolean bl = n14 * (n15 - n16) + n17 * (n16 - n18) - (n15 - n18) * n19 < 0;
        int n20 = 0;
        int n21 = 0;
        while (n21 < n) {
            n13 = (n11 + n21) % n;
            int n22 = (n13 + 1) % n;
            if (bl) {
                n10 = nArray[n22] >= nArray[n13] ? 0 : 1;
                n9 = nArray[n22] <= nArray[n13] ? 0 : 1;
            } else {
                n10 = nArray[n22] <= nArray[n13] ? 0 : 1;
                n9 = nArray[n22] >= nArray[n13] ? 0 : 1;
            }
            n8 = nArray[n22] - nArray[n13];
            n7 = nArray2[n22] - nArray2[n13];
            n6 = Math.abs(n8) < Math.abs(n7) ? (bl && n8 < 0 || !bl && n8 > 0 ? (bl && n7 < 0 || !bl && n7 > 0 ? NEE : NWW) : (bl && n7 > 0 || !bl && n7 < 0 ? SWW : SEE)) : (bl && n8 < 0 || !bl && n8 > 0 ? (bl && n7 < 0 || !bl && n7 > 0 ? NNE : NNW) : (bl && n7 > 0 || !bl && n7 < 0 ? SSW : SSE));
            n20 = this.discretizeBndEdge(nArray[n13], nArray2[n13], nArray3[n13], nArray[n22], nArray2[n22], nArray3[n22], pdVectorArray[n13], pdVectorArray[n22], this.m_faceDestBnd, this.m_faceTextureBnd, n20, this.m_bShowCurrEdge, n10 != 0, n9 != 0, bl, n6, nArray4, n4, n2, n3);
            ++n21;
        }
        if (n20 == 0) {
            return;
        }
        int n23 = (int)((double)(n20 + 2) / 2.0);
        n10 = -1;
        int n24 = 0;
        int n25 = 0;
        if (this.m_faceDestBnd[n20 - 1].m_data[1] == this.m_faceDestBnd[0].m_data[1] && this.m_faceDestBnd[n20 - 1].m_data[1] == this.m_faceDestBnd[n20 - 2].m_data[1] && Math.abs(this.m_faceDestBnd[n20 - 1].m_data[0] - this.m_faceDestBnd[0].m_data[0]) <= Math.abs(this.m_faceDestBnd[n20 - 2].m_data[0] - this.m_faceDestBnd[0].m_data[0])) {
            --n20;
        }
        if (this.m_faceDestBnd[n20 - 1].m_data[1] == this.m_faceDestBnd[0].m_data[1]) {
            n25 = n20 - 1;
        }
        if (this.m_faceDestBnd[0].m_data[1] == this.m_faceDestBnd[1].m_data[1]) {
            if (this.m_faceDestBnd[n20 - 1].m_data[1] == this.m_faceDestBnd[0].m_data[1]) {
                if (Math.abs(this.m_faceDestBnd[n20 - 1].m_data[0] - this.m_faceDestBnd[0].m_data[0]) <= Math.abs(this.m_faceDestBnd[n20 - 1].m_data[0] - this.m_faceDestBnd[1].m_data[0])) {
                    n24 = 1;
                }
            } else {
                n24 = 1;
            }
        }
        n13 = 0;
        while (n13 < n23) {
            int n26 = 0;
            int n27 = 0;
            n21 = this.m_faceDestBnd[n24].m_data[0] - n2;
            if (!this.m_bShowCurrEdge) {
                n27 = this.m_faceDestBnd[n24].m_data[3];
            }
            if (n21 >= n4) {
                n21 = n4 - 1;
            }
            if (n21 < 0) {
                n21 = 0;
            }
            if (this.m_faceDestBnd[n24].m_data[1] - n3 <= n10) {
                ++n24;
            } else {
                n10 = this.m_faceDestBnd[n24].m_data[1] - n3;
                if (n10 < 0 || n10 >= n5) break;
                n9 = this.m_faceDestBnd[n24].m_data[2];
                if (this.m_faceDestBnd[n25].m_data[1] - n3 < n10) {
                    --n25;
                }
                if (n25 < 0) break;
                n6 = this.m_faceDestBnd[n25].m_data[0] - n2;
                if (!this.m_bShowCurrEdge) {
                    n26 = this.m_faceDestBnd[n25].m_data[3];
                }
                if (n6 >= n4) {
                    n6 = n4 - 1;
                }
                if (n6 < 0) {
                    n6 = 0;
                }
                n8 = n10;
                n8 = this.m_faceDestBnd[n25].m_data[1] - n3;
                n7 = this.m_faceDestBnd[n25].m_data[2];
                if (n8 < 0 || n8 >= n5 || n8 + n3 < 0 || n8 + n3 >= this.m_dispSize.height) break;
                this.drawScanLine(nArray4, n4, n21, n10, n9, n6, n8, n7, this.m_faceTextureBnd[n24].m_data, this.m_faceTextureBnd[n25].m_data, nArray5, n2, n3, n27, n26);
                ++n24;
                n25 = n25 == 0 ? n20 - 1 : --n25;
            }
            ++n13;
        }
    }

    public void assureVertexNormals() {
        super.assureVertexNormals();
        if (this.m_vertexNormalTrans == null || this.m_vertexNormalTrans.length != this.m_maxNumVertices) {
            this.m_vertexNormalTrans = PiVector.realloc(this.m_vertexNormalTrans, this.m_maxNumVertices, this.m_dimTrans);
        }
    }

    public void assureElementNormals() {
        super.assureElementNormals();
        if (this.m_elementNormalTrans == null || this.m_elementNormalTrans.length != this.m_maxNumElements) {
            this.m_elementNormalTrans = PiVector.realloc(this.m_elementNormalTrans, this.m_maxNumElements, this.m_dimTrans);
        }
    }

    public int[] removePolygon(int n) {
        if (n < 0 || n > this.m_numPolygons - 1) {
            PsDebug.error("index=" + n + " out of range", this);
            return null;
        }
        this.m_polygon[n].setTag(2);
        return null;
    }

    public void setTagPolygon(int n, int n2) {
        this.m_polygon[n].setTag(n2);
        this.m_geometry.setTagPolygon(n, n2);
    }

    private int clipPolygon(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n3 = 0;
        int n4 = 0;
        double d7 = 0.0;
        int n5 = 0;
        do {
            int n6 = this.m_polygon[n].m_data[n2 + n5];
            if ((double)this.m_vertexTrans[n6].m_data[2] < this.m_clipFar || (double)this.m_vertexTrans[n6].m_data[2] > this.m_clipNear) {
                this.m_elemIsClipped = true;
                d4 = this.m_vertexTrans[n6].m_data[0];
                d5 = this.m_vertexTrans[n6].m_data[1];
                d6 = this.m_vertexTrans[n6].m_data[2];
                if (n4 == 1) {
                    d7 = d6 < this.m_clipFar ? (d3 - this.m_clipFar) / (d3 - d6) : (d3 - this.m_clipNear) / (d3 - d6);
                    nArray[n3] = (int)((1.0 - d7) * d + d7 * d4);
                    nArray2[n3] = (int)((1.0 - d7) * d2 + d7 * d5);
                    nArray3[n3] = (int)((1.0 - d7) * d3 + d7 * d6);
                    nArray4[n3] = -1;
                    ++n3;
                }
                n4 = -1;
                continue;
            }
            d = this.m_vertexTrans[n6].m_data[0];
            d2 = this.m_vertexTrans[n6].m_data[1];
            d3 = this.m_vertexTrans[n6].m_data[2];
            if (n4 == -1) {
                d7 = d6 < this.m_clipFar ? (d3 - this.m_clipFar) / (d3 - d6) : (d3 - this.m_clipNear) / (d3 - d6);
                nArray[n3] = (int)((1.0 - d7) * d + d7 * d4);
                nArray2[n3] = (int)((1.0 - d7) * d2 + d7 * d5);
                nArray3[n3] = (int)((1.0 - d7) * d3 + d7 * d6);
                nArray4[n3] = -1;
                ++n3;
            }
            nArray[n3] = this.m_vertexTrans[n6].m_data[0];
            nArray2[n3] = this.m_vertexTrans[n6].m_data[1];
            nArray3[n3] = this.m_vertexTrans[n6].m_data[2];
            nArray4[n3] = n6;
            ++n3;
            n4 = 1;
        } while (++n5 < 2);
        return n3;
    }

    public PvGeometry(int n) {
        super(n);
        this.m_dim = n < 3 ? 3 : n;
        this.m_dimTrans = 3;
        this.m_dimOfColors = 3;
        this.m_bShowBackface = true;
        this.m_bShowDepthcue = true;
        this.m_bShowEdgeOnce = true;
        this.m_clipFar = Double.NEGATIVE_INFINITY;
        this.m_clipNear = Double.POSITIVE_INFINITY;
        this.m_vt = new PdVector(4);
        this.init();
    }

    public int[] removeElement(int n) {
        if (n < 0 || n > this.m_numElements - 1) {
            PsDebug.error("index=" + n + " out of range", this);
            return null;
        }
        this.m_element[n].setTag(2);
        return null;
    }

    public boolean setVertexColor(int n, Color color) {
        if (n < 0 || n > this.m_numVertices - 1) {
            PsDebug.error("index=" + n + " out of range", this);
            return false;
        }
        if (color == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        this.assureVertexColors();
        this.m_vertexColor[n] = color;
        return true;
    }

    public boolean setElementColor(int n, Color color) {
        if (n < 0 || n > this.m_numElements - 1) {
            PsDebug.error("index=" + n + " out of range", this);
            return false;
        }
        if (color == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        this.assureElementColors();
        this.m_elementColor[n] = color;
        return true;
    }

    public boolean setVertexTag(int n, int n2) {
        if (n < 0 || n > this.m_numVertices - 1) {
            PsDebug.error("index=" + n + " out of range", this);
            return false;
        }
        if (n2 < 0 || n2 >= 32) {
            PsDebug.warning("tag=" + n2 + " out of range", this);
            return false;
        }
        this.m_vertex[n].setTag(n2);
        return true;
    }

    public boolean setElementTag(int n, int n2) {
        if (n < 0 || n > this.m_numElements - 1) {
            PsDebug.error("index=" + n + " out of range", this);
            return false;
        }
        if (n2 < 0 || n2 >= 32) {
            PsDebug.warning("tag=" + n2 + " out of range", this);
            return false;
        }
        this.m_element[n].setTag(n2);
        return true;
    }

    public void setTransparency(double d) {
        if (Math.abs(1.0 - d) < 0.02) {
            this.m_alpha = 0;
            return;
        }
        if (Math.abs(d) < 0.02) {
            this.m_alpha = -16777216;
            return;
        }
        this.m_alpha = (255 - (int)(255.0 * d) & 0xFF) << 24;
    }

    public int setVectorField(Object object) {
        int n = this.getNumVectorFields();
        if (object == null) {
            this.setNumVectorFields(0);
            return 0;
        }
        this.setNumVectorFields(n + 1);
        return this.m_numVectorFields;
    }

    public void showVectorField(int n, boolean bl) {
        super.showVectorField(n, bl);
        if (bl) {
            this.m_bShowVectors = bl;
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.m_geometry != null && this.m_geometry.isVisible() != bl) {
            this.m_geometry.setVisible(bl);
        }
    }

    public void clearTagVertex(int n, int n2) {
        this.m_vertex[n].clearTag(n2);
        this.m_geometry.clearTagVertex(n, n2);
    }

    public void setGlobalVertexNormalSize(double d) {
        this.m_globalVertexNormalSize = d;
        if (this.m_globalVertexNormalSize > 1.0) {
            this.m_globalVertexNormalSize = 2.0 * d - 1.0;
        }
    }

    public void setGlobalEdgeSize(double d) {
        this.m_globalEdgeSize = d;
        if (this.m_globalEdgeSize > 1.0) {
            this.m_globalEdgeSize = 2.0 * d - 1.0;
        }
    }

    public void setGlobalElementNormalSize(double d) {
        this.m_globalElementNormalSize = d;
        if (this.m_globalElementNormalSize > 1.0) {
            this.m_globalElementNormalSize = 2.0 * d - 1.0;
        }
    }

    public void setTagElement(int n, int n2) {
        this.m_element[n].setTag(n2);
        this.m_geometry.setTagElement(n, n2);
    }

    private void drawVertex(Graphics graphics, int n) {
        Object object;
        int n2;
        Color color;
        if (this.m_vertex[n].hasTag(2)) {
            return;
        }
        if (this.m_bEnableClip && ((double)this.m_vertexTrans[n].m_data[2] < this.m_clipFar || (double)this.m_vertexTrans[n].m_data[2] > this.m_clipNear)) {
            return;
        }
        if (this.m_bShowVertexNormals) {
            color = this.m_bShowDepthcue && !this.m_bEnableZBuffer ? PdColor.getDimmedColor(this.m_globalVertexNormalColor, this.m_heightFac) : this.m_globalVertexNormalColor;
            this.drawVector_(graphics, (int)this.m_globalVertexNormalSize, this.m_vertexTrans[n].m_data[0], this.m_vertexTrans[n].m_data[1], this.m_vertexTrans[n].m_data[2], this.m_vertexNormalTrans[n].m_data[0], this.m_vertexNormalTrans[n].m_data[1], this.m_vertexNormalTrans[n].m_data[2], this.m_bShowVertexNormalArrow, color);
        }
        if (this.m_bShowVectors) {
            n2 = 0;
            while (n2 < this.m_numVectorFields) {
                if (this.m_bShowVectorField[n2] && !this.m_vectorIsElementBased[n2]) {
                    color = this.m_globalVectorColor[n2];
                    if (this.m_bShowVectorColors[n2]) {
                        color = this.m_vectorColor[n2][n];
                    }
                    this.drawVector_(graphics, (int)this.m_globalVectorSize[n2], this.m_vertexTrans[n].m_data[0], this.m_vertexTrans[n].m_data[1], this.m_vertexTrans[n].m_data[2], this.m_vectorTrans[n2][n].m_data[0], this.m_vectorTrans[n2][n].m_data[1], this.m_vectorTrans[n2][n].m_data[2], this.m_bShowVectorArrow[n2], color);
                }
                ++n2;
            }
        }
        n2 = (int)this.m_globalVertexSize;
        if (this.m_bShowTaggedVertices && this.m_bHasTaggedVertices && this.m_vertex[n].hasTag(1)) {
            n2 = (int)(2.0 * this.m_globalVertexSize);
            color = this.m_globalVertexTagColor;
        } else if (this.m_bShowVertices) {
            color = this.m_bShowVertexColors && this.m_vertexColor != null ? this.m_vertexColor[n] : this.m_globalVertexColor;
            if (this.m_bShowDepthcue) {
                color = PdColor.getDimmedColor(color, this.m_heightFac);
            }
        } else {
            return;
        }
        int n3 = n2 * PS_ZOOM;
        int n4 = this.m_vertexTrans[n].m_data[0];
        int n5 = this.m_vertexTrans[n].m_data[1];
        boolean bl = true;
        if (this.m_bEnableZBuffer) {
            object = ((PvDisplay)this.m_display).getZBuffer();
            if (n5 >= 0 && n5 < ((int[][])object).length && n4 >= 0 && n4 < object[0].length && object[n5][n4] > this.m_vertexTrans[n].m_data[2] + 50) {
                bl = false;
            }
        }
        if (bl && n3 > 0) {
            graphics.setColor(color);
            graphics.fillOval(n4 - n3, n5 - n3, 2 * n3, 2 * n3);
            graphics.setColor(Color.black);
            graphics.drawOval(n4 - n3, n5 - n3, 2 * n3, 2 * n3);
        } else {
            graphics.setColor(Color.black);
        }
        if (this.m_bShowIndices || this.m_bShowVertexLabels) {
            object = this.m_vertex[n].getName();
            if (object == null && this.m_bDefaultLabelEnabled) {
                object = String.valueOf(n);
            }
            int[] nArray = this.m_labelAttribute[0].m_data;
            this.drawString(graphics, (String)object, n4, n5, n2, nArray);
        }
    }

    private int clipElement(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, PdVector[] pdVectorArray, PdVector[] pdVectorArray2) {
        int n3 = -2;
        int n4 = -1;
        int n5 = 1;
        double[] dArray = null;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n2) {
            block23: {
                int n8;
                int n9;
                int[] nArray5;
                int[] nArray6;
                int n10;
                int n11;
                block24: {
                    n11 = n7;
                    n10 = (n7 + 1) % n2;
                    int n12 = this.m_element[n].m_data[n11];
                    int n13 = this.m_element[n].m_data[n10];
                    nArray6 = this.m_vertexTrans[n12].m_data;
                    nArray5 = this.m_vertexTrans[n13].m_data;
                    n9 = n5;
                    n8 = n5;
                    if ((double)nArray6[2] < this.m_clipFar) {
                        n9 = n3;
                    }
                    if ((double)nArray6[2] > this.m_clipNear) {
                        n9 = n4;
                    }
                    if ((double)nArray5[2] < this.m_clipFar) {
                        n8 = n3;
                    }
                    if ((double)nArray5[2] > this.m_clipNear) {
                        n8 = n4;
                    }
                    if (n9 != n5 || n8 != n5) {
                        this.m_elemIsClipped = true;
                    }
                    if (n9 == n3 && n8 == n3 || n9 == n4 && n8 == n4) break block23;
                    if (n9 != n5) break block24;
                    if (n7 < n2) {
                        nArray[n6] = nArray6[0];
                        nArray2[n6] = nArray6[1];
                        nArray3[n6] = nArray6[2];
                        if (pdVectorArray2 != null) {
                            pdVectorArray[n6].copyArray(pdVectorArray2[n7]);
                        }
                        nArray4[n6] = n12;
                        ++n6;
                    }
                    if (n8 == n5) break block23;
                }
                if (dArray == null) {
                    dArray = new double[2];
                }
                double d = nArray6[0];
                double d2 = nArray6[1];
                double d3 = nArray6[2];
                double d4 = nArray5[0];
                double d5 = nArray5[1];
                double d6 = nArray5[2];
                PdVector pdVector = null;
                PdVector pdVector2 = null;
                if (pdVectorArray2 != null) {
                    pdVector = pdVectorArray2[n11];
                    pdVector2 = pdVectorArray2[n10];
                }
                int n14 = 1;
                if (n9 == n5 && n8 == n3 || n9 == n3 && n8 == n5) {
                    dArray[0] = (d3 - this.m_clipFar) / (d3 - d6);
                } else if (n9 == n5 && n8 == n4 || n9 == n4 && n8 == n5) {
                    dArray[0] = (d3 - this.m_clipNear) / (d3 - d6);
                } else if (n9 == n3 && n8 == n4) {
                    dArray[0] = (d3 - this.m_clipFar) / (d3 - d6);
                    dArray[1] = (d3 - this.m_clipNear) / (d3 - d6);
                    n14 = 2;
                } else if (n9 == n4 && n8 == n3) {
                    dArray[0] = (d3 - this.m_clipNear) / (d3 - d6);
                    dArray[1] = (d3 - this.m_clipFar) / (d3 - d6);
                    n14 = 2;
                }
                int n15 = 0;
                while (n15 < n14) {
                    nArray[n6] = (int)((1.0 - dArray[n15]) * d + dArray[n15] * d4);
                    nArray2[n6] = (int)((1.0 - dArray[n15]) * d2 + dArray[n15] * d5);
                    nArray3[n6] = (int)((1.0 - dArray[n15]) * d3 + dArray[n15] * d6);
                    if (pdVectorArray2 != null) {
                        pdVectorArray[n6].m_data[0] = (1.0 - dArray[n15]) * pdVector.m_data[0] + dArray[n15] * pdVector2.m_data[0];
                        pdVectorArray[n6].m_data[1] = (1.0 - dArray[n15]) * pdVector.m_data[1] + dArray[n15] * pdVector2.m_data[1];
                        if (pdVector.m_data.length > 2) {
                            pdVectorArray[n6].m_data[2] = (1.0 - dArray[n15]) * pdVector.m_data[2] + dArray[n15] * pdVector2.m_data[2];
                        }
                    }
                    nArray4[n6] = -1;
                    ++n6;
                    ++n15;
                }
            }
            ++n7;
        }
        n2 = n6;
        return n2;
    }

    protected boolean removeGeometryVertex(int n) {
        this.removeVertex(n);
        this.m_geometry.removeVertex(n);
        return true;
    }

    protected int addGeometryElement(PiVector piVector) {
        this.addElement(piVector);
        return this.m_geometry.addElement(piVector);
    }

    public boolean setVertexNormal(int n, PdVector pdVector) {
        if (n < 0 || n > this.m_numVertices - 1) {
            PsDebug.error("index=" + n + " out of range", this);
            return false;
        }
        if (pdVector == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        this.assureVertexNormals();
        this.m_vertexNormal[n].copy(pdVector);
        return true;
    }

    public boolean setElementNormal(int n, PdVector pdVector) {
        if (n < 0 || n > this.m_numElements - 1) {
            PsDebug.error("index=" + n + " out of range", this);
            return false;
        }
        if (pdVector == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        this.assureElementNormals();
        this.m_elementNormal[n].copy(pdVector);
        return true;
    }

    private void drawElementNormal(Graphics graphics, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3) {
        this.getElementCenter(this.m_elemCenter, this.m_element[n], this.m_vertexTrans, 3);
        Color color = this.m_bShowDepthcue ? PdColor.getDimmedColor(this.m_globalElementNormalColor, this.m_heightFac) : this.m_globalElementNormalColor;
        this.drawVector_(graphics, (int)this.m_globalElementNormalSize, (int)this.m_elemCenter[0], (int)this.m_elemCenter[1], (int)this.m_elemCenter[2], this.m_elementNormalTrans[n].m_data[0], this.m_elementNormalTrans[n].m_data[1], this.m_elementNormalTrans[n].m_data[2], this.m_bShowElementNormalArrow, color);
    }

    private void writePixel(int n, int n2, int[] nArray, int n3, int n4, int n5, int[][] nArray2, int n6, double d) {
        if (n2 < 0 || n2 >= nArray2.length - 1 || n < 0 || n >= nArray2[0].length) {
            return;
        }
        if ((int)d < nArray2[n2][n]) {
            return;
        }
        int n7 = n6;
        if (this.m_bShowDepthcue && this.m_bDepthcueEdge) {
            double d2 = this.m_heightFac;
            if (!this.m_bUse_m_heightFac) {
                double d3 = PvScene.m_zMin;
                double d4 = PvScene.m_zMax;
                double d5 = 1.0;
                if (d4 - d3 != 0.0) {
                    d5 = d4 - d3;
                }
                d2 = (d - d3) / d5;
            }
            int n8 = (int)((double)(n7 >> 16 & 0xFF) * d2);
            int n9 = (int)((double)(n7 >> 8 & 0xFF) * d2);
            int n10 = (int)((double)(n7 & 0xFF) * d2);
            int n11 = (int)(this.m_grey * (1.0 - d2));
            n7 = (n8 += n11) << 16 | (n9 += n11) << 8 | (n10 += n11);
        }
        nArray[(n2 - n5) * n3 + (n - n4)] = n7 = this.m_alpha | n7;
        nArray2[n2][n] = (int)d;
    }

    private void drawLine_(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray, int n7, int n8, int n9, int[][] nArray2, Color color) {
        int n10 = color.getRGB();
        int n11 = n4 - n;
        int n12 = n5 - n2;
        double d = n6 - n3;
        int n13 = n;
        int n14 = n2;
        double d2 = n3;
        int n15 = 1;
        int n16 = 1;
        if (n11 < 0) {
            n11 = -n11;
            n15 = -1;
        }
        if (n12 < 0) {
            n12 = -n12;
            n16 = -1;
        }
        if (Math.abs(n11) >= Math.abs(n12)) {
            d /= (double)Math.abs(n11);
            int n17 = 2 * n12 - n11;
            int n18 = 2 * n12;
            int n19 = 2 * (n12 - n11);
            while (n13 != n4) {
                this.writePixel(n13, n14, nArray, n7, n8, n9, nArray2, n10, d2);
                n13 += n15;
                d2 += d;
                if (n17 <= 0) {
                    n17 += n18;
                    continue;
                }
                n17 += n19;
                n14 += n16;
            }
            return;
        }
        d /= (double)Math.abs(n12);
        int n20 = 2 * n11 - n12;
        int n21 = 2 * n11;
        int n22 = 2 * (n11 - n12);
        while (n14 != n5) {
            this.writePixel(n13, n14, nArray, n7, n8, n9, nArray2, n10, d2);
            n14 += n16;
            d2 += d;
            if (n20 <= 0) {
                n20 += n21;
                continue;
            }
            n20 += n22;
            n13 += n15;
        }
    }

    public int[] removeVertex(int n) {
        if (n < 0 || n > this.m_numVertices - 1) {
            PsDebug.error("index=" + n + " out of range", this);
            return null;
        }
        this.m_vertex[n].setTag(2);
        return null;
    }

    public void setTagVertex(int n, int n2) {
        this.m_vertex[n].setTag(n2);
        this.m_geometry.setTagVertex(n, n2);
    }

    private boolean drawLine_(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray, int n8, int n9, int n10, int[][] nArray2, Color color) {
        if (n == 1) {
            return false;
        }
        double d = (double)n / 2.0;
        double d2 = n5 - n2;
        double d3 = n3 - n6;
        double d4 = n2 == n5 ? 0.0 : Math.atan(d3 / d2) - 1.5707963267948966;
        int n11 = (int)(d * Math.cos(d4));
        int n12 = (int)(d * Math.sin(d4));
        int[] nArray3 = new int[]{n2 + n11, n5 + n11, n5 - n11, n2 - n11};
        int[] nArray4 = new int[]{n3 - n12, n6 - n12, n6 + n12, n3 + n12};
        int[] nArray5 = new int[]{n4, n7, n7, n4};
        double d5 = PvScene.m_zMin;
        double d6 = PvScene.m_zMax;
        double d7 = 1.0;
        if (d6 - d5 != 0.0) {
            d7 = d6 - d5;
        }
        int n13 = 4;
        PdVector[] pdVectorArray = PdVector.realloc(null, n13, 3);
        int n14 = 0;
        while (n14 < n13) {
            pdVectorArray[n14].m_data[0] = (double)this.m_textureWidth - 1.0;
            pdVectorArray[n14].m_data[1] = (double)this.m_textureHeight - 1.0;
            pdVectorArray[n14].setEntry(2, ((double)nArray5[n14] - d5) / d7);
            ++n14;
        }
        this.drawElementZBuffer(graphics, nArray3, nArray4, nArray5, n13, color, pdVectorArray);
        return true;
    }

    protected int addGeometryVertex(PdVector pdVector) {
        this.addVertex(pdVector);
        return this.m_geometry.addVertex(pdVector);
    }

    public void setModelMatrix(PdMatrix pdMatrix) {
        super.setModelMatrix(pdMatrix);
        if (this.m_geometry != null) {
            this.m_geometry.setModelMatrix(pdMatrix);
        }
    }

    public void setAmbientMatrix(PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        super.setAmbientMatrix(pdMatrix, pdMatrix2);
        if (this.m_geometry != null) {
            this.m_geometry.setAmbientMatrix(pdMatrix, pdMatrix2);
        }
    }

    public void setPolygons(PiVector[] piVectorArray) {
        super.setPolygons(piVectorArray);
        this.computeNumPolygonEdges();
    }

    public void setGlobalPolygonNormalSize(double d) {
        this.m_globalPolygonNormalSize = d;
        if (this.m_globalPolygonNormalSize > 1.0) {
            this.m_globalPolygonNormalSize = 2.0 * d - 1.0;
        }
    }

    public void setGlobalPolygonSize(double d) {
        this.m_globalPolygonSize = (int)d;
        if (this.m_globalPolygonSize > 1.0) {
            this.m_globalPolygonSize = 2.0 * d - 1.0;
        }
    }

    private boolean drawElementZBuffer(Graphics graphics, int[] nArray, int[] nArray2, int[] nArray3, int n, Color color, PdVector[] pdVectorArray) {
        if (color != null) {
            this.m_currElementCol = this.m_alpha | color.getRGB();
        }
        int n2 = -1;
        if (!this.m_bNewZBuffer && (n2 = this.assureMIS(nArray, nArray2, n)) == MIS_IMAGE_OUTSIDE) {
            return false;
        }
        this.drawElementTexture_(nArray, nArray2, nArray3, n, this.m_elemMin[0], this.m_elemMin[1], this.m_pix.m_data, this.imgWidth, this.m_elemHeight, pdVectorArray, ((PvDisplay)this.m_display).getZBuffer());
        if (!this.m_bNewZBuffer) {
            this.drawMIS(graphics, n2);
        }
        return true;
    }

    private boolean drawLineZBuffer(Graphics graphics, int[] nArray, int[] nArray2, int[] nArray3, int n, Color color) {
        if (color != null) {
            this.m_currElementCol = this.m_alpha | color.getRGB();
        }
        int n2 = -1;
        if (!this.m_bNewZBuffer && (n2 = this.assureMIS(nArray, nArray2, n)) == MIS_IMAGE_OUTSIDE) {
            return false;
        }
        this.drawLine_(nArray[0], nArray2[0], nArray3[0], nArray[1], nArray2[1], nArray3[1], this.m_pix.m_data, this.imgWidth, this.m_elemMin[0], this.m_elemMin[1], ((PvDisplay)this.m_display).getZBuffer(), color);
        if (!this.m_bNewZBuffer) {
            this.drawMIS(graphics, n2);
        }
        return true;
    }

    private boolean drawLineZBuffer(Graphics graphics, int n, int[] nArray, int[] nArray2, int[] nArray3, int n2, Color color) {
        this.drawLine_(graphics, n, nArray[0], nArray2[0], nArray3[0], nArray[1], nArray2[1], nArray3[1], this.m_pix.m_data, this.imgWidth, this.m_elemMin[0], this.m_elemMin[1], ((PvDisplay)this.m_display).getZBuffer(), color);
        return true;
    }

    protected int updateUnusedVertices() {
        int n;
        int n2 = -1;
        this.m_unusedVertex.setSize(this.m_numVertices);
        this.m_unusedVertex.setConstant(0);
        int[] nArray = this.m_unusedVertex.m_data;
        int n3 = 0;
        while (n3 < this.m_numElements) {
            n = this.m_element[n3].m_data.length - 1;
            while (n >= 0) {
                nArray[this.m_element[n3].m_data[n]] = n2;
                --n;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.m_numPolygons) {
            n = this.m_polygon[n3].m_data.length - 1;
            while (n >= 0) {
                nArray[this.m_polygon[n3].m_data[n]] = n2;
                --n;
            }
            ++n3;
        }
        int n4 = 0;
        n3 = 0;
        while (n3 < this.m_numVertices) {
            if (nArray[n3] != n2) {
                nArray[n4++] = n3;
            }
            ++n3;
        }
        this.m_numUnusedVertices = n4;
        return this.m_numUnusedVertices;
    }

    public void setStateFromDisplay(int n, boolean bl) {
        if (this.m_geometry == null) {
            return;
        }
        switch (n) {
            default: {
                PsDebug.warning("invalid key = " + n);
            }
            case 50: 
        }
        this.setState(n, bl);
        this.m_geometry.setState(n, bl);
    }

    private void drawScanLine(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, double[] dArray, double[] dArray2, int[][] nArray2, int n8, int n9, int n10, int n11) {
        int n12;
        float f;
        float f2;
        float f3;
        float f4;
        int n13 = 0;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        int n14 = n5 - n2;
        int n15 = n8;
        int n16 = n3 + n9;
        if (n16 < 0 || n16 >= this.m_dispSize.height) {
            return;
        }
        int n17 = n3 * n;
        if (n14 >= 0) {
            n17 += n2;
            f4 = (float)dArray[0];
            f3 = (float)dArray[1];
            f2 = (float)dArray[2];
            f = (float)n4 + 0.5f;
            n15 += n2;
        } else {
            n17 += n5;
            f4 = (float)dArray2[0];
            f3 = (float)dArray2[1];
            f2 = (float)dArray2[2];
            f = (float)n7 + 0.5f;
            n15 += n5;
            n12 = n10;
            n10 = n11;
            n11 = n12;
        }
        if (n14 != 0) {
            f6 = (float)((dArray2[0] - dArray[0]) / (double)n14);
            f7 = (float)((dArray2[1] - dArray[1]) / (double)n14);
            f8 = (float)((dArray2[2] - dArray[2]) / (double)n14);
            f5 = (float)(n7 - n4) / (float)n14;
            if (n14 < 0) {
                n14 = -n14;
            }
        }
        n14 += n11;
        if (n10 > 0) {
            n12 = 0;
            while (n12 < n10) {
                ++n17;
                ++n15;
                f4 += f6;
                f3 += f7;
                f2 += f8;
                f += f5;
                --n14;
                ++n12;
            }
        }
        while (n14 >= 0) {
            if (n15 >= 0 && n15 < this.m_dispSize.width) {
                if (nArray2 != null && nArray2[n16][n15] > (int)f) {
                    if ((nArray[n17] >> 24 & 0xFF) == m_colMark) {
                        nArray[n17] = this.m_bNewZBuffer ? this.m_alpha | nArray[n17] & 0xFFFFFF : 0;
                    }
                } else {
                    if (nArray2 != null) {
                        nArray2[n16][n15] = (int)f;
                    }
                    if (this.m_bShowCurrEdge && (nArray[n17] >> 24 & 0xFF) == m_colMark) {
                        nArray[n17] = this.m_currEdgeCol;
                    } else if (this.m_bShowCurrElement) {
                        int n18;
                        n13 = this.m_texturePix != null && (this.m_bShowVertexTexture || this.m_bShowElementTexture) && !this.m_bDrawingEdge ? ((n18 = (this.m_textureHeight - (int)f3 - 1) * this.m_textureWidth + (int)f4) >= 0 && n18 < this.m_texturePix.length ? this.m_texturePix[n18] : this.m_currElementCol) : this.m_currElementCol;
                        if (this.m_bShowDepthcue && (!this.m_bDrawingEdge || this.m_bDepthcueEdge)) {
                            n12 = (int)((float)(n13 >> 16 & 0xFF) * f2);
                            int n19 = (int)((float)(n13 >> 8 & 0xFF) * f2);
                            int n20 = (int)((float)(n13 & 0xFF) * f2);
                            if (this.m_bDrawingEdge && this.m_bDepthcueEdge) {
                                n18 = (int)(this.m_grey * (1.0 - (double)f2));
                                n12 += n18;
                                n19 += n18;
                                n20 += n18;
                            }
                            n13 = n12 << 16 | n19 << 8 | n20;
                        }
                        nArray[n17] = n13 = this.m_alpha | n13;
                    } else if ((nArray[n17] >> 24 & 0xFF) == m_colMark) {
                        nArray[n17] = this.m_alpha | nArray[n17] & 0xFFFFFF;
                    }
                }
            }
            ++n17;
            ++n15;
            f4 += f6;
            f3 += f7;
            f2 += f8;
            f += f5;
            --n14;
        }
    }

    protected void clearMIS() {
        this.mis = null;
        this.imgWidth = 0;
        this.imgHeight = 0;
        this.m_destImage = null;
        this.m_elemHeight = this.m_dispSize.height;
        this.m_elemMin[0] = 0;
        this.m_elemMin[1] = 0;
        this.m_pix.m_data = null;
    }
}

