/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PuMath;
import jv.vecmath.PuReflect;
import jv.viewer.PvDisplay;

final class PvModelCamera
extends PsObject {
    private double SIZE = 10.0;
    protected PdMatrix m_ambient = new PdMatrix();
    protected PdMatrix m_ambientInv = new PdMatrix();
    protected PdMatrix m_incrAmbient = new PdMatrix();
    protected PdMatrix m_incrAmbientInv = new PdMatrix();
    protected PdMatrix m_model = new PdMatrix(4);
    protected PdMatrix m_modelInv = new PdMatrix(4);
    protected PdMatrix m_incrModel = new PdMatrix(4);
    protected PdMatrix m_incrModelInv = new PdMatrix(4);
    protected PdMatrix m_viewCamera = new PdMatrix(4);
    protected PdMatrix m_viewInvCamera = new PdMatrix(4);
    protected int m_mode;
    protected int m_transformationMode;
    protected double m_nHeight;
    protected double m_nWidth;
    protected double m_scaleTotal = 1.0;
    protected double m_scaleValue;
    protected double m_xTransValue;
    protected double m_yTransValue;
    protected double m_zTransValue;
    protected PdVector m_vecAlt = new PdVector(3);
    protected PdVector m_vec = new PdVector(3);
    protected PdVector m_rotAxis = new PdVector(3);
    protected double[] m_prevNormLoc = new double[2];
    protected double[] m_currNormLoc = new double[2];
    protected PvDisplay m_display;
    private static /* synthetic */ Class class$jv$viewer$PvModelCamera;

    protected void mouseAnimate() {
        switch (this.getTransformationMode()) {
            default: {
                PsDebug.warning("neither in model nor ambient transformation mode.");
                return;
            }
            case 1: {
                if (!this.m_display.isEnabledLocalTransform()) {
                    this.m_model.leftMult(this.m_viewCamera);
                    this.m_model.leftMult(this.m_incrModel);
                    this.m_model.leftMult(this.m_viewInvCamera);
                    this.m_modelInv.rightMult(this.m_viewInvCamera);
                    this.m_modelInv.rightMult(this.m_incrModelInv);
                    this.m_modelInv.rightMult(this.m_viewCamera);
                    return;
                }
                this.m_model.rightMult(this.m_incrModel);
                this.m_modelInv.leftMult(this.m_incrModelInv);
                return;
            }
            case 2: 
        }
        this.m_ambient.rightMult(this.m_incrAmbient);
        this.m_ambientInv.leftMult(this.m_incrAmbientInv);
    }

    protected void mousePressed(int n, int n2) {
        PvDisplay.normalizedCoordsFromViewport(this.m_prevNormLoc, n, n2, (int)this.m_nWidth, (int)this.m_nHeight);
        this.m_scaleValue = Math.exp(this.m_prevNormLoc[0] + this.m_prevNormLoc[1]);
        this.m_xTransValue = this.m_prevNormLoc[0] * this.SIZE / 2.0;
        this.m_yTransValue = this.m_prevNormLoc[1] * this.SIZE / 2.0;
        this.m_zTransValue = this.m_xTransValue + this.m_yTransValue;
        this.m_vecAlt.invStereoProj(this.m_prevNormLoc[0], this.m_prevNormLoc[1]);
    }

    protected void mouseDragged(int n, int n2) {
        PvDisplay.normalizedCoordsFromViewport(this.m_currNormLoc, n, n2, (int)this.m_nWidth, (int)this.m_nHeight);
        double d = this.m_currNormLoc[0] * this.SIZE / 2.0;
        double d2 = this.m_currNormLoc[1] * this.SIZE / 2.0;
        double d3 = d + d2;
        double d4 = d - this.m_xTransValue;
        double d5 = d2 - this.m_yTransValue;
        double d6 = d3 - this.m_zTransValue;
        this.m_xTransValue = d;
        this.m_yTransValue = d2;
        this.m_zTransValue = d3;
        switch (this.m_transformationMode) {
            case 0: {
                return;
            }
            case 1: {
                this.m_incrModel.setIdentity();
                this.m_incrModelInv.setIdentity();
                if (this.m_mode == 1) {
                    double d7 = Math.exp(this.m_currNormLoc[0] + this.m_currNormLoc[1]);
                    double d8 = d7 / this.m_scaleValue;
                    this.m_scaleTotal *= d8;
                    this.m_scaleValue = d7;
                    this.m_incrModel.m_data[0][0] = d8;
                    this.m_incrModel.m_data[1][1] = d8;
                    this.m_incrModel.m_data[2][2] = d8;
                    this.m_incrModelInv.m_data[0][0] = 1.0 / d8;
                    this.m_incrModelInv.m_data[1][1] = 1.0 / d8;
                    this.m_incrModelInv.m_data[2][2] = 1.0 / d8;
                    this.m_model.rightMult(this.m_incrModel);
                    this.m_modelInv.leftMult(this.m_incrModelInv);
                    return;
                }
                if (this.m_mode == 3) {
                    this.m_incrModel.m_data[0][3] = d4;
                    this.m_incrModel.m_data[1][3] = d5;
                    this.m_incrModelInv.m_data[0][3] = -d4;
                    this.m_incrModelInv.m_data[1][3] = -d5;
                } else if (this.m_mode == 4) {
                    this.m_incrModel.m_data[2][3] = d6;
                    this.m_incrModelInv.m_data[2][3] = -d6;
                } else if (this.m_mode == 0) {
                    this.m_vec.invStereoProj(this.m_currNormLoc[0], this.m_currNormLoc[1]);
                    double d9 = Math.acos(this.m_vec.dot(this.m_vecAlt));
                    if (d9 < 1.0E-10) {
                        return;
                    }
                    this.m_rotAxis.cross(this.m_vecAlt, this.m_vec);
                    this.m_vecAlt.copy(this.m_vec);
                    if (this.m_rotAxis.length() < 1.0E-10) {
                        return;
                    }
                    if (!PuReflect.makeRotation(this.m_incrModel, this.m_rotAxis, d9)) {
                        return;
                    }
                    this.m_incrModelInv.transpose(this.m_incrModel);
                } else {
                    return;
                }
                if (!this.m_display.isEnabledLocalTransform()) {
                    this.m_model.leftMult(this.m_viewCamera);
                    this.m_model.leftMult(this.m_incrModel);
                    this.m_model.leftMult(this.m_viewInvCamera);
                    this.m_modelInv.rightMult(this.m_viewInvCamera);
                    this.m_modelInv.rightMult(this.m_incrModelInv);
                    this.m_modelInv.rightMult(this.m_viewCamera);
                    break;
                }
                this.m_model.rightMult(this.m_incrModel);
                this.m_modelInv.leftMult(this.m_incrModelInv);
                break;
            }
            case 2: {
                d4 /= this.SIZE;
                d5 /= this.SIZE;
                d6 /= this.SIZE;
                int n3 = this.m_incrAmbient.getSize() - 1;
                this.m_incrAmbient.setIdentity();
                this.m_incrAmbientInv.setIdentity();
                int n4 = this.m_display.getAmbientSpace();
                if (this.m_mode == 1) {
                    double d10 = Math.exp(this.m_currNormLoc[0] + this.m_currNormLoc[1]);
                    double d11 = d10 / this.m_scaleValue;
                    int n5 = 0;
                    while (n5 < n3) {
                        this.m_incrAmbient.m_data[n5][n5] = d11;
                        this.m_incrAmbientInv.m_data[n5][n5] = 1.0 / d11;
                        ++n5;
                    }
                    this.m_scaleTotal *= d11;
                    this.m_scaleValue = d10;
                    break;
                }
                if (this.m_mode == 3) {
                    if (n4 == 0) {
                        this.m_incrAmbient.m_data[0][n3] = d4;
                        this.m_incrAmbientInv.m_data[0][n3] = -d4;
                        break;
                    }
                    if (n4 == 1 || n4 == 3 || n4 == 6 || n4 == 9) {
                        this.m_incrAmbient.m_data[0][n3] = d4;
                        this.m_incrAmbient.m_data[1][n3] = d5;
                        this.m_incrAmbientInv.m_data[0][n3] = -d4;
                        this.m_incrAmbientInv.m_data[1][n3] = -d5;
                        break;
                    }
                    if (n4 == 2) {
                        PvModelCamera.translateSpherical(this.m_incrAmbient, 0, n3 - 1, d4 *= -Math.PI);
                        this.m_incrAmbientInv.transpose(this.m_incrAmbient);
                        break;
                    }
                    if (n4 == 4 || n4 == 7 || n4 == 10) {
                        PdMatrix pdMatrix = new PdMatrix(n3 + 1);
                        PvModelCamera.translateSpherical(pdMatrix, 0, n3 - 1, d4 *= -Math.PI);
                        PvModelCamera.translateSpherical(this.m_incrAmbient, 1, n3 - 1, d5 *= -Math.PI);
                        this.m_incrAmbient.rightMult(pdMatrix);
                        this.m_incrAmbientInv.transpose(this.m_incrAmbient);
                        break;
                    }
                    if (n4 != 5 && n4 != 8 && n4 != 11) break;
                    PdMatrix pdMatrix = new PdMatrix(n3 + 1);
                    PvModelCamera.translateHyperbolic(pdMatrix, 0, n3 - 1, d4);
                    PvModelCamera.translateHyperbolic(this.m_incrAmbient, 1, n3 - 1, d5);
                    this.m_incrAmbient.rightMult(pdMatrix);
                    this.m_incrAmbientInv.transpose(this.m_incrAmbient);
                    break;
                }
                if (this.m_mode == 4) {
                    if (n4 == 1 || n4 == 2 || n4 == 4 || n4 == 5) {
                        PvModelCamera.translateSpherical(this.m_incrAmbient, 0, 1, d6 *= -Math.PI);
                        this.m_incrAmbientInv.transpose(this.m_incrAmbient);
                        break;
                    }
                    if (n4 == 3) {
                        this.m_incrAmbient.m_data[2][n3] = d6;
                        this.m_incrAmbientInv.m_data[2][n3] = -d6;
                        break;
                    }
                    if (n4 == 6 || n4 == 9) {
                        this.m_incrAmbient.m_data[2][n3] = d4;
                        this.m_incrAmbientInv.m_data[2][n3] = -d4;
                        this.m_incrAmbient.m_data[3][n3] = d5;
                        this.m_incrAmbientInv.m_data[3][n3] = -d5;
                        break;
                    }
                    if (n4 == 7) {
                        PvModelCamera.translateSpherical(this.m_incrAmbient, 2, n3 - 1, d6 *= -Math.PI);
                        this.m_incrAmbientInv.transpose(this.m_incrAmbient);
                        break;
                    }
                    if (n4 == 10) {
                        PdMatrix pdMatrix = new PdMatrix(n3 + 1);
                        PvModelCamera.translateSpherical(pdMatrix, 2, n3 - 1, d4 *= -Math.PI);
                        PvModelCamera.translateSpherical(this.m_incrAmbient, 3, n3 - 1, d5 *= -Math.PI);
                        this.m_incrAmbient.rightMult(pdMatrix);
                        this.m_incrAmbientInv.transpose(this.m_incrAmbient);
                        break;
                    }
                    if (n4 == 8) {
                        PvModelCamera.translateHyperbolic(this.m_incrAmbient, 2, n3 - 1, d6);
                        this.m_incrAmbientInv.transpose(this.m_incrAmbient);
                        break;
                    }
                    if (n4 != 11) break;
                    PdMatrix pdMatrix = new PdMatrix(n3 + 1);
                    PvModelCamera.translateHyperbolic(pdMatrix, 2, n3 - 1, d6);
                    PvModelCamera.translateHyperbolic(this.m_incrAmbient, 3, n3 - 1, d6);
                    this.m_incrAmbient.rightMult(pdMatrix);
                    this.m_incrAmbientInv.transpose(this.m_incrAmbient);
                    break;
                }
                if (this.m_mode != 0) break;
                if (n4 == 0) {
                    return;
                }
                this.m_vec.invStereoProj(this.m_currNormLoc[0], this.m_currNormLoc[1]);
                double d12 = Math.acos(this.m_vec.dot(this.m_vecAlt));
                if (d12 < 1.0E-10) {
                    return;
                }
                if (n4 == 1 || n4 == 5 || n4 == 2) {
                    if (this.m_vec.getEntry(0) < this.m_vecAlt.getEntry(0)) {
                        d12 = -d12;
                    }
                    PvModelCamera.translateSpherical(this.m_incrAmbient, 0, 1, d12);
                } else {
                    this.m_rotAxis.cross(this.m_vecAlt, this.m_vec);
                    if (this.m_rotAxis.length() < 1.0E-10) {
                        return;
                    }
                    if (!PuReflect.makeRotation(this.m_incrAmbient, this.m_rotAxis, d12)) {
                        return;
                    }
                }
                this.m_vecAlt.copy(this.m_vec);
                this.m_incrAmbientInv.transpose(this.m_incrAmbient);
            }
        }
        this.m_ambient.rightMult(this.m_incrAmbient);
        this.m_ambientInv.leftMult(this.m_incrAmbientInv);
    }

    public void setCurrentView(PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        this.m_viewCamera.copy(pdMatrix);
        this.m_viewInvCamera.copy(pdMatrix2);
    }

    public PvModelCamera(PvDisplay pvDisplay) {
        this.m_display = pvDisplay;
        if (this.getClass() == (class$jv$viewer$PvModelCamera != null ? class$jv$viewer$PvModelCamera : (class$jv$viewer$PvModelCamera = PvModelCamera.class$("jv.viewer.PvModelCamera")))) {
            this.init();
        }
    }

    public int getMode() {
        return this.m_mode;
    }

    public void setMode(int n) {
        this.m_mode = n;
    }

    public PdMatrix getAmbientInvMatrix() {
        return this.m_ambientInv;
    }

    public PdMatrix getModelInvMatrix() {
        return this.m_modelInv;
    }

    private static void translateHyperbolic(PdMatrix pdMatrix, int n, int n2, double d) {
        pdMatrix.setIdentity();
        pdMatrix.m_data[n][n] = PuMath.cosh(d);
        pdMatrix.m_data[n][n2] = PuMath.sinh(d);
        pdMatrix.m_data[n2][n] = PuMath.sinh(d);
        pdMatrix.m_data[n2][n2] = PuMath.cosh(d);
    }

    public int getTransformationMode() {
        return this.m_transformationMode;
    }

    public void setTransformationMode(int n) {
        this.m_transformationMode = n;
    }

    public PdMatrix getAmbientMatrix() {
        return this.m_ambient;
    }

    public void setAmbientMatrix(PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        this.m_vecAlt.set(0.0, 0.0, 1.0);
        if (pdMatrix != null) {
            this.m_ambient.setSize(pdMatrix.getISize(), pdMatrix.getJSize());
            this.m_ambient.copy(pdMatrix);
            this.m_incrAmbient.setSize(pdMatrix.getISize(), pdMatrix.getJSize());
        } else {
            this.m_ambient.setIdentity();
        }
        if (pdMatrix2 != null) {
            this.m_ambientInv.setSize(pdMatrix2.getISize(), pdMatrix2.getJSize());
            this.m_ambientInv.copy(pdMatrix2);
            this.m_incrAmbientInv.setSize(pdMatrix2.getISize(), pdMatrix2.getJSize());
        } else {
            this.m_ambientInv.setIdentity();
        }
        this.m_incrAmbient.setIdentity();
        this.m_incrAmbientInv.setIdentity();
    }

    public PdMatrix getModelMatrix() {
        return this.m_model;
    }

    public void setModelMatrix(PdMatrix pdMatrix) {
        this.m_vecAlt.set(0.0, 0.0, 1.0);
        if (pdMatrix != null) {
            this.m_model.copy(pdMatrix);
        } else {
            this.m_model.setIdentity();
        }
        this.m_modelInv.invert34(this.m_model);
        this.m_incrModel.setIdentity();
        this.m_incrModelInv.setIdentity();
    }

    protected void resizeImage(double d, double d2) {
        if (d == 0.0 || d2 == 0.0) {
            PsDebug.warning("window has a dimension==0");
            return;
        }
        this.m_nWidth = d;
        this.m_nHeight = d2;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        this.m_vecAlt.set(0.0, 0.0, 1.0);
        this.m_ambient.setIdentity();
        this.m_ambientInv.setIdentity();
        this.m_incrAmbient.setIdentity();
        this.m_incrAmbientInv.setIdentity();
        this.m_model.setIdentity();
        this.m_modelInv.setIdentity();
        this.m_incrModel.setIdentity();
        this.m_incrModelInv.setIdentity();
    }

    private static void translateSpherical(PdMatrix pdMatrix, int n, int n2, double d) {
        pdMatrix.setIdentity();
        pdMatrix.m_data[n][n] = Math.cos(d);
        pdMatrix.m_data[n][n2] = -Math.sin(d);
        pdMatrix.m_data[n2][n] = Math.sin(d);
        pdMatrix.m_data[n2][n2] = Math.cos(d);
    }
}

