/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.download.dialogs;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;

public class ProgressBar
extends Canvas {
    int percentDone = 0;
    int fontHeight;
    long timerStarted = 0L;
    Image offscreenImage;
    Graphics offscreenGraphics;

    public void addNotify() {
        super.addNotify();
        this.fontHeight = this.getFontMetrics(this.getFont()).getHeight();
        this.offscreenImage = this.createImage(this.size().width, this.size().height);
        this.offscreenGraphics = this.offscreenImage.getGraphics();
        this.offscreenGraphics.setFont(new Font("Dialog", 0, 12));
        this.offscreenGraphics.translate(2, 2);
        this.repaint();
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.offscreenImage, 0, 0, this);
    }

    public void update(Graphics graphics) {
        Dimension dimension = this.size();
        Dimension dimension2 = this.size();
        int n = 2;
        dimension2.height = (dimension.height >> 1) - 4;
        dimension2.width = dimension.width - 4;
        String string = "" + this.percentDone + "% done";
        if (this.percentDone >= 10) {
            long l = System.currentTimeMillis() - this.timerStarted;
            long l2 = (100L * l / (long)this.percentDone - l) / 1000L;
            string = l2 > 90L ? string + " (About " + (l2 + 30L) / 60L + " minutes remaining)" : (l2 > 30L ? string + " (About a minute remaining)" : string + " (Less than a minute remaining)");
        }
        int n2 = this.percentDone * dimension2.width / 100;
        this.offscreenGraphics.setColor(this.getBackground());
        this.offscreenGraphics.fillRect(-2, -2, dimension.width, dimension.height);
        int n3 = 4;
        int n4 = 0;
        while (n4 <= n3) {
            Color color = new Color(0, 0, 150);
            int n5 = n4;
            while (n5 < n3) {
                color = color.darker();
                ++n5;
            }
            this.offscreenGraphics.setColor(color);
            this.offscreenGraphics.fillRect(n4, n4, n2 - n4, dimension2.height - 1 - n4);
            float f = (float)n4 / (float)n3;
            this.offscreenGraphics.setColor(new Color(f, f, f));
            this.offscreenGraphics.fillRect(n2 + n4, n4, dimension2.width - n2 - 1 - n4, dimension2.height - 1 - n4);
            ++n4;
        }
        this.offscreenGraphics.setColor(Color.black);
        this.offscreenGraphics.drawString(string, 0, dimension2.height + (this.fontHeight >> 1) + 5);
        this.offscreenGraphics.draw3DRect(-1, -1, dimension2.width, dimension2.height, false);
        this.paint(graphics);
    }

    public void setPercentDone(int n) {
        if (n == this.percentDone && n != 0) {
            return;
        }
        this.percentDone = n;
        if (this.percentDone < 0) {
            this.percentDone = 0;
        } else if (this.percentDone > 100) {
            this.percentDone = 100;
        }
        if (this.timerStarted == 0L && n > 0) {
            this.timerStarted = System.currentTimeMillis();
        }
        this.repaint();
    }

    public int getPercentDone() {
        return this.percentDone;
    }

    public ProgressBar() {
        this(300, 50);
    }

    public ProgressBar(int n, int n2) {
        this.resize(n, n2);
    }
}

