/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.download.downloaders;

import com.zerog.ia.download.downloaders.FileDownloader;
import com.zerog.ia.download.downloaders.FileExecutor;
import com.zerog.ia.download.outputListeners.DownloadListener;
import com.zerog.ia.download.shared.DownloadContext;
import com.zerog.ia.download.utility.Gestalt;
import com.zerog.ia.download.utility.Util;
import java.awt.FileDialog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import netscape.security.PrivilegeManager;

public class ZGDownloader
extends FileDownloader {
    File fileDestination;
    boolean executeFile = false;
    boolean fileToBeDeletedAfterExecute = true;
    long totalSoFar;
    long expectedFileSize = -1L;
    FileExecutor executorObject;

    public void setFileDestination(File file) {
        this.fileDestination = file;
    }

    public File getFileDestination() {
        return this.fileDestination;
    }

    public void setExecuteFile(boolean bl) {
        this.executeFile = bl;
    }

    public boolean getExecuteFile() {
        return this.executeFile;
    }

    public void setFileToBeDeletedAfterExecute(boolean bl) {
        this.fileToBeDeletedAfterExecute = bl;
    }

    public boolean isFileToBeDeletedAfterExecute() {
        return this.fileToBeDeletedAfterExecute;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void downloadFileNow(URL uRL) throws Exception {
        super.downloadFileNow(uRL);
        boolean bl = true;
        int n = 1;
        while (bl) {
            try {
                this.copyFileFromServer(uRL, this.getFileDestination());
                bl = false;
            }
            catch (InterruptedIOException interruptedIOException) {
                if (n > 10) {
                    this.notifySetFriendlyErrorMessage("Unable to open file '" + this.getFileDestination().toString() + "' most likely because the file is marked as 'read-only'.");
                    throw new IOException();
                }
                int n2 = this.getFileDestination().toString().lastIndexOf(46);
                if (n2 == -1) {
                    n2 = this.getFileDestination().toString().length() - 1;
                }
                this.setFileDestination(new File(this.getFileDestination().toString().substring(0, n2) + ++n + this.getFileDestination().toString().substring(n2)));
            }
        }
        if (!this.isDownloadCancelled()) {
            this.notifyDownloadCompleted();
            return;
        }
        this.notifyDownloadCancelled();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        super.run();
        try {
            this.downloadFileNow(this.fileToDownload);
            this.setFileExecutor();
            if (this.executorObject == null) return;
            this.notifyOutputDiagnosticMessage("Attempting to run installer...");
            this.executorObject.start();
            return;
        }
        catch (IOException iOException) {
            FileDialog fileDialog = new FileDialog(this.context.getParentFrame(), "Save to", 1);
            fileDialog.setFile("install.exe");
            fileDialog.show();
            String string = fileDialog.getDirectory();
            String string2 = fileDialog.getFile();
            this.setFileDestination(new File(string + string2));
            this.notifyDownloadCancelled();
            this.run();
            return;
        }
        catch (Exception exception) {
            this.notifyErrorOccured(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyFileFromServer(URL uRL, File file) throws Exception {
        InputStream inputStream;
        URLConnection uRLConnection;
        this.notifyOutputDiagnosticMessage("copyFileFromServer: sourceUrl = " + uRL.toString());
        this.notifyOutputDiagnosticMessage("copyFileFromServer: destinationFile = " + file.toString());
        if (Gestalt.isNetscapeSecurityModelAvailable()) {
            PrivilegeManager.enablePrivilege((String)Gestalt.NETSCAPE_FILE_ACCESS);
        }
        try {
            uRLConnection = uRL.openConnection();
            uRLConnection.connect();
            inputStream = uRLConnection.getInputStream();
        }
        catch (Exception exception) {
            this.notifySetFriendlyErrorMessage("Problem in opening a connection to the installer on the server.  It is possible that the installer cannot be found or has a different name.");
            throw exception;
        }
        long l = uRLConnection.getContentLength();
        Object object = this.downloadListenerList.elements();
        while (true) {
            if (!object.hasMoreElements()) {
                if (file.length() != l) break;
                this.notifyOutputDiagnosticMessage("File already present on machine; skipping download.");
                return;
            }
            ((DownloadListener)object.nextElement()).setTotalNumberOfBytesInFile(l);
        }
        if (Gestalt.isNetscapeSecurityModelAvailable()) {
            PrivilegeManager.enablePrivilege((String)Gestalt.NETSCAPE_FILE_ACCESS);
        }
        if (!Util.makeLeadingDirectories(file)) {
            this.notifyOutputDiagnosticMessage("copyFileFromServer: Fail--leading directories not created (name:  '" + file.getPath() + "')");
            this.notifySetFriendlyErrorMessage("This volume is not writeable, you will be asked to choose a new location.");
            throw new IOException("Disk is not writeable.");
        }
        this.notifyOutputDiagnosticMessage("copyFileFromServer: Success--leading directories created (name:  '" + file.getPath() + "')");
        if (!this.checkForSpaceOnVolume(file, l)) {
            this.notifySetFriendlyErrorMessage("No space on this volume to download the installer.");
            throw new IOException("No space on this volume to download the installer.");
        }
        try {
            object = new RandomAccessFile(file, "rw");
        }
        catch (Exception exception) {
            if (file.exists()) {
                throw new InterruptedIOException();
            }
            this.notifySetFriendlyErrorMessage("Unable to open output file '" + file + "'.");
            throw exception;
        }
        this.totalSoFar = 0L;
        this.notifyDownloadStarted(uRL.toString());
        byte[] byArray = new byte[4096];
        try {
            block9: while (true) {
                int n = inputStream.read(byArray);
                this.totalSoFar += (long)n;
                if (n <= 0) break;
                if (this.isDownloadCancelled()) {
                    this.notifyOutputDiagnosticMessage("copyFileFromServer: Download cancelled.");
                    break;
                }
                ((RandomAccessFile)object).write(byArray, 0, n);
                Enumeration enumeration = this.downloadListenerList.elements();
                while (true) {
                    if (!enumeration.hasMoreElements()) continue block9;
                    ((DownloadListener)enumeration.nextElement()).setBytesInFileDownloaded(this.totalSoFar);
                }
                break;
            }
            Object var10_13 = null;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            inputStream.close();
            ((RandomAccessFile)object).close();
            throw throwable;
        }
        inputStream.close();
        ((RandomAccessFile)object).close();
        if (this.isDownloadCancelled()) {
            file.delete();
            this.executorObject = null;
            return;
        }
        if (file.length() == l) return;
        this.notifySetFriendlyErrorMessage("The entire installer was not downloaded, probably because your disk is full.");
        throw new Exception();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkForSpaceOnVolume(File file, long l) throws Exception {
        boolean bl;
        block10: {
            FileOutputStream fileOutputStream;
            bl = true;
            try {
                fileOutputStream = new FileOutputStream(file);
            }
            catch (Exception exception) {
                if (file.exists()) {
                    throw new InterruptedIOException();
                }
                this.notifyDownloadCancelled();
                this.notifySetFriendlyErrorMessage("Unable to download the installer to the current location, you will be asked to select a new location.");
                throw exception;
            }
            this.notifyOutputDiagnosticMessage("copyFileFromServer: Making sure there is enough room on volume for file.");
            byte[] byArray = new byte[1024];
            try {
                try {
                    long l2 = 0L;
                    while (true) {
                        if (l2 >= l / 1024L) {
                            fileOutputStream.write(byArray, 0, (int)(l % 1024L));
                            Object var8_12 = null;
                            break;
                        }
                        fileOutputStream.write(byArray, 0, 1024);
                        ++l2;
                    }
                }
                catch (Exception exception) {
                    bl = false;
                    Object var8_13 = null;
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    boolean bl2 = file.delete();
                    this.notifyOutputDiagnosticMessage("Attempt to delete temp file '" + file.toString() + "' = " + bl2);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                Object var8_14 = null;
                fileOutputStream.flush();
                fileOutputStream.close();
                boolean bl3 = file.delete();
                this.notifyOutputDiagnosticMessage("Attempt to delete temp file '" + file.toString() + "' = " + bl3);
                throw throwable;
            }
            fileOutputStream.flush();
            fileOutputStream.close();
            boolean bl4 = file.delete();
            this.notifyOutputDiagnosticMessage("Attempt to delete temp file '" + file.toString() + "' = " + bl4);
        }
        this.notifyOutputDiagnosticMessage("copyFileFromServer: Detected enough room on volume for file.");
        return bl;
    }

    public long getTotalSoFar() {
        return this.totalSoFar;
    }

    void setFileExecutor() {
        FileExecutor fileExecutor = new FileExecutor(this.getFileDestination(), this);
        this.setExecutorObject(fileExecutor);
    }

    public void setExecutorObject(FileExecutor fileExecutor) {
        this.executorObject = fileExecutor;
    }

    public ZGDownloader(DownloadContext downloadContext) {
        super(downloadContext);
    }
}

