/*
 * Decompiled with CFR 0.152.
 */
package vgp.curve.cycloid;

import java.awt.Color;
import jv.anim.PsAnimation;
import jv.anim.PsTimeEvent;
import jv.anim.PsTimeListenerIf;
import jv.geom.PgElementSet;
import jv.geom.PgPolygon;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;

public class PjCycloid
extends PjProject {
    protected boolean m_bShowCircle;
    protected boolean m_bShowCycloid;
    protected boolean m_bShowDelaunay;
    protected PgPolygon m_circle;
    protected PgPolygon m_stick;
    protected PgPolygon m_cycloid;
    protected PgElementSet m_delaunay;
    protected int m_defCycloidDiscr = 40;
    protected PuInteger m_cycloidDiscr;
    protected double m_defDistance = 2.0;
    protected PuDouble m_distance;
    protected double m_defLength = Math.PI * 4;
    protected PuDouble m_length;
    protected double m_defRadius = 1.0;
    protected PuDouble m_radius;
    protected int m_numCircleDiscr = 20;
    private static /* synthetic */ Class class$vgp$curve$cycloid$PjCycloid;

    public void setDistance(double d) {
        this.m_distance.setValue(d);
        this.computeCycloid(this.m_cycloidDiscr.getValue(), this.m_length.getValue(), this.m_distance.getValue());
        this.m_cycloid.update((Object)this.m_cycloid);
        this.m_circle.update(null);
        this.m_stick.update(null);
    }

    private void computeCycloid(int n, double d, double d2) {
        double d3 = this.m_radius.getValue();
        this.m_cycloid.setNumVertices(n);
        PdVector[] pdVectorArray = this.m_cycloid.getVertices();
        int n2 = 0;
        while (n2 < n) {
            double d4 = d * (double)n2 / ((double)n - 1.0);
            pdVectorArray[n2].m_data[0] = d3 * d4 - d2 * Math.sin(d4);
            pdVectorArray[n2].m_data[1] = d3 - d2 * Math.cos(d4);
            ++n2;
        }
        this.m_circle.computeCircle(this.m_numCircleDiscr, d3);
        this.m_circle.translate(new PdVector(0.0, d3));
        this.m_stick.setVertex(0, 0.0, d3);
        this.m_stick.setVertex(1, 0.0, d3 - d2);
    }

    public PjCycloid() {
        super("Cycloid");
        this.m_circle = new PgPolygon(2);
        this.m_circle.setName("Circle");
        this.m_circle.showVertices(false);
        this.m_cycloid = new PgPolygon(2);
        this.m_cycloid.setName("Cycloid");
        this.m_cycloid.setGlobalPolygonColor(Color.blue);
        this.m_stick = new PgPolygon(2);
        this.m_stick.setName("Stick");
        this.m_stick.showVertices(true);
        this.m_stick.setGlobalPolygonSize(5.0);
        this.m_stick.setGlobalVertexSize(7);
        this.m_stick.setGlobalVertexColor(Color.yellow);
        this.m_stick.setNumVertices(2);
        this.m_delaunay = new PgElementSet(3);
        this.m_delaunay.setName("Delaunay");
        this.m_delaunay.showElements(false);
        this.m_delaunay.setVisible(false);
        this.m_cycloidDiscr = new PuInteger("Cycloid Discr", (PsUpdateIf)this);
        this.m_length = new PuDouble("Cycloid Length", (PsUpdateIf)this);
        this.m_radius = new PuDouble("Radius r", (PsUpdateIf)this);
        this.m_distance = new PuDouble("Distance d", (PsUpdateIf)this);
        this.m_anim = new PsAnimation();
        this.m_anim.setName("Rolling Circle");
        this.m_anim.addTimeListener((PsTimeListenerIf)this);
        this.setAnimation(this.m_anim);
        if (((Object)((Object)this)).getClass() == (class$vgp$curve$cycloid$PjCycloid != null ? class$vgp$curve$cycloid$PjCycloid : (class$vgp$curve$cycloid$PjCycloid = PjCycloid.class$("vgp.curve.cycloid.PjCycloid")))) {
            this.init();
        }
    }

    public boolean setTime(PsTimeEvent psTimeEvent) {
        double d = psTimeEvent.getTime();
        double d2 = this.m_distance.getValue();
        double d3 = this.m_radius.getValue();
        double d4 = this.m_length.getValue();
        double d5 = d4 * d / 100.0;
        this.computeCycloid(this.m_cycloidDiscr.getValue(), d4, d2);
        this.m_circle.translate(new PdVector(d3 * d5, 0.0));
        this.m_stick.setVertex(0, d3 * d5, d3);
        this.m_stick.setVertex(1, d3 * d5 - d2 * Math.sin(d5), d3 - d2 * Math.cos(d5));
        this.m_display.setPaintTag(1, false);
        this.m_circle.update(null);
        this.m_display.setPaintTag(1, true);
        this.m_stick.update(null);
        return true;
    }

    public boolean update(Object object) {
        if (object == this.m_cycloidDiscr) {
            this.computeCycloid(this.m_cycloidDiscr.getValue(), this.m_length.getValue(), this.m_distance.getValue());
            if (!this.m_anim.isRunning()) {
                this.m_circle.update(null);
                this.m_stick.update(null);
            }
            if (this.m_delaunay.isVisible()) {
                this.m_delaunay.computeRotation(this.m_cycloid, 10);
                this.m_delaunay.update(null);
            }
            return this.m_cycloid.update((Object)this.m_cycloid);
        }
        if (object == this.m_distance || object == this.m_radius) {
            this.computeCycloid(this.m_cycloidDiscr.getValue(), this.m_length.getValue(), this.m_distance.getValue());
            if (!this.m_anim.isRunning()) {
                this.m_circle.update(null);
                this.m_stick.update(null);
            }
            if (this.m_delaunay.isVisible()) {
                this.m_delaunay.computeRotation(this.m_cycloid, 10);
                this.m_delaunay.update(null);
            }
            return this.m_cycloid.update((Object)this.m_cycloid);
        }
        if (object == this.m_length) {
            this.computeCycloid(this.m_cycloidDiscr.getValue(), this.m_length.getValue(), this.m_distance.getValue());
            if (!this.m_anim.isRunning()) {
                this.m_circle.update(null);
                this.m_stick.update(null);
            }
            if (this.m_delaunay.isVisible()) {
                this.m_delaunay.computeRotation(this.m_cycloid, 10);
                this.m_delaunay.update(null);
            }
            return this.m_cycloid.update((Object)this.m_cycloid);
        }
        return super.update(object);
    }

    public void start() {
        PvDisplayIf pvDisplayIf = this.getDisplay();
        if (pvDisplayIf != null) {
            pvDisplayIf.showGrid(true);
            pvDisplayIf.selectCamera(1);
        }
        this.addGeometry((PgGeometryIf)this.m_cycloid);
        this.addGeometry((PgGeometryIf)this.m_circle);
        this.addGeometry((PgGeometryIf)this.m_stick);
        this.selectGeometry((PgGeometryIf)this.m_cycloid);
        super.start();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        this.m_bShowCircle = true;
        this.m_bShowCycloid = true;
        this.m_bShowDelaunay = false;
        this.m_cycloidDiscr.setDefBounds(0, 2 * this.m_defCycloidDiscr, 1, 2);
        this.m_cycloidDiscr.setDefValue(this.m_defCycloidDiscr);
        this.m_cycloidDiscr.init();
        this.m_length.setDefBounds(0.1, 20.0, 0.1, 1.0);
        this.m_length.setDefValue(this.m_defLength);
        this.m_length.init();
        this.m_distance.setDefBounds(0.01, 5.0, 0.01, 0.1);
        this.m_distance.setDefValue(this.m_defDistance);
        this.m_distance.init();
        this.m_radius.setDefBounds(0.01, 5.0, 0.01, 0.1);
        this.m_radius.setDefValue(this.m_defRadius);
        this.m_radius.init();
        this.computeCycloid(this.m_cycloidDiscr.getValue(), this.m_length.getValue(), this.m_distance.getValue());
    }

    public void setCycloidDiscr(int n) {
        this.m_cycloidDiscr.setValue(n);
        this.computeCycloid(this.m_cycloidDiscr.getValue(), this.m_length.getValue(), this.m_distance.getValue());
        this.m_cycloid.update((Object)this.m_cycloid);
        this.m_circle.update(null);
        this.m_stick.update(null);
    }
}

