/*
 * Decompiled with CFR 0.152.
 */
package vgp.discrete.conformal;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import jv.object.PsConfig;
import jv.object.PsMainFrame;
import jv.project.PjProject;
import jv.viewer.PvViewer;
import vgp.discrete.conformal.PjConformal;

public class PaConformal
extends Applet
implements Runnable {
    protected Frame m_frame = null;
    protected PvViewer m_viewer;
    private String m_drawString = "Initializing ...";

    public void stop() {
        if (this.m_viewer != null) {
            this.m_viewer.stop();
        }
    }

    public void startFromThread() {
        if (this.m_viewer != null) {
            this.m_viewer.start();
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.blue);
        graphics.drawString(PsConfig.getProgram() + " v." + PsConfig.getVersion(), 20, 40);
        graphics.drawString(this.m_drawString, 20, 60);
    }

    public void destroy() {
        if (this.m_viewer != null) {
            this.m_viewer.destroy();
        }
    }

    private void drawMessage(String string) {
        this.m_drawString = string;
        this.repaint();
    }

    public static void main(String[] stringArray) {
        PaConformal paConformal = new PaConformal();
        PsMainFrame psMainFrame = new PsMainFrame((Component)paConformal, stringArray);
        psMainFrame.pack();
        psMainFrame.setBounds(new Rectangle(420, 5, 640, 550));
        paConformal.m_frame = psMainFrame;
        paConformal.init();
        psMainFrame.setVisible(true);
    }

    public String getAppletInfo() {
        return "Name: " + this.getClass().getName() + "\r\n" + "Author: " + "Konrad Polthier" + "\r\n" + "Version: " + "1.00" + "\r\n" + "Development applet on discrete conformal maps." + "\r\n";
    }

    public void run() {
        this.drawMessage("Loading viewer ...");
        this.m_viewer = new PvViewer((Applet)this, this.m_frame);
        this.drawMessage("Loading geometry ...");
        PjConformal pjConformal = new PjConformal();
        this.m_viewer.addProject((PjProject)pjConformal);
        this.m_viewer.selectProject(pjConformal.getName());
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)this.m_viewer.getDisplay());
        this.add("East", this.m_viewer.getPanel(10));
        this.validate();
        this.m_viewer.showPanel(13);
        this.startFromThread();
    }

    public void init() {
        Thread thread = new Thread((Runnable)this, "JavaView: inititialize applet");
        thread.setPriority(5);
        thread.start();
    }
}

