/*
 * Decompiled with CFR 0.152.
 */
package vgp.surface.common;

import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.object.PsUtil;
import vgp.surface.common.PgSurfaceDescr;

public class PgSurface
extends PgElementSet {
    protected PgSurfaceDescr m_descr;
    protected String m_surfaceName;
    private static /* synthetic */ Class class$vgp$surface$common$PgSurface;

    public void setAmbientSpace(int n) {
        super.setAmbientSpace(n);
        if (this.m_descr != null) {
            this.m_descr.setAmbientSpace(n);
        }
    }

    public PgSurface(int n) {
        super(n);
        if (((Object)((Object)this)).getClass() == (class$vgp$surface$common$PgSurface != null ? class$vgp$surface$common$PgSurface : (class$vgp$surface$common$PgSurface = PgSurface.class$("vgp.surface.common.PgSurface")))) {
            this.init();
        }
    }

    public void setAmbientProjection(int n) {
        super.setAmbientProjection(n);
        if (this.m_descr != null) {
            this.m_descr.setAmbientProjection(n);
        }
    }

    public boolean setSurfaceName(String string, String string2) {
        String string3 = string2 + string;
        this.m_descr = (PgSurfaceDescr)((Object)PsUtil.newInstance((String)string3));
        if (this.m_descr == null) {
            PsDebug.warning((String)("missing surface descriptor = " + string3));
            return false;
        }
        this.m_descr.setName(string);
        this.setDescr(this.m_descr);
        return true;
    }

    public boolean update(Object object) {
        if (object == null) {
            return super.update(null);
        }
        if (object == this.m_descr) {
            this.computeSurface();
            return super.update((Object)this);
        }
        return super.update(object);
    }

    public void setDescr(PgSurfaceDescr pgSurfaceDescr) {
        this.m_descr = pgSurfaceDescr;
        if (pgSurfaceDescr == null) {
            this.setName("");
            return;
        }
        this.setName(this.m_descr.getName());
        this.m_descr.setParent((PsUpdateIf)this);
    }

    public PgSurfaceDescr getDescr() {
        return this.m_descr;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
    }

    public void computeSurface() {
        if (this.m_descr == null) {
            PsDebug.warning((String)"missing descriptor of surface");
            return;
        }
        this.setAmbientSpace(this.m_descr.getAmbientSpace());
        this.setAmbientProjection(this.m_descr.getAmbientProjection());
        int n = this.m_descr.getNumULines();
        int n2 = this.m_descr.getNumVLines();
        this.setNumVertices(n * n2);
        double d = (this.m_descr.getUMax() - this.m_descr.getUMin()) / (-1.0 + (double)n);
        double d2 = (this.m_descr.getVMax() - this.m_descr.getVMin()) / (-1.0 + (double)n2);
        int n3 = 0;
        double d3 = this.m_descr.getUMin();
        int n4 = 0;
        while (n4 < n) {
            double d4 = this.m_descr.getVMin();
            int n5 = 0;
            while (n5 < n2) {
                this.m_descr.eval(((PgPointSet)this).m_vertex[n3], d3, d4);
                ++n3;
                d4 += d2;
                ++n5;
            }
            d3 += d;
            ++n4;
        }
        this.makeQuadrConn(n, n2);
        this.makeQuadrBnd(n, n2);
        this.makeElementNormals();
    }
}

