/*
 * Decompiled with CFR 0.152.
 */
package vgp.vector.lic;

import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.vecmath.PdVector;
import jvx.geom.PwIntegralLines;
import jvx.geom.PwLIC;
import jvx.geom.PwVectorField;
import jvx.surface.PgDomain;
import jvx.surface.PgDomainDescr;

public class PjLIC
extends PjProject {
    protected PwLIC m_lic;
    protected PgDomain m_domain;
    protected PgDomainDescr m_descr;
    protected PwVectorField m_vec = new PwVectorField(this.getDisplay());
    protected PwIntegralLines m_integral;
    private double m_UMin = 0.0;
    private double m_UMax = 0.0;
    private double m_VMin = 0.0;
    private double m_VMax = 0.0;
    private int m_ULines = -1;
    private int m_VLines = -1;
    private static /* synthetic */ Class class$vgp$vector$lic$PjLIC;

    public PjLIC() {
        super("LIC");
        this.m_lic = new PwLIC();
        this.m_integral = new PwIntegralLines();
        this.m_domain = new PgDomain(2);
        this.m_domain.setName("Domain with Vector Field");
        this.m_domain.setParent((PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$vector$lic$PjLIC != null ? class$vgp$vector$lic$PjLIC : (class$vgp$vector$lic$PjLIC = PjLIC.class$("vgp.vector.lic.PjLIC")))) {
            this.init();
        }
    }

    public boolean update(Object object) {
        if (object == this.m_domain) {
            if (!this.checkDescr()) {
                this.memorizeDescr();
                int n = this.m_domain.getNumVectorFields();
                int n2 = 0;
                while (n2 < n) {
                    this.m_domain.getVectorField(n2).setGeometry((PgPointSet)this.m_domain);
                    ++n2;
                }
                this.m_lic.stopLIC();
                this.m_domain.setElementTextures(null);
                this.m_domain.showElementTexture(false);
                PgElementSet.triangulate((PgElementSet)this.m_domain);
                this.m_lic.setGeometry((PgElementSet)this.m_domain);
                this.m_domain.update(null);
            }
            return super.update(null);
        }
        return super.update(object);
    }

    public void start() {
        super.start();
        this.addGeometry((PgGeometryIf)this.m_domain);
        this.update(this.m_domain);
        this.m_vec.setDisplay(this.getDisplay());
        this.m_vec.setGeometry((PgElementSet)this.m_domain);
        this.m_vec.makeNewVF(0);
        this.m_vec.addCenter(new PdVector(-2.5, -2.5), 0);
        this.m_vec.addCenter(1);
        this.m_integral.setGeometry((PgElementSet)this.m_domain);
        if (this.getDisplay() != null) {
            this.getDisplay().selectCamera(1);
            this.getDisplay().setMajorMode(5);
            this.m_integral.setDisplay(this.getDisplay());
        }
        this.m_domain.showEdges(false);
        this.m_domain.showElements(false);
        this.m_domain.setGlobalVectorColor(Color.black);
        this.m_domain.update(null);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        this.m_descr = this.m_domain.getDescr();
        this.m_descr.setMaxSize(-10.0, -10.0, 10.0, 10.0);
        this.m_descr.setSize(-5.0, -5.0, 5.0, 5.0);
        this.m_descr.setDiscrBounds(2, 2, 50, 50);
        this.m_descr.setDiscr(10, 10);
        this.m_domain.computeSurface();
        PgElementSet.triangulate((PgElementSet)this.m_domain);
        this.m_lic.setGeometry((PgElementSet)this.m_domain);
        this.m_lic.setFast(true);
        this.m_lic.setLICSize(50);
    }

    private void memorizeDescr() {
        this.m_UMin = this.m_descr.getUMin();
        this.m_VMin = this.m_descr.getVMin();
        this.m_UMax = this.m_descr.getUMax();
        this.m_VMax = this.m_descr.getVMax();
        this.m_ULines = this.m_descr.getNumULines();
        this.m_VLines = this.m_descr.getNumVLines();
    }

    private boolean checkDescr() {
        return this.m_UMin == this.m_descr.getUMin() && this.m_VMin == this.m_descr.getVMin() && this.m_UMax == this.m_descr.getUMax() && this.m_VMax == this.m_descr.getVMax() && this.m_ULines == this.m_descr.getNumULines() && this.m_VLines == this.m_descr.getNumVLines();
    }
}

