/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Date;
import java.util.Random;
import jv.geom.PgElementSet;
import jv.object.PsConfig;
import jv.object.PsDialog;
import jv.object.PsUpdateIf;
import jv.project.PvDisplayIf;
import jv.project.PvPickEvent;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PnCellOperator;
import jvx.geom.PnExplodeElementSet;
import jvx.geom.PnMinesweeper_Dialog;
import jvx.thirdParty.acmeGui.GuiUtils;
import jvx.thirdParty.acmeGui.OkDialog;

public class PnMinesweeper
extends PnCellOperator
implements KeyListener {
    protected int m_numMines;
    protected int m_numOpen;
    protected PiVector m_minedNeighbours;
    protected boolean m_bShift = false;
    protected boolean[] m_bMines;
    protected Random m_random;
    protected boolean m_bFirstPick;
    protected PnExplodeElementSet m_expl;
    protected double m_explSpeed = 0.5;
    protected double m_explGravity = 0.00981;
    protected double m_explRotationSpeed = 0.5;
    protected PvDisplayIf m_explodeDisplay;
    protected boolean m_bExploding;
    protected long m_startTime;
    protected long m_endTime;
    protected String[] m_origElNames;
    protected boolean m_showIndices;
    private static /* synthetic */ Class class$jvx$geom$PnMinesweeper;

    public void stop() {
    }

    public void setMines(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        this.m_numMines = this.m_geom.getNumElements() / 5;
        this.m_numOpen = 0;
        while (n6 < this.m_numMines) {
            n5 = Math.abs(this.m_random.nextInt()) % this.m_geom.getNumElements();
            n4 = 0;
            n3 = this.m_infCell[n].getSize();
            n2 = 0;
            while (n2 < n3) {
                if (this.m_infCell[n].m_data[n2] == n5) {
                    n4 = 1;
                }
                ++n2;
            }
            if (this.m_bMines[n5] || n4 != 0) continue;
            this.m_bMines[n5] = true;
            ++n6;
        }
        this.m_minedNeighbours = new PiVector(this.m_geom.getNumElements());
        n5 = this.m_geom.getNumElements();
        n3 = 0;
        while (n3 < n5) {
            this.m_minedNeighbours.m_data[n3] = 0;
            n4 = this.m_infCell[n3].getSize();
            n2 = 1;
            while (n2 < n4) {
                if (this.m_infCell[n3].m_data[n2] > -1 && this.m_bMines[this.m_infCell[n3].m_data[n2]]) {
                    int n7 = n3;
                    this.m_minedNeighbours.m_data[n7] = this.m_minedNeighbours.m_data[n7] + 1;
                }
                ++n2;
            }
            ++n3;
        }
        this.m_startTime = new Date().getTime();
    }

    public static PsDialog getDialog(PgElementSet pgElementSet) {
        PnMinesweeper_Dialog pnMinesweeper_Dialog = new PnMinesweeper_Dialog(pgElementSet);
        ((Component)((Object)pnMinesweeper_Dialog)).setVisible(true);
        return pnMinesweeper_Dialog;
    }

    public void setExplodeDisplay(PvDisplayIf pvDisplayIf) {
        this.m_explodeDisplay = pvDisplayIf;
    }

    protected void openNeighbours(int n) {
        int n2 = this.m_infCell[n].getSize();
        int n3 = 1;
        while (n3 < n2) {
            if (this.m_infCell[n].m_data[n3] > -1 && this.m_markI.m_data[this.m_infCell[n].m_data[n3]] == 0) {
                this.markElement(this.m_infCell[n].m_data[n3], 2);
                this.m_geom.getElement(this.m_infCell[n].m_data[n3]).setName(String.valueOf(this.m_minedNeighbours.m_data[this.m_infCell[n].m_data[n3]]));
                ++this.m_numOpen;
                if (this.m_minedNeighbours.m_data[this.m_infCell[n].m_data[n3]] == 0) {
                    this.openNeighbours(this.m_infCell[n].m_data[n3]);
                }
            }
            ++n3;
        }
    }

    public PnMinesweeper(PgElementSet pgElementSet) {
        super(pgElementSet);
        this.setOutputType(1);
        int n = pgElementSet.getNumElements();
        this.m_origElNames = new String[n];
        this.m_showIndices = pgElementSet.isShowingIndices();
        int n2 = 0;
        while (n2 < n) {
            this.m_origElNames[n2] = pgElementSet.getElement(n2).getName();
            ++n2;
        }
        this.m_geom.addUpdateListener((PsUpdateIf)this);
        if (this.getClass() == (class$jvx$geom$PnMinesweeper != null ? class$jvx$geom$PnMinesweeper : (class$jvx$geom$PnMinesweeper = PnMinesweeper.class$("jvx.geom.PnMinesweeper")))) {
            this.init();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (16 == keyEvent.getKeyCode()) {
            this.m_bShift = true;
        }
    }

    public void restoreColors() {
        super.restoreColors();
        int n = this.m_geom.getNumElements();
        if (n == this.m_origElNames.length) {
            int n2 = 0;
            while (n2 < n) {
                this.m_geom.getElement(n2).setName(this.m_origElNames[n2]);
                ++n2;
            }
        }
        this.m_geom.showIndices(this.m_showIndices);
    }

    public boolean update(Object object) {
        if (object == this.m_geom) {
            if (!this.m_bUpdateSender) {
                this.init();
            }
            return true;
        }
        if (object == this) {
            this.m_bUpdateSender = true;
            this.m_geom.update((Object)this.m_geom);
            this.m_bUpdateSender = false;
            return super.update(this);
        }
        if (object == this.m_expl) {
            this.m_expl.reset();
            this.init();
            this.m_bUpdateSender = false;
            return true;
        }
        return super.update(object);
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (16 == keyEvent.getKeyCode()) {
            this.m_bShift = false;
        }
    }

    public void start() {
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        this.m_numStates = 3;
        this.m_color = new Color[3];
        this.m_color[0] = new Color(255, 255, 255);
        this.m_color[1] = new Color(255, 0, 0);
        this.m_color[2] = new Color(107, 157, 255);
        this.m_markI = new PiVector(this.m_geom.getNumElements());
        this.m_random = new Random();
        this.m_bMines = new boolean[this.m_geom.getNumElements()];
        int n = this.m_geom.getNumElements();
        int n2 = 0;
        while (n2 < n) {
            this.m_bMines[n2] = false;
            ++n2;
        }
        this.m_markI.setConstant(0);
        this.m_markI.setSize(this.m_geom.getNumElements());
        this.m_infCell = new PiVector[this.m_geom.getNumElements()];
        this.m_geomElement = this.m_geom.getElements();
        this.m_geomNeighbour = this.m_geom.getNeighbours();
        this.m_geom.assureElementColors();
        this.m_geom.showElementColors(true);
        n2 = 0;
        while (n2 < n) {
            this.m_geom.getElement(n2).setName("");
            ++n2;
        }
        this.m_geom.showIndices(true);
        this.makeInfluence();
        this.setColors();
        this.update(this);
        this.m_bFirstPick = true;
        this.m_bExploding = false;
    }

    public void run() {
    }

    public void pickInitial(PvPickEvent pvPickEvent) {
        if (!this.m_bExploding) {
            int n;
            int n2 = pvPickEvent.getElementInd();
            if (n2 != -1) {
                if (this.m_bShift) {
                    if (!this.m_bFirstPick) {
                        if (this.m_markI.m_data[n2] == 0) {
                            this.markElement(n2, 1);
                            this.setColors();
                            this.update(this);
                        } else if (this.m_markI.m_data[n2] == 1) {
                            this.markElement(n2, 0);
                            this.setColors();
                            this.update(this);
                        }
                    }
                } else if (this.m_markI.m_data[n2] == 0) {
                    if (!this.m_bMines[n2]) {
                        this.markElement(n2, 2);
                        if (this.m_bFirstPick) {
                            this.setMines(n2);
                            this.m_bFirstPick = false;
                        }
                        ++this.m_numOpen;
                        this.m_geom.getElement(n2).setName(String.valueOf(this.m_minedNeighbours.m_data[n2]));
                        if (this.m_minedNeighbours.m_data[n2] == 0) {
                            this.openNeighbours(n2);
                        }
                        this.setColors();
                        this.update(this);
                    } else {
                        this.m_bExploding = true;
                        this.explode();
                    }
                } else if (this.m_markI.m_data[n2] == 2) {
                    n = 0;
                    boolean bl = false;
                    int n3 = 1;
                    while (n3 < this.m_infCell[n2].getSize()) {
                        boolean bl2 = false;
                        if (this.m_infCell[n2].m_data[n3] > -1) {
                            if (this.m_markI.m_data[this.m_infCell[n2].m_data[n3]] == 1) {
                                ++n;
                                bl2 = true;
                            }
                            if (this.m_bMines[this.m_infCell[n2].m_data[n3]] && !bl2) {
                                bl = true;
                            }
                        }
                        ++n3;
                    }
                    if (n == this.m_minedNeighbours.m_data[n2]) {
                        if (!bl) {
                            this.openNeighbours(n2);
                        } else {
                            this.m_bExploding = true;
                            this.explode();
                        }
                    }
                    this.setColors();
                    this.update(this);
                }
            }
            if (this.m_numOpen + this.m_numMines == this.m_geom.getNumElements()) {
                this.m_endTime = new Date().getTime();
                n = (int)((this.m_endTime - this.m_startTime) / 1000L);
                Frame frame = PsConfig.getFrame();
                OkDialog okDialog = new OkDialog(frame, GuiUtils.noticeIcon(frame.getComponent(0)), "You found " + this.m_numMines + " mines on " + this.m_geom.getNumElements() + " faces in " + n + " seconds.");
                okDialog.show();
                this.init();
            }
        }
    }

    protected void explode() {
        this.m_bUpdateSender = true;
        this.releasePick();
        this.m_geom.showBoundaries(false);
        PdMatrix pdMatrix = new PdMatrix(4);
        pdMatrix = this.m_explodeDisplay.getTransMatrix(128);
        PdVector pdVector = new PdVector(0.0, -1.0, 0.0, 0.0);
        pdVector.leftMultMatrix(pdMatrix);
        PdVector pdVector2 = new PdVector(pdVector.m_data[0], pdVector.m_data[1], pdVector.m_data[2]);
        this.m_expl = new PnExplodeElementSet(this.m_geom);
        this.m_expl.setSpeed(this.m_explSpeed);
        this.m_expl.setGravity(this.m_explGravity);
        this.m_expl.setGravityDirection(pdVector2);
        this.m_expl.setRotationSpeed(this.m_explRotationSpeed);
        this.m_expl.setEndListener((PsUpdateIf)this);
        this.m_expl.startAnimation();
        this.m_bUpdateSender = false;
        this.requestPick();
    }
}

