/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgPolygonOnElementSet;
import jvx.geom.PgVertexStar;

public class PwBary {
    private static PgElementSet prevGeom = null;
    private static int prevElement = -1;
    private static double AA;
    private static double BB;
    private static double CC;
    private static double AB;
    private static double BC;
    private static double AC;
    private static final double eps = 1.0E-10;
    private static PdBaryDir m_tmpEdge1;
    private static PdBaryDir m_tmpEdge2;
    private static PdBaryDir m_tmpEdge3;
    private static PdBaryDir m_tmpEdge4;
    private static PdVector[] m_projVert;
    private static PdVector m_projN;
    private static PdVector m_rotVertAngles;
    private static PgVertexStar m_rotVertStar;
    private static PdBaryDir m_rotVertEdge;
    private static PdBaryDir m_rotVertHalf;
    private static PdBaryDir m_rotVertNormal;
    private static PdBaryDir m_angleEdge;
    private static double[] m_angleOriented;
    private static PdBaryDir[] m_angleVectors;
    private static final String errormsg = "Elements degenerated in element set.";

    public static PdBaryDir[] getTransRepresentation(PgElementSet pgElementSet, int n, PdBaryDir pdBaryDir, int n2, PiVector piVector, PiVector piVector2) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"Missing geometry.");
            return null;
        }
        if (pdBaryDir == null || pdBaryDir.getSize() != 3) {
            PsDebug.warning((String)"Missing vector.");
            return null;
        }
        if (n < 0 || n >= pgElementSet.getNumElements()) {
            PsDebug.warning((String)"Invalid element.");
            return null;
        }
        if (n2 < 0 || n2 >= 3) {
            PsDebug.warning((String)"Invalid vertex.");
            return null;
        }
        PdVector pdVector = new PdVector(1);
        double d = PwBary.getTransRepresentationValues(pgElementSet, n, pdBaryDir, n2, piVector, piVector2, pdVector);
        double d2 = PwBary.norm(pgElementSet, n, pdBaryDir, false);
        int n3 = piVector.getSize();
        PdBaryDir[] pdBaryDirArray = new PdBaryDir[n3];
        PdBaryDir pdBaryDir2 = new PdBaryDir(3);
        PdBaryDir pdBaryDir3 = new PdBaryDir(3);
        int n4 = 0;
        while (n4 < n3) {
            int n5 = piVector.getEntry(n4);
            int n6 = piVector2.getEntry(n4);
            double d3 = pdVector.getEntry(n4);
            pdBaryDir2.m_data[n6] = -1.0;
            pdBaryDir2.m_data[(n6 + 1) % 3] = 1.0;
            pdBaryDir2.m_data[(n6 + 2) % 3] = 0.0;
            pdBaryDir3.m_data[n6] = -1.0;
            pdBaryDir3.m_data[(n6 + 1) % 3] = 0.0;
            pdBaryDir3.m_data[(n6 + 2) % 3] = 1.0;
            double d4 = PwBary.norm(pgElementSet, n5, pdBaryDir2, false);
            if (d4 < 1.0E-10) {
                PsDebug.warning((String)"Edges degenerated.");
            } else {
                pdBaryDir2.multScalar(1.0 / d4);
            }
            double d5 = PwBary.getOrientedAngle(pgElementSet, n5, pdBaryDir2, pdBaryDir3, false) / 2.0;
            double d6 = d5 - Math.PI * 2 / d * (d3 + d5);
            pdBaryDirArray[n4] = new PdBaryDir(3);
            PwBary.rotateInElement(pgElementSet, n5, pdBaryDir2, d6, pdBaryDirArray[n4], false);
            pdBaryDirArray[n4].multScalar(d2);
            ++n4;
        }
        return pdBaryDirArray;
    }

    public static boolean showsIntoElement(PdBaryDir pdBaryDir, int n) {
        if (pdBaryDir == null || pdBaryDir.getSize() != 3) {
            PsDebug.warning((String)"wrong direction");
            return false;
        }
        return pdBaryDir.m_data[n] <= 0.0 && pdBaryDir.m_data[(n + 1) % 3] >= 0.0 && pdBaryDir.m_data[(n + 2) % 3] >= 0.0;
    }

    public static double norm(PgElementSet pgElementSet, int n, PdBaryDir pdBaryDir, boolean bl) {
        double d;
        if (pgElementSet == null) {
            PsDebug.warning((String)"Missing element set.");
            return 0.0;
        }
        if (pdBaryDir == null || pdBaryDir.getSize() != 3) {
            PsDebug.warning((String)"No valid x.");
            return 0.0;
        }
        if (n < 0 || n >= pgElementSet.getNumElements()) {
            PsDebug.warning((String)("Not a valid element index " + n + "."));
            return 0.0;
        }
        if (bl || prevGeom != pgElementSet || prevElement != n) {
            PiVector piVector = pgElementSet.getElement(n);
            PdVector pdVector = pgElementSet.getVertex(piVector.m_data[0]);
            PdVector pdVector2 = pgElementSet.getVertex(piVector.m_data[1]);
            PdVector pdVector3 = pgElementSet.getVertex(piVector.m_data[2]);
            AA = 0.0;
            BB = 0.0;
            CC = 0.0;
            AB = 0.0;
            AC = 0.0;
            BC = 0.0;
            int n2 = pdVector.getSize();
            int n3 = 0;
            while (n3 < n2) {
                AA += pdVector.m_data[n3] * pdVector.m_data[n3];
                BB += pdVector2.m_data[n3] * pdVector2.m_data[n3];
                CC += pdVector3.m_data[n3] * pdVector3.m_data[n3];
                AB += pdVector.m_data[n3] * pdVector2.m_data[n3];
                AC += pdVector.m_data[n3] * pdVector3.m_data[n3];
                BC += pdVector2.m_data[n3] * pdVector3.m_data[n3];
                ++n3;
            }
            prevGeom = pgElementSet;
            prevElement = n;
        }
        if ((d = pdBaryDir.m_data[0] * pdBaryDir.m_data[0] * AA + pdBaryDir.m_data[1] * pdBaryDir.m_data[1] * BB + pdBaryDir.m_data[2] * pdBaryDir.m_data[2] * CC + 2.0 * pdBaryDir.m_data[1] * pdBaryDir.m_data[0] * AB + 2.0 * pdBaryDir.m_data[2] * pdBaryDir.m_data[1] * BC + 2.0 * pdBaryDir.m_data[0] * pdBaryDir.m_data[2] * AC) < 0.0) {
            return 0.0;
        }
        return Math.sqrt(d);
    }

    public static double getVertexAngles(PgVertexStar pgVertexStar, PgElementSet pgElementSet, PdVector pdVector) {
        if (pgVertexStar == null) {
            PsDebug.warning((String)"Missing vertexstar.");
            return -1.0;
        }
        if (pgElementSet == null) {
            PsDebug.warning((String)"Missing geometry.");
            return -1.0;
        }
        PiVector piVector = pgVertexStar.getElement();
        PiVector piVector2 = pgVertexStar.getVertexLocInd();
        int n = piVector.m_data.length;
        if (pdVector == null) {
            pdVector = new PdVector(n);
        } else if (pdVector.m_data == null || pdVector.m_data.length != n) {
            pdVector.setSize(n);
        }
        double d = 0.0;
        boolean bl = true;
        int n2 = 0;
        while (n2 < n) {
            int n3 = piVector2.m_data[n2];
            PwBary.m_tmpEdge1.m_data[n3] = -1.0;
            PwBary.m_tmpEdge1.m_data[(n3 + 1) % 3] = 1.0;
            PwBary.m_tmpEdge1.m_data[(n3 + 2) % 3] = 0.0;
            PwBary.m_tmpEdge2.m_data[n3] = -1.0;
            PwBary.m_tmpEdge2.m_data[(n3 + 1) % 3] = 0.0;
            PwBary.m_tmpEdge2.m_data[(n3 + 2) % 3] = 1.0;
            double d2 = PwBary.scalar(pgElementSet, piVector.m_data[n2], m_tmpEdge1, m_tmpEdge2, bl);
            if (bl) {
                bl = false;
            }
            d2 /= PwBary.norm(pgElementSet, piVector.m_data[n2], m_tmpEdge1, bl);
            if ((d2 /= PwBary.norm(pgElementSet, piVector.m_data[n2], m_tmpEdge2, bl)) > 1.0) {
                d2 = 1.0;
            } else if (d2 < -1.0) {
                d2 = -1.0;
            }
            pdVector.m_data[n2] = d2 = Math.acos(d2);
            d += d2;
            ++n2;
        }
        return d;
    }

    static {
        m_tmpEdge1 = new PdBaryDir(3);
        m_tmpEdge2 = new PdBaryDir(3);
        m_tmpEdge3 = new PdBaryDir(3);
        m_tmpEdge4 = new PdBaryDir(3);
        m_projVert = null;
        m_projN = new PdVector();
        m_rotVertAngles = new PdVector();
        m_rotVertStar = new PgVertexStar();
        m_rotVertEdge = new PdBaryDir(3);
        m_rotVertHalf = new PdBaryDir(3);
        m_rotVertNormal = new PdBaryDir(3);
        m_angleEdge = new PdBaryDir(3);
        m_angleOriented = new double[2];
        m_angleVectors = new PdBaryDir[2];
    }

    public static double getOrientedAngle(PgElementSet pgElementSet, int n, PdBaryDir pdBaryDir, PdBaryDir pdBaryDir2, boolean bl) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"Missing geometry.");
            return 0.0;
        }
        if (n < 0 || n >= pgElementSet.getNumElements()) {
            PsDebug.warning((String)("Wrong element index=" + n));
            return 0.0;
        }
        if (pdBaryDir == null || pdBaryDir.getSize() != 3) {
            PsDebug.warning((String)"Wrong direction a");
            return 0.0;
        }
        if (pdBaryDir2 == null || pdBaryDir2.getSize() != 3) {
            PsDebug.warning((String)"Wrong direction b");
            return 0.0;
        }
        PwBary.m_angleEdge.m_data[0] = 0.0;
        PwBary.m_angleEdge.m_data[1] = -1.0;
        PwBary.m_angleEdge.m_data[2] = 1.0;
        double d = PwBary.norm(pgElementSet, n, m_angleEdge, bl);
        if (d < 1.0E-10) {
            PsDebug.warning((String)"Edges degenerated.");
            return Math.PI * -3;
        }
        m_angleEdge.multScalar(1.0 / d);
        PwBary.m_angleVectors[0] = pdBaryDir;
        PwBary.m_angleVectors[1] = pdBaryDir2;
        int n2 = 0;
        do {
            PwBary.m_angleOriented[n2] = PwBary.scalar(pgElementSet, n, m_angleVectors[n2], m_angleEdge, false);
            double d2 = PwBary.norm(pgElementSet, n, m_angleVectors[n2], false);
            if (d2 < 1.0E-10) {
                PsDebug.warning((String)("Vector degenerated no." + n2 + "."));
                if (m_angleVectors[n2] != null) {
                    PsDebug.warning((String)m_angleVectors[n2].toShortString());
                }
                return Math.PI * -3;
            }
            int n3 = n2;
            m_angleOriented[n3] = m_angleOriented[n3] / d2;
            if (m_angleOriented[n2] > 1.0) {
                PwBary.m_angleOriented[n2] = 1.0;
            } else if (m_angleOriented[n2] < -1.0) {
                PwBary.m_angleOriented[n2] = -1.0;
            }
            PwBary.m_angleOriented[n2] = Math.acos(m_angleOriented[n2]);
            if (!(PwBary.m_angleVectors[n2].m_data[0] < 0.0)) continue;
            int n4 = n2;
            m_angleOriented[n4] = m_angleOriented[n4] * -1.0;
        } while (++n2 < 2);
        double d3 = m_angleOriented[1] - m_angleOriented[0];
        while (d3 > Math.PI) {
            d3 -= Math.PI * 2;
        }
        while (d3 < -Math.PI) {
            d3 += Math.PI * 2;
        }
        return d3;
    }

    public static double scalar(PgElementSet pgElementSet, int n, PdBaryDir pdBaryDir, PdBaryDir pdBaryDir2, boolean bl) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"Missing element set.");
            return 0.0;
        }
        if (pdBaryDir == null || pdBaryDir.getSize() != 3) {
            PsDebug.warning((String)"No valid x.");
            return 0.0;
        }
        if (pdBaryDir2 == null || pdBaryDir2.getSize() != 3) {
            PsDebug.warning((String)"No valid y.");
            return 0.0;
        }
        if (n < 0 || n >= pgElementSet.getNumElements()) {
            PsDebug.warning((String)("Not a valid element index " + n + "."));
            return 0.0;
        }
        if (bl || prevGeom != pgElementSet || prevElement != n) {
            PiVector piVector = pgElementSet.getElement(n);
            PdVector pdVector = pgElementSet.getVertex(piVector.m_data[0]);
            PdVector pdVector2 = pgElementSet.getVertex(piVector.m_data[1]);
            PdVector pdVector3 = pgElementSet.getVertex(piVector.m_data[2]);
            AA = 0.0;
            BB = 0.0;
            CC = 0.0;
            AB = 0.0;
            AC = 0.0;
            BC = 0.0;
            int n2 = pdVector.getSize();
            int n3 = 0;
            while (n3 < n2) {
                AA += pdVector.m_data[n3] * pdVector.m_data[n3];
                BB += pdVector2.m_data[n3] * pdVector2.m_data[n3];
                CC += pdVector3.m_data[n3] * pdVector3.m_data[n3];
                AB += pdVector.m_data[n3] * pdVector2.m_data[n3];
                AC += pdVector.m_data[n3] * pdVector3.m_data[n3];
                BC += pdVector2.m_data[n3] * pdVector3.m_data[n3];
                ++n3;
            }
            prevGeom = pgElementSet;
            prevElement = n;
        }
        double d = pdBaryDir.m_data[0];
        double d2 = pdBaryDir.m_data[1];
        double d3 = pdBaryDir.m_data[2];
        double d4 = pdBaryDir2.m_data[0];
        double d5 = pdBaryDir2.m_data[1];
        double d6 = pdBaryDir2.m_data[2];
        double d7 = d * d4 * AA + d2 * d5 * BB + d3 * d6 * CC + (d * d5 + d2 * d4) * AB + (d2 * d6 + d3 * d5) * BC + (d3 * d4 + d * d6) * AC;
        return d7;
    }

    public static PdBaryDir[] getProjRepresentation(PgElementSet pgElementSet, int n, PdBaryDir pdBaryDir, int n2, PiVector piVector, PiVector piVector2) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"Missing geometry.");
            return null;
        }
        if (pdBaryDir == null || pdBaryDir.getSize() != 3) {
            PsDebug.warning((String)"Missing vector.");
            return null;
        }
        if (n < 0 || n >= pgElementSet.getNumElements()) {
            PsDebug.warning((String)"Invalid element.");
            return null;
        }
        if (n2 < 0 || n2 >= 3) {
            PsDebug.warning((String)"Invalid vertex.");
            return null;
        }
        PgVertexStar pgVertexStar = new PgVertexStar();
        pgVertexStar.makeVertexStar(pgElementSet, pgElementSet.getElement((int)n).m_data[n2], n);
        int n3 = pgVertexStar.getFirstElemInd();
        piVector.setSize(pgVertexStar.getElement().getSize());
        piVector.copy(pgVertexStar.getElement());
        piVector2.setSize(pgVertexStar.getVertexLocInd().getSize());
        piVector2.copy(pgVertexStar.getVertexLocInd());
        PdBaryDir[] pdBaryDirArray = new PdBaryDir[pgVertexStar.getSize()];
        PiVector[] piVectorArray = pgElementSet.getElements();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        int n4 = pgElementSet.getDimOfVertices();
        PdVector pdVector = new PdVector(n4);
        int n5 = 0;
        while (n5 < n4) {
            pdVector.m_data[n5] = 0.0;
            ++n5;
        }
        n5 = 0;
        while (n5 < n4) {
            int n6 = 0;
            do {
                int n7 = n5;
                pdVector.m_data[n7] = pdVector.m_data[n7] + pdBaryDir.m_data[n6] * pdVectorArray[piVectorArray[n].m_data[n6]].m_data[n5];
            } while (++n6 < 3);
            ++n5;
        }
        n5 = 0;
        while (n5 < pdBaryDirArray.length) {
            if (n5 == n3) {
                pdBaryDirArray[n5] = new PdBaryDir(3);
                pdBaryDirArray[n5].copy(pdBaryDir);
            } else {
                pdBaryDirArray[n5] = new PdBaryDir(3);
                PwBary.projectOntoElement(pgElementSet, piVector.m_data[n5], pdVector, pdBaryDirArray[n5]);
            }
            ++n5;
        }
        return pdBaryDirArray;
    }

    public static double getTransRepresentationValues(PgElementSet pgElementSet, int n, PdBaryDir pdBaryDir, int n2, PiVector piVector, PiVector piVector2, PdVector pdVector) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"Missing geometry.");
            return 0.0;
        }
        if (pdBaryDir == null || pdBaryDir.getSize() != 3) {
            PsDebug.warning((String)"Missing vector.");
            return 0.0;
        }
        if (n < 0 || n >= pgElementSet.getNumElements()) {
            PsDebug.warning((String)"Invalid element.");
            return 0.0;
        }
        PgVertexStar pgVertexStar = new PgVertexStar();
        pgVertexStar.makeVertexStar(pgElementSet, pgElementSet.getElement((int)n).m_data[n2], n);
        int n3 = pgVertexStar.getFirstElemInd();
        int n4 = pgVertexStar.getElement().getSize();
        piVector2.setSize(n4);
        piVector.setSize(n4);
        int n5 = 0;
        while (n5 < n4) {
            piVector.setEntry(n5, pgVertexStar.getElement().getEntry((n5 + n3) % n4));
            piVector2.setEntry(n5, pgVertexStar.getVertexLocInd().getEntry((n5 + n3) % n4));
            ++n5;
        }
        PdVector pdVector2 = new PdVector();
        double d = PwBary.getVertexAngles(pgVertexStar, pgElementSet, pdVector2);
        double d2 = Math.PI * 2 - d;
        if (!pgVertexStar.isClosed()) {
            d = Math.PI * 2;
        }
        PdBaryDir pdBaryDir2 = new PdBaryDir(3);
        pdBaryDir2.m_data[n2] = -1.0;
        pdBaryDir2.m_data[(n2 + 1) % 3] = 0.0;
        pdBaryDir2.m_data[(n2 + 2) % 3] = 1.0;
        double d3 = 0.0;
        double d4 = PwBary.norm(pgElementSet, n, pdBaryDir, true);
        if (d4 >= 1.0E-10) {
            d3 = PwBary.getOrientedAngle(pgElementSet, n, pdBaryDir, pdBaryDir2, false);
        }
        pdVector.setSize(n4);
        pdVector.setEntry(0, d - pdVector2.m_data[n3] + d3);
        int n6 = n3 + 1;
        while (n6 < n3 + pgVertexStar.getSize()) {
            int n7 = n6 % pgVertexStar.getSize();
            if (!pgVertexStar.isClosed() && n6 == pgVertexStar.getSize()) {
                d3 += d2;
            }
            pdVector.setEntry(n6 - n3, d3);
            d3 += pdVector2.m_data[n7];
            ++n6;
        }
        return d;
    }

    public static void projectOntoElement(PgElementSet pgElementSet, int n, PdVector pdVector, PdBaryDir pdBaryDir) {
        double d;
        int n2;
        if (pgElementSet == null) {
            PsDebug.warning((String)"Missing geometry.");
            return;
        }
        if (pdVector == null || pdVector.getSize() != 3) {
            PsDebug.warning((String)"Missing vector.");
            return;
        }
        if (pdBaryDir == null) {
            PsDebug.warning((String)"Missing output variable.");
            return;
        }
        PiVector[] piVectorArray = pgElementSet.getElements();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        int n3 = pgElementSet.getDimOfVertices();
        if (m_projVert == null) {
            m_projVert = new PdVector[3];
            n2 = 0;
            do {
                PwBary.m_projVert[n2] = new PdVector(n3);
            } while (++n2 < 3);
        }
        n2 = 0;
        do {
            m_projVert[n2].setSize(pdVectorArray[piVectorArray[n].m_data[n2]].getSize());
            m_projVert[n2].copy(pdVectorArray[piVectorArray[n].m_data[n2]]);
        } while (++n2 < 3);
        m_projVert[1].sub(m_projVert[0]);
        m_projVert[2].sub(m_projVert[0]);
        m_projN.setSize(n3);
        n2 = 0;
        while (n2 < n3) {
            PwBary.m_projN.m_data[n2] = 0.0;
            ++n2;
        }
        if (n3 == 3) {
            m_projN.cross(m_projVert[1], m_projVert[2]);
            double d2 = m_projN.length();
            if (d2 < 1.0E-10) {
                PsDebug.warning((String)errormsg);
                return;
            }
            m_projN.multScalar(1.0 / d2);
            d = PdVector.dot((PdVector)m_projN, (PdVector)pdVector);
            m_projN.multScalar(-d);
            m_projN.add(pdVector);
        } else if (n3 < 3) {
            m_projN.copy(pdVector);
        }
        double d3 = m_projVert[1].sqrLength();
        if (d3 < 1.0E-10) {
            PsDebug.warning((String)errormsg);
            return;
        }
        d = PdVector.dot((PdVector)m_projN, (PdVector)m_projVert[1]) / d3;
        double d4 = PdVector.dot((PdVector)m_projVert[2], (PdVector)m_projVert[1]) / d3;
        m_projVert[1].multScalar(-d4);
        m_projVert[2].add(m_projVert[1]);
        d3 = m_projVert[2].sqrLength();
        if (d3 < 1.0E-10) {
            PsDebug.warning((String)errormsg);
            return;
        }
        double d5 = PdVector.dot((PdVector)m_projN, (PdVector)m_projVert[2]) / d3;
        pdBaryDir.setSize(3);
        pdBaryDir.m_data[0] = -d - d5 + d5 * d4;
        pdBaryDir.m_data[1] = d - d5 * d4;
        pdBaryDir.m_data[2] = d5;
    }

    public static void rotateInElement(PgElementSet pgElementSet, int n, PdBaryDir pdBaryDir, double d, PdBaryDir pdBaryDir2, boolean bl) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"Missing geometry.");
            return;
        }
        if (n < 0 || n >= pgElementSet.getNumElements()) {
            PsDebug.warning((String)("Wrong element index=" + n));
            return;
        }
        if (pdBaryDir == null || pdBaryDir.getSize() != 3) {
            PsDebug.warning((String)"Wrong direction");
            return;
        }
        if (pdBaryDir2 == null) {
            PsDebug.warning((String)"Missing output parameter");
            return;
        }
        int n2 = -1;
        double d2 = 1.0;
        int n3 = 0;
        do {
            if (!(pdBaryDir.m_data[n3] < d2)) continue;
            n2 = n3;
            d2 = pdBaryDir.m_data[n3];
        } while (++n3 < 3);
        double d3 = PwBary.norm(pgElementSet, n, pdBaryDir, bl);
        if (d3 < 1.0E-10) {
            PsDebug.warning((String)"Direction degenerated.");
            return;
        }
        m_tmpEdge3.copy(pdBaryDir);
        pdBaryDir2.setSize(3);
        pdBaryDir2.m_data[n2] = 0.0;
        pdBaryDir2.m_data[(n2 + 1) % 3] = -1.0;
        pdBaryDir2.m_data[(n2 + 2) % 3] = 1.0;
        m_tmpEdge3.multScalar(1.0 / d3);
        m_tmpEdge4.copy(m_tmpEdge3);
        m_tmpEdge4.multScalar(-PwBary.scalar(pgElementSet, n, m_tmpEdge3, pdBaryDir2, false));
        int n4 = 0;
        do {
            int n5 = n4;
            pdBaryDir2.m_data[n5] = pdBaryDir2.m_data[n5] + PwBary.m_tmpEdge4.m_data[n4];
        } while (++n4 < 3);
        double d4 = PwBary.norm(pgElementSet, n, pdBaryDir2, false);
        if (d4 < 1.0E-10) {
            PsDebug.warning((String)"Edges degenerated.");
            return;
        }
        pdBaryDir2.multScalar(1.0 / d4);
        m_tmpEdge3.multScalar(Math.cos(d));
        pdBaryDir2.multScalar(Math.sin(d));
        int n6 = 0;
        do {
            int n7 = n6;
            pdBaryDir2.m_data[n7] = pdBaryDir2.m_data[n7] + PwBary.m_tmpEdge3.m_data[n6];
        } while (++n6 < 3);
        pdBaryDir2.multScalar(d3);
    }

    public static int rotateAtVertex(PgElementSet pgElementSet, int n, int n2, PdBaryDir pdBaryDir, PdBaryDir pdBaryDir2, PdBary pdBary, double d) {
        double d2;
        if (pgElementSet == null) {
            PsDebug.warning((String)"Missing geometry.");
            return 0;
        }
        if (n < 0 || n >= pgElementSet.getNumElements()) {
            PsDebug.warning((String)("Wrong element index=" + n));
            return 0;
        }
        if (pdBaryDir == null || pdBaryDir.getSize() != 3) {
            PsDebug.warning((String)"Wrong direction");
            return 0;
        }
        if (pdBaryDir2 == null) {
            PsDebug.warning((String)"Missing output parameter");
            return 0;
        }
        m_rotVertStar.makeVertexStar(pgElementSet, pgElementSet.getElement((int)n).m_data[n2], n);
        double d3 = d2 = PwBary.getVertexAngles(m_rotVertStar, pgElementSet, m_rotVertAngles);
        if (!m_rotVertStar.isClosed()) {
            d3 = Math.PI * 2;
        }
        double d4 = d;
        while (d4 < 0.0) {
            d4 += Math.PI * 2;
        }
        double d5 = d3 / 2.0 / Math.PI * d4;
        int n3 = m_rotVertStar.getFirstElemInd();
        int n4 = PwBary.m_rotVertStar.getVertexLocInd().m_data[n3];
        int n5 = PwBary.m_rotVertStar.getElement().m_data[n3];
        PwBary.m_rotVertEdge.m_data[n4] = -1.0;
        PwBary.m_rotVertEdge.m_data[(n4 + 1) % 3] = 0.0;
        PwBary.m_rotVertEdge.m_data[(n4 + 2) % 3] = 1.0;
        double d6 = PwBary.norm(pgElementSet, n5, pdBaryDir, false);
        double d7 = PwBary.scalar(pgElementSet, n5, m_rotVertEdge, pdBaryDir, false);
        double d8 = PwBary.norm(pgElementSet, n5, m_rotVertEdge, false);
        if (Math.abs(d8) < 1.0E-10) {
            PsDebug.warning((String)"Edges degenerated in geometry.");
            return -1;
        }
        if (Math.abs(d6) < 1.0E-10) {
            PsDebug.warning((String)"Dir degenerated.");
            return -1;
        }
        d7 /= d8;
        if ((d7 /= d6) < -1.0) {
            d7 = -1.0;
        } else if (d7 > 1.0) {
            d7 = 1.0;
        }
        d7 = Math.acos(d7);
        double d9 = 0.0;
        while (d7 + d9 < d5) {
            if (!m_rotVertStar.isClosed() && ++n3 % PwBary.m_rotVertAngles.m_data.length == 0 && n3 > 0) {
                d7 = Math.PI * 2 - d2;
                if (d7 + (d9 += d7) >= d5 + 1.0E-6) {
                    return -1;
                }
                d7 = Math.min(d7, d5 - d9);
            }
            d9 += d7;
            d7 = PwBary.m_rotVertAngles.m_data[n3 % PwBary.m_rotVertAngles.m_data.length];
        }
        int n6 = PwBary.m_rotVertStar.getVertexLocInd().m_data[n3 % m_rotVertStar.getSize()];
        n5 = PwBary.m_rotVertStar.getElement().m_data[n3 % PwBary.m_rotVertAngles.m_data.length];
        if (n3 == m_rotVertStar.getFirstElemInd()) {
            pdBaryDir2.setSize(3);
            PwBary.rotateInElement(pgElementSet, n5, pdBaryDir, d5 - d9, pdBaryDir2, false);
        } else {
            PwBary.m_rotVertEdge.m_data[n6] = -1.0;
            PwBary.m_rotVertEdge.m_data[(n6 + 1) % 3] = 1.0;
            PwBary.m_rotVertEdge.m_data[(n6 + 2) % 3] = 0.0;
            d8 = PwBary.norm(pgElementSet, n5, m_rotVertEdge, false);
            if (Math.abs(d8) < 1.0E-10) {
                PsDebug.warning((String)"Edges degenerated in geometry.");
                return -1;
            }
            m_rotVertEdge.multScalar(1.0 / d8);
            PwBary.m_rotVertHalf.m_data[n6] = -1.0;
            PwBary.m_rotVertHalf.m_data[(n6 + 1) % 3] = 0.0;
            PwBary.m_rotVertHalf.m_data[(n6 + 2) % 3] = 1.0;
            m_rotVertNormal.copy(m_rotVertEdge);
            m_rotVertNormal.multScalar(-1.0 * PwBary.scalar(pgElementSet, n5, m_rotVertHalf, m_rotVertEdge, false));
            int n7 = 0;
            do {
                int n8 = n7;
                PwBary.m_rotVertNormal.m_data[n8] = PwBary.m_rotVertNormal.m_data[n8] + PwBary.m_rotVertHalf.m_data[n7];
            } while (++n7 < 3);
            d8 = PwBary.norm(pgElementSet, n5, m_rotVertNormal, false);
            if (Math.abs(d8) < 1.0E-10) {
                PsDebug.warning((String)"Edges degenerated in geometry.");
                return -1;
            }
            m_rotVertNormal.multScalar(1.0 / d8);
            pdBaryDir2.copy(m_rotVertEdge);
            pdBaryDir2.multScalar(Math.cos(d5 - d9));
            m_rotVertHalf.copy(m_rotVertNormal);
            m_rotVertHalf.multScalar(Math.sin(d5 - d9));
            n7 = 0;
            do {
                int n9 = n7;
                pdBaryDir2.m_data[n9] = pdBaryDir2.m_data[n9] + PwBary.m_rotVertHalf.m_data[n7];
            } while (++n7 < 3);
            pdBaryDir2.multScalar(d6);
        }
        pdBary.m_data[n6] = 1.0;
        pdBary.m_data[(n6 + 1) % 3] = 0.0;
        pdBary.m_data[(n6 + 2) % 3] = 0.0;
        return n5;
    }

    public static int liesOnVertex(PdBary pdBary) {
        int n;
        if (pdBary == null || pdBary.getSize() != 3) {
            PsDebug.warning((String)"wrong argument 'pos'");
            return -1;
        }
        int n2 = 0;
        int n3 = -1;
        int n4 = n = pdBary.getSize() - 1;
        while (n4 >= 0) {
            if (Math.abs(pdBary.m_data[n4]) < PgPolygonOnElementSet.BARYEPS) {
                ++n2;
            } else {
                n3 = n4;
            }
            --n4;
        }
        if (n2 == 2) {
            return n3;
        }
        return -1;
    }

    public static PdBaryDir[] getGeodRepresentation(PgElementSet pgElementSet, int n, PdBaryDir pdBaryDir, int n2, PiVector piVector, PiVector piVector2) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"Missing geometry.");
            return null;
        }
        if (pdBaryDir == null || pdBaryDir.getSize() != 3) {
            PsDebug.warning((String)"Missing vector.");
            return null;
        }
        if (n < 0 || n >= pgElementSet.getNumElements()) {
            PsDebug.warning((String)"Invalid element.");
            return null;
        }
        if (n2 < 0 || n2 >= 3) {
            PsDebug.warning((String)"Invalid vertex.");
            return null;
        }
        PgVertexStar pgVertexStar = new PgVertexStar();
        pgVertexStar.makeVertexStar(pgElementSet, pgElementSet.getElement((int)n).m_data[n2], n);
        piVector.setSize(pgVertexStar.getElement().getSize());
        piVector.copy(pgVertexStar.getElement());
        PdBaryDir[] pdBaryDirArray = new PdBaryDir[pgVertexStar.getSize()];
        double d = PwBary.norm(pgElementSet, n, pdBaryDir, true);
        if (d < 1.0E-10) {
            int n3 = 0;
            while (n3 < pdBaryDirArray.length) {
                pdBaryDirArray[n3] = new PdBaryDir(0.0, 0.0, 0.0);
                ++n3;
            }
            return pdBaryDirArray;
        }
        PdVector pdVector = new PdVector();
        double d2 = PwBary.getVertexAngles(pgVertexStar, pgElementSet, pdVector);
        double d3 = Math.PI * 2 - d2;
        if (!pgVertexStar.isClosed()) {
            d2 = Math.PI * 2;
        }
        int n4 = pgVertexStar.getFirstElemInd();
        PdBaryDir pdBaryDir2 = new PdBaryDir(3);
        pdBaryDir2.m_data[n2] = 1.0;
        pdBaryDir2.m_data[(n2 + 1) % 3] = 0.0;
        pdBaryDir2.m_data[(n2 + 2) % 3] = -1.0;
        double d4 = PwBary.scalar(pgElementSet, n, pdBaryDir, pdBaryDir2, false);
        d4 /= d;
        double d5 = PwBary.norm(pgElementSet, n, pdBaryDir2, false);
        if (d5 < 1.0E-10) {
            PsDebug.warning((String)"Edges degenerated in element set.");
            return null;
        }
        if ((d4 /= d5) > 1.0) {
            d4 = 1.0;
        } else if (d4 < -1.0) {
            d4 = -1.0;
        }
        d4 = Math.acos(d4);
        if (pdBaryDir.m_data[(n2 + 1) % 3] > 0.0) {
            d4 = Math.PI * 2 - d4;
        }
        pdBaryDirArray[n4] = new PdBaryDir(3);
        pdBaryDirArray[n4].copy(pdBaryDir);
        piVector2.setSize(pgVertexStar.getVertexLocInd().getSize());
        piVector2.copy(pgVertexStar.getVertexLocInd());
        PdBaryDir pdBaryDir3 = new PdBaryDir(3);
        PdBaryDir pdBaryDir4 = new PdBaryDir(3);
        double d6 = 0.0;
        int n5 = n4 + 1;
        while (n5 < n4 + pgVertexStar.getSize()) {
            int n6 = n5 % pgVertexStar.getSize();
            if (!pgVertexStar.isClosed() && n5 == pgVertexStar.getSize()) {
                d6 += d3;
            }
            int n7 = piVector2.m_data[n6];
            pdBaryDir2.m_data[n7] = -1.0;
            pdBaryDir2.m_data[(n7 + 1) % 3] = 1.0;
            pdBaryDir2.m_data[(n7 + 2) % 3] = 0.0;
            d5 = PwBary.norm(pgElementSet, piVector.m_data[n6], pdBaryDir2, false);
            if (d5 < 1.0E-10) {
                PsDebug.warning((String)"Edges degenerated in element set.");
                return null;
            }
            pdBaryDir2.multScalar(1.0 / d5);
            pdBaryDir4 = new PdBaryDir(3);
            pdBaryDir4.m_data[n7] = -1.0;
            pdBaryDir4.m_data[(n7 + 1) % 3] = 0.0;
            pdBaryDir4.m_data[(n7 + 2) % 3] = 1.0;
            pdBaryDir3 = new PdBaryDir(3);
            pdBaryDir3.copy(pdBaryDir2);
            pdBaryDir3.multScalar(-1.0 * PwBary.scalar(pgElementSet, piVector.m_data[n6], pdBaryDir4, pdBaryDir2, false));
            pdBaryDir3.m_data[0] = pdBaryDir3.m_data[0] + pdBaryDir4.m_data[0];
            pdBaryDir3.m_data[1] = pdBaryDir3.m_data[1] + pdBaryDir4.m_data[1];
            pdBaryDir3.m_data[2] = pdBaryDir3.m_data[2] + pdBaryDir4.m_data[2];
            d5 = PwBary.norm(pgElementSet, piVector.m_data[n6], pdBaryDir3, false);
            if (Math.abs(d5) < 1.0E-10) {
                PsDebug.warning((String)"Edges degenerated in geometry.");
                return null;
            }
            pdBaryDir3.multScalar(1.0 / d5);
            double d7 = d2 / 2.0 - d6 - d4;
            pdBaryDirArray[n6] = new PdBaryDir(3);
            pdBaryDirArray[n6].copy(pdBaryDir2);
            pdBaryDirArray[n6].multScalar(Math.cos(d7));
            pdBaryDir4.copy(pdBaryDir3);
            pdBaryDir4.multScalar(Math.sin(d7));
            pdBaryDirArray[n6].m_data[0] = pdBaryDirArray[n6].m_data[0] + pdBaryDir4.m_data[0];
            pdBaryDirArray[n6].m_data[1] = pdBaryDirArray[n6].m_data[1] + pdBaryDir4.m_data[1];
            pdBaryDirArray[n6].m_data[2] = pdBaryDirArray[n6].m_data[2] + pdBaryDir4.m_data[2];
            pdBaryDirArray[n6].multScalar(d);
            d6 += pdVector.m_data[n6];
            ++n5;
        }
        return pdBaryDirArray;
    }
}

