/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.geom.PgElementSet;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDialog;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jvx.geom.PwCleanMesh;

public class PwCleanMesh_Dialog
extends PsDialog {
    protected PgElementSet m_geom;
    protected PgElementSet m_geomOriginal;
    protected PuDouble m_eps;
    protected Checkbox m_cPercent;
    protected Checkbox m_cAbsolute;
    protected double m_diam;
    protected boolean bUsePercentValue;
    private static /* synthetic */ Class class$jvx$geom$PwCleanMesh_Dialog;

    public PwCleanMesh_Dialog(PgElementSet pgElementSet) {
        super(PsConfig.getFrame(), PsConfig.getMessage((String)"PwCleanMeshDialog"), false);
        this.m_geom = pgElementSet;
        this.m_geomOriginal = new PgElementSet(this.m_geom.getDimOfVertices());
        this.m_geomOriginal.copy((PgGeometry)this.m_geom);
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwCleanMesh_Dialog != null ? class$jvx$geom$PwCleanMesh_Dialog : (class$jvx$geom$PwCleanMesh_Dialog = PwCleanMesh_Dialog.class$("jvx.geom.PwCleanMesh_Dialog")))) {
            this.init();
            ((Component)((Object)this)).setSize(350, 150);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.m_cPercent) {
            if (!this.bUsePercentValue) {
                double d = this.m_eps.getValue() * 100.0 / this.m_diam;
                double d2 = this.m_eps.getMin() * 100.0 / this.m_diam;
                double d3 = this.m_eps.getMax() * 100.0 / this.m_diam;
                double d4 = this.m_eps.getLineIncr() * 100.0 / this.m_diam;
                double d5 = this.m_eps.getPageIncr() * 100.0 / this.m_diam;
                this.m_eps.setBounds(d2, d3, d4, d5);
                this.m_eps.setValue(d);
            }
            this.bUsePercentValue = true;
            return;
        }
        if (object == this.m_cAbsolute) {
            if (this.bUsePercentValue) {
                double d = this.m_eps.getValue() * this.m_diam / 100.0;
                double d6 = this.m_eps.getMin() * this.m_diam / 100.0;
                double d7 = this.m_eps.getMax() * this.m_diam / 100.0;
                double d8 = this.m_eps.getLineIncr() * this.m_diam / 100.0;
                double d9 = this.m_eps.getPageIncr() * this.m_diam / 100.0;
                this.m_eps.setBounds(d6, d7, d8, d9);
                this.m_eps.setValue(d);
            }
            this.bUsePercentValue = false;
        }
    }

    public boolean update(Object object) {
        if (object == this.m_eps) {
            if (this.m_cPercent.getState()) {
                PwCleanMesh.markVertices(this.m_geom, this.m_eps.getValue() * this.m_diam / 100.0);
            } else {
                PwCleanMesh.markVertices(this.m_geom, this.m_eps.getValue());
            }
            this.m_geom.update(null);
            return true;
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_bReset) {
            this.m_geom.copy((PgGeometry)this.m_geomOriginal);
            if (this.m_cPercent.getState()) {
                PwCleanMesh.markVertices(this.m_geom, this.m_eps.getValue() * this.m_diam / 100.0);
            } else {
                PwCleanMesh.markVertices(this.m_geom, this.m_eps.getValue());
            }
            this.m_geom.update((Object)this.m_geom);
            return;
        }
        if (object == this.m_bOk) {
            if (this.m_cPercent.getState()) {
                PwCleanMesh.identifyVertices(this.m_geom, this.m_eps.getValue() * this.m_diam / 100.0);
            } else {
                PwCleanMesh.identifyVertices(this.m_geom, this.m_eps.getValue());
            }
            PwCleanMesh.removeMarks(this.m_geom);
            this.m_geom.makeNeighbour();
            this.m_geom.update((Object)this.m_geom);
            return;
        }
        if (object == this.m_bClose) {
            this.m_action = 16;
            this.dispose();
        }
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void dispose() {
        if (this.m_action == 16) {
            PwCleanMesh.removeMarks(this.m_geom);
            this.m_geom.update(null);
        }
        super.dispose();
    }

    public void init() {
        Panel panel = new Panel(new GridLayout(2, 1));
        Panel panel2 = new Panel(new GridLayout(1, 2));
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.m_cPercent = new Checkbox(PsConfig.getMessage((String)"distPercent"), checkboxGroup, true);
        this.bUsePercentValue = true;
        this.m_cPercent.addItemListener((ItemListener)((Object)this));
        panel2.add(this.m_cPercent);
        this.m_cAbsolute = new Checkbox(PsConfig.getMessage((String)"distAbsolute"), checkboxGroup, false);
        this.m_cAbsolute.addItemListener((ItemListener)((Object)this));
        panel2.add(this.m_cAbsolute);
        panel.add(panel2);
        this.m_eps = new PuDouble(PsConfig.getMessage((String)"dist"), (PsUpdateIf)this);
        this.m_diam = this.m_geom.getDiameter();
        this.m_eps.setDefValue(0.01);
        this.m_eps.setDefBounds(0.0, 1.0, 0.01, 0.1);
        this.m_eps.init();
        panel.add((Component)this.m_eps.getInfoPanel());
        ((Container)((Object)this)).add(panel);
        Panel panel3 = new Panel();
        panel3.setLayout(new FlowLayout(1));
        this.m_bOk = new Button(PsConfig.getMessage((String)"bIdentify"));
        this.m_bOk.addActionListener((ActionListener)((Object)this));
        panel3.add(this.m_bOk);
        this.m_bReset = new Button(PsConfig.getMessage((String)"bReset"));
        this.m_bReset.addActionListener((ActionListener)((Object)this));
        panel3.add(this.m_bReset);
        this.m_bClose = new Button(PsConfig.getMessage((String)"bClose"));
        this.m_bClose.addActionListener((ActionListener)((Object)this));
        panel3.add(this.m_bClose);
        ((Container)((Object)this)).setLayout(new FlowLayout());
        ((Container)((Object)this)).add(panel3);
        ((Container)((Object)this)).validate();
        if (this.m_cPercent.getState()) {
            PwCleanMesh.markVertices(this.m_geom, this.m_eps.getValue() * this.m_diam / 100.0);
        } else {
            PwCleanMesh.markVertices(this.m_geom, this.m_eps.getValue());
        }
        this.m_geom.update(null);
    }
}

