/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import java.awt.Dialog;
import jv.geom.PgBndPolygon;
import jv.geom.PgElementEdge;
import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.number.PdColor;
import jv.object.PsDebug;
import jv.object.PsDialog;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PwSimplify_Dialog;

public class PwSimplify
extends PsObject {
    protected PgElementSet m_elementSet;
    protected PiVector[] m_edgeList;
    protected PiVector m_index;
    protected PiVector m_location;
    protected boolean[] m_isDenied;
    protected int m_maxIndex;
    protected int m_lastNode;
    protected PdVector[] m_minVector;
    protected PdVector m_minValue;
    protected int m_numEdges;
    protected int m_numEl;
    protected PdMatrix[] m_quadMatrix;
    protected PdVector[] m_quadVector;
    protected PdVector m_quadScalar;
    protected PiVector[] m_edgesAtVertex;
    protected PiVector[] m_edgesAtVertex2;
    protected PiVector[] m_elementsAtVertex;
    protected boolean m_bRetainBoundary = false;
    protected boolean m_bRetainMarkedVertices = true;
    protected double minInOut;
    protected boolean m_bCheckAngles = false;
    protected boolean m_bFlipEdges = false;
    protected boolean m_bCheckNormals = true;
    protected boolean m_bForceSimplify = true;
    protected double m_maxAngle;
    protected boolean m_bBigNeighbourhood = false;
    protected boolean m_bUpdateSendet = false;
    public boolean m_bSetSimplified = false;

    public static PsDialog getDialog(PgElementSet pgElementSet) {
        PwSimplify_Dialog pwSimplify_Dialog = new PwSimplify_Dialog(pgElementSet);
        ((Dialog)((Object)pwSimplify_Dialog)).show();
        return pwSimplify_Dialog;
    }

    protected void markVertices() {
        int n;
        PdVector pdVector = new PdVector(this.m_elementSet.getNumVertices());
        boolean[] blArray = new boolean[this.m_elementSet.getNumVertices()];
        int n2 = this.m_elementSet.getNumVertices();
        int n3 = 0;
        while (n3 < n2) {
            blArray[n3] = false;
            ++n3;
        }
        int n4 = this.m_elementSet.getNumElements();
        int n5 = 0;
        while (n5 < n4) {
            PiVector piVector = this.m_elementSet.getElement(n5);
            PiVector piVector2 = this.m_elementSet.getNeighbour(n5);
            int n6 = piVector.getSize();
            n = 0;
            while (n < n6) {
                PdVector pdVector2 = this.m_elementSet.getVertex(piVector.m_data[n]);
                PdVector pdVector3 = this.m_elementSet.getVertex(piVector.m_data[(n + 1) % n6]);
                PdVector pdVector4 = this.m_elementSet.getVertex(piVector.m_data[(n + 2) % n6]);
                int n7 = piVector.m_data[(n + 1) % n6];
                pdVector.m_data[n7] = pdVector.m_data[n7] + PdVector.angle((PdVector)PdVector.subNew((PdVector)pdVector2, (PdVector)pdVector3), (PdVector)PdVector.subNew((PdVector)pdVector4, (PdVector)pdVector3));
                if (piVector2.m_data[n] == -1) {
                    blArray[piVector.m_data[(n + 1) % n6]] = true;
                    blArray[piVector.m_data[(n + 2) % n6]] = true;
                }
                ++n;
            }
            ++n5;
        }
        n5 = this.m_elementSet.getNumVertices();
        n = 0;
        while (n < n5) {
            if (blArray[n] && pdVector.m_data[n] < 130.0) {
                this.m_elementSet.setTagVertex(n, 1);
            }
            ++n;
        }
        this.m_elementSet.update(null);
    }

    protected void flipEdges(boolean bl) {
        this.m_bFlipEdges = bl;
    }

    private boolean checkNewElements(int n) {
        int n2 = this.m_edgeList[0].m_data[n];
        int n3 = this.m_edgeList[1].m_data[n];
        if (this.m_bCheckAngles && this.m_elementSet.getDimOfElements() == 3) {
            PiVector piVector;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            int n4 = this.m_elementsAtVertex[n2].getSize();
            int n5 = 0;
            while (n5 < n4) {
                piVector = this.m_elementSet.getElement(this.m_elementsAtVertex[n2].m_data[n5]);
                if (!this.m_elementSet.hasTagElement(this.m_elementsAtVertex[n2].m_data[n5], 2) && piVector.m_data[0] != n3 && piVector.m_data[1] != n3 && piVector.m_data[2] != n3) {
                    if (piVector.m_data[0] == n2) {
                        d = PdVector.dist((PdVector)this.m_minVector[n], (PdVector)this.m_elementSet.getVertex(piVector.m_data[1]));
                        d2 = PdVector.dist((PdVector)this.m_minVector[n], (PdVector)this.m_elementSet.getVertex(piVector.m_data[2]));
                        d3 = PdVector.dist((PdVector)this.m_elementSet.getVertex(piVector.m_data[1]), (PdVector)this.m_elementSet.getVertex(piVector.m_data[2]));
                    } else if (piVector.m_data[1] == n2) {
                        d = PdVector.dist((PdVector)this.m_elementSet.getVertex(piVector.m_data[0]), (PdVector)this.m_minVector[n]);
                        d2 = PdVector.dist((PdVector)this.m_elementSet.getVertex(piVector.m_data[0]), (PdVector)this.m_elementSet.getVertex(piVector.m_data[2]));
                        d3 = PdVector.dist((PdVector)this.m_minVector[n], (PdVector)this.m_elementSet.getVertex(piVector.m_data[2]));
                    } else if (piVector.m_data[2] == n2) {
                        d = PdVector.dist((PdVector)this.m_elementSet.getVertex(piVector.m_data[0]), (PdVector)this.m_elementSet.getVertex(piVector.m_data[1]));
                        d2 = PdVector.dist((PdVector)this.m_elementSet.getVertex(piVector.m_data[0]), (PdVector)this.m_minVector[n]);
                        d3 = PdVector.dist((PdVector)this.m_elementSet.getVertex(piVector.m_data[1]), (PdVector)this.m_minVector[n]);
                    }
                    d4 = d > d2 && d > d3 ? (d2 + d3 - d) / d : (d2 > d3 ? (d + d3 - d2) / d2 : (d + d2 - d3) / d3);
                    if (d4 < this.minInOut) {
                        return false;
                    }
                }
                ++n5;
            }
            n5 = this.m_elementsAtVertex[n3].getSize();
            int n6 = 0;
            while (n6 < n5) {
                piVector = this.m_elementSet.getElement(this.m_elementsAtVertex[n3].m_data[n6]);
                if (!this.m_elementSet.hasTagElement(this.m_elementsAtVertex[n3].m_data[n6], 2) && piVector.m_data[0] != n2 && piVector.m_data[1] != n2 && piVector.m_data[2] != n2) {
                    if (piVector.m_data[0] == n3) {
                        d = PdVector.dist((PdVector)this.m_minVector[n], (PdVector)this.m_elementSet.getVertex(piVector.m_data[1]));
                        d2 = PdVector.dist((PdVector)this.m_minVector[n], (PdVector)this.m_elementSet.getVertex(piVector.m_data[2]));
                        d3 = PdVector.dist((PdVector)this.m_elementSet.getVertex(piVector.m_data[1]), (PdVector)this.m_elementSet.getVertex(piVector.m_data[2]));
                    } else if (piVector.m_data[1] == n3) {
                        d = PdVector.dist((PdVector)this.m_elementSet.getVertex(piVector.m_data[0]), (PdVector)this.m_minVector[n]);
                        d2 = PdVector.dist((PdVector)this.m_elementSet.getVertex(piVector.m_data[0]), (PdVector)this.m_elementSet.getVertex(piVector.m_data[2]));
                        d3 = PdVector.dist((PdVector)this.m_minVector[n], (PdVector)this.m_elementSet.getVertex(piVector.m_data[2]));
                    } else if (piVector.m_data[2] == n3) {
                        d = PdVector.dist((PdVector)this.m_elementSet.getVertex(piVector.m_data[0]), (PdVector)this.m_elementSet.getVertex(piVector.m_data[1]));
                        d2 = PdVector.dist((PdVector)this.m_elementSet.getVertex(piVector.m_data[0]), (PdVector)this.m_minVector[n]);
                        d3 = PdVector.dist((PdVector)this.m_elementSet.getVertex(piVector.m_data[1]), (PdVector)this.m_minVector[n]);
                    }
                    d4 = d > d2 && d > d3 ? (d2 + d3 - d) / d : (d2 > d3 ? (d + d3 - d2) / d2 : (d + d2 - d3) / d3);
                    if (d4 < this.minInOut) {
                        return false;
                    }
                }
                ++n6;
            }
        }
        return true;
    }

    private void computeMinInOut() {
        if (this.m_elementSet.getDimOfElements() == 3) {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            int n = 0;
            while (n < this.m_numEl) {
                PiVector piVector = this.m_elementSet.getElement(n);
                d = PdVector.dist((PdVector)this.m_elementSet.getVertex(piVector.m_data[0]), (PdVector)this.m_elementSet.getVertex(piVector.m_data[1]));
                d2 = PdVector.dist((PdVector)this.m_elementSet.getVertex(piVector.m_data[0]), (PdVector)this.m_elementSet.getVertex(piVector.m_data[2]));
                d3 = PdVector.dist((PdVector)this.m_elementSet.getVertex(piVector.m_data[1]), (PdVector)this.m_elementSet.getVertex(piVector.m_data[2]));
                if (d > 1.0E-10 && d2 > 1.0E-10 && d3 > 1.0E-10) {
                    d4 = d > d2 && d > d3 ? (d2 + d3 - d) / d : (d2 > d3 ? (d + d3 - d2) / d2 : (d + d2 - d3) / d3);
                    if (d4 < this.minInOut) {
                        this.minInOut = d4;
                    }
                } else {
                    this.minInOut = 0.0;
                }
                ++n;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void valueChanged(int var1_1) {
        block1: {
            if (var1_1 <= 0 || !(this.m_minValue.m_data[this.m_index.m_data[var1_1]] < this.m_minValue.m_data[this.m_index.m_data[(var1_1 - 1) / 2]])) break block1;
            if (true) ** GOTO lbl11
            do {
                var2_2 = (var1_1 - 1) / 2;
                var3_3 = this.m_index.m_data[var1_1];
                this.m_index.m_data[var1_1] = this.m_index.m_data[var2_2];
                this.m_index.m_data[var2_2] = var3_3;
                this.m_location.m_data[this.m_index.m_data[var1_1]] = var1_1;
                this.m_location.m_data[this.m_index.m_data[var2_2]] = var2_2;
                var1_1 = var2_2;
lbl11:
                // 2 sources

                if (var1_1 <= 0) return;
            } while (this.m_minValue.m_data[this.m_index.m_data[var1_1]] < this.m_minValue.m_data[this.m_index.m_data[(var1_1 - 1) / 2]]);
            return;
        }
        if (var1_1 > this.m_lastNode) return;
        this.checkRelation(var1_1);
    }

    public PwSimplify(PgElementSet pgElementSet) {
        this.m_elementSet = pgElementSet;
        this.m_elementSet.addUpdateListener((PsUpdateIf)this);
        this.init();
    }

    protected void forceSimplify(boolean bl) {
        this.m_bForceSimplify = bl;
    }

    private void computeQuadric(int n) {
        int n2;
        this.m_quadMatrix[n] = new PdMatrix(3);
        this.m_quadVector[n] = new PdVector(3);
        this.m_quadScalar.m_data[n] = 0.0;
        int n3 = 0;
        do {
            this.m_quadVector[n].m_data[n3] = 0.0;
            n2 = 0;
            do {
                this.m_quadMatrix[n].m_data[n3][n2] = 0.0;
            } while (++n2 < 3);
        } while (++n3 < 3);
        n3 = 0;
        while (n3 < this.m_elementsAtVertex[n].getSize()) {
            n2 = this.m_elementsAtVertex[n].m_data[n3];
            if (!this.m_elementSet.hasTagElement(n2, 2)) {
                PdVector pdVector = this.m_elementSet.getElementNormal(n2);
                double d = this.m_elementSet.getAreaOfElement(n2);
                double d2 = PdVector.dot((PdVector)pdVector, (PdVector)this.m_elementSet.getVertex(n));
                int n4 = n;
                this.m_quadScalar.m_data[n4] = this.m_quadScalar.m_data[n4] + d * d2 * d2;
                int n5 = 0;
                do {
                    int n6 = n5;
                    this.m_quadVector[n].m_data[n6] = this.m_quadVector[n].m_data[n6] + d * d2 * pdVector.m_data[n5];
                    int n7 = 0;
                    do {
                        double[] dArray = this.m_quadMatrix[n].m_data[n5];
                        int n8 = n7;
                        dArray[n8] = dArray[n8] + d * pdVector.m_data[n5] * pdVector.m_data[n7];
                    } while (++n7 < 3);
                } while (++n5 < 3);
            }
            ++n3;
        }
    }

    private void removeEdge(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (this.m_elementSet.getDimOfElements() != -1 && this.m_elementSet.getDimOfElements() != 3) {
            this.m_elementSet.setDimOfElements(-1);
        }
        int n8 = this.m_edgeList[0].m_data[n];
        int n9 = this.m_edgeList[1].m_data[n];
        if (this.m_elementSet.hasTagVertex(n9, 13)) {
            this.replaceBndVertex(n9, n8);
        }
        if (this.m_elementSet.hasTagVertex(n9, 13) || this.m_elementSet.hasTagVertex(n8, 13)) {
            this.m_minVector[n].setTag(13);
        }
        int n10 = this.m_elementsAtVertex[n9].getSize();
        int n11 = 0;
        while (n11 < n10) {
            int n12 = this.m_elementsAtVertex[n9].m_data[n11];
            if (!this.m_elementSet.hasTagElement(n12, 2)) {
                PiVector piVector = this.m_elementSet.getElement(n12);
                int n13 = piVector.getSize();
                int n14 = 0;
                while (n14 < n13) {
                    if (piVector.m_data[n14] == n9) {
                        piVector.m_data[n14] = n8;
                        if (piVector.m_data[(n14 + 1) % n13] == n8 || piVector.m_data[(n14 - 1 + n13) % n13] == n8) {
                            int n15;
                            int n16;
                            int n17;
                            if (n13 < 4) {
                                int n18;
                                n7 = -1;
                                int n19 = -1;
                                n17 = -1;
                                if (this.m_elementSet.getNeighbours() != null) {
                                    PiVector piVector2;
                                    if (piVector.m_data[(n14 + 1) % n13] == n8) {
                                        n7 = this.m_elementSet.getNeighbour((int)n12).m_data[n14];
                                        n19 = this.m_elementSet.getNeighbour((int)n12).m_data[(n14 + 1) % n13];
                                        n17 = piVector.m_data[(n14 + 2) % n13];
                                    } else {
                                        n7 = this.m_elementSet.getNeighbour((int)n12).m_data[(n14 - 1 + n13) % n13];
                                        n19 = this.m_elementSet.getNeighbour((int)n12).m_data[n14];
                                        n17 = piVector.m_data[(n14 + 1) % n13];
                                    }
                                    if (n7 != -1) {
                                        piVector2 = this.m_elementSet.getNeighbour(n7);
                                        n16 = piVector2.getSize();
                                        n18 = 0;
                                        while (n18 < n16) {
                                            if (piVector2.m_data[n18] == n12) {
                                                piVector2.m_data[n18] = n19;
                                            }
                                            ++n18;
                                        }
                                    }
                                    if (n19 != -1) {
                                        piVector2 = this.m_elementSet.getNeighbour(n19);
                                        n16 = piVector2.getSize();
                                        n18 = 0;
                                        while (n18 < n16) {
                                            if (piVector2.m_data[n18] == n12) {
                                                piVector2.m_data[n18] = n7;
                                            }
                                            ++n18;
                                        }
                                    }
                                }
                                if (n7 == -1 && n19 == -1) {
                                    this.replaceBndVertex(n17, n8);
                                }
                                this.m_elementSet.setTagElement(n12, 2);
                                this.m_numEl += -1;
                                n15 = -1;
                                n16 = this.m_elementsAtVertex[n17].getSize();
                                n18 = 0;
                                while (n18 < n16) {
                                    if (this.m_elementsAtVertex[n17].m_data[n18] == n12) {
                                        n15 = n18;
                                    }
                                    ++n18;
                                }
                                n18 = n15;
                                while (n18 < n16 - 1) {
                                    this.m_elementsAtVertex[n17].m_data[n18] = this.m_elementsAtVertex[n17].m_data[n18 + 1];
                                    ++n18;
                                }
                                this.m_elementsAtVertex[n17].setSize(n16 - 1);
                            } else {
                                n7 = piVector.m_data[(n14 + 1) % n13] == n8 ? (n14 - 1 + n13) % n13 : (n14 - 2 + n13) % n13;
                                PiVector piVector3 = this.m_elementSet.getNeighbour(n12);
                                n17 = piVector3.getSize();
                                n15 = n7;
                                while (n15 < n17 - 1) {
                                    piVector3.m_data[n15] = piVector3.m_data[n15 + 1];
                                    ++n15;
                                }
                                if (n14 == 0 || n14 == 1 && n7 == n13 - 1) {
                                    n15 = piVector3.m_data[0];
                                    n16 = 0;
                                    while (n16 < n17 - 1) {
                                        piVector3.m_data[n16] = piVector3.m_data[n16 + 1];
                                        ++n16;
                                    }
                                    piVector3.m_data[piVector3.getSize() - 2] = n15;
                                }
                                n15 = piVector.getSize();
                                n16 = n14;
                                while (n16 < n15 - 1) {
                                    piVector.m_data[n16] = piVector.m_data[n16 + 1];
                                    ++n16;
                                }
                                piVector.setSize(--n13);
                                piVector3.setSize(n13);
                            }
                        } else {
                            n7 = this.m_elementsAtVertex[n8].getSize();
                            this.m_elementsAtVertex[n8].setSize(n7 + 1);
                            this.m_elementsAtVertex[n8].m_data[n7] = n12;
                        }
                    }
                    ++n14;
                }
            }
            ++n11;
        }
        if (this.m_elementSet.hasVertexTextures() || this.m_elementSet.hasVertexColors() || this.m_elementSet.getNumVectorFields() > 0) {
            double d;
            n11 = this.m_elementSet.getNumVectorFields();
            double d2 = PdVector.dist((PdVector)this.m_minVector[n], (PdVector)this.m_elementSet.getVertex(n8));
            if (d2 + (d = PdVector.dist((PdVector)this.m_minVector[n], (PdVector)this.m_elementSet.getVertex(n9))) > 1.0E-10) {
                d2 /= d2 + d;
                d = 1.0 - d2;
            } else {
                d2 = 0.5;
                d = 0.5;
            }
            if (this.m_elementSet.hasVertexTextures()) {
                PdVector[] pdVectorArray = this.m_elementSet.getVertexTextures();
                pdVectorArray[n8].blend(d, pdVectorArray[n8], d2, pdVectorArray[n9]);
            }
            if (this.m_elementSet.hasVertexColors()) {
                Color color = this.m_elementSet.getVertexColor(n8);
                Color color2 = this.m_elementSet.getVertexColor(n9);
                color = PdColor.blend((double)d, (Color)color, (double)d2, (Color)color2);
            }
            if (n11 > 0) {
                int n20 = 0;
                while (n20 < n11) {
                    PgVectorField pgVectorField = this.m_elementSet.getVectorField(n20);
                    if (pgVectorField.getBasedOn() == 0) {
                        PdVector[] pdVectorArray = pgVectorField.getVectors();
                        pdVectorArray[n8].blend(d, pdVectorArray[n8], d2, pdVectorArray[n9]);
                    }
                    ++n20;
                }
            }
        }
        this.m_elementSet.setVertex(n8, this.m_minVector[n]);
        PiVector piVector = new PiVector(this.m_elementsAtVertex[n8].getSize());
        int n21 = 0;
        n7 = this.m_elementsAtVertex[n8].getSize();
        int n22 = 0;
        while (n22 < n7) {
            if (!this.m_elementSet.hasTagElement(this.m_elementsAtVertex[n8].m_data[n22], 2)) {
                piVector.m_data[n21] = this.m_elementsAtVertex[n8].m_data[n22];
                ++n21;
            }
            ++n22;
        }
        piVector.setSize(n21);
        this.m_elementsAtVertex[n8] = piVector;
        this.m_elementsAtVertex[n9].setSize(0);
        n21 = 0;
        PiVector piVector4 = new PiVector(this.m_edgesAtVertex[n8].getSize() + this.m_edgesAtVertex[n9].getSize() - 1);
        int n23 = this.m_edgesAtVertex[n8].getSize();
        int n24 = 0;
        while (n24 < n23) {
            n22 = this.m_edgesAtVertex[n8].m_data[n24];
            if (this.m_edgeList[1].m_data[n22] == n9) {
                if (this.m_location.m_data[n22] != -1) {
                    this.deleteValue(this.m_location.m_data[n22]);
                }
            } else {
                piVector4.m_data[n21] = n22;
                ++n21;
            }
            ++n24;
        }
        n24 = this.m_edgesAtVertex[n9].getSize();
        int n25 = 0;
        while (n25 < n24) {
            n22 = this.m_edgesAtVertex[n9].m_data[n25];
            if (this.m_edgeList[0].m_data[n22] != n8) {
                if (this.m_edgeList[0].m_data[n22] == n9) {
                    this.m_edgeList[0].m_data[n22] = n8;
                } else if (n8 > this.m_edgeList[0].m_data[n22]) {
                    this.m_edgeList[1].m_data[n22] = n8;
                } else {
                    this.m_edgeList[1].m_data[n22] = this.m_edgeList[0].m_data[n22];
                    this.m_edgeList[0].m_data[n22] = n8;
                }
                n6 = 0;
                int n26 = 0;
                while (n26 < n21) {
                    if (this.m_edgeList[0].m_data[n22] == this.m_edgeList[0].m_data[piVector4.m_data[n26]] && this.m_edgeList[1].m_data[n22] == this.m_edgeList[1].m_data[piVector4.m_data[n26]]) {
                        n6 = 1;
                    }
                    ++n26;
                }
                if (n6 == 0) {
                    piVector4.m_data[n21] = n22;
                    ++n21;
                } else {
                    this.deleteValue(this.m_location.m_data[n22]);
                    if (this.m_edgeList[0].m_data[n22] == n8) {
                        PiVector piVector5 = new PiVector(this.m_edgesAtVertex[this.m_edgeList[1].m_data[n22]].getSize() - 1);
                        n5 = 0;
                        n4 = piVector5.getSize();
                        n3 = 0;
                        while (n3 < n4 + 1) {
                            if (this.m_edgesAtVertex[this.m_edgeList[1].m_data[n22]].m_data[n3] != n22) {
                                piVector5.m_data[n5] = this.m_edgesAtVertex[this.m_edgeList[1].m_data[n22]].m_data[n3];
                                ++n5;
                            }
                            ++n3;
                        }
                        this.m_edgesAtVertex[this.m_edgeList[1].m_data[n22]] = piVector5;
                    } else {
                        PiVector piVector6 = new PiVector(this.m_edgesAtVertex[this.m_edgeList[0].m_data[n22]].getSize() - 1);
                        n5 = 0;
                        n4 = piVector6.getSize();
                        n3 = 0;
                        while (n3 < n4 + 1) {
                            if (this.m_edgesAtVertex[this.m_edgeList[0].m_data[n22]].m_data[n3] != n22) {
                                piVector6.m_data[n5] = this.m_edgesAtVertex[this.m_edgeList[0].m_data[n22]].m_data[n3];
                                ++n5;
                            }
                            ++n3;
                        }
                        this.m_edgesAtVertex[this.m_edgeList[0].m_data[n22]] = piVector6;
                    }
                }
            }
            ++n25;
        }
        piVector4.setSize(n21);
        this.m_edgesAtVertex[n8] = piVector4;
        this.m_edgesAtVertex[n9].setSize(0);
        if (this.m_bCheckNormals || this.m_bCheckAngles) {
            this.computeQuadric(n8);
            n25 = this.m_edgesAtVertex[n8].getSize();
            n6 = 0;
            while (n6 < n25) {
                if (this.m_edgeList[0].m_data[this.m_edgesAtVertex[n8].m_data[n6]] == n8) {
                    this.computeQuadric(this.m_edgeList[1].m_data[this.m_edgesAtVertex[n8].m_data[n6]]);
                } else {
                    this.computeQuadric(this.m_edgeList[0].m_data[this.m_edgesAtVertex[n8].m_data[n6]]);
                }
                ++n6;
            }
        } else {
            this.m_quadMatrix[n8].add(this.m_quadMatrix[n9]);
            this.m_quadVector[n8].add(this.m_quadVector[n9]);
            int n27 = n8;
            this.m_quadScalar.m_data[n27] = this.m_quadScalar.m_data[n27] + this.m_quadScalar.m_data[n9];
        }
        if (!this.m_bBigNeighbourhood) {
            n25 = this.m_edgesAtVertex[n8].getSize();
            n6 = 0;
            while (n6 < n25) {
                if (this.m_location.m_data[this.m_edgesAtVertex[n8].m_data[n6]] != -1) {
                    this.computeMinimum(this.m_edgesAtVertex[n8].m_data[n6]);
                    this.valueChanged(this.m_location.m_data[this.m_edgesAtVertex[n8].m_data[n6]]);
                }
                ++n6;
            }
            return;
        }
        PiVector piVector7 = new PiVector(this.m_edgesAtVertex2[n8].getSize() + this.m_edgesAtVertex2[n9].getSize());
        n21 = 0;
        n6 = this.m_edgesAtVertex2[n8].getSize();
        int n28 = 0;
        while (n28 < n6) {
            n5 = this.m_edgesAtVertex2[n8].m_data[n28];
            if (!(this.m_edgeList[0].m_data[n5] == n9 && this.m_edgeList[1].m_data[n5] == n8 || this.m_edgeList[0].m_data[n5] == n8 && this.m_edgeList[1].m_data[n5] == n9 || this.m_location.m_data[n5] == -1)) {
                piVector7.m_data[n21] = n5;
                ++n21;
            }
            ++n28;
        }
        n28 = this.m_edgesAtVertex2[n9].getSize();
        n5 = 0;
        while (n5 < n28) {
            n4 = this.m_edgesAtVertex2[n9].m_data[n5];
            if (!(this.m_edgeList[0].m_data[n4] == n8 && this.m_edgeList[1].m_data[n4] == n9 || this.m_edgeList[0].m_data[n4] == n9 && this.m_edgeList[1].m_data[n4] == n8)) {
                n3 = 0;
                n2 = 0;
                while (n2 < n21) {
                    if (piVector7.m_data[n2] == n4) {
                        n3 = 1;
                    }
                    ++n2;
                }
                if (n3 == 0 && this.m_location.m_data[n4] != -1) {
                    piVector7.m_data[n21] = n4;
                    ++n21;
                }
            }
            ++n5;
        }
        piVector7.setSize(n21);
        this.m_edgesAtVertex2[n8] = piVector7;
        this.m_edgesAtVertex2[n9].setSize(0);
        n5 = this.m_edgesAtVertex2[n8].getSize();
        n4 = 0;
        while (n4 < n5) {
            n3 = this.m_edgesAtVertex2[n8].m_data[n4];
            if (this.m_location.m_data[n3] != -1) {
                this.computeMinimum(n3);
                this.valueChanged(this.m_location.m_data[n3]);
            }
            ++n4;
        }
        n5 = this.m_edgesAtVertex2[n8].getSize();
        int n29 = 0;
        while (n29 < n5) {
            n4 = this.m_edgesAtVertex2[n8].m_data[n29];
            if (this.m_location.m_data[n4] != -1) {
                int n30;
                int n31;
                int n32;
                PiVector piVector8;
                int n33;
                int n34;
                PiVector piVector9;
                int n35 = this.m_elementsAtVertex[this.m_edgeList[0].m_data[n4]].getSize();
                int n36 = 0;
                while (n36 < n35) {
                    piVector9 = this.m_elementSet.getElement(this.m_elementsAtVertex[this.m_edgeList[0].m_data[n4]].m_data[n36]);
                    if (!this.m_elementSet.hasTagElement(this.m_elementsAtVertex[this.m_edgeList[0].m_data[n4]].m_data[n36], 2)) {
                        n34 = piVector9.getSize();
                        n33 = 0;
                        while (n33 < n34) {
                            piVector8 = new PiVector(this.m_edgesAtVertex2[piVector9.m_data[n33]].getSize() + 1);
                            n32 = 0;
                            n2 = 0;
                            n31 = this.m_edgesAtVertex2[piVector9.m_data[n33]].getSize();
                            n30 = 0;
                            while (n30 < n31) {
                                n3 = this.m_edgesAtVertex2[piVector9.m_data[n33]].m_data[n30];
                                if (this.m_location.m_data[n3] != -1) {
                                    piVector8.m_data[n32] = n3;
                                    ++n32;
                                    if (n4 == n3) {
                                        n2 = 1;
                                    }
                                }
                                ++n30;
                            }
                            if (n2 == 0) {
                                piVector8.m_data[n32] = n4;
                                piVector8.setSize(++n32);
                                this.m_edgesAtVertex2[piVector9.m_data[n33]] = piVector8;
                            }
                            ++n33;
                        }
                    }
                    ++n36;
                }
                n35 = this.m_elementsAtVertex[this.m_edgeList[1].m_data[n4]].getSize();
                n36 = 0;
                while (n36 < n35) {
                    piVector9 = this.m_elementSet.getElement(this.m_elementsAtVertex[this.m_edgeList[1].m_data[n4]].m_data[n36]);
                    if (!this.m_elementSet.hasTagElement(this.m_elementsAtVertex[this.m_edgeList[1].m_data[n4]].m_data[n36], 2)) {
                        n34 = piVector9.getSize();
                        n33 = 0;
                        while (n33 < n34) {
                            piVector8 = new PiVector(this.m_edgesAtVertex2[piVector9.m_data[n33]].getSize() + 1);
                            n32 = 0;
                            n2 = 0;
                            n31 = this.m_edgesAtVertex2[piVector9.m_data[n33]].getSize();
                            n30 = 0;
                            while (n30 < n31) {
                                n3 = this.m_edgesAtVertex2[piVector9.m_data[n33]].m_data[n30];
                                if (this.m_location.m_data[n3] != -1) {
                                    piVector8.m_data[n32] = n3;
                                    ++n32;
                                    if (n4 == n3) {
                                        n2 = 1;
                                    }
                                }
                                ++n30;
                            }
                            if (n2 == 0) {
                                piVector8.m_data[n32] = n4;
                                piVector8.setSize(++n32);
                                this.m_edgesAtVertex2[piVector9.m_data[n33]] = piVector8;
                            }
                            ++n33;
                        }
                    }
                    ++n36;
                }
            }
            ++n29;
        }
    }

    public boolean update(Object object) {
        if (!this.m_bUpdateSendet) {
            if (object == this.m_elementSet) {
                this.init();
                this.m_infoPanel.update((Object)this.m_elementSet);
                return true;
            }
            if (object == this.m_infoPanel) {
                return this.m_parent.update((Object)this);
            }
            return true;
        }
        return true;
    }

    protected void checkNormals(boolean bl) {
        this.m_bCheckNormals = bl;
    }

    private boolean checkNormals(int n, boolean bl) {
        int n2 = this.m_edgeList[0].m_data[n];
        int n3 = this.m_edgeList[1].m_data[n];
        if (this.m_bCheckNormals) {
            PdVector pdVector;
            PdVector pdVector2;
            PdVector pdVector3;
            PdVector pdVector4;
            PdVector pdVector5;
            int n4;
            PdVector[] pdVectorArray;
            PiVector piVector = new PiVector(this.m_elementsAtVertex[n2].getSize() + this.m_elementsAtVertex[n3].getSize());
            PdVector[] pdVectorArray2 = new PdVector[this.m_elementsAtVertex[n2].getSize() + this.m_elementsAtVertex[n3].getSize()];
            int n5 = 0;
            int n6 = this.m_elementsAtVertex[n2].getSize();
            int n7 = 0;
            while (n7 < n6) {
                PiVector piVector2 = this.m_elementSet.getElement(this.m_elementsAtVertex[n2].m_data[n7]);
                if (!this.m_elementSet.hasTagElement(this.m_elementsAtVertex[n2].m_data[n7], 2)) {
                    pdVectorArray = new PdVector[piVector2.getSize()];
                    int n8 = 0;
                    n4 = piVector2.getSize();
                    int n9 = 0;
                    while (n9 < n4) {
                        if (piVector2.m_data[n9] == n2) {
                            pdVectorArray[n8] = new PdVector(this.m_elementSet.getDimOfVertices());
                            pdVectorArray[n8].copy(this.m_minVector[n]);
                            ++n8;
                        } else if (piVector2.m_data[n9] != n3) {
                            pdVectorArray[n8] = new PdVector(this.m_elementSet.getDimOfVertices());
                            pdVectorArray[n8].copy(this.m_elementSet.getVertex(piVector2.m_data[n9]));
                            ++n8;
                        }
                        ++n9;
                    }
                    if (n8 > 2) {
                        PdVector pdVector6;
                        if ((this.m_elementSet.getDimOfVertices() == 1 || this.m_elementSet.getDimOfVertices() == 2) && this.m_elementSet.getDimOfVectors() == 3) {
                            pdVector6 = new PdVector(3);
                            pdVector6.set(0.0, 0.0, 1.0);
                        } else {
                            pdVector6 = new PdVector(this.m_elementSet.getDimOfVectors());
                            pdVector5 = new PdVector(this.m_elementSet.getDimOfVertices());
                            pdVector4 = new PdVector(this.m_elementSet.getDimOfVertices());
                            pdVector3 = new PdVector(this.m_elementSet.getDimOfVectors());
                            PdVector.setConstant((PdVector)pdVector6, (double)0.0);
                            int n10 = 0;
                            while (n10 < n8) {
                                PdVector pdVector7 = pdVectorArray[n10];
                                pdVector2 = pdVectorArray[(n10 + 1) % n8];
                                pdVector = pdVectorArray[(n10 + 2) % n8];
                                pdVector5.sub(pdVector7, pdVector2);
                                pdVector4.sub(pdVector, pdVector2);
                                pdVector3.cross(pdVector4, pdVector5);
                                if (pdVector3.normalize()) {
                                    pdVector6.add(pdVector3);
                                }
                                ++n10;
                            }
                            pdVector6.normalize();
                        }
                        if (PdVector.angle((PdVector)pdVector6, (PdVector)this.m_elementSet.getElementNormal(this.m_elementsAtVertex[n2].m_data[n7])) > this.m_maxAngle) {
                            return false;
                        }
                        piVector.m_data[n5] = this.m_elementsAtVertex[n2].m_data[n7];
                        pdVectorArray2[n5] = pdVector6;
                        ++n5;
                    }
                }
                ++n7;
            }
            n7 = this.m_elementsAtVertex[n3].getSize();
            int n11 = 0;
            while (n11 < n7) {
                pdVectorArray = this.m_elementSet.getElement(this.m_elementsAtVertex[n3].m_data[n11]);
                if (!this.m_elementSet.hasTagElement(this.m_elementsAtVertex[n3].m_data[n11], 2)) {
                    PdVector[] pdVectorArray3 = new PdVector[pdVectorArray.getSize()];
                    n4 = 0;
                    int n12 = pdVectorArray.getSize();
                    int n13 = 0;
                    while (n13 < n12) {
                        if (pdVectorArray.m_data[n13] == n3) {
                            pdVectorArray3[n4] = new PdVector(this.m_elementSet.getDimOfVertices());
                            pdVectorArray3[n4].copy(this.m_minVector[n]);
                            ++n4;
                        } else if (pdVectorArray.m_data[n13] != n2) {
                            pdVectorArray3[n4] = new PdVector(this.m_elementSet.getDimOfVertices());
                            pdVectorArray3[n4].copy(this.m_elementSet.getVertex(pdVectorArray.m_data[n13]));
                            ++n4;
                        }
                        ++n13;
                    }
                    if (n4 > 2) {
                        PdVector pdVector8;
                        if ((this.m_elementSet.getDimOfVertices() == 1 || this.m_elementSet.getDimOfVertices() == 2) && this.m_elementSet.getDimOfVectors() == 3) {
                            pdVector8 = new PdVector(3);
                            pdVector8.set(0.0, 0.0, 1.0);
                        } else {
                            pdVector8 = new PdVector(this.m_elementSet.getDimOfVectors());
                            pdVector4 = new PdVector(this.m_elementSet.getDimOfVertices());
                            pdVector3 = new PdVector(this.m_elementSet.getDimOfVertices());
                            PdVector pdVector9 = new PdVector(this.m_elementSet.getDimOfVectors());
                            PdVector.setConstant((PdVector)pdVector8, (double)0.0);
                            int n14 = 0;
                            while (n14 < n4) {
                                pdVector2 = pdVectorArray3[n14];
                                pdVector = pdVectorArray3[(n14 + 1) % n4];
                                pdVector5 = pdVectorArray3[(n14 + 2) % n4];
                                pdVector4.sub(pdVector2, pdVector);
                                pdVector3.sub(pdVector5, pdVector);
                                pdVector9.cross(pdVector3, pdVector4);
                                if (pdVector9.normalize()) {
                                    pdVector8.add(pdVector9);
                                }
                                ++n14;
                            }
                            pdVector8.normalize();
                        }
                        if (PdVector.angle((PdVector)pdVector8, (PdVector)this.m_elementSet.getElementNormal(this.m_elementsAtVertex[n3].m_data[n11])) > this.m_maxAngle) {
                            return false;
                        }
                        piVector.m_data[n5] = this.m_elementsAtVertex[n3].m_data[n11];
                        pdVectorArray2[n5] = pdVector8;
                        ++n5;
                    }
                }
                ++n11;
            }
            if (bl) {
                n11 = 0;
                while (n11 < n5) {
                    this.m_elementSet.getElementNormal(piVector.m_data[n11]).copy(pdVectorArray2[n11]);
                    ++n11;
                }
            }
        }
        return true;
    }

    protected void retainBoundary(boolean bl) {
        this.m_bRetainBoundary = bl;
    }

    public boolean simplify(int n) {
        int n2;
        int n3;
        int n4;
        if (this.m_bFlipEdges) {
            this.m_elementSet.flipEdges();
            this.init();
        }
        int n5 = 0;
        int n6 = 5 * this.m_edgeList[0].getSize();
        while (n < this.m_numEl && this.m_maxIndex >= 0 && n5 < n6) {
            boolean bl = false;
            if ((!this.m_bBigNeighbourhood || this.m_bBigNeighbourhood && !this.m_isDenied[this.m_index.m_data[0]]) && !this.checkEdge(this.m_index.m_data[0]) && this.checkNewElements(this.m_index.m_data[0]) && this.checkNormals(this.m_index.m_data[0], true)) {
                bl = true;
            }
            if (bl) {
                this.removeEdge(this.m_index.m_data[0]);
                n6 = 5 * this.m_maxIndex;
                n5 = 0;
                this.m_infoPanel.update((Object)this);
                continue;
            }
            this.m_isDenied[this.m_index.m_data[0]] = true;
            if (Math.abs(this.m_minValue.m_data[this.m_index.m_data[0]]) < 1.0E-10) {
                this.m_minValue.m_data[this.m_index.m_data[0]] = 1.0;
            } else {
                int n7 = this.m_index.m_data[0];
                this.m_minValue.m_data[n7] = this.m_minValue.m_data[n7] * 2.0;
            }
            this.valueChanged(0);
            if (++n5 != n6) continue;
            boolean bl2 = true;
            n4 = 0;
            while (n4 <= this.m_maxIndex) {
                if (!this.m_isDenied[this.m_index.m_data[n4]]) {
                    bl2 = false;
                }
                ++n4;
            }
            if (!bl2) {
                n5 = 0;
                continue;
            }
            if (!this.m_bForceSimplify) {
                n4 = 1;
                if (!this.m_bBigNeighbourhood) {
                    n3 = this.m_edgeList[0].getSize();
                    n2 = 0;
                    while (n2 < n3) {
                        if (this.m_location.m_data[n2] != -1) {
                            this.computeMinimum(n2);
                            this.valueChanged(this.m_location.m_data[n2]);
                        }
                        ++n2;
                    }
                    n2 = 0;
                    while (n2 <= this.m_maxIndex) {
                        if (!this.checkEdge(this.m_index.m_data[n2]) && this.checkNewElements(this.m_index.m_data[n2]) && this.checkNormals(this.m_index.m_data[n2], false)) {
                            this.m_isDenied[this.m_index.m_data[n2]] = false;
                            n4 = 0;
                            n5 = 0;
                        }
                        ++n2;
                    }
                }
                if (n4 != 1) continue;
                PsDebug.warning((String)"Simplifying stopped before reaching given number of elements because of normal or thin triangle criterium");
                continue;
            }
            n4 = 1;
            n3 = 0;
            n2 = this.m_edgeList[0].getSize();
            int n8 = 0;
            while (n8 < n2) {
                if (this.m_location.m_data[n8] != -1) {
                    this.computeMinimum(n8);
                    this.valueChanged(this.m_location.m_data[n8]);
                }
                ++n8;
            }
            if (!this.m_bBigNeighbourhood) {
                n8 = 0;
                while (n8 <= this.m_maxIndex) {
                    if (this.checkEdge(this.m_index.m_data[n8])) {
                        ++n3;
                    } else if (this.checkNewElements(this.m_index.m_data[n8]) && this.checkNormals(this.m_index.m_data[n8], false)) {
                        this.m_isDenied[this.m_index.m_data[n8]] = false;
                        n4 = 0;
                        n5 = 0;
                    }
                    ++n8;
                }
            } else {
                n8 = 0;
                while (n8 <= this.m_maxIndex) {
                    if (this.checkEdge(this.m_index.m_data[n8])) {
                        ++n3;
                    }
                    ++n8;
                }
            }
            if (n3 <= this.m_maxIndex) {
                if (n4 != 1) continue;
                if (this.m_maxAngle < 180.0) {
                    this.m_maxAngle += 2.5;
                }
                this.minInOut *= 0.9;
                PsDebug.message((String)"PwSimplify: Criteria changed:");
                if (this.m_bCheckNormals) {
                    PsDebug.message((String)("Maximal normal angle: " + this.m_maxAngle));
                }
                if (this.m_bCheckAngles) {
                    PsDebug.message((String)("Thin triangle determination value: " + this.minInOut));
                }
                n5 = 0;
                continue;
            }
            PsDebug.warning((String)"Simplifying stopped before reaching given number of elements to avoid degenerating of surface");
        }
        boolean[] blArray = new boolean[this.m_elementSet.getNumBoundaries()];
        if (this.m_elementSet.hasBoundary()) {
            PgBndPolygon[] pgBndPolygonArray = this.m_elementSet.getBoundaries();
            n4 = 0;
            while (n4 < pgBndPolygonArray.length) {
                blArray[n4] = pgBndPolygonArray[n4].hasTag(2);
                ++n4;
            }
        }
        this.m_elementSet.removeMarkedElements();
        this.m_elementSet.makeNeighbour();
        this.m_elementSet.makeVertexNormals();
        if (this.m_elementSet.hasBoundary()) {
            PgBndPolygon[] pgBndPolygonArray = this.m_elementSet.getBoundaries();
            n4 = 0;
            n3 = pgBndPolygonArray.length;
            n2 = 0;
            while (n2 < n3) {
                if (!blArray[n2]) {
                    pgBndPolygonArray[n2].clearTag(2);
                } else {
                    pgBndPolygonArray[n2].setTag(2);
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < n3) {
                if (pgBndPolygonArray[n2].getNumVertices() == 3) {
                    PiVector piVector = pgBndPolygonArray[n2].getVertexInd();
                    if (piVector.m_data[0] == piVector.m_data[2]) {
                        piVector.m_data[1] = piVector.m_data[0];
                        n4 = 1;
                    }
                }
                ++n2;
            }
            if (n4 == 1) {
                this.replaceBndVertex(0, 0);
            }
            n3 = pgBndPolygonArray.length;
            n2 = 0;
            while (n2 < n3) {
                if (!pgBndPolygonArray[n2].makeElementInd()) {
                    this.m_elementSet.removeBoundaries();
                    break;
                }
                ++n2;
            }
        }
        this.m_elementSet.removeUnusedVertices();
        this.m_elementSet.update((Object)this.m_elementSet);
        return true;
    }

    private void generateEdgesAtVertex2() {
        this.m_edgesAtVertex2 = new PiVector[this.m_elementSet.getNumVertices()];
        int n = -1;
        int n2 = this.m_edgeList[0].getSize();
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            PiVector piVector;
            int n9 = this.m_edgeList[0].m_data[n3];
            int n10 = this.m_edgeList[1].m_data[n3];
            int n11 = this.m_elementsAtVertex[n9].getSize();
            int n12 = 0;
            while (n12 < n11) {
                piVector = this.m_elementSet.getElement(this.m_elementsAtVertex[n9].m_data[n12]);
                n8 = piVector.getSize();
                n7 = 0;
                while (n7 < n8) {
                    n = piVector.m_data[n7];
                    if (this.m_edgesAtVertex2[n] == null || this.m_edgesAtVertex2[n].getSize() == 0) {
                        this.m_edgesAtVertex2[n] = new PiVector(1);
                        this.m_edgesAtVertex2[n].m_data[0] = n3;
                    } else {
                        n6 = 0;
                        n5 = this.m_edgesAtVertex2[n].getSize();
                        n4 = 0;
                        while (n4 < n5) {
                            if (this.m_edgesAtVertex2[n].m_data[n4] == n3) {
                                n6 = 1;
                            }
                            ++n4;
                        }
                        if (n6 == 0) {
                            n4 = this.m_edgesAtVertex2[n].getSize();
                            this.m_edgesAtVertex2[n].setSize(n4 + 1);
                            this.m_edgesAtVertex2[n].m_data[n4] = n3;
                        }
                    }
                    ++n7;
                }
                ++n12;
            }
            n12 = this.m_elementsAtVertex[n10].getSize();
            n8 = 0;
            while (n8 < n12) {
                piVector = this.m_elementSet.getElement(this.m_elementsAtVertex[n10].m_data[n8]);
                n7 = piVector.getSize();
                n6 = 0;
                while (n6 < n7) {
                    n = piVector.m_data[n6];
                    if (this.m_edgesAtVertex2[n] == null || this.m_edgesAtVertex2[n].getSize() == 0) {
                        this.m_edgesAtVertex2[n] = new PiVector(1);
                        this.m_edgesAtVertex2[n].m_data[0] = n3;
                    } else {
                        n5 = 0;
                        n4 = this.m_edgesAtVertex2[n].getSize();
                        int n13 = 0;
                        while (n13 < n4) {
                            if (this.m_edgesAtVertex2[n].m_data[n13] == n3) {
                                n5 = 1;
                            }
                            ++n13;
                        }
                        if (n5 == 0) {
                            n13 = this.m_edgesAtVertex2[n].getSize();
                            this.m_edgesAtVertex2[n].setSize(n13 + 1);
                            this.m_edgesAtVertex2[n].m_data[n13] = n3;
                        }
                    }
                    ++n6;
                }
                ++n8;
            }
            ++n3;
        }
    }

    private void replaceBndVertex(int n, int n2) {
        if (this.m_elementSet.hasBoundary()) {
            int n3;
            int n4;
            PgBndPolygon[] pgBndPolygonArray = this.m_elementSet.getBoundaries();
            PiVector piVector = new PiVector();
            int n5 = 0;
            int n6 = pgBndPolygonArray.length;
            int n7 = 0;
            while (n7 < n6) {
                PiVector piVector2 = pgBndPolygonArray[n7].getVertexInd();
                n4 = pgBndPolygonArray[n7].getNumVertices();
                n3 = -1;
                piVector.setSize(piVector2.getSize());
                int n8 = 0;
                int n9 = 0;
                while (n9 < n4) {
                    if (piVector2.m_data[n9] == n) {
                        piVector2.m_data[n9] = n2;
                    }
                    if (piVector2.m_data[n9] != n3) {
                        piVector.m_data[n8] = piVector2.m_data[n9];
                        ++n8;
                        n3 = piVector2.m_data[n9];
                    }
                    ++n9;
                }
                if (n8 > 1) {
                    ++n5;
                }
                pgBndPolygonArray[n7].setNumVertices(n8);
                piVector2.copy(piVector);
                ++n7;
            }
            if (n5 != n6) {
                if (n5 != 0) {
                    PgBndPolygon[] pgBndPolygonArray2 = new PgBndPolygon[n5];
                    n4 = 0;
                    n3 = 0;
                    while (n3 < n6) {
                        if (pgBndPolygonArray[n3].getNumVertices() > 1) {
                            pgBndPolygonArray2[n4] = pgBndPolygonArray[n3];
                            ++n4;
                        }
                        ++n3;
                    }
                    this.m_elementSet.setBoundary(pgBndPolygonArray2);
                    return;
                }
                this.m_elementSet.setBoundary(null);
            }
        }
    }

    private void checkRelation(int n) {
        int n2 = 2 * n + 1;
        int n3 = 2 * n + 2;
        if (this.m_index.m_data[n2] == -1 || this.m_minValue.m_data[this.m_index.m_data[n]] < this.m_minValue.m_data[this.m_index.m_data[n2]]) {
            if (this.m_index.m_data[n3] != -1 && !(this.m_minValue.m_data[this.m_index.m_data[n]] < this.m_minValue.m_data[this.m_index.m_data[n3]])) {
                int n4 = this.m_index.m_data[n3];
                this.m_index.m_data[n3] = this.m_index.m_data[n];
                this.m_index.m_data[n] = n4;
                this.m_location.m_data[this.m_index.m_data[n]] = n;
                this.m_location.m_data[this.m_index.m_data[n3]] = n3;
                if (n3 <= this.m_lastNode) {
                    this.checkRelation(n3);
                    return;
                }
            }
        } else if (this.m_index.m_data[n3] == -1 || this.m_minValue.m_data[this.m_index.m_data[n2]] < this.m_minValue.m_data[this.m_index.m_data[n3]]) {
            int n5 = this.m_index.m_data[n2];
            this.m_index.m_data[n2] = this.m_index.m_data[n];
            this.m_index.m_data[n] = n5;
            this.m_location.m_data[this.m_index.m_data[n]] = n;
            this.m_location.m_data[this.m_index.m_data[n2]] = n2;
            if (n2 <= this.m_lastNode) {
                this.checkRelation(n2);
                return;
            }
        } else {
            int n6 = this.m_index.m_data[n3];
            this.m_index.m_data[n3] = this.m_index.m_data[n];
            this.m_index.m_data[n] = n6;
            this.m_location.m_data[this.m_index.m_data[n]] = n;
            this.m_location.m_data[this.m_index.m_data[n3]] = n3;
            if (n3 <= this.m_lastNode) {
                this.checkRelation(n3);
            }
        }
    }

    private boolean checkEdge(int n) {
        int n2;
        int n3;
        int n4;
        int n5 = this.m_edgeList[0].m_data[n];
        int n6 = this.m_edgeList[1].m_data[n];
        int n7 = 0;
        int n8 = this.m_edgesAtVertex[n5].getSize();
        int n9 = 0;
        while (n9 < n8) {
            int n10 = this.m_edgesAtVertex[n5].m_data[n9];
            n4 = this.m_edgesAtVertex[n6].getSize();
            n3 = 0;
            while (n3 < n4) {
                int n11 = this.m_edgesAtVertex[n6].m_data[n3];
                if (this.m_edgeList[0].m_data[n10] == n5) {
                    if (this.m_edgeList[0].m_data[n11] == n6) {
                        if (this.m_edgeList[1].m_data[n10] == this.m_edgeList[1].m_data[n11]) {
                            ++n7;
                        }
                    } else if (this.m_edgeList[1].m_data[n10] == this.m_edgeList[0].m_data[n11]) {
                        ++n7;
                    }
                } else if (this.m_edgeList[0].m_data[n11] == n6) {
                    if (this.m_edgeList[0].m_data[n10] == this.m_edgeList[1].m_data[n11]) {
                        ++n7;
                    }
                } else if (this.m_edgeList[0].m_data[n10] == this.m_edgeList[0].m_data[n11]) {
                    ++n7;
                }
                ++n3;
            }
            ++n9;
        }
        if (n7 > 2) {
            return true;
        }
        if (this.m_elementSet.hasTagVertex(n5, 13) && this.m_elementSet.hasTagVertex(n6, 13)) {
            n7 = 0;
            n9 = this.m_elementsAtVertex[n5].getSize();
            n4 = 0;
            while (n4 < n9) {
                n3 = this.m_elementsAtVertex[n6].getSize();
                n2 = 0;
                while (n2 < n3) {
                    if (this.m_elementsAtVertex[n5].m_data[n4] == this.m_elementsAtVertex[n6].m_data[n2]) {
                        ++n7;
                    }
                    ++n2;
                }
                ++n4;
            }
            if (n7 > 1) {
                return true;
            }
        }
        if ((this.m_elementSet.hasTagVertex(n5, 13) || this.m_elementSet.hasTagVertex(n6, 13)) && this.m_bRetainBoundary) {
            return true;
        }
        if ((this.m_elementSet.hasTagVertex(n5, 1) || this.m_elementSet.hasTagVertex(n6, 1)) && this.m_bRetainMarkedVertices) {
            return true;
        }
        n9 = 0;
        if (this.m_elementSet.hasTagVertex(n5, 13) && this.m_elementSet.hasTagVertex(n6, 13) && this.m_elementSet.hasBoundary()) {
            PgBndPolygon[] pgBndPolygonArray = this.m_elementSet.getBoundaries();
            n3 = pgBndPolygonArray.length;
            n2 = 0;
            while (n2 < n3) {
                PiVector piVector = pgBndPolygonArray[n2].getVertexInd();
                int n12 = pgBndPolygonArray[n2].getNumVertices();
                boolean bl = false;
                if (n12 > 1 && (piVector.m_data[0] == n5 && piVector.m_data[1] == n6 || piVector.m_data[0] == n6 && piVector.m_data[1] == n5 || piVector.m_data[n12 - 2] == n5 && piVector.m_data[n12 - 1] == n6 || piVector.m_data[n12 - 2] == n6 && piVector.m_data[n12 - 1] == n5)) {
                    bl = true;
                }
                if (bl) {
                    if (pgBndPolygonArray[n2].getNumVertices() == 3 && piVector.m_data[0] == piVector.m_data[2]) {
                        int n13;
                        int n14 = -1;
                        int n15 = -1;
                        int n16 = this.m_elementsAtVertex[n5].getSize();
                        int n17 = 0;
                        while (n17 < n16) {
                            n13 = this.m_elementsAtVertex[n6].getSize();
                            int n18 = 0;
                            while (n18 < n13) {
                                if (this.m_elementsAtVertex[n6].m_data[n18] == this.m_elementsAtVertex[n5].m_data[n17]) {
                                    PiVector piVector2 = this.m_elementSet.getElement(this.m_elementsAtVertex[n5].m_data[n17]);
                                    n12 = piVector2.getSize();
                                    int n19 = 0;
                                    while (n19 < n12) {
                                        if (piVector2.m_data[n19] == n5 && (piVector2.m_data[(n19 + 1) % n12] == n6 || piVector2.m_data[(n19 - 1 + n12) % n12] == n6)) {
                                            if (n14 == -1) {
                                                n14 = this.m_elementsAtVertex[n5].m_data[n17];
                                            } else {
                                                n15 = this.m_elementsAtVertex[n5].m_data[n17];
                                            }
                                        }
                                        ++n19;
                                    }
                                }
                                ++n18;
                            }
                            ++n17;
                        }
                        n17 = -1;
                        n13 = -1;
                        PiVector piVector3 = this.m_elementSet.getElement(n14);
                        n12 = piVector3.getSize();
                        int n20 = 0;
                        while (n20 < n12) {
                            if (piVector3.m_data[n20] == n5) {
                                if (piVector3.m_data[(n20 + 1) % n12] == n6) {
                                    n17 = (n20 - 1 + n12) % n12;
                                }
                                if (piVector3.m_data[(n20 - 1 + n12) % n12] == n6) {
                                    n17 = (n20 - 2 + n12) % n12;
                                }
                            }
                            ++n20;
                        }
                        piVector3 = this.m_elementSet.getElement(n15);
                        n12 = piVector3.getSize();
                        n20 = 0;
                        while (n20 < n12) {
                            if (piVector3.m_data[n20] == n5) {
                                if (piVector3.m_data[(n20 + 1) % n12] == n6) {
                                    n13 = (n20 - 1 + n12) % n12;
                                }
                                if (piVector3.m_data[(n20 - 1 + n12) % n12] == n6) {
                                    n13 = (n20 - 2 + n12) % n12;
                                }
                            }
                            ++n20;
                        }
                        this.m_elementSet.getNeighbour((int)n14).m_data[n17] = n15;
                        this.m_elementSet.getNeighbour((int)n15).m_data[n13] = n14;
                        piVector.m_data[1] = piVector.m_data[0];
                        n9 = 1;
                    } else {
                        if (n9 == 1) {
                            this.replaceBndVertex(0, 0);
                        }
                        return true;
                    }
                }
                ++n2;
            }
        }
        if (n9 == 1) {
            this.replaceBndVertex(0, 0);
        }
        return false;
    }

    protected void retainMarkedVertices(boolean bl) {
        this.m_bRetainMarkedVertices = bl;
    }

    protected void checkAngles(boolean bl) {
        this.m_bCheckAngles = bl;
        if (bl) {
            this.computeMinInOut();
            this.generateEdgesAtVertex2();
            this.m_bBigNeighbourhood = true;
            return;
        }
        this.m_bBigNeighbourhood = false;
    }

    public void init() {
        int n;
        int n2;
        this.m_maxAngle = 15.0;
        PgElementEdge[] pgElementEdgeArray = this.m_elementSet.getEdgeList();
        this.m_numEdges = pgElementEdgeArray.length;
        this.m_numEl = this.m_elementSet.getNumElements();
        this.m_edgeList = new PiVector[2];
        this.m_edgeList[0] = new PiVector(this.m_numEdges);
        this.m_edgeList[1] = new PiVector(this.m_numEdges);
        this.m_minVector = new PdVector[this.m_numEdges];
        this.m_minValue = new PdVector(this.m_numEdges);
        this.m_isDenied = new boolean[this.m_numEdges];
        this.m_quadMatrix = new PdMatrix[this.m_elementSet.getNumVertices()];
        this.m_quadVector = new PdVector[this.m_elementSet.getNumVertices()];
        this.m_quadScalar = new PdVector(this.m_elementSet.getNumVertices());
        this.m_edgesAtVertex = new PiVector[this.m_elementSet.getNumVertices()];
        this.m_elementsAtVertex = new PiVector[this.m_elementSet.getNumVertices()];
        int n3 = 0;
        while (n3 < this.m_numEdges) {
            this.m_isDenied[n3] = false;
            PgElementEdge pgElementEdge = pgElementEdgeArray[n3];
            int n4 = pgElementEdge.getEdgeInd(0);
            int n5 = pgElementEdge.getEdgeInd(1);
            this.m_edgeList[0].m_data[n3] = n4;
            this.m_edgeList[1].m_data[n3] = n5;
            if (this.m_edgesAtVertex[n4] == null || this.m_edgesAtVertex[n4].getSize() == 0) {
                this.m_edgesAtVertex[n4] = new PiVector(1);
                this.m_edgesAtVertex[n4].m_data[0] = n3;
            } else {
                n2 = this.m_edgesAtVertex[n4].getSize();
                this.m_edgesAtVertex[n4].setSize(n2 + 1);
                this.m_edgesAtVertex[n4].m_data[n2] = n3;
            }
            if (this.m_edgesAtVertex[n5] == null || this.m_edgesAtVertex[n5].getSize() == 0) {
                this.m_edgesAtVertex[n5] = new PiVector(1);
                this.m_edgesAtVertex[n5].m_data[0] = n3;
            } else {
                n2 = this.m_edgesAtVertex[n5].getSize();
                this.m_edgesAtVertex[n5].setSize(n2 + 1);
                this.m_edgesAtVertex[n5].m_data[n2] = n3;
            }
            ++n3;
        }
        int n6 = this.m_elementSet.getNumElements();
        int n7 = 0;
        while (n7 < n6) {
            int n8 = this.m_elementSet.getElement(n7).getSize();
            n = 0;
            while (n < n8) {
                n3 = this.m_elementSet.getElement((int)n7).m_data[n];
                if (this.m_elementsAtVertex[n3] == null || this.m_elementsAtVertex[n3].getSize() == 0) {
                    this.m_elementsAtVertex[n3] = new PiVector(1);
                    this.m_elementsAtVertex[n3].m_data[0] = n7;
                } else {
                    n2 = this.m_elementsAtVertex[n3].getSize();
                    this.m_elementsAtVertex[n3].setSize(n2 + 1);
                    this.m_elementsAtVertex[n3].m_data[n2] = n7;
                }
                ++n;
            }
            ++n7;
        }
        n7 = this.m_elementSet.getNumVertices();
        n = 0;
        while (n < n7) {
            if (this.m_elementsAtVertex[n] == null) {
                this.m_elementsAtVertex[n] = new PiVector(0);
            }
            ++n;
        }
        if (this.m_bBigNeighbourhood) {
            this.generateEdgesAtVertex2();
        }
        this.m_elementSet.makeElementNormals();
        this.m_elementSet.markBoundary();
        n = 0;
        while (n < n7) {
            this.computeQuadric(n);
            ++n;
        }
        n = 0;
        while (n < this.m_numEdges) {
            this.computeMinimum(n);
            ++n;
        }
        this.m_index = new PiVector(this.m_numEdges + 1);
        this.m_location = new PiVector(this.m_numEdges);
        this.m_maxIndex = this.m_numEdges - 1;
        this.m_lastNode = (this.m_maxIndex - 1) / 2;
        n = 0;
        while (n < this.m_numEdges) {
            this.m_index.m_data[n] = n;
            this.m_location.m_data[n] = n;
            ++n;
        }
        this.m_index.m_data[this.m_maxIndex + 1] = -1;
        n = this.m_lastNode;
        while (n > -1) {
            this.checkRelation(n);
            --n;
        }
        this.minInOut = 2.0;
        if (this.m_bCheckAngles) {
            this.computeMinInOut();
        }
        this.m_bUpdateSendet = true;
        this.markVertices();
        this.m_bUpdateSendet = false;
    }

    private void deleteValue(int n) {
        if (n == this.m_maxIndex) {
            this.m_location.m_data[this.m_index.m_data[n]] = -1;
            this.m_index.m_data[n] = -1;
            this.m_maxIndex += -1;
            this.m_lastNode = (this.m_maxIndex - 1) / 2;
            return;
        }
        this.m_location.m_data[this.m_index.m_data[n]] = -1;
        this.m_index.m_data[n] = this.m_index.m_data[this.m_maxIndex];
        this.m_location.m_data[this.m_index.m_data[n]] = n;
        this.m_index.m_data[this.m_maxIndex] = -1;
        this.m_maxIndex += -1;
        this.m_lastNode = (this.m_maxIndex - 1) / 2;
        this.valueChanged(n);
    }

    private void computeMinimum(int n) {
        this.m_isDenied[n] = false;
        this.m_minVector[n] = new PdVector(3);
        PdMatrix pdMatrix = new PdMatrix(3);
        PdMatrix pdMatrix2 = new PdMatrix(3);
        PdVector pdVector = new PdVector(3);
        PdVector pdVector2 = new PdVector(3);
        double d = this.m_quadScalar.m_data[this.m_edgeList[0].m_data[n]] + this.m_quadScalar.m_data[this.m_edgeList[1].m_data[n]];
        pdMatrix.add(this.m_quadMatrix[this.m_edgeList[0].m_data[n]], this.m_quadMatrix[this.m_edgeList[1].m_data[n]]);
        pdVector.add(this.m_quadVector[this.m_edgeList[0].m_data[n]], this.m_quadVector[this.m_edgeList[1].m_data[n]]);
        if (this.m_elementSet.hasTagVertex(this.m_edgeList[0].m_data[n], 13)) {
            if (!this.m_elementSet.hasTagVertex(this.m_edgeList[1].m_data[n], 13)) {
                this.m_minVector[n].copy(this.m_elementSet.getVertex(this.m_edgeList[0].m_data[n]));
            } else {
                this.m_minVector[n].add(this.m_elementSet.getVertex(this.m_edgeList[0].m_data[n]), this.m_elementSet.getVertex(this.m_edgeList[1].m_data[n]));
                this.m_minVector[n].multScalar(0.5);
            }
        } else if (this.m_elementSet.hasTagVertex(this.m_edgeList[1].m_data[n], 13)) {
            this.m_minVector[n].copy(this.m_elementSet.getVertex(this.m_edgeList[1].m_data[n]));
        } else if (Math.abs(pdMatrix.det()) < 1.0E-10) {
            this.m_minVector[n].add(this.m_elementSet.getVertex(this.m_edgeList[0].m_data[n]), this.m_elementSet.getVertex(this.m_edgeList[1].m_data[n]));
            this.m_minVector[n].multScalar(0.5);
        } else {
            pdMatrix2.invert(pdMatrix);
            this.m_minVector[n].leftMultMatrix(pdMatrix2, pdVector);
        }
        pdVector2.leftMultMatrix(pdMatrix, this.m_minVector[n]);
        this.m_minValue.m_data[n] = d - 2.0 * PdVector.dot((PdVector)pdVector, (PdVector)this.m_minVector[n]) + PdVector.dot((PdVector)pdVector2, (PdVector)this.m_minVector[n]);
        if (this.m_minValue.m_data[n] < 0.0) {
            int n2 = n;
            this.m_minValue.m_data[n2] = this.m_minValue.m_data[n2] * -1.0;
        }
    }
}

