/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import java.util.Enumeration;
import jv.anim.PsAnimation;
import jv.anim.PsTimeEvent;
import jv.anim.PsTimeListenerIf;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuReflect;
import jvx.geom.PwModel;
import jvx.geom.PwUnfoldPriorityQueue;

public class PwUnfold
extends PsObject
implements PsTimeListenerIf {
    protected PgElementSet m_geom = null;
    protected PgElementSet m_geomCopy = null;
    protected int[] data;
    protected int[] parent;
    protected boolean genSplice = true;
    protected boolean hasSplice = false;
    protected PgElementSet m_sp = null;
    protected boolean isUnfold = false;
    protected int numOfElem;
    protected PsAnimation m_anim;
    protected double dxmax = 0.0;
    protected double dymax = 0.0;
    protected int numOfParts = 0;
    protected int numOfRows = 0;
    protected int actNumOfElem = 0;
    protected int actNumOfVert = 0;
    private static /* synthetic */ Class class$jvx$geom$PwUnfold;

    public void removeSplice() {
        if (!this.hasSplice) {
            return;
        }
        Enumeration enumeration = this.m_geom.getDisplays();
        while (enumeration.hasMoreElements()) {
            PvDisplayIf pvDisplayIf = (PvDisplayIf)enumeration.nextElement();
            pvDisplayIf.removeGeometry((PgGeometryIf)this.m_sp);
        }
        this.hasSplice = false;
    }

    public void unfold() {
        int n;
        if (this.m_geom == null) {
            PsDebug.warning((String)"Missing Geometry. Set Geometry first.");
            return;
        }
        PiVector[] piVectorArray = this.m_geomCopy.getNeighbours();
        double[][] dArray = new double[this.numOfElem][3];
        int n2 = 0;
        while (n2 < this.numOfElem) {
            n = 0;
            do {
                dArray[n2][n] = -this.m_geom.getEdgeLength(n2, n);
            } while (++n < 3);
            ++n2;
        }
        try {
            PwModel.shrink(this.m_geom, 1.0);
        }
        catch (Exception exception) {
            PsDebug.warning((String)" Removing unused vertices.");
            this.m_geom.removeUnusedVertices();
            PwModel.shrink(this.m_geom, 1.0);
        }
        PiVector[] piVectorArray2 = this.m_geom.getElements();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PwUnfoldPriorityQueue pwUnfoldPriorityQueue = new PwUnfoldPriorityQueue(this.numOfElem);
        int n3 = 0;
        int n4 = -1;
        int n5 = -1;
        int n6 = 0;
        PdMatrix pdMatrix = new PdMatrix(4);
        PdVector pdVector = new PdVector(0.0, 0.0, 1.0);
        PdVector pdVector2 = new PdVector(3);
        PdVector pdVector3 = new PdVector(3);
        int[][] nArray = new int[3 * this.numOfElem][2];
        int n7 = 0;
        PdVector pdVector4 = new PdVector(3);
        while ((n4 = pwUnfoldPriorityQueue.extractMin()) != -1) {
            double d;
            if (this.parent[n4] == -1) {
                n7 = 3;
                pdVector2.normalOfPlane(pdVectorArray[piVectorArray2[n4].m_data[0]], pdVectorArray[piVectorArray2[n4].m_data[1]], pdVectorArray[piVectorArray2[n4].m_data[2]]);
                d = PdVector.angle((PdVector)pdVector2, (PdVector)pdVector);
                pdMatrix = PuReflect.rotateLine((PdVector)pdVectorArray[piVectorArray2[n4].m_data[0]], (PdVector)PdVector.crossNew((PdVector)pdVector2, (PdVector)pdVector), (double)(d * Math.PI / 180.0));
                if (pdMatrix != null) {
                    double[] dArray2 = pdMatrix.m_data[2];
                    dArray2[3] = dArray2[3] - pdVectorArray[piVectorArray2[n4].m_data[0]].m_data[2];
                    n2 = 0;
                    do {
                        pdVector4.copy(pdVectorArray[piVectorArray2[n4].m_data[n2]]);
                        pdVectorArray[piVectorArray2[n4].m_data[n2]].leftMultAffin(pdMatrix, pdVector4, true);
                    } while (++n2 < 3);
                }
                nArray[0][0] = piVectorArray2[n4].m_data[0];
                nArray[0][1] = piVectorArray2[n4].m_data[1];
                nArray[1][0] = piVectorArray2[n4].m_data[1];
                nArray[1][1] = piVectorArray2[n4].m_data[2];
                nArray[2][0] = piVectorArray2[n4].m_data[2];
                nArray[2][1] = piVectorArray2[n4].m_data[0];
                n6 = n3;
                this.data[n3] = n4;
                ++n3;
            } else {
                int n8;
                d = this.m_geomCopy.getVertexAngle(n4, (this.parent[n4] + 1) % 3);
                d *= Math.PI / 180;
                double d2 = this.m_geomCopy.getEdgeLength(n4, (this.parent[n4] + 2) % 3);
                n5 = piVectorArray[n4].m_data[this.parent[n4]];
                int n9 = this.m_geomCopy.getElement((int)n4).m_data[(this.parent[n4] + 1) % 3];
                int n10 = this.m_geomCopy.getOppVertexLocInd(n4, this.parent[n4]);
                if (n9 == this.m_geomCopy.getElement((int)n5).m_data[(n10 + 2) % 3]) {
                    n9 = piVectorArray2[n5].m_data[(n10 + 2) % 3];
                    n8 = piVectorArray2[n5].m_data[(n10 + 1) % 3];
                } else {
                    n8 = piVectorArray2[n5].m_data[(n10 + 2) % 3];
                    n9 = piVectorArray2[n5].m_data[(n10 + 1) % 3];
                }
                PdVector pdVector5 = pdVectorArray[n9];
                PdVector pdVector6 = pdVectorArray[n8];
                PdVector pdVector7 = pdVectorArray[piVectorArray2[n5].m_data[n10]];
                double d3 = pdVector6.m_data[0] - pdVector5.m_data[0];
                double d4 = pdVector6.m_data[1] - pdVector5.m_data[1];
                double d5 = d3 * (pdVector7.m_data[1] - pdVector5.m_data[1]) - d4 * (pdVector7.m_data[0] - pdVector5.m_data[0]);
                if (d5 > 0.0) {
                    d = -d;
                }
                pdVector3.m_data[0] = d3 * Math.cos(d) - d4 * Math.sin(d);
                pdVector3.m_data[1] = d3 * Math.sin(d) + d4 * Math.cos(d);
                pdVector3.m_data[2] = 0.0;
                pdVector3.setLength(d2);
                pdVector3.add(pdVector5);
                double d6 = -1.0;
                double d7 = -1.0;
                boolean bl = false;
                double d8 = 1.0E-6;
                n2 = 0;
                while (n2 < n7) {
                    double d9 = pdVectorArray[nArray[n2][0]].m_data[0];
                    double d10 = pdVectorArray[nArray[n2][0]].m_data[1];
                    double d11 = pdVectorArray[nArray[n2][1]].m_data[1] - pdVectorArray[nArray[n2][0]].m_data[1];
                    double d12 = pdVector3.m_data[0];
                    double d13 = pdVector5.m_data[0] - d12;
                    double d14 = pdVectorArray[nArray[n2][1]].m_data[0] - pdVectorArray[nArray[n2][0]].m_data[0];
                    double d15 = pdVector3.m_data[1];
                    double d16 = pdVector5.m_data[1] - d15;
                    if (d11 * d13 - d14 * d16 != 0.0) {
                        d6 = ((d9 - d12) * d16 - (d10 - d15) * d13) / (d11 * d13 - d14 * d16);
                        d7 = ((d10 - d15) * d14 - (d9 - d12) * d11) / (d14 * d16 - d11 * d13);
                    } else {
                        d6 = -1.0;
                        d7 = -1.0;
                    }
                    if (d6 > d8 && d6 < 1.0 - d8 && d7 > d8 && d7 < 1.0 - d8) {
                        bl = true;
                        break;
                    }
                    d13 = pdVector6.m_data[0] - d12;
                    d16 = pdVector6.m_data[1] - d15;
                    if (d11 * d13 - d14 * d16 != 0.0) {
                        d6 = ((d9 - d12) * d16 - (d10 - d15) * d13) / (d11 * d13 - d14 * d16);
                        d7 = ((d10 - d15) * d14 - (d9 - d12) * d11) / (d14 * d16 - d11 * d13);
                    } else {
                        d6 = -1.0;
                        d7 = -1.0;
                    }
                    if (d6 > d8 && d6 < 1.0 - d8 && d7 > d8 && d7 < 1.0 - d8) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                int n11 = this.parent[n4];
                boolean bl2 = false;
                boolean bl3 = false;
                if (bl) {
                    int n12 = piVectorArray[n4].m_data[(this.parent[n4] + 1) % 3];
                    if (dArray[n4][this.parent[n4]] > dArray[n4][(this.parent[n4] + 1) % 3]) {
                        n12 = -2;
                    }
                    if (dArray[n4][this.parent[n4]] == dArray[n4][(this.parent[n4] + 1) % 3]) {
                        dArray[n4][this.parent[n4]] = dArray[n4][this.parent[n4]] + 1.0E-6 * dArray[n4][this.parent[n4]];
                    }
                    int n13 = piVectorArray[n4].m_data[(this.parent[n4] + 2) % 3];
                    if (dArray[n4][this.parent[n4]] > dArray[n4][(this.parent[n4] + 2) % 3]) {
                        n13 = -2;
                    }
                    if (dArray[n4][this.parent[n4]] == dArray[n4][(this.parent[n4] + 2) % 3]) {
                        dArray[n4][this.parent[n4]] = dArray[n4][this.parent[n4]] + 1.0E-6 * dArray[n4][this.parent[n4]];
                    }
                    n2 = n6;
                    while (n2 < n3) {
                        if (n12 == this.data[n2]) {
                            bl2 = true;
                        }
                        if (n13 == this.data[n2]) {
                            bl3 = true;
                        }
                        ++n2;
                    }
                    if (dArray[n4][(this.parent[n4] + 1) % 3] < dArray[n4][(this.parent[n4] + 2) % 3]) {
                        if (bl3) {
                            this.parent[n4] = (this.parent[n4] + 2) % 3;
                        }
                        if (bl2) {
                            this.parent[n4] = (this.parent[n4] + 1) % 3;
                        }
                    } else {
                        if (bl2) {
                            this.parent[n4] = (this.parent[n4] + 1) % 3;
                        }
                        if (bl3) {
                            this.parent[n4] = (this.parent[n4] + 2) % 3;
                        }
                    }
                    if (n11 == this.parent[n4]) {
                        this.parent[n4] = -1;
                        pwUnfoldPriorityQueue.enqueue(n4, Double.MAX_VALUE);
                        continue;
                    }
                    pwUnfoldPriorityQueue.enqueue(n4, dArray[n4][this.parent[n4]]);
                    continue;
                }
                piVectorArray2[n4].m_data[(this.parent[n4] + 1) % 3] = n9;
                piVectorArray2[n4].m_data[(this.parent[n4] + 2) % 3] = n8;
                pdVectorArray[piVectorArray2[n4].m_data[this.parent[n4]]].copy(pdVector3);
                this.data[n3] = n4;
                ++n3;
                nArray[n7][0] = piVectorArray2[n4].m_data[this.parent[n4]];
                nArray[n7][1] = n9;
                nArray[++n7][0] = piVectorArray2[n4].m_data[this.parent[n4]];
                nArray[n7][1] = n8;
                ++n7;
            }
            n2 = 0;
            do {
                if ((n5 = piVectorArray[n4].m_data[n2]) == -1 || !pwUnfoldPriorityQueue.isElement(n5) || !(dArray[n4][n2] < pwUnfoldPriorityQueue.getKey(n5))) continue;
                n = 0;
                do {
                    if (piVectorArray[n5].m_data[n] != n4) continue;
                    this.parent[n5] = n;
                    break;
                } while (++n < 3);
                pwUnfoldPriorityQueue.decreaseKey(n5, dArray[n4][n2]);
            } while (++n2 < 3);
        }
        this.m_geom.removeUnusedVertices();
        this.isUnfold = true;
        this.arrangeParts();
    }

    protected void arrangeParts() {
        int n;
        if (this.m_geom == null) {
            PsDebug.warning((String)"Missing Geometry. Set Geometry first.");
            return;
        }
        if (!this.isUnfold) {
            this.unfold();
        }
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        double d3 = d;
        double d4 = d2;
        this.dxmax = 0.0;
        this.dymax = 0.0;
        this.numOfParts = 0;
        PiVector[] piVectorArray = this.m_geom.getElements();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        int n2 = this.numOfElem - 1;
        while (n2 >= 0) {
            if (this.parent[this.data[n2]] >= 0) {
                if (pdVectorArray[piVectorArray[this.data[n2]].m_data[this.parent[this.data[n2]]]].m_data[0] > d2) {
                    d2 = pdVectorArray[piVectorArray[this.data[n2]].m_data[this.parent[this.data[n2]]]].m_data[0];
                }
                if (pdVectorArray[piVectorArray[this.data[n2]].m_data[this.parent[this.data[n2]]]].m_data[0] < d) {
                    d = pdVectorArray[piVectorArray[this.data[n2]].m_data[this.parent[this.data[n2]]]].m_data[0];
                }
                if (pdVectorArray[piVectorArray[this.data[n2]].m_data[this.parent[this.data[n2]]]].m_data[1] > d4) {
                    d4 = pdVectorArray[piVectorArray[this.data[n2]].m_data[this.parent[this.data[n2]]]].m_data[1];
                }
                if (pdVectorArray[piVectorArray[this.data[n2]].m_data[this.parent[this.data[n2]]]].m_data[1] < d3) {
                    d3 = pdVectorArray[piVectorArray[this.data[n2]].m_data[this.parent[this.data[n2]]]].m_data[1];
                }
            } else {
                n = 0;
                do {
                    if (pdVectorArray[piVectorArray[this.data[n2]].m_data[n]].m_data[0] > d2) {
                        d2 = pdVectorArray[piVectorArray[this.data[n2]].m_data[n]].m_data[0];
                    }
                    if (pdVectorArray[piVectorArray[this.data[n2]].m_data[n]].m_data[0] < d) {
                        d = pdVectorArray[piVectorArray[this.data[n2]].m_data[n]].m_data[0];
                    }
                    if (pdVectorArray[piVectorArray[this.data[n2]].m_data[n]].m_data[1] > d4) {
                        d4 = pdVectorArray[piVectorArray[this.data[n2]].m_data[n]].m_data[1];
                    }
                    if (!(pdVectorArray[piVectorArray[this.data[n2]].m_data[n]].m_data[1] < d3)) continue;
                    d3 = pdVectorArray[piVectorArray[this.data[n2]].m_data[n]].m_data[1];
                } while (++n < 3);
                if (this.dxmax < d2 - d) {
                    this.dxmax = d2 - d;
                }
                if (this.dymax < d4 - d3) {
                    this.dymax = d4 - d3;
                }
                d = Double.MAX_VALUE;
                d2 = Double.MIN_VALUE;
                d3 = d;
                d4 = d2;
                ++this.numOfParts;
            }
            this.m_geom.makeNeighbour();
            --n2;
        }
        this.numOfRows = (int)Math.ceil(Math.sqrt(this.numOfParts));
        double d5 = 0.0;
        double d6 = 0.0;
        int n3 = 0;
        boolean bl = true;
        double d7 = 0.0;
        double d8 = 0.0;
        d3 = d = Double.MAX_VALUE;
        n2 = 1;
        while (n2 < this.numOfElem) {
            if (this.parent[this.data[n2]] >= 0) {
                if (pdVectorArray[piVectorArray[this.data[n2]].m_data[this.parent[this.data[n2]]]].m_data[0] < d) {
                    d = pdVectorArray[piVectorArray[this.data[n2]].m_data[this.parent[this.data[n2]]]].m_data[0];
                }
                if (pdVectorArray[piVectorArray[this.data[n2]].m_data[this.parent[this.data[n2]]]].m_data[1] < d3) {
                    d3 = pdVectorArray[piVectorArray[this.data[n2]].m_data[this.parent[this.data[n2]]]].m_data[1];
                }
            } else {
                n = 0;
                do {
                    if (pdVectorArray[piVectorArray[this.data[n3]].m_data[n]].m_data[0] < d) {
                        d = pdVectorArray[piVectorArray[this.data[n3]].m_data[n]].m_data[0];
                    }
                    if (!(pdVectorArray[piVectorArray[this.data[n3]].m_data[n]].m_data[1] < d3)) continue;
                    d3 = pdVectorArray[piVectorArray[this.data[n3]].m_data[n]].m_data[1];
                } while (++n < 3);
                if (bl) {
                    d7 = d;
                    d8 = d3;
                    bl = false;
                }
                n = n3 + 1;
                while (n < n2) {
                    pdVectorArray[piVectorArray[this.data[n]].m_data[this.parent[this.data[n]]]].m_data[0] = pdVectorArray[piVectorArray[this.data[n]].m_data[this.parent[this.data[n]]]].m_data[0] + (d5 - d + d7);
                    pdVectorArray[piVectorArray[this.data[n]].m_data[this.parent[this.data[n]]]].m_data[1] = pdVectorArray[piVectorArray[this.data[n]].m_data[this.parent[this.data[n]]]].m_data[1] + (d6 - d3 + d8);
                    ++n;
                }
                n = 0;
                do {
                    pdVectorArray[piVectorArray[this.data[n3]].m_data[n]].m_data[0] = pdVectorArray[piVectorArray[this.data[n3]].m_data[n]].m_data[0] + (d5 - d + d7);
                    pdVectorArray[piVectorArray[this.data[n3]].m_data[n]].m_data[1] = pdVectorArray[piVectorArray[this.data[n3]].m_data[n]].m_data[1] + (d6 - d3 + d8);
                } while (++n < 3);
                if (d5 < (double)(this.numOfRows - 2) * this.dxmax + this.dxmax / 2.0) {
                    d5 += this.dxmax;
                } else {
                    d6 += this.dymax;
                    d5 = 0.0;
                }
                n3 = n2;
                d3 = d = Double.MAX_VALUE;
            }
            ++n2;
        }
        n = 0;
        do {
            if (pdVectorArray[piVectorArray[this.data[n3]].m_data[n]].m_data[0] < d) {
                d = pdVectorArray[piVectorArray[this.data[n3]].m_data[n]].m_data[0];
            }
            if (!(pdVectorArray[piVectorArray[this.data[n3]].m_data[n]].m_data[1] < d3)) continue;
            d3 = pdVectorArray[piVectorArray[this.data[n3]].m_data[n]].m_data[1];
        } while (++n < 3);
        if (bl) {
            d7 = d;
            d8 = d3;
            bl = false;
        }
        n = n3 + 1;
        while (n < n2) {
            pdVectorArray[piVectorArray[this.data[n]].m_data[this.parent[this.data[n]]]].m_data[0] = pdVectorArray[piVectorArray[this.data[n]].m_data[this.parent[this.data[n]]]].m_data[0] + (d5 - d + d7);
            pdVectorArray[piVectorArray[this.data[n]].m_data[this.parent[this.data[n]]]].m_data[1] = pdVectorArray[piVectorArray[this.data[n]].m_data[this.parent[this.data[n]]]].m_data[1] + (d6 - d3 + d8);
            ++n;
        }
        n = 0;
        do {
            pdVectorArray[piVectorArray[this.data[n3]].m_data[n]].m_data[0] = pdVectorArray[piVectorArray[this.data[n3]].m_data[n]].m_data[0] + (d5 - d + d7);
            pdVectorArray[piVectorArray[this.data[n3]].m_data[n]].m_data[1] = pdVectorArray[piVectorArray[this.data[n3]].m_data[n]].m_data[1] + (d6 - d3 + d8);
        } while (++n < 3);
        if (d5 < (double)(this.numOfRows - 2) * this.dxmax + this.dxmax / 2.0) {
            d5 += this.dxmax;
        } else {
            d6 += this.dymax;
            d5 = 0.0;
        }
        d3 = d = Double.MAX_VALUE;
    }

    protected void arrangeParts(double d) {
        int n;
        double d2;
        double d3 = d2 = Double.MAX_VALUE;
        double d4 = 0.0;
        double d5 = 0.0;
        PiVector[] piVectorArray = this.m_geom.getElements();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        boolean bl = true;
        double d6 = 0.0;
        double d7 = 0.0;
        int n2 = 0;
        int n3 = 1;
        while (n3 < this.numOfElem) {
            if (this.parent[this.data[n3]] >= 0) {
                if (pdVectorArray[piVectorArray[this.data[n3]].m_data[this.parent[this.data[n3]]]].m_data[0] < d2) {
                    d2 = pdVectorArray[piVectorArray[this.data[n3]].m_data[this.parent[this.data[n3]]]].m_data[0];
                }
                if (pdVectorArray[piVectorArray[this.data[n3]].m_data[this.parent[this.data[n3]]]].m_data[1] < d3) {
                    d3 = pdVectorArray[piVectorArray[this.data[n3]].m_data[this.parent[this.data[n3]]]].m_data[1];
                }
            } else {
                n = 0;
                do {
                    if (pdVectorArray[piVectorArray[this.data[n2]].m_data[n]].m_data[0] < d2) {
                        d2 = pdVectorArray[piVectorArray[this.data[n2]].m_data[n]].m_data[0];
                    }
                    if (!(pdVectorArray[piVectorArray[this.data[n2]].m_data[n]].m_data[1] < d3)) continue;
                    d3 = pdVectorArray[piVectorArray[this.data[n2]].m_data[n]].m_data[1];
                } while (++n < 3);
                if (bl) {
                    d6 = d2;
                    d7 = d3;
                    bl = false;
                }
                n = n2 + 1;
                while (n < n3) {
                    pdVectorArray[piVectorArray[this.data[n]].m_data[this.parent[this.data[n]]]].m_data[0] = pdVectorArray[piVectorArray[this.data[n]].m_data[this.parent[this.data[n]]]].m_data[0] + d * (d4 - d2 + d6);
                    pdVectorArray[piVectorArray[this.data[n]].m_data[this.parent[this.data[n]]]].m_data[1] = pdVectorArray[piVectorArray[this.data[n]].m_data[this.parent[this.data[n]]]].m_data[1] + d * (d5 - d3 + d7);
                    ++n;
                }
                n = 0;
                do {
                    pdVectorArray[piVectorArray[this.data[n2]].m_data[n]].m_data[0] = pdVectorArray[piVectorArray[this.data[n2]].m_data[n]].m_data[0] + d * (d4 - d2 + d6);
                    pdVectorArray[piVectorArray[this.data[n2]].m_data[n]].m_data[1] = pdVectorArray[piVectorArray[this.data[n2]].m_data[n]].m_data[1] + d * (d5 - d3 + d7);
                } while (++n < 3);
                if (d4 < (double)(this.numOfRows - 2) * this.dxmax + this.dxmax / 2.0) {
                    d4 += this.dxmax;
                } else {
                    d5 += this.dymax;
                    d4 = 0.0;
                }
                n2 = n3;
                d3 = d2 = Double.MAX_VALUE;
            }
            ++n3;
        }
        n = 0;
        do {
            if (pdVectorArray[piVectorArray[this.data[n2]].m_data[n]].m_data[0] < d2) {
                d2 = pdVectorArray[piVectorArray[this.data[n2]].m_data[n]].m_data[0];
            }
            if (!(pdVectorArray[piVectorArray[this.data[n2]].m_data[n]].m_data[1] < d3)) continue;
            d3 = pdVectorArray[piVectorArray[this.data[n2]].m_data[n]].m_data[1];
        } while (++n < 3);
        if (bl) {
            d6 = d2;
            d7 = d3;
            bl = false;
        }
        n = n2 + 1;
        while (n < n3) {
            pdVectorArray[piVectorArray[this.data[n]].m_data[this.parent[this.data[n]]]].m_data[0] = pdVectorArray[piVectorArray[this.data[n]].m_data[this.parent[this.data[n]]]].m_data[0] + d * (d4 - d2 + d6);
            pdVectorArray[piVectorArray[this.data[n]].m_data[this.parent[this.data[n]]]].m_data[1] = pdVectorArray[piVectorArray[this.data[n]].m_data[this.parent[this.data[n]]]].m_data[1] + d * (d5 - d3 + d7);
            ++n;
        }
        n = 0;
        do {
            pdVectorArray[piVectorArray[this.data[n2]].m_data[n]].m_data[0] = pdVectorArray[piVectorArray[this.data[n2]].m_data[n]].m_data[0] + d * (d4 - d2 + d6);
            pdVectorArray[piVectorArray[this.data[n2]].m_data[n]].m_data[1] = pdVectorArray[piVectorArray[this.data[n2]].m_data[n]].m_data[1] + d * (d5 - d3 + d7);
        } while (++n < 3);
        if (d4 < (double)(this.numOfRows - 2) * this.dxmax + this.dxmax / 2.0) {
            d4 += this.dxmax;
        } else {
            d5 += this.dymax;
            d4 = 0.0;
        }
        d3 = d2 = Double.MAX_VALUE;
    }

    public PwUnfold() {
        this.setName(" Unfold Geometry ");
        this.m_anim = new PsAnimation();
        this.m_anim.setName("Animated Unfolding");
        this.m_anim.addTimeListener((PsTimeListenerIf)this);
        this.m_anim.setTimeInterval(0.0, 100.0, 2.0, 4.0);
        this.m_anim.update((Object)this.m_anim);
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwUnfold != null ? class$jvx$geom$PwUnfold : (class$jvx$geom$PwUnfold = PwUnfold.class$("jvx.geom.PwUnfold")))) {
            this.init();
        }
    }

    protected void flatten(double d) {
        if (this.m_geom == null) {
            PsDebug.warning((String)"Missing Geometry. Set Geometry first.");
            return;
        }
        int n = this.data.length - 1;
        int[] nArray = new int[this.m_geom.getNumVertices()];
        int n2 = 0;
        PiVector[] piVectorArray = this.m_geom.getNeighbours();
        PdMatrix pdMatrix = new PdMatrix(4);
        PdMatrix pdMatrix2 = new PdMatrix(3);
        PdVector pdVector = new PdVector(3);
        PdVector pdVector2 = new PdVector(3);
        PdVector pdVector3 = new PdVector(3);
        PdVector pdVector4 = new PdVector(3);
        int n3 = n;
        while (n >= 0) {
            int n4;
            double d2;
            PiVector piVector;
            int n5 = this.data[n];
            int n6 = this.parent[n5];
            if (n6 == -1) {
                piVector = this.m_geom.getElement(this.data[n]);
                pdVector.normalOfPlane(this.m_geom.getVertex(piVector.m_data[0]), this.m_geom.getVertex(piVector.m_data[1]), this.m_geom.getVertex(piVector.m_data[2]));
                d2 = PdVector.angle((PdVector)pdVector, (PdVector)new PdVector(0.0, 0.0, 1.0));
                pdMatrix = PuReflect.rotateLine((PdVector)this.m_geom.getVertex(piVector.m_data[0]), (PdVector)PdVector.crossNew((PdVector)pdVector, (PdVector)new PdVector(0.0, 0.0, 1.0)), (double)((d2 *= d) * Math.PI / 180.0));
                double d3 = this.m_geom.getVertex((int)piVector.m_data[0]).m_data[2];
                if (pdMatrix != null) {
                    n4 = n3;
                    while (n4 > n) {
                        pdVector3 = this.m_geom.getVertex(this.m_geom.getElement((int)this.data[n4]).m_data[this.parent[this.data[n4]]]);
                        pdVector4.copy(pdVector3);
                        pdVector3.leftMultAffin(pdMatrix, pdVector4, true);
                        pdVector3.m_data[2] = pdVector3.m_data[2] - d * d3;
                        --n4;
                    }
                    n4 = 0;
                    do {
                        pdVector3 = this.m_geom.getVertex(this.m_geom.getElement((int)this.data[n]).m_data[n4]);
                        pdVector4.copy(pdVector3);
                        pdVector3.leftMultAffin(pdMatrix, pdVector4, true);
                        pdVector3.m_data[2] = pdVector3.m_data[2] - d * d3;
                    } while (++n4 < 3);
                } else {
                    n4 = n3;
                    while (n4 > n) {
                        pdVector3 = this.m_geom.getVertex(this.m_geom.getElement((int)this.data[n4]).m_data[this.parent[this.data[n4]]]);
                        pdVector3.m_data[2] = pdVector3.m_data[2] - d * d3;
                        --n4;
                    }
                    n4 = 0;
                    do {
                        pdVector3 = this.m_geom.getVertex(this.m_geom.getElement((int)this.data[n]).m_data[n4]);
                        pdVector3.m_data[2] = pdVector3.m_data[2] - d * d3;
                    } while (++n4 < 3);
                }
                n3 = n - 1;
                --n;
                continue;
            }
            nArray[n2] = this.m_geom.getElement((int)n5).m_data[n6];
            ++n2;
            if (piVectorArray[n5].m_data[(n6 + 2) % 3] != -1) {
                n5 = piVectorArray[n5].m_data[(n6 + 2) % 3];
                n6 = (this.parent[n5] + 2) % 3;
                piVector = this.m_geom.getElement(n5);
                n4 = this.parent[n5];
                while (n4 != (this.parent[n5] + 2) % 3) {
                    nArray[n2] = piVector.m_data[n4];
                    ++n2;
                    n4 = (n4 + 2) % 3;
                }
                block6: while (true) {
                    if (n6 != this.parent[n5]) {
                        if (piVectorArray[n5].m_data[n6] != -1) {
                            n4 = n5;
                            n5 = piVectorArray[n5].m_data[n6];
                            n6 = (this.m_geom.getOppVertexLocInd(n4, n6) + 2) % 3;
                            piVector = this.m_geom.getElement(n5);
                            n4 = this.parent[n5];
                            while (true) {
                                if (n4 == (this.parent[n5] + 2) % 3) continue block6;
                                nArray[n2] = piVector.m_data[n4];
                                ++n2;
                                n4 = (n4 + 2) % 3;
                            }
                        }
                        n6 = (n6 + 2) % 3;
                        continue;
                    }
                    if (piVectorArray[n5].m_data[n6] == this.data[n]) break;
                    n4 = n5;
                    n5 = piVectorArray[n5].m_data[n6];
                    n6 = (this.m_geom.getOppVertexLocInd(n4, n6) + 2) % 3;
                }
            }
            n5 = this.data[n];
            n6 = (this.parent[n5] + 2) % 3;
            nArray[n2] = this.m_geom.getElement((int)n5).m_data[n6];
            ++n2;
            if (piVectorArray[n5].m_data[(n6 + 2) % 3] != -1) {
                n5 = piVectorArray[n5].m_data[(n6 + 2) % 3];
                n6 = (this.parent[n5] + 2) % 3;
                piVector = this.m_geom.getElement(n5);
                n4 = this.parent[n5];
                while (n4 != (this.parent[n5] + 2) % 3) {
                    nArray[n2] = piVector.m_data[n4];
                    ++n2;
                    n4 = (n4 + 2) % 3;
                }
                block9: while (true) {
                    if (n6 != this.parent[n5]) {
                        if (piVectorArray[n5].m_data[n6] != -1) {
                            n4 = n5;
                            n5 = piVectorArray[n5].m_data[n6];
                            n6 = (this.m_geom.getOppVertexLocInd(n4, n6) + 2) % 3;
                            piVector = this.m_geom.getElement(n5);
                            n4 = this.parent[n5];
                            while (true) {
                                if (n4 == (this.parent[n5] + 2) % 3) continue block9;
                                nArray[n2] = piVector.m_data[n4];
                                ++n2;
                                n4 = (n4 + 2) % 3;
                            }
                        }
                        n6 = (n6 + 2) % 3;
                        continue;
                    }
                    if (piVectorArray[n5].m_data[n6] == this.data[n]) {
                        n5 = this.data[n];
                        n6 = (this.parent[n5] + 2) % 3;
                        break;
                    }
                    n4 = n5;
                    n5 = piVectorArray[n5].m_data[n6];
                    n6 = (this.m_geom.getOppVertexLocInd(n4, n6) + 2) % 3;
                }
            }
            if (piVectorArray[this.data[n]].m_data[this.parent[this.data[n]]] == -1) break;
            piVector = this.m_geom.getElement(this.data[n]);
            n4 = this.parent[this.data[n]];
            PiVector piVector2 = this.m_geom.getElement(piVectorArray[this.data[n]].m_data[n4]);
            if (piVector.m_data[(n4 + 1) % 3] == piVector2.m_data[(this.m_geom.getOppVertexLocInd(this.data[n], n4) + 1) % 3]) {
                pdVector.normalOfPlane(this.m_geom.getVertex(piVector.m_data[(n4 + 1) % 3]), this.m_geom.getVertex(piVector.m_data[(n4 + 2) % 3]), this.m_geom.getVertex(piVector.m_data[n4]));
                pdVector2.normalOfPlane(this.m_geom.getVertex(piVector2.m_data[1]), this.m_geom.getVertex(piVector2.m_data[0]), this.m_geom.getVertex(piVector2.m_data[2]));
            } else {
                pdVector.normalOfPlane(this.m_geom.getVertex(piVector.m_data[(n4 + 1) % 3]), this.m_geom.getVertex(piVector.m_data[(n4 + 2) % 3]), this.m_geom.getVertex(piVector.m_data[n4]));
                pdVector2.normalOfPlane(this.m_geom.getVertex(piVector2.m_data[0]), this.m_geom.getVertex(piVector2.m_data[1]), this.m_geom.getVertex(piVector2.m_data[2]));
            }
            d2 = PdVector.angle((PdVector)pdVector, (PdVector)pdVector2);
            d2 *= d;
            pdMatrix2.setColumn(0, PdVector.subNew((PdVector)this.m_geom.getVertex(piVector.m_data[(n4 + 2) % 3]), (PdVector)this.m_geom.getVertex(piVector.m_data[(n4 + 1) % 3])));
            pdMatrix2.setColumn(1, pdVector);
            pdMatrix2.setColumn(2, pdVector2);
            if (pdMatrix2.det() < 0.0) {
                d2 = -d2;
            }
            if ((pdMatrix = PuReflect.rotateLine((PdVector)this.m_geom.getVertex(piVector.m_data[(n4 + 1) % 3]), (PdVector)PdVector.subNew((PdVector)this.m_geom.getVertex(piVector.m_data[(n4 + 2) % 3]), (PdVector)this.m_geom.getVertex(piVector.m_data[(n4 + 1) % 3])), (double)(d2 * Math.PI / 180.0))) != null) {
                int n7 = 0;
                while (n7 < n2) {
                    pdVector3 = this.m_geom.getVertex(nArray[n7]);
                    pdVector4.copy(pdVector3);
                    pdVector3.leftMultAffin(pdMatrix, pdVector4, true);
                    ++n7;
                }
            }
            --n;
            n2 = 0;
        }
        this.arrangeParts(d);
        if (d == 1.0 && this.genSplice) {
            this.generateSplice();
        }
        this.m_geom.makeElementNormals();
    }

    public boolean setTime(PsTimeEvent psTimeEvent) {
        double d = psTimeEvent.getTime();
        if (this.hasSplice) {
            this.removeSplice();
        }
        this.cut();
        this.flatten((d - this.m_anim.getMinTime()) / (this.m_anim.getMaxTime() - this.m_anim.getMinTime()));
        this.m_geom.update((Object)this.m_geom);
        return super.update((Object)this);
    }

    public PsAnimation getAnimation() {
        return this.m_anim;
    }

    public void setAnimation(PsAnimation psAnimation) {
        this.m_anim = psAnimation;
    }

    public boolean update(Object object) {
        return super.update(object);
    }

    public void setGeometry(PgElementSet pgElementSet) {
        if (pgElementSet == null) {
            PsDebug.warning((String)" Wrong argument. ");
            return;
        }
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)" Geometry not triangulated. Triangulating Geometry. ");
            return;
        }
        this.m_geom = pgElementSet;
        this.m_geom.makeNeighbour();
        this.m_geomCopy = new PgElementSet(3);
        this.m_geomCopy.copy((PgGeometry)this.m_geom);
        this.numOfElem = this.m_geom.getNumElements();
        this.data = new int[this.numOfElem];
        this.parent = new int[this.numOfElem];
        int n = 0;
        while (n < this.numOfElem) {
            this.parent[n] = -1;
            ++n;
        }
        this.hasSplice = false;
        this.isUnfold = false;
    }

    public PgElementSet getGeometry() {
        return this.m_geom;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean hasAnimation() {
        return this.m_anim == null;
    }

    protected void cut() {
        if (!this.isUnfold) {
            this.unfold();
        }
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PiVector[] piVectorArray = this.m_geom.getElements();
        PdVector[] pdVectorArray2 = this.m_geomCopy.getVertices();
        PiVector[] piVectorArray2 = this.m_geomCopy.getElements();
        int n = 0;
        while (n < this.numOfElem) {
            int n2 = 0;
            do {
                int n3 = 0;
                do {
                    pdVectorArray[piVectorArray[n].m_data[n2]].m_data[n3] = pdVectorArray2[piVectorArray2[n].m_data[n2]].m_data[n3];
                } while (++n3 < 3);
            } while (++n2 < 3);
            ++n;
        }
        this.m_geom.makeNeighbour();
    }

    protected void cancel() {
        if (this.m_geom == null) {
            PsDebug.warning((String)"Missing Geometry");
            return;
        }
        if (this.hasSplice) {
            this.removeSplice();
        }
        this.m_geom.copy((PgGeometry)this.m_geomCopy);
        this.setGeometry(this.m_geom);
        this.m_geom.update((Object)this.m_geom);
    }

    public void generateSplice() {
        if (this.hasSplice) {
            return;
        }
        if (this.m_sp == null) {
            this.m_sp = new PgElementSet(3);
            this.m_sp.setName("Splices of Unfolded Geometry");
            this.m_sp.setGlobalElementColor(Color.magenta);
            this.m_sp.setGlobalElementBackColor(Color.magenta);
            PdVector pdVector = new PdVector(3);
            PiVector[] piVectorArray = this.m_geom.getNeighbours();
            PiVector[] piVectorArray2 = this.m_geomCopy.getNeighbours();
            PdVector[] pdVectorArray = this.m_geom.getVertices();
            PiVector[] piVectorArray3 = this.m_geom.getElements();
            int n = 0;
            while (n < this.numOfElem) {
                int n2 = 0;
                do {
                    if (n >= piVectorArray2[n].m_data[n2] || piVectorArray[n].m_data[n2] != -1) continue;
                    double d = pdVectorArray[piVectorArray3[n].m_data[(n2 + 1) % 3]].m_data[0];
                    double d2 = pdVectorArray[piVectorArray3[n].m_data[(n2 + 1) % 3]].m_data[1];
                    double d3 = pdVectorArray[piVectorArray3[n].m_data[(n2 + 2) % 3]].m_data[0];
                    double d4 = pdVectorArray[piVectorArray3[n].m_data[(n2 + 2) % 3]].m_data[1];
                    pdVector.m_data[0] = d * 0.875 + d3 * 0.125;
                    pdVector.m_data[1] = d2 * 0.875 + d4 * 0.125;
                    pdVector.m_data[2] = 0.0;
                    this.m_sp.addVertex(pdVector);
                    pdVector.m_data[0] = d * 0.125 + d3 * 0.875;
                    pdVector.m_data[1] = d2 * 0.125 + d4 * 0.875;
                    this.m_sp.addVertex(pdVector);
                    double d5 = pdVectorArray[piVectorArray3[n].m_data[n2]].m_data[0];
                    double d6 = pdVectorArray[piVectorArray3[n].m_data[n2]].m_data[1];
                    if ((-d2 + d4) * (d5 - d) + (d - d3) * (d6 - d2) < 0.0) {
                        pdVector.m_data[0] = (-d2 + d4) / 10.0 + d * 0.375 + d3 * 0.625;
                        pdVector.m_data[1] = (d - d3) / 10.0 + d2 * 0.375 + d4 * 0.625;
                        this.m_sp.addVertex(pdVector);
                        pdVector.m_data[0] = (-d2 + d4) / 10.0 + d * 0.625 + d3 * 0.375;
                        pdVector.m_data[1] = (d - d3) / 10.0 + d2 * 0.625 + d4 * 0.375;
                        this.m_sp.addVertex(pdVector);
                        continue;
                    }
                    pdVector.m_data[0] = (d2 - d4) / 10.0 + d * 0.375 + d3 * 0.625;
                    pdVector.m_data[1] = (-d + d3) / 10.0 + d2 * 0.375 + d4 * 0.625;
                    this.m_sp.addVertex(pdVector);
                    pdVector.m_data[0] = (d2 - d4) / 10.0 + d * 0.625 + d3 * 0.375;
                    pdVector.m_data[1] = (-d + d3) / 10.0 + d2 * 0.625 + d4 * 0.375;
                    this.m_sp.addVertex(pdVector);
                } while (++n2 < 3);
                ++n;
            }
            int n3 = this.m_sp.getNumVertices();
            this.m_sp.setNumElements(n3 >> 2);
            this.m_sp.setNumElements(0);
            int n4 = 0;
            n = 0;
            while (n < n3) {
                n4 = this.m_sp.addElement(new PiVector(n, n + 1, n + 2, n + 3));
                n += 4;
            }
        }
        this.hasSplice = true;
        Enumeration enumeration = this.m_geom.getDisplays();
        while (enumeration.hasMoreElements()) {
            PvDisplayIf pvDisplayIf = (PvDisplayIf)enumeration.nextElement();
            pvDisplayIf.addGeometry((PgGeometryIf)this.m_sp);
        }
    }
}

