/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;
import jvx.geom.PwVectorField_IP;

public class PwVectorField
extends PsObject {
    public static final int TYPE_ROTATION = 0;
    public static final int TYPE_GRADIENT = 1;
    public static final int TYPE_STRAIGHT = 2;
    public static final int TYPE_LINEAR = 3;
    public static final int TYPE_Z_K = 4;
    protected int TYPE_MAX = 4;
    protected static final String[] TYPE_STRINGS = new String[]{"Rotary", "Sink/Source", "Straight", "Linear Transformation", "z^k"};
    private static final Color COLOR_NOTSELECTED = Color.red;
    private static final Color COLOR_SELECTED = Color.yellow;
    protected PgElementSet m_elemSet = null;
    protected boolean m_isShowingElements = false;
    protected PiVector m_centerType = null;
    protected PgPointSet m_centers = null;
    protected int m_dim = 0;
    protected PuInteger m_centerIndex;
    protected boolean m_makeTangential = true;
    protected PuInteger m_VFIndex;
    protected int m_numVF = 0;
    protected PgVectorField m_saveVF = null;
    protected PgVectorField m_VF = null;
    protected PvDisplayIf m_disp;
    protected PuDouble m_slope;
    protected PuDouble m_principleA;
    protected PuDouble m_principleB;
    protected PuDouble m_angleExp;
    protected PuDouble m_slope2;
    protected PuDouble m_centerInfluence;
    protected PuDouble m_angleStraight;
    protected PuDouble m_xStretch;
    protected PuDouble m_yStretch;
    protected PuDouble m_rotation;
    protected PuDouble m_zkFact;
    protected PuInteger m_power;
    protected static final int P_INFL = 0;
    protected static final int P_ANGSTR = 1;
    protected static final int P_SLOP = 2;
    protected static final int P_PRINCA = 3;
    protected static final int P_PRINCB = 4;
    protected static final int P_ANGEXP = 5;
    protected static final int P_SLOP2 = 6;
    protected static final int P_XSTRETCH = 7;
    protected static final int P_YSTRETCH = 8;
    protected static final int P_ROTATION = 9;
    protected static final int P_ZKFACT = 10;
    protected static final int P_POWER = 11;
    protected static final int NUM_PARAMS = 12;
    protected static final double[] P_DEF_VALUES;
    protected PdVector[] m_parameters = new PdVector[12];
    private static /* synthetic */ Class class$jvx$geom$PwVectorField;

    public int getCenterType(int n) {
        return this.m_centerType.getEntry(n);
    }

    public void clearCenter() {
        if (this.m_centers == null) {
            PsDebug.warning((String)"No centers.");
            return;
        }
        this.m_centers.setNumVertices(0);
        this.m_centerType.setSize(0);
        int n = 0;
        do {
            this.m_parameters[n].setSize(0);
        } while (++n < 12);
        this.m_centerIndex.setBounds(0, 0, 0, 0);
        this.update(this.m_centerIndex);
    }

    public void close() {
        if (this.m_saveVF != null) {
            this.m_VF.copy((PgGeometry)this.m_saveVF);
        }
        if (this.m_VF != null) {
            this.m_VF.update(null);
        }
        if (this.m_elemSet != null) {
            if (!this.m_elemSet.isShowingElements()) {
                this.m_elemSet.showElements(this.m_isShowingElements);
            }
            this.m_elemSet.update((Object)this.m_elemSet);
        }
        if (this.m_centers != null) {
            this.m_disp.removeGeometry((PgGeometryIf)this.m_centers);
        }
        if (this.m_elemSet != null) {
            this.m_elemSet.removeUpdateListener((PsUpdateIf)this);
        }
    }

    public void setDisplay(PvDisplayIf pvDisplayIf) {
        if (this.m_disp != null && this.m_centers != null) {
            this.m_disp.removeGeometry((PgGeometryIf)this.m_centers);
        }
        this.m_disp = pvDisplayIf;
        if (this.m_disp != null) {
            this.m_disp.addGeometry((PgGeometryIf)this.m_centers);
        }
    }

    public PwVectorField() {
        this(null);
    }

    public PwVectorField(PvDisplayIf pvDisplayIf) {
        this.setName("Model Vector Fields");
        this.m_VFIndex = new PuInteger("Selected VF", (PsUpdateIf)this);
        this.m_centerIndex = new PuInteger("Selected Sing.", (PsUpdateIf)this);
        this.m_slope = new PuDouble("Slope", (PsUpdateIf)this);
        this.m_slope2 = new PuDouble("Slope", (PsUpdateIf)this);
        this.m_principleA = new PuDouble("Principle A", (PsUpdateIf)this);
        this.m_principleB = new PuDouble("Principle B", (PsUpdateIf)this);
        this.m_angleExp = new PuDouble("Angle", (PsUpdateIf)this);
        this.m_centerInfluence = new PuDouble("Size", (PsUpdateIf)this);
        this.m_angleStraight = new PuDouble("Angle", (PsUpdateIf)this);
        this.m_xStretch = new PuDouble("x grad", (PsUpdateIf)this);
        this.m_yStretch = new PuDouble("y grad", (PsUpdateIf)this);
        this.m_rotation = new PuDouble("rotation", (PsUpdateIf)this);
        this.m_zkFact = new PuDouble("Factor", (PsUpdateIf)this);
        this.m_power = new PuInteger("Power k", (PsUpdateIf)this);
        this.m_centers = new PgPointSet(3);
        this.m_centers.setName("Singularities");
        this.m_centers.setGlobalVertexSize(3);
        this.m_centers.setNumVertices(0);
        this.m_centers.showVertexColors(true);
        this.m_centers.setParent((PsUpdateIf)this);
        this.m_centerType = new PiVector(0);
        this.m_centerType.setName("Types");
        int n = 0;
        do {
            this.m_parameters[n] = new PdVector(0);
            this.m_parameters[n].setName("Param " + (n + 1));
        } while (++n < 12);
        this.setDisplay(pvDisplayIf);
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwVectorField != null ? class$jvx$geom$PwVectorField : (class$jvx$geom$PwVectorField = PwVectorField.class$("jvx.geom.PwVectorField")))) {
            this.init();
        }
    }

    public int getSelectedVF() {
        return this.m_VFIndex.getValue() - 1;
    }

    public void removeVF(int n) {
        if (this.m_elemSet == null) {
            return;
        }
        if (n < 0 || n >= this.m_elemSet.getNumVectorFields()) {
            return;
        }
        this.m_elemSet.removeVectorField((PgGeometryIf)this.m_elemSet.getVectorField(n));
        this.m_numVF += -1;
        if (this.m_numVF > 0) {
            this.m_VFIndex.setBounds(1, this.m_numVF, 1, 2);
        } else {
            this.m_VFIndex.setBounds(0, 0, 1, 2);
        }
        this.m_VFIndex.update((Object)this.m_VFIndex);
        if (this.m_disp != null) {
            // empty if block
        }
        this.m_disp.update((Object)this.m_elemSet);
        this.m_elemSet.update(null);
    }

    public void fixVF() {
        if (this.m_VF == null) {
            return;
        }
        if (this.m_saveVF == null) {
            this.m_saveVF = new PgVectorField(this.m_dim);
        }
        this.m_saveVF.copy((PgGeometry)this.m_VF);
        this.clearCenter();
        this.calculateVF();
        this.m_VF.update(null);
        this.m_elemSet.update(null);
    }

    public void calculateVF() {
        int n;
        if (this.m_centers == null) {
            PsDebug.warning((String)"No centers.");
            return;
        }
        if (this.m_VF == null) {
            PsDebug.warning((String)"No vector field selected.");
            return;
        }
        int n2 = this.m_VF.getNumVectors();
        if (n2 < 1) {
            return;
        }
        int n3 = this.m_saveVF.getNumVectors();
        int n4 = this.m_centers.getNumVertices();
        if (this.m_centerIndex.getValue() > 0) {
            n = 0;
            while (n < n4) {
                this.m_centers.setVertexColor(n, COLOR_NOTSELECTED);
                ++n;
            }
            this.m_centers.setVertexColor(this.m_centerIndex.getValue() - 1, COLOR_SELECTED);
        }
        n = this.m_VF.getBasedOn();
        PdVector[] pdVectorArray = this.m_elemSet.getVertices();
        PiVector[] piVectorArray = this.m_elemSet.getElements();
        PdVector[] pdVectorArray2 = this.m_VF.getVectors();
        PdVector[] pdVectorArray3 = this.m_saveVF.getVectors();
        PdVector[] pdVectorArray4 = this.m_elemSet.getElementNormals();
        PdVector[] pdVectorArray5 = this.m_elemSet.getVertexNormals();
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        PdVector pdVector3 = null;
        PdVector pdVector4 = null;
        int n5 = 0;
        while (n5 < n2) {
            int n6;
            int n7;
            if (n5 < n3) {
                pdVectorArray2[n5].copy(pdVectorArray3[n5]);
            } else {
                pdVectorArray2[n5].setConstant(0.0);
            }
            if (n == 0) {
                pdVector3 = pdVectorArray[n5];
                pdVector4 = pdVectorArray5[n5];
            } else if (n == 1) {
                pdVector3 = new PdVector(this.m_dim);
                n7 = piVectorArray[n5].getSize();
                n6 = 0;
                while (n6 < n7) {
                    pdVector3.add(pdVectorArray[piVectorArray[n5].getEntry(n6)]);
                    ++n6;
                }
                pdVector3.multScalar(1.0 / (double)n7);
                pdVector4 = pdVectorArray4[n5];
            }
            n7 = 0;
            while (n7 < n4) {
                PdVector pdVector5 = this.m_centers.getVertex(n7);
                n6 = this.m_centerType.getEntry(n7);
                switch (n6) {
                    case 2: {
                        double d3;
                        if (this.m_dim > 3) {
                            pdVector2.copy(pdVector5);
                            if (this.m_makeTangential) {
                                PuVectorGeom.projectOntoPlane((PdVector)pdVector2, (PdVector)pdVector4);
                            }
                            if (pdVector2.length() > 1.0E-10) {
                                pdVector2.normalize();
                            }
                        } else {
                            d3 = this.m_parameters[1].getEntry(n7) / 180.0 * Math.PI;
                            pdVector2.setEntry(0, Math.cos(d3));
                            pdVector2.setEntry(1, Math.sin(d3));
                        }
                        pdVector2.multScalar(this.m_parameters[0].getEntry(n7));
                        pdVectorArray2[n5].add(pdVector2);
                        break;
                    }
                    case 0: {
                        double d;
                        double d2;
                        double d3;
                        pdVector2.sub(pdVector5, pdVector3);
                        if (this.m_dim > 2) {
                            pdVector2.multScalar(Math.exp(-2.0 * pdVector2.length() * 0.5));
                            if (this.m_makeTangential && this.m_dim > 2) {
                                PuVectorGeom.projectOntoPlane((PdVector)pdVector2, (PdVector)pdVector4);
                            }
                            pdVector2.multScalar(this.m_parameters[2].getEntry(n7));
                            if (this.m_dim > 2) {
                                pdVector.cross(pdVector4, pdVector2);
                            } else if (this.m_dim == 2) {
                                pdVector.setEntry(0, -pdVector2.getEntry(1));
                                pdVector.setEntry(1, pdVector2.getEntry(0));
                            }
                            pdVector.setLength(pdVector2.length());
                        } else {
                            d3 = this.m_parameters[3].getEntry(n7);
                            if ((d3 *= d3) < 1.0E-10) {
                                d3 = 1.0E-10;
                            }
                            d2 = this.m_parameters[4].getEntry(n7);
                            if ((d2 *= d2) < 1.0E-10) {
                                d2 = 1.0E-10;
                            }
                            d = this.m_parameters[2].getEntry(n7);
                            double d4 = Math.sqrt(Math.exp(1.0));
                            double d5 = this.m_parameters[5].getEntry(n7) / 180.0 * Math.PI;
                            double d6 = Math.sin(d5);
                            double d7 = Math.cos(d5);
                            double d8 = pdVector2.getEntry(0);
                            double d9 = pdVector2.getEntry(1);
                            double d10 = d8 * d7 + d9 * d6;
                            double d11 = d9 * d7 - d8 * d6;
                            double d12 = Math.exp(-0.5 * (d10 * d10 / d3 + d11 * d11 / d2));
                            pdVector.setEntry(0, -d * d4 / 2.0 * (d3 + d2) * (d10 * d6 / d3 + d11 * d7 / d2) * d12);
                            pdVector.setEntry(1, d * d4 / 2.0 * (d3 + d2) * (d10 * d7 / d3 - d11 * d6 / d2) * d12);
                        }
                        pdVectorArray2[n5].add(pdVector);
                        break;
                    }
                    case 1: {
                        pdVector2.sub(pdVector5, pdVector3);
                        pdVector2.multScalar(Math.exp(-2.0 * pdVector2.length() * 0.5));
                        if (this.m_makeTangential && this.m_dim > 2) {
                            PuVectorGeom.projectOntoPlane((PdVector)pdVector2, (PdVector)pdVector4);
                        }
                        pdVector2.multScalar(this.m_parameters[6].getEntry(n7));
                        pdVectorArray2[n5].add(pdVector2);
                        break;
                    }
                    case 3: {
                        if (this.m_dim != 2) break;
                        pdVector2.sub(pdVector5, pdVector3);
                        double d3 = pdVector2.getEntry(0);
                        double d2 = pdVector2.getEntry(1);
                        double d = this.m_parameters[9].getEntry(n7);
                        pdVector.setEntry(0, this.m_parameters[7].getEntry(n7) * d3 - d * d2);
                        pdVector.setEntry(1, this.m_parameters[8].getEntry(n7) * d2 + d * d3);
                        pdVectorArray2[n5].add(pdVector);
                        break;
                    }
                    case 4: {
                        double d;
                        if (this.m_dim != 2) break;
                        pdVector2.sub(pdVector5, pdVector3);
                        double d3 = pdVector2.getEntry(0) / 8.0;
                        double d2 = -pdVector2.getEntry(1) / 8.0;
                        int n8 = (int)this.m_parameters[11].getEntry(n7) - 1;
                        if (n8 == 0) {
                            d3 = 1.0;
                            d2 = 0.0;
                        } else if (n8 == -1) {
                            d3 = 0.0;
                            d2 = 0.0;
                        } else {
                            int n9 = 1;
                            while (n9 < n8) {
                                d = d2;
                                d2 = 2.0 * d3 * d2;
                                d3 = d3 * d3 - d * d;
                                ++n9;
                            }
                            double d13 = this.m_parameters[10].getEntry(n7);
                            d3 *= (double)(n8 + 1) * d13;
                            d2 *= (double)(n8 + 1) * d13;
                        }
                        pdVector.setEntry(0, d3);
                        pdVector.setEntry(1, d2);
                        pdVectorArray2[n5].add(pdVector);
                    }
                }
                ++n7;
            }
            ++n5;
        }
        if (this.m_VF.hasInspector("Info") && this.m_VF.getInspector("Info").isShowing()) {
            this.m_VF.getInspector("Info").update((Object)this.m_VF);
        }
    }

    public void selectCenter(int n) {
        this.m_centerIndex.setValue(n + 1);
        this.update(this.m_centerIndex);
    }

    public void setCenterInfluence(int n, double d) {
        if (this.m_centers == null) {
            PsDebug.warning((String)"No centers.");
            return;
        }
        if (n < 0 || n >= this.m_centers.getNumVertices()) {
            PsDebug.warning((String)("Invalid center index = " + n + "."));
            return;
        }
        this.m_parameters[0].setEntry(n, d);
        this.update(this.m_centerIndex);
    }

    public boolean update(Object object) {
        if (object == null) {
            return super.update(object);
        }
        if (object == this && this.m_VF != null && this.m_elemSet != null) {
            this.calculateVF();
            this.m_VF.update(null);
            this.m_elemSet.update(null);
        } else {
            if (object == this.m_VFIndex) {
                if (this.m_numVF == 0) {
                    return super.update(null);
                }
                int n = this.m_VFIndex.getValue();
                if (n > this.m_numVF) {
                    n = this.m_numVF;
                } else if (n < 1) {
                    n = 1;
                }
                this.selectVF(n - 1);
                return super.update(null);
            }
            if (object == this.m_centers) {
                PwVectorField_IP pwVectorField_IP;
                int n;
                int n2;
                int n3;
                if (this.m_centers.getNumVertices() > this.m_centerType.getSize()) {
                    n3 = this.m_centerType.getSize();
                    n2 = this.m_centers.getNumVertices();
                    this.m_centerType.setSize(n2);
                    n = 0;
                    do {
                        this.m_parameters[n].setSize(n2);
                    } while (++n < 12);
                    n = n3;
                    while (n < n2) {
                        this.m_centerType.setEntry(n, 0);
                        int n4 = 0;
                        do {
                            this.m_parameters[n4].setEntry(n, 1.0);
                        } while (++n4 < 12);
                        ++n;
                    }
                    this.m_centerIndex.setBounds(1, n2, 1, 2);
                    this.m_centerIndex.setValue(n2);
                    this.m_centerIndex.update((Object)this.m_centerIndex);
                }
                n3 = this.m_centers.getNumVertices();
                n2 = this.m_centerIndex.getValue();
                n = 0;
                while (n < n3) {
                    if (this.m_centers.hasTagVertex(n, 1)) {
                        this.m_centerIndex.setValue(n + 1);
                        break;
                    }
                    ++n;
                }
                if (n2 != this.m_centerIndex.getValue() && (pwVectorField_IP = (PwVectorField_IP)this.getInfoPanel()) != null) {
                    pwVectorField_IP.update((Object)this);
                }
                this.calculateVF();
                this.m_VF.update(null);
                if (this.m_disp != null) {
                    this.m_disp.update((Object)this.m_elemSet);
                }
                return super.update(null);
            }
            if (object == this.m_infoPanel) {
                this.calculateVF();
                this.m_VF.update(null);
                this.m_elemSet.update((Object)this.m_elemSet);
                return true;
            }
            if (object == this.m_centerIndex) {
                PwVectorField_IP pwVectorField_IP = (PwVectorField_IP)this.getInfoPanel();
                if (pwVectorField_IP == null) {
                    return super.update(null);
                }
                pwVectorField_IP.update((Object)this);
                this.m_centers.update(null);
                return super.update(null);
            }
            if (object == this.m_elemSet) {
                this.updateElemSet();
                return true;
            }
            if (object == this.m_centerInfluence) {
                this.m_parameters[0].setEntry(this.m_centerIndex.getValue() - 1, this.m_centerInfluence.getValue());
            } else if (object == this.m_angleStraight) {
                this.m_parameters[1].setEntry(this.m_centerIndex.getValue() - 1, this.m_angleStraight.getValue());
            } else if (object == this.m_slope) {
                this.m_parameters[2].setEntry(this.m_centerIndex.getValue() - 1, this.m_slope.getValue());
            } else if (object == this.m_principleA) {
                this.m_parameters[3].setEntry(this.m_centerIndex.getValue() - 1, this.m_principleA.getValue());
            } else if (object == this.m_principleB) {
                this.m_parameters[4].setEntry(this.m_centerIndex.getValue() - 1, this.m_principleB.getValue());
            } else if (object == this.m_angleExp) {
                this.m_parameters[5].setEntry(this.m_centerIndex.getValue() - 1, this.m_angleExp.getValue());
            } else if (object == this.m_slope2) {
                this.m_parameters[6].setEntry(this.m_centerIndex.getValue() - 1, this.m_slope2.getValue());
            } else if (object == this.m_xStretch) {
                this.m_parameters[7].setEntry(this.m_centerIndex.getValue() - 1, this.m_xStretch.getValue());
            } else if (object == this.m_yStretch) {
                this.m_parameters[8].setEntry(this.m_centerIndex.getValue() - 1, this.m_yStretch.getValue());
            } else if (object == this.m_rotation) {
                this.m_parameters[9].setEntry(this.m_centerIndex.getValue() - 1, this.m_rotation.getValue());
            } else if (object == this.m_zkFact) {
                this.m_parameters[10].setEntry(this.m_centerIndex.getValue() - 1, this.m_zkFact.getValue());
            } else if (object == this.m_power) {
                this.m_parameters[11].setEntry(this.m_centerIndex.getValue() - 1, this.m_power.getValue());
            } else {
                return super.update(object);
            }
        }
        this.calculateVF();
        this.m_VF.update(null);
        if (this.m_disp != null) {
            // empty if block
        }
        this.m_disp.update((Object)this.m_elemSet);
        return super.update(null);
    }

    public PgElementSet getElementSet() {
        return this.m_elemSet;
    }

    static {
        double[] dArray = new double[12];
        dArray[0] = 1.0;
        dArray[2] = 0.2;
        dArray[3] = 2.0;
        dArray[4] = 1.0;
        dArray[5] = 30.0;
        dArray[6] = 1.0;
        dArray[7] = 0.1;
        dArray[8] = 0.1;
        dArray[9] = 0.1;
        dArray[10] = 1.0;
        dArray[11] = 2.0;
        P_DEF_VALUES = dArray;
    }

    public void setGeometry(PgElementSet pgElementSet) {
        this.m_elemSet = pgElementSet;
        this.m_isShowingElements = this.m_elemSet.isShowingElements();
        this.m_elemSet.addUpdateListener((PsUpdateIf)this);
        this.m_elemSet.makeElementNormals();
        this.m_elemSet.makeVertexNormals();
        this.m_elemSet.showElements(false);
        this.m_elemSet.showVectorArrow(true);
        this.updateElemSet();
        if (this.m_disp != null) {
            this.m_disp.selectGeometry((PgGeometryIf)this.m_centers);
        }
    }

    public void makeNewVF(int n) {
        if (this.m_elemSet == null) {
            PsDebug.warning((String)"No element set.");
            return;
        }
        PgVectorField pgVectorField = new PgVectorField(this.m_dim, n);
        pgVectorField.setGeometry((PgPointSet)this.m_elemSet);
        ++this.m_numVF;
        this.m_elemSet.addVectorField(pgVectorField);
        this.m_VFIndex.setBounds(1, this.m_numVF, 1, 2);
        if (this.m_numVF == 1) {
            this.selectVF(0);
        }
        this.m_VFIndex.update((Object)this.m_VFIndex);
        this.m_elemSet.update(null);
    }

    public int getSelectedCenter() {
        return this.m_centerIndex.getValue() - 1;
    }

    public void removeCenter(int n) {
        if (this.m_centers == null) {
            PsDebug.warning((String)"No centers.");
            return;
        }
        if (n < 0 || n >= this.m_centers.getNumVertices()) {
            return;
        }
        this.m_centers.removeVertex(n);
        int n2 = this.m_centers.getNumVertices();
        int n3 = n;
        while (n3 < n2) {
            this.m_centerType.setEntry(n3, this.m_centerType.getEntry(n3 + 1));
            int n4 = 0;
            do {
                this.m_parameters[n4].setEntry(n3, this.m_parameters[n4].getEntry(n3 + 1));
            } while (++n4 < 12);
            ++n3;
        }
        this.m_centerType.setSize(n2);
        n3 = 0;
        do {
            this.m_parameters[n3].setSize(n2);
        } while (++n3 < 12);
        this.m_centerIndex.setBounds(1, n2, 1, 2);
        this.update(this.m_centerIndex);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void addCenter(int n) {
        if (this.m_centers == null) {
            PsDebug.warning((String)"missing centers.");
            return;
        }
        PdVector pdVector = new PdVector(this.m_dim);
        pdVector.setConstant(0.01);
        this.m_centers.addVertex(pdVector);
        int n2 = this.m_centers.getNumVertices();
        this.m_centerType.setSize(n2);
        this.m_centerType.setEntry(n2 - 1, n);
        int n3 = 0;
        do {
            this.m_parameters[n3].setSize(n2);
            this.m_parameters[n3].setEntry(n2 - 1, P_DEF_VALUES[n3]);
        } while (++n3 < 12);
        this.m_centers.update((Object)this.m_centers);
        this.m_centerIndex.setBounds(1, n2, 1, 2);
        this.m_centerIndex.update((Object)this.m_centerIndex);
    }

    public void addCenter(int n, double d) {
        if (this.m_centers == null) {
            PsDebug.warning((String)"No centers.");
            return;
        }
        PdVector pdVector = new PdVector(this.m_dim);
        pdVector.setConstant(0.01);
        this.m_centers.addVertex(pdVector);
        int n2 = this.m_centers.getNumVertices();
        this.m_centerType.setSize(n2);
        this.m_centerType.setEntry(n2 - 1, n);
        int n3 = 0;
        do {
            this.m_parameters[n3].setSize(n2);
            this.m_parameters[n3].setEntry(n2 - 1, d);
        } while (++n3 < 12);
        this.m_centers.update((Object)this.m_centers);
        this.m_centerIndex.setBounds(1, n2, 1, 2);
        this.m_centerIndex.update((Object)this.m_centerIndex);
    }

    public void addCenter(PdVector pdVector, int n, double d) {
        this.addCenter(n, d);
        this.m_centers.setVertex(this.m_centers.getNumVertices() - 1, pdVector);
    }

    public void addCenter(PdVector pdVector, int n) {
        this.addCenter(n);
        this.m_centers.setVertex(this.m_centers.getNumVertices() - 1, pdVector);
    }

    public void init() {
        this.m_VFIndex.setDefBounds(1, this.m_numVF, 1, 2);
        this.m_VFIndex.setDefValue(this.m_numVF);
        this.m_VFIndex.init();
        int n = 1;
        if (this.m_centers.getNumVertices() == 0) {
            n = 0;
        }
        this.m_centerIndex.setDefBounds(n, this.m_centers.getNumVertices(), 1, 2);
        this.m_centerIndex.setDefValue(this.m_centers.getNumVertices());
        this.m_centerIndex.init();
        this.m_slope.setDefBounds(-2.0, 2.0, 0.05, 0.5);
        this.m_slope.setDefValue(0.3);
        this.m_slope.init();
        this.m_principleA.setDefBounds(0.01, 5.0, 0.1, 1.0);
        this.m_principleA.setDefValue(1.0);
        this.m_principleA.init();
        this.m_principleB.setDefBounds(0.01, 5.0, 0.1, 1.0);
        this.m_principleB.setDefValue(1.0);
        this.m_principleB.init();
        this.m_angleExp.setDefBounds(-180.0, 180.0, 1.0, 10.0);
        this.m_angleExp.setDefValue(0.0);
        this.m_angleExp.init();
        this.m_slope.setDefBounds(-2.0, 2.0, 0.05, 0.5);
        this.m_slope.setDefValue(0.1);
        this.m_slope.init();
        this.m_centerInfluence.setDefBounds(-5.0, 5.0, 0.1, 1.0);
        this.m_centerInfluence.setDefValue(1.0);
        this.m_centerInfluence.init();
        this.m_angleStraight.setDefBounds(-180.0, 180.0, 1.0, 10.0);
        this.m_angleStraight.setDefValue(0.0);
        this.m_angleStraight.init();
        this.m_xStretch.setDefBounds(-2.0, 2.0, 0.05, 0.5);
        this.m_xStretch.setDefValue(0.1);
        this.m_xStretch.init();
        this.m_yStretch.setDefBounds(-2.0, 2.0, 0.05, 0.5);
        this.m_yStretch.setDefValue(0.1);
        this.m_yStretch.init();
        this.m_rotation.setDefBounds(-2.0, 2.0, 0.05, 0.5);
        this.m_rotation.setDefValue(0.1);
        this.m_rotation.init();
        this.m_zkFact.setDefBounds(0.0, 3.0, 0.1, 0.5);
        this.m_zkFact.setDefValue(0.1);
        this.m_zkFact.init();
        this.m_power.setDefBounds(0, 6, 1, 2);
        this.m_power.setDefValue(2);
        this.m_power.init();
    }

    protected void updateElemSet() {
        this.m_dim = this.m_elemSet.getDimOfVertices();
        if (this.m_centers == null || this.m_centers.getDimOfVertices() != this.m_dim) {
            if (this.m_centers != null && this.m_disp != null) {
                this.m_disp.removeGeometry((PgGeometryIf)this.m_centers);
            }
            this.m_centers = new PgPointSet(this.m_dim);
            this.m_centers.setName("Singularities");
            this.m_centers.setGlobalVertexSize(3);
            this.m_centers.setNumVertices(0);
            this.m_centers.showVertexColors(true);
            this.m_centers.setParent((PsUpdateIf)this);
            if (this.m_disp != null) {
                this.m_disp.addGeometry((PgGeometryIf)this.m_centers);
            }
        }
        if (this.m_saveVF != null && this.m_VF != null) {
            int n = Math.min(this.m_saveVF.getNumVectors(), this.m_VF.getNumVectors());
            int n2 = 0;
            while (n2 < n) {
                this.m_VF.setVector(n2, this.m_saveVF.getVector(n2));
                ++n2;
            }
            this.m_saveVF.copy((PgGeometry)this.m_VF);
        }
        if (!this.m_elemSet.hasElementNormals()) {
            this.m_elemSet.makeElementNormals();
        }
        if (!this.m_elemSet.hasVertexNormals()) {
            this.m_elemSet.makeVertexNormals();
        }
        if (this.m_elemSet.getDimOfVertices() > 2) {
            this.m_principleA.setEnabled(false);
            this.m_principleB.setEnabled(false);
            this.m_angleExp.setEnabled(false);
            this.TYPE_MAX = 2;
        } else {
            this.m_principleA.setEnabled(true);
            this.m_principleB.setEnabled(true);
            this.m_angleExp.setEnabled(true);
            this.TYPE_MAX = 4;
        }
        if (this.getInfoPanel() != null) {
            this.getInfoPanel().update((Object)this);
        }
        this.m_numVF = this.m_elemSet.getNumVectorFields();
        if (this.m_numVF < 1) {
            this.m_VFIndex.setBounds(0, this.m_numVF, 1, 2);
        } else {
            this.m_VFIndex.setBounds(1, this.m_numVF, 1, 2);
        }
        this.m_VFIndex.update((Object)this.m_VFIndex);
    }

    public int getNumVectorFields() {
        return this.m_numVF;
    }

    public void setMakeTangential(boolean bl) {
        this.m_makeTangential = bl;
    }

    public int getNumCenters() {
        if (this.m_centers == null) {
            return 0;
        }
        return this.m_centers.getNumVertices();
    }

    public void selectVF(int n) {
        if (this.m_elemSet == null) {
            PsDebug.warning((String)"No element set.");
            return;
        }
        if (n < 0 || n >= this.m_numVF) {
            PsDebug.warning((String)("No valid vector field index = " + n + "."));
            return;
        }
        if (this.m_saveVF != null && this.m_VF != null) {
            this.m_VF.copy((PgGeometry)this.m_saveVF);
        }
        this.m_VF = this.m_elemSet.getVectorField(n);
        if (this.m_saveVF == null) {
            this.m_saveVF = new PgVectorField(this.m_dim);
        }
        this.m_saveVF.copy((PgGeometry)this.m_VF);
        this.m_VFIndex.setValue(n + 1);
        this.calculateVF();
        this.m_VF.update(null);
        if (this.m_disp != null) {
            this.m_disp.update((Object)this.m_elemSet);
        }
        PwVectorField_IP pwVectorField_IP = (PwVectorField_IP)this.getInfoPanel();
        pwVectorField_IP.updateField();
    }

    public void setCenterType(int n, int n2) {
        if (this.m_centers == null) {
            PsDebug.warning((String)"No centers.");
            return;
        }
        if (n < 0 || n >= this.m_centers.getNumVertices()) {
            PsDebug.warning((String)("Invalid center index = " + n + "."));
            return;
        }
        if (n2 < 0 || n2 > this.TYPE_MAX) {
            PsDebug.warning((String)("Invalid center type = " + n2 + "."));
            return;
        }
        this.m_centerType.setEntry(n, n2);
        this.update(this.m_centerIndex);
    }
}

