/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import jv.loader.PgLoaderIf;
import jv.loader.PvDisplayOption;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgDxfLoader
implements PgLoaderIf {
    protected static final int ENTITY_LINE = 100;
    protected static final int ENTITY_POINT = 101;
    protected static final int ENTITY_CIRCLE = 102;
    protected static final int ENTITY_ARC = 103;
    protected static final int ENTITY_TRACE = 104;
    protected static final int ENTITY_SOLID = 105;
    protected static final int ENTITY_TEXT = 106;
    protected static final int ENTITY_SHAPE = 107;
    protected static final int ENTITY_BLOCK = 108;
    protected static final int ENTITY_ENDBLK = 109;
    protected static final int ENTITY_INSERT = 110;
    protected static final int ENTITY_ATTDEF = 111;
    protected static final int ENTITY_ATTRIB = 112;
    protected static final int ENTITY_POLYLINE = 113;
    protected static final int ENTITY_VERTEX = 114;
    protected static final int ENTITY_SEQEND = 115;
    protected static final int ENTITY_3DFACE = 116;
    protected static final int ENTITY_VIEWPORT = 117;
    protected static final int ENTITY_DIMENSION = 118;
    protected static final int ENTITY_LINEAR = 119;
    protected static final int ENTITY_ANGULAR = 120;
    protected static final int ENTITY_DIAMETER = 121;
    protected static final int ENTITY_RADIUS = 122;
    protected static final int ENTITY_ORDINATE = 123;
    protected int m_numVertices = 0;
    protected int m_numPolygons = 0;
    protected int m_numElements = 0;
    protected Vector m_vVertex;
    protected int m_dimOfElements = -1;
    protected Vector m_vElement;
    protected int m_dimOfPolygons = -1;
    protected Vector m_vPolygon;
    private int m_code;
    private int m_ival;
    private double m_dval;
    private String m_sval;
    protected boolean m_bIsAnimation = false;
    private BufferedReader m_bufReader;
    private static final String StrNL = "\n";
    protected static boolean m_bVertexNormals = false;
    protected static boolean m_bVertexTextures = false;
    protected static boolean m_bVertexVector = false;
    protected static boolean m_bElements = false;
    protected static boolean m_bPolygons = false;
    protected static boolean m_bPolygonColors = false;
    protected static boolean m_bPolygonNormals = false;

    protected static String writePolygons(int n, PiVector[] piVectorArray) {
        if (n <= 0 && piVectorArray == null && n > piVectorArray.length) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("# Polygon List\n");
        stringBuffer.append("# Number of Polygons = " + n + StrNL);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("l ");
            if (piVectorArray[n2] == null) {
                return null;
            }
            int n3 = 0;
            while (n3 < piVectorArray[n2].m_data.length) {
                int n4 = piVectorArray[n2].m_data[n3] + 1;
                stringBuffer.append(n4);
                if (m_bPolygonNormals) {
                    stringBuffer.append("/" + n4);
                }
                if (n3 < piVectorArray[n2].m_data.length - 1) {
                    stringBuffer.append(" ");
                }
                ++n3;
            }
            stringBuffer.append(StrNL);
            ++n2;
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected PgJvxSrc[] parse(BufferedReader bufferedReader) {
        this.m_bufReader = bufferedReader;
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.commentChar(35);
        streamTokenizer.quoteChar(34);
        streamTokenizer.ordinaryChar(45);
        streamTokenizer.ordinaryChar(43);
        streamTokenizer.ordinaryChar(46);
        streamTokenizer.ordinaryChars(48, 48);
        streamTokenizer.ordinaryChars(49, 57);
        streamTokenizer.wordChars(94, 94);
        streamTokenizer.wordChars(38, 38);
        streamTokenizer.wordChars(36, 36);
        streamTokenizer.wordChars(40, 40);
        streamTokenizer.wordChars(41, 41);
        streamTokenizer.wordChars(126, 126);
        streamTokenizer.wordChars(64, 64);
        streamTokenizer.wordChars(45, 45);
        streamTokenizer.wordChars(43, 43);
        streamTokenizer.wordChars(42, 42);
        streamTokenizer.wordChars(48, 48);
        streamTokenizer.wordChars(49, 57);
        streamTokenizer.wordChars(46, 46);
        streamTokenizer.wordChars(44, 44);
        streamTokenizer.wordChars(59, 59);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.wordChars(58, 58);
        streamTokenizer.whitespaceChars(44, 44);
        streamTokenizer.whitespaceChars(61, 61);
        Vector<PgJvxSrc> vector = new Vector<PgJvxSrc>();
        try {
            block3: while (true) {
                int n;
                int n2;
                if ((n2 = this.parseGroup(streamTokenizer)) == 999) {
                    continue;
                }
                if (n2 == 0) {
                    if (this.m_sval.equals("SECTION") || this.m_sval.equals("TABLE") || this.m_sval.equals("ENDTAB")) continue;
                    if (this.m_sval.equals("EOF")) {
                        PgJvxSrc[] pgJvxSrcArray = new PgJvxSrc[vector.size()];
                        n = 0;
                        Enumeration enumeration = vector.elements();
                        while (enumeration.hasMoreElements()) {
                            pgJvxSrcArray[n++] = (PgJvxSrc)enumeration.nextElement();
                        }
                        return pgJvxSrcArray;
                    }
                    if (this.m_sval.equals("LINE") || this.m_sval.equals("3DFACE") || !this.m_sval.equals("LAYER")) continue;
                    continue;
                }
                if (n2 != 2) continue;
                if (this.m_sval.equals("HEADER")) {
                    n2 = this.parseGroup(streamTokenizer);
                    while (true) {
                        if (n2 == 0 && this.m_sval.equals("ENDSEC")) continue block3;
                        if (n2 == 9) {
                            if (this.m_sval.equals("$ACADVER")) {
                                n2 = this.parseGroup(streamTokenizer);
                                if (n2 != 1) throw new IOException("unexpected code=" + n2 + " in group=" + this.m_sval + " at line=" + streamTokenizer.lineno());
                                if (!this.m_sval.equals("AC1006") && !this.m_sval.equals("AC1008") && this.m_sval.equals("AC1009")) {
                                    // empty if block
                                }
                            } else if (!(this.m_sval.equals("$ANGBASE") || this.m_sval.equals("$ANGDIR") || this.m_sval.equals("$ATTDIA") || this.m_sval.equals("$ATTMODE") || this.m_sval.equals("$ATTREQ") || this.m_sval.equals("$AUNITS") || this.m_sval.equals("$AUPREC") || this.m_sval.equals("$AXISMODE") || this.m_sval.equals("$AXISUNIT") || this.m_sval.equals("$BLIPMODE") || this.m_sval.equals("$CECOLOR") || this.m_sval.equals("$CELTYPE") || this.m_sval.equals("$CHAMFERA") || this.m_sval.equals("$CHAMFERB") || this.m_sval.equals("$CLAYER") || this.m_sval.equals("$COORDS") || this.m_sval.equals("$DIMALT") || this.m_sval.equals("$DIMALTD") || this.m_sval.equals("$DIMALTF") || this.m_sval.equals("$DIMAPOST") || this.m_sval.equals("$DIMASO") || this.m_sval.equals("$DIMASZ") || this.m_sval.equals("$DIMBLK") || this.m_sval.equals("$DIMBLK1") || this.m_sval.equals("$DIMBLK2") || this.m_sval.equals("$DIMCEN") || this.m_sval.equals("$DIMCLRD") || this.m_sval.equals("$DIMCLRE") || this.m_sval.equals("$DIMCLRT") || this.m_sval.equals("$DIMDLE") || this.m_sval.equals("$DIMDLI") || this.m_sval.equals("$DIMEXE") || this.m_sval.equals("$DIMEXO") || this.m_sval.equals("$DIMGAP") || this.m_sval.equals("$DIMLFAC") || this.m_sval.equals("$DIMLIM") || this.m_sval.equals("$DIMPOST") || this.m_sval.equals("$DIMRND") || this.m_sval.equals("$DIMSAH") || this.m_sval.equals("$DIMSCALE") || this.m_sval.equals("$DIMSE1") || this.m_sval.equals("$DIMSE2") || this.m_sval.equals("$DIMSHO") || this.m_sval.equals("$DIMSOXD") || this.m_sval.equals("$DIMSTYLE") || this.m_sval.equals("$DIMTAD") || this.m_sval.equals("$DIMTFAC") || this.m_sval.equals("$DIMTIH") || this.m_sval.equals("$DIMTIX") || this.m_sval.equals("$DIMTM") || this.m_sval.equals("$DIMTOFL") || this.m_sval.equals("$DIMTOH") || this.m_sval.equals("$DIMTOL") || this.m_sval.equals("$DIMTP") || this.m_sval.equals("$DIMTSZ") || this.m_sval.equals("$DIMTVP") || this.m_sval.equals("$DIMTXT") || this.m_sval.equals("$DIMZIN") || this.m_sval.equals("$DWGCODEPAGE") || this.m_sval.equals("$DRAGMODE") || this.m_sval.equals("$ELEVATION") || this.m_sval.equals("$EXTMAX") || this.m_sval.equals("$EXTMIN") || this.m_sval.equals("$FILLETRAD") || this.m_sval.equals("$FILLMODE") || this.m_sval.equals("$HANDLING") || this.m_sval.equals("$HANDSEED") || this.m_sval.equals("$INSBASE") || this.m_sval.equals("$LIMCHECK") || this.m_sval.equals("$LIMMAX") || this.m_sval.equals("$LIMMIN") || this.m_sval.equals("$LTSCALE") || this.m_sval.equals("$LUNITS") || this.m_sval.equals("$LUPREC") || this.m_sval.equals("$MAXACTVP") || this.m_sval.equals("$MENU") || this.m_sval.equals("$MIRRTEXT") || this.m_sval.equals("$ORTHOMODE") || this.m_sval.equals("$OSMODE") || this.m_sval.equals("$PDMODE") || this.m_sval.equals("$PDSIZE") || this.m_sval.equals("$PELEVATION") || this.m_sval.equals("$PEXTMAX") || this.m_sval.equals("$PEXTMIN") || this.m_sval.equals("$PLIMCHECK") || this.m_sval.equals("$PLIMMAX") || this.m_sval.equals("$PLIMMIN") || this.m_sval.equals("$PLINEGEN") || this.m_sval.equals("$PLINEWID") || this.m_sval.equals("$PSLTSCALE") || this.m_sval.equals("$PUCSNAME") || this.m_sval.equals("$PUCSORG") || this.m_sval.equals("$PUCSXDIR") || this.m_sval.equals("$PUCSYDIR") || this.m_sval.equals("$QTEXTMODE") || this.m_sval.equals("$REGENMODE") || this.m_sval.equals("$SHADEDGE") || this.m_sval.equals("$SHADEDIF") || this.m_sval.equals("$SKETCHINC") || this.m_sval.equals("$SKPOLY") || this.m_sval.equals("$SPLFRAME") || this.m_sval.equals("$SPLINESEGS") || this.m_sval.equals("$SPLINETYPE") || this.m_sval.equals("$SURFTAB1") || this.m_sval.equals("$SURFTAB2") || this.m_sval.equals("$SURFTYPE") || this.m_sval.equals("$SURFU") || this.m_sval.equals("$SURFV") || this.m_sval.equals("$TDCREATE") || this.m_sval.equals("$TDINDWG") || this.m_sval.equals("$TDUPDATE") || this.m_sval.equals("$TDUSRTIMER") || this.m_sval.equals("$TEXTSIZE") || this.m_sval.equals("$TEXTSTYLE") || this.m_sval.equals("$THICKNESS") || this.m_sval.equals("$TILEMODE") || this.m_sval.equals("$TRACEWID") || this.m_sval.equals("$UCSNAME") || this.m_sval.equals("$UCSORG") || this.m_sval.equals("$UCSXDIR") || this.m_sval.equals("$UCSYDIR") || this.m_sval.equals("$UNITMODE") || this.m_sval.equals("$USERI1 - 5") || this.m_sval.equals("$USERR1 - 5") || this.m_sval.equals("$USRTIMER") || this.m_sval.equals("$VISRETAIN") || this.m_sval.equals("$WORLDVIEW"))) {
                                throw new IOException("unexpected group=" + this.m_sval + " at line=" + streamTokenizer.lineno());
                            }
                        }
                        n2 = this.parseGroup(streamTokenizer);
                    }
                }
                if (this.m_sval.equals("TABLES")) {
                    n2 = this.parseGroup(streamTokenizer);
                    while (true) {
                        if (n2 == 0 && this.m_sval.equals("ENDSEC")) continue block3;
                        n2 = this.parseGroup(streamTokenizer);
                    }
                }
                if (this.m_sval.equals("BLOCKS")) {
                    n2 = this.parseGroup(streamTokenizer);
                    while (true) {
                        if (n2 == 0 && this.m_sval.equals("ENDSEC")) continue block3;
                        n2 = this.parseGroup(streamTokenizer);
                    }
                }
                if (!this.m_sval.equals("ENTITIES")) throw new IOException("unexpected group=" + this.m_sval + " at line=" + streamTokenizer.lineno());
                String string = "0";
                this.m_numVertices = 0;
                this.m_numElements = 0;
                int n3 = 0;
                int n4 = 0;
                boolean bl = false;
                boolean bl2 = false;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                this.m_vVertex = new Vector();
                this.m_vElement = new Vector();
                this.m_vPolygon = new Vector();
                PgJvxSrc pgJvxSrc = new PgJvxSrc();
                int n9 = 0;
                double[][] dArray = new double[4][3];
                int n10 = -1;
                int n11 = -1;
                n2 = this.parseGroup(streamTokenizer);
                PiVector piVector = new PiVector(10);
                PiVector piVector2 = new PiVector(10);
                int[] nArray = piVector2.m_data;
                PiVector piVector3 = new PiVector(10);
                piVector3.setConstant(0);
                int[] nArray2 = piVector3.m_data;
                PiVector piVector4 = new PiVector(10);
                piVector4.setConstant(0);
                int[] nArray3 = piVector4.m_data;
                while (true) {
                    if (n2 == 0) {
                        Object object;
                        if (n10 != -1) {
                            if (n10 != 100 && n10 != 101 && n10 != 102 && n10 != 103 && n10 != 104 && n10 != 105 && n10 != 106 && n10 != 107 && n10 != 108 && n10 != 109 && n10 != 110 && n10 != 111 && n10 != 112) {
                                if (n10 == 113) {
                                    piVector.set(nArray2);
                                    piVector2.set(nArray3);
                                    if ((nArray[0] & 0x10) != 0) {
                                        n3 = nArray[1];
                                        n4 = nArray[2];
                                        n7 = n3 * n4;
                                        if ((nArray[0] & 1) != 0) {
                                            bl = true;
                                        }
                                        if ((nArray[0] & 0x20) != 0) {
                                            bl2 = true;
                                        }
                                    } else if ((nArray[0] & 0x40) != 0) {
                                        n7 = nArray[1];
                                        n8 = nArray[2];
                                    }
                                    piVector3.setConstant(0);
                                    piVector4.setConstant(0);
                                } else if (n10 == 114) {
                                    if (n11 == 113) {
                                        if ((nArray3[0] & 0x40) != 0) {
                                            object = new PdVector(dArray[0]);
                                            this.m_vVertex.addElement(object);
                                            ++this.m_numVertices;
                                            ++n5;
                                        } else if ((nArray3[0] & 0x80) != 0) {
                                            if ((nArray3[0] & 0x40) != 0) {
                                                object = new PdVector(dArray[0]);
                                                this.m_vVertex.addElement(object);
                                                ++this.m_numVertices;
                                                ++n5;
                                            } else {
                                                object = new PiVector();
                                                if (nArray3[4] == 0) {
                                                    object.setSize(3);
                                                    object.set(Math.abs(nArray3[1]) - 1, Math.abs(nArray3[2]) - 1, Math.abs(nArray3[3]) - 1);
                                                } else {
                                                    object.setSize(4);
                                                    object.set(Math.abs(nArray3[1]) - 1, Math.abs(nArray3[2]) - 1, Math.abs(nArray3[3]) - 1, Math.abs(nArray3[4]) - 1);
                                                }
                                                this.m_vElement.addElement(object);
                                                ++this.m_numElements;
                                                ++n6;
                                            }
                                        }
                                    } else {
                                        if (n9 != 1) {
                                            throw new IOException("missing vertex, nov = " + n9);
                                        }
                                        object = new PdVector(dArray[0]);
                                        this.m_vVertex.addElement(object);
                                        ++this.m_numVertices;
                                    }
                                } else if (n10 == 115) {
                                    if (n11 == 113) {
                                        if (n5 != n7) {
                                            PsDebug.warning((String)("unexpected number of vertices in polymesh: (expected/found)=(" + n7 + "/" + n5));
                                        }
                                        if (n6 != n8) {
                                            PsDebug.warning((String)("unexpected number of vertices in polymesh: (expected/found)=(" + n8 + "/" + n6));
                                        }
                                        pgJvxSrc.setType(33);
                                        if (this.m_numVertices > 0) {
                                            pgJvxSrc.setNumVertices(this.m_numVertices);
                                            n = 0;
                                            object = this.m_vVertex.elements();
                                            while (object.hasMoreElements()) {
                                                pgJvxSrc.setVertex(n++, (PdVector)object.nextElement());
                                            }
                                        }
                                        if ((nArray[0] & 0x10) != 0) {
                                            pgJvxSrc.makeQuadrConn(n3, n4, bl, bl2);
                                        } else if (this.m_numElements > 0) {
                                            pgJvxSrc.setDimOfElements(this.m_dimOfElements);
                                            pgJvxSrc.setNumElements(this.m_numElements);
                                            n = 0;
                                            object = this.m_vElement.elements();
                                            while (object.hasMoreElements()) {
                                                pgJvxSrc.setElement(n++, (PiVector)object.nextElement());
                                            }
                                        }
                                        vector.addElement(pgJvxSrc);
                                        this.m_numVertices = 0;
                                        this.m_numElements = 0;
                                        pgJvxSrc = null;
                                    }
                                    n11 = -1;
                                } else if (n10 == 116) {
                                    if (n9 != 4) {
                                        throw new IOException("missing vertex, nov = " + n9);
                                    }
                                    int n12 = 0;
                                    do {
                                        object = new PdVector(dArray[n12]);
                                        this.m_vVertex.addElement(object);
                                    } while (++n12 < 4);
                                    object = new PiVector(n9);
                                    object.set(this.m_numVertices, this.m_numVertices + 1, this.m_numVertices + 2, this.m_numVertices + 3);
                                    this.m_vElement.addElement(object);
                                    this.m_numVertices += 4;
                                    ++this.m_numElements;
                                    if (nArray3[0] != 0) {
                                        // empty if block
                                    }
                                } else if (n10 == 117 || n10 == 118 || n10 == 119 || n10 == 120 || n10 == 120 || n10 == 121 || n10 == 122 || n10 != 123) {
                                    // empty if block
                                }
                            }
                            n10 = -1;
                            piVector3.setConstant(0);
                            piVector4.setConstant(0);
                        }
                        if (this.m_sval.equals("ENDSEC")) {
                            if (pgJvxSrc == null) continue block3;
                            pgJvxSrc.setType(33);
                            if (this.m_numVertices > 0) {
                                pgJvxSrc.setNumVertices(this.m_numVertices);
                                n = 0;
                                object = this.m_vVertex.elements();
                                while (object.hasMoreElements()) {
                                    pgJvxSrc.setVertex(n++, (PdVector)object.nextElement());
                                }
                            }
                            if (this.m_numElements > 0) {
                                pgJvxSrc.setDimOfElements(this.m_dimOfElements);
                                pgJvxSrc.setNumElements(this.m_numElements);
                                n = 0;
                                object = this.m_vElement.elements();
                                while (object.hasMoreElements()) {
                                    pgJvxSrc.setElement(n++, (PiVector)object.nextElement());
                                }
                            }
                            vector.addElement(pgJvxSrc);
                            this.m_numVertices = 0;
                            this.m_numElements = 0;
                            pgJvxSrc = null;
                            continue block3;
                        }
                        n9 = 0;
                        if (this.m_sval.equals("POINT")) {
                            n10 = 100;
                        } else if (this.m_sval.equals("POINT")) {
                            n10 = 101;
                        } else if (this.m_sval.equals("CIRCLE")) {
                            n10 = 102;
                        } else if (this.m_sval.equals("ARC")) {
                            n10 = 103;
                        } else if (this.m_sval.equals("TRACE")) {
                            n10 = 104;
                        } else if (this.m_sval.equals("SOLID")) {
                            n10 = 105;
                        } else if (this.m_sval.equals("TEXT")) {
                            n10 = 106;
                        } else if (this.m_sval.equals("SHAPE")) {
                            n10 = 107;
                        } else if (this.m_sval.equals("BLOCK")) {
                            n10 = 108;
                        } else if (this.m_sval.equals("ENDBLK")) {
                            n10 = 109;
                        } else if (this.m_sval.equals("INSERT")) {
                            n10 = 110;
                        } else if (this.m_sval.equals("ATTDEF")) {
                            n10 = 111;
                        } else if (this.m_sval.equals("ATTRIB")) {
                            n10 = 112;
                        } else if (this.m_sval.equals("POLYLINE")) {
                            n11 = 113;
                            n10 = 113;
                        } else if (this.m_sval.equals("VERTEX")) {
                            n10 = 114;
                        } else if (this.m_sval.equals("SEQEND")) {
                            n10 = 115;
                        } else if (this.m_sval.equals("3DFACE")) {
                            n10 = 116;
                        } else if (this.m_sval.equals("VIEWPORT")) {
                            n10 = 117;
                        } else if (this.m_sval.equals("DIMENSION")) {
                            n10 = 118;
                        } else if (this.m_sval.equals("LINEAR")) {
                            n10 = 119;
                        } else if (this.m_sval.equals("ANGULAR")) {
                            n10 = 120;
                        } else if (this.m_sval.equals("ANGULAR")) {
                            n10 = 120;
                        } else if (this.m_sval.equals("DIAMETER")) {
                            n10 = 121;
                        } else if (this.m_sval.equals("RADIUS")) {
                            n10 = 122;
                        } else {
                            if (!this.m_sval.equals("ORDINATE")) throw new IOException("unexpected group=" + this.m_sval + " at line=" + streamTokenizer.lineno());
                            n10 = 123;
                        }
                    } else if (n2 != 5 && n2 != 6) {
                        if (n2 == 8) {
                            String string2 = this.m_sval;
                        } else if (n2 == 10) {
                            dArray[n9][0] = this.m_dval;
                            n2 = this.parseGroup(streamTokenizer);
                            if (n2 != 20) {
                                throw new IOException("missing y component of vertex");
                            }
                            dArray[n9][1] = this.m_dval;
                            n2 = this.parseGroup(streamTokenizer);
                            if (n2 != 30) {
                                throw new IOException("missing z component of vertex");
                            }
                            dArray[n9][2] = this.m_dval;
                            ++n9;
                        } else if (n2 == 11) {
                            dArray[n9][0] = this.m_dval;
                            n2 = this.parseGroup(streamTokenizer);
                            if (n2 != 21) {
                                throw new IOException("missing y component of vertex");
                            }
                            dArray[n9][1] = this.m_dval;
                            n2 = this.parseGroup(streamTokenizer);
                            if (n2 != 31) {
                                throw new IOException("missing z component of vertex");
                            }
                            dArray[n9][2] = this.m_dval;
                            ++n9;
                        } else if (n2 == 12) {
                            dArray[n9][0] = this.m_dval;
                            n2 = this.parseGroup(streamTokenizer);
                            if (n2 != 22) {
                                throw new IOException("missing y component of vertex");
                            }
                            dArray[n9][1] = this.m_dval;
                            n2 = this.parseGroup(streamTokenizer);
                            if (n2 != 32) {
                                throw new IOException("missing z component of vertex");
                            }
                            dArray[n9][2] = this.m_dval;
                            ++n9;
                        } else if (n2 == 13) {
                            dArray[n9][0] = this.m_dval;
                            n2 = this.parseGroup(streamTokenizer);
                            if (n2 != 23) {
                                throw new IOException("missing y component of vertex");
                            }
                            dArray[n9][1] = this.m_dval;
                            n2 = this.parseGroup(streamTokenizer);
                            if (n2 != 33) {
                                throw new IOException("missing z component of vertex");
                            }
                            dArray[n9][2] = this.m_dval;
                            ++n9;
                        } else if (n2 != 38 && n2 != 39) {
                            if (60 <= n2 && n2 <= 69) {
                                nArray2[n2 % 10] = this.m_ival;
                            } else if (70 <= n2 && n2 <= 79) {
                                nArray3[n2 % 10] = this.m_ival;
                            } else if (n2 == 210 || n2 == 220 || n2 != 230) {
                                // empty if block
                            }
                        }
                    }
                    n2 = this.parseGroup(streamTokenizer);
                }
                break;
            }
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning((String)("NumberFormatException thrown in line=" + streamTokenizer.lineno() + ", Exception = " + numberFormatException));
            return null;
        }
        catch (IOException iOException) {
            PsDebug.warning((String)("IOException thrown in line=" + streamTokenizer.lineno() + ", Exception = " + iOException));
            return null;
        }
    }

    private int parseInt(StreamTokenizer streamTokenizer) throws IOException, NumberFormatException {
        String string = this.readLine(streamTokenizer);
        if (string == null) {
            throw new NumberFormatException("Missing String");
        }
        return Integer.parseInt(string.trim());
    }

    private String parseString(StreamTokenizer streamTokenizer) throws IOException {
        String string = this.readLine(streamTokenizer);
        if (string == null) {
            return null;
        }
        return string.trim();
    }

    protected static String writePdVectors(String string, String string2, int n, PdVector[] pdVectorArray) {
        if (n <= 0 && pdVectorArray == null && n > pdVectorArray.length) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("# " + string + " List\n");
        stringBuffer.append("# Number of " + string + "s = " + n + StrNL);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(string2 + " ");
            if (pdVectorArray[n2] == null) {
                return null;
            }
            int n3 = 0;
            while (n3 < pdVectorArray[n2].m_data.length) {
                if (Math.abs(pdVectorArray[n2].m_data[n3]) > 1.0E-10) {
                    stringBuffer.append((float)pdVectorArray[n2].m_data[n3]);
                } else {
                    stringBuffer.append(0.0f);
                }
                if (n3 < pdVectorArray[n2].m_data.length - 1) {
                    stringBuffer.append(" ");
                }
                ++n3;
            }
            stringBuffer.append(StrNL);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning((String)"missing reader");
            return null;
        }
        PgJvxSrc[] pgJvxSrcArray = this.parse(bufferedReader);
        if (pgJvxSrcArray == null) {
            PsDebug.warning((String)"error during parsing of reader");
            return null;
        }
        return pgJvxSrcArray;
    }

    public PvDisplayOption getDisplayOption() {
        return null;
    }

    public void setDisplayOption(PvDisplayOption pvDisplayOption) {
    }

    public void setAnimation(boolean bl) {
        this.m_bIsAnimation = bl;
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) throws IOException {
        String string;
        int n;
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null) {
            PsDebug.warning((String)"missing geometry");
            return false;
        }
        PgJvxSrc pgJvxSrc = pgJvxSrcArray[0];
        writer.write("# Produced with JavaView v." + PsConfig.getVersion() + " by " + PsConfig.getAuthors() + StrNL);
        writer.write("# File Format = Wavefront OBJ\n");
        writer.write("# Geometry = " + pgJvxSrc.getName() + StrNL);
        writer.write("# Date = " + new Date().toString() + "\n#\n");
        int n2 = pgJvxSrc.getNumVertices();
        writer.write("# Number of Vertices = " + n2 + StrNL);
        int n3 = pgJvxSrc.getNumElements();
        if (n3 > 0) {
            writer.write("# Number of Elements = " + n3 + StrNL);
        }
        if ((n = pgJvxSrc.getNumPolygons()) > 0) {
            writer.write("# Number of Polygons = " + n + StrNL);
        }
        if (pgJvxSrc.getVertexNormals() != null) {
            writer.write("# Additional: Vertex Normals\n");
        }
        if (pgJvxSrc.getVertexTextures() != null) {
            writer.write("# Additional: Vertex Texture Coordinates\n");
        }
        writer.write("#\n# End of Header\n");
        writer.write(PgDxfLoader.writePdVectors("Vertex", "v", n2, pgJvxSrc.getVertices()));
        m_bVertexNormals = false;
        if (pgJvxSrc.getVertexNormals() != null && (string = PgDxfLoader.writePdVectors("Vertex Normal", "vn", n2, pgJvxSrc.getVertexNormals())) != null) {
            writer.write(string);
            m_bVertexNormals = true;
        }
        m_bVertexTextures = false;
        if (pgJvxSrc.getVertexTextures() != null && (string = PgDxfLoader.writePdVectors("Vertex Texture", "vt", n2, pgJvxSrc.getVertexTextures())) != null) {
            writer.write(string);
            m_bVertexTextures = true;
        }
        m_bElements = false;
        if (pgJvxSrc.getElements() != null && (string = PgDxfLoader.writeElements(n3, pgJvxSrc.getElements())) != null) {
            writer.write(string);
            m_bElements = true;
        }
        m_bPolygonNormals = false;
        if (pgJvxSrc.getPolygonNormals() != null && (string = PgDxfLoader.writePdVectors("Polygon Normal", "ln", n, pgJvxSrc.getPolygonNormals())) != null) {
            writer.write(string);
            m_bPolygonNormals = true;
        }
        m_bPolygons = false;
        if (pgJvxSrc.getPolygons() != null && (string = PgDxfLoader.writePolygons(n, pgJvxSrc.getPolygons())) != null) {
            writer.write(string);
            m_bPolygons = true;
        }
        return true;
    }

    private String readLine(StreamTokenizer streamTokenizer) throws IOException {
        return this.m_bufReader.readLine();
    }

    private int parseCode(StreamTokenizer streamTokenizer) throws IOException, NumberFormatException {
        return this.parseInt(streamTokenizer);
    }

    private double parseDouble(StreamTokenizer streamTokenizer) throws IOException, NumberFormatException {
        String string = this.readLine(streamTokenizer);
        if (string == null) {
            throw new NumberFormatException("Missing String");
        }
        return Double.valueOf(string.trim());
    }

    public boolean isAnimation() {
        return this.m_bIsAnimation;
    }

    private static void geomInitType(PgJvxSrc pgJvxSrc) {
        switch (pgJvxSrc.getType()) {
            case 30: {
                pgJvxSrc.showVertices(true);
                return;
            }
            case 33: {
                pgJvxSrc.assureNeighbours();
                pgJvxSrc.showEdges(true);
                pgJvxSrc.showElements(true);
                return;
            }
            case 32: {
                pgJvxSrc.showVertices(true);
                pgJvxSrc.showPolygons(true);
                pgJvxSrc.showEdges(true);
                return;
            }
        }
    }

    private int parseGroup(StreamTokenizer streamTokenizer) throws IOException, NumberFormatException {
        while ((this.m_code = this.parseCode(streamTokenizer)) == 999) {
            this.readLine(streamTokenizer);
        }
        this.m_sval = null;
        this.m_ival = 0;
        this.m_dval = 0.0;
        if (this.m_code >= 0 && this.m_code <= 9) {
            this.m_sval = this.parseString(streamTokenizer);
        } else if (10 <= this.m_code && this.m_code <= 59) {
            this.m_dval = this.parseDouble(streamTokenizer);
        } else if (60 <= this.m_code && this.m_code <= 79) {
            this.m_ival = this.parseInt(streamTokenizer);
        } else if (140 <= this.m_code && this.m_code <= 147) {
            this.m_dval = this.parseDouble(streamTokenizer);
        } else if (170 <= this.m_code && this.m_code <= 175) {
            this.m_ival = this.parseInt(streamTokenizer);
        } else if (210 <= this.m_code && this.m_code <= 239) {
            this.m_dval = this.parseDouble(streamTokenizer);
        } else if (999 == this.m_code) {
            this.m_sval = this.parseString(streamTokenizer);
        } else if (1010 <= this.m_code && this.m_code <= 1059) {
            this.m_dval = this.parseDouble(streamTokenizer);
        } else if (1060 <= this.m_code && this.m_code <= 1079) {
            this.m_ival = this.parseInt(streamTokenizer);
        } else if (1000 <= this.m_code && this.m_code <= 1009) {
            this.m_sval = this.parseString(streamTokenizer);
        } else {
            throw new IOException("group code out of range");
        }
        return this.m_code;
    }

    private double[] parseCoords(StreamTokenizer streamTokenizer) throws IOException, NumberFormatException {
        double[] dArray = new double[3];
        int n = 0;
        do {
            int n2;
            if ((n2 = this.parseGroup(streamTokenizer)) != (n + 1) * 10) {
                throw new IOException("missing coordinate component");
            }
            dArray[n] = this.m_dval;
        } while (++n < 3);
        return dArray;
    }

    protected static String writeElements(int n, PiVector[] piVectorArray) {
        if (n <= 0 && piVectorArray == null && n > piVectorArray.length) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("# Face List\n");
        stringBuffer.append("# Number of Faces = " + n + StrNL);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("f ");
            if (piVectorArray[n2] == null) {
                return null;
            }
            int n3 = 0;
            while (n3 < piVectorArray[n2].m_data.length) {
                int n4 = piVectorArray[n2].m_data[n3] + 1;
                stringBuffer.append(n4);
                if (m_bVertexNormals) {
                    stringBuffer.append("/" + n4);
                    if (m_bVertexTextures) {
                        stringBuffer.append("/" + n4);
                    }
                } else if (!m_bVertexNormals && m_bVertexTextures) {
                    stringBuffer.append("//" + n4);
                }
                if (n3 < piVectorArray[n2].m_data.length - 1) {
                    stringBuffer.append(" ");
                }
                ++n3;
            }
            stringBuffer.append(StrNL);
            ++n2;
        }
        return stringBuffer.toString();
    }
}

