/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jvx.numeric.PnEnergy;
import jvx.numeric.PnStiffDiriConforming;
import jvx.numeric.PnStiffDiriNonConforming;

public class PnDiriEnergy
extends PnEnergy {
    private static /* synthetic */ Class class$jvx$numeric$PnDiriEnergy;

    public boolean setSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"missing domain geometry.");
            return false;
        }
        if (pgElementSet2 == null) {
            PsDebug.warning((String)"missing surface geometry.");
            return false;
        }
        if (!super.setSurface(pgElementSet, pgElementSet2)) {
            return false;
        }
        if (pgElementSet.isConforming() != pgElementSet2.isConforming()) {
            PsDebug.error((String)"domain and surface have different conformality", (Object)((Object)this));
            return false;
        }
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)("domain=" + pgElementSet.getName() + " not triangulated"));
            PgElementSet.triangulate((PgElementSet)pgElementSet);
        }
        if (pgElementSet2.getDimOfElements() != 3) {
            PsDebug.warning((String)("surface=" + pgElementSet2.getName() + " not triangulated"));
            PgElementSet.triangulate((PgElementSet)pgElementSet2);
        }
        this.m_stiffMatrix = this.m_domain.isConforming() ? new PnStiffDiriConforming(pgElementSet) : new PnStiffDiriNonConforming(pgElementSet);
        return true;
    }

    public PnDiriEnergy() {
        if (((Object)((Object)this)).getClass() == (class$jvx$numeric$PnDiriEnergy != null ? class$jvx$numeric$PnDiriEnergy : (class$jvx$numeric$PnDiriEnergy = PnDiriEnergy.class$("jvx.numeric.PnDiriEnergy")))) {
            this.init();
        }
    }

    public PdMatrix evalHessian(PdMatrix pdMatrix) {
        if (pdMatrix == null) {
            pdMatrix = new PdMatrix();
        }
        int n = this.m_index.length;
        pdMatrix.setSize(this.m_dim * n);
        pdMatrix.setConstant(0.0);
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < this.m_stiffMatrix.m_snoe.m_data[this.m_index[n2]]) {
                int n4 = this.m_invIndex[this.m_stiffMatrix.m_sindx[this.m_index[n2]].m_data[n3]];
                if (n4 != -1) {
                    if (n2 != 0 || n4 == 0) {
                        // empty if block
                    }
                    int n5 = 0;
                    while (n5 < this.m_dim) {
                        pdMatrix.m_data[n2 * this.m_dim + n5][n4 * this.m_dim + n5] = this.m_stiffMatrix.m_stiff[this.m_index[n2]].m_data[n3];
                        ++n5;
                    }
                }
                ++n3;
            }
            ++n2;
        }
        return pdMatrix;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
    }

    public void initSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        if (pgElementSet == null) {
            PsDebug.warning((String)"missing domain geometry.");
            return;
        }
        if (pgElementSet2 == null) {
            PsDebug.warning((String)"missing surface geometry.");
            return;
        }
        if (this.m_stiffMatrix == null) {
            PsDebug.warning((String)"missing m_stiffMatrix, call setSurface before.");
            return;
        }
        super.initSurface(pgElementSet, pgElementSet2);
        this.m_stiffMatrix.init(pgElementSet);
    }
}

