/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import jvx.numeric.PnAreaEnergy;
import jvx.numeric.PnConfEnergy;
import jvx.numeric.PnDiriEnergy;
import jvx.numeric.PnEnergyMinimizer;
import jvx.numeric.PnSpringEnergy;
import jvx.thirdParty.acmeGui.BusyBox;

public class PnEnergyMinimizer_IP
extends PsPanel
implements Runnable,
ActionListener,
ItemListener,
TextListener {
    protected PnEnergyMinimizer m_energyMinimizer;
    protected Choice m_cEnergy;
    protected Panel m_pDiri;
    protected TextField m_tNumLoops;
    protected TextField m_tCurrLoop;
    protected TextField m_tCGEps;
    protected TextField m_tInitialEnergy;
    protected TextField m_tFinalEnergy;
    protected TextField m_tGradientLength;
    protected TextField m_tNumIterations;
    protected Checkbox m_cTangential;
    protected Checkbox m_cNormal;
    protected Checkbox m_cUpdateNormals;
    protected Checkbox m_cUpdateDomain;
    protected CheckboxGroup m_gHessian;
    protected Checkbox m_cHessian;
    protected Checkbox m_cIndex;
    protected Choice m_cShowEV;
    protected Choice m_cPrint;
    protected String[] m_printChoice = new String[]{"NONE", "Eigenvector", "Eigenvalue", "Gradient", "Hessian", "Test Matrices"};
    protected Button m_bStep;
    protected Button m_bMinimize;
    private Color m_minimizeColor;
    protected Button m_bSuspend;
    private boolean m_bInteractive = true;
    int m_numInst = 0;
    BusyBox b = null;
    int m_printType;
    int m_showType;
    private static /* synthetic */ Class class$jvx$numeric$PnEnergyMinimizer_IP;

    public PnEnergyMinimizer_IP() {
        if (this.getClass() == (class$jvx$numeric$PnEnergyMinimizer_IP != null ? class$jvx$numeric$PnEnergyMinimizer_IP : (class$jvx$numeric$PnEnergyMinimizer_IP = PnEnergyMinimizer_IP.class$("jvx.numeric.PnEnergyMinimizer_IP")))) {
            this.init();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.m_energyMinimizer == null) {
            return;
        }
        Object object = itemEvent.getSource();
        if (object == this.m_cEnergy) {
            int n = this.m_cEnergy.getSelectedIndex();
            if (n == 0) {
                this.m_energyMinimizer.setEnergy(new PnDiriEnergy());
            } else if (n == 1) {
                this.m_energyMinimizer.setEnergy(new PnAreaEnergy());
            } else if (n == 2) {
                this.m_energyMinimizer.setEnergy(new PnConfEnergy());
            } else if (n == 3) {
                this.m_energyMinimizer.setEnergy(new PnSpringEnergy());
            } else {
                return;
            }
            this.m_energyMinimizer.update(this.m_energyMinimizer);
            return;
        }
        if (object == this.m_cUpdateNormals) {
            this.m_energyMinimizer.m_bUpdateNormals = this.m_cUpdateNormals.getState();
            if (this.m_energyMinimizer.m_bUpdateNormals) {
                this.m_energyMinimizer.m_surface.makeVertexNormals();
                this.m_energyMinimizer.m_surface.update(null);
                return;
            }
        } else {
            if (object == this.m_cUpdateDomain) {
                this.m_energyMinimizer.setUpdateDomain(this.m_cUpdateDomain.getState());
                this.m_energyMinimizer.m_domain.update(null);
                return;
            }
            if (object == this.m_cTangential) {
                if (this.m_energyMinimizer.m_energy != null) {
                    this.m_energyMinimizer.m_energy.m_bTangential = this.m_cTangential.getState();
                    this.m_energyMinimizer.m_surface.update(null);
                    return;
                }
            } else if (object == this.m_cNormal) {
                if (this.m_energyMinimizer.m_energy != null) {
                    this.m_energyMinimizer.m_energy.m_bNormal = this.m_cNormal.getState();
                    this.m_energyMinimizer.m_surface.update(null);
                    return;
                }
            } else {
                if (object == this.m_cShowEV) {
                    int n = this.m_cShowEV.getSelectedIndex();
                    if (n > 1) {
                        if (this.m_energyMinimizer.m_eVector == null) {
                            this.m_showType = n;
                            this.m_printType = -1;
                            new Thread((Runnable)this, "Show_" + n + "_" + this.m_numInst++).start();
                            return;
                        }
                        this.m_energyMinimizer.showEigenvector(n - 2);
                        this.m_energyMinimizer.m_surface.update(null);
                        return;
                    }
                    if (n == 1) {
                        this.m_energyMinimizer.showGradient();
                        this.m_energyMinimizer.m_surface.update((Object)this.m_energyMinimizer.m_surface);
                        return;
                    }
                    this.m_energyMinimizer.showNone();
                    this.m_energyMinimizer.m_surface.update((Object)this.m_energyMinimizer.m_surface);
                    return;
                }
                if (object == this.m_cPrint) {
                    int n;
                    this.m_printType = n = this.m_cPrint.getSelectedIndex();
                    switch (n) {
                        case 1: {
                            new Thread((Runnable)this, "Print_" + n + "_" + this.m_numInst++).start();
                            return;
                        }
                        case 2: {
                            new Thread((Runnable)this, "Print_" + n + "_" + this.m_numInst++).start();
                            return;
                        }
                        case 3: {
                            this.m_energyMinimizer.printGradient();
                            return;
                        }
                        case 4: {
                            this.m_energyMinimizer.printHessian();
                            return;
                        }
                        case 5: {
                            this.m_energyMinimizer.getEnergy().testEigenvalues();
                            return;
                        }
                        default: {
                            return;
                        }
                    }
                }
                if (object == this.m_cHessian) {
                    this.m_energyMinimizer.m_bHessianIsL2Normalized = false;
                    this.m_energyMinimizer.showNone();
                    this.m_energyMinimizer.m_surface.update((Object)this.m_energyMinimizer.m_surface);
                    return;
                }
                if (object == this.m_cIndex) {
                    this.m_energyMinimizer.m_bHessianIsL2Normalized = true;
                    this.m_energyMinimizer.showNone();
                    this.m_energyMinimizer.m_surface.update((Object)this.m_energyMinimizer.m_surface);
                }
            }
        }
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.m_energyMinimizer = (PnEnergyMinimizer)psUpdateIf;
    }

    public boolean update(Object object) {
        if (this.m_energyMinimizer == null) {
            return true;
        }
        if (this.m_energyMinimizer == object) {
            if (this.m_cUpdateNormals.getState() != this.m_energyMinimizer.m_bUpdateNormals) {
                this.m_cUpdateNormals.setState(this.m_energyMinimizer.m_bUpdateNormals);
            }
            if (this.m_cUpdateDomain.getState() != this.m_energyMinimizer.m_bUpdateDomain) {
                this.m_cUpdateDomain.setState(this.m_energyMinimizer.m_bUpdateDomain);
            }
            ((TextComponent)this.m_tCurrLoop).setText(String.valueOf(this.m_energyMinimizer.m_currLoop));
            ((TextComponent)this.m_tNumLoops).setText(String.valueOf(this.m_energyMinimizer.m_numLoops));
            if (this.m_tCGEps != null) {
                ((TextComponent)this.m_tCGEps).setText(String.valueOf(this.m_energyMinimizer.m_cgEps));
            }
            if (!this.m_energyMinimizer.m_bRunning) {
                if (new Double(this.m_energyMinimizer.m_initialEnergy).isNaN()) {
                    ((TextComponent)this.m_tInitialEnergy).setText("Unknown");
                } else {
                    ((TextComponent)this.m_tInitialEnergy).setText(String.valueOf(this.m_energyMinimizer.m_initialEnergy));
                }
            }
            if (new Double(this.m_energyMinimizer.m_finalEnergy).isNaN()) {
                ((TextComponent)this.m_tFinalEnergy).setText("Unknown");
            } else {
                ((TextComponent)this.m_tFinalEnergy).setText(String.valueOf(this.m_energyMinimizer.m_finalEnergy));
            }
            ((TextComponent)this.m_tNumIterations).setText(String.valueOf(this.m_energyMinimizer.m_numIterations));
            if (this.m_energyMinimizer.m_energy != null) {
                if (this.m_cTangential.getState() != this.m_energyMinimizer.m_energy.m_bTangential) {
                    this.m_cTangential.setState(this.m_energyMinimizer.m_energy.m_bTangential);
                }
                if (this.m_cNormal.getState() != this.m_energyMinimizer.m_energy.m_bNormal) {
                    this.m_cNormal.setState(this.m_energyMinimizer.m_energy.m_bNormal);
                }
                if (this.m_energyMinimizer.m_energy instanceof PnDiriEnergy) {
                    this.m_cEnergy.select("Dirichlet");
                } else if (this.m_energyMinimizer.m_energy instanceof PnAreaEnergy) {
                    this.m_cEnergy.select("Area");
                } else if (this.m_energyMinimizer.m_energy instanceof PnConfEnergy) {
                    this.m_cEnergy.select("Conformal");
                } else if (this.m_energyMinimizer.m_energy instanceof PnSpringEnergy) {
                    this.m_cEnergy.select("Spring");
                }
                int n = this.m_energyMinimizer.m_energy.getNumOfVariables();
                if (n != this.m_cShowEV.getItemCount() - 2) {
                    if (this.m_cShowEV.getItemCount() > 0) {
                        this.m_cShowEV.removeAll();
                    }
                    this.m_cShowEV.add("NONE");
                    this.m_cShowEV.add("Gradient");
                    int n2 = 0;
                    while (n2 < n) {
                        this.m_cShowEV.add("E-Vector " + n2);
                        ++n2;
                    }
                }
                if (this.m_energyMinimizer.m_vf == null) {
                    this.m_cShowEV.select(0);
                }
            }
            if (this.m_energyMinimizer.m_energy != null) {
                PdVector pdVector = this.m_energyMinimizer.m_energy.evalGradient(this.m_energyMinimizer.m_coord, null);
                if (pdVector != null) {
                    ((TextComponent)this.m_tGradientLength).setText(String.valueOf((float)pdVector.length()));
                    if ("Gradient".equals(this.m_cShowEV.getSelectedItem())) {
                        this.m_energyMinimizer.showGradient();
                    }
                } else {
                    ((TextComponent)this.m_tGradientLength).setText("missing gradient");
                }
            }
            if (this.m_gHessian.getSelectedCheckbox() == this.m_cHessian && this.m_energyMinimizer.m_bHessianIsL2Normalized) {
                this.m_gHessian.setSelectedCheckbox(this.m_cIndex);
            }
            if (!this.m_energyMinimizer.m_bRunning && !this.m_bSuspend.getLabel().equals("Resume")) {
                if (this.m_minimizeColor != null) {
                    this.m_bStep.setBackground(this.m_minimizeColor);
                    this.m_bMinimize.setBackground(this.m_minimizeColor);
                }
                this.m_bStep.setLabel("Step");
                this.m_bMinimize.setLabel("Minimize");
                this.m_bSuspend.setLabel("Suspend");
                this.m_bSuspend.setEnabled(false);
            }
            return true;
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_energyMinimizer == null) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.m_bStep) {
            if (this.m_bStep.getLabel().equals("Step")) {
                this.m_minimizeColor = this.m_bStep.getBackground();
                this.m_bStep.setBackground(Color.red);
                this.m_bStep.setLabel("Stop");
                this.m_energyMinimizer.step(this.m_energyMinimizer.m_numLoops);
                return;
            }
            if (this.m_minimizeColor != null) {
                this.m_bStep.setBackground(this.m_minimizeColor);
            }
            this.m_bStep.setLabel("Step");
            this.m_energyMinimizer.stop();
            return;
        }
        if (object == this.m_bMinimize) {
            if (this.m_bMinimize.getLabel().equals("Minimize")) {
                this.m_minimizeColor = this.m_bMinimize.getBackground();
                this.m_bMinimize.setBackground(Color.red);
                this.m_bMinimize.setLabel("Stop");
                this.m_bSuspend.setEnabled(true);
                this.m_energyMinimizer.minimize();
                return;
            }
            if (this.m_minimizeColor != null) {
                this.m_bMinimize.setBackground(this.m_minimizeColor);
            }
            this.m_bMinimize.setLabel("Minimize");
            this.m_bSuspend.setEnabled(false);
            this.m_bSuspend.setLabel("Suspend");
            this.m_energyMinimizer.stop();
            return;
        }
        if (object == this.m_bSuspend) {
            if (this.m_bSuspend.getLabel().equals("Suspend")) {
                this.m_bSuspend.setLabel("Resume");
                this.m_energyMinimizer.stop();
                return;
            }
            this.m_bSuspend.setLabel("Suspend");
            this.m_energyMinimizer.start();
        }
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void run() {
        if (this.b != null) {
            return;
        }
        this.b = new BusyBox(PsConfig.getFrame(), "Computing Eigenvectors");
        ((Component)this.b).setLocation(150, 500);
        ((Component)this.b).setSize(250, 150);
        this.b.show();
        if (this.m_printType > 0) {
            switch (this.m_printType) {
                case 1: {
                    this.m_energyMinimizer.printEigenvectors();
                    break;
                }
                case 2: {
                    this.m_energyMinimizer.printEigenvalues();
                }
            }
            this.b.done();
        } else {
            int n = this.m_showType;
            if (n > 1) {
                this.m_energyMinimizer.showEigenvector(n - 2);
            }
            this.b.done();
            this.m_energyMinimizer.m_surface.update((Object)this.m_energyMinimizer.m_surface);
        }
        this.b = null;
    }

    public void textValueChanged(TextEvent textEvent) {
        if (!this.m_bInteractive) {
            return;
        }
        Object object = textEvent.getSource();
        if (object == this.m_tNumLoops) {
            try {
                this.m_energyMinimizer.m_numLoops = Integer.parseInt(this.m_tNumLoops.getText());
                return;
            }
            catch (NumberFormatException numberFormatException) {
                PsDebug.warning((String)("wrong format = " + this.m_tNumLoops.getText()), (Object)this);
                return;
            }
        }
        if (this.m_tCGEps != null && object == this.m_tCGEps) {
            try {
                this.m_energyMinimizer.m_cgEps = new Double(this.m_tCGEps.getText());
                return;
            }
            catch (NumberFormatException numberFormatException) {
                PsDebug.warning((String)("wrong format = " + this.m_tCGEps.getText()), (Object)this);
            }
        }
    }

    public void init() {
        super.init();
        this.addTitle("Minimization");
        this.m_cEnergy = new Choice();
        this.m_cEnergy.addItemListener(this);
        this.m_cEnergy.add("Dirichlet");
        this.m_cEnergy.add("Area");
        this.m_cEnergy.add("Conformal");
        this.m_cEnergy.add("Spring");
        this.m_cEnergy.select(1);
        this.addLabelComponent("Select Energy", this.m_cEnergy);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 2));
        this.m_tInitialEnergy = new TextField(8);
        this.m_tInitialEnergy.setEditable(false);
        panel.add(this.m_tInitialEnergy);
        this.m_tFinalEnergy = new TextField(8);
        this.m_tFinalEnergy.setEditable(false);
        panel.add(this.m_tFinalEnergy);
        this.addLabelComponent("Initial/Final Energy", panel);
        this.m_tGradientLength = this.addTextField("Gradient Length", 8);
        this.m_tGradientLength.setEditable(false);
        panel = new Panel();
        panel.setLayout(new GridLayout(1, 2));
        this.m_tCurrLoop = new TextField(8);
        this.m_tCurrLoop.setEditable(false);
        this.m_tNumLoops = new TextField(8);
        this.m_tNumLoops.addTextListener(this);
        panel.add(this.m_tCurrLoop);
        panel.add(this.m_tNumLoops);
        this.addLabelComponent("Current/Num Loops", panel);
        this.m_tNumIterations = this.addTextField("Used Iterations", 8);
        this.m_tNumIterations.setEditable(false);
        this.addSubTitle("Variation Directions");
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(2, 2));
        this.m_cTangential = new Checkbox("Tangential");
        this.m_cTangential.addItemListener(this);
        panel2.add(this.m_cTangential);
        this.m_cNormal = new Checkbox("Normal");
        this.m_cNormal.addItemListener(this);
        panel2.add(this.m_cNormal);
        this.m_cUpdateNormals = new Checkbox("Update Normals");
        this.m_cUpdateNormals.addItemListener(this);
        panel2.add(this.m_cUpdateNormals);
        this.m_cUpdateDomain = new Checkbox("Update Domain");
        this.m_cUpdateDomain.addItemListener(this);
        panel2.add(this.m_cUpdateDomain);
        ((Container)((Object)this)).add(panel2);
        PsPanel psPanel = new PsPanel();
        psPanel.addTitle("Eigenvalues and -vectors");
        Panel panel3 = new Panel();
        panel3.setLayout(new GridLayout(1, 2));
        this.m_gHessian = new CheckboxGroup();
        this.m_cHessian = new Checkbox("Hessian", this.m_gHessian, true);
        this.m_cHessian.addItemListener(this);
        panel3.add(this.m_cHessian);
        this.m_cIndex = new Checkbox("Index Hessian", this.m_gHessian, false);
        this.m_cIndex.addItemListener(this);
        panel3.add(this.m_cIndex);
        psPanel.add(panel3);
        this.m_cShowEV = new Choice();
        this.m_cShowEV.addItemListener(this);
        psPanel.addLabelComponent("Show Vector", (Component)this.m_cShowEV);
        this.m_cPrint = new Choice();
        this.m_cPrint.addItemListener(this);
        int n = 0;
        while (n < this.m_printChoice.length) {
            this.m_cPrint.add(this.m_printChoice[n]);
            ++n;
        }
        this.m_cPrint.select(0);
        psPanel.addLabelComponent("Print Vector", (Component)this.m_cPrint);
        ((Container)((Object)this)).add((Component)psPanel);
        panel3 = new Panel();
        panel3.setLayout(new FlowLayout(1));
        this.m_bStep = new Button("Step");
        this.m_bStep.addActionListener(this);
        panel3.add(this.m_bStep);
        this.m_bMinimize = new Button("Minimize");
        this.m_bMinimize.addActionListener(this);
        panel3.add(this.m_bMinimize);
        this.m_bSuspend = new Button("Suspend");
        this.m_bSuspend.addActionListener(this);
        this.m_bSuspend.setEnabled(false);
        panel3.add(this.m_bSuspend);
        ((Container)((Object)this)).add(panel3);
    }
}

