/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.geom.PgPolygon;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgPolygonOnElementSet;
import jvx.geom.PwBary;
import jvx.numeric.PnGeodesicRK;
import jvx.numeric.PnNoise;

public class PnLIC {
    protected PgElementSet m_geom;
    protected int m_maxhits = 3;
    protected PnGeodesicRK m_rk;
    protected double m_integralh = 1.0;
    protected int m_width;
    protected int m_height;
    protected int[] m_pix;
    protected PdVector[][] m_texCoords;
    protected double m_steplen;
    protected int m_kernelwidth = 15;
    protected int m_minKernel = 1;
    protected float m_coarseness = 1.0f;
    protected PnNoise m_noise;
    private PgPolygonOnElementSet m_poly;
    private PgPolygonOnElementSet m_lastpoly;
    private PiVector m_evalelem;
    private PdVector[] m_evalbary;
    private int m_evalsize;
    private PiVector m_evalx;
    private PiVector m_evaly;
    private PdVector m_noisecol;
    private PiVector m_kernelW;
    private int m_nextkernelw;
    private int m_nextpolysize;
    private boolean m_nextedgereached;
    private PgPolygon m_lenBuf;
    private double m_kernelFac;
    private static final int m_maxIter = 30;

    public int getTextureHeight() {
        return this.m_height;
    }

    private void makeEvalXY(int n, int n2, PdBary pdBary, PdVector[] pdVectorArray, PdVector pdVector) {
        pdVectorArray = this.m_texCoords[this.m_evalelem.m_data[n]];
        int n3 = 0;
        do {
            pdBary.m_data[n3] = this.m_evalbary[n3].m_data[n];
        } while (++n3 < 3);
        PdBary.getVertex((PdVector)pdVector, (PdBary)pdBary, (PdVector)pdVectorArray[0], (PdVector)pdVectorArray[1], (PdVector)pdVectorArray[2]);
        this.m_evalx.m_data[n2] = (int)(pdVector.m_data[0] * (double)(this.m_width - 1));
        this.m_evaly.m_data[n2] = (int)((1.0 - pdVector.m_data[1]) * (double)(this.m_height - 1));
    }

    public int[] getPixArray(int[] nArray) {
        int n;
        if (nArray == null) {
            nArray = new int[this.m_pix.length];
        }
        if ((n = this.m_pix.length) > nArray.length) {
            n = nArray.length;
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.m_pix[n2] >> 24 & 0xFF;
            int n4 = this.m_pix[n2] & 0xFFFFFF;
            if (n3 != 0) {
                n4 /= n3;
            }
            if (n4 > 255) {
                nArray[n2] = -1;
            } else if (n4 == 0) {
                nArray[n2] = -16777216;
            } else {
                n4 = n4 * n4 * (768 - (n4 << 1)) / 65536;
                nArray[n2] = -16777216 + (n4 << 16) + (n4 << 8) + n4;
            }
            ++n2;
        }
        return nArray;
    }

    protected int getOutline(PdVector[] pdVectorArray, int n, int n2, PiVector piVector, PiVector piVector2) {
        PiVector[] piVectorArray = new PiVector[3];
        int n3 = 0;
        do {
            piVectorArray[n3] = new PiVector(2);
            piVectorArray[n3].m_data[0] = (int)(pdVectorArray[n3].m_data[0] * (double)(n - 1));
            piVectorArray[n3].m_data[1] = (int)((1.0 - pdVectorArray[n3].m_data[1]) * (double)(n2 - 1));
        } while (++n3 < 3);
        float f = piVectorArray[0].m_data[1];
        int n4 = 0;
        int n5 = 1;
        while (n5 < piVectorArray.length) {
            if (f > (float)piVectorArray[n5].m_data[1] || f >= (float)piVectorArray[n5].m_data[1] && n5 == n4 + 1) {
                f = piVectorArray[n5].m_data[1];
                n4 = n5;
            }
            ++n5;
        }
        int n6 = 0;
        n3 = n4;
        while (n3 < n4 + 3) {
            int n7 = piVectorArray[n3 % 3].m_data[0];
            int n8 = piVectorArray[n3 % 3].m_data[1];
            int n9 = piVectorArray[(n3 + 1) % 3].m_data[1] - n8;
            int n10 = Math.abs(n9);
            int n11 = piVectorArray[(n3 + 1) % 3].m_data[0] - n7;
            if (n10 != 0 || n11 != 0) {
                int n12 = 0;
                int n13 = 1;
                if (n9 < 0) {
                    n13 = -1;
                }
                n9 = Math.abs(n9);
                int n14 = 1;
                if (n11 < 0) {
                    n14 = -1;
                }
                n11 = Math.abs(n11);
                do {
                    piVector.setEntry(n6, n7);
                    piVector2.setEntry(n6, n8);
                    n8 += n13;
                    n12 += n11;
                    while (n12 >= n9 && n9 != 0) {
                        n7 += n14;
                        n12 -= n9;
                    }
                    ++n6;
                } while (--n10 > 0);
            }
            ++n3;
        }
        piVector.setEntry(n6, piVectorArray[(n4 + 3) % 3].m_data[0]);
        piVector2.setEntry(n6, piVectorArray[(n4 + 3) % 3].m_data[1]);
        return ++n6;
    }

    public int getTextureWidth() {
        return this.m_width;
    }

    public PnLIC(PgElementSet pgElementSet, int n, double d, PnGeodesicRK pnGeodesicRK) {
        this.m_geom = pgElementSet;
        this.m_rk = pnGeodesicRK;
        double[] dArray = PnLIC.triangleElemTexCoords(this.m_geom, n);
        this.m_steplen = 1.0 / dArray[0];
        this.m_width = (int)dArray[1];
        this.m_height = (int)dArray[2];
        this.m_pix = new int[this.m_width * this.m_height];
        this.m_noise = new PnNoise();
        this.m_texCoords = this.m_geom.getElementTextures();
        this.m_poly = new PgPolygonOnElementSet(this.m_geom);
        this.m_lastpoly = new PgPolygonOnElementSet(this.m_geom);
        this.m_lenBuf = new PgPolygon(this.m_geom.getDimOfVertices());
        this.m_evalsize = (this.m_width + this.m_height) / 2;
        this.m_evalbary = new PdVector[3];
        int n2 = 0;
        do {
            this.m_evalbary[n2] = new PdVector(this.m_evalsize);
        } while (++n2 < 3);
        this.m_evalelem = new PiVector(this.m_evalsize);
        this.m_evalx = new PiVector(this.m_evalsize);
        this.m_evaly = new PiVector(this.m_evalsize);
        this.m_kernelW = new PiVector(this.m_evalsize);
        this.m_noisecol = new PdVector(this.m_evalsize);
    }

    public void makeElement(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = n;
        PdBary pdBary = new PdBary(3);
        PdVector pdVector = new PdVector(2);
        PdBary pdBary2 = new PdBary(3);
        PdVector[] pdVectorArray = null;
        PiVector piVector = new PiVector(1);
        PiVector piVector2 = new PiVector(1);
        this.m_kernelFac = this.m_steplen / this.m_integralh * (double)(this.m_kernelwidth - this.m_minKernel);
        int n7 = this.m_evalx.getSize();
        PdVector[] pdVectorArray2 = this.m_texCoords[n6];
        int n8 = this.getOutline(pdVectorArray2, this.m_width, this.m_height, piVector, piVector2);
        int n9 = n8 / 2;
        int n10 = 0;
        while (n10 < n9) {
            int n11;
            int n12;
            if (piVector.m_data[n10] <= piVector.m_data[n8 - n10 - 1]) {
                n5 = piVector.m_data[n10];
                n4 = piVector.m_data[n8 - n10 - 1];
            } else {
                n5 = piVector.m_data[n8 - n10 - 1];
                n4 = piVector.m_data[n10];
            }
            n3 = piVector2.m_data[n10];
            n2 = n5;
            while (n2 <= n4) {
                if ((this.m_pix[n2 + n3 * this.m_width] & 0xFF000000) >> 24 <= this.m_maxhits) {
                    int n13;
                    int n14;
                    int n15;
                    int n16;
                    pdVector.m_data[0] = (float)n2 / (float)(this.m_width - 1);
                    pdVector.m_data[1] = (float)(this.m_height - n3 - 1) / (float)(this.m_height - 1);
                    PdBary.getBary((PdBary)pdBary, (PdVector)pdVector, (PdVector)pdVectorArray2[0], (PdVector)pdVectorArray2[1], (PdVector)pdVectorArray2[2]);
                    n12 = 0;
                    do {
                        if (!(pdBary.m_data[n12] < 0.0)) continue;
                        pdBary.m_data[n12] = 0.0;
                        pdBary.validate();
                    } while (++n12 < 3);
                    this.m_rk.prepareSolve(this.m_poly, n6, pdBary, this.m_integralh);
                    boolean bl = false;
                    boolean bl2 = false;
                    int n17 = 0;
                    int n18 = 0;
                    int n19 = 0;
                    float f = 0.0f;
                    this.makeNextStep();
                    block3: do {
                        int n20 = this.m_nextpolysize;
                        n16 = this.m_nextkernelw;
                        bl = this.m_nextedgereached;
                        if (n7 < n19 + n20) {
                            this.m_evalx.setSize(n7 += Math.max(this.m_evalsize, n20));
                            this.m_evaly.setSize(n7);
                            this.m_kernelW.setSize(n7);
                            this.m_noisecol.setSize(n7);
                        }
                        n15 = n19 + n20;
                        n12 = n19;
                        while (n12 < n15) {
                            this.makeEvalXY(n12 - n19, n12, pdBary2, pdVectorArray, pdVector);
                            float f2 = (this.m_noise.noise(this.m_coarseness * (float)this.m_evalx.m_data[n12], this.m_coarseness * (float)this.m_evaly.m_data[n12]) / 2.0f + 0.5f) * 255.0f;
                            this.m_noisecol.m_data[n12] = f2;
                            ++n12;
                        }
                        this.makeNextStep();
                        float f3 = (float)(this.m_nextkernelw - n16) / (float)n20;
                        float f4 = n16;
                        n12 = 0;
                        while (n12 < n20) {
                            this.m_kernelW.m_data[n19] = (int)f4;
                            f4 += f3;
                            ++n19;
                            ++n12;
                        }
                        n16 = this.m_kernelW.m_data[n18];
                        while (n18 < n19 && n19 - n18 >= n16) {
                            n11 = this.m_evalx.m_data[n18] + this.m_evaly.m_data[n18] * this.m_width;
                            if ((this.m_pix[n11] & 0xFF000000) >> 24 > this.m_maxhits) {
                                if (n17 > this.m_maxhits) {
                                    bl2 = true;
                                    continue block3;
                                }
                                ++n17;
                            }
                            f = 0.0f;
                            n15 = n18 + n16;
                            n12 = n18;
                            while (n12 < n15) {
                                f = (float)((double)f + this.m_noisecol.m_data[n12]);
                                ++n12;
                            }
                            n14 = 0x1000000 + (int)(f /= (float)n16);
                            int n21 = n11;
                            this.m_pix[n21] = this.m_pix[n21] + n14;
                            if (n18 == 0 && (this.m_evalx.m_data[0] != n2 || this.m_evaly.m_data[0] != n3)) {
                                int n22 = n13 = n3 * this.m_width + n2;
                                this.m_pix[n22] = this.m_pix[n22] + n14;
                            }
                            n16 = this.m_kernelW.m_data[++n18];
                        }
                    } while (!bl && !bl2);
                    if (bl) {
                        while (n18 < n19) {
                            n11 = this.m_evalx.m_data[n18] + this.m_evaly.m_data[n18] * this.m_width;
                            n16 = this.m_kernelW.m_data[n18];
                            float f5 = 0.0f;
                            n15 = n18 + n16;
                            n12 = n18;
                            while (n12 < n15) {
                                f5 = (float)((double)f5 + this.m_noisecol.m_data[n12 % n19]);
                                ++n12;
                            }
                            n14 = 0x1000000 + (int)(f5 /= (float)n16);
                            int n23 = n11;
                            this.m_pix[n23] = this.m_pix[n23] + n14;
                            if (n18 == 0 && (this.m_evalx.m_data[0] != n2 || this.m_evaly.m_data[0] != n3)) {
                                int n24 = n13 = n3 * this.m_width + n2;
                                this.m_pix[n24] = this.m_pix[n24] + n14;
                            }
                            ++n18;
                        }
                    }
                }
                ++n2;
            }
            n11 = n3 * this.m_width;
            n12 = 1;
            do {
                if (n5 - n12 >= 0) {
                    int n25 = n11 + n5 - n12;
                    this.m_pix[n25] = this.m_pix[n25] + this.m_pix[n11 + n5];
                }
                if (n4 + n12 >= this.m_width) continue;
                int n26 = n11 + n4 + n12;
                this.m_pix[n26] = this.m_pix[n26] + this.m_pix[n11 + n4];
            } while (++n12 <= 2);
            ++n10;
        }
        if (n9 >= 1 && (n3 = piVector2.m_data[n9 - 1] + 1) < this.m_height) {
            if (piVector.m_data[n9 - 1] <= piVector.m_data[n8 - n9]) {
                n5 = Math.max(piVector.m_data[n9 - 1] - 1, 0);
                n4 = Math.min(piVector.m_data[n8 - n9] + 1, this.m_width - 1);
            } else {
                n5 = Math.max(piVector.m_data[n8 - n9] - 1, 0);
                n4 = Math.min(piVector.m_data[n9 - 1] + 1, this.m_width - 1);
            }
            n2 = n5;
            while (n2 <= n4) {
                int n27 = n3 * this.m_width + n2;
                this.m_pix[n27] = this.m_pix[n27] + this.m_pix[(n3 - 1) * this.m_width + n2];
                ++n2;
            }
        }
    }

    private void makeNextStep() {
        int n = 0;
        this.m_poly.setNumVertices(1);
        this.m_lastpoly.setNumVertices(1);
        boolean bl = false;
        double d = 0.0;
        do {
            this.m_nextedgereached = !this.m_rk.nextStep();
            d += this.m_rk.getStepLength();
            this.m_lastpoly.setNumVertices(this.m_lastpoly.getNumVertices() - 1);
            this.m_lastpoly.addPolygon(this.m_rk.getStepPolygon());
            if (++n >= 30) {
                this.m_nextedgereached = true;
            }
            if (this.m_nextedgereached) {
                bl = true;
                continue;
            }
            if (!(d >= this.m_steplen)) continue;
            bl = true;
        } while (!bl);
        this.m_lastpoly.eval(this.m_evalbary[0], this.m_evalbary[1], this.m_evalbary[2], this.m_evalelem, this.m_steplen);
        this.m_nextpolysize = this.m_evalelem.getSize() - 1;
        this.m_nextkernelw = (int)(this.m_kernelFac * (double)this.m_nextpolysize / (double)n + (double)this.m_minKernel);
        if (this.m_nextpolysize <= 1) {
            this.m_nextkernelw = 1;
            if (this.m_nextpolysize < 1) {
                ++this.m_nextpolysize;
            }
        }
    }

    public boolean setConvolutionWidth(int n) {
        if (n < 1) {
            return false;
        }
        this.m_kernelwidth = n;
        return true;
    }

    public boolean setCoarseness(double d) {
        if (d < 0.0 || d > 1.0) {
            return false;
        }
        this.m_coarseness = (float)(1.0 - d);
        return true;
    }

    public double getCoarseness() {
        return this.m_coarseness;
    }

    public int getConvolutionWidth() {
        return this.m_kernelwidth;
    }

    public boolean setMinConvolutionWidth(int n) {
        if (n < 1 || n > this.m_kernelwidth) {
            return false;
        }
        this.m_minKernel = n;
        return true;
    }

    public int getMinConvolutionWidth() {
        return this.m_minKernel;
    }

    public void makeLIC() {
        int n = this.m_geom.getNumElements();
        int n2 = n - 1;
        while (n2 >= 0) {
            this.makeElement(n2);
            --n2;
        }
    }

    public void setStepSize(double d) {
        this.m_integralh = d;
    }

    public double getStepSize() {
        return this.m_integralh;
    }

    protected static double[] triangleElemTexCoords(PgElementSet pgElementSet, int n) {
        double d;
        pgElementSet.setDimOfTextures(2);
        pgElementSet.assureElementTextures();
        int n2 = pgElementSet.getNumElements();
        int n3 = 0;
        int n4 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        PiVector piVector = new PiVector(n2);
        PdVector pdVector = new PdVector(n2);
        PdVector pdVector2 = new PdVector(n2);
        PdVector pdVector3 = new PdVector(n2);
        PdVector pdVector4 = new PdVector(n2);
        PdVector pdVector5 = new PdVector(n2);
        PdBaryDir pdBaryDir = new PdBaryDir(3);
        PdBaryDir pdBaryDir2 = new PdBaryDir(3);
        int n5 = 0;
        while (n5 < n2) {
            double d4;
            piVector.m_data[n5] = 0;
            pdVector.m_data[n5] = 0.0;
            int n6 = 0;
            do {
                pdBaryDir.m_data[n6] = 0.0;
                pdBaryDir.m_data[(n6 + 1) % 3] = 1.0;
                pdBaryDir.m_data[(n6 + 2) % 3] = -1.0;
                d4 = PwBary.norm(pgElementSet, n5, pdBaryDir, n6 == 0);
                if (d4 > pdVector.m_data[n5]) {
                    piVector.m_data[n5] = n6;
                    pdVector.m_data[n5] = d4;
                }
                if (!(d4 > d2)) continue;
                d2 = d4;
                n4 = n6;
                n3 = n5;
            } while (++n6 < 3);
            n6 = piVector.m_data[n5];
            pdBaryDir.m_data[n6] = 0.0;
            pdBaryDir.m_data[(n6 + 1) % 3] = 1.0;
            pdBaryDir.m_data[(n6 + 2) % 3] = -1.0;
            pdBaryDir2.m_data[n6] = 1.0;
            pdBaryDir2.m_data[(n6 + 1) % 3] = 0.0;
            pdBaryDir2.m_data[(n6 + 2) % 3] = -1.0;
            pdVector2.m_data[n5] = PwBary.scalar(pgElementSet, n5, pdBaryDir, pdBaryDir2, false) / pdVector.m_data[n5];
            d4 = PwBary.norm(pgElementSet, n5, pdBaryDir2, false);
            d4 *= d4;
            if ((d4 -= pdVector2.m_data[n5] * pdVector2.m_data[n5]) < 0.0) {
                d4 = 0.0;
            }
            pdVector3.m_data[n5] = Math.sqrt(d4);
            if (pdVector3.m_data[n5] > d3) {
                d3 = pdVector3.m_data[n5];
            }
            if (pdVector2.m_data[n5] < 1.0E-10) {
                pdVector4.setEntry(n5, 1.5707963267948966);
            } else {
                pdVector4.setEntry(n5, Math.atan(pdVector3.m_data[n5] / pdVector2.m_data[n5]));
            }
            double d5 = pdVector.m_data[n5] - pdVector2.m_data[n5];
            if (d5 < 1.0E-10) {
                pdVector5.setEntry(n5, 1.5707963267948966);
            } else {
                pdVector5.setEntry(n5, Math.atan(pdVector3.m_data[n5] / d5));
            }
            ++n5;
        }
        double d6 = (double)n / d2;
        int n7 = (int)Math.ceil(d3 * d6 + 1.0);
        PiVector[][] piVectorArray = new PiVector[n2][3];
        int n8 = 8;
        int n9 = n8 / 2;
        int n10 = n8 / 2;
        boolean[] blArray = new boolean[n2];
        int n11 = 0;
        while (n11 < n2) {
            blArray[n11] = true;
            ++n11;
        }
        n11 = 0;
        while (n11 < n2) {
            int n12;
            int n13;
            int n14;
            double d7;
            int n15;
            double d8;
            int n16;
            double d9;
            double d10;
            int n17;
            double d11;
            double d12;
            if (n9 <= n10) {
                d = n9 == n10 ? 1.5707963267948966 : Math.atan((double)n7 / (double)(n10 - n9));
                d12 = 1000.0;
                d11 = 1000.0;
                n17 = -1;
                d10 = 1000.0;
                d9 = 1000.0;
                n16 = -1;
                int n18 = 0;
                while (n18 < n2) {
                    if (blArray[n18]) {
                        d8 = pdVector4.getEntry(n18);
                        double d13 = Math.abs(d8 - d);
                        if (d13 < d9 && d8 <= d) {
                            d9 = d13;
                            d10 = d8;
                            n16 = n18;
                        } else if (d13 < d11 && d8 > d) {
                            d11 = d13;
                            d12 = d8;
                            n17 = n18;
                        }
                    }
                    ++n18;
                }
                if (n16 == -1) {
                    n15 = n17;
                    d7 = d12;
                } else {
                    n15 = n16;
                    d7 = d10;
                }
                blArray[n15] = false;
                n14 = d7 <= d ? n9 : (int)Math.ceil((double)n10 - pdVector2.m_data[n15] * d6);
                n13 = (int)Math.ceil((double)n14 + pdVector2.m_data[n15] * d6);
                int n19 = (int)Math.floor(pdVector3.m_data[n15] * d6);
                int n20 = piVector.m_data[n15];
                piVectorArray[n15][(n20 + 2) % 3] = new PiVector(n14, 0);
                piVectorArray[n15][n20] = new PiVector(n13, n19);
                n14 = (int)Math.ceil((double)n14 + pdVector.m_data[n15] * d6);
                piVectorArray[n15][(n20 + 1) % 3] = new PiVector(n14, 0);
                n9 = n14 + n8;
                n12 = n13 + (int)Math.ceil((double)((n13 - n14) * (n7 - 1 - n19)) / (double)n19);
                if (n12 + n8 > n10) {
                    n10 = n12 + n8;
                }
            } else {
                d = Math.atan((double)n7 / (double)(n9 - n10));
                d12 = 1000.0;
                d11 = 1000.0;
                n17 = -1;
                d10 = 1000.0;
                d9 = 1000.0;
                n16 = -1;
                int n21 = 0;
                while (n21 < n2) {
                    if (blArray[n21]) {
                        d8 = pdVector5.getEntry(n21);
                        double d14 = Math.abs(d8 - d);
                        if (d14 < d9 && d8 <= d) {
                            d9 = d14;
                            d10 = d8;
                            n16 = n21;
                        } else if (d14 < d11 && d8 > d) {
                            d11 = d14;
                            d12 = d8;
                            n17 = n21;
                        }
                    }
                    ++n21;
                }
                if (n16 == -1) {
                    n15 = n17;
                    d7 = d12;
                } else {
                    n15 = n16;
                    d7 = d10;
                }
                blArray[n15] = false;
                double d15 = pdVector.m_data[n15] - pdVector2.m_data[n15];
                n13 = d7 <= d ? n10 : (int)Math.ceil((double)n9 - d15 * d6);
                n14 = (int)Math.ceil((double)n13 + d15 * d6);
                n12 = (int)Math.ceil((double)(n7 - 1) - pdVector3.m_data[n15] * d6);
                int n22 = piVector.m_data[n15];
                piVectorArray[n15][(n22 + 1) % 3] = new PiVector(n13, n7 - 1);
                piVectorArray[n15][n22] = new PiVector(n14, n12);
                n13 = (int)Math.ceil((double)n13 + pdVector.m_data[n15] * d6);
                piVectorArray[n15][(n22 + 2) % 3] = new PiVector(n13, n7 - 1);
                n10 = n13 + n8;
                int n23 = n14 + (int)Math.ceil((double)((n14 - n13) * n12) / (double)(n7 - 1 - n12));
                if (n23 + n8 > n9) {
                    n9 = n23 + n8;
                }
            }
            ++n11;
        }
        n11 = 0;
        n11 = n10 > n9 ? n10 + 1 : n9 + 1;
        double d16 = 1.0 / (double)(n7 - 1);
        d = 1.0 / (double)(n11 - 1);
        PdVector[][] pdVectorArray = new PdVector[n2][3];
        int n24 = 0;
        while (n24 < n2) {
            int n25 = 0;
            do {
                pdVectorArray[n24][n25] = new PdVector((double)piVectorArray[n24][n25].m_data[0] * d, 1.0 - (double)piVectorArray[n24][n25].m_data[1] * d16);
            } while (++n25 < 3);
            ++n24;
        }
        pgElementSet.setElementTextures(pdVectorArray);
        double[] dArray = new double[]{d6, n11, n7};
        return dArray;
    }
}

