/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PwBary;
import jvx.numeric.PnGeodesicRK;

public class PnTranslationRK
extends PnGeodesicRK {
    protected double[][][] m_ABT;
    protected PdBaryDir[][] m_base;

    public PnTranslationRK(PgElementSet pgElementSet) {
        super(pgElementSet);
        this.m_ABT = new double[pgElementSet.getNumElements()][3][3];
        this.m_base = new PdBaryDir[pgElementSet.getNumElements()][3];
    }

    public void setVectorField(int[] nArray, PdBaryDir[] pdBaryDirArray, int[] nArray2) {
        int n = this.m_geom.getNumVertices();
        int n2 = 0;
        while (n2 < n) {
            PiVector piVector = new PiVector();
            PiVector piVector2 = new PiVector();
            PdVector pdVector = new PdVector();
            double d = PwBary.getTransRepresentationValues(this.m_geom, nArray[n2], pdBaryDirArray[n2], nArray2[n2], piVector, piVector2, pdVector);
            double d2 = PwBary.norm(this.m_geom, nArray[n2], pdBaryDirArray[n2], false);
            int n3 = piVector.getSize();
            int n4 = 0;
            while (n4 < n3) {
                int n5 = piVector.getEntry(n4);
                int n6 = piVector2.getEntry(n4);
                this.m_ABT[n5][n6][0] = pdVector.getEntry(n4);
                this.m_ABT[n5][n6][1] = d;
                this.m_ABT[n5][n6][2] = d2;
                this.m_base[n5][n6] = new PdBaryDir(3);
                this.m_base[n5][n6].m_data[n6] = -1.0;
                this.m_base[n5][n6].m_data[(n6 + 1) % 3] = 1.0;
                this.m_base[n5][n6].m_data[(n6 + 2) % 3] = 0.0;
                double d3 = PwBary.norm(this.m_geom, n5, this.m_base[n5][n6], false);
                if (d3 < 1.0E-10) {
                    PsDebug.warning((String)"Edges degenerated");
                } else {
                    this.m_base[n5][n6].multScalar(1.0 / d3);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void eval(int n, PdBary pdBary, PdBaryDir pdBaryDir) {
        try {
            pdBaryDir.setSize(3);
            PdBaryDir[] pdBaryDirArray = new PdBaryDir[3];
            int n2 = 0;
            do {
                double d;
                pdBaryDir.m_data[n2] = 0.0;
                pdBaryDirArray[n2] = new PdBaryDir(3);
                pdBaryDirArray[n2].m_data[n2] = -1.0;
                pdBaryDirArray[n2].m_data[(n2 + 1) % 3] = 0.0;
                pdBaryDirArray[n2].m_data[(n2 + 1) % 3] = 0.0;
                int n3 = 0;
                do {
                    int n4 = n3;
                    pdBaryDirArray[n2].m_data[n4] = pdBaryDirArray[n2].m_data[n4] + pdBary.m_data[n3];
                } while (++n3 < 3);
                double d2 = PwBary.norm(this.m_geom, n, pdBaryDirArray[n2], false);
                if (d2 < 1.0E-10) {
                    pdBaryDirArray[n2].m_data[n2] = -1.0;
                    pdBaryDirArray[n2].m_data[(n2 + 1) % 3] = 0.0;
                    pdBaryDirArray[n2].m_data[(n2 + 2) % 3] = 1.0;
                    d = PwBary.getOrientedAngle(this.m_geom, n, this.m_base[n][n2], pdBaryDirArray[n2], false);
                    d /= 2.0;
                } else {
                    d = PwBary.getOrientedAngle(this.m_geom, n, this.m_base[n][n2], pdBaryDirArray[n2], false);
                }
                double d3 = d - Math.PI * 2 / this.m_ABT[n][n2][1] * (this.m_ABT[n][n2][0] + d);
                PwBary.rotateInElement(this.m_geom, n, this.m_base[n][n2], d3, pdBaryDirArray[n2], false);
                pdBaryDirArray[n2].multScalar(this.m_ABT[n][n2][2]);
            } while (++n2 < 3);
            n2 = 0;
            do {
                int n5 = 0;
                do {
                    int n6 = n2;
                    pdBaryDir.m_data[n6] = pdBaryDir.m_data[n6] + pdBary.m_data[n5] * pdBaryDirArray[n5].m_data[n2];
                } while (++n5 < 3);
            } while (++n2 < 3);
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            PsDebug.warning((String)"Invalid vector field.");
            return;
        }
        catch (NullPointerException nullPointerException) {
            PsDebug.warning((String)"Invalid vector field or missing outdir.");
            return;
        }
    }
}

