/*
 * Decompiled with CFR 0.152.
 */
package jvx.rsrc;

import java.awt.Component;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.object.PsViewerIf;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;
import jvx.rsrc.PsModelInfo;
import jvx.rsrc.PsSubmission_IP;

public class PsSubmission
extends PsModelInfo {
    protected static final String[] RATING = new String[]{"pending", "accept", "reject", "revise"};
    protected static final int m_maxNumSubmissions = 5;
    protected int m_numSubmissions;
    protected String[] m_submissionId;
    protected String[] m_submissionDate;
    protected String[] m_rating;
    protected String[] m_reviewerId;
    protected String[] m_reviewDate;
    protected String[] m_reviewComment;

    public void showInfoPanel(boolean bl, PsViewerIf psViewerIf) {
        this.m_dialog = new PsSubmission_IP(bl);
        this.m_dialog.init();
        this.m_dialog.setParent((PsUpdateIf)this);
        this.m_dialog.setViewer(psViewerIf);
        this.m_dialog.update((Object)this);
        this.m_dialog.setLocation(20, 5);
        ((Component)((Object)this.m_dialog)).setSize(800, 800);
        ((Component)((Object)this.m_dialog)).setVisible(true);
    }

    public PsXmlSrc getXml() {
        PsXmlSrc psXmlSrc = super.getXml();
        if (psXmlSrc == null) {
            PsDebug.warning((String)"super class failed to create Xml source.");
            return null;
        }
        return this.fillRsrcTree(psXmlSrc);
    }

    public void setXml(PsXmlSrc psXmlSrc) {
        PsXmlNode psXmlNode;
        if (psXmlSrc == null) {
            PsDebug.warning((String)"missing resource.");
            return;
        }
        super.setXml(psXmlSrc);
        PsXmlNode psXmlNode2 = psXmlSrc.getRootNode();
        if (psXmlNode2 == null) {
            psXmlSrc = this.fillRsrcTree(psXmlSrc);
            psXmlNode2 = psXmlSrc.getRootNode();
        }
        if ((psXmlNode = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode2, (String)"submissions")) != null) {
            PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes((PsXmlNode)psXmlNode, (String)"submission");
            if (psXmlNodeArray != null && psXmlNodeArray.length > 0) {
                this.m_numSubmissions = Math.min(psXmlNodeArray.length, 5);
                this.m_submissionId = new String[5];
                this.m_submissionDate = new String[5];
                this.m_rating = new String[5];
                this.m_reviewerId = new String[5];
                this.m_reviewDate = new String[5];
                this.m_reviewComment = new String[5];
                int n = 0;
                while (n < this.m_numSubmissions) {
                    this.m_submissionId[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"submissionid");
                    this.m_submissionDate[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"submissiondate");
                    PsXmlNode psXmlNode3 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNodeArray[n], (String)"review");
                    this.m_rating[n] = psXmlNode3.getAttribute("rating");
                    this.m_reviewerId[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNode3, (String)"reviewerid");
                    this.m_reviewDate[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNode3, (String)"reviewdate");
                    this.m_reviewComment[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNode3, (String)"reviewcomment");
                    ++n;
                }
                return;
            }
            this.m_numSubmissions = 0;
            PsDebug.warning((String)"missing submission node.");
            return;
        }
        this.m_numSubmissions = 0;
        PsDebug.warning((String)"missing submissions node.");
    }

    private PsXmlSrc fillRsrcTree(PsXmlSrc psXmlSrc) {
        PsXmlNode psXmlNode = psXmlSrc.getRootNode();
        PsXmlNode psXmlNode2 = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode, (String)"submissions");
        if (psXmlNode2 == null) {
            psXmlNode2 = new PsXmlNode("submissions");
            psXmlNode.addChild(psXmlNode2);
        }
        psXmlNode2.removeChildren();
        int n = 0;
        while (n < this.m_numSubmissions) {
            PsXmlNode psXmlNode3 = psXmlNode2.addChild("submission");
            psXmlNode3.addAttribute("num", String.valueOf(n + 1));
            psXmlNode3.addChild("submissionid", this.m_submissionId[n]);
            psXmlNode3.addChild("submissiondate", this.m_submissionDate[n]);
            PsXmlNode psXmlNode4 = psXmlNode3.addChild("review");
            psXmlNode4.addAttribute("rating", this.m_rating[n]);
            psXmlNode4.addChild("reviewerid", this.m_reviewerId[n]);
            psXmlNode4.addChild("reviewdate", this.m_reviewDate[n]);
            psXmlNode4.addChild("reviewcomment", this.m_reviewComment[n]);
            ++n;
        }
        return psXmlSrc;
    }
}

