/*
 * Decompiled with CFR 0.152.
 */
package jv.anim;

import java.awt.Component;
import java.util.Enumeration;
import java.util.Vector;
import jv.anim.PsTimeEvent;
import jv.anim.PsTimeListenerIf;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsDialog;
import jv.object.PsObject;

public class PsAnimation
extends PsObject
implements Runnable {
    public static final int FORWARD = 0;
    public static final int REWIND = 1;
    public static final int FAST_FORWARD = 2;
    public static final int FAST_REWIND = 3;
    public static final int ONE_WAY = 0;
    public static final int LOOP = 1;
    public static final int BACK_FORTH = 2;
    protected Vector m_dynamicList;
    protected double m_globalTime;
    protected PuDouble m_currentTime;
    protected int m_speed;
    private double m_timeIncr;
    private long m_sleepInterval;
    protected int m_repeat;
    protected boolean m_syncFlag = true;
    protected boolean m_enableKeys = false;
    protected int[] m_position = new int[]{100, 100, 400, 250};
    protected transient PsDialog m_animDialog;
    protected transient Thread m_thread;
    private static /* synthetic */ Class class$jv$anim$PsAnimation;

    public void stop() {
        if (this.m_thread != null) {
            this.m_thread = null;
            return;
        }
    }

    public void setTimeInterval(double d, double d2, double d3, double d4) {
        this.m_currentTime.setBounds(d, d2, d3, d4);
    }

    public void setTimeInterval(double d, double d2) {
        this.m_currentTime.setBounds(d, d2);
    }

    public PsAnimation() {
        this.setTag(4);
        this.m_currentTime = new PuDouble(PsConfig.getMessage("currentTime"), this);
        this.m_currentTime.setDefBounds(0.0, 100.0, 1.0, 5.0);
        this.m_currentTime.setDefValue(0.0);
        if (this.getClass() == (class$jv$anim$PsAnimation != null ? class$jv$anim$PsAnimation : (class$jv$anim$PsAnimation = PsAnimation.class$("jv.anim.PsAnimation")))) {
            this.init();
        }
    }

    public void setRepeat(int n) {
        this.m_repeat = n;
    }

    public double getTimeStepIncr() {
        return this.m_currentTime.getLineIncr();
    }

    public double getMinTime() {
        return this.m_currentTime.getMin();
    }

    public double getTime() {
        return this.m_currentTime.getValue();
    }

    public void setTime(double d) {
        if (d == this.m_currentTime.getValue()) {
            return;
        }
        this.m_globalTime = d;
        if (!this.m_syncFlag) {
            return;
        }
        boolean bl = this.setTime(new PsTimeEvent(this.m_globalTime));
        if (bl) {
            this.m_currentTime.setValue(this.m_globalTime);
        }
    }

    protected boolean setTime(PsTimeEvent psTimeEvent) {
        if (this.m_dynamicList == null) {
            return true;
        }
        Enumeration enumeration = this.m_dynamicList.elements();
        while (enumeration.hasMoreElements()) {
            PsTimeListenerIf psTimeListenerIf = (PsTimeListenerIf)enumeration.nextElement();
            psTimeListenerIf.setTime(psTimeEvent);
        }
        return true;
    }

    public double getMaxTime() {
        return this.m_currentTime.getMax();
    }

    public boolean update(Object object) {
        if (object == this.m_currentTime) {
            double d;
            this.m_globalTime = d = this.m_currentTime.getValue();
            return this.setTime(new PsTimeEvent(this.m_globalTime));
        }
        if (object == this.m_animDialog) {
            return true;
        }
        return super.update(object);
    }

    public long getSleepInterval() {
        return this.m_sleepInterval;
    }

    public void setSleepInterval(long l) {
        this.m_sleepInterval = l;
    }

    public double getTimePageIncr() {
        return this.m_currentTime.getPageIncr();
    }

    public void start() {
        this.start(0);
    }

    public void start(int n) {
        this.setSpeed(n);
        if (this.m_thread == null) {
            this.m_thread = new Thread((Runnable)this, "JavaView: Animation");
            this.m_thread.start();
            return;
        }
    }

    public boolean hasTimeListener(PsTimeListenerIf psTimeListenerIf) {
        if (this.m_dynamicList == null) {
            return false;
        }
        return this.m_dynamicList.contains(psTimeListenerIf);
    }

    public boolean removeTimeListener(PsTimeListenerIf psTimeListenerIf) {
        if (this.m_dynamicList == null) {
            return false;
        }
        return this.m_dynamicList.removeElement(psTimeListenerIf);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void setPosition(int[] nArray) {
        if (nArray == null || nArray.length < 4) {
            PsDebug.warning("missing or incomplete position");
            return;
        }
        int n = 0;
        do {
            this.m_position[n] = nArray[n];
        } while (++n < 4);
        if (this.m_animDialog != null) {
            this.m_animDialog.setLocation(this.m_position[0], this.m_position[1]);
            ((Component)this.m_animDialog).setSize(this.m_position[2], this.m_position[3]);
        }
    }

    public void synchronize(boolean bl) {
        if (this.m_syncFlag == bl) {
            return;
        }
        this.m_syncFlag = bl;
        if (this.m_syncFlag) {
            this.setTime(this.m_globalTime);
        }
    }

    public boolean addTimeListener(PsTimeListenerIf psTimeListenerIf) {
        if (this.m_dynamicList == null) {
            this.m_dynamicList = new Vector();
        } else if (this.hasTimeListener(psTimeListenerIf)) {
            PsDebug.warning("name = " + psTimeListenerIf.getName() + " of listener already used.");
            return false;
        }
        this.m_dynamicList.addElement(psTimeListenerIf);
        psTimeListenerIf.setAnimation(this);
        return true;
    }

    public void enableKeys(boolean bl) {
        if (this.m_enableKeys == bl) {
            return;
        }
        this.m_enableKeys = bl;
        this.updatePanels(this);
    }

    public void run() {
        while (this.m_thread != null) {
            double d = this.m_currentTime.getValue();
            if ((d += this.m_timeIncr) > this.m_currentTime.getMax() - 1.0E-10) {
                if (this.m_repeat == 0) {
                    this.setTime(this.m_currentTime.getMax());
                    this.stop();
                    return;
                }
                if (this.m_repeat == 1) {
                    d = d < this.m_currentTime.getMax() + 1.0E-10 ? this.m_currentTime.getMax() : this.m_currentTime.getMin();
                } else if (this.m_repeat == 2) {
                    d = this.m_currentTime.getMax();
                    this.m_timeIncr *= -1.0;
                }
            } else if (d < this.m_currentTime.getMin() + 1.0E-10) {
                if (this.m_repeat == 0) {
                    this.setTime(this.m_currentTime.getMin());
                    this.stop();
                    return;
                }
                if (this.m_repeat == 1) {
                    d = d > this.m_currentTime.getMin() - 1.0E-10 ? this.m_currentTime.getMin() : this.m_currentTime.getMax();
                } else if (this.m_repeat == 2) {
                    d = this.m_currentTime.getMin();
                    this.m_timeIncr *= -1.0;
                }
            }
            this.setTime(d);
            if (this.m_thread == null) {
                return;
            }
            try {
                Thread.sleep(this.m_sleepInterval);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void init() {
        super.init();
        this.m_speed = 0;
        this.m_repeat = 2;
        this.m_syncFlag = true;
        this.m_globalTime = 0.0;
        this.m_sleepInterval = 50L;
        this.m_currentTime.init();
    }

    public PsDialog getAnimationPanel() {
        if (this.m_animDialog != null) {
            return this.m_animDialog;
        }
        this.m_animDialog = new PsDialog(PsConfig.getFrame(), PsConfig.getMessage("AnimationPanel"), false);
        if (this.m_animDialog == null) {
            PsDebug.warning("failed allocating animation dialog.");
            return null;
        }
        this.m_animDialog.add("Center", this.getInfoPanel());
        this.m_animDialog.add("South", this.m_animDialog.getBottomButtons(16));
        this.m_animDialog.pack();
        this.m_animDialog.setLocation(this.m_position[0], this.m_position[1]);
        ((Component)this.m_animDialog).setSize(this.m_position[2], this.m_position[3]);
        this.m_animDialog.setParent(this);
        this.m_animDialog.update(this);
        return this.m_animDialog;
    }

    public void setAnimationPanel(PsDialog psDialog) {
        this.m_animDialog = psDialog;
    }

    protected void setSpeed(int n) {
        this.m_speed = n;
        switch (this.m_speed) {
            case 0: {
                this.m_timeIncr = this.m_currentTime.getLineIncr();
                return;
            }
            case 1: {
                this.m_timeIncr = -this.m_currentTime.getLineIncr();
                return;
            }
            case 2: {
                this.m_timeIncr = this.m_currentTime.getPageIncr();
                return;
            }
            case 3: {
                this.m_timeIncr = -this.m_currentTime.getPageIncr();
                return;
            }
        }
    }

    public boolean isRunning() {
        return this.m_thread != null;
    }

    public boolean hasAnimationPanel() {
        return this.m_animDialog != null;
    }
}

