/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvGeometryIf;
import jv.vecmath.P_Vector;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;

public class PgVectorField
extends PgGeometry {
    protected PgPointSet m_basePoints;
    protected PgElementSet m_surface;
    public static final int VERTEX_BASED = 0;
    public static final int ELEMENT_BASED = 1;
    protected int m_basedOn;
    protected int m_dimOfVectors;
    protected int m_numVectors;
    protected int m_maxNumVectors;
    protected PdVector[] m_vector;
    protected Color[] m_vectorColor;
    protected boolean m_bShowVectorArrow;
    protected PdColor m_globalVectorColor;
    protected PuDouble m_globalVectorLength;
    protected PuDouble m_globalVectorSize;
    protected boolean m_bShowVectorColors = false;
    protected int m_index = -1;
    private static /* synthetic */ Class class$jv$geom$PgVectorField;

    public int getBasedOn() {
        return this.m_basedOn;
    }

    public void setBasedOn(int n) {
        if (this.m_basedOn == n) {
            return;
        }
        this.m_basedOn = n;
        if (this.m_surface != null) {
            if (this.m_basedOn == 1) {
                this.setNumVectors(this.m_surface.getNumElements());
                return;
            }
            this.setNumVectors(this.m_surface.getNumVertices());
        }
    }

    public double getGlobalVectorSize() {
        return this.m_globalVectorSize.getValue();
    }

    public void setGlobalVectorSize(double d) {
        this.m_globalVectorSize.setValue(d);
    }

    public boolean merge(PgGeometryIf pgGeometryIf) {
        if (!super.merge(pgGeometryIf)) {
            return false;
        }
        if (!(pgGeometryIf instanceof PgVectorField)) {
            return false;
        }
        PgVectorField pgVectorField = (PgVectorField)pgGeometryIf;
        int n = this.m_numVectors;
        int n2 = this.m_numVectors + pgVectorField.m_numVectors;
        this.setNumVectors(n2);
        PdVector.copy(this.m_vector, n, pgVectorField.m_vector, 0, pgVectorField.m_numVectors);
        if (pgVectorField.m_vectorColor != null) {
            this.assureVectorColors();
            PdColor.copy(this.m_vectorColor, n, pgVectorField.m_vectorColor, 0, pgVectorField.m_numVectors);
        }
        return true;
    }

    public boolean computeGradient(PgElementSet pgElementSet, PgPointSet pgPointSet) {
        int n;
        if (pgElementSet == null || pgPointSet == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (this.m_dim != pgElementSet.getDimOfVertices()) {
            PsDebug.warning("domain and vf have different dimension.");
            return false;
        }
        if (pgElementSet.getDimOfElements() != 3) {
            PgElementSet.triangulate(pgElementSet);
        }
        if ((n = pgElementSet.getNumVertices()) != pgPointSet.getNumVertices()) {
            PsDebug.warning("domain and image have different number of vertices.");
            return false;
        }
        int n2 = pgElementSet.getNumElements();
        this.setBasedOn(1);
        this.setGeometry(pgElementSet);
        this.setNumVectors(n2);
        PiVector[] piVectorArray = pgElementSet.getElements();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        double[] dArray = new double[3];
        PdVector[] pdVectorArray2 = PdVector.realloc(null, 3, this.m_dim);
        PdVector[] pdVectorArray3 = PdVector.realloc(null, 3, this.m_dim);
        int n3 = 0;
        while (n3 < n2) {
            int[] nArray = piVectorArray[n3].m_data;
            double d = pgElementSet.getAreaOfElement(n3);
            PuVectorGeom.ctg(dArray, pdVectorArray[nArray[0]], pdVectorArray[nArray[1]], pdVectorArray[nArray[2]]);
            int n4 = 0;
            do {
                pdVectorArray2[n4].sub(pdVectorArray[nArray[(n4 + 2) % 3]], pdVectorArray[nArray[(n4 + 1) % 3]]);
            } while (++n4 < 3);
            n4 = 0;
            do {
                pdVectorArray3[n4].blend(dArray[(n4 + 1) % 3], pdVectorArray2[(n4 + 1) % 3], -dArray[(n4 + 2) % 3], pdVectorArray2[(n4 + 2) % 3]);
                pdVectorArray3[n4].multScalar(1.0 / (2.0 * d));
            } while (++n4 < 3);
            this.m_vector[n3].setConstant(0.0);
            n4 = 0;
            do {
                pdVectorArray3[n4].multScalar(pgPointSet.m_vertex[nArray[n4]].m_data[0]);
                this.m_vector[n3].add(pdVectorArray3[n4]);
            } while (++n4 < 3);
            ++n3;
        }
        return true;
    }

    public double getGlobalVectorLength() {
        return this.m_globalVectorLength.getValue();
    }

    public void setGlobalVectorLength(double d) {
        this.m_globalVectorLength.setValue(d);
    }

    public PdVector[] getVertices() {
        if (this.m_basePoints != null) {
            return this.m_basePoints.getVertices();
        }
        PsDebug.warning("missing base points.");
        return null;
    }

    protected void project(int n) {
        if (this.m_dim < 3) {
            return;
        }
        PdVector pdVector = this.m_vector[n];
        double d = 1.0E-10;
        PiVector[] piVectorArray = this.m_surface.getElements();
        PdVector[] pdVectorArray = this.m_surface.getVertices();
        PdVector[] pdVectorArray2 = new PdVector[3];
        int n2 = 0;
        do {
            pdVectorArray2[n2] = new PdVector(this.m_dim);
        } while (++n2 < 3);
        n2 = 0;
        do {
            pdVectorArray2[n2].setSize(pdVectorArray[piVectorArray[n].m_data[n2]].getSize());
            pdVectorArray2[n2].copy(pdVectorArray[piVectorArray[n].m_data[n2]]);
        } while (++n2 < 3);
        pdVectorArray2[1].sub(pdVectorArray2[0]);
        pdVectorArray2[2].sub(pdVectorArray2[0]);
        PdVector pdVector2 = new PdVector(this.m_dim);
        int n3 = 0;
        while (n3 < this.m_dim) {
            pdVector2.m_data[n3] = 0.0;
            ++n3;
        }
        if (this.m_dim == 3) {
            pdVector2 = PdVector.crossNew(pdVectorArray2[1], pdVectorArray2[2]);
            double d2 = pdVector2.length();
            if (d2 < d) {
                PsDebug.warning("elements degenerated in element set");
                return;
            }
            pdVector2.multScalar(1.0 / d2);
            double d3 = PdVector.dot(pdVector2, pdVector);
            pdVector2.multScalar(-d3);
            pdVector2.add(pdVector);
        }
        pdVector.copy(pdVector2);
    }

    public boolean update(Object object) {
        if (object == null) {
            return super.update(object);
        }
        if (object == this.m_surface) {
            this.setGeometry(this.m_surface);
            return super.update(null);
        }
        if (object == this.m_basePoints) {
            this.setGeometry(this.m_basePoints);
            return super.update(null);
        }
        if (object == this.m_globalVectorSize) {
            return super.update(this);
        }
        if (object == this.m_globalVectorLength) {
            return super.update(this);
        }
        if (object == this.m_globalVectorColor) {
            return super.update(this);
        }
        return super.update(object);
    }

    public void makeTangent() {
        if (this.m_basedOn == 0) {
            PsDebug.warning("vector field is vertex based");
            return;
        }
        int n = 0;
        while (n < this.m_numVectors) {
            this.project(n);
            ++n;
        }
    }

    public Color getGlobalVectorColor() {
        return this.m_globalVectorColor.getColor();
    }

    public void setGlobalVectorColor(Color color) {
        this.m_globalVectorColor.setColor(color);
    }

    public void assureVectorColors() {
        if (this.m_vectorColor == null || this.m_vectorColor.length != this.m_maxNumVectors) {
            this.m_vectorColor = PdColor.realloc(this.m_vectorColor, this.m_maxNumVectors);
        }
    }

    public Color[] getVectorColors() {
        return this.m_vectorColor;
    }

    public void setVectorColors(Color[] colorArray) {
        if (colorArray == null) {
            this.m_vectorColor = null;
            return;
        }
        if (colorArray.length < this.m_numVectors) {
            PsDebug.warning("void length of argument array");
            return;
        }
        this.assureVectorColors();
        PdColor.copy(this.m_vectorColor, 0, colorArray, 0, this.m_numVectors);
    }

    public int getNumVectors() {
        return this.m_numVectors;
    }

    public void setNumVectors(int n) {
        if (n > this.m_maxNumVectors) {
            this.setMaxNumVectors(n);
        }
        this.m_numVectors = n;
    }

    public Object clone() {
        PgVectorField pgVectorField = (PgVectorField)super.clone();
        if (pgVectorField == null) {
            return null;
        }
        pgVectorField.m_basePoints = null;
        pgVectorField.m_surface = null;
        pgVectorField.m_globalVectorSize = (PuDouble)this.m_globalVectorSize.clone();
        pgVectorField.m_globalVectorLength = (PuDouble)this.m_globalVectorLength.clone();
        pgVectorField.m_globalVectorColor = (PdColor)this.m_globalVectorColor.clone();
        pgVectorField.m_globalVectorSize.setParent(pgVectorField);
        pgVectorField.m_globalVectorLength.setParent(pgVectorField);
        pgVectorField.m_globalVectorColor.setParent(pgVectorField);
        if (this.m_vector != null) {
            pgVectorField.m_vector = (PdVector[])P_Vector.clone(this.m_vector);
        }
        if (this.m_vectorColor != null) {
            pgVectorField.m_vectorColor = (Color[])this.m_vectorColor.clone();
        }
        return pgVectorField;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgVectorField ***********\n");
        stringBuffer.append("\t m_numVectors = " + this.m_numVectors + "\n");
        stringBuffer.append("\t ******* m_vector *******\n");
        if (this.m_vector != null && this.m_numVectors > 0) {
            int n = 0;
            while (n < this.m_numVectors) {
                stringBuffer.append("\t [" + n + "] = " + this.m_vector[n].toShortString());
                ++n;
            }
        } else {
            stringBuffer.append("\t m_vector = null");
        }
        return stringBuffer.toString();
    }

    public PgVectorField(int n) {
        this(n, 0);
    }

    public PgVectorField(int n, int n2) {
        super(n);
        this.setTag(4);
        this.m_dimOfVectors = n;
        this.m_basedOn = n2;
        this.m_globalVectorColor = new PdColor(PsConfig.getMessage("globalVectorColor"), this);
        this.m_globalVectorLength = new PuDouble(PsConfig.getMessage("globalVectorLength"), this);
        this.m_globalVectorSize = new PuDouble(PsConfig.getMessage("globalVectorSize"), this);
        if (this.getClass() == (class$jv$geom$PgVectorField != null ? class$jv$geom$PgVectorField : (class$jv$geom$PgVectorField = PgVectorField.class$("jv.geom.PgVectorField")))) {
            this.init();
        }
    }

    public void paint(PvGeometryIf pvGeometryIf) {
        pvGeometryIf.setNumVectors(this.m_index, this.m_numVectors, this.m_dimOfVectors);
        pvGeometryIf.setVectors(this.m_index, this.m_vector);
        pvGeometryIf.setVectorElementBased(this.m_index, this.m_basedOn == 1);
        pvGeometryIf.showVectorField(this.m_index, this.isVisible());
        pvGeometryIf.showVectorArrows(this.m_index, this.m_bShowVectorArrow);
        pvGeometryIf.showVectorColors(this.m_index, this.m_bShowVectorColors);
        pvGeometryIf.setGlobalVectorColor(this.m_index, this.m_globalVectorColor.getColor());
        pvGeometryIf.setGlobalVectorLength(this.m_index, this.m_globalVectorLength.getValue());
        pvGeometryIf.setGlobalVectorSize(this.m_index, this.m_globalVectorSize.getValue());
    }

    public void clearTagVector(int n, int n2) {
        if (n < 0 || n > this.m_numVectors - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return;
        }
        this.m_vector[n].clearTag(n2);
    }

    public PdVector getVector(int n) {
        if (n < 0 || n > this.m_numVectors - 1) {
            PsDebug.warning("index out of range");
            return null;
        }
        return this.m_vector[n];
    }

    public boolean setVector(int n, PdVector pdVector) {
        if (n < 0 || n > this.m_numVectors - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        if (pdVector == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        this.m_vector[n].copy(pdVector);
        return true;
    }

    public void setVector(int n, double d, double d2) {
        if (n < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (this.m_dim != 2) {
            PsDebug.error("wrong vector dimension", this);
            return;
        }
        if (n > this.m_numVectors - 1) {
            PsDebug.warning("index=" + n + " > " + this.m_numVectors + "=m_numVectors, bad programming style", this);
            this.setNumVectors(n + 1);
        }
        this.m_vector[n].set(d, d2);
    }

    public void setVector(int n, double d, double d2, double d3) {
        if (n < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (this.m_dim != 3) {
            PsDebug.error("wrong vector dimension", this);
            return;
        }
        if (n > this.m_numVectors - 1) {
            PsDebug.warning("index=" + n + " > " + this.m_numVectors + "=m_numVectors, bad programming style", this);
            this.setNumVectors(n + 1);
        }
        this.m_vector[n].set(d, d2, d3);
    }

    public boolean blend(double d, PgVectorField pgVectorField, double d2, PgVectorField pgVectorField2) {
        int n;
        if (pgVectorField == null || pgVectorField2 == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (Math.abs(d) < 1.0E-10) {
            d = 0.0;
        }
        if (Math.abs(d2) < 1.0E-10) {
            d2 = 0.0;
        }
        this.m_dim = pgVectorField.m_dim;
        if (pgVectorField.m_numVectors == 0) {
            PsDebug.warning("empty first argument");
            return false;
        }
        if (pgVectorField.m_numVectors != pgVectorField2.m_numVectors) {
            PsDebug.warning("wrong second argument");
            return false;
        }
        this.setVisible(pgVectorField.isVisible());
        this.m_globalVectorColor.blend(d, pgVectorField.m_globalVectorColor, d2, pgVectorField2.m_globalVectorColor);
        this.m_globalVectorSize.blend(d, pgVectorField.m_globalVectorSize, d2, pgVectorField2.m_globalVectorSize);
        this.m_globalVectorLength.blend(d, pgVectorField.m_globalVectorLength, d2, pgVectorField2.m_globalVectorLength);
        this.setNumVectors(pgVectorField.m_numVectors);
        if (pgVectorField.m_vector != null && pgVectorField2.m_vector != null) {
            n = 0;
            while (n < this.m_numVectors) {
                this.m_vector[n].blend(d, pgVectorField.m_vector[n], d2, pgVectorField2.m_vector[n]);
                ++n;
            }
        }
        if (pgVectorField.m_vectorColor != null && pgVectorField2.m_vectorColor != null) {
            this.m_vectorColor = PdColor.realloc(this.m_vectorColor, this.m_numVectors);
            n = 0;
            while (n < this.m_numVectors) {
                this.m_vectorColor[n] = PdColor.blend(d, pgVectorField.m_vectorColor[n], d2, pgVectorField2.m_vectorColor[n]);
                ++n;
            }
        }
        return true;
    }

    public void setTagVector(int n, int n2) {
        if (n < 0 || n > this.m_numVectors - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return;
        }
        this.m_vector[n].setTag(n2);
    }

    public boolean removeVector(int n) {
        if (n < 0 || n > this.m_numVectors - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        this.m_vector[n].setTag(2);
        return true;
    }

    public void setGeometry(PgPointSet pgPointSet) {
        this.m_basePoints = pgPointSet;
        int n = pgPointSet.getNumVertices();
        int n2 = pgPointSet.getDimOfVertices();
        if (pgPointSet instanceof PgElementSet) {
            this.m_surface = (PgElementSet)pgPointSet;
            if (this.m_basedOn == 1) {
                n = this.m_surface.getNumElements();
            }
        }
        if (n != this.m_numVectors) {
            this.setDimOfVertices(n2);
            this.setNumVectors(n);
        }
    }

    public void copy(PgGeometry pgGeometry) {
        super.copy(pgGeometry);
        if (!(pgGeometry instanceof PgVectorField)) {
            return;
        }
        PgVectorField pgVectorField = (PgVectorField)pgGeometry;
        this.m_basePoints = pgVectorField.m_basePoints;
        this.m_surface = pgVectorField.m_surface;
        this.m_basedOn = pgVectorField.m_basedOn;
        this.m_dimOfVectors = pgVectorField.m_dimOfVectors;
        this.m_numVectors = pgVectorField.m_numVectors;
        this.m_maxNumVectors = pgVectorField.m_maxNumVectors;
        this.m_vector = pgVectorField.m_vector != null ? PdVector.copyNew(pgVectorField.m_vector) : null;
        if (pgVectorField.m_vectorColor != null) {
            this.m_vectorColor = new Color[pgVectorField.m_vectorColor.length];
            PdColor.copy(this.m_vectorColor, 0, pgVectorField.m_vectorColor, 0, pgVectorField.m_vectorColor.length);
        } else {
            this.m_vectorColor = null;
        }
        this.m_bShowVectorArrow = pgVectorField.m_bShowVectorArrow;
        this.m_globalVectorColor.copy(pgVectorField.m_globalVectorColor);
        this.m_globalVectorLength.copy(pgVectorField.m_globalVectorLength);
        this.m_globalVectorSize.copy(pgVectorField.m_globalVectorSize);
        this.m_bShowVectorColors = pgVectorField.m_bShowVectorColors;
    }

    protected void setIndex(int n) {
        this.m_index = n;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PdVector[] getVectors() {
        return this.m_vector;
    }

    public void init() {
        super.init();
        this.m_numVectors = 0;
        this.m_maxNumVectors = 0;
        this.m_vector = null;
        this.m_vectorColor = null;
        this.m_globalVectorColor.setColor(Color.yellow);
        this.m_globalVectorLength.setDefValue(2.0);
        this.m_globalVectorLength.setDefBounds(0.0, 10.0, 0.1, 1.0);
        this.m_globalVectorLength.init();
        this.m_globalVectorSize.setDefValue(1.0);
        this.m_globalVectorSize.setDefBounds(1.0, 10.0, 1.0, 2.0);
        this.m_globalVectorSize.init();
    }

    public boolean setVectors(PdVector[] pdVectorArray) {
        if (pdVectorArray == null || pdVectorArray.length == 0 || pdVectorArray.length < this.m_numVectors) {
            PsDebug.warning("void length of argument vector array");
            return false;
        }
        int n = pdVectorArray[0].getSize();
        int n2 = 0;
        while (n2 < this.m_numVectors) {
            int n3 = pdVectorArray[n2].getSize();
            this.m_vector[n2].setSize(n3);
            if (n != -1 && n3 != n) {
                n = -1;
            }
            ++n2;
        }
        this.m_dimOfVectors = n;
        PdVector.copy(this.m_vector, 0, pdVectorArray, 0, this.m_numVectors);
        return true;
    }

    public int getDimOfVectors() {
        return this.m_dimOfVectors;
    }

    protected int getMaxNumVectors() {
        return this.m_maxNumVectors;
    }

    protected void setMaxNumVectors(int n) {
        if (this.m_maxNumVectors == n) {
            return;
        }
        this.m_vector = PdVector.realloc(this.m_vector, n, this.m_dimOfVectors);
        if (this.m_vectorColor != null) {
            this.m_vectorColor = PdColor.realloc(this.m_vectorColor, n);
        }
        this.m_maxNumVectors = n;
        if (this.m_maxNumVectors < this.m_numVectors) {
            this.m_numVectors = this.m_maxNumVectors;
        }
    }
}

