/*
 * Decompiled with CFR 0.152.
 */
package jv.number;

import java.awt.Color;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PuData;

public final class PdColor
extends PsObject {
    private static final int MIN_VALUE = 0;
    private static final int MAX_VALUE = 255;
    private static final int m_numDefColors = 3;
    protected boolean m_hasAlpha;
    protected int[] m_data;
    protected boolean m_enabled = true;

    public static Color rgb2hsl(int n, int n2, int n3) {
        double d;
        double d2;
        double d3 = (double)n / 255.0;
        double d4 = (double)n2 / 255.0;
        double d5 = (double)n3 / 255.0;
        double d6 = Math.min(Math.min(d3, d4), d5);
        double d7 = Math.max(Math.max(d3, d4), d5);
        double d8 = (d7 + d6) / 2.0;
        if (d7 == d6) {
            d2 = 0.0;
            d = 0.0;
        } else {
            d2 = d8 <= 0.5 ? (d7 - d6) / (d7 + d6) : (d7 - d6) / (2.0 - d7 - d6);
            double d9 = d7 - d6;
            d = d3 == d7 ? (d4 - d5) / d9 : (d4 == d7 ? 2.0 + (d5 - d3) / d9 : 4.0 + (d3 - d4) / d9);
            if ((d /= 6.0) < 0.0) {
                d += 1.0;
            }
        }
        return new Color((int)(d * 255.0), (int)(d8 * 255.0), (int)(d2 * 255.0));
    }

    public int getRed() {
        if (this.getSize() == 3) {
            return this.m_data[0];
        }
        return 0;
    }

    public int getEntry(int n) {
        if (n < 0 || this.getSize() <= n) {
            PsDebug.warning("index=" + n + " out of range");
            return 0;
        }
        return this.m_data[n];
    }

    public void setEntry(int n, int n2) {
        if (n < 0 || this.getSize() <= n) {
            PsDebug.warning("index=" + n + " out of range");
            return;
        }
        this.m_data[n] = n2;
    }

    public int indexOfMax() {
        int n = 0;
        int n2 = 0;
        int n3 = this.getSize();
        int n4 = 0;
        while (n4 < n3) {
            if (this.m_data[n4] > n2) {
                n2 = this.m_data[n4];
                n = n4;
            }
            ++n4;
        }
        return n;
    }

    public static void hsv2rgb(PdColor pdColor, PdColor pdColor2) {
        Color color = PdColor.hsv2rgb(pdColor2.m_data[0], pdColor2.m_data[1], pdColor2.m_data[2]);
        pdColor.setColor(color);
    }

    public static Color hsv2rgb(Color color) {
        return PdColor.hsv2rgb(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static Color hsv2rgb(int n, int n2, int n3) {
        if (n2 == 0) {
            return new Color(n3, n3, n3);
        }
        float f = (float)((double)n * 6.0 / 256.0);
        int n4 = (int)f;
        float f2 = (float)((double)(n3 * n2) / 255.0);
        int n5 = (int)((float)n3 - f2);
        int n6 = (int)((float)n3 - (f -= (float)n4) * f2);
        int n7 = (int)((double)n3 - (1.0 - (double)f) * (double)f2);
        switch (n4) {
            case 0: {
                return new Color(n3, n7, n5);
            }
            case 1: {
                return new Color(n6, n3, n5);
            }
            case 2: {
                return new Color(n5, n3, n7);
            }
            case 3: {
                return new Color(n5, n6, n3);
            }
            case 4: {
                return new Color(n7, n5, n3);
            }
            case 5: {
                return new Color(n3, n5, n6);
            }
        }
        return new Color(0, 0, 0);
    }

    private static double value(double d, double d2, double d3) {
        if (d3 < 0.0) {
            d3 += 360.0;
        }
        if (d3 > 360.0) {
            d3 -= 360.0;
        }
        if (d3 < 60.0) {
            return d + (d2 - d) * d3 / 60.0;
        }
        if (d3 < 180.0) {
            return d2;
        }
        if (d3 < 240.0) {
            return d + (d2 - d) * (240.0 - d3) / 60.0;
        }
        return d;
    }

    public int getBlue() {
        if (this.getSize() == 3) {
            return this.m_data[2];
        }
        return 0;
    }

    public static Color hsl2rgb(int n, int n2, int n3) {
        double d;
        double d2;
        double d3;
        double d4 = (double)n / 255.0 * 360.0;
        double d5 = (double)n2 / 255.0;
        double d6 = (double)n3 / 255.0;
        double d7 = d5 < 0.5 ? d5 * (1.0 + d6) : d5 + d6 - d5 * d6;
        double d8 = 2.0 * d5 - d7;
        if (d6 == 0.0) {
            d3 = d5;
            d2 = d5;
            d = d5;
        } else {
            d3 = PdColor.value(d8, d7, d4 + 120.0);
            d2 = PdColor.value(d8, d7, d4);
            d = PdColor.value(d8, d7, d4 - 120.0);
        }
        return new Color((int)(d3 * 255.0), (int)(d2 * 255.0), (int)(d * 255.0));
    }

    public boolean equals(Color color) {
        int n = this.getSize();
        if (color == null && n == 0) {
            return true;
        }
        if (color == null) {
            return false;
        }
        if (n < 3) {
            return false;
        }
        if (this.getRed() != color.getRed()) {
            return false;
        }
        if (this.getGreen() != color.getGreen()) {
            return false;
        }
        return this.getBlue() == color.getBlue();
    }

    public boolean equals(PdColor pdColor) {
        int n = this.getSize();
        if (pdColor == null && n == 0) {
            return true;
        }
        if (pdColor == null) {
            return false;
        }
        if (n != pdColor.getSize()) {
            return false;
        }
        --n;
        while (n >= 0) {
            if (this.m_data[n] != pdColor.m_data[n]) {
                return false;
            }
            --n;
        }
        return true;
    }

    public static PdColor copyNew(PdColor pdColor) {
        if (pdColor == null) {
            PsDebug.warning("missing argument color");
            return null;
        }
        PdColor pdColor2 = new PdColor(pdColor.getSize(), pdColor.hasAlpha());
        pdColor2.copy(pdColor);
        return pdColor2;
    }

    public static PdColor[] copyNew(PdColor[] pdColorArray) {
        if (pdColorArray == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        return PdColor.copyNew(pdColorArray, pdColorArray.length);
    }

    public static Color getDimmedColor(Color color, double d) {
        if (d == 1.0) {
            return color;
        }
        if (d <= 0.0) {
            return Color.black;
        }
        int n = color.getRGB();
        int n2 = (int)(d * (double)(n >> 16 & 0xFF));
        int n3 = (int)(d * (double)(n >> 8 & 0xFF));
        int n4 = (int)(d * (double)(n & 0xFF));
        if (d > 1.0) {
            if (n2 > 255) {
                n2 = 255;
            }
            if (n3 > 255) {
                n3 = 255;
            }
            if (n4 > 255) {
                n4 = 255;
            }
        }
        return new Color(n2, n3, n4);
    }

    public static Color getDimmedColor(Color color, double d, double d2) {
        int n = color.getRGB();
        int n2 = (int)(d2 + d * (double)(n >> 16 & 0xFF));
        int n3 = (int)(d2 + d * (double)(n >> 8 & 0xFF));
        int n4 = (int)(d2 + d * (double)(n & 0xFF));
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        if (n3 > 255) {
            n3 = 255;
        }
        if (n4 > 255) {
            n4 = 255;
        }
        return new Color(n2, n3, n4);
    }

    public static PdColor[] copyNew(PdColor[] pdColorArray, int n) {
        if (pdColorArray == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        PdColor[] pdColorArray2 = new PdColor[n];
        int n2 = 0;
        while (n2 < n) {
            PdColor cfr_ignored_0 = pdColorArray2[n2];
            PdColor.copyNew(pdColorArray[n2]);
            ++n2;
        }
        return pdColorArray2;
    }

    public int getSize() {
        if (this.m_data == null) {
            return 0;
        }
        if (this.hasAlpha()) {
            return this.m_data.length - 1;
        }
        return this.m_data.length;
    }

    public void setSize(int n) {
        if (this.hasAlpha()) {
            ++n;
        }
        if (this.m_data != null && this.m_data.length == n) {
            return;
        }
        this.m_data = PuData.realloc(this.m_data, n);
    }

    public int getGrey() {
        if (this.getSize() == 1) {
            return this.m_data[0];
        }
        return 0;
    }

    public void blendBase(PdColor pdColor, double d, PdColor pdColor2) {
        this.blend(1.0, pdColor, d, pdColor2);
    }

    public Object clone() {
        PdColor pdColor = (PdColor)super.clone();
        if (pdColor == null) {
            return null;
        }
        pdColor.m_data = (int[])this.m_data.clone();
        return pdColor;
    }

    public int min() {
        int n = 255;
        int n2 = this.getSize();
        int n3 = 0;
        while (n3 < n2) {
            if (this.m_data[n3] < n) {
                n = this.m_data[n3];
            }
            ++n3;
        }
        return n;
    }

    public boolean hasAlpha() {
        return this.m_hasAlpha;
    }

    public void set(int n) {
        if (this.getSize() < 1) {
            PsDebug.warning("too small number of components == " + this.getSize());
            return;
        }
        this.m_data[0] = n;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void set(int n, int n2, int n3) {
        if (this.getSize() < 3) {
            PsDebug.warning("too small number of components == " + this.getSize());
            return;
        }
        this.m_data[0] = n;
        this.m_data[1] = n2;
        this.m_data[2] = n3;
    }

    public void set(int n, int n2, int n3, int n4) {
        this.set(n, n2, n3);
        this.setAlpha(n4);
    }

    public void set(double d) {
        this.set((int)(255.0 * d));
    }

    public PdColor() {
        this(3, false);
    }

    public PdColor(int n, boolean bl) {
        this.enableAlpha(bl);
        this.setSize(n);
        this.init();
    }

    public PdColor(String string, PsUpdateIf psUpdateIf) {
        this.setName(string);
        this.setParent(psUpdateIf);
        this.enableAlpha(false);
        this.setSize(3);
        this.init();
    }

    public Color getColor() {
        if (this.getSize() < 3) {
            PsDebug.warning("too small number of components == " + this.getSize());
            return null;
        }
        return new Color(this.m_data[0], this.m_data[1], this.m_data[2]);
    }

    public void setColor(Color color) {
        if (color == null) {
            PsDebug.warning("missing aColor");
            return;
        }
        int n = color.getRGB();
        this.set(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
        if (this.hasInspector("Info")) {
            this.getInspector("Info").update(this);
        }
    }

    public void set(double d, double d2, double d3) {
        this.set((int)(255.0 * d), (int)(255.0 * d2), (int)(255.0 * d3));
    }

    public void set(double d, double d2, double d3, double d4) {
        this.set((int)(255.0 * d), (int)(255.0 * d2), (int)(255.0 * d3));
        this.setAlpha((int)(255.0 * d4));
    }

    public int max() {
        int n = 0;
        int n2 = this.getSize();
        int n3 = 0;
        while (n3 < n2) {
            if (this.m_data[n3] > n) {
                n = this.m_data[n3];
            }
            ++n3;
        }
        return n;
    }

    public static Color blend(double d, Color color, double d2, Color color2) {
        return new Color((int)(d * (double)color.getRed() + d2 * (double)color2.getRed()), (int)(d * (double)color.getGreen() + d2 * (double)color2.getGreen()), (int)(d * (double)color.getBlue() + d2 * (double)color2.getBlue()));
    }

    public void blend(double d, PdColor pdColor, double d2, PdColor pdColor2) {
        int n = 0;
        while (n < this.m_data.length) {
            int n2 = (int)((double)pdColor.m_data[n] * d + (double)pdColor2.m_data[n] * d2);
            this.m_data[n] = n2 <= 0 ? 0 : (n2 >= 255 ? 255 : n2);
            ++n;
        }
    }

    public static void rgb2hsv(PdColor pdColor, PdColor pdColor2) {
        int n = pdColor2.max();
        int n2 = pdColor2.min();
        pdColor.m_data[2] = n;
        pdColor.m_data[1] = n == 0 ? 0 : (int)((double)(n - n2) * 255.0 / (double)n);
        if (pdColor.m_data[1] == 0) {
            pdColor.m_data[0] = 0;
            return;
        }
        double d = 0.0;
        double d2 = n - n2;
        d = pdColor2.m_data[0] == n ? (double)(pdColor2.m_data[1] - pdColor2.m_data[2]) / d2 : (pdColor2.m_data[1] == n ? 2.0 + (double)(pdColor2.m_data[2] - pdColor2.m_data[0]) / d2 : 4.0 + (double)(pdColor2.m_data[0] - pdColor2.m_data[1]) / d2);
        if ((d *= 60.0) < 0.0) {
            d += 360.0;
        }
        pdColor.m_data[0] = (int)d;
    }

    public void copy(PdColor pdColor) {
        if (pdColor == null) {
            PsDebug.warning("missing argument color");
            return;
        }
        int n = pdColor.getSize();
        if (this.m_data != null && this.getSize() != n) {
            PsDebug.warning("argument color has different size");
            return;
        }
        if (this.hasAlpha() != pdColor.hasAlpha()) {
            this.enableAlpha(pdColor.hasAlpha());
        }
        if (this.m_data == null) {
            this.setSize(n);
        }
        System.arraycopy(pdColor.m_data, 0, this.m_data, 0, n);
        super.copy(pdColor);
    }

    public void copy(int[] nArray, int n) {
        if (nArray == null) {
            PsDebug.warning("missing argument array");
            return;
        }
        if (this.m_data == null) {
            this.setSize(n);
        }
        if (this.getSize() != n) {
            PsDebug.warning("missing space in destination");
            return;
        }
        System.arraycopy(this.m_data, 0, nArray, 0, n);
    }

    public void copy(double[] dArray, int n) {
        if (dArray == null) {
            PsDebug.warning("missing argument array");
            return;
        }
        if (this.m_data == null) {
            this.setSize(n);
        }
        if (this.getSize() != n) {
            PsDebug.warning("missing space in destination");
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            this.m_data[n2] = (int)(255.0 * dArray[n2]);
            ++n2;
        }
    }

    public static boolean copy(Color[] colorArray, int n, Color[] colorArray2, int n2, int n3) {
        if (colorArray == null || colorArray.length < n + n3) {
            PsDebug.warning("missing space in dataDest");
            return false;
        }
        int n4 = 0;
        while (n4 < n3) {
            colorArray[n + n4] = colorArray2[n2 + n4];
            ++n4;
        }
        return true;
    }

    public int getAlpha() {
        if (!this.hasAlpha()) {
            return 0;
        }
        return this.m_data[this.getSize()];
    }

    public void enableAlpha(boolean bl) {
        if (this.m_hasAlpha == bl) {
            return;
        }
        int n = this.getSize();
        this.m_hasAlpha = bl;
        this.setSize(n);
    }

    public void setAlpha(int n) {
        if (!this.hasAlpha()) {
            PsDebug.warning("alpha not enabled");
            return;
        }
        this.m_data[this.getSize()] = n;
    }

    public void setAlpha(double d) {
        this.setAlpha((int)(255.0 * d));
    }

    public static boolean copy(PdColor[] pdColorArray, int n, PdColor[] pdColorArray2, int n2, int n3) {
        if (pdColorArray == null || pdColorArray.length < n + n3) {
            PsDebug.warning("missing space in dataDest");
            return false;
        }
        int n4 = 0;
        while (n4 < n3) {
            pdColorArray[n + n4].copy(pdColorArray2[n2 + n4]);
            ++n4;
        }
        return true;
    }

    public static Color yiq2rgb(int n, int n2, int n3) {
        double d = (double)n / 255.0;
        double d2 = ((double)n2 / 255.0 * 2.0 - 1.0) * 0.596;
        double d3 = ((double)n3 / 255.0 * 2.0 - 1.0) * 0.522;
        double d4 = Math.min(1.0, Math.max(0.0, d + 0.956 * d2 + 0.623 * d3));
        double d5 = Math.min(1.0, Math.max(0.0, d - 0.272 * d2 - 0.648 * d3));
        double d6 = Math.min(1.0, Math.max(0.0, d - 1.105 * d2 + 0.705 * d3));
        return new Color((int)(d4 * 255.0), (int)(d5 * 255.0), (int)(d6 * 255.0));
    }

    public void init() {
        super.init();
        this.setConstant(0);
    }

    public void setEnabled(boolean bl) {
        if (this.m_enabled == bl) {
            return;
        }
        this.m_enabled = bl;
        if (this.hasInspector("Info")) {
            this.getInspector("Info").setEnabled(bl);
        }
    }

    public int getGreen() {
        if (this.getSize() == 3) {
            return this.m_data[1];
        }
        return 0;
    }

    public void setConstant(int n) {
        int n2 = 0;
        while (n2 < this.m_data.length) {
            this.m_data[n2] = n;
            ++n2;
        }
    }

    public int indexOfMin() {
        int n = 0;
        int n2 = 255;
        int n3 = this.getSize();
        int n4 = 0;
        while (n4 < n3) {
            if (this.m_data[n4] < n2) {
                n2 = this.m_data[n4];
                n = n4;
            }
            ++n4;
        }
        return n;
    }

    public static Color rgb2yiq(int n, int n2, int n3) {
        double d = (double)n / 255.0;
        double d2 = (double)n2 / 255.0;
        double d3 = (double)n3 / 255.0;
        double d4 = 0.299 * d + 0.587 * d2 + 0.114 * d3;
        double d5 = 0.596 * d - 0.274 * d2 - 0.322 * d3;
        double d6 = 0.211 * d - 0.522 * d2 + 0.311 * d3;
        d5 = (d5 / 0.596 + 1.0) / 2.0;
        d6 = (d6 / 0.522 + 1.0) / 2.0;
        return new Color((int)(d4 * 255.0), (int)(d5 * 255.0), (int)(d6 * 255.0));
    }

    public static Color parseColor(String string) {
        if (string == null) {
            PsDebug.warning("missing color string.");
            return null;
        }
        try {
            String[] stringArray = PuString.splitString(string, ' ');
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            int n3 = Integer.parseInt(stringArray[2]);
            return new Color(n, n2, n3);
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning("wrong format in color = " + string);
            return null;
        }
    }

    public static Color[] realloc(Color[] colorArray, int n) {
        if (colorArray != null && colorArray.length == n) {
            return colorArray;
        }
        Color[] colorArray2 = new Color[n];
        int n2 = 0;
        if (colorArray != null && (n2 = Math.min(colorArray.length, n)) != 0) {
            System.arraycopy(colorArray, 0, colorArray2, 0, n2);
        }
        int n3 = n2;
        while (n3 < n) {
            colorArray2[n3] = Color.black;
            ++n3;
        }
        return colorArray2;
    }

    public static PdColor[] realloc(PdColor[] pdColorArray, int n, int n2) {
        return PdColor.realloc(pdColorArray, n, n2, false);
    }

    public static PdColor[] realloc(PdColor[] pdColorArray, int n, int n2, boolean bl) {
        int n3;
        if (pdColorArray != null && pdColorArray.length == n) {
            int n4 = 0;
            while (n4 < pdColorArray.length) {
                pdColorArray[n4].enableAlpha(bl);
                pdColorArray[n4].setSize(n2);
                ++n4;
            }
            return pdColorArray;
        }
        PdColor[] pdColorArray2 = new PdColor[n];
        if (pdColorArray == null) {
            n3 = 0;
        } else {
            n3 = Math.min(pdColorArray.length, n);
            System.arraycopy(pdColorArray, 0, pdColorArray2, 0, n3);
        }
        int n5 = 0;
        while (n5 < n3) {
            if (pdColorArray2[n5].hasAlpha() != bl) {
                pdColorArray2[n5].enableAlpha(bl);
            }
            if (pdColorArray2[n5].getSize() != n2) {
                pdColorArray2[n5].setSize(n2);
            }
            ++n5;
        }
        n5 = n3;
        while (n5 < n) {
            pdColorArray2[n5] = new PdColor(n2, bl);
            ++n5;
        }
        return pdColorArray2;
    }
}

