/*
 * Decompiled with CFR 0.152.
 */
package jv.number;

import java.io.Serializable;
import jv.object.PsDebug;

public class PuComplex
implements Cloneable,
Serializable {
    public static final PuComplex ZERO = new PuComplex(0.0, 0.0);
    public static final PuComplex ONE = new PuComplex(1.0, 0.0);
    public static final PuComplex I = new PuComplex(0.0, 1.0);
    public static final PuComplex NEG_ONE = new PuComplex(-1.0, 0.0);
    public static final PuComplex NEG_I = new PuComplex(0.0, -1.0);
    public static final PuComplex PI_OVER_4 = new PuComplex(0.7071067811865476, 0.7071067811865476);
    public static final PuComplex PI3_OVER_4 = new PuComplex(-0.7071067811865476, 0.7071067811865476);
    public static final PuComplex PI5_OVER_4 = new PuComplex(-0.7071067811865476, -0.7071067811865476);
    public static final PuComplex PI7_OVER_4 = new PuComplex(0.7071067811865476, -0.7071067811865476);
    public double re = 0.0;
    public double im = 0.0;

    public static PuComplex log(PuComplex puComplex) {
        if (puComplex.abs() == 0.0) {
            PsDebug.warning("log(0) error");
            return new PuComplex(Double.NEGATIVE_INFINITY, 0.0);
        }
        return new PuComplex(Math.log(puComplex.abs()), puComplex.arg());
    }

    public PuComplex log() {
        if (this.abs() == 0.0) {
            PsDebug.warning("log(0) error");
            return this;
        }
        double d = Math.log(this.abs());
        double d2 = this.arg();
        this.re = d;
        this.im = d2;
        return this;
    }

    public static PuComplex add(PuComplex puComplex, PuComplex puComplex2) {
        PuComplex puComplex3 = new PuComplex();
        puComplex3.re = puComplex.re + puComplex2.re;
        puComplex3.im = puComplex.im + puComplex2.im;
        return puComplex3;
    }

    public PuComplex add(PuComplex puComplex) {
        this.re += puComplex.re;
        this.im += puComplex.im;
        return this;
    }

    public static PuComplex add(PuComplex puComplex, double d) {
        PuComplex puComplex2 = new PuComplex();
        puComplex2.re = puComplex.re + d;
        puComplex2.im = puComplex.im;
        return puComplex2;
    }

    public PuComplex add(double d) {
        this.re += d;
        return this;
    }

    public static PuComplex sqr(PuComplex puComplex) {
        PuComplex puComplex2 = new PuComplex();
        puComplex2.re = puComplex.re * puComplex.re - puComplex.im * puComplex.im;
        puComplex2.im = 2.0 * puComplex.re * puComplex.im;
        return puComplex2;
    }

    public PuComplex sqr() {
        double d = this.re;
        double d2 = this.im;
        this.re = d * d - d2 * d2;
        this.im = 2.0 * d * d2;
        return this;
    }

    public static double re(PuComplex puComplex) {
        return puComplex.re;
    }

    public static PuComplex exp(PuComplex puComplex) {
        PuComplex puComplex2 = new PuComplex();
        double d = Math.exp(puComplex.re);
        puComplex2.re = d * Math.cos(puComplex.im);
        puComplex2.im = d * Math.sin(puComplex.im);
        return puComplex2;
    }

    public PuComplex exp() {
        double d = Math.exp(this.re);
        double d2 = this.im;
        this.re = d * Math.cos(d2);
        this.im = d * Math.sin(d2);
        return this;
    }

    public static PuComplex sqrt(PuComplex puComplex) {
        return PuComplex.polarToRect(Math.sqrt(puComplex.abs()), puComplex.arg() / 2.0);
    }

    public static PuComplex polarToRect(double d, double d2) {
        PuComplex puComplex = new PuComplex();
        puComplex.re = d * Math.cos(d2);
        puComplex.im = d * Math.sin(d2);
        return puComplex;
    }

    public PuComplex sqrt() {
        double d = Math.sqrt(this.abs());
        double d2 = this.arg() / 2.0;
        this.re = d * Math.cos(d2);
        this.im = d * Math.sin(d2);
        return this;
    }

    public static PuComplex pow(PuComplex puComplex, PuComplex puComplex2) {
        if (puComplex.abs() == 0.0) {
            PsDebug.warning("PuComplex.pow(0,*) called.");
            return ZERO;
        }
        return PuComplex.exp(PuComplex.mult(puComplex2, PuComplex.log(puComplex)));
    }

    public static PuComplex pow(PuComplex puComplex, double d) {
        if (puComplex.abs() == 0.0) {
            PsDebug.warning("PuComplex.pow(0,*) called.");
            return ZERO;
        }
        return PuComplex.exp(PuComplex.mult(PuComplex.log(puComplex), d));
    }

    public static PuComplex cosh(PuComplex puComplex) {
        PuComplex puComplex2 = new PuComplex();
        puComplex2.re = Math.cos(puComplex.im) * (Math.exp(puComplex.re) + Math.exp(-puComplex.re)) / 2.0;
        puComplex2.im = Math.sin(puComplex.im) * (Math.exp(puComplex.re) - Math.exp(-puComplex.re)) / 2.0;
        return puComplex2;
    }

    public boolean equals(PuComplex puComplex, PuComplex puComplex2, double d) {
        return Math.abs(puComplex.re - puComplex2.re) < d && Math.abs(puComplex.im - puComplex2.im) < d;
    }

    public boolean equals(PuComplex puComplex, double d) {
        return Math.abs(this.re - puComplex.re) < d && Math.abs(this.im - puComplex.im) < d;
    }

    public static PuComplex mult(PuComplex puComplex, PuComplex puComplex2) {
        PuComplex puComplex3 = new PuComplex();
        puComplex3.re = puComplex.re * puComplex2.re - puComplex.im * puComplex2.im;
        puComplex3.im = puComplex.re * puComplex2.im + puComplex.im * puComplex2.re;
        return puComplex3;
    }

    public PuComplex mult(PuComplex puComplex) {
        double d = this.re;
        double d2 = this.im;
        this.re = d * puComplex.re - d2 * puComplex.im;
        this.im = d * puComplex.im + d2 * puComplex.re;
        return this;
    }

    public static PuComplex mult(PuComplex puComplex, double d) {
        PuComplex puComplex2 = new PuComplex();
        puComplex2.re = puComplex.re * d;
        puComplex2.im = puComplex.im * d;
        return puComplex2;
    }

    public PuComplex mult(double d) {
        this.re *= d;
        this.im *= d;
        return this;
    }

    public static PuComplex cube(PuComplex puComplex) {
        PuComplex puComplex2 = new PuComplex();
        puComplex2.re = puComplex.re * (puComplex.re * puComplex.re - 3.0 * puComplex.im * puComplex.im);
        puComplex2.im = puComplex.im * (3.0 * puComplex.re * puComplex.re - puComplex.im * puComplex.im);
        return puComplex2;
    }

    public PuComplex cube() {
        double d = this.re;
        double d2 = this.im;
        this.re = d * (d * d - 3.0 * d2 * d2);
        this.im = d2 * (3.0 * d * d - d2 * d2);
        return this;
    }

    public static PuComplex inv(PuComplex puComplex) {
        double d = puComplex.re * puComplex.re + puComplex.im * puComplex.im;
        if (d == 0.0) {
            PsDebug.warning("divide by zero");
            return new PuComplex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        PuComplex puComplex2 = new PuComplex();
        puComplex2.re = puComplex.re / d;
        puComplex2.im = -puComplex.im / d;
        return puComplex2;
    }

    public PuComplex inv() {
        double d = this.re * this.re + this.im * this.im;
        if (d == 0.0) {
            PsDebug.warning("divide by zero");
            this.re = Double.POSITIVE_INFINITY;
            this.im = Double.POSITIVE_INFINITY;
            return this;
        }
        this.re /= d;
        this.im /= -d;
        return this;
    }

    public double sqrAbs() {
        return this.re * this.re + this.im * this.im;
    }

    public static PuComplex div(PuComplex puComplex, PuComplex puComplex2) {
        PuComplex puComplex3 = new PuComplex();
        double d = puComplex2.re * puComplex2.re + puComplex2.im * puComplex2.im;
        if (d == 0.0) {
            PsDebug.warning("divide by zero");
            puComplex3.re = puComplex.re > 0.0 ? Double.POSITIVE_INFINITY : (puComplex.re < 0.0 ? Double.NEGATIVE_INFINITY : Double.NaN);
            puComplex3.im = puComplex.im > 0.0 ? Double.POSITIVE_INFINITY : (puComplex.im < 0.0 ? Double.NEGATIVE_INFINITY : Double.NaN);
            return puComplex3;
        }
        puComplex3.re = (puComplex.re * puComplex2.re + puComplex.im * puComplex2.im) / d;
        puComplex3.im = (puComplex.im * puComplex2.re - puComplex.re * puComplex2.im) / d;
        return puComplex3;
    }

    public PuComplex div(PuComplex puComplex) {
        double d = this.re;
        double d2 = this.im;
        double d3 = puComplex.re * puComplex.re + puComplex.im * puComplex.im;
        if (d3 == 0.0) {
            PsDebug.warning("divide by zero");
            this.re = this.re > 0.0 ? Double.POSITIVE_INFINITY : (this.re < 0.0 ? Double.NEGATIVE_INFINITY : Double.NaN);
            this.im = this.im > 0.0 ? Double.POSITIVE_INFINITY : (this.im < 0.0 ? Double.NEGATIVE_INFINITY : Double.NaN);
            return this;
        }
        this.re = (d * puComplex.re + d2 * puComplex.im) / d3;
        this.im = (d2 * puComplex.re - d * puComplex.im) / d3;
        return this;
    }

    public static PuComplex div(PuComplex puComplex, double d) {
        PuComplex puComplex2 = new PuComplex();
        if (d == 0.0) {
            PsDebug.warning("divide by zero");
            puComplex2.re = puComplex.re > 0.0 ? Double.POSITIVE_INFINITY : (puComplex.re < 0.0 ? Double.NEGATIVE_INFINITY : Double.NaN);
            puComplex2.im = puComplex.im > 0.0 ? Double.POSITIVE_INFINITY : (puComplex.im < 0.0 ? Double.NEGATIVE_INFINITY : Double.NaN);
            return puComplex2;
        }
        puComplex2.re = puComplex.re / d;
        puComplex2.im = puComplex.im / d;
        return puComplex2;
    }

    public PuComplex div(double d) {
        if (d == 0.0) {
            PsDebug.warning("divide by zero");
            this.re = this.re > 0.0 ? Double.POSITIVE_INFINITY : (this.re < 0.0 ? Double.NEGATIVE_INFINITY : Double.NaN);
            this.im = this.im > 0.0 ? Double.POSITIVE_INFINITY : (this.im < 0.0 ? Double.NEGATIVE_INFINITY : Double.NaN);
            return this;
        }
        this.re /= d;
        this.im /= d;
        return this;
    }

    public static PuComplex conj(PuComplex puComplex) {
        PuComplex puComplex2 = new PuComplex();
        puComplex2.re = puComplex.re;
        puComplex2.im = -puComplex.im;
        return puComplex2;
    }

    public PuComplex conj() {
        this.im *= -1.0;
        return this;
    }

    public static PuComplex cos(PuComplex puComplex) {
        PuComplex puComplex2 = new PuComplex();
        puComplex2.re = Math.cos(puComplex.re) * (Math.exp(puComplex.im) + Math.exp(-puComplex.im)) / 2.0;
        puComplex2.im = Math.sin(puComplex.re) * (Math.exp(puComplex.im) - Math.exp(-puComplex.im)) / 2.0;
        return puComplex2;
    }

    public PuComplex set(double d, double d2) {
        this.re = d;
        this.im = d2;
        return this;
    }

    public static PuComplex sin(PuComplex puComplex) {
        PuComplex puComplex2 = new PuComplex();
        puComplex2.re = Math.sin(puComplex.re) * (Math.exp(puComplex.im) + Math.exp(-puComplex.im)) / 2.0;
        puComplex2.im = Math.cos(puComplex.re) * (Math.exp(puComplex.im) - Math.exp(-puComplex.im)) / 2.0;
        return puComplex2;
    }

    public static PuComplex neg(PuComplex puComplex) {
        return new PuComplex(-puComplex.re, -puComplex.im);
    }

    public PuComplex() {
    }

    public PuComplex(double d) {
        this.re = d;
        this.im = 0.0;
    }

    public PuComplex(PuComplex puComplex) {
        this.re = puComplex.re;
        this.im = puComplex.im;
    }

    public PuComplex(double d, double d2) {
        this.re = d;
        this.im = d2;
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.re) || Double.isInfinite(this.im);
    }

    public static double im(PuComplex puComplex) {
        return puComplex.im;
    }

    public PuComplex neg() {
        this.re = -this.re;
        this.im = -this.im;
        return this;
    }

    public static double arg(PuComplex puComplex) {
        if (Math.abs(puComplex.re) > Math.abs(puComplex.im)) {
            if (puComplex.re > 0.0) {
                if (puComplex.im >= 0.0) {
                    return Math.atan(puComplex.im / puComplex.re);
                }
                return Math.atan(puComplex.im / puComplex.re) + Math.PI * 2;
            }
            return Math.atan(puComplex.im / puComplex.re) + Math.PI;
        }
        if (puComplex.im > 0.0) {
            return 1.5707963267948966 - Math.atan(puComplex.re / puComplex.im);
        }
        if (puComplex.im < 0.0) {
            return 4.71238898038469 - Math.atan(puComplex.re / puComplex.im);
        }
        return 0.0;
    }

    public double arg() {
        if (Math.abs(this.re) > Math.abs(this.im)) {
            if (this.re > 0.0) {
                if (this.im >= 0.0) {
                    return Math.atan(this.im / this.re);
                }
                return Math.atan(this.im / this.re) + Math.PI * 2;
            }
            return Math.atan(this.im / this.re) + Math.PI;
        }
        if (this.im > 0.0) {
            return 1.5707963267948966 - Math.atan(this.re / this.im);
        }
        if (this.im < 0.0) {
            return 4.71238898038469 - Math.atan(this.re / this.im);
        }
        return 0.0;
    }

    public static PuComplex sinh(PuComplex puComplex) {
        PuComplex puComplex2 = new PuComplex();
        puComplex2.re = Math.cos(puComplex.im) * (Math.exp(puComplex.re) - Math.exp(-puComplex.re)) / 2.0;
        puComplex2.im = Math.sin(puComplex.im) * (Math.exp(puComplex.re) + Math.exp(-puComplex.re)) / 2.0;
        return puComplex2;
    }

    public static PuComplex sub(PuComplex puComplex, PuComplex puComplex2) {
        PuComplex puComplex3 = new PuComplex();
        puComplex3.re = puComplex.re - puComplex2.re;
        puComplex3.im = puComplex.im - puComplex2.im;
        return puComplex3;
    }

    public PuComplex sub(PuComplex puComplex) {
        this.re -= puComplex.re;
        this.im -= puComplex.im;
        return this;
    }

    public static PuComplex sub(PuComplex puComplex, double d) {
        PuComplex puComplex2 = new PuComplex();
        puComplex2.re = puComplex.re - d;
        puComplex2.im = puComplex.im;
        return puComplex2;
    }

    public PuComplex sub(double d) {
        this.re -= d;
        return this;
    }

    public PuComplex copy(PuComplex puComplex) {
        this.re = puComplex.re;
        this.im = puComplex.im;
        return this;
    }

    public static double abs(PuComplex puComplex) {
        return puComplex.abs();
    }

    public double abs() {
        return Math.sqrt(this.re * this.re + this.im * this.im);
    }

    public boolean isNaN() {
        return Double.isNaN(this.re) || Double.isNaN(this.im);
    }
}

