/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import jv.number.PuString;
import jv.object.PsDebug;
import jv.vecmath.P_Vector;
import jv.vecmath.PdBary;
import jv.vecmath.PdVector;
import jv.vecmath.PuData;

public class PdBaryDir
extends P_Vector {
    public double[] m_data;

    public void multScalar(double d) {
        int n = 0;
        while (n < this.m_data.length) {
            int n2 = n++;
            this.m_data[n2] = this.m_data[n2] * d;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PdBaryDir *********\n");
        int n = this.getSize();
        stringBuffer.append("\t size = " + n + "\n");
        if (n > 0) {
            stringBuffer.append("\t m_data = (" + this.m_data[0]);
            int n2 = 1;
            while (n2 < n) {
                stringBuffer.append(", " + this.m_data[n2]);
                ++n2;
            }
            stringBuffer.append(")\n");
        } else {
            stringBuffer.append("\t m_data = null\n");
        }
        return stringBuffer.toString();
    }

    public PdBaryDir() {
        this.m_data = null;
    }

    public PdBaryDir(int n) {
        this.m_data = new double[n];
    }

    public PdBaryDir(double d, double d2) {
        this(2);
        this.m_data[0] = d;
        this.m_data[1] = d2;
    }

    public PdBaryDir(double d, double d2, double d3) {
        this(3);
        this.m_data[0] = d;
        this.m_data[1] = d2;
        this.m_data[2] = d3;
    }

    public PdBaryDir(double d, double d2, double d3, double d4) {
        this(4);
        this.m_data[0] = d;
        this.m_data[1] = d2;
        this.m_data[2] = d3;
        this.m_data[3] = d4;
    }

    public String toShortString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = this.getSize();
        if (this.m_data == null || n2 == 0) {
            stringBuffer.append("{ m_data = null} \t");
        } else {
            stringBuffer.append("{ " + String.valueOf(this.m_data[0]));
            n = 1;
            while (n < n2) {
                stringBuffer.append(", " + String.valueOf(this.m_data[n]));
                ++n;
            }
            stringBuffer.append("} \t");
        }
        stringBuffer.append("Attr = ");
        if (this.m_bits == null) {
            stringBuffer.append("{ } \t");
        } else {
            stringBuffer.append("{ " + PuString.intToString((int)this.m_bits[0], 4));
            n = 1;
            while (n < this.m_bits.length) {
                stringBuffer.append("\t " + PuString.intToString((int)this.m_bits[n], 4));
                ++n;
            }
            stringBuffer.append("} \t");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static void getVector(PdVector pdVector, PdBaryDir pdBaryDir, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4) {
        int n = pdVector2.getSize();
        double[] dArray = pdBaryDir.m_data;
        int n2 = 0;
        while (n2 < n) {
            pdVector.m_data[n2] = dArray[0] * pdVector2.m_data[n2] + dArray[1] * pdVector3.m_data[n2] + dArray[2] * pdVector4.m_data[n2];
            ++n2;
        }
    }

    public void validate() {
        double d = 0.0;
        int n = 0;
        while (n < this.m_data.length) {
            if (Math.abs(this.m_data[n]) < 1.0E-10) {
                this.m_data[n] = 0.0;
            }
            d += this.m_data[n];
            ++n;
        }
        d /= (double)this.m_data.length;
        n = 0;
        while (n < this.m_data.length) {
            int n2 = n++;
            this.m_data[n2] = this.m_data[n2] - d;
        }
    }

    public void sub(PdBary pdBary, PdBary pdBary2) {
        int n = 0;
        while (n < this.m_data.length) {
            this.m_data[n] = pdBary.m_data[n] - pdBary2.m_data[n];
            ++n;
        }
    }

    public static PdBaryDir copyNew(PdBaryDir pdBaryDir) {
        if (pdBaryDir == null) {
            PsDebug.warning("missing argument vector");
            return null;
        }
        if (pdBaryDir.m_data == null) {
            PsDebug.warning("missing data of argument vector.");
            return null;
        }
        PdBaryDir pdBaryDir2 = new PdBaryDir(pdBaryDir.getSize());
        pdBaryDir2.copy(pdBaryDir);
        return pdBaryDir2;
    }

    public void copy(PdBaryDir pdBaryDir) {
        if (pdBaryDir == null) {
            PsDebug.warning("missing argument");
            return;
        }
        super.copy(pdBaryDir);
        if (pdBaryDir.m_data == null) {
            this.m_data = null;
            return;
        }
        if (this.m_data.length != pdBaryDir.getSize()) {
            this.setSize(pdBaryDir.getSize());
        }
        int n = 0;
        while (n < this.m_data.length) {
            this.m_data[n] = pdBaryDir.m_data[n];
            ++n;
        }
    }

    public int getSize() {
        if (this.m_data == null) {
            return 0;
        }
        return this.m_data.length;
    }

    public int setSize(int n) {
        if (this.m_data == null || this.m_data.length != n) {
            this.m_data = PuData.realloc(this.m_data, n);
        }
        return n;
    }

    public Object clone() {
        return PdBaryDir.copyNew(this);
    }
}

