/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.number.PdVector_IP;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.viewer.PvCamera;
import jv.viewer.PvDisplay;

public class PvCamera_IP
extends PsPanel
implements ActionListener,
ItemListener {
    protected PvCamera m_camera;
    protected PvDisplay m_disp;
    protected CheckboxGroup m_gProjection;
    protected Checkbox m_rPerspective;
    protected Checkbox m_rTop;
    protected Checkbox m_rFront;
    protected Checkbox m_rRight;
    protected PsPanel m_pOrient;
    protected Panel m_pOrient2;
    protected Checkbox m_cOrient;
    protected Checkbox m_cLocal;
    protected CheckboxGroup m_gTransform;
    protected Checkbox m_rCameraTransform;
    protected Checkbox m_rModelTransform;
    protected Checkbox m_rAmbientTransform;
    protected int m_spaceMode = 3;
    protected Choice m_cAmbient;
    protected Label m_lAmbient;
    protected Choice m_cProj;
    protected Label m_lProj;
    protected PdVector m_viewDir;
    protected PdVector_IP m_pViewDir;
    protected PdVector m_interest;
    protected PdVector_IP m_pInterest;
    protected PuDouble m_dist;
    protected PsPanel m_pDist;
    protected Panel m_pClip;
    protected Checkbox m_cClip;
    protected Button m_bCenter;
    protected Button m_bFit;
    protected Button m_bReset;
    protected Button m_bResetAll;
    private static /* synthetic */ Class class$jv$viewer$PvCamera_IP;

    private void setAmbientSpace(int n) {
        int n2;
        if (n != this.m_spaceMode) {
            this.m_cAmbient.removeAll();
            this.m_cProj.removeAll();
            n2 = 0;
            while (n2 < PgGeometryIf.AMBIENT_SPACES[n].length) {
                this.m_cAmbient.add(PgGeometryIf.AMBIENT_SPACES[n][n2]);
                ++n2;
            }
            switch (n) {
                case 0: 
                case 1: 
                case 3: 
                case 6: 
                case 9: {
                    this.m_cAmbient.select(0);
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 10: {
                    this.m_cAmbient.select(1);
                    break;
                }
                case 5: 
                case 8: 
                case 11: {
                    this.m_cAmbient.select(2);
                }
            }
            this.m_spaceMode = n;
        }
        if (this.m_cProj.getItemCount() == 0) {
            n2 = 0;
            while (n2 < PgGeometryIf.AMBIENT_PROJECTIONS[n].length) {
                this.m_cProj.add(PgGeometryIf.AMBIENT_PROJECTIONS[n][n2]);
                ++n2;
            }
        }
        n2 = this.m_disp.getAmbientProjection();
        if (this.m_cProj.getSelectedIndex() != n2) {
            if (this.m_cProj.getItemCount() > n2 + 1) {
                this.m_cProj.select(n2);
                return;
            }
            PsDebug.warning("ambient projection not updated");
        }
    }

    public PvCamera_IP() {
        if (this.getClass() == (class$jv$viewer$PvCamera_IP != null ? class$jv$viewer$PvCamera_IP : (class$jv$viewer$PvCamera_IP = PvCamera_IP.class$("jv.viewer.PvCamera_IP")))) {
            this.init();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.m_camera == null) {
            return;
        }
        Object object = itemEvent.getSource();
        if (object == this.m_rPerspective) {
            this.m_disp.selectCamera(0);
            this.m_camera.update(null);
            return;
        }
        if (object == this.m_rTop) {
            this.m_disp.selectCamera(1);
            this.m_camera.update(null);
            return;
        }
        if (object == this.m_rFront) {
            this.m_disp.selectCamera(2);
            this.m_camera.update(null);
            return;
        }
        if (object == this.m_rRight) {
            this.m_disp.selectCamera(3);
            this.m_camera.update(null);
            return;
        }
        if (object == this.m_cOrient) {
            this.m_pViewDir.setEnabled(this.m_cOrient.getState());
            this.m_pInterest.setEnabled(this.m_cOrient.getState());
            this.m_dist.setEnabled(this.m_cOrient.getState());
            this.m_camera.m_roll.setEnabled(this.m_cOrient.getState());
            return;
        }
        if (object == this.m_cLocal) {
            this.m_disp.setEnabledLocalTransform(this.m_cLocal.getState());
            this.m_camera.update(this.m_camera);
            return;
        }
        if (object == this.m_rCameraTransform) {
            this.m_disp.setTransformationMode(0);
            this.m_camera.update(this.m_camera);
            return;
        }
        if (object == this.m_rModelTransform) {
            this.m_disp.setTransformationMode(1);
            this.m_camera.update(this.m_camera);
            return;
        }
        if (object == this.m_rAmbientTransform) {
            this.m_disp.setTransformationMode(2);
            this.m_camera.update(this.m_camera);
            return;
        }
        if (object == this.m_cAmbient) {
            int n = this.m_cAmbient.getSelectedIndex();
            int n2 = this.m_disp.getAmbientDim();
            switch (n) {
                case 0: {
                    if (this.m_spaceMode == 0 || this.m_spaceMode == 1 || this.m_spaceMode == 3 || this.m_spaceMode == 6 || this.m_spaceMode == 9) {
                        return;
                    }
                    if (n2 == 2) {
                        this.m_spaceMode = 1;
                        break;
                    }
                    if (n2 == 3) {
                        this.m_spaceMode = 3;
                        break;
                    }
                    if (n2 == 4) {
                        this.m_spaceMode = 6;
                        break;
                    }
                    if (n2 != 5) break;
                    this.m_spaceMode = 9;
                    break;
                }
                case 1: {
                    if (this.m_spaceMode == 2 || this.m_spaceMode == 4 || this.m_spaceMode == 7 || this.m_spaceMode == 10) {
                        return;
                    }
                    if (n2 == 2) {
                        this.m_spaceMode = 2;
                        break;
                    }
                    if (n2 == 3) {
                        this.m_spaceMode = 4;
                        break;
                    }
                    if (n2 == 4) {
                        this.m_spaceMode = 7;
                        break;
                    }
                    if (n2 != 5) break;
                    this.m_spaceMode = 10;
                    break;
                }
                case 2: {
                    if (this.m_spaceMode == 5 || this.m_spaceMode == 8 || this.m_spaceMode == 11) {
                        return;
                    }
                    if (n2 == 3) {
                        this.m_spaceMode = 5;
                        break;
                    }
                    if (n2 == 4) {
                        this.m_spaceMode = 8;
                        break;
                    }
                    if (n2 != 5) break;
                    this.m_spaceMode = 11;
                }
            }
            this.m_disp.setAmbientSpace(this.m_spaceMode);
            this.m_cProj.removeAll();
            int n3 = 0;
            while (n3 < PgGeometryIf.AMBIENT_PROJECTIONS[this.m_spaceMode].length) {
                this.m_cProj.add(PgGeometryIf.AMBIENT_PROJECTIONS[this.m_spaceMode][n3]);
                ++n3;
            }
            if (this.m_disp.getAmbientProjection() >= this.m_cProj.getItemCount()) {
                this.m_disp.setAmbientProjection(0);
            }
            this.m_cProj.select(this.m_disp.getAmbientProjection());
            this.m_disp.update(this.m_disp);
            return;
        }
        if (object == this.m_cProj) {
            this.m_disp.setAmbientProjection(this.m_cProj.getSelectedIndex());
            this.m_disp.update(this.m_disp);
            return;
        }
        if (object == this.m_cClip) {
            this.m_disp.setEnabledClip(this.m_cClip.getState());
            this.m_camera.m_nearClip.setEnabled(this.m_camera.m_bEnableClip);
            this.m_camera.m_farClip.setEnabled(this.m_camera.m_bEnableClip);
            PdVector[] pdVectorArray = this.m_camera.getBounds();
            if (this.m_cClip.getState() && pdVectorArray != null) {
                double d;
                double d2;
                if (pdVectorArray[1].m_data[2] < pdVectorArray[0].m_data[2]) {
                    d2 = pdVectorArray[1].m_data[2];
                    d = pdVectorArray[0].m_data[2];
                } else {
                    d2 = pdVectorArray[0].m_data[2];
                    d = pdVectorArray[1].m_data[2];
                }
                this.m_camera.m_nearClip.setBounds(d2 - (-d2 + d) / 2.0, d + (-d2 + d) / 2.0, 0.02, 1.0);
                this.m_camera.m_farClip.setBounds(d2 - (-d2 + d) / 2.0, d + (-d2 + d) / 2.0, 0.02, 1.0);
                this.m_camera.m_nearClip.setValue(d);
                this.m_camera.m_farClip.setValue(d2);
            }
            this.m_camera.update(null);
        }
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        if (psUpdateIf == null) {
            PsDebug.warning("missing camera");
            return;
        }
        super.setParent(psUpdateIf);
        this.m_camera = (PvCamera)psUpdateIf;
        this.m_disp = this.m_camera.m_display;
        this.m_pOrient2.removeAll();
        this.m_pOrient2.add(this.m_camera.m_roll.getInfoPanel());
        this.m_pOrient2.validate();
        this.m_pViewDir.setEnabled(this.m_cOrient.getState());
        this.m_pInterest.setEnabled(this.m_cOrient.getState());
        this.m_dist.setEnabled(this.m_cOrient.getState());
        this.m_camera.m_roll.setEnabled(this.m_cOrient.getState());
        this.m_pClip.removeAll();
        this.m_pClip.add(this.m_camera.m_nearClip.getInfoPanel());
        this.m_pClip.add(this.m_camera.m_farClip.getInfoPanel());
        this.m_pClip.validate();
        this.m_cClip.setState(this.m_camera.m_bEnableClip);
        this.m_camera.m_nearClip.setEnabled(this.m_camera.m_bEnableClip);
        this.m_camera.m_farClip.setEnabled(this.m_camera.m_bEnableClip);
        this.setTransformationMode(this.m_disp.getTransformationMode());
        switch (this.m_camera.getProjectionMode()) {
            default: {
                PsDebug.warning("unknown projection mode = " + this.m_camera.getProjectionMode());
            }
            case 0: {
                this.m_gProjection.setSelectedCheckbox(this.m_rPerspective);
                break;
            }
            case 1: {
                this.m_gProjection.setSelectedCheckbox(this.m_rTop);
                break;
            }
            case 2: {
                this.m_gProjection.setSelectedCheckbox(this.m_rFront);
                break;
            }
            case 3: {
                this.m_gProjection.setSelectedCheckbox(this.m_rRight);
            }
        }
        this.setTitle(PsConfig.getMessage("Camera") + ": " + this.m_disp.getName());
    }

    public boolean update(Object object) {
        if (this.m_camera == null) {
            PsDebug.warning("missing camera");
            return false;
        }
        if (object == this.m_camera) {
            this.m_disp = this.m_camera.m_display;
            this.m_viewDir.copy(this.m_camera.getViewDir());
            this.m_pViewDir.update(this.m_viewDir);
            this.m_interest.copy(this.m_camera.getInterest());
            this.m_pInterest.update(this.m_interest);
            this.m_dist.setValue(this.m_camera.getDist());
            this.m_camera.getRoll();
            if (this.m_cClip.getState() != this.m_camera.m_bEnableClip) {
                this.m_cClip.setState(this.m_camera.m_bEnableClip);
                this.m_camera.m_nearClip.setEnabled(this.m_camera.m_bEnableClip);
                this.m_camera.m_farClip.setEnabled(this.m_camera.m_bEnableClip);
            }
            if (this.m_cLocal.getState() != this.m_disp.isEnabledLocalTransform()) {
                this.m_cLocal.setState(this.m_disp.isEnabledLocalTransform());
            }
            this.setTransformationMode(this.m_disp.getTransformationMode());
            this.setAmbientSpace(this.m_disp.getAmbientSpace());
            return true;
        }
        if (object == this) {
            this.m_camera.setViewDir(this.m_pViewDir.getVector());
            this.m_camera.setInterest(this.m_pInterest.getVector());
            this.m_camera.setDist(this.m_dist.getValue());
            return this.m_camera.update(null);
        }
        if (object == this.m_pViewDir) {
            this.m_camera.setViewDir(this.m_pViewDir.getVector());
            return this.m_camera.update(null);
        }
        if (object == this.m_pInterest) {
            this.m_camera.setInterest(this.m_pInterest.getVector());
            return this.m_camera.update(null);
        }
        if (object == this.m_dist) {
            this.m_camera.setDist(this.m_dist.getValue());
            return this.m_camera.update(null);
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_camera == null) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.m_bCenter) {
            this.m_disp.center();
            this.m_camera.update(this.m_camera);
            return;
        }
        if (object == this.m_bFit) {
            this.m_disp.fit();
            this.m_camera.update(this.m_camera);
            return;
        }
        if (object == this.m_bReset) {
            PdMatrix pdMatrix;
            int n = this.m_disp.getTransformationMode();
            if (n == 0) {
                this.m_camera.init();
            } else if (n == 1) {
                PdMatrix pdMatrix2 = this.m_disp.getTransMatrix(8);
                if (pdMatrix2 != null) {
                    pdMatrix2.setIdentity();
                    pdMatrix2 = this.m_disp.getTransMatrix(256);
                    pdMatrix2.setIdentity();
                }
            } else if (n == 2 && (pdMatrix = this.m_disp.getTransMatrix(512)) != null) {
                pdMatrix.setIdentity();
                pdMatrix = this.m_disp.getTransMatrix(1024);
                pdMatrix.setIdentity();
            }
            this.m_camera.update(this.m_camera);
            return;
        }
        if (object == this.m_bResetAll) {
            this.m_disp.resetTransformModel();
            this.m_camera.init();
            this.m_disp.fit();
            this.m_camera.update(this.m_camera);
        }
    }

    private void setTransformationMode(int n) {
        Checkbox checkbox = this.m_gTransform.getSelectedCheckbox();
        Checkbox checkbox2 = null;
        switch (n) {
            default: {
                PsDebug.warning("unknown transformation mode = " + n);
            }
            case 0: {
                checkbox2 = this.m_rCameraTransform;
                break;
            }
            case 1: {
                checkbox2 = this.m_rModelTransform;
                break;
            }
            case 2: {
                checkbox2 = this.m_rAmbientTransform;
            }
        }
        if (checkbox != checkbox2) {
            this.m_gTransform.setSelectedCheckbox(checkbox2);
        }
        this.m_cLocal.setEnabled(n != 2);
        this.m_cAmbient.setEnabled(n == 2);
        this.m_lAmbient.setEnabled(n == 2);
        this.m_cProj.setEnabled(n == 2);
        this.m_lProj.setEnabled(n == 2);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        this.setBorderType(3);
        this.addTitle("");
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 2));
        this.add(panel);
        this.m_gProjection = new CheckboxGroup();
        this.m_rPerspective = new Checkbox(PsConfig.getMessage("rPerspective"), this.m_gProjection, true);
        this.m_rPerspective.addItemListener(this);
        panel.add(this.m_rPerspective);
        this.m_rTop = new Checkbox(PsConfig.getMessage("rTop"), this.m_gProjection, false);
        this.m_rTop.addItemListener(this);
        panel.add(this.m_rTop);
        this.m_rFront = new Checkbox(PsConfig.getMessage("rFront"), this.m_gProjection, false);
        this.m_rFront.addItemListener(this);
        panel.add(this.m_rFront);
        this.m_rRight = new Checkbox(PsConfig.getMessage("rRight"), this.m_gProjection, false);
        this.m_rRight.addItemListener(this);
        panel.add(this.m_rRight);
        this.addLine(1);
        this.m_pOrient = new PsPanel();
        this.m_pOrient.addTitle(PsConfig.getMessage("pPosition"));
        this.add(this.m_pOrient);
        this.m_cOrient = new Checkbox("Position");
        this.m_cOrient.setState(true);
        this.m_pViewDir = new PdVector_IP();
        this.m_pViewDir.setTitle(PsConfig.getMessage("pViewDir"));
        this.m_pViewDir.setParent(this);
        this.m_viewDir = new PdVector(3);
        this.m_pViewDir.setVector(this.m_viewDir);
        this.m_pOrient.add(this.m_pViewDir);
        this.m_pInterest = new PdVector_IP();
        this.m_pInterest.setTitle(PsConfig.getMessage("pInterest"));
        this.m_pInterest.setParent(this);
        this.m_interest = new PdVector(3);
        this.m_pInterest.setVector(this.m_interest);
        this.m_pOrient.add(this.m_pInterest);
        this.m_dist = new PuDouble(PsConfig.getMessage("dist"), this);
        this.m_dist.setBounds(0.001, 100.0, 1.0, 10.0);
        this.m_dist.setValue(10.0);
        this.m_pDist = this.m_dist.getInfoPanel();
        this.m_pOrient.add(this.m_pDist);
        this.m_pOrient2 = new PsPanel();
        this.m_pOrient2.setLayout(new GridLayout(1, 1));
        this.add(this.m_pOrient2);
        this.addLine(1);
        PsPanel psPanel = new PsPanel();
        this.add(psPanel);
        PsPanel psPanel2 = new PsPanel();
        psPanel2.setLayout(new GridLayout(1, 2));
        psPanel2.addTitle(PsConfig.getMessage("rTransform"));
        this.m_cLocal = new Checkbox(PsConfig.getMessage("rCameraLocal"), true);
        this.m_cLocal.addItemListener(this);
        psPanel2.add(this.m_cLocal);
        psPanel.add(psPanel2);
        PsPanel psPanel3 = new PsPanel();
        psPanel3.setLayout(new GridLayout(1, 3));
        psPanel.add(psPanel3);
        this.m_gTransform = new CheckboxGroup();
        this.m_rCameraTransform = new Checkbox(PsConfig.getMessage("rCameraTransform"), this.m_gTransform, true);
        this.m_rCameraTransform.addItemListener(this);
        psPanel3.add(this.m_rCameraTransform);
        this.m_rModelTransform = new Checkbox(PsConfig.getMessage("rModelTransform"), this.m_gTransform, false);
        this.m_rModelTransform.addItemListener(this);
        psPanel3.add(this.m_rModelTransform);
        this.m_rAmbientTransform = new Checkbox(PsConfig.getMessage("rAmbientTransform"), this.m_gTransform, false);
        this.m_rAmbientTransform.addItemListener(this);
        psPanel3.add(this.m_rAmbientTransform);
        psPanel2 = new PsPanel();
        psPanel2.setLayout(new GridLayout(2, 2));
        this.add(psPanel2);
        this.m_lAmbient = new Label(PsConfig.getMessage("cAmbient"));
        psPanel2.add(this.m_lAmbient);
        this.m_cAmbient = new Choice();
        this.m_cAmbient.addItemListener(this);
        int n = 0;
        while (n < PgGeometryIf.AMBIENT_SPACES[this.m_spaceMode].length) {
            this.m_cAmbient.add(PgGeometryIf.AMBIENT_SPACES[this.m_spaceMode][n]);
            ++n;
        }
        psPanel2.add(this.m_cAmbient);
        this.m_lProj = new Label(PsConfig.getMessage("cProj"));
        psPanel2.add(this.m_lProj);
        this.m_cProj = new Choice();
        this.m_cProj.addItemListener(this);
        psPanel2.add(this.m_cProj);
        this.addLine(1);
        this.m_cClip = new Checkbox(PsConfig.getMessage("cClip"));
        this.m_cClip.addItemListener(this);
        this.m_cClip.setFont(PsConfig.getFont(3));
        this.m_cClip.setState(false);
        this.add(this.m_cClip);
        this.m_pClip = new PsPanel();
        this.m_pClip.setLayout(new GridLayout(2, 1));
        this.add(this.m_pClip);
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout(1));
        this.add(panel2);
        this.m_bCenter = new Button(PsConfig.getMessage("bCenter"));
        this.m_bCenter.addActionListener(this);
        panel2.add(this.m_bCenter);
        this.m_bFit = new Button(PsConfig.getMessage("bFit"));
        this.m_bFit.addActionListener(this);
        panel2.add(this.m_bFit);
        this.m_bReset = new Button(PsConfig.getMessage("bReset"));
        this.m_bReset.addActionListener(this);
        panel2.add(this.m_bReset);
        this.m_bResetAll = new Button(PsConfig.getMessage("bResetAll"));
        this.m_bResetAll.addActionListener(this);
        panel2.add(this.m_bResetAll);
    }
}

