/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.ode;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.project.PjProject_IP;
import vgp.tutor.ode.PjExprOde;

public class PjExprOde_IP
extends PjProject_IP
implements ActionListener,
ItemListener {
    protected PjExprOde m_pjExpr;
    protected int m_order;
    protected TextField m_tOrder;
    protected Label m_lEquation;
    protected TextField m_tEquation;
    protected int m_textLength = 10;
    protected Checkbox m_cShowInitialPoint;
    protected Checkbox m_cShowVectorField;
    protected Button m_bReset;
    protected Panel m_pBounds;
    private static /* synthetic */ Class class$vgp$tutor$ode$PjExprOde_IP;

    public PjExprOde_IP() {
        if (this.getClass() == (class$vgp$tutor$ode$PjExprOde_IP != null ? class$vgp$tutor$ode$PjExprOde_IP : (class$vgp$tutor$ode$PjExprOde_IP = PjExprOde_IP.class$("vgp.tutor.ode.PjExprOde_IP")))) {
            this.init();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.m_project == null) {
            return;
        }
        Object object = itemEvent.getSource();
        if (object == this.m_cShowVectorField) {
            this.m_pjExpr.showVectorField(this.m_cShowVectorField.getState());
            return;
        }
        if (object == this.m_cShowInitialPoint) {
            this.m_pjExpr.showInitialPoint(this.m_cShowInitialPoint.getState());
            return;
        }
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.m_pjExpr = (PjExprOde)psUpdateIf;
        this.m_pBounds.add((Component)this.m_pjExpr.m_h.getInfoPanel());
        this.m_pBounds.add((Component)this.m_pjExpr.m_length.getInfoPanel());
        this.m_pBounds.add((Component)this.m_pjExpr.m_xStart.getInfoPanel());
        this.m_pBounds.add((Component)this.m_pjExpr.m_pYStart);
    }

    private boolean setOrder(int n) {
        if (n < 1 || n > 4) {
            ((TextComponent)this.m_tOrder).setText(String.valueOf(this.m_order));
            return false;
        }
        this.m_order = n;
        ((TextComponent)this.m_tOrder).setText(String.valueOf(this.m_order));
        switch (n) {
            case 1: {
                this.m_lEquation.setText("y'(x) = f(x,y) = ");
                break;
            }
            case 2: {
                this.m_lEquation.setText("y''(x) = f(x,y,dy) = ");
                break;
            }
            case 3: {
                this.m_lEquation.setText("y'''(x) = f(x,y,dy,d2y) = ");
                break;
            }
            case 4: {
                this.m_lEquation.setText("y''''(x) = f(x,y,dy,d2y,d3y) = ");
            }
        }
        return true;
    }

    public boolean update(Object object) {
        if (this.m_pjExpr == object) {
            this.setTitle("Solving ODE: " + this.m_pjExpr.getName());
            ((TextComponent)this.m_tEquation).setText(this.m_pjExpr.m_equation);
            if (this.m_order != this.m_pjExpr.m_order) {
                this.setOrder(this.m_pjExpr.m_order);
            }
            if (this.m_cShowVectorField.isEnabled() != (this.m_order == 1)) {
                this.m_cShowVectorField.setEnabled(this.m_order == 1);
            }
            if (this.m_cShowInitialPoint.getState() != this.m_pjExpr.m_bShowInitialPoint) {
                this.m_cShowInitialPoint.setState(this.m_pjExpr.m_bShowInitialPoint);
            }
            if (this.m_cShowVectorField.getState() != this.m_pjExpr.m_bShowVectorField) {
                this.m_cShowVectorField.setState(this.m_pjExpr.m_bShowVectorField);
            }
            return true;
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_pjExpr == null) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.m_bReset) {
            this.m_pjExpr.init();
            this.update((Object)this.m_pjExpr);
            this.m_pjExpr.solve();
            return;
        }
        if (object == this.m_tEquation) {
            this.m_pjExpr.setEquation(this.m_tEquation.getText());
            this.m_pjExpr.solve();
            return;
        }
        if (object == this.m_tOrder) {
            try {
                int n = Integer.parseInt(this.m_tOrder.getText());
                if (!this.setOrder(n)) {
                    return;
                }
                this.m_pjExpr.setOrder(n);
                this.update((Object)this.m_pjExpr);
                this.m_pjExpr.solve();
                return;
            }
            catch (NumberFormatException numberFormatException) {
                PsDebug.warning((String)("wrong format = " + this.m_tOrder.getText()));
            }
        }
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        this.addTitle("");
        this.addLine(1);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 2));
        ((Container)((Object)this)).add(panel);
        this.m_lEquation = new Label("y'(x) = ");
        panel.add(this.m_lEquation);
        this.m_tEquation = new TextField(this.m_textLength);
        this.m_tEquation.addActionListener(this);
        panel.add(this.m_tEquation);
        panel.add(new Label("Order "));
        this.m_tOrder = new TextField(this.m_textLength);
        this.m_tOrder.addActionListener(this);
        panel.add(this.m_tOrder);
        this.addLine(1);
        this.m_pBounds = new Panel();
        this.m_pBounds.setLayout(new GridLayout(4, 1));
        ((Container)((Object)this)).add(this.m_pBounds);
        this.addLine(1);
        PsPanel psPanel = new PsPanel();
        psPanel.addTitle("Show");
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, 2));
        this.m_cShowInitialPoint = new Checkbox("Initial Point");
        this.m_cShowInitialPoint.addItemListener(this);
        panel2.add(this.m_cShowInitialPoint);
        this.m_cShowVectorField = new Checkbox("Vectors (if order=1)");
        this.m_cShowVectorField.addItemListener(this);
        panel2.add(this.m_cShowVectorField);
        psPanel.add(panel2);
        ((Container)((Object)this)).add((Component)psPanel);
        panel2 = new Panel();
        panel2.setLayout(new FlowLayout(1));
        ((Container)((Object)this)).add(panel2);
        this.m_bReset = new Button("Reset");
        this.m_bReset.addActionListener(this);
        panel2.add(this.m_bReset);
    }
}

