/*
 * Decompiled with CFR 0.152.
 */
package dev.app.ansys;

import dev.app.tetraset.PgTetraSet;
import dev.app.tetraset.PwWorkshop;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.loader.PjImportModel;
import jv.object.PsConfig;
import jv.object.PsMainFrame;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.viewer.PvViewer;

public class PaAnsys
extends Applet
implements Runnable {
    protected int[] m_frameSize = new int[]{420, 5, 640, 550};
    public Frame m_frame = null;
    protected PvViewer m_viewer;
    private String m_drawString = "Initializing ...";
    protected String[][] m_parm = new String[][]{{"Console", "String", "Hide", "Show/Hide VGP-console for debugging"}, {"Control", "String", "Hide", "Show/Hide control panel"}, {"Frame", "String", "Hide", "Show/Hide frame around applet"}, {"Panel", "String", "Project", "Name of initial panel if control panel is showing"}};

    public void stop() {
        if (this.m_viewer != null) {
            this.m_viewer.stop();
        }
    }

    public void startFromThread() {
        if (this.m_viewer != null) {
            this.m_viewer.start();
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.blue);
        graphics.drawString(PsConfig.getProgram() + " v." + PsConfig.getVersion(), 20, 40);
        graphics.drawString(this.m_drawString, 20, 60);
    }

    public String[][] getParameterInfo() {
        return this.m_parm;
    }

    public void destroy() {
        if (this.m_viewer != null) {
            this.m_viewer.destroy();
        }
    }

    private void drawMessage(String string) {
        this.m_drawString = string;
        this.repaint();
    }

    public static void main(String[] stringArray) {
        PaAnsys paAnsys = new PaAnsys();
        PsMainFrame psMainFrame = new PsMainFrame((Component)paAnsys, stringArray);
        paAnsys.m_frame = psMainFrame;
        paAnsys.init();
        psMainFrame.setBounds(new Rectangle(420, 5, 640, 550));
        psMainFrame.setVisible(true);
    }

    public String getAppletInfo() {
        return "Name: " + this.getClass().getName() + "\r\n" + "Author: " + PsConfig.getAuthors() + "\r\n" + "Version: " + PsConfig.getVersion() + "\r\n" + "Applet shows simple properties of the 3d-viewer used in JavaView" + "\r\n";
    }

    public void run() {
        int n;
        Object object;
        this.drawMessage("Loading display ...");
        this.m_viewer = new PvViewer((Applet)this, this.m_frame);
        this.drawMessage("Loading geometry ...");
        PgTetraSet pgTetraSet = new PgTetraSet(3);
        PvDisplayIf pvDisplayIf = this.m_viewer.getDisplay();
        PjImportModel pjImportModel = new PjImportModel();
        String string = this.m_viewer.getParameter("model");
        if (string == null) {
            string = "dev/app/ansys/mesh";
        }
        pjImportModel.load(PsConfig.getCodeBase() + string + ".ans");
        pgTetraSet = (PgTetraSet)pjImportModel.getGeometry();
        pjImportModel = new PjImportModel();
        pjImportModel.load(PsConfig.getCodeBase() + string + "_data.ans");
        PgPointSet pgPointSet = (PgPointSet)pjImportModel.getGeometry();
        int n2 = pgPointSet.getNumVertices();
        int n3 = pgPointSet.getDimOfVertices();
        float[][] fArray = new float[n3][n2];
        int n4 = 0;
        while (n4 < n2) {
            object = pgPointSet.getVertex(n4);
            n = 0;
            while (n < n3) {
                fArray[n][n4] = new Float(object.getEntry(n)).floatValue();
                ++n;
            }
            ++n4;
        }
        PgElementSet[] pgElementSetArray = new PgElementSet[n3];
        n = 0;
        while (n < n3) {
            object = PwWorkshop.colorVertices(pgTetraSet, fArray[n]);
            pgElementSetArray[n] = pgTetraSet.getSurface();
            pgElementSetArray[n].removeUnusedVertices();
            pgElementSetArray[n].makeNeighbour();
            pgElementSetArray[n].setName("Set " + n + " (" + (float)object[0] + ".." + (float)object[1] + ")");
            PwWorkshop.makeElementColorsFromVertexColors(pgElementSetArray[n]);
            pgElementSetArray[n].showVertices(true);
            pgElementSetArray[n].showVertexColors(true);
            pgElementSetArray[n].showElements(true);
            pgElementSetArray[n].showElementColors(true);
            pgElementSetArray[n].showEdges(false);
            pgElementSetArray[n].setVisible(false);
            pvDisplayIf.addGeometry((PgGeometryIf)pgElementSetArray[n]);
            ++n;
        }
        pgElementSetArray[0].setVisible(true);
        pvDisplayIf.setPaintTag(2048, true);
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)this.m_viewer.getDisplay());
        this.validate();
        this.startFromThread();
    }

    public void init() {
        this.drawMessage("Loading viewer ...");
        Thread thread = new Thread((Runnable)this, "JavaView: inititialize applet");
        thread.setPriority(5);
        thread.start();
    }
}

