/*
 * Decompiled with CFR 0.152.
 */
package dev.app.archive;

import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import jv.geom.PgElementSet;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsMainFrame;
import jv.objectGui.PsImage;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.rsrc.JarResources;
import jv.viewer.PvViewer;

public class PaArchive
extends Applet
implements Runnable {
    public Frame m_frame = null;
    protected PvViewer m_viewer;
    private String m_drawString = "Initializing ...";

    public void stop() {
        if (this.m_viewer != null) {
            this.m_viewer.stop();
        }
    }

    public void startFromThread() {
        if (this.m_viewer != null) {
            this.m_viewer.start();
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.blue);
        graphics.drawString(PsConfig.getProgram() + " v." + PsConfig.getVersion(), 20, 40);
        graphics.drawString(this.m_drawString, 20, 60);
    }

    public void destroy() {
        if (this.m_viewer != null) {
            this.m_viewer.destroy();
        }
    }

    private void drawMessage(String string) {
        this.m_drawString = string;
        this.repaint();
    }

    public static void main(String[] stringArray) {
        PaArchive paArchive = new PaArchive();
        PsMainFrame psMainFrame = new PsMainFrame((Component)paArchive, stringArray);
        paArchive.m_frame = psMainFrame;
        paArchive.init();
        psMainFrame.setBounds(new Rectangle(420, 5, 640, 550));
        psMainFrame.setVisible(true);
    }

    public String getAppletInfo() {
        return "Name: " + this.getClass().getName() + "\r\n" + "Author: " + "Konrad Polthier" + "\r\n" + "Version: " + "1.10" + "\r\n" + "Applet shows how to access image and audio files in jar/cab archives" + "\r\n";
    }

    public void run() {
        AudioClip audioClip;
        PvDisplayIf pvDisplayIf = this.m_viewer.getDisplay();
        this.drawMessage("Loading image ...");
        Image image = null;
        image = PsImage.getImage((String)"dev/app/images/bluewat.jpg");
        PsImage psImage = new PsImage(image, "Blue Water");
        if (!psImage.loadImage()) {
            PsDebug.message((String)"Second attempt: reading Jar file directly ...");
            try {
                String string = "jars/javaview.jar";
                audioClip = PsConfig.isApplication() ? new JarResources(string) : new JarResources(PsConfig.getCodeBase() + string, false);
                image = Toolkit.getDefaultToolkit().createImage(audioClip.getResource("dev/app/images/bluewat.jpg"));
                psImage = new PsImage(image, "Blue Water");
                if (!psImage.loadImage()) {
                    PsDebug.message((String)"Second attempt: failed.");
                    image = null;
                }
            }
            catch (Exception exception) {
                image = null;
            }
        }
        if (image != null) {
            PsDebug.message((String)("width  = " + image.getWidth(null)));
            PsDebug.message((String)("height = " + image.getHeight(null)));
            PsDebug.message((String)("source = " + image.getSource()));
            pvDisplayIf.setBackgroundImage(image);
        }
        if (!PsConfig.isApplication() && (audioClip = this.getAudioClip(this.getCodeBase(), "rsrc/oww.au")) != null) {
            audioClip.play();
        }
        this.drawMessage("Loading geometry ...");
        audioClip = new PgElementSet(3);
        audioClip.setName("Torus");
        audioClip.computeTorus(10, 10, 2.0, 1.0);
        pvDisplayIf.addGeometry((PgGeometryIf)audioClip);
        pvDisplayIf.selectGeometry((PgGeometryIf)audioClip);
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)pvDisplayIf);
        this.validate();
        this.startFromThread();
    }

    public void init() {
        this.drawMessage("Loading display ...");
        this.m_viewer = new PvViewer((Applet)this, this.m_frame);
        this.m_viewer.showDialog(25);
        Thread thread = new Thread((Runnable)this, "JavaView: inititialize applet");
        thread.setPriority(5);
        thread.start();
        PsDebug.warning((String)"Here we are");
    }
}

