/*
 * Decompiled with CFR 0.152.
 */
package dev.app.knotBook;

import dev.app.knotBook.BooknotProject_IP;
import dev.app.knotBook.BooknotView;
import dev.app.knotBook.DecoderGC;
import dev.app.knotBook.PgKnotBook;
import dev.app.knotBook.PlaneParser;
import dev.app.knotBook.PsKbxLoader;
import dev.app.knotBook.Rotate;
import dev.app.knotBook.ThreePageLink;
import java.awt.Component;
import java.awt.FileDialog;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import jv.object.PsConfig;
import jv.object.PsObject;
import jv.object.PsUtil;
import jv.project.PjProject;

public class BooknotProject
extends PjProject {
    private PgKnotBook m_knotbook;
    private BooknotView m_bkview;
    private boolean is3D = true;
    private boolean is2D = false;
    private String fileDir;
    private String currentKnotFileName;
    private String defaultKnotFileName;
    private String s_fileName = "";

    public String getCurrentKnotFileName() {
        return this.currentKnotFileName;
    }

    public String[] getKnotFileNames() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.getList(this.fileDir + "/_modelList.txts"));
        if (stringTokenizer == null) {
            return null;
        }
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        return stringArray;
    }

    public void doRotate() {
        if (this.m_knotbook == null) {
            this.setProcessStatusLabel("no Knot present");
            return;
        }
        Rotate rotate = new Rotate();
        this.setProcessStatusLabel("Vertex Permutation in process");
        this.m_knotbook = rotate.move(this.m_knotbook);
        this.setProcessStatusLabel("Vertex Permutation completed");
        this.setNumPointsLabel(this.m_knotbook.getNumVertices());
        this.setNumComponentsLabel(this.m_knotbook.getNumComponents());
    }

    public String getGCfromString(String string) {
        this.setProcessStatusLabel("Generating GC in process");
        PlaneParser planeParser = new PlaneParser(string);
        if (!planeParser.getDataCorrectness()) {
            this.setProcessStatusLabel("Generating GC failed, no process");
            return "";
        }
        String string2 = planeParser.getGC();
        if (string2 == null || string2 == "") {
            this.setProcessStatusLabel("Generating GC failed, no process");
            return "";
        }
        return string2;
    }

    public String getDefaultKnotFileName() {
        return this.defaultKnotFileName;
    }

    protected String getList(String string) {
        String string2 = "";
        try {
            BufferedReader bufferedReader = PsUtil.open((String)string);
            if (bufferedReader == null) {
                return null;
            }
            String string3 = "";
            while (string3 != null) {
                string3 = bufferedReader.readLine();
                string2 = string2 + string3 + "\n";
            }
        }
        catch (Exception exception) {}
        return string2;
    }

    public boolean update(Object object) {
        if (object == ((PsObject)this).m_infoPanel) {
            if (this.is2D) {
                this.setProcessStatusLabel("Drawing the Knot");
                this.m_bkview.compute2DView(this.m_knotbook);
                this.setProcessStatusLabel("no process");
            } else if (this.is3D) {
                this.setProcessStatusLabel("Drawing the Knot");
                this.m_bkview.compute3DView(this.m_knotbook);
                this.setProcessStatusLabel("no process");
            }
        }
        return super.update(object);
    }

    public void start() {
        this.m_bkview.setCameraMode(this.m_bkview.i3D);
        if (this.m_knotbook == null) {
            this.setProcessStatusLabel("Knot not found");
            this.setNumPointsLabel(-1);
            this.setNumComponentsLabel(-1);
        } else {
            this.setProcessStatusLabel("no process.");
            this.setNumPointsLabel(this.m_knotbook.getNumVertices());
            this.setNumComponentsLabel(this.m_knotbook.getNumComponents());
        }
        super.start();
    }

    public void setDownPage(int n) {
        this.m_bkview.setDownPage(n);
    }

    public String export3D(String string) {
        String string2 = (this.fileDir.substring(PsConfig.getCodeBase().length()) + "poly3D/").replace('/', '\\');
        return this.export(string, string2, "New_Knot.txt");
    }

    public String export(String string, String string2, String string3) {
        FileDialog fileDialog = new FileDialog(this.getViewer().getFrame(), "", 1);
        if (!string2.equals("")) {
            fileDialog.setDirectory(string2);
        }
        if (!string3.equals("")) {
            fileDialog.setFile(string3);
        }
        ((Component)fileDialog).setVisible(true);
        String string4 = fileDialog.getDirectory() + fileDialog.getFile();
        if (fileDialog.getFile() == null) {
            return null;
        }
        try {
            FileWriter fileWriter = new FileWriter(string4);
            fileWriter.write(string, 0, string.length());
            fileWriter.close();
        }
        catch (IOException iOException) {
            this.setProcessStatusLabel("Can't write the file " + string4);
            return null;
        }
        return fileDialog.getFile();
    }

    public void reset() {
        if (this.m_knotbook == null) {
            this.setProcessStatusLabel("Knot not found");
            this.setNumPointsLabel(-1);
            this.setNumComponentsLabel(-1);
            return;
        }
        this.setProcessStatusLabel("no process.");
        this.setNumPointsLabel(this.m_knotbook.getNumVertices());
        this.setNumComponentsLabel(this.m_knotbook.getNumComponents());
    }

    public boolean readAndSet3D(String string) {
        return this.readAndSet3D(this.fileDir + "poly3D/", string);
    }

    public boolean readAndSet3D(String string, String string2) {
        String string3 = this.readFile(string, string2);
        if (string3 == null || string3.equals("")) {
            return false;
        }
        String string4 = this.getGCfromString(string3);
        if (string4 == null || string4.equals("")) {
            return false;
        }
        if (this.decode(string4, string2)) {
            this.currentKnotFileName = string + string2;
            this.reset();
            return true;
        }
        return false;
    }

    public String exportGk(String string) {
        String string2 = (this.fileDir.substring(PsConfig.getCodeBase().length()) + "gc/").replace('/', '\\');
        return this.export(string, string2, "New_Knot.gc");
    }

    public BooknotProject(String string, String string2) {
        super("BooknotProject");
        this.fileDir = string;
        this.defaultKnotFileName = string2;
        this.readAndSetJKB(string2);
        this.m_bkview = new BooknotView(this);
        this.init();
    }

    protected int parseKnotPlotSite() {
        int n = 0;
        this.setProcessStatusLabel("process");
        int n2 = 2;
        do {
            String string;
            String string2;
            if ((string2 = this.parseKnotPlotPage(string = "http://www.pims.math.ca/knotplot/KnotServer/ms-coord/" + n2 + ".html")).equals("")) continue;
            ++n;
            if (this.s_fileName.equals("")) continue;
            try {
                string2 = this.getGCfromString(string2);
                FileWriter fileWriter = new FileWriter(this.fileDir.replace('/', '\\') + this.s_fileName + ".gc");
                fileWriter.write(string2, 0, string2.length());
                fileWriter.close();
            }
            catch (Exception exception) {
                --n;
                System.out.println("http://www.pims.math.ca/knotplot/KnotServer/ms-coord/" + n2 + ".html  failed");
            }
            this.setProcessStatusLabel("Complete " + n + " knots");
        } while (++n2 < 385);
        this.setProcessStatusLabel("Complete all. " + n + " Knots upload.");
        return n;
    }

    public void set2D() {
        this.is2D = true;
        this.is3D = false;
        this.m_bkview.setCameraMode(this.m_bkview.i2D);
    }

    public String readFile(String string) {
        if (string.endsWith(".gc")) {
            return this.readFile(this.fileDir + "gc/", string);
        }
        if (string.endsWith(".txt")) {
            return this.readFile(this.fileDir + "poly3D/", string);
        }
        return null;
    }

    public String getFileDir() {
        return this.fileDir;
    }

    public String readFile(String string, String string2) {
        String string3 = string + string2;
        System.out.println(string3);
        if (string3 == null || string3.equals("")) {
            return null;
        }
        LineNumberReader lineNumberReader = new LineNumberReader(PsUtil.open((String)string3));
        if (lineNumberReader == null) {
            return null;
        }
        String string4 = "";
        String string5 = "";
        while (string5 != null) {
            try {
                string5 = lineNumberReader.readLine();
                string4 = string5 != null ? string4 + string5 + "\n" : string4;
            }
            catch (IOException iOException) {
                this.setProcessStatusLabel("Can't read the file " + string3);
                return null;
            }
        }
        return string4;
    }

    public boolean readAndSetGC(String string) {
        return this.readAndSetGC(this.fileDir + "gc/", string);
    }

    public boolean readAndSetGC(String string, String string2) {
        String string3 = this.readFile(string, string2);
        if (string3 == null || string3.equals("")) {
            return false;
        }
        if (this.decode(string3, string2)) {
            this.currentKnotFileName = string + string2;
            this.reset();
            return true;
        }
        return false;
    }

    public void setUpPage(int n) {
        this.m_bkview.setUpPage(n);
    }

    private String parseKnotPlotPage(String string) {
        try {
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            byte[] byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
            inputStream.close();
            String string2 = new String(byArray).toLowerCase();
            int n = string2.indexOf("<title>");
            int n2 = string2.indexOf("</title>") - 1;
            n = string2.indexOf("for", n) + 4;
            this.s_fileName = string2.substring(n, n2);
            String string3 = this.fileDir.replace('/', '\\') + "knot-" + this.s_fileName + ".txt";
            string2 = string2.substring(n2 + 7);
            n = string2.indexOf("<pre>") + 6;
            n2 = string2.indexOf("</pre>");
            string2 = string2.substring(n, n2);
            FileWriter fileWriter = new FileWriter(string3);
            fileWriter.write(string2, 0, string2.length());
            fileWriter.close();
            return string2;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return "";
        }
    }

    public void set3D() {
        this.is2D = false;
        this.is3D = true;
        this.m_bkview.setCameraMode(this.m_bkview.i3D);
    }

    public boolean decode(String string, String string2) {
        this.setProcessStatusLabel("Decoding Knot in process");
        DecoderGC decoderGC = new DecoderGC();
        PgKnotBook pgKnotBook = decoderGC.decode(string, string2);
        if (pgKnotBook != null) {
            this.m_knotbook = pgKnotBook;
            this.setProcessStatusLabel("Decoding Knot completed");
            this.setNumPointsLabel(this.m_knotbook.getNumVertices());
            this.setNumComponentsLabel(this.m_knotbook.getNumComponents());
            return true;
        }
        this.setProcessStatusLabel("Decoding Knot failed: " + decoderGC.getStatus());
        return false;
    }

    public void simplify() {
        if (this.m_knotbook == null) {
            this.setProcessStatusLabel("no Knot present");
            return;
        }
        this.setProcessStatusLabel("kNotSimplyFier running...");
        ThreePageLink threePageLink = new ThreePageLink();
        threePageLink.kb_to_3P(this.m_knotbook);
        threePageLink.kNotSimplyFire();
        if (threePageLink.back_to_kb() == null) {
            this.setProcessStatusLabel("Simplifier failed");
            return;
        }
        this.m_knotbook = threePageLink.back_to_kb();
        this.setProcessStatusLabel("Simplifying completed");
        this.setNumPointsLabel(this.m_knotbook.getNumVertices());
        this.setNumComponentsLabel(this.m_knotbook.getNumComponents());
    }

    public void setAnother() {
        this.is2D = false;
        this.is3D = false;
    }

    public void setArcDisc(int n) {
        this.m_bkview.setArcDisc(n);
    }

    public void setThick(double d) {
        this.m_bkview.setDThickness(d);
    }

    public String exportKbx() {
        String string = PsKbxLoader.write(this.m_knotbook);
        String string2 = (this.fileDir.substring(PsConfig.getCodeBase().length()) + "jkb/").replace('/', '\\');
        return this.export(string, string2, "New_Knot.jkb");
    }

    public void init() {
        super.init();
        this.m_bkview.compute3DView(this.m_knotbook);
    }

    public BooknotView getBKView() {
        return this.m_bkview;
    }

    public boolean readAndSetJKB(String string) {
        return this.readAndSetJKB(this.fileDir + "jkb/", string);
    }

    public boolean readAndSetJKB(String string, String string2) {
        if (string == null || string.equals("") || string2 == null || string2.equals("")) {
            return false;
        }
        PgKnotBook pgKnotBook = PsKbxLoader.read(string + string2);
        if (pgKnotBook == null) {
            return false;
        }
        this.m_knotbook = pgKnotBook;
        this.currentKnotFileName = string + string2;
        this.reset();
        return true;
    }

    protected void setProcessStatusLabel(String string) {
        if (((PsObject)this).m_infoPanel == null) {
            return;
        }
        ((BooknotProject_IP)((PsObject)this).m_infoPanel).setProcessStatusLabel(string);
    }

    protected void setNumPointsLabel(int n) {
        if (((PsObject)this).m_infoPanel == null) {
            return;
        }
        ((BooknotProject_IP)((PsObject)this).m_infoPanel).setNumPointsLabel(n);
    }

    protected void setNumComponentsLabel(int n) {
        if (((PsObject)this).m_infoPanel == null) {
            return;
        }
        ((BooknotProject_IP)((PsObject)this).m_infoPanel).setNumComponentsLabel(n);
    }

    public String[] selectModel(int n) {
        System.out.println("fileDir = " + this.fileDir);
        FileDialog fileDialog = new FileDialog(this.getViewer().getFrame(), "", 0);
        String string = this.fileDir.substring(PsConfig.getCodeBase().length()).replace('/', '\\');
        System.out.println("c_dir = " + string);
        String string2 = "";
        String string3 = "*.*";
        switch (n) {
            case 1: {
                string = string + "jkb\\";
                string2 = ".jkb";
                string3 = "*.jkb";
                break;
            }
            case 2: {
                string = string + "gc\\";
                string2 = ".gc";
                string3 = "*.gc";
                break;
            }
            case 3: {
                string = string + "poly3D\\";
                string2 = ".txt";
                string3 = "*.txt";
                break;
            }
            default: {
                return null;
            }
            case 0: 
        }
        fileDialog.setDirectory(string);
        fileDialog.setFile(string3);
        ((Component)fileDialog).setVisible(true);
        String[] stringArray = new String[]{"", ""};
        if (fileDialog.getFile() == null) {
            return stringArray;
        }
        stringArray[0] = fileDialog.getDirectory();
        stringArray[1] = fileDialog.getFile();
        if (stringArray[1].endsWith(string2)) {
            return stringArray;
        }
        return null;
    }

    public void setCurrentKnotFileName(String string) {
        this.currentKnotFileName = string;
    }
}

