/*
 * Decompiled with CFR 0.152.
 */
package dev.app.knotBook;

import dev.app.knotBook.PgKnotArc;
import java.awt.Color;
import jv.number.PdColor;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.project.PvGeometryIf;
import jv.vecmath.PdVector;
import jv.vecmath.PuData;

public class PgKnotBook
extends PgGeometry {
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final int UNKNOWN = -1;
    public static final boolean[] BOOLEAN;
    protected int m_numVertices = 0;
    protected int m_numComponents = 0;
    protected PdVector[] m_vertex;
    protected Color[] m_vertexColor;
    protected int m_bShowVertices = -1;
    protected double m_globalVertexSize;
    protected Color m_globalVertexColor;
    protected Color m_globalVertexTagColor;
    protected int m_bShowIndices = -1;
    protected int m_numArcs;
    protected PgKnotArc[] m_arc;
    protected int[] m_components;
    protected Color[] m_arcColor;
    protected Color m_globalArcColor;
    protected int m_numPages;
    protected double[] m_pageAngle;
    protected Color[] m_pageColor;
    protected Color m_globalPageColor;

    public void setGlobalArcColor(Color color) {
        this.m_globalArcColor = color;
    }

    public double getPageAngle(int n) {
        return this.m_pageAngle[n];
    }

    public void setPageAngle(int n, double d) {
        this.m_pageAngle[n] = d;
    }

    public void setGlobalPageColor(Color color) {
        this.m_globalPageColor = color;
    }

    public Color getGlobalPageColor() {
        return this.m_globalPageColor;
    }

    public PgKnotArc getArc(int n) {
        return this.m_arc[n];
    }

    public void setArc(int n, PgKnotArc pgKnotArc) {
        this.m_arc[n].copy(pgKnotArc);
    }

    public PdVector[] getVertices() {
        return this.m_vertex;
    }

    public void setVertices(PdVector[] pdVectorArray) {
        if (pdVectorArray == null || pdVectorArray.length == 0 || pdVectorArray.length < this.m_numVertices) {
            PsDebug.warning((String)"PgKnotBook.setVertices(): void length of argument vertex array");
            return;
        }
        int n = pdVectorArray[0].getSize();
        int n2 = 0;
        while (n2 < this.m_numVertices) {
            int n3 = pdVectorArray[n2].getSize();
            this.m_vertex[n2].setSize(n3);
            if (n != -1 && n3 != n) {
                n = -1;
            }
            ++n2;
        }
        this.m_dim = n;
        PdVector.copy((PdVector[])this.m_vertex, (int)0, (PdVector[])pdVectorArray, (int)0, (int)this.m_numVertices);
    }

    public int getNumPages() {
        return this.m_numPages;
    }

    public void setNumPages(int n) {
        if (this.m_numPages == n) {
            return;
        }
        this.m_numPages = n;
        this.m_pageAngle = PuData.realloc((double[])this.m_pageAngle, (int)this.m_numPages);
        if (this.m_pageColor != null) {
            this.m_pageColor = PdColor.realloc((Color[])this.m_pageColor, (int)this.m_numPages);
        }
    }

    public int isShowingVertices() {
        return this.m_bShowVertices;
    }

    public void showVertices(int n) {
        this.m_bShowVertices = n;
    }

    public Color getArcColor(int n) {
        return this.m_arcColor[n];
    }

    public void setArcColor(int n, Color color) {
        if (this.m_arcColor == null) {
            this.assureArcColors();
        }
        this.m_arcColor[n] = color;
    }

    public Color getPageColor(int n) {
        return this.m_pageColor[n];
    }

    public void setPageColor(int n, Color color) {
        if (this.m_pageColor == null) {
            this.assurePageColors();
        }
        this.m_pageColor[n] = color;
    }

    public Color getGlobalVertexColor() {
        return this.m_globalVertexColor;
    }

    public void setGlobalVertexColor(Color color) {
        this.m_globalVertexColor = color;
    }

    public int[] getComponents() {
        this.setComponents();
        return this.m_components;
    }

    private void setComponents() {
        this.m_components = new int[this.m_arc.length];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = true;
        int n4 = 0;
        while (n4 < this.m_components.length) {
            this.m_components[n4] = -1;
            ++n4;
        }
        while (bl) {
            this.m_components[n2] = n;
            int n5 = 0;
            while (n5 < this.m_arc.length && this.m_arc[n5].getBase() != this.m_arc[n2].getEnd()) {
                ++n5;
            }
            n2 = n5;
            if (n2 == this.m_components.length) {
                n4 = 0;
                while (n4 < this.m_components.length) {
                    this.m_components[n4] = 0;
                    ++n4;
                }
                return;
            }
            if (this.m_components[n2] < 0) continue;
            while (n3 < this.m_components.length && this.m_components[n3] >= 0) {
                ++n3;
            }
            n2 = n3;
            bl = n2 != this.m_components.length;
            ++n;
        }
        this.m_numComponents = n;
    }

    public void assureArcColors() {
        if (this.m_arcColor == null || this.m_arcColor.length != this.m_numArcs) {
            this.m_arcColor = PdColor.realloc((Color[])this.m_arcColor, (int)this.m_numArcs);
        }
    }

    public Color[] getArcColors() {
        return this.m_arcColor;
    }

    public void setArcColors(Color[] colorArray) {
        if (colorArray == null || colorArray.length < this.m_numArcs) {
            PsDebug.warning((String)"PgKnotBook.setArcColors(): void length of argument array");
            return;
        }
        this.assureArcColors();
        PdColor.copy((Color[])this.m_arcColor, (int)0, (Color[])colorArray, (int)0, (int)this.m_numArcs);
    }

    public Color[] getPageColors() {
        return this.m_pageColor;
    }

    public void setPageColors(Color[] colorArray) {
        if (colorArray == null || colorArray.length < this.m_numArcs) {
            PsDebug.warning((String)"PgKnotBook.setPageColors(): void length of argument array");
            return;
        }
        this.assurePageColors();
        PdColor.copy((Color[])this.m_pageColor, (int)0, (Color[])colorArray, (int)0, (int)this.m_numPages);
    }

    public void assurePageColors() {
        if (this.m_pageColor == null || this.m_pageColor.length != this.m_numPages) {
            this.m_pageColor = PdColor.realloc((Color[])this.m_pageColor, (int)this.m_numPages);
        }
    }

    public int getNumVertices() {
        return this.m_numVertices;
    }

    public void setNumVertices(int n, int n2) {
        if (this.m_numVertices == n) {
            return;
        }
        this.m_vertex = PdVector.realloc((PdVector[])this.m_vertex, (int)n, (int)this.m_dim);
        if (this.m_vertexColor != null) {
            this.m_vertexColor = PdColor.realloc((Color[])this.m_vertexColor, (int)n);
        }
        this.m_numVertices = n;
    }

    public PgKnotBook() {
        super(1);
        this.init();
    }

    public void paint(PvGeometryIf pvGeometryIf) {
        super.paint(pvGeometryIf);
        pvGeometryIf.setState(70, false);
        pvGeometryIf.setState(69, false);
        pvGeometryIf.setGlobalVertexSize(2.0);
        pvGeometryIf.setGlobalVertexColor(Color.red);
        pvGeometryIf.setNumVertices(this.m_numVertices);
        pvGeometryIf.setVertices(this.m_vertex);
        if (this.m_vertexColor == null) {
            pvGeometryIf.setState(90, true);
        } else {
            pvGeometryIf.setState(90, false);
        }
        pvGeometryIf.setVertexColors(this.m_vertexColor);
        pvGeometryIf.setState(60, false);
    }

    public Color getVertexColor(int n) {
        if (n < 0 || n >= this.m_numVertices) {
            return null;
        }
        return this.m_vertexColor[n];
    }

    public boolean setVertex(int n, PdVector pdVector) {
        if (n < 0 || n > this.m_numVertices - 1) {
            PsDebug.warning((String)("PgKnotBook.setVertex(): index=" + n + " out of range"));
            return false;
        }
        if (pdVector == null) {
            PsDebug.warning((String)"PgKnotBook.setVertex(): missing argument");
            return false;
        }
        this.m_vertex[n].copy(pdVector);
        return true;
    }

    public void setVertexColor(int n, Color color) {
        if (n < 0 || color == null) {
            PsDebug.warning((String)"PgKnotBook.setVertexColor(): index out of range, corrupt argument");
            return;
        }
        if (this.m_vertexColor == null || n >= this.m_vertexColor.length) {
            this.assureVertexColors();
        }
        this.m_vertexColor[n] = color;
    }

    public double getGlobalVertexSize() {
        return this.m_globalVertexSize;
    }

    public void setGlobalVertexSize(double d) {
        this.m_globalVertexSize = d;
    }

    static {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        BOOLEAN = blArray;
    }

    public int getNumArcs() {
        return this.m_numArcs;
    }

    public void setNumArcs(int n) {
        if (this.m_numArcs == n) {
            return;
        }
        int n2 = this.m_numArcs;
        this.m_numArcs = n;
        PgKnotArc[] pgKnotArcArray = this.m_arc;
        int n3 = Math.min(n2, this.m_numArcs);
        this.m_arc = new PgKnotArc[this.m_numArcs];
        int n4 = 0;
        while (n4 < n3) {
            this.m_arc[n4] = pgKnotArcArray[n4];
            ++n4;
        }
        n4 = n3;
        while (n4 < n) {
            this.m_arc[n4] = new PgKnotArc();
            ++n4;
        }
        if (this.m_arcColor != null) {
            this.m_arcColor = PdColor.realloc((Color[])this.m_arcColor, (int)this.m_numArcs);
        }
    }

    public int getNumComponents() {
        this.setComponents();
        return this.m_numComponents;
    }

    public int isShowingIndices() {
        return this.m_bShowIndices;
    }

    public void showIndices(int n) {
        this.m_bShowIndices = n;
    }

    public void assureVertexColors() {
        if (this.m_vertexColor == null || this.m_vertexColor.length != this.m_numVertices) {
            this.m_vertexColor = PdColor.realloc((Color[])this.m_vertexColor, (int)this.m_numVertices);
        }
    }

    public void init() {
        super.init();
        this.m_numComponents = 0;
        this.m_numVertices = 0;
        this.m_vertex = null;
        this.m_vertexColor = null;
        this.m_bShowVertices = -1;
        this.m_globalVertexSize = 0.0;
        this.m_globalVertexColor = null;
        this.m_globalVertexTagColor = null;
        this.m_bShowIndices = -1;
        this.m_numArcs = 0;
        this.m_arc = null;
        this.m_components = null;
        this.m_arcColor = null;
        this.m_globalArcColor = null;
        this.m_numPages = 0;
        this.m_pageAngle = null;
        this.m_pageColor = null;
        this.m_globalPageColor = null;
    }

    public Color[] getVertexColors() {
        return this.m_vertexColor;
    }

    public void setVertexColors(Color[] colorArray) {
        if (colorArray == null || colorArray.length < this.m_numVertices) {
            PsDebug.warning((String)"PgKnotBook.setVertexColors(): void length of argument array");
            return;
        }
        this.assureVertexColors();
        PdColor.copy((Color[])this.m_vertexColor, (int)0, (Color[])colorArray, (int)0, (int)this.m_numVertices);
    }

    public Color getGlobalVertexTagColor() {
        return this.m_globalVertexTagColor;
    }

    public void setGlobalVertexTagColor(Color color) {
        this.m_globalVertexTagColor = color;
    }

    public PgKnotArc[] getArcs() {
        return this.m_arc;
    }

    public void setArcs(PgKnotArc[] pgKnotArcArray) {
        this.setNumArcs(pgKnotArcArray.length);
        int n = 0;
        while (n < pgKnotArcArray.length) {
            this.m_arc[n].copy(pgKnotArcArray[n]);
            ++n;
        }
    }

    public Color getGlobalArcColor() {
        return this.m_globalArcColor;
    }
}

