/*
 * Decompiled with CFR 0.152.
 */
package dev.app.knotBook;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class PlaneParser {
    private boolean maybeDataCorrect = true;
    private Vector crossings = new Vector();
    private double[][][] polinoms;
    private Vector basePointsPol = new Vector();
    private Hashtable polCross = new Hashtable();
    private int[] component_polinom_rel;

    public PlaneParser(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        if (n % 3 != 0 || n == 0) {
            System.out.println("incorrect input data");
            this.maybeDataCorrect = false;
            return;
        }
        this.polinoms = new double[n / 3][2][3];
        this.component_polinom_rel = new int[n / 3];
        int n2 = -1;
        int n3 = 0;
        while (!string.equals("")) {
            int n4 = string.indexOf("\n\n");
            if (n4 != -1) {
                stringTokenizer = new StringTokenizer(string.substring(0, n4));
                string = string.substring(n4 + 1).trim();
                ++n2;
                n = stringTokenizer.countTokens();
            } else {
                stringTokenizer = new StringTokenizer(string);
                n = stringTokenizer.countTokens();
                ++n2;
                string = "";
            }
            double[] dArray = new double[3];
            double[] dArray2 = new double[3];
            try {
                dArray2[0] = dArray[0] = Double.valueOf(stringTokenizer.nextToken()).doubleValue();
                dArray2[1] = dArray[1] = Double.valueOf(stringTokenizer.nextToken()).doubleValue();
                dArray2[2] = dArray[2] = Double.valueOf(stringTokenizer.nextToken()).doubleValue();
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("incorrect input data");
                this.maybeDataCorrect = false;
                return;
            }
            int n5 = 3;
            while (n5 < n + 3) {
                this.polinoms[(n5 + n3 - 3) / 3][0][n5 % 3] = dArray[n5 % 3];
                if (n5 < n) {
                    try {
                        dArray[n5 % 3] = Double.valueOf(stringTokenizer.nextToken());
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("incorrect input data");
                        this.maybeDataCorrect = false;
                        return;
                    }
                    this.polinoms[(n5 + n3) / 3 - 1][1][n5 % 3] = dArray[n5 % 3];
                } else {
                    this.polinoms[(n5 + n3) / 3 - 1][1][(n5 - n) % 3] = dArray2[(n5 - n) % 3];
                }
                this.component_polinom_rel[(n5 + n3) / 3 - 1] = n2;
                ++n5;
            }
            n3 += n;
        }
        this.initData();
    }

    private boolean setCrossing() {
        int n = -1;
        int n2 = 0;
        while (n2 < this.polinoms.length) {
            double[][] dArray = this.polinoms[n2];
            double d = dArray[0][0];
            double d2 = dArray[1][0];
            double d3 = dArray[0][1];
            double d4 = dArray[1][1];
            double d5 = dArray[0][2];
            double d6 = dArray[1][2];
            String string = dArray[0][0] + "" + dArray[0][1] + "" + dArray[0][2];
            this.basePointsPol.addElement(string);
            this.basePointsPol.addElement(new Integer(n2));
            int n3 = n2 + 1;
            while (n3 < this.polinoms.length) {
                double[][] dArray2 = this.polinoms[n3];
                double d7 = dArray2[0][0];
                double d8 = dArray2[1][0];
                double d9 = dArray2[0][1];
                double d10 = dArray2[1][1];
                double d11 = dArray2[0][2];
                double d12 = dArray2[1][2];
                if (!((d - d2) * (d7 - d8) + (d3 - d4) * (d9 - d10) == 0.0 || d == d7 && d3 == d9 || d == d8 && d3 == d10 || d2 == d7 && d4 == d9 || d2 == d8 && d4 == d10)) {
                    double d13 = d - d2;
                    double d14 = d8 - d7;
                    double d15 = d3 - d4;
                    double d16 = d10 - d9;
                    double d17 = d7 - d2 + d4 * d13 / d15 - d9 * d14 / d16;
                    double d18 = d9 - d4 + d2 * d15 / d13 - d7 * d16 / d14;
                    double d19 = (d5 - d6) * ((d18 /= d15 / d13 - d16 / d14) - d2) / (d - d2) + d6;
                    double d20 = (d11 - d12) * (d18 - d8) / (d7 - d8) + d12;
                    if (Math.min(d, d2) < d18 && d18 < Math.max(d, d2) && Math.min(d7, d8) < d18 && d18 < Math.max(d7, d8) && Math.min(d3, d4) < d17 && d17 < Math.max(d3, d4) && Math.min(d9, d10) < d17 && d17 < Math.max(d9, d10) && (d18 != d || (d17 /= d13 / d15 - d14 / d16) != d3) && (d18 != d2 || d17 != d4) && (d18 != d7 || d17 != d9) && (d18 != d8 || d17 != d10)) {
                        Object object;
                        ++n;
                        if (d20 < d19) {
                            object = new int[]{n, n2, n3};
                            this.crossings.addElement(object);
                        } else if (d20 > d19) {
                            object = new int[]{n, n3, n2};
                            this.crossings.addElement(object);
                        } else {
                            System.out.println("ERROR: incorrect crossing");
                            return false;
                        }
                        object = new Integer(n2);
                        Integer n4 = new Integer(n3);
                        Vector<Object> vector = (Vector<Object>)this.polCross.get(object);
                        Vector<Object> vector2 = (Vector<Object>)this.polCross.get(n4);
                        if (vector == null) {
                            vector = new Vector<Object>();
                        }
                        if (vector2 == null) {
                            vector2 = new Vector<Object>();
                        }
                        double[] dArray3 = new double[]{d18, d17};
                        vector.addElement(dArray3);
                        vector2.addElement(dArray3);
                        vector.addElement(new Integer(n));
                        vector2.addElement(new Integer(n));
                        this.polCross.put(object, vector);
                        this.polCross.put(n4, vector2);
                    }
                }
                ++n3;
            }
            ++n2;
        }
        return true;
    }

    private void initData() {
        this.correctInput();
        this.setCrossing();
    }

    private String makeStringGC(Vector vector, int[] nArray) {
        String[] stringArray;
        int n;
        int n2;
        String string = "";
        if (nArray != null) {
            n2 = 0;
            n = 0;
            while (n < nArray.length) {
                stringArray = new String[]{"", "Component", ""};
                vector.insertElementAt(stringArray, nArray[n] + n2);
                ++n2;
                ++n;
            }
        }
        n2 = vector.size();
        n = 0;
        while (n < n2) {
            stringArray = (String[])vector.elementAt(n);
            string = string + stringArray[0] + stringArray[1] + stringArray[2] + "\n";
            ++n;
        }
        return string;
    }

    private void correctInput() {
        int n = 0;
        while (n < this.polinoms.length) {
            double[][] dArray = this.polinoms[n];
            int n2 = n + 1;
            while (n2 < this.polinoms.length) {
                double[][] dArray2 = this.polinoms[n2];
                double d = dArray[0][0];
                double d2 = dArray[0][1];
                double d3 = dArray[1][0];
                double d4 = dArray[1][1];
                double d5 = dArray2[0][0];
                double d6 = dArray2[0][1];
                double d7 = dArray2[1][0];
                double d8 = dArray2[1][1];
                if (d == d7 && d2 == d8 || d5 == d3 && d6 == d4) break;
                if (d == d5 && d2 == d6) {
                    dArray2[0][0] = d7;
                    dArray2[0][1] = d8;
                    dArray2[1][0] = d5;
                    dArray2[1][1] = d6;
                    break;
                }
                ++n2;
            }
            ++n;
        }
    }

    public boolean getDataCorrectness() {
        return this.maybeDataCorrect;
    }

    private Vector crossingsSorted(Vector vector, int n) {
        double[][] dArray = this.polinoms[n];
        double d = dArray[0][0];
        double d2 = dArray[1][0];
        double d3 = dArray[0][1];
        double d4 = dArray[1][1];
        Vector<Object> vector2 = new Vector<Object>();
        Object object = new Object();
        int n2 = 0;
        while (n2 < vector.size()) {
            vector2.addElement(vector.elementAt(n2));
            vector2.addElement(vector.elementAt(n2 + 1));
            double[] dArray2 = (double[])vector.elementAt(n2);
            int n3 = 0;
            while (n3 < vector2.size()) {
                if (n2 != n3) {
                    int n4;
                    double[] dArray3 = (double[])vector.elementAt(n3);
                    if (d > d2 && dArray2[0] > dArray3[0]) {
                        vector2.insertElementAt(dArray2, n3);
                        object = vector.elementAt(n2 + 1);
                        vector2.insertElementAt(object, n3 + 1);
                        vector.insertElementAt(dArray2, n3);
                        vector.removeElementAt(n2 + 1);
                        vector.insertElementAt(object, n3 + 1);
                        vector.removeElementAt(n2 + 2);
                        n4 = vector2.size();
                        vector2.removeElementAt(n4 - 1);
                        vector2.removeElementAt(n4 - 2);
                        break;
                    }
                    if (d < d2 && dArray2[0] < dArray3[0]) {
                        vector2.insertElementAt(dArray2, n3);
                        vector2.insertElementAt(vector.elementAt(n2 + 1), n3 + 1);
                        vector.insertElementAt(dArray2, n3);
                        vector.removeElementAt(n2 + 1);
                        vector.insertElementAt(object, n3 + 1);
                        vector.removeElementAt(n2 + 2);
                        n4 = vector2.size();
                        vector2.removeElementAt(n4 - 1);
                        vector2.removeElementAt(n4 - 2);
                        break;
                    }
                    if (d == d2) {
                        if (d3 < d4 && dArray2[1] < dArray3[1]) {
                            vector2.insertElementAt(dArray2, n3);
                            vector2.insertElementAt(vector.elementAt(n2 + 1), n3 + 1);
                            vector.insertElementAt(dArray2, n3);
                            vector.removeElementAt(n2 + 1);
                            vector.insertElementAt(object, n3 + 1);
                            vector.removeElementAt(n2 + 2);
                            n4 = vector2.size();
                            vector2.removeElementAt(n4 - 1);
                            vector2.removeElementAt(n4 - 2);
                            break;
                        }
                        if (d3 > d4 && dArray2[1] > dArray3[1]) {
                            vector2.insertElementAt(dArray2, n3);
                            vector2.setElementAt(vector.elementAt(n2 + 1), n3 + 1);
                            vector.insertElementAt(dArray2, n3);
                            vector.removeElementAt(n2 + 1);
                            vector.insertElementAt(object, n3 + 1);
                            vector.removeElementAt(n2 + 2);
                            n4 = vector2.size();
                            vector2.removeElementAt(n4 - 1);
                            vector2.removeElementAt(n4 - 2);
                            break;
                        }
                        if (d3 == d4) {
                            System.out.println("ERROR: impossible situation in PlaneParser");
                        }
                    }
                }
                n3 += 2;
            }
            n2 += 2;
        }
        return vector2;
    }

    public String getGC() {
        int n;
        Vector<String[]> vector = new Vector<String[]>();
        int n2 = this.crossings.size();
        System.out.println("crossNum = " + n2);
        if (n2 == 0) {
            return "Trivial Knot";
        }
        int n3 = 0;
        int n4 = n = 0;
        System.out.println("component_polinom_rel.length =" + this.component_polinom_rel.length);
        int n5 = this.component_polinom_rel[n];
        int[] nArray = null;
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        block0: while (true) {
            int n6;
            int[] nArray2;
            int n7;
            int n8;
            double[][] dArray = this.polinoms[n];
            String string = dArray[1][0] + "" + dArray[1][1] + "" + dArray[1][2];
            double d = dArray[0][0];
            double d2 = dArray[1][0];
            double d3 = dArray[0][1];
            double d4 = dArray[1][1];
            Object v = this.polCross.get(new Integer(n));
            if (v != null) {
                Vector vector2 = (Vector)v;
                vector2 = this.crossingsSorted(vector2, n);
                n8 = 1;
                while (n8 < vector2.size()) {
                    n7 = (Integer)vector2.elementAt(n8);
                    nArray2 = (int[])this.crossings.elementAt(n7);
                    String[] stringArray = new String[]{"", "", String.valueOf(nArray2[0])};
                    int n9 = -1;
                    if (nArray2[1] == n) {
                        n9 = nArray2[2];
                        stringArray[0] = "+";
                    } else {
                        n9 = nArray2[1];
                        stringArray[0] = "-";
                    }
                    Object v2 = hashtable.get(String.valueOf(nArray2[0]));
                    if (v2 != null) {
                        int n10 = (Integer)v2;
                        String[] stringArray2 = (String[])vector.elementAt(n10);
                        double[][] dArray2 = this.polinoms[n9];
                        double d5 = (d2 - d) * (dArray2[1][1] - dArray2[0][1]) - (d4 - d3) * (dArray2[1][0] - dArray2[0][0]);
                        if (d5 < 0.0) {
                            stringArray[1] = ">";
                            stringArray2[1] = "<";
                        } else {
                            stringArray[1] = "<";
                            stringArray2[1] = ">";
                        }
                        vector.setElementAt(stringArray2, n10);
                    }
                    hashtable.put(String.valueOf(nArray2[0]), new Integer(n3));
                    vector.addElement(stringArray);
                    if (++n3 >= 2 * n2) break;
                    n8 += 2;
                }
                if (n3 >= 2 * n2) break;
            }
            if ((n = ((Integer)this.basePointsPol.elementAt((n6 = this.basePointsPol.indexOf(string)) + 1)).intValue()) != n4) continue;
            n8 = 0;
            while (true) {
                if (n8 >= this.component_polinom_rel.length) continue block0;
                if (this.component_polinom_rel[n8] == n5 + 1) {
                    n5 = this.component_polinom_rel[n8];
                    n7 = 0;
                    if (nArray != null) {
                        n7 = nArray.length;
                    }
                    nArray2 = new int[n7 + 1];
                    int n11 = 0;
                    while (n11 < n7) {
                        nArray2[n11] = nArray[n11];
                        ++n11;
                    }
                    nArray2[n7] = vector.size();
                    nArray = nArray2;
                    n4 = n = n8;
                    continue block0;
                }
                ++n8;
            }
            break;
        }
        return this.makeStringGC(vector, nArray);
    }
}

