/*
 * Decompiled with CFR 0.152.
 */
package dev.app.level;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import jv.function.PuFunction;
import jv.number.PuInteger;
import jv.object.PsUpdateIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.project.PvPickEvent;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PjLevel
extends PjProject {
    protected PuFunction m_function;
    protected Image m_image;
    private MemoryImageSource mis;
    private PiVector m_pix;
    protected int m_imageHeight;
    protected int m_imageWidth;
    protected PdVector m_bounds;
    protected PuInteger m_coarseness;
    protected double[] m_result = new double[1];
    protected double[] m_arg = new double[2];
    private static /* synthetic */ Class class$dev$app$level$PjLevel;

    public void markVertices(PvPickEvent pvPickEvent) {
        PiVector piVector = pvPickEvent.getMarkBox();
        int[] nArray = piVector.m_data;
        double d = this.m_bounds.m_data[2] - this.m_bounds.m_data[0];
        double d2 = this.m_bounds.m_data[3] - this.m_bounds.m_data[1];
        double d3 = this.m_bounds.m_data[0] + d * (double)nArray[0] / ((double)this.m_imageWidth - 1.0);
        double d4 = this.m_bounds.m_data[0] + d * (double)nArray[2] / ((double)this.m_imageWidth - 1.0);
        double d5 = this.m_bounds.m_data[1] + d2 * (double)nArray[1] / ((double)this.m_imageHeight - 1.0);
        double d6 = this.m_bounds.m_data[1] + d2 * (double)nArray[3] / ((double)this.m_imageHeight - 1.0);
        this.computeImage(d3, d5, d4, d6);
        PvDisplayIf pvDisplayIf = this.getDisplay();
        pvDisplayIf.update(null);
    }

    public PjLevel() {
        super("Mandelbrot Set");
        this.m_function = new PuFunction(3, 1);
        this.m_function.setName("Sphere");
        this.m_function.setExpression("1-u*u-v*v-w*w", 0);
        this.m_pix = new PiVector();
        this.m_bounds = new PdVector(4);
        this.m_coarseness = new PuInteger("Coarseness", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$dev$app$level$PjLevel != null ? class$dev$app$level$PjLevel : (class$dev$app$level$PjLevel = PjLevel.class$("dev.app.level.PjLevel")))) {
            this.init();
        }
    }

    public void computeImage(double d, double d2, double d3, double d4) {
        this.m_bounds.set(d, d2, d3, d4);
        Dimension dimension = this.getDisplay().getSize();
        if (dimension.height == -1 || dimension.width == -1) {
            dimension.height = 200;
            dimension.width = 200;
        }
        if (this.mis == null || this.m_imageHeight != dimension.height || this.m_imageWidth != dimension.width) {
            this.m_imageHeight = dimension.height;
            this.m_imageWidth = dimension.width;
            this.m_pix.setSize(this.m_imageWidth * this.m_imageHeight);
            this.drawImage(this.m_pix.m_data, this.m_imageWidth, this.m_imageHeight, d, d2, d3, d4);
            this.mis = new MemoryImageSource(this.m_imageWidth, this.m_imageHeight, this.m_pix.m_data, 0, this.m_imageWidth);
            this.mis.setAnimated(true);
            this.m_image = ((Component)this.m_display).createImage(this.mis);
            return;
        }
        this.drawImage(this.m_pix.m_data, this.m_imageWidth, this.m_imageHeight, d, d2, d3, d4);
        this.mis.newPixels(0, 0, this.m_imageWidth, this.m_imageHeight);
    }

    public boolean update(Object object) {
        PvDisplayIf pvDisplayIf = this.getDisplay();
        if (object == this.getInspector("Info")) {
            if (this.m_image != null) {
                pvDisplayIf.setBackgroundImage(this.m_image);
            } else {
                pvDisplayIf.setBackgroundImage(null);
            }
            pvDisplayIf.update(null);
            return true;
        }
        if (object == this.m_function) {
            this.computeImage(this.m_bounds.m_data[0], this.m_bounds.m_data[1], this.m_bounds.m_data[2], this.m_bounds.m_data[3]);
            pvDisplayIf.update(null);
            return true;
        }
        if (object == this.m_coarseness) {
            this.computeImage(this.m_bounds.m_data[0], this.m_bounds.m_data[1], this.m_bounds.m_data[2], this.m_bounds.m_data[3]);
            pvDisplayIf.update(null);
            return true;
        }
        return super.update(object);
    }

    public void start() {
        this.computeImage(-2.5, -2.0, 1.5, 2.0);
        this.update(this.getInspector("Info"));
        PvDisplayIf pvDisplayIf = this.getDisplay();
        if (pvDisplayIf != null) {
            // empty if block
        }
        pvDisplayIf.showBackImage(true);
        super.start();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void drawImage(int[] nArray, int n, int n2, double d, double d2, double d3, double d4) {
        int n3 = this.m_coarseness.getValue();
        double d5 = (double)n3 * (d3 - d) / ((double)n - 1.0);
        double d6 = (double)n3 * (d4 - d2) / ((double)n2 - 1.0);
        double d7 = d2;
        int n4 = 0;
        while (n4 < n2) {
            int n5;
            int n6;
            double d8 = d;
            int n7 = n4 * n;
            int n8 = 0;
            while (n8 < n) {
                n6 = (int)Math.abs(this.eval(d8, d7));
                int n9 = 0xFF000000 | (50 + 205 * n6) % 255 << 16;
                n5 = 0;
                while (n5 < Math.min(n3, n - n8)) {
                    nArray[n7++] = n9;
                    ++n5;
                }
                d8 += d5;
                n8 += n3;
            }
            n6 = n7 - n;
            n5 = 0;
            while (n5 < Math.min(n3, n2 - n4 - 1)) {
                n8 = 0;
                while (n8 < n) {
                    nArray[n7++] = nArray[n6++];
                    ++n8;
                }
                ++n5;
            }
            d7 += d6;
            n4 += n3;
        }
    }

    public void init() {
        super.init();
        this.m_image = null;
        this.m_pix.setSize(0);
        this.m_imageHeight = 0;
        this.m_imageWidth = 0;
        this.m_coarseness.setDefValue(2);
        this.m_coarseness.setDefBounds(1, 10, 1, 2);
        this.m_coarseness.init();
    }

    protected double eval(double d, double d2) {
        this.m_arg[0] = d;
        this.m_arg[1] = d2;
        this.m_function.eval(this.m_result, this.m_arg);
        return this.m_result[0];
    }
}

