/*
 * Decompiled with CFR 0.152.
 */
package dev.app.maxPrinciple;

import dev.app.maxPrinciple.PjMaxPrinciple;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import jv.loader.PgJvxLoader;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsMainFrame;
import jv.project.PgJvxSrc;
import jv.project.PjProject;
import jv.viewer.PvViewer;

public class PaMaxPrinciple
extends Applet
implements Runnable {
    public Frame m_frame = null;
    protected PvViewer m_viewer;
    private String m_drawString = "Initializing ...";

    public void stop() {
        if (this.m_viewer != null) {
            this.m_viewer.stop();
        }
    }

    public void startFromThread() {
        if (this.m_viewer != null) {
            this.m_viewer.start();
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.blue);
        graphics.drawString(PsConfig.getProgram() + " v." + PsConfig.getVersion(), 20, 40);
        graphics.drawString(this.m_drawString, 20, 60);
    }

    public void destroy() {
        if (this.m_viewer != null) {
            this.m_viewer.destroy();
        }
    }

    private void drawMessage(String string) {
        this.m_drawString = string;
        this.repaint();
    }

    public static void main(String[] stringArray) {
        PaMaxPrinciple paMaxPrinciple = new PaMaxPrinciple();
        PsMainFrame psMainFrame = new PsMainFrame((Component)paMaxPrinciple, stringArray);
        psMainFrame.pack();
        psMainFrame.setBounds(new Rectangle(420, 5, 790, 550));
        paMaxPrinciple.m_frame = psMainFrame;
        paMaxPrinciple.init();
        psMainFrame.setVisible(true);
    }

    public String getAppletInfo() {
        return "Name: " + this.getClass().getName() + "\r\n" + "Author: " + "Konrad Polthier" + "\r\n" + "Version: " + "1.00" + "\r\n" + "Counterexample to the Maximum Principle of Discrete Minimal Surfaces" + "\r\n";
    }

    public void run() {
        Object object;
        this.m_viewer = new PvViewer((Applet)this, this.m_frame);
        this.drawMessage("Loading project ...");
        String string = this.m_viewer.getParameter("Model");
        PgJvxSrc pgJvxSrc = null;
        if (string != null) {
            object = PsConfig.getCodeBase() + string;
            String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
            if (string2 != null && string2.equalsIgnoreCase("Jvx")) {
                PgJvxSrc[] pgJvxSrcArray = PgJvxLoader.read((String)object);
                if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0) {
                    PsDebug.warning((String)("Loading failed.\n Could not load model = " + string));
                    return;
                }
                pgJvxSrc = pgJvxSrcArray[0];
            } else {
                PsDebug.warning((String)"Must use a JVX geometry model with functional vertices.");
                return;
            }
        }
        if (pgJvxSrc == null) {
            PsDebug.warning((String)("Loading failed.\n Could not load model = " + string));
            return;
        }
        object = new PjMaxPrinciple(pgJvxSrc);
        this.m_viewer.addProject((PjProject)object);
        this.m_viewer.selectProject(object.getName());
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)this.m_viewer.getDisplay());
        this.add("East", this.m_viewer.getPanel(10));
        this.validate();
        this.startFromThread();
    }

    public void init() {
        Thread thread = new Thread((Runnable)this, "JavaView: inititialize applet");
        thread.setPriority(5);
        thread.start();
    }
}

