/*
 * Decompiled with CFR 0.152.
 */
package dev.app.optimize;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Date;
import jv.geom.PgElementSet;
import jv.object.PsConfig;
import jv.object.PsMainFrame;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.viewer.PvViewer;

public class PaViewerOptimize
extends Applet
implements Runnable {
    public Frame m_frame = null;
    protected PvViewer m_viewer;
    private String m_drawString = "Initializing ...";
    protected String[][] m_parm = new String[][]{{"Console", "String", "Hide", "Show/Hide VGP-console for debugging"}, {"Control", "String", "Hide", "Show/Hide control panel"}, {"Frame", "String", "Hide", "Show/Hide frame around applet"}, {"Panel", "String", "Project", "Name of initial panel if control panel is showing"}};
    private long m_initTime;

    public void stop() {
        if (this.m_viewer != null) {
            this.m_viewer.stop();
        }
    }

    public void startFromThread() {
        if (this.m_viewer != null) {
            this.m_viewer.start();
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.blue);
        graphics.drawString(PsConfig.getProgram() + " v." + PsConfig.getVersion(), 20, 40);
        graphics.drawString(this.m_drawString, 20, 60);
    }

    public String[][] getParameterInfo() {
        return this.m_parm;
    }

    public void destroy() {
        if (this.m_viewer != null) {
            this.m_viewer.destroy();
        }
    }

    private void drawMessage(String string) {
        this.m_drawString = string;
        this.repaint();
    }

    public static void main(String[] stringArray) {
        PaViewerOptimize paViewerOptimize = new PaViewerOptimize();
        PsMainFrame psMainFrame = new PsMainFrame((Component)paViewerOptimize, stringArray);
        paViewerOptimize.m_frame = psMainFrame;
        paViewerOptimize.init();
        psMainFrame.setBounds(new Rectangle(420, 5, 640, 550));
        psMainFrame.setVisible(true);
    }

    public String getAppletInfo() {
        return "Name: " + this.getClass().getName() + "\r\n" + "Author: " + "Konrad Polthier" + "\r\n" + "Version: " + "1.10" + "\r\n" + "Applet shows simple properties of the 3d-viewer used in JavaView" + "\r\n";
    }

    public void run() {
        this.drawMessage("Loading display ...");
        this.m_viewer = new PvViewer((Applet)this, this.m_frame);
        PvDisplayIf pvDisplayIf = this.m_viewer.getDisplay();
        this.drawMessage("Loading geometry ...");
        PgElementSet pgElementSet = new PgElementSet(3);
        pgElementSet.setName("Torus");
        pgElementSet.computeTorus(10, 10, 2.0, 1.0);
        pvDisplayIf.addGeometry((PgGeometryIf)pgElementSet);
        pvDisplayIf.selectGeometry((PgGeometryIf)pgElementSet);
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)pvDisplayIf);
        this.validate();
        this.m_initTime = new Date().getTime() - this.m_initTime;
        this.drawMessage("... completed after ms = " + this.m_initTime);
        System.out.println("... completed after ms = " + this.m_initTime);
        this.startFromThread();
    }

    public void init() {
        this.m_initTime = new Date().getTime();
        Thread thread = new Thread((Runnable)this, "JavaView: inititialize applet");
        thread.setPriority(5);
        thread.start();
    }
}

