/*
 * Decompiled with CFR 0.152.
 */
package dev.app.tetraset;

import dev.app.tetraset.PgTetraSet;
import dev.app.tetraset.PwTetraRivara;
import dev.app.tetraset.PwTetraSet;
import dev.app.tetraset.PwWorkshop;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import jv.function.PuFunction;
import jv.geom.PgElementSet;
import jv.object.PsConfig;
import jv.object.PsMainFrame;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.viewer.PvViewer;

public class PaTetraset
extends Applet
implements Runnable,
ActionListener {
    protected int[] m_frameSize = new int[]{420, 5, 640, 550};
    public Frame m_frame = null;
    private Button m_bColor;
    private Button m_bRefine;
    private Button m_bRivara;
    private PuFunction m_function;
    private PgElementSet m_surface;
    private PgTetraSet m_tetra;
    private TextField m_tfFunction;
    private PwTetraRivara m_wRefine;
    protected PvViewer m_viewer;
    private String m_drawString = "Initializing ...";
    protected String[][] m_parm = new String[][]{{"Console", "String", "Hide", "Show/Hide VGP-console for debugging"}, {"Control", "String", "Hide", "Show/Hide control panel"}, {"Frame", "String", "Hide", "Show/Hide frame around applet"}, {"Panel", "String", "Project", "Name of initial panel if control panel is showing"}};

    public void stop() {
        if (this.m_viewer != null) {
            this.m_viewer.stop();
        }
    }

    public void startFromThread() {
        if (this.m_viewer != null) {
            this.m_viewer.start();
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.blue);
        graphics.drawString(PsConfig.getProgram() + " v." + PsConfig.getVersion(), 20, 40);
        graphics.drawString(this.m_drawString, 20, 60);
    }

    public String[][] getParameterInfo() {
        return this.m_parm;
    }

    public void destroy() {
        if (this.m_viewer != null) {
            this.m_viewer.destroy();
        }
    }

    private void drawMessage(String string) {
        this.m_drawString = string;
        this.repaint();
    }

    public static void main(String[] stringArray) {
        PaTetraset paTetraset = new PaTetraset();
        PsMainFrame psMainFrame = new PsMainFrame((Component)paTetraset, stringArray);
        paTetraset.m_frame = psMainFrame;
        paTetraset.init();
        psMainFrame.setBounds(new Rectangle(420, 5, 640, 550));
        psMainFrame.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_bColor) {
            int n = this.m_tetra.getNumVertices();
            float[] fArray = new float[n];
            int n2 = 0;
            while (n2 < n) {
                fArray[n2] = (float)this.m_function.eval(0, this.m_tetra.getVertex(n2).getEntries());
                ++n2;
            }
            PwWorkshop.colorVertices(this.m_tetra, fArray);
            this.m_tetra.update((Object)this.m_tetra);
            return;
        }
        if (actionEvent.getSource() == this.m_bRefine) {
            this.m_tetra.refineGlobalIntoEight();
            this.m_wRefine.init();
            PwTetraSet.intersect(this.m_tetra, this.m_surface, this.m_function);
            return;
        }
        if (actionEvent.getSource() == this.m_bRivara) {
            Vector vector = PwTetraSet.grepValue(this.m_tetra, this.m_function, 0.0);
            this.m_wRefine.refine(vector);
            PwTetraSet.intersect(this.m_tetra, this.m_surface, this.m_function);
            return;
        }
        if (actionEvent.getSource() == this.m_tfFunction) {
            this.m_function.setExpression(this.m_tfFunction.getText(), 0);
            PwTetraSet.intersect(this.m_tetra, this.m_surface, this.m_function);
        }
    }

    public String getAppletInfo() {
        return "Name: " + this.getClass().getName() + "\r\n" + "Author: " + PsConfig.getAuthors() + "\r\n" + "Version: " + PsConfig.getVersion() + "\r\n" + "Applet shows simple properties of the 3d-viewer used in JavaView" + "\r\n";
    }

    public void run() {
        this.drawMessage("Loading display ...");
        this.m_viewer = new PvViewer((Applet)this, this.m_frame);
        this.drawMessage("Loading geometry ...");
        this.m_tetra = new PgTetraSet(3);
        this.m_tetra.setName("Tetrahedron");
        this.m_tetra.computeBox(3, 3, 3, -1.0, -1.0, -1.0, 1.0, 1.0, 1.0);
        this.m_wRefine = new PwTetraRivara(this.m_tetra);
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)this.m_viewer.getDisplay());
        Panel panel = new Panel();
        this.add("South", panel);
        this.m_bColor = new Button("Color Tetra Set");
        this.m_bColor.addActionListener(this);
        panel.add(this.m_bColor);
        this.m_bRefine = new Button("Refine Global");
        this.m_bRefine.addActionListener(this);
        panel.add(this.m_bRefine);
        this.m_bRivara = new Button("Rivara Refine");
        this.m_bRivara.addActionListener(this);
        panel.add(this.m_bRivara);
        this.m_tfFunction = new TextField("(u*u+w*w-.1)*(v*v+w*w-.1)");
        this.m_tfFunction.addActionListener(this);
        panel.add(this.m_tfFunction);
        this.m_function = new PuFunction(3, 1);
        this.m_function.setExpression(this.m_tfFunction.getText(), 0);
        this.m_surface = new PgElementSet(3);
        PwTetraSet.intersect(this.m_tetra, this.m_surface, this.m_function);
        this.m_surface.showEdges(true);
        this.m_surface.showElements(true);
        this.m_surface.setName("Intersection");
        PvDisplayIf pvDisplayIf = this.m_viewer.getDisplay();
        pvDisplayIf.addGeometry((PgGeometryIf)this.m_tetra);
        pvDisplayIf.addGeometry((PgGeometryIf)this.m_surface);
        this.validate();
        this.startFromThread();
    }

    public void init() {
        this.drawMessage("Loading viewer ...");
        Thread thread = new Thread((Runnable)this, "JavaView: inititialize applet");
        thread.setPriority(5);
        thread.start();
    }
}

