/*
 * Decompiled with CFR 0.152.
 */
package dev.app.tetraset;

import dev.app.tetraset.PgTetraFace;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.project.PvGeometryIf;
import jv.project.PvPickEvent;
import jv.vecmath.PdBary;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;

public class PgTetraSet
extends PgPointSet {
    protected static final int m_dimOfElements = 4;
    protected Color[] m_elementColor;
    protected PdColor m_globalBndColor;
    protected PuDouble m_globalBndSize;
    protected PdColor m_globalBndTagColor;
    protected PdColor m_globalEdgeColor;
    protected PuDouble m_globalEdgeSize;
    protected PdColor m_globalEdgeTagColor;
    protected PdColor m_globalElementColor;
    protected PdColor m_globalElementTagColor;
    protected int m_maxNumElements;
    protected PiVector[] m_neighbour;
    protected static final int m_numEdgesPerTetra = 6;
    protected static final int m_numFacesPerTetra = 4;
    protected int m_numTetras;
    protected static final int m_numVerticesPerTetra = 4;
    protected boolean m_showBoundary;
    protected boolean m_showEdges;
    protected boolean m_showElementNormals;
    protected boolean m_showElements;
    protected boolean m_showTaggedBoundary;
    protected boolean m_showTaggedEdges;
    protected boolean m_showTaggedElements;
    protected PiVector[] m_tetra = new PiVector[0];
    protected boolean m_useGlobalEdgeColor = true;
    protected boolean m_bShowElementColors = false;
    private static /* synthetic */ Class class$dev$app$tetraset$PgTetraSet;

    public int getNumElements() {
        return this.m_numTetras;
    }

    public void setNumElements(int n) {
        if (n > this.m_maxNumElements) {
            this.setMaxNumElements(n);
        }
        this.m_numTetras = n;
    }

    public PvPickEvent intersectionWithLine(PdVector pdVector, PdVector pdVector2) {
        PdVector pdVector3 = new PdVector(((PgGeometry)this).m_dim);
        PdVector pdVector4 = new PdVector(((PgGeometry)this).m_dim);
        int n = -1;
        int n2 = -1;
        double d = Double.MIN_VALUE;
        PdVector pdVector5 = new PdVector(((PgGeometry)this).m_dim);
        PdVector pdVector6 = new PdVector(((PgGeometry)this).m_dim);
        PdBary pdBary = new PdBary(3);
        PdBary pdBary2 = new PdBary(3);
        int n3 = 0;
        while (n3 < this.m_numTetras) {
            PdVector[] pdVectorArray = this.getElementVertices(n3);
            if (pdVectorArray.length >= 3) {
                int n4 = 1;
                while (n4 < pdVectorArray.length - 1) {
                    double d2;
                    if (pdVector3.normalOfPlane(pdVectorArray[0], pdVectorArray[n4], pdVectorArray[n4 + 1]) && (d2 = PuVectorGeom.intersectionOfLineAndPlane((PdVector)pdVector5, (PdVector)pdVector, (PdVector)pdVector2, (PdVector)pdVectorArray[0], (PdVector)pdVector3)) != Double.NaN && (n == -1 || !(d2 > d))) {
                        PdBary.getBary((PdBary)pdBary, (PdVector)pdVector5, (PdVector)pdVectorArray[0], (PdVector)pdVectorArray[n4], (PdVector)pdVectorArray[n4 + 1]);
                        if (pdBary.isInside()) {
                            d = d2;
                            n = n3;
                            n2 = n4;
                            pdBary2.copy(pdBary);
                            pdVector4.copy(pdVector3);
                            pdVector6.copy(pdVector5);
                        }
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        if (n == -1) {
            return null;
        }
        PvPickEvent pvPickEvent = new PvPickEvent(((PgGeometry)this).m_dim);
        pvPickEvent.set(pdVector6, n, n2, pdBary2);
        pvPickEvent.setViewDir(pdVector2);
        pvPickEvent.setNormal(pdVector4);
        return pvPickEvent;
    }

    public PiVector getNeighbour(int n) {
        if (n < 0 || n >= this.m_numTetras) {
            return null;
        }
        return this.m_neighbour[n];
    }

    public void computeBox(int n, int n2, int n3, double d, double d2, double d3, double d4, double d5, double d6) {
        PdVector[] pdVectorArray = PdVector.realloc(null, (int)8, (int)((PgGeometry)this).m_dim);
        pdVectorArray[0].set(d, d2, d3);
        pdVectorArray[1].set(d, d2, d6);
        pdVectorArray[2].set(d, d5, d3);
        pdVectorArray[3].set(d, d5, d6);
        pdVectorArray[4].set(d4, d2, d3);
        pdVectorArray[5].set(d4, d2, d6);
        pdVectorArray[6].set(d4, d5, d3);
        pdVectorArray[7].set(d4, d5, d6);
        this.buildQuadr(pdVectorArray, n, n2, n3);
    }

    public int addElement(PiVector piVector) {
        if (this.addElement(piVector, this.m_numTetras)) {
            return this.m_numTetras - 1;
        }
        return -1;
    }

    public boolean addElement(PiVector piVector, int n) {
        if (n < 0 || n > this.m_numTetras) {
            PsDebug.warning((String)(" index = " + n + " is out of range."));
            return false;
        }
        if (piVector.getSize() != 4) {
            PsDebug.warning((String)("tetrahedron must have 4 and not " + piVector.getSize() + " vertex indices"));
            return false;
        }
        this.setNumElements(this.m_numTetras + 1);
        if (n == this.m_numTetras - 1) {
            this.m_tetra[this.m_numTetras - 1].copy(piVector);
            return true;
        }
        int n2 = n;
        while (n2 < this.m_numTetras - 1) {
            this.m_tetra[n2 + 1].copy(this.m_tetra[n2]);
            ++n2;
        }
        this.m_tetra[n].copy(piVector);
        return true;
    }

    public void getGlobalElementColor() {
        this.m_globalElementColor.getColor();
    }

    public void getGlobalEdgeColor() {
        this.m_globalEdgeColor.getColor();
    }

    public void setGlobalElementColor(Color color) {
        this.m_globalElementColor.setColor(color);
    }

    public void setGlobalEdgeColor(Color color) {
        this.m_globalEdgeColor.setColor(color);
    }

    public Vector[] getFaceArray() {
        Vector[] vectorArray = new Vector[this.m_numVertices];
        PgTetraFace pgTetraFace = null;
        int n = 0;
        while (n < this.m_numTetras) {
            int n2 = 0;
            do {
                int[] nArray = this.m_tetra[n].m_data;
                int[] nArray2 = new int[3];
                int n3 = 0;
                do {
                    nArray2[n3] = n3 < n2 ? nArray[n3] : nArray[n3 + 1];
                } while (++n3 < 3);
                int[] nArray3 = new int[3];
                if (nArray2[0] < nArray2[1]) {
                    if (nArray2[1] < nArray2[2]) {
                        nArray3[0] = nArray2[0];
                        nArray3[1] = nArray2[1];
                        nArray3[2] = nArray2[2];
                    } else if (nArray2[0] < nArray2[2]) {
                        nArray3[0] = nArray2[0];
                        nArray3[1] = nArray2[2];
                        nArray3[2] = nArray2[1];
                    } else {
                        nArray3[0] = nArray2[2];
                        nArray3[1] = nArray2[0];
                        nArray3[2] = nArray2[1];
                    }
                } else if (nArray2[0] < nArray2[2]) {
                    nArray3[0] = nArray2[1];
                    nArray3[1] = nArray2[0];
                    nArray3[2] = nArray2[2];
                } else if (nArray2[1] < nArray2[2]) {
                    nArray3[0] = nArray2[1];
                    nArray3[1] = nArray2[2];
                    nArray3[2] = nArray2[0];
                } else {
                    nArray3[0] = nArray2[2];
                    nArray3[1] = nArray2[1];
                    nArray3[2] = nArray2[0];
                }
                if (vectorArray[nArray3[0]] == null) {
                    vectorArray[nArray3[0]] = new Vector();
                }
                boolean bl = false;
                int n4 = 0;
                while (n4 < vectorArray[nArray3[0]].size() && !bl) {
                    pgTetraFace = (PgTetraFace)vectorArray[nArray3[0]].elementAt(n4);
                    if (pgTetraFace.m_vertex[1] == nArray3[1] && pgTetraFace.m_vertex[2] == nArray3[2]) {
                        bl = true;
                    }
                    ++n4;
                }
                if (!bl) {
                    pgTetraFace = new PgTetraFace(nArray3);
                    vectorArray[nArray3[0]].addElement(pgTetraFace);
                }
                pgTetraFace.m_tetra.addElement(new Integer(n));
                pgTetraFace.m_index.addElement(new Integer(n2));
            } while (++n2 < 4);
            ++n;
        }
        return vectorArray;
    }

    public int getNumBoundaryVertices() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_numVertices) {
            if (this.m_vertex[n2].hasTag(13)) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public int getNumEdges() {
        int n = 0;
        if (this.m_neighbour == null) {
            int n2 = 0;
            while (n2 < this.m_numTetras) {
                n += this.m_tetra[n2].getSize();
                ++n2;
            }
            return n;
        }
        int n3 = 0;
        while (n3 < this.m_numTetras) {
            int n4 = 0;
            while (n4 < this.m_tetra[n3].getSize()) {
                if (this.m_neighbour[n3].m_data[n4] < n3) {
                    ++n;
                }
                ++n4;
            }
            ++n3;
        }
        return n;
    }

    public PgElementSet getSurface() {
        Object object;
        Vector[] vectorArray = this.getFaceArray();
        Vector<int[]> vector = new Vector<int[]>();
        int n = 0;
        while (n < this.m_numVertices) {
            if (vectorArray[n] != null) {
                int n2 = 0;
                while (n2 < vectorArray[n].size()) {
                    object = (PgTetraFace)vectorArray[n].elementAt(n2);
                    if (((PgTetraFace)object).m_tetra.size() < 2) {
                        vector.addElement(((PgTetraFace)object).m_vertex);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        PgElementSet pgElementSet = new PgElementSet(3);
        pgElementSet.setNumVertices(this.m_numVertices);
        n = 0;
        while (n < this.m_numVertices) {
            pgElementSet.setVertex(n, (PdVector)this.m_vertex[n].clone());
            Color color = this.m_vertexColor[n];
            pgElementSet.setVertexColor(n, new Color(color.getRed(), color.getGreen(), color.getBlue()));
            ++n;
        }
        pgElementSet.setNumElements(vector.size());
        n = 0;
        object = vector.elements();
        while (object.hasMoreElements()) {
            pgElementSet.setElement(n, (int[])object.nextElement());
            ++n;
        }
        return pgElementSet;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgTetraSet *********\n");
        stringBuffer.append("\t m_numTetras\t\t= " + this.m_numTetras + "\n");
        stringBuffer.append("\t ******* m_tetra *******\n");
        if (this.m_tetra != null) {
            n = 0;
            while (n < this.m_numTetras) {
                stringBuffer.append("\t [" + n + "] = " + this.m_tetra[n].toShortString());
                ++n;
            }
        } else {
            stringBuffer.append("\t m_tetra = null\n");
        }
        stringBuffer.append("\t ******* m_neighbour *******\n");
        if (this.m_neighbour != null) {
            n = 0;
            while (n < this.m_numTetras) {
                stringBuffer.append("\t [" + n + "] = " + this.m_neighbour[n].toShortString());
                ++n;
            }
        } else {
            stringBuffer.append("\t m_neighbour = null\n");
        }
        return stringBuffer.toString();
    }

    public void makeQuadrConn(int n, int n2, int n3) {
        if (n < 2 || n2 < 2 || n3 < 2) {
            return;
        }
        this.setNumElements(6 * (n - 1) * (n2 - 1) * (n3 - 1));
        int n4 = 0;
        int[] nArray = new int[8];
        int n5 = 0;
        while (n5 < n - 1) {
            int n6 = 0;
            while (n6 < n2 - 1) {
                int n7 = 0;
                while (n7 < n3 - 1) {
                    nArray[0] = n5 * n2 * n3 + n6 * n3 + n7;
                    nArray[1] = n5 * n2 * n3 + n6 * n3 + (n7 + 1);
                    nArray[2] = n5 * n2 * n3 + (n6 + 1) * n3 + n7;
                    nArray[3] = n5 * n2 * n3 + (n6 + 1) * n3 + (n7 + 1);
                    nArray[4] = (n5 + 1) * n2 * n3 + n6 * n3 + n7;
                    nArray[5] = (n5 + 1) * n2 * n3 + n6 * n3 + (n7 + 1);
                    nArray[6] = (n5 + 1) * n2 * n3 + (n6 + 1) * n3 + n7;
                    nArray[7] = (n5 + 1) * n2 * n3 + (n6 + 1) * n3 + (n7 + 1);
                    this.m_tetra[n4++].set(nArray[0], nArray[7], nArray[5], nArray[4]);
                    this.m_tetra[n4++].set(nArray[0], nArray[7], nArray[5], nArray[1]);
                    this.m_tetra[n4++].set(nArray[0], nArray[7], nArray[3], nArray[1]);
                    this.m_tetra[n4++].set(nArray[0], nArray[7], nArray[3], nArray[2]);
                    this.m_tetra[n4++].set(nArray[0], nArray[7], nArray[6], nArray[2]);
                    this.m_tetra[n4++].set(nArray[0], nArray[7], nArray[6], nArray[4]);
                    ++n7;
                }
                ++n6;
            }
            ++n5;
        }
        this.makeNeighbour();
    }

    public int getOtherVertexLocInd(int n, int n2, int n3) {
        int n4 = this.m_tetra[n].getSize();
        int n5 = 0;
        while (n5 < n4) {
            if (this.m_tetra[n].m_data[n5] == n2 && this.m_tetra[n].m_data[(n5 + 1) % n4] == n3) {
                return (n5 + n4 - 1) % n4;
            }
            if (this.m_tetra[n].m_data[n5] == n3 && this.m_tetra[n].m_data[(n5 + 1) % n4] == n2) {
                return (n5 + n4 - 1) % n4;
            }
            ++n5;
        }
        PsDebug.error((String)("cannot find edge (" + n2 + "," + n3 + ") in element[" + n + "]"), (Object)((Object)this));
        return -1;
    }

    public PiVector[] getElements() {
        return this.m_tetra;
    }

    public int getMaxNumElements() {
        return this.m_maxNumElements;
    }

    public double getVolume() {
        double d = 0.0;
        int n = 0;
        while (n < this.m_numTetras) {
            d += this.getVolumeOfElement(n);
            ++n;
        }
        return d;
    }

    public int[] removeMarkedElements() {
        int n = 1;
        int n2 = -1;
        PiVector piVector = new PiVector(this.m_numTetras);
        piVector.setConstant(n2);
        int[] nArray = piVector.m_data;
        int n3 = 0;
        while (n3 < this.m_numTetras) {
            if (!this.m_tetra[n3].hasTag(2)) {
                nArray[n3] = n;
            }
            ++n3;
        }
        int n4 = 0;
        n3 = 0;
        while (n3 < this.m_numTetras) {
            if (nArray[n3] == n) {
                nArray[n3] = n4++;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.m_numTetras) {
            if (nArray[n3] != n2) {
                int n5 = 0;
                while (n5 < this.m_tetra[n3].m_data.length) {
                    if (this.m_neighbour[n3].m_data[n5] > -1) {
                        this.m_neighbour[n3].m_data[n5] = nArray[this.m_neighbour[n3].m_data[n5]];
                    }
                    ++n5;
                }
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.m_numTetras) {
            if (nArray[n3] != n2 && nArray[n3] < n3) {
                this.m_tetra[nArray[n3]].setSize(this.m_tetra[n3].getSize());
                this.m_tetra[nArray[n3]].copy(this.m_tetra[n3]);
                this.m_neighbour[nArray[n3]].setSize(this.m_neighbour[n3].getSize());
                this.m_neighbour[nArray[n3]].copy(this.m_neighbour[n3]);
            }
            ++n3;
        }
        if (this.m_elementColor != null) {
            n3 = 0;
            while (n3 < this.m_numTetras) {
                if (nArray[n3] != n2 && nArray[n3] < n3) {
                    this.m_elementColor[nArray[n3]] = this.m_elementColor[n3];
                }
                ++n3;
            }
        }
        this.setNumElements(n4);
        this.setMaxNumElements(n4);
        return nArray;
    }

    public void setElements(PiVector[] piVectorArray) {
        if (piVectorArray == null || piVectorArray.length != this.m_numTetras) {
            PsDebug.warning((String)"void length of element array");
            return;
        }
        int n = 0;
        while (n < piVectorArray.length) {
            if (piVectorArray[n] == null || piVectorArray[n].getSize() != 4) {
                PsDebug.warning((String)("missing or void element in element array at position = " + n));
                return;
            }
            ++n;
        }
        PiVector.copy((PiVector[])this.m_tetra, (int)0, (PiVector[])piVectorArray, (int)0, (int)this.m_numTetras);
        this.assureNeighbours();
    }

    protected void setMaxNumElements(int n) {
        if (this.m_maxNumElements == n) {
            return;
        }
        this.m_tetra = PiVector.realloc((PiVector[])this.m_tetra, (int)n, (int)4);
        this.m_neighbour = PiVector.realloc((PiVector[])this.m_neighbour, (int)n, (int)4);
        if (this.m_elementColor != null) {
            this.m_elementColor = PdColor.realloc((Color[])this.m_elementColor, (int)n);
        }
        this.m_maxNumElements = n;
        if (this.m_maxNumElements < this.m_numTetras) {
            this.m_numTetras = this.m_maxNumElements;
        }
    }

    public void showElements(boolean bl) {
        this.m_showElements = bl;
    }

    public void markBoundary() {
        int n = 0;
        while (n < this.m_numVertices) {
            this.m_vertex[n].clearTag(13);
            ++n;
        }
        if (this.m_neighbour == null || this.m_neighbour.length != this.m_tetra.length) {
            PsDebug.warning((String)"void neighbour connectivity", (Object)((Object)this));
            return;
        }
        n = 0;
        while (n < this.m_numTetras) {
            int n2 = 0;
            do {
                if (this.m_neighbour[n].m_data[n2] >= 0) continue;
                this.m_vertex[this.m_tetra[n].m_data[(n2 + 1) % 4]].setTag(13);
                this.m_vertex[this.m_tetra[n].m_data[(n2 + 2) % 4]].setTag(13);
                this.m_vertex[this.m_tetra[n].m_data[(n2 + 3) % 4]].setTag(13);
            } while (++n2 < 4);
            ++n;
        }
    }

    public void copy(PgGeometry pgGeometry) {
        super.copy(pgGeometry);
        if (!(pgGeometry instanceof PgTetraSet)) {
            return;
        }
        PgTetraSet pgTetraSet = (PgTetraSet)pgGeometry;
        this.setNumElements(pgTetraSet.getNumElements());
        PiVector.copy((PiVector[])this.m_tetra, (int)0, (PiVector[])pgTetraSet.getElements(), (int)0, (int)this.m_numTetras);
        PiVector[] piVectorArray = pgTetraSet.getNeighbours();
        if (piVectorArray != null) {
            PiVector.copy((PiVector[])this.m_neighbour, (int)0, (PiVector[])piVectorArray, (int)0, (int)this.m_numTetras);
        }
        if (pgTetraSet.m_elementColor != null) {
            this.assureElementColors();
            PdColor.copy((Color[])this.m_elementColor, (int)0, (Color[])pgTetraSet.getElementColors(), (int)0, (int)this.m_numTetras);
        }
    }

    public boolean makeNeighbour() {
        if (this.m_numTetras < 1) {
            return true;
        }
        this.assureNeighbours();
        Vector[] vectorArray = this.getFaceArray();
        boolean bl = true;
        int n = 0;
        while (n < this.m_numVertices) {
            if (vectorArray[n] != null) {
                Enumeration enumeration = vectorArray[n].elements();
                while (enumeration.hasMoreElements()) {
                    PgTetraFace pgTetraFace = (PgTetraFace)enumeration.nextElement();
                    int n2 = pgTetraFace.m_tetra.size();
                    int[] nArray = new int[n2];
                    int[] nArray2 = new int[n2];
                    int n3 = 0;
                    while (n3 < n2) {
                        nArray[n3] = (Integer)pgTetraFace.m_tetra.elementAt(n3);
                        nArray2[n3] = (Integer)pgTetraFace.m_index.elementAt(n3);
                        ++n3;
                    }
                    switch (n2) {
                        case 1: {
                            this.m_neighbour[nArray[0]].m_data[nArray2[0]] = -1;
                            break;
                        }
                        case 2: {
                            this.m_neighbour[nArray[0]].m_data[nArray2[0]] = nArray[1];
                            this.m_neighbour[nArray[1]].m_data[nArray2[1]] = nArray[0];
                            break;
                        }
                        default: {
                            this.m_neighbour[nArray[0]].m_data[nArray2[0]] = nArray[1];
                            this.m_neighbour[nArray[1]].m_data[nArray2[1]] = nArray[0];
                            n3 = 2;
                            while (n3 < n2) {
                                this.m_neighbour[nArray[n3]].m_data[nArray2[n3]] = -1;
                                ++n3;
                            }
                            bl = false;
                        }
                        case 0: 
                    }
                }
            }
            ++n;
        }
        return bl;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public double getArea() {
        double d = 0.0;
        int n = 0;
        while (n < this.m_numTetras) {
            int n2 = 0;
            do {
                if (this.m_neighbour[n].m_data[n2] >= 0) continue;
                PdVector[] pdVectorArray = this.getElementVertices(n);
                d += PdVector.area((PdVector)pdVectorArray[(n2 + 1) % 4], (PdVector)pdVectorArray[(n2 + 2) % 4], (PdVector)pdVectorArray[(n2 + 3) % 4]);
            } while (++n2 < 4);
            ++n;
        }
        return d;
    }

    public void refineGlobalIntoEight() {
        int[][] nArrayArray = new int[6][];
        nArrayArray[0] = new int[]{1, 2};
        int[] nArray = new int[2];
        nArray[1] = 2;
        nArrayArray[1] = nArray;
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        nArrayArray[2] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[1] = 3;
        nArrayArray[3] = nArray3;
        nArrayArray[4] = new int[]{1, 3};
        nArrayArray[5] = new int[]{2, 3};
        int[][] nArrayArray2 = nArrayArray;
        Vector<Vector> vector = new Vector<Vector>();
        int n = 0;
        while (n < this.m_numVertices) {
            vector.addElement(null);
            ++n;
        }
        int[] nArray4 = new int[10];
        int n2 = this.m_numTetras;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            do {
                nArray4[n4] = this.m_tetra[n3].m_data[n4];
            } while (++n4 < 4);
            n4 = 4;
            do {
                Vector vector2;
                nArray4[n4] = -1;
                int n5 = nArray4[nArrayArray2[n4 - 4][0]];
                int n6 = nArray4[nArrayArray2[n4 - 4][1]];
                if (n5 > n6) {
                    int n7 = n5;
                    n5 = n6;
                    n6 = n7;
                }
                if (vector.elementAt(n5) == null) {
                    vector2 = new Vector();
                    vector.setElementAt(vector2, n5);
                } else {
                    vector2 = (Vector)vector.elementAt(n5);
                    if (vector2.size() > 0) {
                        Enumeration enumeration = vector2.elements();
                        while (enumeration.hasMoreElements()) {
                            int[] nArray5 = (int[])enumeration.nextElement();
                            if (nArray5[1] != n6) continue;
                            nArray4[n4] = nArray5[0];
                            break;
                        }
                    }
                }
                if (nArray4[n4] != -1) continue;
                nArray4[n4] = this.addVertex(PdVector.blendNew((double)0.5, (PdVector)this.m_vertex[n5], (double)0.5, (PdVector)this.m_vertex[n6]));
                vector2.addElement(new int[]{nArray4[n4], n6});
                vector.addElement(null);
            } while (++n4 < 10);
            this.m_tetra[n3].set(nArray4[0], nArray4[6], nArray4[5], nArray4[7]);
            PiVector piVector = new PiVector(4);
            piVector.set(nArray4[6], nArray4[1], nArray4[4], nArray4[8]);
            this.addElement(piVector);
            piVector.set(nArray4[5], nArray4[4], nArray4[2], nArray4[9]);
            this.addElement(piVector);
            piVector.set(nArray4[5], nArray4[4], nArray4[8], nArray4[9]);
            this.addElement(piVector);
            piVector.set(nArray4[5], nArray4[4], nArray4[8], nArray4[6]);
            this.addElement(piVector);
            piVector.set(nArray4[7], nArray4[8], nArray4[6], nArray4[5]);
            this.addElement(piVector);
            piVector.set(nArray4[7], nArray4[8], nArray4[9], nArray4[5]);
            this.addElement(piVector);
            piVector.set(nArray4[7], nArray4[8], nArray4[9], nArray4[3]);
            this.addElement(piVector);
            ++n3;
        }
        this.makeNeighbour();
        this.update((Object)this);
    }

    public void assureElementColors() {
        if (this.m_elementColor == null || this.m_elementColor.length != this.m_maxNumElements) {
            this.m_elementColor = PdColor.realloc((Color[])this.m_elementColor, (int)this.m_maxNumElements);
        }
    }

    public void init() {
        super.init();
        this.m_bShowVertices = true;
        this.m_elementColor = null;
        this.setMaxNumElements(0);
        this.m_showElements = false;
        this.m_showTaggedElements = false;
        this.m_globalElementColor.setColor(new Color(100, 200, 0));
        this.m_globalElementTagColor.setColor(Color.magenta);
        this.m_showEdges = false;
        this.m_showTaggedEdges = false;
        this.m_globalEdgeColor.setColor(Color.black);
        this.m_globalEdgeTagColor.setColor(Color.red);
        this.m_globalEdgeSize.setDefBounds(0.0, 50.0, 1.0, 5.0);
        this.m_globalEdgeSize.setDefValue(1.0);
        this.m_globalEdgeSize.init();
        this.m_showBoundary = false;
        this.m_showTaggedBoundary = false;
        this.m_globalBndColor.setColor(Color.blue);
        this.m_globalBndTagColor.setColor(Color.magenta);
        this.m_globalBndSize.setDefBounds(0.0, 50.0, 1.0, 5.0);
        this.m_globalBndSize.setDefValue(2.0);
        this.m_globalBndSize.init();
        this.m_showElementNormals = false;
    }

    public Color[] getElementColors() {
        return this.m_elementColor;
    }

    public double getVolumeOfElement(int n) {
        PdVector[] pdVectorArray = this.getElementVertices(n);
        if (pdVectorArray == null || pdVectorArray.length < 4) {
            return 0.0;
        }
        PdVector pdVector = new PdVector(((PgGeometry)this).m_dim);
        pdVector.normalOfPlane(pdVectorArray[0], pdVectorArray[1], pdVectorArray[2]);
        double d = PuVectorGeom.distOfPointToPlane((PdVector)pdVectorArray[3], (PdVector)pdVectorArray[0], (PdVector)pdVector);
        double d2 = PdVector.area((PdVector)pdVectorArray[0], (PdVector)pdVectorArray[1], (PdVector)pdVectorArray[2]);
        return d2 * d / 3.0;
    }

    public boolean isShowingElementColors() {
        return this.m_bShowElementColors;
    }

    public void setElementColors(Color[] colorArray) {
        if (colorArray == null) {
            this.m_elementColor = null;
            return;
        }
        if (colorArray.length != this.m_numTetras) {
            PsDebug.warning((String)"void length of color array");
            return;
        }
        this.assureElementColors();
        PdColor.copy((Color[])this.m_elementColor, (int)0, (Color[])colorArray, (int)0, (int)this.m_numTetras);
    }

    public void showBoundary(boolean bl) {
        this.m_showBoundary = bl;
    }

    public void showElementColors(boolean bl) {
        this.m_bShowElementColors = bl;
    }

    public boolean merge(PgTetraSet pgTetraSet) {
        int n;
        if (pgTetraSet == null) {
            PsDebug.warning((String)"missing argument", (Object)((Object)this));
            return false;
        }
        int n2 = this.m_numVertices;
        if (!super.merge((PgGeometryIf)pgTetraSet)) {
            return false;
        }
        int n3 = this.m_numTetras;
        int n4 = this.m_numTetras + pgTetraSet.m_numTetras;
        this.setNumElements(n4);
        PiVector.copy((PiVector[])this.m_tetra, (int)n3, (PiVector[])pgTetraSet.m_tetra, (int)0, (int)pgTetraSet.m_numTetras);
        int n5 = 0;
        while (n5 < pgTetraSet.m_numTetras) {
            n = 0;
            do {
                int n6 = n++;
                this.m_tetra[n3 + n5].m_data[n6] = this.m_tetra[n3 + n5].m_data[n6] + n2;
            } while (n < 4);
            ++n5;
        }
        if (pgTetraSet.m_neighbour != null) {
            this.assureNeighbours();
            PiVector.copy((PiVector[])this.m_neighbour, (int)n3, (PiVector[])pgTetraSet.m_neighbour, (int)0, (int)pgTetraSet.m_numTetras);
            n5 = 0;
            while (n5 < pgTetraSet.m_numTetras) {
                n = 0;
                do {
                    if (pgTetraSet.m_neighbour[n5].m_data[n] <= -1) continue;
                    int n7 = n;
                    this.m_neighbour[n3 + n5].m_data[n7] = this.m_neighbour[n3 + n5].m_data[n7] + n3;
                } while (++n < 4);
                ++n5;
            }
        }
        if (pgTetraSet.m_elementColor != null) {
            this.assureElementColors();
            PdColor.copy((Color[])this.m_elementColor, (int)n3, (Color[])pgTetraSet.m_elementColor, (int)0, (int)pgTetraSet.m_numTetras);
        }
        return true;
    }

    public PiVector getElement(int n) {
        if (n < 0 || n >= this.m_numTetras) {
            return null;
        }
        return this.m_tetra[n];
    }

    public boolean setElement(int n, int[] nArray) {
        if (nArray == null || nArray.length != 4) {
            PsDebug.warning((String)"element and array have different length");
            return false;
        }
        if (n >= this.m_numTetras) {
            this.setNumElements(n + 1);
        }
        this.m_tetra[n].set(nArray);
        return true;
    }

    public boolean setElement(int n, PiVector piVector) {
        if (n < 0 || piVector == null) {
            PsDebug.error((String)"index out of range, corrupt argument", (Object)((Object)this));
            return false;
        }
        if (n >= this.m_numTetras) {
            PsDebug.warning((String)("index=" + n + " > " + this.m_numTetras + "=m_numTetras, bad programming style"), (Object)((Object)this));
            this.setNumElements(n + 1);
        }
        this.m_tetra[n].copy(piVector);
        return true;
    }

    public boolean setElement(int n, int n2, int n3, int n4, int n5) {
        if (n >= this.m_numTetras) {
            this.setNumElements(n + 1);
        }
        this.m_tetra[n].m_data[0] = n2;
        this.m_tetra[n].m_data[1] = n3;
        this.m_tetra[n].m_data[2] = n4;
        this.m_tetra[n].m_data[3] = n5;
        return true;
    }

    public void assureNeighbours() {
        this.m_neighbour = PiVector.realloc((PiVector[])this.m_neighbour, (int)this.m_maxNumElements, (int)4);
        int n = 0;
        while (n < this.m_maxNumElements) {
            this.m_neighbour[n].setConstant(-1);
            ++n;
        }
    }

    public PiVector[] getNeighbours() {
        return this.m_neighbour;
    }

    public PdVector[] getElementVertices(int n) {
        if (n < 0 || this.m_numTetras <= n) {
            PsDebug.warning((String)("elemInd out of bounds, elemInd = " + n));
            return null;
        }
        if (this.m_tetra[n].getSize() == 0) {
            return null;
        }
        int n2 = this.m_tetra[n].getSize();
        PdVector[] pdVectorArray = new PdVector[n2];
        --n2;
        while (n2 >= 0) {
            pdVectorArray[n2] = this.m_vertex[this.m_tetra[n].m_data[n2]];
            --n2;
        }
        return pdVectorArray;
    }

    public int[] removeMarkedVertices() {
        int n = -1;
        int[] nArray = super.removeMarkedVertices();
        int n2 = 0;
        while (n2 < this.m_numTetras) {
            int n3 = this.m_tetra[n2].getSize() - 1;
            while (n3 >= 0) {
                if (nArray[this.m_tetra[n2].m_data[n3]] == n) {
                    this.m_tetra[n2].setTag(2);
                    break;
                }
                this.m_tetra[n2].m_data[n3] = nArray[this.m_tetra[n2].m_data[n3]];
                --n3;
            }
            ++n2;
        }
        this.removeMarkedElements();
        return nArray;
    }

    public boolean removeUnusedVertices() {
        int n;
        int n2 = 1;
        int n3 = -1;
        PiVector piVector = new PiVector(this.m_numVertices);
        piVector.setConstant(n3);
        int[] nArray = piVector.m_data;
        int n4 = 0;
        while (n4 < this.m_numTetras) {
            n = 0;
            while (n < this.m_tetra[n4].m_data.length) {
                nArray[this.m_tetra[n4].m_data[n]] = n2;
                ++n;
            }
            ++n4;
        }
        int n5 = 0;
        n4 = 0;
        while (n4 < this.m_numVertices) {
            if (nArray[n4] == n2) {
                nArray[n4] = n5++;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < this.m_numVertices) {
            if (nArray[n4] != n3 && nArray[n4] < n4) {
                this.m_vertex[nArray[n4]] = this.m_vertex[n4];
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < this.m_numTetras) {
            n = 0;
            while (n < this.m_tetra[n4].m_data.length) {
                this.m_tetra[n4].m_data[n] = nArray[this.m_tetra[n4].m_data[n]];
                ++n;
            }
            ++n4;
        }
        if (this.m_vertexNormal != null) {
            n4 = 0;
            while (n4 < this.m_numVertices) {
                if (nArray[n4] != n3 && nArray[n4] < n4) {
                    this.m_vertexNormal[nArray[n4]] = this.m_vertexNormal[n4];
                }
                ++n4;
            }
        }
        if (this.m_vertexColor != null) {
            n4 = 0;
            while (n4 < this.m_numVertices) {
                if (nArray[n4] != n3 && nArray[n4] < n4) {
                    this.m_vertexColor[nArray[n4]] = this.m_vertexColor[n4];
                }
                ++n4;
            }
        }
        if (this.m_vertexTexture != null) {
            n4 = 0;
            while (n4 < this.m_numVertices) {
                if (nArray[n4] != n3 && nArray[n4] < n4) {
                    this.m_vertexTexture[nArray[n4]] = this.m_vertexTexture[n4];
                }
                ++n4;
            }
        }
        this.setNumVertices(n5);
        this.setMaxNumVertices(n5);
        return true;
    }

    public boolean setElementVertices(int n, PdVector[] pdVectorArray) {
        int n2 = this.m_tetra[n].getSize();
        if (n2 != pdVectorArray.length) {
            PsDebug.warning((String)"element and array have different length", (Object)((Object)this));
            return false;
        }
        --n2;
        while (n2 >= 0) {
            this.m_vertex[this.m_tetra[n].m_data[n2]] = pdVectorArray[n2];
            --n2;
        }
        return true;
    }

    public void showEdges(boolean bl) {
        this.m_showEdges = bl;
    }

    public boolean update(Object object) {
        if (object == null) {
            return super.update(null);
        }
        if (object == this.m_globalBndColor) {
            return super.update(null);
        }
        if (object == this.m_globalBndTagColor) {
            return super.update(null);
        }
        if (object == this.m_globalBndSize) {
            return super.update(null);
        }
        if (object == this.m_globalEdgeColor) {
            return super.update(null);
        }
        if (object == this.m_globalEdgeTagColor) {
            return super.update(null);
        }
        if (object == this.m_globalEdgeSize) {
            return super.update(null);
        }
        if (object == this.m_globalElementColor) {
            return super.update(null);
        }
        if (object == this.m_globalElementTagColor) {
            return super.update(null);
        }
        return super.update(object);
    }

    public int getOppVertexLocInd(int n, int n2) {
        if (this.m_neighbour == null) {
            PsDebug.error((String)"missing neighbour variable", (Object)((Object)this));
            return -1;
        }
        int n3 = this.m_neighbour[n].m_data[n2];
        if (n3 == -1) {
            return -1;
        }
        int n4 = this.m_neighbour[n3].getSize() - 1;
        while (n4 >= 0) {
            if (this.m_neighbour[n3].m_data[n4] == n) {
                return n4;
            }
            --n4;
        }
        PsDebug.error((String)"error in neighb. connectivity", (Object)((Object)this));
        return -1;
    }

    public PiVector[] getFaceList() {
        Vector[] vectorArray = this.getFaceArray();
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_numVertices) {
            if (vectorArray[n2] != null) {
                n += vectorArray[n2].size();
            }
            ++n2;
        }
        PiVector[] piVectorArray = new PiVector[n];
        n = 0;
        int n3 = 0;
        while (n3 < this.m_numVertices) {
            if (vectorArray[n3] != null) {
                int n4 = 0;
                while (n4 < vectorArray[n3].size()) {
                    PgTetraFace pgTetraFace = (PgTetraFace)vectorArray[n3].elementAt(n4);
                    int[] nArray = pgTetraFace.m_vertex;
                    piVectorArray[n++] = new PiVector(nArray[0], nArray[1], nArray[2]);
                    ++n4;
                }
            }
            ++n3;
        }
        return piVectorArray;
    }

    public void buildQuadr(PdVector[] pdVectorArray, int n, int n2, int n3) {
        if (pdVectorArray == null || pdVectorArray.length < 8) {
            PsDebug.error((String)"no initial vertices or wrong number", (Object)((Object)this));
            return;
        }
        this.setNumVertices(n * n2 * n3);
        PdVector pdVector = new PdVector(((PgGeometry)this).m_dim);
        PdVector pdVector2 = new PdVector(((PgGeometry)this).m_dim);
        PdVector pdVector3 = new PdVector(((PgGeometry)this).m_dim);
        PdVector pdVector4 = new PdVector(((PgGeometry)this).m_dim);
        PdVector pdVector5 = new PdVector(((PgGeometry)this).m_dim);
        PdVector pdVector6 = new PdVector(((PgGeometry)this).m_dim);
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            double d = (double)n5 / ((double)n - 1.0);
            pdVector.blend(1.0 - d, pdVectorArray[0], d, pdVectorArray[4]);
            pdVector2.blend(1.0 - d, pdVectorArray[1], d, pdVectorArray[5]);
            pdVector3.blend(1.0 - d, pdVectorArray[2], d, pdVectorArray[6]);
            pdVector4.blend(1.0 - d, pdVectorArray[3], d, pdVectorArray[7]);
            int n6 = 0;
            while (n6 < n2) {
                double d2 = (double)n6 / ((double)n2 - 1.0);
                pdVector5.blend(1.0 - d2, pdVector, d2, pdVector3);
                pdVector6.blend(1.0 - d2, pdVector2, d2, pdVector4);
                int n7 = 0;
                while (n7 < n3) {
                    double d3 = (double)n7 / ((double)n3 - 1.0);
                    this.m_vertex[n4++].blend(1.0 - d3, pdVector5, d3, pdVector6);
                    ++n7;
                }
                ++n6;
            }
            ++n5;
        }
        this.makeQuadrConn(n, n2, n3);
    }

    public void showElementNormals(boolean bl) {
        this.m_showElementNormals = bl;
    }

    public boolean checkNeighbour() {
        boolean bl = this.checkNeighbour(null);
        if (bl) {
            PsDebug.message((String)"Neighbourhood information is correct.");
        }
        return bl;
    }

    public boolean checkNeighbour(Vector vector) {
        if (this.m_neighbour == null) {
            PsDebug.warning((String)"Missing neighbour information.");
            return false;
        }
        if (vector != null && vector.size() != this.m_numTetras) {
            PsDebug.warning((String)("Vector \"neighbours\" has length " + vector.size() + ", but number of tetrahedrons is " + this.m_numTetras + "."));
            return false;
        }
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        while (n < this.m_numTetras) {
            int n2 = 0;
            do {
                int n3;
                int n4;
                int n5;
                int n6;
                int n7 = this.m_neighbour[n].m_data[n2];
                int[][] nArray = null;
                if (vector != null) {
                    nArray = (int[][])vector.elementAt(n);
                }
                if (n7 == -1) continue;
                if (n7 == n || nArray != null && (nArray[n2][0] == n || nArray[n2][1] == n || nArray[n2][2] == n)) {
                    bl = false;
                    stringBuffer.append("\n\tTetrahedron has itself as neighbour\n");
                    stringBuffer.append("\t\tTetrahedron " + n + " (" + this.m_tetra[n].m_data[0] + ", " + this.m_tetra[n].m_data[1] + ", " + this.m_tetra[n].m_data[2] + ", " + this.m_tetra[n].m_data[3] + ") with neighbours " + this.m_neighbour[n].m_data[0] + ", " + this.m_neighbour[n].m_data[1] + ", " + this.m_neighbour[n].m_data[2] + ", " + this.m_neighbour[n].m_data[3] + ".\n");
                    continue;
                }
                int n8 = -1;
                Object object = null;
                if (vector != null) {
                    object = (int[][])vector.elementAt(n7);
                }
                int n9 = 0;
                while (n9 < 4 && n8 == -1) {
                    if (this.m_neighbour[n7].m_data[n9] == n) {
                        n8 = n9;
                        break;
                    }
                    if (object != null) {
                        n6 = 0;
                        do {
                            if (object[n9][n6] != n) continue;
                            n8 = n9;
                            break;
                        } while (++n6 < 3);
                    }
                    ++n9;
                }
                if (n8 == -1) {
                    bl = false;
                    stringBuffer.append("\n\tTwo adjacent tetrahedrons do not reference each other.\n\t\tTetrahedron " + n + " (" + this.m_tetra[n].m_data[0] + ", " + this.m_tetra[n].m_data[1] + ", " + this.m_tetra[n].m_data[2] + ", " + this.m_tetra[n].m_data[3] + ") with neighbours " + this.m_neighbour[n].m_data[0] + ", " + this.m_neighbour[n].m_data[1] + ", " + this.m_neighbour[n].m_data[2] + ", " + this.m_neighbour[n].m_data[3] + " at face opposite to vertex " + this.m_tetra[n].m_data[n2] + ".\n\t\tTetrahedron " + n7 + " (" + this.m_tetra[n7].m_data[0] + ", " + this.m_tetra[n7].m_data[1] + ", " + this.m_tetra[n7].m_data[2] + ", " + this.m_tetra[n7].m_data[3] + ") with neighbours " + this.m_neighbour[n7].m_data[0] + ", " + this.m_neighbour[n7].m_data[1] + ", " + this.m_neighbour[n7].m_data[2] + ", " + this.m_neighbour[n7].m_data[3] + " does not reference back.\n");
                    continue;
                }
                if (nArray != null) {
                    n9 = 0;
                    do {
                        n8 = -1;
                        object = nArray[n2][n9] != -1 ? (int[][])vector.elementAt(nArray[n2][n9]) : null;
                        n6 = 0;
                        while (n6 < 4 && n8 == -1) {
                            if (nArray[n2][n9] != -1 && this.m_neighbour[nArray[n2][n9]].m_data[n6] == n) {
                                n8 = n6;
                                break;
                            }
                            if (object != null) {
                                n5 = 0;
                                do {
                                    if (object[n6][n5] != n) continue;
                                    n8 = n6;
                                    break;
                                } while (++n5 < 3);
                            }
                            ++n6;
                        }
                        if (n8 != -1 || nArray[n2][n9] == -1) continue;
                        bl = false;
                        stringBuffer.append("\n\tTwo adjacent tetrahedrons do not reference each other.\n\t\tTetrahedron " + n + " (" + this.m_tetra[n].m_data[0] + ", " + this.m_tetra[n].m_data[1] + ", " + this.m_tetra[n].m_data[2] + ", " + this.m_tetra[n].m_data[3] + ") with neighbours " + this.m_neighbour[n].m_data[0] + ", " + this.m_neighbour[n].m_data[1] + ", " + this.m_neighbour[n].m_data[2] + ", " + this.m_neighbour[n].m_data[3] + " at face opposite to vertex " + this.m_tetra[n].m_data[n2] + ".\n");
                        if (nArray[n2][n9] == -1) continue;
                        stringBuffer.append("\t\tTetrahedron " + nArray[n2][n9] + " (" + this.m_tetra[nArray[n2][n9]].m_data[0] + ", " + this.m_tetra[nArray[n2][n9]].m_data[1] + ", " + this.m_tetra[nArray[n2][n9]].m_data[2] + ", " + this.m_tetra[nArray[n2][n9]].m_data[3] + ") with neighbours " + this.m_neighbour[nArray[n2][n9]].m_data[0] + ", " + this.m_neighbour[nArray[n2][n9]].m_data[1] + ", " + this.m_neighbour[nArray[n2][n9]].m_data[2] + ", " + this.m_neighbour[nArray[n2][n9]].m_data[3] + " does not reference back.\n");
                    } while (++n9 < 3);
                }
                if (vector != null) continue;
                int[] nArray2 = new int[]{-1, -1, -1, -1};
                n6 = 0;
                block7: do {
                    n5 = this.m_tetra[n].m_data[n6];
                    n4 = 0;
                    do {
                        if (nArray2[n4] == -1) {
                            nArray2[n4] = n5;
                            continue block7;
                        }
                        if (n5 >= nArray2[n4]) continue;
                        n3 = 3;
                        while (n3 > n4) {
                            nArray2[n3] = nArray2[n3 - 1];
                            --n3;
                        }
                        nArray2[n4] = n5;
                        continue block7;
                    } while (++n4 < 4);
                } while (++n6 < 4);
                if (nArray2[3] == -1) {
                    bl = false;
                    stringBuffer.append("\n\tTetrahedron with double vertex found.\n\t\tTetrahedron " + n + " (" + this.m_tetra[n].m_data[0] + ", " + this.m_tetra[n].m_data[1] + ", " + this.m_tetra[n].m_data[2] + ", " + this.m_tetra[n].m_data[3] + ").\n");
                    continue;
                }
                n6 = 0;
                n5 = 0;
                block10: do {
                    n4 = this.m_tetra[n7].m_data[n5];
                    n3 = 0;
                    do {
                        if (n4 != nArray2[n3]) continue;
                        ++n6;
                        nArray2[n3] = -1;
                        continue block10;
                    } while (++n3 < 4);
                } while (++n5 < 4);
                if (n6 == 4) {
                    bl = false;
                    stringBuffer.append("\n\tTwo identical tetrahedrons found.\n\t\tTetrahedron " + n + " (" + this.m_tetra[n].m_data[0] + ", " + this.m_tetra[n].m_data[1] + ", " + this.m_tetra[n].m_data[2] + ", " + this.m_tetra[n].m_data[3] + ").\n" + "\t\tTetrahedron " + n7 + " (" + this.m_tetra[n7].m_data[0] + ", " + this.m_tetra[n7].m_data[1] + ", " + this.m_tetra[n7].m_data[2] + ", " + this.m_tetra[n7].m_data[3] + ").\n");
                    continue;
                }
                if (n6 >= 3) continue;
                bl = false;
                stringBuffer.append("\n\tTwo adjacent tetrahedrons reference each other but have no common face.\n\t\tTetrahedron " + n + " (" + this.m_tetra[n].m_data[0] + ", " + this.m_tetra[n].m_data[1] + ", " + this.m_tetra[n].m_data[2] + ", " + this.m_tetra[n].m_data[3] + ") " + " with neighbours " + this.m_neighbour[n].m_data[0] + ", " + this.m_neighbour[n].m_data[1] + ", " + this.m_neighbour[n].m_data[2] + ", " + this.m_neighbour[n].m_data[3] + ".\n" + "\t\tTetrahedron " + n7 + " (" + this.m_tetra[n7].m_data[0] + ", " + this.m_tetra[n7].m_data[1] + ", " + this.m_tetra[n7].m_data[2] + ", " + this.m_tetra[n7].m_data[3] + ") " + " with neighbours " + this.m_neighbour[n7].m_data[0] + ", " + this.m_neighbour[n7].m_data[1] + ", " + this.m_neighbour[n7].m_data[2] + ", " + this.m_neighbour[n7].m_data[3] + ".\n");
            } while (++n2 < 4);
            ++n;
        }
        if (!bl) {
            PsDebug.warning((String)stringBuffer.toString());
        }
        return bl;
    }

    public int getElementWithEdge(int n, int n2) {
        int n3 = 0;
        while (n3 < this.m_numTetras) {
            int n4 = this.m_tetra[n3].m_data.length;
            int n5 = 0;
            while (n5 < n4 - 1) {
                int n6 = n5 + 1;
                while (n6 < n4) {
                    if (this.m_tetra[n3].m_data[n5] == n && this.m_tetra[n3].m_data[n6] == n2 || this.m_tetra[n3].m_data[n5] == n2 && this.m_tetra[n3].m_data[n6] == n) {
                        return n3;
                    }
                    ++n6;
                }
                ++n5;
            }
            ++n3;
        }
        return -1;
    }

    public PgTetraSet() {
        this(3);
    }

    public PgTetraSet(int n) {
        super(n);
        this.m_neighbour = new PiVector[0];
        this.m_globalElementColor = new PdColor("Face", (PsUpdateIf)this);
        this.m_globalElementTagColor = new PdColor("Face Tag", (PsUpdateIf)this);
        this.m_globalEdgeColor = new PdColor("Edge", (PsUpdateIf)this);
        this.m_globalEdgeTagColor = new PdColor("Edge Tag", (PsUpdateIf)this);
        this.m_globalEdgeSize = new PuDouble("Edge Size", (PsUpdateIf)this);
        this.m_globalBndColor = new PdColor("Boundary", (PsUpdateIf)this);
        this.m_globalBndTagColor = new PdColor("Boundary Tag", (PsUpdateIf)this);
        this.m_globalBndSize = new PuDouble("Boundary Size", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$dev$app$tetraset$PgTetraSet != null ? class$dev$app$tetraset$PgTetraSet : (class$dev$app$tetraset$PgTetraSet = PgTetraSet.class$("dev.app.tetraset.PgTetraSet")))) {
            this.init();
        }
    }

    public void paint(PvGeometryIf pvGeometryIf) {
        super.paint(pvGeometryIf);
        pvGeometryIf.setState(52, this.m_showEdges);
        if (this.m_showEdges) {
            if (this.m_globalEdgeSize != null) {
                pvGeometryIf.setGlobalEdgeSize(this.m_globalEdgeSize.getValue());
            }
            if (this.m_globalEdgeColor != null) {
                pvGeometryIf.setGlobalEdgeColor(this.m_globalEdgeColor.getColor());
            }
        }
        pvGeometryIf.setState(54, this.m_showBoundary);
        if (this.m_showBoundary) {
            if (this.m_globalBndSize != null) {
                pvGeometryIf.setGlobalPolygonSize(this.m_globalBndSize.getValue());
            }
            if (this.m_globalBndColor != null) {
                pvGeometryIf.setGlobalPolygonColor(this.m_globalBndColor.getColor());
            }
        }
        pvGeometryIf.setState(56, this.m_showElements);
        if (this.m_showEdges) {
            PiVector[] piVectorArray = this.getFaceList();
            pvGeometryIf.setNumElements(piVectorArray.length);
            pvGeometryIf.setElements(piVectorArray);
            pvGeometryIf.setElementColors(this.m_elementColor);
        }
        pvGeometryIf.setNeighbours(null);
        pvGeometryIf.setState(62, this.m_showElementNormals);
        pvGeometryIf.setGlobalElementColor(this.m_globalElementColor.getColor());
        pvGeometryIf.setState(94, this.m_bShowElementColors);
    }

    public boolean blend(double d, PgGeometry pgGeometry, double d2, PgGeometry pgGeometry2) {
        if (!super.blend(d, pgGeometry, d2, pgGeometry2)) {
            return false;
        }
        if (!(pgGeometry instanceof PgTetraSet)) {
            return false;
        }
        PgTetraSet pgTetraSet = (PgTetraSet)pgGeometry;
        PgTetraSet pgTetraSet2 = (PgTetraSet)pgGeometry2;
        if (pgTetraSet.m_numTetras != pgTetraSet2.m_numTetras) {
            PsDebug.warning((String)"unequal number of elements", (Object)((Object)this));
            return false;
        }
        this.setNumElements(pgTetraSet.m_numTetras);
        int n = 0;
        while (n < this.m_numTetras) {
            this.m_tetra[n].copy(pgTetraSet.m_tetra[n]);
            if (pgTetraSet.m_neighbour != null) {
                this.m_neighbour[n].copy(pgTetraSet.m_neighbour[n]);
            }
            ++n;
        }
        if (pgTetraSet.m_elementColor != null && pgTetraSet2.m_elementColor != null) {
            this.m_elementColor = PdColor.realloc((Color[])this.m_elementColor, (int)this.m_numTetras);
            n = 0;
            while (n < this.m_numTetras) {
                this.m_elementColor[n] = PdColor.blend((double)d, (Color)pgTetraSet.m_elementColor[n], (double)d2, (Color)pgTetraSet2.m_elementColor[n]);
                ++n;
            }
        }
        return true;
    }

    public Color getElementColor(int n) {
        if (n < 0 || n >= this.m_numTetras) {
            return null;
        }
        return this.m_elementColor[n];
    }

    public void getGlobalBndColor() {
        this.m_globalBndColor.getColor();
    }

    public int[] removeElement(int n) {
        this.m_tetra[n].setTag(2);
        return this.removeMarkedElements();
    }

    public boolean setElementColor(int n, Color color) {
        if (n < 0 || n >= this.m_numTetras) {
            PsDebug.warning((String)("index=" + n + " out of range"), (Object)((Object)this));
            return false;
        }
        if (color == null) {
            PsDebug.warning((String)"missing argument", (Object)((Object)this));
            return false;
        }
        this.assureElementColors();
        this.m_elementColor[n] = color;
        return true;
    }

    public void setGlobalBndColor(Color color) {
        this.m_globalBndColor.setColor(color);
    }

    public void setTagElement(int n, int n2) {
        if (n < 0 || n > this.m_numTetras - 1) {
            PsDebug.warning((String)("index=" + n + " out of range"));
            return;
        }
        this.m_tetra[n].setTag(n2);
    }

    public double getVertexAngle(int n, int n2) {
        int n3 = this.m_tetra[n].getSize();
        PdVector pdVector = this.m_vertex[this.m_tetra[n].m_data[n2]];
        PdVector pdVector2 = this.m_vertex[this.m_tetra[n].m_data[(n2 + 1) % n3]];
        PdVector pdVector3 = this.m_vertex[this.m_tetra[n].m_data[(n2 - 1 + n3) % n3]];
        return PdVector.angle((PdVector)pdVector, (PdVector)pdVector2, (PdVector)pdVector3);
    }

    public void setJvx(PgJvxSrc pgJvxSrc) {
        super.setJvx(pgJvxSrc);
        this.showElements(pgJvxSrc.isShowingElements());
        PiVector.getSameSize((PiVector[])pgJvxSrc.getElements(), (int)pgJvxSrc.getNumElements());
        this.setNumElements(pgJvxSrc.getNumElements());
        this.setElements(pgJvxSrc.getElements());
        this.makeNeighbour();
        if (pgJvxSrc.getGlobalElementColor() != null) {
            this.setGlobalElementColor(pgJvxSrc.getGlobalElementColor());
        }
        this.showEdges(pgJvxSrc.isShowingEdges());
        if (pgJvxSrc.getGlobalEdgeColor() != null) {
            this.setGlobalEdgeColor(pgJvxSrc.getGlobalEdgeColor());
        }
    }
}

