/*
 * Decompiled with CFR 0.152.
 */
package dev.app.vector.vectorfield2;

import dev.app.vector.vectorfield2.PjVectorfield2;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Date;
import jv.object.PsConfig;
import jv.object.PsMainFrame;
import jv.project.PjProject;
import jv.viewer.PvViewer;

public class PaVectorfield2
extends Applet
implements Runnable {
    protected int[] m_frameSize = new int[]{420, 5, 640, 550};
    public Frame m_frame = null;
    protected PvViewer m_viewer;
    private long m_initTime = new Date().getTime();
    private boolean m_bRunCompleted = false;
    private String m_drawString = "Initializing ...";
    private static String m_defaultModel = "models/primitive/cube.byu";
    protected String[][] m_parm = new String[][]{{"ProjectPanel", "String", "Show", "Show models selection panel, i.e. project panel"}, {"Model", "String", m_defaultModel, "Relative name of BYU geometry file"}, {"Console", "String", "Hide", "Show/Hide VGP-console for debugging"}, {"Control", "String", "Hide", "Show/Hide control panel"}, {"Frame", "String", "Hide", "Show/Hide frame around applet"}, {"Panel", "String", "Project", "Name of initial panel if control panel is showing"}, {"Select", "String", "Import Model", "Name of default project"}, {"Project1", "String", "Import Model; jv.viewer.PjImportModel", "Default project"}};

    public void stop() {
        if (this.m_viewer != null) {
            this.m_viewer.stop();
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.blue);
        graphics.drawString(PsConfig.getProgram() + " v." + PsConfig.getVersion(), 20, 40);
        graphics.drawString(this.m_drawString, 20, 60);
    }

    public String[][] getParameterInfo() {
        return this.m_parm;
    }

    public void destroy() {
        if (this.m_viewer != null) {
            this.m_viewer.destroy();
        }
    }

    private void drawMessage(String string) {
        this.m_drawString = string;
        this.repaint();
    }

    public static void main(String[] stringArray) {
        PaVectorfield2 paVectorfield2 = new PaVectorfield2();
        PsMainFrame psMainFrame = new PsMainFrame((Component)paVectorfield2, stringArray);
        paVectorfield2.m_frame = psMainFrame;
        paVectorfield2.init();
        paVectorfield2.start();
        psMainFrame.pack();
        psMainFrame.setBounds(new Rectangle(420, 5, 640, 550));
        psMainFrame.setVisible(true);
    }

    public void start() {
        if (this.m_bRunCompleted && this.m_viewer != null) {
            this.m_viewer.start();
        }
    }

    public String getAppletInfo() {
        return "Name: " + this.getClass().getName() + "\r\n" + "Author: Eike Preuss\r\n" + "Version: 1.00\r\n" + "Continous discrete vectorfields" + "\r\n";
    }

    public void run() {
        this.drawMessage("Loading viewer ...");
        this.m_viewer = new PvViewer((Applet)this, this.m_frame);
        this.drawMessage("Loading vectorfield project ...");
        PjVectorfield2 pjVectorfield2 = new PjVectorfield2();
        this.m_viewer.addProject((PjProject)pjVectorfield2);
        this.m_viewer.selectProject(pjVectorfield2.getName());
        String string = this.m_viewer.getParameter("Model");
        if (string == null) {
            string = m_defaultModel;
        }
        this.drawMessage("Loading " + string + " ...");
        if (!PsConfig.isApplication()) {
            pjVectorfield2.load(PsConfig.getCodeBase() + string);
        } else if (pjVectorfield2.load(string)) {
            PsConfig.getFrame().setTitle(string);
        }
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)this.m_viewer.getDisplay());
        if ("Show".equals(this.m_viewer.getParameter("ProjectPanel"))) {
            this.add("East", this.m_viewer.getPanel(10));
        }
        this.validate();
        this.m_viewer.showPanel(13);
        this.m_bRunCompleted = true;
        this.start();
        System.out.println("Applet loading completed after " + (new Date().getTime() - this.m_initTime) + "ms");
    }

    public void init() {
        Thread thread = new Thread((Runnable)this, "JavaView: inititialize applet");
        thread.setPriority(5);
        thread.start();
    }
}

