/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.geom.PgElementSet;
import jv.geom.PgPolygon;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;
import jvx.geom.PwBary;

public class PgPolygonOnElementSet
extends PsObject {
    public static double BARYEPS = 0.005;
    public double m_eps = BARYEPS;
    protected PgElementSet m_geom;
    protected int m_maxNum;
    protected int m_size;
    protected PiVector m_elem;
    protected PdBary[] m_pos;

    public void setNumVertices(int n) {
        if (n > this.m_maxNum) {
            this.setMaxNumVertices(n);
        }
        this.m_size = n;
    }

    public int getNumVertices() {
        return this.m_size;
    }

    public void addPolygon(PgPolygonOnElementSet pgPolygonOnElementSet) {
        int n = this.m_size;
        this.setNumVertices(n + pgPolygonOnElementSet.getNumVertices());
        PiVector piVector = pgPolygonOnElementSet.getElemInd();
        PdBary[] pdBaryArray = pgPolygonOnElementSet.getBary();
        int n2 = n;
        while (n2 < this.m_size) {
            this.setVertex(n2, piVector.m_data[n2 - n], pdBaryArray[n2 - n]);
            ++n2;
        }
    }

    public PiVector getElemInd() {
        return this.m_elem;
    }

    public int getElemInd(int n) {
        if (n >= this.m_size || n < 0) {
            PsDebug.warning((String)("Array index out of bounds: " + n + "."));
            return -1;
        }
        return this.m_elem.m_data[n];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgPolygonOnElementSet ******\n");
        stringBuffer.append("\t m_size = " + this.m_size + "\n");
        stringBuffer.append("\t ******* m_elem *******\n");
        if (this.m_elem != null && this.m_size > 0) {
            stringBuffer.append("\t m_elem = " + this.m_elem.toShortString());
        } else {
            stringBuffer.append("\t m_elem = null\n");
        }
        stringBuffer.append("\t ******* m_pos *******\n");
        if (this.m_pos != null && this.m_size > 0) {
            int n = 0;
            while (n < this.m_size) {
                stringBuffer.append("\t [" + n + "] = " + this.m_pos[n].toShortString());
                ++n;
            }
        } else {
            stringBuffer.append("\t m_pos = null\n");
        }
        return stringBuffer.toString();
    }

    public PgPolygonOnElementSet(PgElementSet pgElementSet) {
        this.m_geom = pgElementSet;
        this.m_size = 0;
        this.m_elem = new PiVector(0);
        this.m_pos = null;
    }

    public void setVertex(int n, int n2, PdBary pdBary) {
        if (pdBary == null) {
            PsDebug.warning((String)"Missing coordinates.");
            return;
        }
        if (n >= this.m_size) {
            PsDebug.warning((String)("Array index out of bounds: " + n + "."));
            return;
        }
        this.m_pos[n].copy(pdBary);
        this.m_elem.m_data[n] = n2;
    }

    public PdBaryDir exp(int n, PdBary pdBary, PdBaryDir pdBaryDir, double d) {
        return this.exp(n, pdBary, pdBaryDir, d, null);
    }

    public PdBaryDir exp(int n, PdBary pdBary, PdBaryDir pdBaryDir, double d, PgPolygon pgPolygon) {
        int n2;
        if (this.m_geom == null) {
            PsDebug.warning((String)"Missing element set.");
            return null;
        }
        if (pdBary == null || pdBary.getSize() != 3) {
            PsDebug.warning((String)"No valid initial barycentric point.");
            return null;
        }
        if (n < 0 || n >= this.m_geom.getNumElements()) {
            PsDebug.warning((String)("Not a valid initial element index " + n + "."));
            return null;
        }
        int n3 = n2 = 100;
        if (pgPolygon != null) {
            pgPolygon.setNumVertices(n3);
        }
        this.setNumVertices(n3);
        PiVector[] piVectorArray = this.m_geom.getElements();
        PdBary pdBary2 = new PdBary(3);
        pdBary2.copy(pdBary);
        int n4 = n;
        PdVector pdVector = new PdVector(3);
        double d2 = 0.0;
        int n5 = 0;
        if (pgPolygon != null) {
            PdBary.getVertex((PdVector)pdVector, (PdBary)pdBary2, (PdVector)this.m_geom.getVertex(piVectorArray[n4].m_data[0]), (PdVector)this.m_geom.getVertex(piVectorArray[n4].m_data[1]), (PdVector)this.m_geom.getVertex(piVectorArray[n4].m_data[2]));
            pgPolygon.setVertex(n5, pdVector);
        }
        this.setVertex(n5, n4, pdBary2);
        if (d < 0.0) {
            PsDebug.warning((String)("Not a valid length " + d + "."));
            if (pgPolygon != null) {
                pgPolygon.setNumVertices(1);
            }
            this.setNumVertices(1);
            return null;
        }
        if (pdBaryDir == null || pdBaryDir.getSize() != 3) {
            PsDebug.warning((String)"No valid initial barycentric direction.");
            if (pgPolygon != null) {
                pgPolygon.setNumVertices(1);
            }
            this.setNumVertices(1);
            return null;
        }
        double d3 = 1.0E-10;
        double d4 = PwBary.norm(this.m_geom, n, pdBaryDir, true);
        if (d4 < d3) {
            PsDebug.warning((String)"No (valid) direction.");
            if (pgPolygon != null) {
                pgPolygon.setNumVertices(1);
            }
            this.setNumVertices(1);
            return null;
        }
        double d5 = d * d4;
        PdBaryDir pdBaryDir2 = new PdBaryDir(3);
        pdBaryDir2.copy(pdBaryDir);
        pdBaryDir2.multScalar(1.0 / d4);
        if (d5 < d3) {
            if (pgPolygon != null) {
                pgPolygon.setNumVertices(1);
            }
            this.setNumVertices(1);
            return pdBaryDir2;
        }
        boolean bl = false;
        while (d2 < d5 && !bl) {
            double d6;
            int n6 = -1;
            int n7 = -1;
            int n8 = 0;
            int n9 = 0;
            do {
                if (Math.abs(pdBary2.m_data[n9]) > this.m_eps) {
                    n6 = n9;
                    continue;
                }
                ++n8;
                n7 = n9;
            } while (++n9 < 3);
            if (n8 == 2) {
                if (pdBaryDir2.m_data[n6] > 0.0 && pdBaryDir2.m_data[(n6 + 1) % 3] < d3 && pdBaryDir2.m_data[(n6 + 2) % 3] < d3) {
                    pdBaryDir2.multScalar(-1.0);
                    n9 = PwBary.rotateAtVertex(this.m_geom, n4, n6, pdBaryDir2, pdBaryDir2, pdBary2, Math.PI);
                    if (n9 < 0) {
                        bl = true;
                        continue;
                    }
                    n4 = n9;
                    if (pgPolygon != null) {
                        PdBary.getVertex((PdVector)pdVector, (PdBary)pdBary2, (PdVector)this.m_geom.getVertex(piVectorArray[n4].m_data[0]), (PdVector)this.m_geom.getVertex(piVectorArray[n4].m_data[1]), (PdVector)this.m_geom.getVertex(piVectorArray[n4].m_data[2]));
                        pgPolygon.setVertex(n5, pdVector);
                    }
                    this.setVertex(n5, n4, pdBary2);
                } else {
                    n8 = 0;
                    n7 = -1;
                    n6 = -1;
                    n9 = 0;
                    do {
                        if (Math.abs(pdBary2.m_data[n9]) > d3) {
                            n6 = n9;
                            continue;
                        }
                        ++n8;
                        n7 = n9;
                    } while (++n9 < 3);
                }
            }
            if (n8 == 1 && pdBaryDir2.m_data[n7] < 0.0) {
                double d7;
                n9 = this.m_geom.getNeighbour((int)n4).m_data[n7];
                if (n9 < 0) {
                    bl = true;
                    continue;
                }
                int n10 = this.m_geom.getOppVertexLocInd(n4, n7);
                PdBaryDir pdBaryDir3 = new PdBaryDir(3);
                pdBaryDir3.m_data[(n7 + 2) % 3] = 1.0;
                pdBaryDir3.m_data[(n7 + 1) % 3] = -1.0;
                pdBaryDir3.m_data[n7] = 0.0;
                d6 = PwBary.norm(this.m_geom, n4, pdBaryDir3, false);
                if (Math.abs(d6) < d3) {
                    PsDebug.warning((String)"Edges degenerated in element set.");
                    bl = true;
                    continue;
                }
                double d8 = PwBary.scalar(this.m_geom, n4, pdBaryDir3, pdBaryDir2, false) / d6;
                double d9 = 1.0 - d8 * d8;
                if (Math.abs(d9) < d3) {
                    d9 = 0.0;
                }
                double d10 = Math.sqrt(d9);
                n4 = n9;
                pdBaryDir3.m_data[(n10 + 2) % 3] = -1.0;
                pdBaryDir3.m_data[(n10 + 1) % 3] = 1.0;
                pdBaryDir3.m_data[n10] = 0.0;
                d6 = PwBary.norm(this.m_geom, n4, pdBaryDir3, false);
                if (Math.abs(d6) < d3) {
                    PsDebug.warning((String)"Edges degenerated in element set.");
                    bl = true;
                    continue;
                }
                pdBaryDir3.multScalar(1.0 / d6);
                PdBaryDir pdBaryDir4 = new PdBaryDir(3);
                pdBaryDir4.m_data[(n10 + 2) % 3] = -0.5;
                pdBaryDir4.m_data[(n10 + 1) % 3] = -0.5;
                pdBaryDir4.m_data[n10] = 1.0;
                PdBaryDir pdBaryDir5 = new PdBaryDir(3);
                pdBaryDir5.copy(pdBaryDir3);
                pdBaryDir5.multScalar(-1.0 * PwBary.scalar(this.m_geom, n4, pdBaryDir4, pdBaryDir3, false));
                pdBaryDir5.m_data[0] = pdBaryDir5.m_data[0] + pdBaryDir4.m_data[0];
                pdBaryDir5.m_data[1] = pdBaryDir5.m_data[1] + pdBaryDir4.m_data[1];
                pdBaryDir5.m_data[2] = pdBaryDir5.m_data[2] + pdBaryDir4.m_data[2];
                double d11 = PwBary.norm(this.m_geom, n4, pdBaryDir5, false);
                if (Math.abs(d11) < d3) {
                    PsDebug.warning((String)"Edges degenerated in element set.");
                    bl = true;
                    continue;
                }
                pdBaryDir5.multScalar(1.0 / d11);
                int n11 = 0;
                do {
                    pdBaryDir2.m_data[n11] = pdBaryDir5.m_data[n11] * d10 + pdBaryDir3.m_data[n11] * d8;
                } while (++n11 < 3);
                double d12 = pdBary2.m_data[(n7 + 2) % 3];
                pdBary2.m_data[(n10 + 2) % 3] = d7 = pdBary2.m_data[(n7 + 1) % 3];
                pdBary2.m_data[(n10 + 1) % 3] = d12;
                pdBary2.m_data[n10] = 0.0;
                pdBary2.validate();
                this.setVertex(n5, n4, pdBary2);
            }
            double d13 = -1.0;
            int n12 = 0;
            while (n12 < pdBary2.m_data.length) {
                if (Math.abs(pdBaryDir2.m_data[n12]) > d3 && (d6 = -pdBary2.m_data[n12] / pdBaryDir2.m_data[n12]) > d3 && (d13 <= 0.0 || d6 < d13)) {
                    d13 = d6;
                }
                ++n12;
            }
            if (d13 < d3) {
                bl = true;
                PsDebug.warning((String)("Cannot calc. l = " + d13 + "."));
                PsDebug.warning((String)("dir: " + pdBaryDir2.toString()));
                PsDebug.warning((String)("bary: " + pdBary2.toString()));
                continue;
            }
            d13 = Math.min(d13, d5 - d2);
            d2 += d13;
            n12 = 0;
            while (n12 < pdBary2.m_data.length) {
                int n13 = n12;
                pdBary2.m_data[n13] = pdBary2.m_data[n13] + d13 * pdBaryDir2.m_data[n12];
                ++n12;
            }
            if (++n5 >= n3) {
                n3 += n2;
                if (pgPolygon != null) {
                    pgPolygon.setNumVertices(n3);
                }
                this.setNumVertices(n3);
            }
            if (pgPolygon != null) {
                PdBary.getVertex((PdVector)pdVector, (PdBary)pdBary2, (PdVector)this.m_geom.getVertex(piVectorArray[n4].m_data[0]), (PdVector)this.m_geom.getVertex(piVectorArray[n4].m_data[1]), (PdVector)this.m_geom.getVertex(piVectorArray[n4].m_data[2]));
                pgPolygon.setVertex(n5, pdVector);
            }
            this.setVertex(n5, n4, pdBary2);
        }
        if (pgPolygon != null) {
            pgPolygon.setNumVertices(n5 + 1);
        }
        this.setNumVertices(n5 + 1);
        return pdBaryDir2;
    }

    public void setAccuracy(double d) {
        this.m_eps = Math.abs(d);
    }

    protected void setMaxNumVertices(int n) {
        this.m_maxNum = n;
        this.m_elem.setSize(n);
        PdBary[] pdBaryArray = this.m_pos;
        this.m_pos = new PdBary[n];
        int n2 = 0;
        if (pdBaryArray != null) {
            n2 = 0;
            while (n2 < pdBaryArray.length && n2 < n) {
                this.m_pos[n2] = pdBaryArray[n2] == null ? new PdBary(3) : pdBaryArray[n2];
                ++n2;
            }
        }
        while (n2 < n) {
            this.m_pos[n2] = new PdBary(3);
            ++n2;
        }
    }

    public void setGeometry(PgElementSet pgElementSet) {
        this.m_geom = pgElementSet;
    }

    public PgElementSet getGeometry() {
        return this.m_geom;
    }

    public PgPolygon getPolygon() {
        if (this.m_geom == null) {
            PsDebug.warning((String)"Missing element set.");
            return null;
        }
        PgPolygon pgPolygon = new PgPolygon(this.m_geom.getDimOfVertices());
        this.getPolygon(pgPolygon);
        return pgPolygon;
    }

    public boolean getPolygon(PgPolygon pgPolygon) {
        if (this.m_geom == null) {
            PsDebug.warning((String)"Missing element set.");
            return false;
        }
        if (pgPolygon == null) {
            PsDebug.warning((String)"Missing polygon.");
            return false;
        }
        PdVector pdVector = new PdVector(this.m_geom.getDimOfVertices());
        int n = this.m_geom.getNumElements();
        PiVector[] piVectorArray = this.m_geom.getElements();
        pgPolygon.setNumVertices(this.m_size);
        int n2 = 0;
        while (n2 < this.m_size) {
            if (n <= this.m_elem.m_data[n2]) {
                PsDebug.warning((String)("Element index out of bounds: " + n2 + "."));
                pgPolygon.setNumVertices(n2);
                return false;
            }
            PdBary.getVertex((PdVector)pdVector, (PdBary)this.m_pos[n2], (PdVector)this.m_geom.getVertex(piVectorArray[this.m_elem.m_data[n2]].m_data[0]), (PdVector)this.m_geom.getVertex(piVectorArray[this.m_elem.m_data[n2]].m_data[1]), (PdVector)this.m_geom.getVertex(piVectorArray[this.m_elem.m_data[n2]].m_data[2]));
            pgPolygon.setVertex(n2, pdVector);
            ++n2;
        }
        return true;
    }

    public PdBary[] getBary() {
        return this.m_pos;
    }

    public PdBary getBary(int n) {
        if (n >= this.m_size || n < 0) {
            PsDebug.warning((String)("Array index out of bounds: " + n + "."));
            return null;
        }
        return this.m_pos[n];
    }

    public double eval(PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PiVector piVector, double d) {
        if (this.m_geom == null) {
            PsDebug.warning((String)"Missing geometry (forgot call of 'setGeometry(..)'?).");
            return 0.0;
        }
        if (this.m_size < 1) {
            pdVector.setSize(0);
            pdVector2.setSize(0);
            pdVector3.setSize(0);
            piVector.setSize(0);
            return 0.0;
        }
        int n = 50;
        int n2 = 50;
        PdVector[] pdVectorArray = new PdVector[]{pdVector, pdVector2, pdVector3};
        int n3 = 0;
        do {
            pdVectorArray[n3].setSize(n);
        } while (++n3 < 3);
        piVector.setSize(n);
        n3 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n4 = 0;
        PdBary[] pdBaryArray = new PdBary[]{new PdBary(3), new PdBary(3)};
        PdBaryDir pdBaryDir = new PdBaryDir(3);
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        int[] nArray3 = new int[2];
        PgVertexStar[] pgVertexStarArray = new PgVertexStar[2];
        PiVector[] piVectorArray = new PiVector[2];
        boolean bl = false;
        int n5 = 0;
        do {
            pdVectorArray[n5].m_data[0] = this.m_pos[0].m_data[n5];
        } while (++n5 < 3);
        piVector.m_data[0] = this.m_elem.m_data[0];
        n5 = 1;
        while (!bl) {
            int n6;
            int n7;
            d5 = d4;
            d4 += d;
            while (d2 + d3 <= d4) {
                if (n3 + 1 >= this.m_size) break;
                d2 += d3;
                if (this.m_elem.m_data[n3] != this.m_elem.m_data[n3 + 1]) {
                    n7 = 0;
                    do {
                        nArray[n7] = -1;
                        nArray2[n7] = -1;
                        nArray3[n7] = 0;
                        int n8 = 0;
                        do {
                            if (Math.abs(this.m_pos[n3 + n7].m_data[n8]) > 1.0E-10) {
                                nArray[n7] = n8;
                                continue;
                            }
                            int n9 = n7;
                            nArray3[n9] = nArray3[n9] + 1;
                            nArray2[n7] = n8;
                        } while (++n8 < 3);
                    } while (++n7 < 2);
                    if (nArray3[0] < 1 && nArray3[1] < 1) {
                        PsDebug.warning((String)"Cannot do it in barycoords.");
                        return 0.0;
                    }
                    pgVertexStarArray[1] = null;
                    pgVertexStarArray[0] = null;
                    piVectorArray[0] = new PiVector();
                    piVectorArray[1] = new PiVector();
                    n7 = 0;
                    do {
                        if (nArray3[n7] == 2) {
                            pgVertexStarArray[n7] = new PgVertexStar();
                            pgVertexStarArray[n7].makeVertexStar(this.m_geom, this.m_geom.getElement((int)this.m_elem.m_data[n3 + n7]).m_data[nArray[n7]], this.m_elem.m_data[n3 + n7]);
                            piVectorArray[n7] = pgVertexStarArray[n7].getElement();
                            continue;
                        }
                        if (nArray3[n7] == 1) {
                            piVectorArray[n7].setSize(2);
                            piVectorArray[n7].m_data[0] = this.m_elem.m_data[n3 + n7];
                            piVectorArray[n7].m_data[1] = this.m_geom.getNeighbour((int)this.m_elem.m_data[n3 + n7]).m_data[nArray2[n7]];
                            continue;
                        }
                        piVectorArray[n7].setSize(1);
                        piVectorArray[n7].m_data[0] = this.m_elem.m_data[n3 + n7];
                    } while (++n7 < 2);
                    n7 = -1;
                    int[] nArray4 = new int[2];
                    nArray4[0] = 0;
                    while (nArray4[0] < piVectorArray[0].getSize()) {
                        nArray4[1] = 0;
                        while (nArray4[1] < piVectorArray[1].getSize()) {
                            if (piVectorArray[0].m_data[nArray4[0]] == piVectorArray[1].m_data[nArray4[1]]) {
                                n7 = piVectorArray[0].m_data[nArray4[0]];
                                break;
                            }
                            nArray4[1] = nArray4[1] + 1;
                        }
                        if (n7 != -1) break;
                        nArray4[0] = nArray4[0] + 1;
                    }
                    if (n7 == -1) {
                        PsDebug.warning((String)"Cannot do it in barycoords.");
                        return 0.0;
                    }
                    n6 = 0;
                    do {
                        int n10;
                        if (pgVertexStarArray[n6] != null) {
                            n10 = pgVertexStarArray[n6].getVertexLocInd().m_data[nArray4[n6]];
                            pdBaryArray[n6].m_data[n10] = 1.0;
                            pdBaryArray[n6].m_data[(n10 + 1) % 3] = 0.0;
                            pdBaryArray[n6].m_data[(n10 + 2) % 3] = 0.0;
                            continue;
                        }
                        if (nArray3[n6] == 1 && this.m_elem.m_data[n3 + n6] != n7) {
                            double d6;
                            n10 = this.m_geom.getOppVertexLocInd(this.m_elem.m_data[n3 + n6], nArray2[n6]);
                            pdBaryArray[n6].m_data[n10] = 0.0;
                            int n11 = (n10 + 1) % 3;
                            int n12 = (n10 + 2) % 3;
                            int n13 = (nArray2[n6] + 1) % 3;
                            int n14 = (nArray2[n6] + 2) % 3;
                            pdBaryArray[n6].m_data[n11] = d6 = this.m_pos[n3 + n6].m_data[n14];
                            pdBaryArray[n6].m_data[n12] = d6 = this.m_pos[n3 + n6].m_data[n13];
                            continue;
                        }
                        pdBaryArray[n6].copy(this.m_pos[n3 + n6]);
                    } while (++n6 < 2);
                    n4 = n7;
                } else {
                    pdBaryArray[0].copy(this.m_pos[n3]);
                    pdBaryArray[1].copy(this.m_pos[n3 + 1]);
                    n4 = this.m_elem.m_data[n3];
                }
                n7 = 0;
                do {
                    pdBaryDir.m_data[n7] = pdBaryArray[1].m_data[n7] - pdBaryArray[0].m_data[n7];
                } while (++n7 < 3);
                d3 = PwBary.norm(this.m_geom, n4, pdBaryDir, n5 == 0);
                ++n3;
            }
            if (d2 + d3 <= d4) {
                d3 = 0.0;
                d4 = d2 += d3;
                n7 = 0;
                do {
                    pdVectorArray[n7].m_data[n5] = pdBaryArray[1].m_data[n7];
                } while (++n7 < 3);
                piVector.m_data[n5] = n4;
                bl = true;
            } else {
                double d7 = (d4 - d2) / d3;
                n6 = 0;
                do {
                    pdVectorArray[n6].m_data[n5] = d7 * pdBaryDir.m_data[n6] + pdBaryArray[0].m_data[n6];
                } while (++n6 < 3);
                piVector.m_data[n5] = n4;
            }
            if (++n5 < n) continue;
            n += n2;
            int n15 = 0;
            do {
                pdVectorArray[n15].setSize(n);
            } while (++n15 < 3);
            piVector.setSize(n);
        }
        int n16 = 0;
        do {
            pdVectorArray[n16].setSize(n5);
        } while (++n16 < 3);
        piVector.setSize(n5);
        return d2 - d5;
    }

    public double getLength() {
        return this.getPolygon().getLength();
    }
}

