/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Component;
import java.util.Enumeration;
import jv.anim.PsAnimation;
import jv.anim.PsAnimation_IP;
import jv.anim.PsTimeEvent;
import jv.anim.PsTimeListenerIf;
import jv.geom.PgElementSet;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.viewer.PvDisplay;
import jvx.geom.PnExplode_Dialog;
import jvx.geom.PwModel;

public class PnExplodeElementSet
implements PsTimeListenerIf {
    public PsAnimation m_anim;
    protected PgElementSet m_geom;
    private PgElementSet m_geomCopy;
    private PdVector[] m_elNormal;
    private PdVector[] m_elCenter;
    private PdVector[] m_direction1;
    private PdVector[] m_direction2;
    private PdVector[] m_rotationAxis;
    private PdVector[] m_relCoord;
    private PdVector m_initialSpeed;
    private PdVector m_rotation;
    private double m_speed;
    private double m_gravity;
    private double m_rotationSpeed;
    private PdVector m_gravityDirection;
    protected PsUpdateIf m_endListener;
    private boolean m_bRunOnce = true;

    public void runOnce(boolean bl) {
        this.m_bRunOnce = bl;
    }

    public static void getDialog(PgElementSet pgElementSet) {
        PnExplodeElementSet pnExplodeElementSet = new PnExplodeElementSet(pgElementSet);
        PnExplode_Dialog pnExplode_Dialog = new PnExplode_Dialog(pnExplodeElementSet.getName());
        pnExplode_Dialog.setAnimPanel((PsAnimation_IP)pnExplodeElementSet.getAnimation().getInfoPanel());
        pnExplode_Dialog.init();
        pnExplode_Dialog.explodePolytope(false);
        ((Component)((Object)pnExplode_Dialog)).setVisible(true);
        pnExplode_Dialog.setExpElSet(pnExplodeElementSet);
        double d = pgElementSet.getDiameter();
        pnExplodeElementSet.setGravity(0.00981);
        Enumeration enumeration = pgElementSet.getDisplays();
        PvDisplay pvDisplay = (PvDisplay)enumeration.nextElement();
        PdMatrix pdMatrix = new PdMatrix(4);
        pdMatrix = pvDisplay.getTransMatrix(128);
        PdVector pdVector = new PdVector(0.0, -1.0, 0.0, 0.0);
        pdVector.leftMultMatrix(pdMatrix);
        PdVector pdVector2 = new PdVector(pdVector.m_data[0], pdVector.m_data[1], pdVector.m_data[2]);
        pdVector2.normalize();
        pdVector2.multScalar(d);
        pnExplodeElementSet.setGravityDirection(pdVector2);
        pnExplodeElementSet.setRotationSpeed(0.5);
        pnExplodeElementSet.setSpeed(0.2 * d);
        pnExplodeElementSet.runOnce(false);
        pnExplodeElementSet.init();
    }

    public void setGravity(double d) {
        this.m_gravity = d;
    }

    public void reset() {
        this.m_geom.copy((PgGeometry)this.m_geomCopy);
    }

    public PnExplodeElementSet(PgElementSet pgElementSet) {
        this.m_geom = pgElementSet;
        this.m_geomCopy = new PgElementSet();
        this.m_geomCopy.copy((PgGeometry)this.m_geom);
        PwModel.shrink(this.m_geom, 1.0);
        this.m_anim = new PsAnimation();
        this.m_anim.setName("Explode");
        this.m_anim.addTimeListener((PsTimeListenerIf)this);
        this.m_anim.setTimeInterval(0.0, 50.0, 1.0, 5.0);
    }

    public boolean setTime(PsTimeEvent psTimeEvent) {
        double d = psTimeEvent.getTime();
        PdVector pdVector = new PdVector(3);
        PdVector pdVector2 = new PdVector(3);
        int n = this.m_geom.getNumElements();
        int n2 = 0;
        while (n2 < n) {
            pdVector2.blendBase(this.m_elCenter[n2], d * this.m_initialSpeed.m_data[n2], this.m_geom.getElementNormal(n2));
            pdVector2.blendBase(pdVector2, d * d * this.m_gravity, this.m_gravityDirection);
            PiVector piVector = this.m_geom.getElement(n2);
            int n3 = piVector.getSize();
            double d2 = this.m_rotation.m_data[n2] * d;
            double d3 = Math.cos(d2);
            double d4 = Math.sin(d2);
            int n4 = 0;
            while (n4 < n3) {
                int n5 = piVector.m_data[n4];
                pdVector.blendBase(pdVector2, this.m_relCoord[n5].m_data[0], this.m_rotationAxis[n2]);
                pdVector.blendBase(pdVector, d3 * this.m_relCoord[n5].m_data[1] - d4 * this.m_relCoord[n5].m_data[2], this.m_direction1[n2]);
                pdVector.blendBase(pdVector, d4 * this.m_relCoord[n5].m_data[1] + d3 * this.m_relCoord[n5].m_data[2], this.m_direction2[n2]);
                this.m_geom.setVertex(n5, pdVector);
                ++n4;
            }
            ++n2;
        }
        if (this.m_bRunOnce && d >= this.m_anim.getMaxTime() - this.m_anim.getTimePageIncr()) {
            this.m_anim.stop();
            return this.m_endListener.update((Object)this);
        }
        return this.m_geom.update((Object)this.m_geom);
    }

    public PsAnimation getAnimation() {
        return this.m_anim;
    }

    public void setAnimation(PsAnimation psAnimation) {
        this.m_anim = psAnimation;
    }

    public void startAnimation() {
        this.init();
        this.m_anim.setRepeat(0);
        this.m_anim.start(0);
    }

    public String getName() {
        return "Explode ElementSet";
    }

    public boolean hasAnimation() {
        return true;
    }

    public void setEndListener(PsUpdateIf psUpdateIf) {
        this.m_endListener = psUpdateIf;
    }

    public void init() {
        this.m_geom.makeElementNormals();
        this.m_elNormal = this.m_geom.getElementNormals();
        this.m_elCenter = new PdVector[this.m_geom.getNumElements()];
        this.m_initialSpeed = new PdVector(this.m_geom.getNumElements());
        this.m_rotation = new PdVector(this.m_geom.getNumElements());
        this.m_rotationAxis = new PdVector[this.m_geom.getNumElements()];
        this.m_direction1 = new PdVector[this.m_geom.getNumElements()];
        this.m_direction2 = new PdVector[this.m_geom.getNumElements()];
        this.m_relCoord = new PdVector[this.m_geom.getNumVertices()];
        PdVector pdVector = new PdVector(3);
        int n = 0;
        while (n < this.m_geom.getNumElements()) {
            this.m_initialSpeed.m_data[n] = Math.random() * this.m_speed;
            this.m_rotation.m_data[n] = Math.random() * this.m_rotationSpeed;
            this.m_elCenter[n] = new PdVector(3);
            this.m_elCenter[n].setConstant(0.0);
            PiVector piVector = this.m_geom.getElement(n);
            int n2 = 0;
            while (n2 < piVector.getSize()) {
                this.m_elCenter[n].add(this.m_geom.getVertex(piVector.m_data[n2]));
                ++n2;
            }
            this.m_elCenter[n].multScalar(1.0 / (double)piVector.getSize());
            this.m_rotationAxis[n] = new PdVector(3);
            this.m_rotationAxis[n].setConstant(0.0);
            while (this.m_rotationAxis[n].length() < 0.01) {
                this.m_rotationAxis[n].m_data[0] = Math.random();
                this.m_rotationAxis[n].m_data[1] = Math.random();
                this.m_rotationAxis[n].m_data[2] = Math.random();
            }
            this.m_rotationAxis[n].normalize();
            PdVector pdVector2 = new PdVector(0.0, 0.0, 1.0);
            if (PdVector.sqrDist((PdVector)pdVector2, (PdVector)this.m_rotationAxis[n]) < 0.01) {
                pdVector2 = new PdVector(0.0, 1.0, 0.0);
            }
            this.m_direction1[n] = PdVector.crossNew((PdVector)pdVector2, (PdVector)this.m_rotationAxis[n]);
            this.m_direction1[n].normalize();
            this.m_direction2[n] = PdVector.crossNew((PdVector)this.m_rotationAxis[n], (PdVector)this.m_direction1[n]);
            this.m_direction2[n].normalize();
            int n3 = 0;
            while (n3 < piVector.getSize()) {
                int n4 = piVector.m_data[n3];
                pdVector = PdVector.subNew((PdVector)this.m_geom.getVertex(n4), (PdVector)this.m_elCenter[n]);
                this.m_relCoord[n4] = new PdVector(3);
                this.m_relCoord[n4].m_data[0] = PdVector.dot((PdVector)pdVector, (PdVector)this.m_rotationAxis[n]);
                this.m_relCoord[n4].m_data[1] = PdVector.dot((PdVector)pdVector, (PdVector)this.m_direction1[n]);
                this.m_relCoord[n4].m_data[2] = PdVector.dot((PdVector)pdVector, (PdVector)this.m_direction2[n]);
                ++n3;
            }
            ++n;
        }
    }

    public void setSpeed(double d) {
        this.m_speed = d;
    }

    public void setRotationSpeed(double d) {
        this.m_rotationSpeed = d;
    }

    public void setGravityDirection(PdVector pdVector) {
        this.m_gravityDirection = pdVector;
    }
}

