/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.viewer.PvViewer;
import jvx.geom.PwHodge_IP;
import jvx.numeric.PnEnergyMinimizer;
import jvx.numeric.PnHodgeU;
import jvx.numeric.PnHodgeW;
import jvx.surface.PgGraph;

public class PwHodge
extends PsObject
implements WindowListener {
    private static final int NUM_LOOPS = 1;
    protected int m_dimOfDomain = -1;
    protected PgElementSet m_domain = null;
    protected PgElementSet[] m_texDomain = null;
    protected PgVectorField m_vf = null;
    protected PnEnergyMinimizer m_diriU;
    protected PgElementSet m_u = new PgElementSet(1);
    protected PgGraph m_uGraph;
    protected PgVectorField m_gradU;
    protected PnEnergyMinimizer m_diriW;
    protected PgElementSet m_w;
    protected PgGraph m_wGraph;
    protected PgVectorField m_coGradW;
    protected PgVectorField m_v;
    protected PuInteger m_selectedVF;
    protected int m_numVF = 0;
    protected boolean m_zeroBoundsU = true;
    protected boolean m_zeroBoundsW = false;
    protected PnHodgeU m_hodgeUEnergy;
    protected PnHodgeW m_hodgeWEnergy;
    protected boolean m_autoUpdate = true;
    private boolean m_uComputed = false;
    private boolean m_wComputed = false;
    private boolean m_lock = false;
    private boolean m_minimizing = false;
    private boolean m_firstTime = true;
    protected PvDisplayIf[] m_display;
    protected Frame[] m_frames;
    private static /* synthetic */ Class class$jvx$geom$PwHodge;

    public void stop() {
        PsPanel psPanel;
        this.m_diriU.stop();
        this.m_diriW.stop();
        this.m_minimizing = false;
        if (this.hasInspector("Info") && (psPanel = this.getInspector("Info")) instanceof PwHodge_IP) {
            ((PwHodge_IP)psPanel).setMinimizing(false);
        }
    }

    public PgElementSet getPotentialU() {
        return this.m_u;
    }

    public void setAutoUpdate(boolean bl) {
        this.m_autoUpdate = bl;
    }

    protected void computeGradient() {
        PdVector[][] pdVectorArray = ((PnHodgeU)this.m_diriU.getEnergy()).getGradFi();
        if (pdVectorArray == null) {
            return;
        }
        int n = this.m_domain.getNumElements();
        PiVector[] piVectorArray = this.m_domain.getElements();
        PdVector[] pdVectorArray2 = this.m_u.getVertices();
        this.m_gradU.setNumVectors(n);
        PdVector[] pdVectorArray3 = this.m_gradU.getVectors();
        try {
            int n2 = 0;
            while (n2 < n) {
                pdVectorArray3[n2].setConstant(0.0);
                int n3 = 0;
                do {
                    int n4 = piVectorArray[n2].m_data[n3];
                    int n5 = 0;
                    while (n5 < this.m_dimOfDomain) {
                        int n6 = n5;
                        pdVectorArray3[n2].m_data[n6] = pdVectorArray3[n2].m_data[n6] + pdVectorArray2[n4].m_data[0] * pdVectorArray[n2][n3].m_data[n5];
                        ++n5;
                    }
                } while (++n3 < 3);
                ++n2;
            }
            return;
        }
        catch (NullPointerException nullPointerException) {
            PsDebug.warning((String)("Calculation aborted " + nullPointerException.toString()));
            return;
        }
    }

    protected void computeJGradient() {
        PdVector[][] pdVectorArray = ((PnHodgeW)this.m_diriW.getEnergy()).getJGradFi();
        if (pdVectorArray == null) {
            return;
        }
        int n = this.m_domain.getNumElements();
        PiVector[] piVectorArray = this.m_domain.getElements();
        PdVector[] pdVectorArray2 = this.m_w.getVertices();
        this.m_coGradW.setNumVectors(n);
        PdVector[] pdVectorArray3 = this.m_coGradW.getVectors();
        try {
            int n2 = 0;
            while (n2 < n) {
                pdVectorArray3[n2].setConstant(0.0);
                int n3 = 0;
                do {
                    int n4 = piVectorArray[n2].m_data[n3];
                    int n5 = 0;
                    while (n5 < this.m_dimOfDomain) {
                        int n6 = n5;
                        pdVectorArray3[n2].m_data[n6] = pdVectorArray3[n2].m_data[n6] + pdVectorArray2[n4].m_data[0] * pdVectorArray[n2][n3].m_data[n5];
                        ++n5;
                    }
                } while (++n3 < 3);
                ++n2;
            }
            return;
        }
        catch (NullPointerException nullPointerException) {
            PsDebug.warning((String)("Calculation aborted " + nullPointerException.toString()));
            return;
        }
    }

    protected void computeHarmonic() {
        int n = this.m_domain.getNumElements();
        this.m_v.setNumVectors(n);
        PdVector[] pdVectorArray = this.m_v.getVectors();
        try {
            int n2 = 0;
            while (n2 < n) {
                pdVectorArray[n2].sub(this.m_vf.getVector(n2), this.m_gradU.getVector(n2));
                pdVectorArray[n2].sub(this.m_coGradW.getVector(n2));
                ++n2;
            }
            return;
        }
        catch (NullPointerException nullPointerException) {
            PsDebug.warning((String)("Calculation aborted " + nullPointerException.toString()));
            return;
        }
    }

    public void setZeroBoundsW(boolean bl) {
        this.m_zeroBoundsW = bl;
        this.m_hodgeWEnergy.setZeroGradientAtBounds(bl);
        int n = this.m_w.getNumVertices();
        int n2 = 0;
        while (n2 < n) {
            this.m_w.setVertex(n2, 0.0);
            ++n2;
        }
        this.m_diriW.setSurface(this.m_domain, this.m_w);
        this.m_diriW.setEnergy(this.m_hodgeWEnergy);
        if (this.m_autoUpdate) {
            this.minimize();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)((Frame)windowEvent.getSource())).setVisible(false);
    }

    private void completeDecomposition() {
        PsPanel psPanel;
        PsPanel psPanel2;
        this.computeHarmonic();
        this.m_minimizing = false;
        if (this.m_firstTime && this.hasInspector("Info") && (psPanel2 = this.getInspector("Info")) instanceof PwHodge_IP) {
            ((PwHodge_IP)psPanel2).setEnabledDisplays(true);
        }
        this.m_firstTime = false;
        int n = 0;
        do {
            this.m_texDomain[n].update(null);
        } while (++n < 3);
        this.m_uGraph.update(this.m_u);
        this.m_wGraph.update(this.m_w);
        if (this.hasInspector("Info") && (psPanel = this.getInspector("Info")) instanceof PwHodge_IP) {
            ((PwHodge_IP)psPanel).setMinimizing(false);
        }
        if (this.getFather() != null) {
            this.getFather().update((Object)this);
        }
    }

    private void allocateDisplays() {
        if (this.m_display[0] == null) {
            PvViewer pvViewer = (PvViewer)PsConfig.getViewer();
            this.m_display[0] = pvViewer.newDisplay("Grad-U", true);
            this.m_display[1] = pvViewer.newDisplay("CoGrad-W", true);
            this.m_display[2] = pvViewer.newDisplay("Harmonic Part", true);
            int n = 350;
            int n2 = 270;
            this.m_frames = new Frame[3];
            int n3 = 0;
            do {
                this.m_frames[n3] = this.m_display[n3].getFrame();
                ((Component)this.m_frames[n3]).setBounds(n3 % 3 * n + 10, n3 / 3 * n2 + 10, n, n2);
                ((Component)this.m_frames[n3]).setVisible(false);
            } while (++n3 < 3);
        }
    }

    public PgVectorField getRotationFree() {
        return this.m_gradU;
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public PgVectorField getDivergenceFree() {
        return this.m_coGradW;
    }

    public boolean update(Object object) {
        if (object == null) {
            super.update(null);
        } else {
            if (object == this.m_diriU) {
                if (this.m_diriU.isStopped()) {
                    this.computeGradient();
                    this.m_uComputed = true;
                    if (this.m_wComputed) {
                        this.completeDecomposition();
                    }
                }
                return true;
            }
            if (object == this.m_diriW) {
                if (this.m_diriW.isStopped()) {
                    this.computeJGradient();
                    this.m_wComputed = true;
                    if (this.m_uComputed) {
                        this.completeDecomposition();
                    }
                }
                return true;
            }
            if (object == this.m_domain) {
                int n = this.m_domain.getNumVectorFields();
                if (this.m_numVF != n) {
                    this.m_numVF = n;
                    int n2 = this.m_selectedVF.getValue();
                    this.m_selectedVF.setBounds(1, this.m_numVF, 1, 2);
                    if (this.m_numVF < 1) {
                        this.m_selectedVF.setValue(0);
                    }
                    this.m_selectedVF.update(null);
                    if (this.m_selectedVF.getValue() != n2) {
                        this.setVectorField(this.m_domain, this.m_selectedVF.getValue() - 1);
                    }
                }
                if (this.m_autoUpdate) {
                    this.minimize();
                }
                return super.update(null);
            }
            if (object == this.m_vf) {
                if (this.m_autoUpdate) {
                    this.minimize();
                }
                return super.update(null);
            }
            if (object == this.m_selectedVF) {
                this.setVectorField(this.m_domain, this.m_selectedVF.getValue() - 1);
                if (this.m_autoUpdate) {
                    this.minimize();
                }
                return super.update(null);
            }
        }
        return super.update(object);
    }

    public PgGraph getWGraph() {
        return this.m_wGraph;
    }

    public void setDisplaySize(int n, int n2, int n3) {
        this.allocateDisplays();
        Insets insets = this.m_frames[n].getInsets();
        this.m_frames[n].resize(n2 + insets.left + insets.right, n3 + insets.top + insets.bottom);
    }

    public void minimize() {
        PsPanel psPanel;
        if (this.m_domain == null || this.m_vf == null) {
            PsDebug.warning((String)"No domain or vector field.");
            return;
        }
        if (this.m_lock) {
            return;
        }
        if (this.m_minimizing) {
            return;
        }
        if (this.hasInspector("Info") && (psPanel = this.getInspector("Info")) instanceof PwHodge_IP) {
            ((PwHodge_IP)psPanel).setMinimizing(true);
        }
        this.m_minimizing = true;
        this.m_uComputed = false;
        this.m_wComputed = false;
        this.m_diriU.minimize();
        this.m_diriW.minimize();
    }

    public void close() {
        if (this.m_domain != null) {
            this.m_domain.removeUpdateListener((PsUpdateIf)this);
        }
        PvViewer pvViewer = (PvViewer)PsConfig.getViewer();
        int n = 0;
        do {
            if (this.m_display[n] == null || pvViewer == null) continue;
            pvViewer.removeDisplay(this.m_display[n]);
        } while (++n < 3);
    }

    public PvDisplayIf getDisplay(int n) {
        this.allocateDisplays();
        return this.m_display[n];
    }

    public void setVisibleGraph(int n, boolean bl) {
        if (n == 0) {
            this.m_uGraph.setVisible(bl);
            this.m_uGraph.update(null);
            return;
        }
        if (n == 1) {
            this.m_wGraph.setVisible(bl);
            this.m_wGraph.update(null);
            return;
        }
        throw new ArrayIndexOutOfBoundsException("index = " + n);
    }

    public boolean getVisibleGraph(int n) {
        if (n == 0) {
            return this.m_uGraph.isVisible();
        }
        if (n == 1) {
            return this.m_wGraph.isVisible();
        }
        throw new ArrayIndexOutOfBoundsException("index = " + n);
    }

    public PgElementSet getPotentialW() {
        return this.m_w;
    }

    public void setZeroBoundsU(boolean bl) {
        this.m_zeroBoundsU = bl;
        this.m_hodgeUEnergy.setZeroGradientAtBounds(bl);
        int n = this.m_u.getNumVertices();
        int n2 = 0;
        while (n2 < n) {
            this.m_u.setVertex(n2, 0.0);
            ++n2;
        }
        this.m_diriU.setSurface(this.m_domain, this.m_u);
        this.m_diriU.setEnergy(this.m_hodgeUEnergy);
        if (this.m_autoUpdate) {
            this.minimize();
        }
    }

    public PwHodge() {
        this.m_u.setName("u");
        this.m_diriU = new PnEnergyMinimizer();
        this.m_diriU.setName("u Minimizer");
        this.m_diriU.setParent((PsUpdateIf)this);
        this.m_w = new PgElementSet(1);
        this.m_w.setName("w");
        this.m_diriW = new PnEnergyMinimizer();
        this.m_diriW.setName("w Minimizer");
        this.m_diriW.setParent((PsUpdateIf)this);
        this.m_texDomain = new PgElementSet[3];
        this.m_display = new PvDisplayIf[3];
        this.m_selectedVF = new PuInteger("Vector Field", (PsUpdateIf)this);
        if (this.getClass() == (class$jvx$geom$PwHodge != null ? class$jvx$geom$PwHodge : (class$jvx$geom$PwHodge = PwHodge.class$("jvx.geom.PwHodge")))) {
            this.init();
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void setVisibleComponent(int n, boolean bl) {
        this.m_texDomain[n].setVisible(bl);
        this.m_texDomain[n].update(null);
    }

    public boolean getVisibleComponent(int n) {
        return this.m_texDomain[n].isVisible();
    }

    public void setVectorField(PgElementSet pgElementSet, int n) {
        PsPanel psPanel;
        if (pgElementSet == null) {
            PsDebug.warning((String)"Missing surface.");
            return;
        }
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"Domain is no triangulation.");
            return;
        }
        if (pgElementSet.getNumVectorFields() <= n || n < 0) {
            PsDebug.warning((String)("Wrong vector field, index=" + n + "."));
            return;
        }
        if (pgElementSet.getVectorField(n).getBasedOn() != 1) {
            PsDebug.warning((String)"Field parameter not element based.");
            return;
        }
        this.stop();
        this.m_lock = true;
        this.m_firstTime = true;
        if (this.hasInspector("Info") && (psPanel = this.getInspector("Info")) instanceof PwHodge_IP) {
            ((PwHodge_IP)psPanel).setEnabledDisplays(false);
        }
        this.allocateDisplays();
        int n2 = 0;
        do {
            this.m_display[n2].removeGeometry((PgGeometryIf)this.m_texDomain[n2]);
        } while (++n2 < 3);
        this.m_display[0].removeGeometry((PgGeometryIf)this.m_uGraph);
        this.m_display[1].removeGeometry((PgGeometryIf)this.m_wGraph);
        PdMatrix pdMatrix = new PdMatrix(4, 4);
        pdMatrix.setIdentity();
        pdMatrix.setEntry(2, 3, 4.0);
        this.m_dimOfDomain = pgElementSet.getDimOfVertices();
        this.m_domain = pgElementSet;
        this.m_domain.addUpdateListener((PsUpdateIf)this);
        this.m_vf = this.m_domain.getVectorField(n);
        this.m_vf.addUpdateListener((PsUpdateIf)this);
        this.m_numVF = this.m_domain.getNumVectorFields();
        this.m_selectedVF.setBounds(1, this.m_numVF, 1, 2);
        this.m_selectedVF.setValue(n + 1);
        this.m_hodgeUEnergy = new PnHodgeU();
        this.m_hodgeUEnergy.setVectorField(this.m_vf);
        this.m_hodgeUEnergy.setZeroGradientAtBounds(this.m_zeroBoundsU);
        this.m_u.setNumVertices(this.m_domain.getNumVertices());
        this.m_u.copyElementSet(this.m_domain);
        this.m_diriU.setSurface(this.m_domain, this.m_u);
        this.m_diriU.setEnergy(this.m_hodgeUEnergy);
        this.m_diriU.enableUpdateDomain(false);
        this.m_diriU.setNumLoops(1);
        this.m_gradU = new PgVectorField(this.m_dimOfDomain);
        this.m_gradU.setBasedOn(1);
        this.m_gradU.setName("Gradient u");
        this.m_gradU.setGeometry((PgPointSet)this.m_domain);
        this.m_uGraph = new PgGraph(this.m_dimOfDomain + 1);
        this.m_uGraph.setName("Graph of u");
        this.m_uGraph.setSurfaces(this.m_domain, this.m_u);
        this.m_uGraph.setModelMatrix(pdMatrix);
        this.m_uGraph.update(this.m_u);
        this.m_w.setNumVertices(this.m_domain.getNumVertices());
        this.m_w.copyElementSet(this.m_domain);
        this.m_hodgeWEnergy = new PnHodgeW();
        this.m_hodgeWEnergy.setVectorField(this.m_vf);
        this.m_hodgeWEnergy.setZeroGradientAtBounds(this.m_zeroBoundsW);
        this.m_diriW.setSurface(this.m_domain, this.m_w);
        this.m_diriW.setEnergy(this.m_hodgeWEnergy);
        this.m_diriW.enableUpdateDomain(false);
        this.m_diriW.setNumLoops(1);
        this.m_coGradW = new PgVectorField(this.m_dimOfDomain);
        this.m_coGradW.setBasedOn(1);
        this.m_coGradW.setName("CoGradient w");
        this.m_coGradW.setGeometry((PgPointSet)this.m_domain);
        this.m_wGraph = new PgGraph(this.m_dimOfDomain + 1);
        this.m_wGraph.setName("Graph of w");
        this.m_wGraph.setSurfaces(this.m_domain, this.m_w);
        this.m_wGraph.setModelMatrix(pdMatrix);
        this.m_wGraph.update(this.m_w);
        this.m_v = new PgVectorField(this.m_dimOfDomain);
        this.m_v.setBasedOn(1);
        this.m_v.setName("Harmonic v");
        this.m_v.setGeometry((PgPointSet)this.m_domain);
        int n3 = 0;
        do {
            this.m_texDomain[n3] = new PgElementSet(this.m_dimOfDomain);
            this.m_texDomain[n3].setName("Domain No " + n3);
            this.m_texDomain[n3].copy((PgGeometry)this.m_domain);
            this.m_texDomain[n3].showElements(false);
            this.m_texDomain[n3].showEdges(false);
            this.m_texDomain[n3].showVectorArrow(true);
            this.m_texDomain[n3].setGlobalVectorColor(Color.black);
            switch (n3) {
                case 0: {
                    this.m_texDomain[0].addVectorField(this.m_gradU);
                    this.m_gradU.setGeometry((PgPointSet)this.m_texDomain[0]);
                    break;
                }
                case 1: {
                    this.m_texDomain[1].addVectorField(this.m_coGradW);
                    this.m_coGradW.setGeometry((PgPointSet)this.m_texDomain[1]);
                    break;
                }
                case 2: {
                    this.m_texDomain[2].addVectorField(this.m_v);
                    this.m_v.setGeometry((PgPointSet)this.m_texDomain[2]);
                }
            }
            this.m_display[n3].addGeometry((PgGeometryIf)this.m_texDomain[n3]);
            this.m_display[n3].fit();
        } while (++n3 < 3);
        this.m_display[0].addGeometry((PgGeometryIf)this.m_uGraph);
        this.m_display[1].addGeometry((PgGeometryIf)this.m_wGraph);
        this.m_display[0].fit();
        this.m_display[1].fit();
        this.m_uGraph.setVisible(false);
        this.m_wGraph.setVisible(false);
        n3 = 0;
        do {
            this.m_texDomain[n3].setVisible(false);
        } while (++n3 < 3);
        this.m_lock = false;
    }

    public void setZeroBounds(boolean bl) {
        this.m_zeroBoundsU = bl;
        this.m_zeroBoundsW = bl;
        this.m_hodgeUEnergy.setZeroGradientAtBounds(bl);
        this.m_hodgeWEnergy.setZeroGradientAtBounds(bl);
        int n = this.m_u.getNumVertices();
        int n2 = 0;
        while (n2 < n) {
            this.m_u.setVertex(n2, 0.0);
            ++n2;
        }
        this.m_diriU.setSurface(this.m_domain, this.m_u);
        this.m_diriU.setEnergy(this.m_hodgeUEnergy);
        n = this.m_w.getNumVertices();
        n2 = 0;
        while (n2 < n) {
            this.m_w.setVertex(n2, 0.0);
            ++n2;
        }
        this.m_diriW.setSurface(this.m_domain, this.m_w);
        this.m_diriW.setEnergy(this.m_hodgeWEnergy);
        if (this.m_autoUpdate) {
            this.minimize();
        }
    }

    public PgVectorField getHarmonic() {
        return this.m_v;
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void setDisplayVisibility(int n, boolean bl) {
        ((Component)this.m_frames[n]).setVisible(bl);
    }

    public boolean getDisplayVisibility(int n) {
        return this.m_frames[n].isVisible();
    }

    public PgGraph getUGraph() {
        return this.m_uGraph;
    }

    public void init() {
        this.setName("Hodge Decomposition");
        this.m_selectedVF.setDefBounds(1, this.m_numVF, 1, 2);
        this.m_selectedVF.setDefValue(this.m_numVF);
        this.m_selectedVF.init();
        super.init();
    }

    public void windowIconified(WindowEvent windowEvent) {
    }
}

